<?php
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');

	include "../../php/TParams.class.php";

	class FacilAPI extends TParams{
		protected $datapacket;
		protected $token;
		protected $dbSge;
		protected $dbComum;

		public function __construct($token){
			$this->datapacket = new TParams();
			$this->datapacket->debug(true);
			$this->datapacket->clear();
			$this->datapacket->setHost($this->datapacket->getHost('empresas'));

			$filtro = '{"cod":"600321","params":[
				{"name":"api_token","value":"'.$token.'","type":"string"}
			]}';

			$this->datapacket->add($filtro);
			$ret = $this->datapacket->open(true);
			$this->datapacket->clear();

			if($token != $ret[0]->{'api_token'}){
				exit("Invalid token.");
			}else{
				$this->token = $token;
				$code = base64_decode(substr($ret[0]->{'api_hash'},0,1).substr($ret[0]->{'api_hash'},2,strlen($ret[0]->{'api_hash'})));
				$filtro = '{"cod":"600011","params":[{"name":"emp_codigo","value":"'.$code.'","type":"string"}]}';
				$this->datapacket->setHost($this->datapacket->getHost("empresas"));
				$this->datapacket->add($filtro);
				$this->datapacket->open(true);
				$this->datapacket->clear();

				$this->dbSge = $this->datapacket->getDbSge();
				$this->dbComum = $this->datapacket->getDb();
			}

		}

		/*
		*	Lista os funcionários da empresa
		*/
		public function getStaff(){
			$this->datapacket->setHost($this->datapacket->getHost($this->dbComum));

			$filtro = '{"cod":"600322","params":[
				{"name":"database","value":"'.$this->dbComum.'","type":"other"}
			]}';

			$this->datapacket->add($filtro);
			$ret = $this->datapacket->open(true);
			
			$obj = array();
			for($i=0;$i<$this->datapacket->getRecordCount();$i++){
				$reg = new StdClass();
				$reg->{'codigo'}	= $ret[$i]->{'cad_codigo'};
				$reg->{'nome'}		= $ret[$i]->{'cad_nomeraz'};
				array_push($obj, $reg);
			}
			
			$this->datapacket->clear();
			return json_encode($obj);
		}
		
		/*
		*	Cadastra um documento no banco da empresa
		*/
		public function sendDoc($data){
print_r($data);
			$data = json_decode(base64_decode($data));
			
			if(gettype($data) != 'array'){
				exit('Invalid data on method "sendDoc".');
			}else{
				$this->datapacket->setHost($this->datapacket->getHost($this->dbSge));
				$dataCount = count($data);

				for($i=0;$i<$dataCount;$i++){
					
					if(!isset($data[$i]->{'carteira'}) || $data[$i]->{'carteira'} =='null'){
						$carteiraType = 'other';
						$carteira = "null";
					}else{
						$carteiraType = 'string';
						$carteira = $data[$i]->{'carteira'};
					}
					
					if(!isset($data[$i]->{'sacador'}) || $data[$i]->{'sacador'}=='null'){
						$sacadorType = 'other';
						$sacador = "null";
					}else{
						$sacadorType = 'string';
						$sacador = $data[$i]->{'sacador'};
					}
					
					if(!isset($data[$i]->{'dataPagamento'}) || $data[$i]->{'dataPagamento'}=='null'){
						$dataPagamentoType = 'other';
						$dataPagamento = "null";
					}else{
						$dataPagamentoType = 'string';
						$dataPagamento = $data[$i]->{'dataPagamento'};
					}
					
					if(!isset($data[$i]->{'planoConta'}) || $data[$i]->{'planoConta'}=='null'){
						$planoContaType = 'other';
						$planoConta = "null";
					}else{
						$planoContaType = 'string';
						$planoConta = $data[$i]->{'planoConta'};
					}
					
					if(!isset($data[$i]->{'centroCusto'}) || $data[$i]->{'centroCusto'}=='null'){
						$centroCustoType = 'other';
						$centroCusto = "null";
					}else{
						$centroCustoType = 'string';
						$centroCusto = $data[$i]->{'centroCusto'};
					}
					
					if(!isset($data[$i]->{'conta'}) || $data[$i]->{'conta'}=='null'){
						$contaType = 'other';
						$conta = "null";
					}else{
						$contaType = 'string';
						$conta = $data[$i]->{'conta'};
					}
					
					$filtro = '{"cod":"500623","params":[
						{"name":"doc_codigo","value":"'.$data[$i]->{'codigo'}.'","type":"string"},
						{"name":"doc_pagrec","value":"'.$data[$i]->{'pagarReceber'}.'","type":"integer"},
						{"name":"cad_codigo","value":"'.$data[$i]->{'cliente'}.'","type":"string"},
						{"name":"doc_tipo","value":"'.$data[$i]->{'tipo'}.'","type":"integer"},
						{"name":"doc_numero","value":"'.$data[$i]->{'numero'}.'","type":"string"},
						{"name":"doc_carteira","value":"'.$carteira.'","type":"'.$carteiraType.'"},
						{"name":"doc_obs","value":"'.$data[$i]->{'observacao'}.'","type":"string"},
						{"name":"doc_descr","value":"'.$data[$i]->{'descricao'}.'","type":"string"},
						{"name":"doc_sacador","value":"'.$sacador.'","type":"'.$sacadorType.'"},
						{"name":"doc_nparc","value":"'.$data[$i]->{'numeroParcela'}.'","type":"integer"},
						{"name":"doc_tparc","value":"'.$data[$i]->{'totalParcelas'}.'","type":"integer"},
						{"name":"doc_data","value":"'.$data[$i]->{'data'}.'","type":"string"},
						{"name":"doc_dtvcto","value":"'.$data[$i]->{'dataVencimento'}.'","type":"string"},
						{"name":"doc_dtpgto","value":"'.$dataPagamento.'","type":"'.$dataPagamentoType.'"},
						{"name":"doc_multa","value":"'.$data[$i]->{'multa'}.'","type":"float"},
						{"name":"doc_juros","value":"'.$data[$i]->{'juros'}.'","type":"float"},
						{"name":"doc_valor","value":"'.$data[$i]->{'valor'}.'","type":"float"},
						{"name":"doc_valorpg","value":"'.$data[$i]->{'valorPago'}.'","type":"float"},
						{"name":"doc_status","value":"'.$data[$i]->{'status'}.'","type":"integer"},
						{"name":"plc_codigo","value":"'.$planoConta.'","type":"'.$planoContaType.'"},
						{"name":"ccu_codigo","value":"'.$centroCusto.'","type":"'.$centroCustoType.'"},
						{"name":"ser_codigo","value":"'.$data[$i]->{'serie'}.'","type":"string"},
						{"name":"cta_codigo","value":"'.$conta.'","type":"'.$contaType.'"},
						{"name":"doc_protesto","value":"'.$data[$i]->{'protestar'}.'","type":"integer"},
						{"name":"doc_dias_envio","value":"'.$data[$i]->{'diasEnvioEmail'}.'","type":"integer"},
						{"name":"doc_dias_protesto","value":"'.$data[$i]->{'diasProtesto'}.'","type":"integer"}
					]}';
		
					$this->datapacket->add($filtro);
				}

				$ret = $this->datapacket->open(true);
				$this->datapacket->clear();
				
				return json_encode($ret);
			}
		}
	}
?>