<?php 

	if(!class_exists("TParams")) include_once dirname(__DIR__) . "/php/TParams.class.php";

	class AtualizaCep extends TParams{

		/*
			Metodo responsavel por verificar se existe o cep passado para 
			pesquisa na tabela de cep.
			$cep a ser buscado, $get variavel reponsavel por retornar booleano ou o obj 
		*/
		function getCep($cep, $get = false) {
			
			$filtro = '{"cod":"600250","params":[
				{"name":"cep","value":"' . $cep . '","type":"string"}
			]}';
			TParams::setHost(TParams::getHost("empresas"));
			TParams::add($filtro);
			$retorno = TParams::open();
			TParams::clear();

			if(!empty($retorno)){
				if($get) return $retorno;
				else return true;
			}
			return false;
		}

		/*
			Metodo responsavel pela insercao do novo endereco.
			$endereco recebe um objeto ou um array de objetos
			sendo esse obj ("cep_cep", "cep_logradouro", "cep_bairro", "cep_uf", "cep_municipio");
		*/
		function addCep($endereco) {
				
			if(!empty($endereco)){
			
				if(is_object($endereco)){

					$cep_cep = "";
					if(!empty($endereco->{'cep_cep'})) $cep_cep = $endereco->{'cep_cep'};
					$cep_logradouro = "";
					if(!empty($endereco->{'cep_logradouro'})) $cep_logradouro = mb_strtoupper($endereco->{'cep_logradouro'}, 'UTF-8');
					$cep_bairro = "";
					if(!empty($endereco->{'cep_bairro'})) $cep_bairro = mb_strtoupper($endereco->{'cep_bairro'}, 'UTF-8');
					$cep_uf = "";
					if(!empty($endereco->{'cep_uf'})) $cep_uf = $endereco->{'cep_uf'};
					$cep_municipio = "";
					if(!empty($endereco->{'cep_municipio'})) $cep_municipio = $endereco->{'cep_municipio'};

					$filtro = '{"cod":"600251","params":[
						{"name":"cep_cep","value":"'.$cep_cep.'","type":"string"},
						{"name":"cep_logradouro","value":"'.$cep_logradouro.'","type":"string"},
						{"name":"cep_bairro","value":"'.$cep_bairro.'","type":"string"},
						{"name":"cep_uf","value":"'.$cep_uf.'","type":"string"},
						{"name":"cep_municipio","value":"'.$cep_municipio.'","type":"string"}
					]}';
					TParams::add($filtro);

				} else if(is_array($endereco)) {

					foreach ($endereco as $end) {

						$cep_cep = "";
						if(!empty($end->{'cep_cep'})) $cep_cep = $end->{'cep_cep'};
						$cep_logradouro = "";
						if(!empty($end->{'cep_logradouro'})) $cep_logradouro = mb_strtoupper($end->{'cep_logradouro'}, 'UTF-8');
						$cep_bairro = "";
						if(!empty($end->{'cep_bairro'})) $cep_bairro = mb_strtoupper($end->{'cep_bairro'}, 'UTF-8');
						$cep_uf = "";
						if(!empty($end->{'cep_uf'})) $cep_uf = $end->{'cep_uf'};
						$cep_municipio = "";
						if(!empty($end->{'cep_municipio'})) $cep_municipio = $end->{'cep_municipio'};

						$filtro = '{"cod":"600251","params":[
							{"name":"cep_cep","value":"'.$cep_cep.'","type":"string"},
							{"name":"cep_logradouro","value":"'.$cep_logradouro.'","type":"string"},
							{"name":"cep_bairro","value":"'.$cep_bairro.'","type":"string"},
							{"name":"cep_uf","value":"'.$cep_uf.'","type":"string"},
							{"name":"cep_municipio","value":"'.$cep_municipio.'","type":"string"}
						]}';
						TParams::add($filtro);
					}
				} 
				TParams::setHost(TParams::getHost("empresas"));
				TParams::open();
				TParams::clear();
			}
		}
	}

 ?>