<?php 
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');

	if(isset($argv[1])){
		$argPath = $argv[1];
	}else{
		$argPath = 'julio';
	}
	
	$path = $argPath.'/FACIL/';
	include $path.'php/TParams.class.php';

	$project_id = '52'; //id projects no redmine (Fácil Desktop)
	$status_id 	= 29; //id issue_statuses no redmine (Aguardando Build)
	$appFile	= $path.'app/Application.js';
	$changelog	= $path.'changelog.html';
	
	$datapacket = new TParams();
	$datapacket->debug(true);
	$datapacket->setUtf8(true);

	/*	versão		*/
	$newFile='';

	$handleApp = fopen($appFile, "r");
	if($handleApp) {

		$contentApp = '';
		while(($line = fgets($handleApp)) !== false) {
			if(strstr($line,'version:')){
				$versionArray = explode('.',$line);
				$lastPos = str_pad($versionArray[2],4,'0',STR_PAD_RIGHT);
				$lastBuildDay = $versionArray[1].'.'.substr($lastPos,0,2);

				if(date('ym.d')==$lastBuildDay){
					$numBuild = substr($lastPos,2,2);
					$numBuild++;
				}else{
					$numBuild = '01';
				}

				$version = '1.'.date('ym.d').str_pad($numBuild,2,'0',STR_PAD_LEFT);
				$contentApp.=chr(9)."version: '".$version."',".chr(13).chr(10);
			}else{
				$contentApp.= $line;
			}
		}
		fclose($handleApp);

		unlink($appFile);
		$newappFile = fopen($appFile,'w+');
		fwrite($newappFile,$contentApp);
		fclose($newappFile);
	}else{
		exit('Erro ao ler o Application.js');
	}

	/*	----------	*/
	
	/*	changelog	*/
	$filtro = '{"cod":"501300","params":[
		{"name":"status_id","value":"'.$status_id.'","type":"integer"},
		{"name":"project_id","value":"'.$project_id.'","type":"other"}
	]}';

	$datapacket->changeEngine("bitnami_redmine.template");
	$datapacket->setHost($datapacket->getHostRedmine());
	$datapacket->add($filtro);
	$ret = $datapacket->open(true);
	$retCount = $datapacket->getRecordCount();
	$datapacket->clear();

	$handle = fopen($changelog, "r");
	$filtro = '';
	if($handle) {

		$content = '';
		$img="";
		
		$datapacket->setHost($datapacket->getHost("empresas"));
		$datapacket->changeEngine("empresas.template");
		
		while(($line = fgets($handle)) !== false) {
			if(strstr($line,'<body id="top">')){
				$content.=chr(9).'<body id="top">'.chr(13).chr(10).chr(9).chr(9).'<div>'.chr(13).chr(10).chr(9).chr(9).chr(9).date('d/m/Y')." - ".$version.chr(13).chr(10).chr(9).chr(9).chr(9).'<ul id="bulk-selection">'.chr(13).chr(10);

				for($i=0;$i<$retCount;$i++){
					
					if( $ret[$i]->{'arquivo'} && $ret[$i]->{'arquivo'}!="" ){
						if(!is_dir($datapacket->uploads.'changelog/')){
							mkdir($datapacket->uploads.'changelog/', 0777, true);
						}
						if(!is_dir($datapacket->uploads.'changelog/'.$ret[$i]->{'id'})){
							mkdir($datapacket->uploads.'changelog/'.$ret[$i]->{'id'}, 0777, true);
						}
						copy('http://redmine.uds.com.br/redmine/attachments/download/'.$ret[$i]->{'anexo'}.'/'.$ret[$i]->{'arquivo'}, $datapacket->uploads.'changelog/'.$ret[$i]->{'id'}.'/'.$ret[$i]->{'arquivo'});
						chmod($datapacket->uploads.'changelog/'.$ret[$i]->{'id'}.'/'.$ret[$i]->{'arquivo'}, 0777);
						
						$img.= '<br><br><img src="../uploads/changelog/'.$ret[$i]->{'id'}.'/'.$ret[$i]->{'arquivo'}.'" style="width:100%; border:1px solid #CCC"><br>';
					}
					if($ret[$i]->{'id'}!=$ret[$i+1]->{'id'}){
						$content.=chr(9).chr(9).chr(9).chr(9).'<li><a class="issue tracker-8 status-12 priority-4 priority-high2 overdue assigned-to-me" href="http://redmine.uds.com.br/issues/'.$ret[$i]->{'id'}.'">'.$ret[$i]->{'tracker'}.' #'.$ret[$i]->{'id'}.'</a>: '.$ret[$i]->{'subject'}.'</li>'.chr(13).chr(10);

						if($i==$retCount-1){
							$content.=chr(9).chr(9).chr(9).'</ul>'.chr(13).chr(10).chr(9).chr(9).'</div>'.chr(13).chr(10);
						}
						
						$tipo = ( strstr($ret[$i]->{'tracker'}, 'Defeito') || strstr($ret[$i]->{'tracker'}, 'Bug') ) ? 1 : 2;
						$mod = explode(']', $ret[$i]->{'subject'});
						$modulo = str_replace('[','', $mod[0]);
						$titulo = $mod[1];
						$filtro = '{"cod":"600200","params":[
							{"name":"fac_versao","value":"'.$version.'","type":"string"},
							{"name":"fac_modulo","value":"'.htmlentities($modulo).'","type":"string"},
							{"name":"fac_titulo","value":"'.'#'.$ret[$i]->{'id'}.' '.addslashes(htmlentities($titulo)).'","type":"string"},
							{"name":"fac_descricao","value":"'.base64_encode(utf8_decode($ret[$i]->{'description'}).$img).'","type":"string"},
							{"name":"fac_tipo","value":"'.$tipo.'","type":"integer"}
						]}';
						$datapacket->add($filtro);
						$img="";
					}
					
				}
			}else{
				$content.= $line;
			}
		}
		fclose($handle);

		unlink($changelog);
		$newChangelog = fopen($changelog,'w+');
		fwrite($newChangelog,$content);
		fclose($newChangelog);
		
		$filtro = '{"cod":"600008","params":[
			{"name":"cfg_versao","value":"'.$version.'","type":"string"},
			{"name":"cfg_servidor","value":"\'facil.uds.com.br\', \'dev.uds.com.br\'","type":"other"}
		]}';
		$datapacket->add($filtro);
		
		$datapacket->open();
		$datapacket->clear();

	}else{
		exit('Erro ao ler o changelog.');
	}
	/*	----------	*/
?>