<?php
	/*
		Criado por Fausto Marouvo
		18/07/2013
	*/
	date_default_timezone_set("America/Sao_Paulo");
	class CalculoJuros {
		private $valor;
		private $vencto;
		private $novoVencto;
		private $juros;
		private $multa;
		private $diasJuros;
		private $totalJuros;
		private $totalMulta;
		private $total;
		private $infJuros;
		
		public function __construct($params){
			$this->params 	  = json_decode($params);
			$this->valor  	  = $this->params->{'valor'};
			$this->vencto  	  = $this->params->{'vencto'};
			$this->novoVencto = $this->params->{'novoVencto'};
			$this->juros  	  = $this->params->{'juros'};
			$this->multa  	  = $this->params->{'multa'};
			$this->infJuros   = $this->params->{'juros'};
			
			$this->getJuros();
			$this->getInfJuros();
			$this->getMulta();
			$this->getTotal();
		}
		
		private function diffDate($d1, $d2, $type='', $sep='-'){
			/*
			if(date('N',strtotime($d1))==6){
				$d1= date('Y-m-d', strtotime($d1. ' + 2 days'));
			}elseif(date('N',strtotime($d1))==7){
				$d1= date('Y-m-d', strtotime($d1. ' + 1 days'));
			}
			*/

			$d1 = explode($sep, $d1);
			$d2 = explode($sep, $d2);
			switch ($type){
				//anos
				case 'a':
					$x = 31536000;
					break;
				//meses
				case 'm':
					$x = 2592000;
					break;
				//dias
				case 'd':
					$x = 86400;
					break;
				//horas
				case 'h':
					$x = 3600;
					break;
				//minutos
				case 'mi':
					$x = 60;
					break;
				//segundos
				default:
					$x = 1;
			}
			$dias = floor(((mktime(0,0,0,$d2[1],$d2[2],$d2[0])-mktime(0,0,0,$d1[1],$d1[2],$d1[0]))/$x));
			return abs($dias);
		}
		
		private function getJuros(){
			$this->diasJuros = $this->diffDate($this->vencto,$this->novoVencto,"d");
			// $this->diasJuros = $this->diasJuros+1; //contar com o dia do vencimento

			if($this->juros>0)
				$this->totalJuros = ((($this->valor * $this->juros) / 100) * $this->diasJuros);
			else
				$this->totalJuros = 0;
		}
		
		private function getInfJuros(){
			$this->infJuros =  (($this->valor * $this->infJuros) / 100);
		}
		
		private function getMulta(){
			if($this->multa>0)
				$this->totalMulta = sprintf("%5.2f",(($this->valor * $this->multa) / 100));
			else
				$this->totalMulta = 0;
		}
		
		private function getTotal(){
			$this->total = sprintf("%5.2f",$this->valor + $this->totalJuros + $this->totalMulta);
		}
		
		public function getData(){
			$data = '{"total":"'.$this->total.'","juros":"'.$this->totalJuros.'","multa":"'.$this->totalMulta.'","dias":"'.$this->diasJuros.'","infJuros":"'.$this->infJuros.'"}';
			return $data;
		}
	}
	
	// $a = new CalculoJuros('{"valor":"100","vencto":"2013-05-10","novoVencto":"2013-06-10","juros":"10","multa":"10"}');
	// echo $a->getData();
?>