<?php

class GERAR_HTML{
	private $texto;
	private $logo="logosantander.jpg";
    public $html;
	public $nossonumero;
	public $linhaDigitavel;
	
	/**
	 * Formata um numero em notacao de moeda, assim como a funcao money_formatyyyyyy do PHP
	 * @author Rubens Takiguti Ribeiro
	 * @see http://php.net/manual/en/function.money-format.php
	 * @param string $formato Formato aceito por money_format
	 * @param float $valor Valor monetario
	 * @return string Valor formatado
	*/
	private	function my_money_format($formato, $valor) {

		// Se a funcao money_format esta disponivel: usa-la
		if (function_exists('money_format')) {
			return money_format($formato, $valor);
		}

		// Se nenhuma localidade foi definida, formatar com number_format
		if (setlocale(LC_MONETARY, 0) == 'C') {
			return number_format($valor, 2);
		}

		// Obter dados da localidade
		$locale = localeconv();

		// Extraindo opcoes do formato
		$regex = '/^'.             // Inicio da Expressao
				 '%'.              // Caractere %
				 '(?:'.            // Inicio das Flags opcionais
				 '\=([\w\040])'.   // Flag =f
				 '|'.
				 '([\^])'.         // Flag ^
				 '|'.
				 '(\+|\()'.        // Flag + ou (
				 '|'.
				 '(!)'.            // Flag !
				 '|'.
				 '(-)'.            // Flag -
				 ')*'.             // Fim das flags opcionais
				 '(?:([\d]+)?)'.   // W  Largura de campos
				 '(?:#([\d]+))?'.  // #n Precisao esquerda
				 '(?:\.([\d]+))?'. // .p Precisao direita
				 '([in%])'.        // Caractere de conversao
				 '$/';             // Fim da Expressao

		if (!preg_match($regex, $formato, $matches)) {
			trigger_error('Formato invalido: '.$formato, E_USER_WARNING);
			return $valor;
		}

		// Recolhendo opcoes do formato
		$opcoes = array(
			'preenchimento'   => ($matches[1] !== '') ? $matches[1] : ' ',
			'nao_agrupar'     => ($matches[2] == '^'),
			'usar_sinal'      => ($matches[3] == '+'),
			'usar_parenteses' => ($matches[3] == '('),
			'ignorar_simbolo' => ($matches[4] == '!'),
			'alinhamento_esq' => ($matches[5] == '-'),
			'largura_campo'   => ($matches[6] !== '') ? (int)$matches[6] : 0,
			'precisao_esq'    => ($matches[7] !== '') ? (int)$matches[7] : false,
			'precisao_dir'    => ($matches[8] !== '') ? (int)$matches[8] : $locale['int_frac_digits'],
			'conversao'       => $matches[9]
		);

		// Sobrescrever $locale
		if ($opcoes['usar_sinal'] && $locale['n_sign_posn'] == 0) {
			$locale['n_sign_posn'] = 1;
		} elseif ($opcoes['usar_parenteses']) {
			$locale['n_sign_posn'] = 0;
		}
		if ($opcoes['precisao_dir']) {
			$locale['frac_digits'] = $opcoes['precisao_dir'];
		}
		if ($opcoes['nao_agrupar']) {
			$locale['mon_thousands_sep'] = '';
		}

		// Processar formatacao
		$tipo_sinal = $valor >= 0 ? 'p' : 'n';
		if ($opcoes['ignorar_simbolo']) {
			$simbolo = '';
		} else {
			$simbolo = $opcoes['conversao'] == 'n' ? $locale['currency_symbol']
												   : $locale['int_curr_symbol'];
		}
		$numero = number_format(abs($valor), $locale['frac_digits'], $locale['mon_decimal_point'], $locale['mon_thousands_sep']);

	/*
	//TODO: dar suporte a todas as flags
		list($inteiro, $fracao) = explode($locale['mon_decimal_point'], $numero);
		$tam_inteiro = strlen($inteiro);
		if ($opcoes['precisao_esq'] && $tam_inteiro < $opcoes['precisao_esq']) {
			$alinhamento = $opcoes['alinhamento_esq'] ? STR_PAD_RIGHT : STR_PAD_LEFT;
			$numero = str_pad($inteiro, $opcoes['precisao_esq'] - $tam_inteiro, $opcoes['preenchimento'], $alinhamento).
					  $locale['mon_decimal_point'].
					  $fracao;
		}
	*/

		$sinal = $valor >= 0 ? $locale['positive_sign'] : $locale['negative_sign'];
		$simbolo_antes = $locale[$tipo_sinal.'_cs_precedes'];

		// Espaco entre o simbolo e o numero
		$espaco1 = $locale[$tipo_sinal.'_sep_by_space'] == 1 ? ' ' : '';

		// Espaco entre o simbolo e o sinal
		$espaco2 = $locale[$tipo_sinal.'_sep_by_space'] == 2 ? ' ' : '';

		$formatado = '';
		switch ($locale[$tipo_sinal.'_sign_posn']) {
		case 0:
			if ($simbolo_antes) {
				$formatado = '('.$simbolo.$espaco1.$numero.')';
			} else {
				$formatado = '('.$numero.$espaco1.$simbolo.')';
			}
			break;
		case 1:
			if ($simbolo_antes) {
				$formatado = $sinal.$espaco2.$simbolo.$espaco1.$numero;
			} else {
				$formatado = $sinal.$numero.$espaco1.$simbolo;
			}
			break;
		case 2:
			if ($simbolo_antes) {
				$formatado = $simbolo.$espaco1.$numero.$sinal;
			} else {
				$formatado = $numero.$espaco1.$simbolo.$espaco2.$sinal;
			}
			break;
		case 3:
			if ($simbolo_antes) {
				$formatado = $sinal.$espaco2.$simbolo.$espaco1.$numero;
			} else {
				$formatado = $numero.$espaco1.$sinal.$espaco2.$simbolo;
			}
			break;
		case 4:
			if ($simbolo_antes) {
				$formatado = $simbolo.$espaco2.$sinal.$espaco1.$numero;
			} else {
				$formatado = $numero.$espaco1.$simbolo.$espaco2.$sinal;
			}
			break;
		}

		// Se a string nao tem o tamanho minimo
		if ($opcoes['largura_campo'] > 0 && strlen($formatado) < $opcoes['largura_campo']) {
			$alinhamento = $opcoes['alinhamento_esq'] ? STR_PAD_RIGHT : STR_PAD_LEFT;
			$formatado = str_pad($formatado, $opcoes['largura_campo'], $opcoes['preenchimento'], $alinhamento);
		}

		return $formatado;
	}
	
	/** FUNCAO NOVA**/
	
	private function dataJuliano($data){
		$dia = (int)substr($data,1,2);
		$mes = (int)substr($data,3,2);
		$ano = (int)substr($data,6,4);
		$dataf = strtotime("$ano/$mes/$dia");
		$datai = strtotime(($ano-1).'/12/31');
		$dias  = (int)(($dataf - $datai)/(60*60*24));
		return str_pad($dias,3,'0',STR_PAD_LEFT).substr($data,9,4);
	}
	
	private function digitoVerificador_nossonumero($numero) {
		$resto2 = $this->modulo_11($numero, 9, 1);
		 $digito = 11 - $resto2;
		 if ($digito == 10 || $digito == 11) {
			$dv = 0;
		 } else {
			$dv = $digito;
		 }
		 return $dv;
	}
	
	private function digitoVerificador_barra($numero) {
		$resto2 = $this->modulo_11($numero, 9, 1);
		 if ($resto2 == 0 || $resto2 == 1 || $resto2 == 10) {
			$dv = 1;
		 } else {
			$dv = 11 - $resto2;
		 }
		 return $dv;
	}
	
	/** FIM FUNCAO NOVA**/
	
    private function formata_numero($numero,$loop,$insert,$tipo = "geral") {
		if ($tipo == "geral") {
			$numero = str_replace(",","",$numero);
			while(strlen($numero)<$loop){
				$numero = $insert . $numero;
			}
		}
		if ($tipo == "valor") {
			$numero = str_replace(",","",$numero);
			while(strlen($numero)<$loop){
				$numero = $insert . $numero;
			}
		}
		if ($tipo == "convenio") {
			while(strlen($numero)<$loop){
				$numero = $numero . $insert;
			}
		}
		return $numero;
	}

    private function esquerda($entra,$comp){
    	return substr($entra,0,$comp);
    }

    private function direita($entra,$comp){
    	return substr($entra,strlen($entra)-$comp,$comp);
    }		
		
	function fbarcode($valor){
		$fino = 1.5 ;
		$largo = 3.5 ;
		$altura = 65 ;

		$barcodes[0] = "00110" ;
		$barcodes[1] = "10001" ;
		$barcodes[2] = "01001" ;
		$barcodes[3] = "11000" ;
		$barcodes[4] = "00101" ;
		$barcodes[5] = "10100" ;
		$barcodes[6] = "01100" ;
		$barcodes[7] = "00011" ;
		$barcodes[8] = "10010" ;
		$barcodes[9] = "01010" ;
		for($f1=9;$f1>=0;$f1--){ 
			for($f2=9;$f2>=0;$f2--){  
				$f = ($f1 * 10) + $f2 ;
				$texto = "" ;
				for($i=1;$i<6;$i++){ 
					$texto .=  substr($barcodes[$f1],($i-1),1) . substr($barcodes[$f2],($i-1),1);
				}
				$barcodes[$f] = $texto;
			}
		}
		//Desenho da barra
		//Guarda inicial
		$barcode='<img src="imagens/p.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		src="imagens/b.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		src="imagens/p.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		src="imagens/b.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		';
		$texto = $valor ;
		if((strlen($texto) % 2) <> 0){
			$texto = "0" . $texto;
		}

		// Draw dos dados
		while (strlen($texto) > 0) {
			$i = round($this->esquerda($texto,2));
			$texto = $this->direita($texto,strlen($texto)-2);
			$f = $barcodes[$i];
			for($i=1;$i<11;$i+=2){
				if (substr($f,($i-1),1) == "0") {
					$f1 = $fino ;
				}else{
					$f1 = $largo ;
				}
				$barcode.='
				src="imagens/p.png" width="'.$f1.'" height="'.$altura.'" border="0"><img 
				';
				if (substr($f,$i,1) == "0") {
					$f2 = $fino ;
				}else{
					$f2 = $largo ;
				}
				$barcode.='
				src="imagens/b.png" width="'.$f2.'" height="'.$altura.'" border="0"><img 
				';
			}
		}

		// Draw guarda final
		$barcode.='
		src="imagens/p.png" width="'.$largo.'" height="'.$altura.'" border="0"><img 
		src="imagens/b.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		src="imagens/p.png" width="1" height="'.$altura.'" border="0">';
		return $barcode;
	} //Fim da função

    private function fator_vencimento($data) {
    	$data = explode("/",$data);
    	$ano = $data[2];
    	$mes = $data[1];
    	$dia = $data[0];
        $retorno = abs(($this->_dateToDays("1997","10","07")) - ($this->_dateToDays($ano, $mes, $dia)));
		if($retorno>9999){
			$retorno = str_pad(($retorno - 9000), 4, "0", STR_PAD_LEFT);
		}
        return($retorno);
    }

    private function _dateToDays($year,$month,$day) {
        $century = substr($year, 0, 2);
        $year = substr($year, 2, 2);
        if ($month > 2) {
            $month -= 3;
        } else {
            $month += 9;
            if ($year) {
                $year--;
            } else {
                $year = 99;
                $century --;
            }
        }

        return ( floor((  146097 * $century)    /  4 ) +
                floor(( 1461 * $year)        /  4 ) +
                floor(( 153 * $month +  2) /  5 ) +
                    $day +  1721119);
    }

    private function modulo_10($num) { 
			$numtotal10 = 0;
			$fator = 2;

			// Separacao dos numeros
			for ($i = strlen($num); $i > 0; $i--) {
				// pega cada numero isoladamente
				$numeros[$i] = substr($num,$i-1,1);
				// Efetua multiplicacao do numero pelo (falor 10)
				// 2002-07-07 01:33:34 Macete para adequar ao Mod10 do Itaú
				$temp = $numeros[$i] * $fator; 
				$temp0=0;
				foreach (preg_split('//',$temp,-1,PREG_SPLIT_NO_EMPTY) as $k=>$v){ $temp0+=$v; }
				$parcial10[$i] = $temp0; //$numeros[$i] * $fator;
				// monta sequencia para soma dos digitos no (modulo 10)
				$numtotal10 += $parcial10[$i];
				if ($fator == 2) {
					$fator = 1;
				} else {
					$fator = 2; // intercala fator de multiplicacao (modulo 10)
				}
			}
			
			// várias linhas removidas, vide função original
			// Calculo do modulo 10
			$resto = $numtotal10 % 10;
			$digito = 10 - $resto;
			if ($resto == 0) {
				$digito = 0;
			}
			
			return $digito;
			
	}

	function modulo_11($num, $base=9, $r=0)  {                                   

		$soma = 0;
		$fator = 2;

		/* Separacao dos numeros */
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo falor
			$parcial[$i] = $numeros[$i] * $fator;
			// Soma dos digitos
			$soma += $parcial[$i];
			if ($fator == $base) {
				// restaura fator de multiplicacao para 2 
				$fator = 1;
			}
			$fator++;
		}

		/* Calculo do modulo 11 */
		if ($r == 0) {
			$soma *= 10;
			$digito = $soma % 11;
			if ($digito == 10) {
				$digito = 0;
			}
			return $digito;
		} elseif ($r == 1){
			$resto = $soma % 11;
			return $resto;
		}
	}
	
	function modulo_11_invertido($num){
	   $ftini = 2;
	   $fator = $ftfim = 9;
	   $soma = 0;
		
	   for ($i = strlen($num); $i > 0; $i--) 
	   {
		  $soma += substr($num,$i-1,1) * $fator;
		  if(--$fator < $ftini) 
			 $fator = $ftfim;
		}
		
		$digito = $soma % 11;
		
		if($digito > 9) 
		   $digito = 0;
		
		return $digito;
	}

    private function monta_linha_digitavel($codigo){
		// Posição 	Conteúdo
		// 1 a 3    Número do banco
		// 4        Código da Moeda - 9 para Real ou 8 - outras moedas
		// 5        Fixo "9'
		// 6 a 9    PSK - codigo cliente (4 primeiros digitos)
		// 10 a 12  Restante do PSK (3 digitos)
		// 13 a 19  7 primeiros digitos do Nosso Numero
		// 20 a 25  Restante do Nosso numero (8 digitos) - total 13 (incluindo digito verificador)
		// 26 a 26  IOS
		// 27 a 29  Tipo Modalidade Carteira
		// 30 a 30  Dígito verificador do código de barras
		// 31 a 34  Fator de vencimento (qtdade de dias desde 07/10/1997 até a data de vencimento)
		// 35 a 44  Valor do título
		
		// 1. Primeiro Grupo - composto pelo código do banco, código da moéda, Valor Fixo "9"
		// e 4 primeiros digitos do PSK (codigo do cliente) e DV (modulo10) deste campo
		$campo1 = substr($codigo,0,3) . substr($codigo,3,1) . substr($codigo,19,1) . substr($codigo,20,4);
		$campo1 = $campo1 . $this->modulo_10($campo1);
		$campo1 = substr($campo1, 0, 5).'.'.substr($campo1, 5);


		
		// 2. Segundo Grupo - composto pelas 3 últimas posiçoes do PSK e 7 primeiros dígitos do Nosso Número
		// e DV (modulo10) deste campo
		$campo2 = substr($codigo,24,10);
		$campo2 = $campo2 . $this->modulo_10($campo2);
		$campo2 = substr($campo2, 0, 5).'.'.substr($campo2, 5);


		// 3. Terceiro Grupo - Composto por : Restante do Nosso Numero (6 digitos), IOS, Modalidade da Carteira
		// e DV (modulo10) deste campo
		$campo3 = substr($codigo,34,10);
		$campo3 = $campo3 . $this->modulo_10($campo3);
		$campo3 = substr($campo3, 0, 5).'.'.substr($campo3, 5);



		// 4. Campo - digito verificador do codigo de barras
		$campo4 = substr($codigo, 4, 1);


		
		// 5. Campo composto pelo fator vencimento e valor nominal do documento, sem
		// indicacao de zeros a esquerda e sem edicao (sem ponto e virgula). Quando se
		// tratar de valor zerado, a representacao deve ser 0000000000 (dez zeros).
		$campo5 = substr($codigo, 5, 4) . substr($codigo, 9, 10);
		
		return "$campo1 $campo2 $campo3 $campo4 $campo5"; 
	}

    private function geraCodigoBanco($numero) {
        $parte1 = substr($numero, 0, 3);
        $parte2 = $this->modulo_11($parte1);
        return $parte1 . "-" . $parte2;
    }

    public function cpny($company,$dadosArray,$bancos){
		$company= json_decode($company);

		/*ADICIONADO CEZAR*/
		//$especieDoc = $bancos->{'emp_especieboleto'};
		$especieDoc = "DM";

         // DADOS DO BOLETO PARA O SEU CLIENTE
		$taxa_boleto   = $company->{'emp_taxa'};
		$valor_cobrado = $dadosArray[0];
		$valor_cobrado = str_replace(",", ".",$valor_cobrado);
        //<!-- corrigir bug do number_format
		setlocale(LC_MONETARY, 'pt_BR.UTF-8', 'Portuguese_Brazil.1252');
		$valor_boleto = $this->my_money_format('%n',floatval($valor_cobrado)+floatval($taxa_boleto));
		$valor_boleto = str_replace("R$ ","",$valor_boleto);
        //-->

        $dadosboleto["numero_documento"]   = $dadosArray[2];//alterado por doc_codigo antes era 1 doc_codigo
        $dadosboleto["data_vencimento"]    = $dadosArray[4];
        $dadosboleto["data_documento"]     = $dadosArray[3];
        $dadosboleto["data_processamento"] = date("d/m/Y");
        $dadosboleto["valor_boleto"]       = $valor_boleto;

        // DADOS DO SEU CLIENTE
		if($dadosArray[14]!=""){
			$length = strlen($dadosArray[14]);
			if($length==11){
				$cnpjCpf = ' - CPF: '.substr($dadosArray[14],0,3).'.'.substr($dadosArray[14],3,3).'.'.substr($dadosArray[14],6,3).'-'.substr($dadosArray[14],9,2);				
				$cnpjCpf2 = '<br>CPF: '.substr($dadosArray[14],0,3).'.'.substr($dadosArray[14],3,3).'.'.substr($dadosArray[14],6,3).'-'.substr($dadosArray[14],9,2);				
			}
			if($length==14){
				$cnpjCpf = ' - CNPJ: '.substr($dadosArray[14],0,2).'.'.substr($dadosArray[14],2,3).'.'.substr($dadosArray[14],5,3).'/'.substr($dadosArray[14],8,4).'-'.substr($dadosArray[14],12,2);
				$cnpjCpf2 = '<br>CNPJ: '.substr($dadosArray[14],0,2).'.'.substr($dadosArray[14],2,3).'.'.substr($dadosArray[14],5,3).'/'.substr($dadosArray[14],8,4).'-'.substr($dadosArray[14],12,2);
			}
		}
        $dadosboleto["sacado"]    = strtoupper($dadosArray[13].$cnpjCpf);
        $dadosboleto["sacado2"]   = $dadosArray[13].$cnpjCpf2;
        $dadosboleto["endereco1"] = $dadosArray[15];
        $dadosboleto["endereco2"] = $dadosArray[16];
		$dadosboleto["observacao"]= $dadosArray[17];

        // INFORMACOES PARA O CLIENTE
				
				
        if($dadosArray[6]=="atualizar"){
          $dadosboleto["instrucoes1"]="";
		}elseif($dadosArray[6]==""){
          $dadosboleto["instrucoes1"]=$company->{'emp_instr1'};
        }else{
          $dadosboleto["instrucoes1"]=$dadosArray[6];
        }
        
        if($dadosArray[7]==""){
          $dadosboleto["instrucoes2"]=$company->{'emp_instr2'};
        }else{
          $dadosboleto["instrucoes2"]=$dadosArray[7];
        }
        
        if($dadosArray[8]==""){
          $dadosboleto["instrucoes3"]=$company->{'emp_instr3'};
        }else{
          $dadosboleto["instrucoes3"]=$dadosArray[8];
        }
        
        if($dadosArray[9]==""){
          $dadosboleto["instrucoes4"]=$company->{'emp_instr4'};
        }else{
          $dadosboleto["instrucoes4"]=$dadosArray[9];
        }
        
        if($dadosArray[10]==""){
          $dadosboleto["instrucoes5"]=$company->{'emp_instr5'};
        }else{
          $dadosboleto["instrucoes5"]=$dadosArray[10];
        }
		
		$dadosboleto['sacador_nome']	= $dadosArray[18];
		$dadosboleto['sacador_cnpjcpf']	= $dadosArray[19];	
		
        // DADOS OPCIONAIS DE ACORDO COM O BANCO OU CLIENTE
        $dadosboleto["quantidade"]     = "";
        $dadosboleto["valor_unitario"] = "";
        $dadosboleto["aceite"]         = "N";
        $dadosboleto["especie"]        = "R$";
        
		/*CEZAR*/
		$dadosboleto["especie_doc"]    = $especieDoc;


        // ---------------------- DADOS FIXOS DE CONFIGURAÇÃO DO SEU BOLETO --------------- //


        // DADOS DA SUA CONTA - BANCO DO BRASIL
        $dadosboleto["agencia"] = $bancos->{'agencia'}; // Num da agencia, sem digito
        $dadosboleto["conta"]   = $bancos->{'conta'}; 	// Num da conta, sem digito

        // DADOS PERSONALIZADOS - BANCO DO BRASIL
        $dadosboleto["convenio"]          = $bancos->{'convenio'};  // Num do convênio - REGRA: 6 ou 7 ou 8 dígitos
        $dadosboleto["contrato"]          = $bancos->{'contrato'}; // Num do seu contrato
        $dadosboleto["carteira"]          = $bancos->{'carteira'};
        $dadosboleto["variacao_carteira"] = $bancos->{'variacaoCarteira'};  // Variação da Carteira, com traço (opcional)
							
        // TIPO DO BOLETO
        $dadosboleto["formatacao_convenio"]     = "7"; // REGRA: 8 p/ Convênio c/ 8 dígitos, 7 p/ Convênio c/ 7 dígitos, ou 6 se Convênio c/ 6 dígitos
        $dadosboleto["formatacao_nosso_numero"] = "2"; // REGRA: Usado apenas p/ Convênio c/ 6 dígitos: informe 1 se for NossoNúmero de até 5 dígitos ou 2 para opção de até 17 dígitos

        // SEUS DADOS
        $dadosboleto["identificacao"] = $company->{'emp_fantasia'};
        $dadosboleto["cpf_cnpj"]      = $company->{'emp_cpfcnpj'};
        $dadosboleto["endereco"]      = $company->{'emp_endereco'}.", ".$company->{'emp_num'}." - ".$company->{'emp_bairro'};
        $dadosboleto["cidade_uf"]     = "CEP:".$company->{'emp_cep'}." - ".$company->{'emp_cidade'}." - ".$company->{'emp_uf'};
        $dadosboleto["cedente"]       = $company->{'emp_razao'};

        // ------------------------- FUNCOES -------------------- //
		$codigobanco = $bancos->{'banco_numero'};
		if($codigobanco=="Santander"){
			$codigobanco="033";
		}
		
        $nummoeda    = "9";
		$fixo     = "9";   // Numero fixo para a posição 05-05
		$ios	  = "0";   // IOS - somente para Seguradoras (Se 7% informar 7, limitado 9%)
						   // Demais clientes usar 0 (zero)

        $codigo_banco_com_dv = $this->geraCodigoBanco($codigobanco);
        $fator_vencimento    = $this->fator_vencimento($dadosboleto["data_vencimento"]);
        $valor          = $this->formata_numero(str_replace(".","",$dadosboleto["valor_boleto"]),10,0,"valor");
        $agencia        = $this->formata_numero($dadosboleto["agencia"],4,0);
        $conta          = $this->formata_numero($dadosboleto["conta"],8,0);
        $carteira       = $dadosboleto["carteira"];
        // $agencia_codigo = $agencia."-".$this->modulo_11($agencia)." / ".$conta."-".$this->modulo_11($conta);
		$agencia_codigo = $agencia."-".$this->modulo_11($agencia)." / ".$dadosboleto["convenio"];
        $livre_zeros    = '000000';
		$codigocliente =$this->formata_numero($bancos->{'convenio'},7,0);
		$convenio		= $dadosboleto["convenio"];

		$filtro3 = '{"cod":"700701","params":[
			{"name":"nnu_banco","value":"'.$codigobanco.'","type":"string"},
			{"name":"nnu_carteira","value":"'.$bancos->{'carteira'}.'","type":"string"}
		]}';
		
		$dataPacket = new Datapacket();
		$TParams = new TParams();
		$dataPacket->setHost($TParams->getHost($company->{'emp_db_sge'}));
		$dataPacket->add($filtro3);	
		$nnumero = $dataPacket->open(true); /*pega o ultimo nosso numero cadastrado no banco relacionando numero do banco e carteira*/

		$registros=0;
		if(!$nnumero){	/* se não existir nosso número para o banco e a carteira selecionada será criado um novo a partir do nosso número inicial*/
			$this->nnum=$bancos->{'nnini'};
		}else{	/* se existir documentos com o número do banco e carteira selecionada, resgata o maior nosso número cadastrado */
			for($i=0;$i<count($nnumero);$i++){
				$len=strlen($nnumero[$i]->{'nnu_numero'});
				if(!isset($nnumMaior)) {
					$nnumMaior = $nnumero[$i]->{'nnu_numero'};
				}else{
					if($nnumMaior<$nnumero[$i]->{'nnu_numero'})
						$nnumMaior =$nnumero[$i]->{'nnu_numero'};
				}
				$this->nnum = $nnumMaior;
				if($dadosArray[1]==$nnumero[$i]->{'doc_codigo'}){
					$nnumAtual = $nnumero[$i]->{'nnu_numero'};
					$this->nnum = $nnumero[$i]->{'nnu_numero'};
					$registros++;
					break;
				}
			}

			if($bancos->{'nnini'} > $nnumMaior)
				$this->nnum=$bancos->{'nnini'}+count($nnumero);
		}

		if($registros==0){	/* se não existir o código do documento cadastrado, então ele cadastra um novo nosso número */
			$this->{'nnum'}=$this->{'nnum'}+1;
			$filtro4  = '{"cod":"700702","params":[
				{"name":"doc_codigo","value":"'.$dadosArray[1].'","type":"string"},
				{"name":"nnu_numero","value":"'.$this->{'nnum'}.'","type":"string"},
				{"name":"nnu_banco","value":"'.$codigobanco.'","type":"string"},
				{"name":"nnu_carteira","value":"'.$bancos->{'carteira'}.'","type":"string"}
			]}';

			$dataPacketNnu = new Datapacket();
			$dataPacketNnu->setHost($TParams->getHost($company->{'emp_db_sge'}));
			$dataPacketNnu->add($filtro4);
			$dataPacketNnu->open();
		}else{
			if($this->nnum < $nnumAtual)
				$this->nnum = $nnumAtual;
		}	
		
		//$this->nnum = str_pad($this->nnum,10,"0",STR_PAD_LEFT);
		$this->nnum = $this->formata_numero($this->nnum,7,0);
		//dv do nosso número
		$dv_nosso_numero = $this->modulo_11($this->nnum,9,0);
		// nosso número (com dvs) são 13 digitos
		$this->nnum = "00000".$this->nnum.$dv_nosso_numero;
		$nossonumero = $this->nnum;

		// 43 numeros para o calculo do digito verificador do codigo de barras
		$barra = "$codigobanco$nummoeda$fator_vencimento$valor$fixo$codigocliente$nossonumero$ios$carteira";

		//$barra = "$codigobanco$nummoeda$fixo$codigocliente$nossonumero$ios$carteira";
		$dv = $this->digitoVerificador_barra($barra);
		// Numero para o codigo de barras com 44 digitos
		$linha = substr($barra,0,4) . $dv . substr($barra,4);

		$dadosboleto["codigo_barras"]       = $linha;
		$dadosboleto["linha_digitavel"]     = $this->monta_linha_digitavel($linha);
		$dadosboleto["agencia_codigo"]      = $agencia_codigo;
		$dadosboleto["nosso_numero"]        = $this->nnum;
		$dadosboleto["codigo_banco_com_dv"] = $codigo_banco_com_dv;

		$this->nossonumero=$this->nnum;
		$this->linhaDigitavel=$dadosboleto["linha_digitavel"];
		
		//PARCELA (carnê)
		$dadosboleto["nparc"]       = $dadosArray[20];
		$dadosboleto["tparc"]       = $dadosArray[21];

		// ------------------------- LAYOUT -------------------- //

		if( !isset($_REQUEST["carne"]) ){
			include "class_boletoLayout.php";
		}else{
			include "class_boletoLayoutCarne.php";
		}
		
    }	
}

?>