<?php
class GERAR_HTML {
		
	private $texto;
	private $logo="logosicredi.jpg";
	public $html; 
	public $nossonumero; 
	public $linhaDigitavel;

	function digitoVerificador_nossonumero($numero) {
		$resto2 = $this->modulo_11($numero, 9, 1);
		// esta rotina sofrer algumas alteraes para ajustar no layout do SICREDI
		 $digito = 11 - $resto2;
		 if ($digito > 9 ) {
			$dv = 0;
		 } else {
			$dv = $digito;
		 }
	 return $dv;
	}

	function digitoVerificador_campolivre($numero) {
		 $resto2 = $this->modulo_11($numero, 9, 1);
	// esta rotina sofreu algumas alteraes para ajustar no layout do SICREDI
		if ($resto2 <=1){
			$dv = 0;
		}else{
			$dv = 11 - $resto2;
		}
		 return $dv;
	}


	function digitoVerificador_barra($numero) {
		$resto2 = $this->modulo_11($numero, 9, 1);
	// esta rotina sofrer algumas alteraes para ajustar no layout do SICREDI
		$digito = 11 - $resto2;
		 if ($digito <= 1 || $digito >= 10 ) {
			$dv = 1;
		 } else {
			$dv = $digito;
		 }
		 return $dv;
	}

	function formata_numero($numero,$loop,$insert,$tipo = "geral") {
		if ($tipo == "geral") {
			$numero = str_replace(",","",$numero);
			while(strlen($numero)<$loop){
				$numero = $insert . $numero;
			}
		}
		if ($tipo == "valor") {
			/*
			retira as virgulas
			formata o numero
			preenche com zeros
			*/
			$numero = str_replace(",","",$numero);
			while(strlen($numero)<$loop){
				$numero = $insert . $numero;
			}
		}
		if ($tipo == "convenio") {
			while(strlen($numero)<$loop){
				$numero = $numero . $insert;
			}
		}
		return $numero;
	}


	function fbarcode($valor){
		$fino = 1.5 ;
		$largo = 3.5 ;
		$altura = 65 ;

		$barcodes[0] = "00110" ;
		$barcodes[1] = "10001" ;
		$barcodes[2] = "01001" ;
		$barcodes[3] = "11000" ;
		$barcodes[4] = "00101" ;
		$barcodes[5] = "10100" ;
		$barcodes[6] = "01100" ;
		$barcodes[7] = "00011" ;
		$barcodes[8] = "10010" ;
		$barcodes[9] = "01010" ;
		for($f1=9;$f1>=0;$f1--){ 
			for($f2=9;$f2>=0;$f2--){  
				$f = ($f1 * 10) + $f2 ;
				$texto = "" ;
				for($i=1;$i<6;$i++){ 
					$texto .=  substr($barcodes[$f1],($i-1),1) . substr($barcodes[$f2],($i-1),1);
				}
				$barcodes[$f] = $texto;
			}
		}
		//Desenho da barra
		//Guarda inicial
		$barcode='<img src="imagens/p.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		src="imagens/b.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		src="imagens/p.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		src="imagens/b.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		';
		$texto = $valor ;
		if((strlen($texto) % 2) <> 0){
			$texto = "0" . $texto;
		}

		// Draw dos dados
		while (strlen($texto) > 0) {
			$i = round($this->esquerda($texto,2));
			$texto = $this->direita($texto,strlen($texto)-2);
			$f = $barcodes[$i];
			for($i=1;$i<11;$i+=2){
				if (substr($f,($i-1),1) == "0") {
					$f1 = $fino ;
				}else{
					$f1 = $largo ;
				}
				$barcode.='
				src="imagens/p.png" width="'.$f1.'" height="'.$altura.'" border="0"><img 
				';
				if (substr($f,$i,1) == "0") {
					$f2 = $fino ;
				}else{
					$f2 = $largo ;
				}
				$barcode.='
				src="imagens/b.png" width="'.$f2.'" height="'.$altura.'" border="0"><img 
				';
			}
		}

		// Draw guarda final
		$barcode.='
		src="imagens/p.png" width="'.$largo.'" height="'.$altura.'" border="0"><img 
		src="imagens/b.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		src="imagens/p.png" width="1" height="'.$altura.'" border="0">';
		return $barcode;
    }

	function esquerda($entra,$comp){
		return substr($entra,0,$comp);
	}

	function direita($entra,$comp){
		return substr($entra,strlen($entra)-$comp,$comp);
	}

	function fator_vencimento($data) {
		$data = explode("/",$data);
		$ano = $data[2];
		$mes = $data[1];
		$dia = $data[0];
		$retorno = abs(($this->_dateToDays("1997","10","07")) - ($this->_dateToDays($ano, $mes, $dia)));
		if($retorno>9999){
			$retorno = str_pad(($retorno - 9000), 4, "0", STR_PAD_LEFT);
		}
        return($retorno);
	}

	function _dateToDays($year,$month,$day) {
		$century = substr($year, 0, 2);
		$year = substr($year, 2, 2);
		if ($month > 2) {
			$month -= 3;
		} else {
			$month += 9;
			if ($year) {
				$year--;
			} else {
				$year = 99;
				$century --;
			}
		}
		return ( floor((  146097 * $century) /  4 ) + floor(( 1461 * $year) /  4 ) + floor(( 153 * $month +  2) /  5 ) + $day +  1721119);
	}

	function modulo_10($num) { 
		$numtotal10 = 0;
		$fator = 2;

		// Separacao dos numeros
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo (falor 10)
			$temp = $numeros[$i] * $fator; 
			$temp0=0;
			foreach (preg_split('//',$temp,-1,PREG_SPLIT_NO_EMPTY) as $k=>$v){ $temp0+=$v; }
			$parcial10[$i] = $temp0; //$numeros[$i] * $fator;
			// monta sequencia para soma dos digitos no (modulo 10)
			$numtotal10 += $parcial10[$i];
			if ($fator == 2) {
				$fator = 1;
			} else {
				$fator = 2; // intercala fator de multiplicacao (modulo 10)
			}
		}
		
		// vrias linhas removidas, vide funo original
		// Calculo do modulo 10
		$resto = $numtotal10 % 10;
		$digito = 10 - $resto;
		if ($resto == 0) {
			$digito = 0;
		}
		return $digito;	
	}

	function modulo_11($num, $base=9, $r=0)  {
		/**
		 *   Autor:
		 *           Pablo Costa <pablo@users.sourceforge.net>
		 *
		 *   Funo:
		 *    Calculo do Modulo 11 para geracao do digito verificador 
		 *    de boletos bancarios conforme documentos obtidos 
		 *    da Febraban - www.febraban.org.br 
		 *
		 *   Entrada:
		 *     $num: string numrica para a qual se deseja calcularo digito verificador;
		 *     $base: valor maximo de multiplicacao [2-$base]
		 *     $r: quando especificado um devolve somente o resto
		 *
		 *   Sada:
		 *     Retorna o Digito verificador.
		 *
		 *   Observaes:
		 *     - Script desenvolvido sem nenhum reaproveitamento de cdigo pr existente.
		 *     - Assume-se que a verificao do formato das variveis de entrada  feita antes da execuo deste script.
		 */                                        

		$soma = 0;
		$fator = 2;

		/* Separacao dos numeros */
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo falor
			$parcial[$i] = $numeros[$i] * $fator;
			// Soma dos digitos
			$soma += $parcial[$i];
			if ($fator == $base) {
				// restaura fator de multiplicacao para 2 
				$fator = 1;
			}
			$fator++;
		}

		/* Calculo do modulo 11 */
		if ($r == 0) {
			$soma *= 10;
			$digito = $soma % 11;
			return $digito;
		} elseif ($r == 1){
			// esta rotina sofrer algumas alteraes para ajustar no layout do SICREDI
			$r_div = (int)($soma/11);
			$digito = ($soma - ($r_div * 11));
			return $digito;
		}
	}

	function monta_linha_digitavel($codigo) {
			
		// COMPOSICAO DO CODIGO		
		// Posio | Larg | Contedo
		// --------+------+---------------
			// 1 a 3   |  03  | Identcao do banco
			// 4       |  01  | Cdigo da Moeda - 9 para R$
			// 5       |  01  | Digito verificador geral do Cdigo de Barras
			// 6 a 9   |  04  | Fator de Vencimento
		// 10 a 19 |  10  | Valor (8 inteiros e 2 decimais)
			// 20 a 44 |  25  | Campo Livre definido por cada banco (25 caracteres)

		//COMPOSICAO DA LINHA DIGITAVEL
			
			// 1. Campo - composto pelo cdigo do banco, cdigo da moda, as cinco primeiras posies
			// do campo livre e DV (modulo10) deste campo
			$p1 = substr($codigo, 0, 4);
			$p2 = substr($codigo, 19, 5);
			$p3 = $this->modulo_10("$p1$p2");
			$p4 = "$p1$p2$p3";
			$p5 = substr($p4, 0, 5);
			$p6 = substr($p4, 5);
			$campo1 = "$p5.$p6";

			// 2. Campo - composto pelas posioes 6 a 15 do campo livre
			// e livre e DV (modulo10) deste campo
			$p1 = substr($codigo, 24, 10);
			$p2 = $this->modulo_10($p1);
			$p3 = "$p1$p2";
			$p4 = substr($p3, 0, 5);
			$p5 = substr($p3, 5);
			$campo2 = "$p4.$p5";

			// 3. Campo composto pelas posicoes 16 a 25 do campo livre
			// e livre e DV (modulo10) deste campo
			$p1 = substr($codigo, 34, 10);
			$p2 = $this->modulo_10($p1);
			$p3 = "$p1$p2";
			$p4 = substr($p3, 0, 5);
			$p5 = substr($p3, 5);
			$campo3 = "$p4.$p5";

			// 4. Campo - digito verificador do codigo de barras
			$campo4 = substr($codigo, 4, 1);

			// 5. Campo composto pelo fator vencimento e valor nominal do documento, sem
			// indicacao de zeros a esquerda e sem edicao (sem ponto e virgula). Quando se
			// tratar de valor zerado, a representacao deve ser 000 (tres zeros).
			$p1 = substr($codigo, 5, 4);
			$p2 = substr($codigo, 9, 10);
			$campo5 = "$p1$p2";

			return "$campo1 $campo2 $campo3 $campo4 $campo5"; 
	}

	function geraCodigoBanco($numero) {
		$parte1 = substr($numero, 0, 3);
		return $parte1 . "-X";
	}

	public function cpny($company,$dadosArray,$bancos){
		$company= json_decode($company);
		
		//---------------------------------------------------
		
		$taxa_boleto   = $company->{'emp_taxa'};
		$valor_cobrado = $dadosArray[0];
		$valor_cobrado = str_replace(",", ".",$valor_cobrado);
        //<!-- corrigir bug do number_format
		setlocale(LC_MONETARY, 'pt_BR.UTF-8', 'Portuguese_Brazil.1252');
		$valor_boleto = money_format('%n',floatval($valor_cobrado)+floatval($taxa_boleto));
		$valor_boleto = str_replace("R$ ","",$valor_boleto);
		
		$dadosboleto["inicio_nosso_numero"] = date("y");	// Ano da gerao do ttulo ex: 07 para 2007 
		$dadosboleto["numero_documento"] = $dadosArray[2];	// Num do pedido ou do documento
		$dadosboleto["data_vencimento"] = $dadosArray[4]; // Data de Vencimento do Boleto - REGRA: Formato DD/MM/AAAA
		$dadosboleto["data_documento"] = $dadosArray[3]; // Data de emisso do Boleto
		$dadosboleto["data_processamento"] = date("d/m/Y"); // Data de processamento do boleto (opcional)
		$dadosboleto["valor_boleto"] = $valor_boleto; 	// Valor do Boleto - REGRA: Com vrgula e sempre com duas casas depois da virgula
		// DADOS DO SEU CLIENTE
		if($dadosArray[14]!=""){
			$length = strlen($dadosArray[14]);
			if($length==11){
				$cnpjCpf = ' - CPF: '.substr($dadosArray[14],0,3).'.'.substr($dadosArray[14],3,3).'.'.substr($dadosArray[14],6,3).'-'.substr($dadosArray[14],9,2);				
				$cnpjCpf2 = '<br>CPF: '.substr($dadosArray[14],0,3).'.'.substr($dadosArray[14],3,3).'.'.substr($dadosArray[14],6,3).'-'.substr($dadosArray[14],9,2);				
			}
			if($length==14){
				$cnpjCpf = ' - CNPJ: '.substr($dadosArray[14],0,2).'.'.substr($dadosArray[14],2,3).'.'.substr($dadosArray[14],5,3).'/'.substr($dadosArray[14],8,4).'-'.substr($dadosArray[14],12,2);
				$cnpjCpf2 = '<br>CNPJ: '.substr($dadosArray[14],0,2).'.'.substr($dadosArray[14],2,3).'.'.substr($dadosArray[14],5,3).'/'.substr($dadosArray[14],8,4).'-'.substr($dadosArray[14],12,2);
			}
		}
		$dadosboleto["sacado"] = strtoupper($dadosArray[13].$cnpjCpf);
		$dadosboleto["endereco1"] = $dadosArray[15];
		$dadosboleto["endereco2"] = $dadosArray[16];
		// INSTRUES PARA O CAIXA
		if($dadosArray[6]=="atualizar"){
          $dadosboleto["instrucoes1"]="";
		}elseif($dadosArray[6]==""){
          $dadosboleto["instrucoes1"]=$company->{'emp_instr1'};
        }else{
          $dadosboleto["instrucoes1"]=$dadosArray[6];
        }
        
        if($dadosArray[7]==""){
          $dadosboleto["instrucoes2"]=$company->{'emp_instr2'};
        }else{
          $dadosboleto["instrucoes2"]=$dadosArray[7];
        }
        
        if($dadosArray[8]==""){
          $dadosboleto["instrucoes3"]=$company->{'emp_instr3'};
        }else{
          $dadosboleto["instrucoes3"]=$dadosArray[8];
        }
        
        if($dadosArray[9]==""){
          $dadosboleto["instrucoes4"]=$company->{'emp_instr4'};
        }else{
          $dadosboleto["instrucoes4"]=$dadosArray[9];
        }
        
        if($dadosArray[10]==""){
          $dadosboleto["instrucoes5"]=$company->{'emp_instr5'};
        }else{
          $dadosboleto["instrucoes5"]=$dadosArray[10];
        }
		// DADOS OPCIONAIS DE ACORDO COM O BANCO OU CLIENTE
		$dadosboleto["quantidade"] = "";
		$dadosboleto["valor_unitario"] = "";
		$dadosboleto["aceite"] = "N";	    // N - remeter cobrana sem aceite do sacado  (cobranas no-registradas)
										  // S - remeter cobrana apos aceite do sacado (cobranas registradas)
		$dadosboleto["especie"] = "R$";
		$dadosboleto["especie_doc"] = "DM"; // OS - Outros segundo manual para cedentes de cobrana SICREDI
		// ---------------------- DADOS FIXOS DE CONFIGURAO DO SEU BOLETO --------------- //
		// DADOS DA SUA CONTA - SICREDI
		$dadosboleto["agencia"] = $bancos->{'agencia'}; // Num da agencia (4 digitos), sem Digito Verificador
        $dadosboleto["conta"]   = $bancos->{'conta'}; // Num da conta (5 digitos), sem Digito Verificador
        $dadosboleto["convenio"]   = $bancos->{'convenio'}; // Num da conta (5 digitos), sem Digito Verificador
		$dadosboleto["conta_dv"] = $bancos->{'contadv'}; 	// Digito Verificador do Num da conta
		// DADOS PERSONALIZADOS - SICREDI
		$dadosboleto["posto"]= $bancos->{'posto'};      // Cdigo do posto da cooperativa de crdito
		$dadosboleto["byte_idt"]= $bancos->{'byte_ids'};	  // Byte de identificao do cedente do bloqueto utilizado para compor o nosso nmero.
										  // 1 - Idtf emitente: Cooperativa | 2 a 9 - Idtf emitente: Cedente
		$dadosboleto["carteira"] = $bancos->{'carteira'};   // Cdigo da Carteira: A (Simples) 
		// SEUS DADOS
        $dadosboleto["identificacao"] = $company->{'emp_fantasia'};
        $dadosboleto["cpf_cnpj"]      = $company->{'emp_cpfcnpj'};
        $dadosboleto["endereco"]      = $company->{'emp_endereco'}.", ".$company->{'emp_num'}." - ".$company->{'emp_bairro'};
        $dadosboleto["cidade_uf"]     = "CEP:".$company->{'emp_cep'}." - ".$company->{'emp_cidade'}." - ".$company->{'emp_uf'};
        $dadosboleto["cedente"]       = $company->{'emp_razao'};

		$dadosboleto['sacador_nome']	= $dadosArray[18];
		$dadosboleto['sacador_cnpjcpf']	= $dadosArray[19];	


        // ---------------------- DADOS FIXOS DE CONFIGURAO DO SEU BOLETO --------------- //


        // ------------------------- FUNCOES -------------------- //
		$codigobanco = "748";
		$codigo_banco_com_dv = $this->geraCodigoBanco($codigobanco);
        $nummoeda    = "9";
       
        $fator_vencimento    = $this->fator_vencimento($dadosboleto["data_vencimento"]);
        $valor          = $this->formata_numero(str_replace(".","",$dadosboleto["valor_boleto"]),10,0,"valor");
        $agencia        = $this->formata_numero($dadosboleto["agencia"],4,0);
        $posto        = $this->formata_numero($dadosboleto["posto"],2,0);
        // $conta          = $this->formata_numero($dadosboleto["conta"],5,0); //alterada em 08/10/2025
        $conta          = $this->formata_numero($dadosboleto["convenio"],5,0);
        $conta_dv          = $this->formata_numero($dadosboleto["conta_dv"],1,0);
        $carteira       = $dadosboleto["carteira"];
		
		//fillers - zeros Obs: filler1 contera 1 quando houver valor expresso no campo valor
		$filler1 = 1;
		$filler2 = 0;
		
		// Byte de Identificao do cedente 1 - Cooperativa; 2 a 9 - Cedente
		$byteidt = $dadosboleto["byte_idt"];
		// Codigo referente ao tipo de cobrana: "3" - SICREDI
		$tipo_cobranca = 1;
		// Codigo referente ao tipo de carteira: "1" - Carteira Simples 
		$tipo_carteira = 1;

		$filtro3 = '{"cod":"500870","params":[
			{"name":"nnu_banco","value":"'.$codigobanco.'","type":"string"},
			{"name":"nnu_carteira","value":"'.$bancos->{'carteira'}.'","type":"string"}
		]}';
		
		/*
			Criar nosso nmero
		*/
		$filtro3 = '{"cod":"700701","params":[
			{"name":"nnu_banco","value":"'.$codigobanco.'","type":"string"},
			{"name":"nnu_carteira","value":"'.$bancos->{'carteira'}.'","type":"string"}
		]}';
		
		$dataPacket = new Datapacket();
		$TParams = new TParams();
		$dataPacket->setHost($TParams->getHost($company->{'emp_db_sge'}));
		$dataPacket->debug(true);
		$dataPacket->add($filtro3);	
		
		$nnumero = $dataPacket->open(true); /*pega o ultimo nosso numero cadastrado no banco relacionando numero do banco e carteira*/

		$registros=0;
		if(!$nnumero){	/* se no existir nosso nmero para o banco e a carteira selecionada ser criado um novo a partir do nosso nmero inicial*/
			$this->nnum=$bancos->{'nnini'};
		}else{	/* se existir documentos com o nmero do banco e carteira selecionada, resgata o maior nosso nmero cadastrado */
			for($i=0;$i<count($nnumero);$i++){
				$len=strlen($nnumero[$i]->{'nnu_numero'});
				if(!isset($nnumMaior)) {
					$nnumMaior = $nnumero[$i]->{'nnu_numero'};
				}else{
					if($nnumMaior<$nnumero[$i]->{'nnu_numero'})
						$nnumMaior =$nnumero[$i]->{'nnu_numero'};
				}
				$this->nnum = $nnumMaior;
				if($dadosArray[1]==$nnumero[$i]->{'doc_codigo'}){
					$nnumAtual = $nnumero[$i]->{'nnu_numero'};
					$this->nnum = $nnumero[$i]->{'nnu_numero'};
					$registros++;
					break;
				}
			}

			if($bancos->{'nnini'} > $nnumMaior)
				$this->nnum=$bancos->{'nnini'}+count($nnumero);
		}

		if($registros==0){	/* se no existir o cdigo do documento cadastrado, ento ele cadastra um novo nosso nmero */
			$this->{'nnum'}=$this->{'nnum'}+1;
			$filtro4  = '{"cod":"700702","params":[
				{"name":"doc_codigo","value":"'.$dadosArray[1].'","type":"string"},
				{"name":"nnu_numero","value":"'.$this->{'nnum'}.'","type":"string"},
				{"name":"nnu_banco","value":"'.$codigobanco.'","type":"string"},
				{"name":"nnu_carteira","value":"'.$bancos->{'carteira'}.'","type":"string"}
			]}';



			$dataPacket->clear();
			$dataPacket->add($filtro4);
			$dataPacket->open();
		}else{
			if($this->nnum < $nnumAtual)
				$this->nnum = $nnumAtual;
		}	
	
		// $this->nnum = str_pad($this->nnum,8,"0",STR_PAD_LEFT);

		$this->nnum = str_pad($this->nnum,5,"0",STR_PAD_LEFT);
		$dadosboleto["nosso_numero"] = $this->nnum;  			// Nosso numero (mx. 5 digitos) - Numero sequencial de controle.
		//nosso nmero (sem dv)  8 digitos
		$this->nnum  = $dadosboleto["inicio_nosso_numero"].$byteidt.$this->formata_numero($this->nnum,5,0);
		$this->nnum = str_pad($this->nnum,8,"0",STR_PAD_RIGHT);
		//calculo do DV do nosso nmero

		$dv_nosso_numero = $this->digitoVerificador_nossonumero($agencia.$posto.$conta.$this->nnum);
		
		$nossonumero_dv = $this->nnum.$dv_nosso_numero;
		//formao do campo livre
		$campolivre = $tipo_cobranca.$tipo_carteira.$nossonumero_dv.$agencia.$posto.$conta.$filler1.$filler2;
		$campolivre_dv = $campolivre.$this->digitoVerificador_campolivre($campolivre); 
		// 43 numeros para o calculo do digito verificador do codigo de barras
		$dv = $this->digitoVerificador_barra($codigobanco.$nummoeda.$fator_vencimento.$valor.$campolivre_dv, 9, 0);
		// Numero para o codigo de barras com 44 digitos
		$linha = $codigobanco.$nummoeda.$dv.$fator_vencimento.$valor.$campolivre_dv;
		// Formata strings para impressao no boleto
		$nossonumero = substr($this->nnum,0,2).'/'.substr($this->nnum,2,6).'-'.$dv_nosso_numero;
		$agencia_codigo = $agencia.".". $posto.".".$conta;
		$dadosboleto["codigo_barras"] = $linha;
		$dadosboleto["linha_digitavel"] = $this->monta_linha_digitavel($linha);
		$dadosboleto["agencia_codigo"] = $agencia_codigo;
		$dadosboleto["nosso_numero"] = $nossonumero;
		$dadosboleto["codigo_banco_com_dv"] = $codigo_banco_com_dv;

		$this->nossonumero=$nossonumero_dv; //nosso numero que sera gravado no banco -------------------------------------------------
		$this->linhaDigitavel=$dadosboleto["linha_digitavel"];
		
		// ------------------------- LAYOUT -------------------- //
		
		if( !isset($_REQUEST["carne"]) ){
			include "class_boletoLayout.php";
		}else{
			include "class_boletoLayoutCarne.php";
		}

    }
		

}
?>