<?php
	require_once "../php/TParams.class.php";
	class importarXml extends TParams{

		private $Params='';
		private $company='';
		public $tipo="";

		public function __construct($tipo="entrada"){

			$this->Params = new TParams();
			$this->company = $this->Params->getCompany();
			Datapacket::debug(true);
			$this->tipo=$tipo;

		}

		public function checkProd($ref_codigo_forn, $ref_id=2, $cad_codigo=""){
			
			Datapacket::clear();
			Datapacket::setHost($this->Params->getHost($this->company->{'emp_db_comum'}));
			
			if( $this->tipo=="saida" ){
				$ref_codigo_forn = (int) str_replace(".", "", $ref_codigo_forn);
				if($ref_id==1){
					$filtro = '{"cod":"600146","params":[{"name":"ref_codigo","value":"'.$ref_codigo_forn.'","type":"string"}]}';
				}else{
					$filtro = '{"cod":"600147","params":[{"name":"ref_codigo","value":"'.$ref_codigo_forn.'","type":"string"}]}';
				}
			}else{
				$filtro = '{"cod":"600140","params":[{"name":"ref_codigo_forn","value":"'.$ref_codigo_forn.'","type":"string"},{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"}]}';
			}
			
			Datapacket::add($filtro);
			$ret = Datapacket::open(true);

			if(count($ret)>0){
				if(isset($ret[0]->{'ref_codigo'}) && $ret[0]->{'ref_codigo'}!=''){
					return $ret[0]->{'ref_codigo'};
				}else{
					return false;
				}
			}else{
				return false;
			}

		}
		
		public function checkPessoa($frn_descr){
			
			Datapacket::clear();
			Datapacket::setHost($this->Params->getHost($this->company->{'emp_db_comum'}));
			
			// if( $this->tipo=="saida" ){
				$filtro = '{"cod":"600144","params":[{"name":"cad_cnpjcpf","value":"'.$frn_descr.'","type":"string"}]}';
			/*
			}else{
				$filtro = '{"cod":"600141","params":[{"name":"frn_descr","value":"'.$frn_descr.'","type":"string"}]}';
			}
			*/
			
			Datapacket::add($filtro);
			$ret = Datapacket::open(true);
			Datapacket::clear();

			if(count($ret)>0){
				if( $this->tipo=="entrada" ){
					$filtro = '{"cod":"700658","params":[{"name":"cad_codigo","value":"'.$ret[0]->{'cad_codigo'}.'","type":"string"}]}';
					Datapacket::add($filtro);
					Datapacket::open();
					Datapacket::clear();
				}
				return $ret[0]->{'cad_codigo'};
			}else{
				return false;
			}

		}
		
		public function checkNota($not_numero, $modelo=55, $serie=1, $chave=""){
			
			Datapacket::clear();
			Datapacket::setHost($this->Params->getHost($this->company->{'emp_db_sge'}));
			
			$not_tipo = ($modelo==55) ? 9 : 12;
			
			$filtro = '{"cod":"600149","params":[{"name":"not_numero","value":"'.$not_numero.'","type":"string"}, {"name":"not_tipo","value":"'.$not_tipo.'","type":"integer"}, {"name":"ser_codigo","value":"'.$serie.'","type":"string"}, {"name":"not_key_nfe","value":"'.$chave.'","type":"string"}]}';
			
			Datapacket::add($filtro);
			$ret = Datapacket::open(true);

			if(count($ret)>0){
				return $ret[0]->{'not_codigo'};
			}else{
				return false;
			}

		}
		
		public function cadastraPessoa($cad_codigo, $cad_cnpjcpf, $cad_nomeraz, $cad_inscrg, $cad_codmun, $cad_cidade, $cad_uf){
			
			Datapacket::clear();
			Datapacket::setHost($this->Params->getHost($this->company->{'emp_db_comum'}));
			
			$cad_pessoa = ( strlen($cad_cnpjcpf)==11 ) ? 1 : 2;
			
			$filtro = '{"cod":"600145","params":[
				{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
				{"name":"cad_cnpjcpf","value":"'.$cad_cnpjcpf.'","type":"string"},
				{"name":"cad_nomeraz","value":"'.$cad_nomeraz.'","type":"string"},
				{"name":"cad_snomefant","value":"'.$cad_nomeraz.'","type":"string"},
				{"name":"cad_pessoa","value":"'.$cad_pessoa.'","type":"integer"},
				{"name":"cad_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
				{"name":"cad_inscrg","value":"'.$cad_inscrg.'","type":"string"},
				{"name":"cad_codmun","value":"'.$cad_codmun.'","type":"string"},
				{"name":"cad_cidade","value":"'.$cad_cidade.'","type":"string"},
				{"name":"cad_uf","value":"'.$cad_uf.'","type":"string"}
			]}';
			$filtroHist = '{"cod":"501245","params":[
				{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
				{"name":"usu_login","value":"SISTEMA","type":"string"},
				{"name":"lgc_descr","value":"Novo Cadastro por xml","type":"string"}
			]}';
			Datapacket::add($filtro);
			Datapacket::add($filtroHist);
			Datapacket::open();

		}
		
		public function cadastraEndereco($cad_codigo, $end_nome, $end_compl, $end_bairro, $end_cidade, $end_uf, $end_cep, $end_num){
			
			Datapacket::clear();
			Datapacket::setHost($this->Params->getHost($this->company->{'emp_db_comum'}));
			
			$filtro = '{"cod":"700282","params":[
				{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
				{"name":"end_tipo","value":"1","type":"integer"},
				{"name":"end_nome","value":"'.$end_nome.'","type":"string"},
				{"name":"end_compl","value":"'.$end_compl.'","type":"string"},
				{"name":"end_bairro","value":"'.$end_bairro.'","type":"string"},
				{"name":"end_cidade","value":"'.$end_cidade.'","type":"string"},
				{"name":"end_uf","value":"'.$end_uf.'","type":"string"},
				{"name":"end_cep","value":"'.$end_cep.'","type":"string"},
				{"name":"end_num","value":"'.$end_num.'","type":"string"},
				{"name":"end_obs","value":"NULL","type":"other"},
				{"name":"end_pais","value":"NULL","type":"other"},
				{"name":"end_descrpais","value":"NULL","type":"other"},
				{"name":"end_codmun","value":"NULL","type":"other"}
			]}';
			Datapacket::add($filtro);
			Datapacket::open();

		}
		
		public function cadastraEmail($cad_codigo, $eml_ender){
			
			if($eml_ender!="" && !strstr($eml_ender, "teste")){
				Datapacket::clear();
				Datapacket::setHost($this->Params->getHost($this->company->{'emp_db_comum'}));
				
				$filtro = '{"cod":"701171","params":[
					{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
					{"name":"eml_ender","value":"'.$eml_ender.'","type":"string"},
					{"name":"eml_obs","value":"","type":"string"},
					{"name":"eml_tipo","value":"1","type":"integer"}
				]}';
				Datapacket::add($filtro);
				Datapacket::open();
			}

		}
		
		public function cadastraTelefone($cad_codigo, $tel_fone){
			
			if($tel_fone!=""){
				Datapacket::clear();
				Datapacket::setHost($this->Params->getHost($this->company->{'emp_db_comum'}));
				$tel_codigo = substr(str_replace(array(","," ","."),array("","",""),microtime()), -7);
				if( substr($tel_fone,0,2)=="00" ){
					$tel_ddd = substr($tel_fone,2,2);
					$tel_numero = substr($tel_fone,-4);
					if( strlen($tel_fone)==13 ){
						$tel_prefixo = substr($tel_fone,4,5);
					}else{
						$tel_prefixo = substr($tel_fone,4,4);
					}
				}else{
					$tel_ddd = substr($tel_fone,0,2);
					$tel_numero = substr($tel_fone,-4);
					if( strlen($tel_fone)==13 ){
						$tel_prefixo = substr($tel_fone,2,5);
					}else{
						$tel_prefixo = substr($tel_fone,2,4);
					}
				}
				$filtro = '{"cod":"700286","params":[
					{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
					{"name":"tel_codigo","value":"'.$tel_codigo.'","type":"integer"},
					{"name":"tel_ddd","value":"'.$tel_ddd.'","type":"string"},
					{"name":"tel_prefixo","value":"'.$tel_prefixo.'","type":"string"},
					{"name":"tel_numero","value":"'.$tel_numero.'","type":"string"},
					{"name":"tel_ramal","value":"","type":"string"},
					{"name":"tel_obs","value":"NULL","type":"other"},
					{"name":"tel_tipo","value":"3","type":"integer"}
				]}';
				Datapacket::add($filtro);
				Datapacket::open();
			}

		}
		
		public function cadastraNota($not_numero, $ser_codigo, $cad_codigo, $not_tipo, $not_data, $not_percdesc, $not_valordesc, $not_totalnota, $not_totalprod, $not_entrsaida, $not_totbaseicms, $not_toticms, $not_totbaseipi, $not_totipi, $cfo_codigo, $not_frete, $not_seguro, $not_despesa, $not_tpfrete, $not_toticmssubst, $not_obs1, $not_qtde, $not_especie, $not_marca, $not_nro, $not_pesobruto, $not_pesoliquido, $not_totbaseicmsst, $not_key_nfe, $not_cstat, $not_xmotivo, $not_nprot, $not_inf_fisco, $not_nferef, $not_tpemis){
			
			Datapacket::clear();
			Datapacket::setHost($this->Params->getHost($this->company->{'emp_db_sge'}));
			$not_codigo = substr(str_replace(array(","," ","."),array("","",""),microtime()), -10).mt_rand(1000, 9999);
			
			$filtrolog = '{"cod":"700103","params":[
				{"name":"log_tipo","value":"2","type":"integer"},
				{"name":"log_nro","value":"'.$not_codigo.'","type":"string"},
				{"name":"log_serie","value":"'.$ser_codigo.'","type":"string"},
				{"name":"log_usu_login","value":"SISTEMA","type":"string"},
				{"name":"log_acao_cod","value":"1","type":"integer"},
				{"name":"log_acao_descr","value":"inclusão","type":"string"},
				{"name":"log_data","value":"","type":"string"},
				{"name":"log_protocolo","value":"NULL","type":"other"},
				{"name":"log_ret","value":"NULL","type":"other"},
				{"name":"log_outro","value":"'.base64_encode("Nota Fiscal Importada pelo Sistema").'","type":"string"}
			]}';
			Datapacket::add($filtrolog);
			Datapacket::open();
			Datapacket::clear();
			
			$filtro ='{"cod":"500927","params":[
				{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"},
				{"name":"not_numero","value":"'.$not_numero.'","type":"integer"},
				{"name":"ser_codigo","value":"'.$ser_codigo.'","type":"string"},
				{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
				{"name":"cad_codvend","value":"NULL","type":"other"},
				{"name":"not_tipo","value":"'.$not_tipo.'","type":"integer"},
				{"name":"not_cancelada","value":"0","type":"integer"},
				{"name":"not_dtcancdesc","value":"","type":"null"},
				{"name":"not_data","value":"'.$not_data.'","type":"string"},
				{"name":"not_dtemissao","value":"'.$not_data.'","type":"string"},
				{"name":"not_dtfaturam","value":"'.$not_data.'","type":"string"},
				{"name":"not_dtprevisao","value":"'.$not_data.'","type":"string"},
				{"name":"not_dtentrega","value":"'.$not_data.'","type":"string"},
				{"name":"not_finanatualiz","value":"1","type":"integer"},
				{"name":"not_stokatualiz","value":"1","type":"integer"},
				{"name":"not_custoautaliz","value":"1","type":"integer"},
				{"name":"not_percdesc","value":"'.$not_percdesc.'","type":"float"},
				{"name":"not_valordesc","value":"'.$not_valordesc.'","type":"float"},
				{"name":"not_totalnota","value":"'.$not_totalnota.'","type":"float"},
				{"name":"not_totalprod","value":"'.$not_totalprod.'","type":"float"},
				{"name":"not_totalserv","value":"NULL","type":"other"},
				{"name":"not_entrsaida","value":"'.$not_entrsaida.'","type":"integer"},
				{"name":"not_totbaseicms","value":"'.$not_totbaseicms.'","type":"float"},
				{"name":"not_toticms","value":"'.$not_toticms.'","type":"float"},
				{"name":"not_totbaseipi","value":"'.$not_totbaseipi.'","type":"float"},
				{"name":"not_totipi","value":"'.$not_totipi.'","type":"float"},
				{"name":"cfo_codigo","value":"'.$cfo_codigo.'","type":"integer"},
				{"name":"cdp_codigo","value":"999","type":"integer"},
				{"name":"pdv_codigo","value":"","type":"null"},
				{"name":"ccu_codigo","value":"NULL","type":"other"},
				{"name":"tbp_codigo","value":"NULL","type":"other"},
				{"name":"not_codigo_pai","value":"NULL","type":"other"},
				{"name":"not_codigo_filho","value":"","type":"null"},
				{"name":"cad_codtransp","value":"NULL","type":"other"},
				{"name":"not_frete","value":"'.$not_frete.'","type":"float"},
				{"name":"not_seguro","value":"'.$not_seguro.'","type":"float"},
				{"name":"not_despesa","value":"'.$not_despesa.'","type":"float"},
				{"name":"not_tpfrete","value":"'.$not_tpfrete.'","type":"integer"},
				{"name":"not_toticmssubst","value":"'.$not_toticmssubst.'","type":"float"},
				{"name":"not_obs1","value":"'.base64_encode($not_obs1).'","type":"string"},
				{"name":"not_obs2","value":"","type":"string"},
				{"name":"not_obs3","value":"","type":"string"},
				{"name":"not_obs4","value":"","type":"string"},
				{"name":"not_devolucao","value":"","type":"null"},
				{"name":"not_hhmmss","value":"","type":"null"},
				{"name":"not_qtde","value":"'.$not_qtde.'","type":"float"},
				{"name":"not_especie","value":"'.$not_especie.'","type":"string"},
				{"name":"not_marca","value":"'.$not_marca.'","type":"string"},
				{"name":"not_nro","value":"'.$not_nro.'","type":"string"},
				{"name":"not_pesobruto","value":"'.$not_pesobruto.'","type":"float"},
				{"name":"not_pesoliquido","value":"'.$not_pesoliquido.'","type":"float"},
				{"name":"not_cadinscrito","value":"","type":"null"},
				{"name":"not_transportadora","value":"NULL","type":"other"},
				{"name":"not_placa","value":"NULL","type":"other"},
				{"name":"not_totbaseicmsst","value":"'.$not_totbaseicmsst.'","type":"float"},
				{"name":"not_totiss","value":"","type":"null"},
				{"name":"cad_atendente","value":"","type":"null"},
				{"name":"not_key_nfe","value":"'.$not_key_nfe.'","type":"string"},
				{"name":"not_cdp_desc","value":"0.00","type":"float"},
				{"name":"not_cobranca","value":"","type":"null"},
				{"name":"not_entrada","value":"","type":"null"},
				{"name":"not_status","value":"2","type":"integer"},
				{"name":"not_tpprc","value":"","type":"null"},
				{"name":"not_nrodeposito","value":"","type":"null"},
				{"name":"not_codrastream","value":"","type":"null"},
				{"name":"cta_codigo","value":"NULL","type":"other"},
				{"name":"not_result","value":"","type":"null"},
				{"name":"not_cstat","value":"'.$not_cstat.'","type":"integer"},
				{"name":"not_xmotivo","value":"'.base64_encode($not_xmotivo).'","type":"string"},
				{"name":"not_nrec","value":"","type":"null"},
				{"name":"not_nprot","value":"'.$not_nprot.'","type":"string"},
				{"name":"not_tpemis","value":"'.$not_tpemis.'","type":"other"},
				{"name":"not_aliq","value":"","type":"null"},
				{"name":"not_entrnfe","value":"","type":"null"},
				{"name":"not_mapa","value":"","type":"null"},
				{"name":"not_lote_ccev","value":"","type":"null"},
				{"name":"loc_codigo","value":"","type":"null"},
				{"name":"not_cod_mesa","value":"","type":"null"},
				{"name":"not_sta_mesa","value":"","type":"null"},
				{"name":"not_aliqcredicms","value":"NULL","type":"other"},
				{"name":"not_inf_fisco","value":"'.base64_encode($not_inf_fisco).'","type":"string"},
				{"name":"lic_codigo","value":"NULL","type":"other"},
				{"name":"not_nferef","value":"'.base64_encode($not_nferef).'","type":"string"},
				{"name":"not_auxiliar","value":"NULL","type":"other"},
				{"name":"not_anexo","value":"NULL","type":"other"},
				{"name":"ors_codigo","value":"NULL","type":"other"},
				{"name":"not_ibpt_federal","value":"0","type":"float"},
				{"name":"not_ibpt_estadual","value":"0","type":"float"},
				{"name":"not_ibpt_municipal","value":"0","type":"float"}
			]}';
			
			Datapacket::add($filtro);
			
			Datapacket::open();
			
			return $not_codigo;

		}
		
		public function cadastraDocto($doc_codigo, $doc_numero, $doc_valor, $doc_dtvcto, $doc_nparc, $doc_tparc, $cad_codigo, $ser_codigo, $not_codigo, $not_numero, $doc_pagrec){
			
			Datapacket::clear();
			Datapacket::setHost($this->Params->getHost($this->company->{'emp_db_sge'}));
			
			//PARCELA
			$filtro  = '{"cod":"500134", "params":[
				{"name":"doc_codigo", "value":"'.$doc_codigo.'", "type":"string"},
				{"name":"doc_numero", "value":"'.$doc_numero.'", "type":"string"},
				{"name":"doc_tipo", "value":"1", "type":"integer"},
				{"name":"doc_pagrec", "value":"'.$doc_pagrec.'", "type":"integer"},
				{"name":"doc_data", "value":"'.date('Y-m-d H:i:s').'", "type":"string"},
				{"name":"doc_valor", "value":"'.$doc_valor.'", "type":"float"},
				{"name":"doc_dtvcto", "value":"'.$doc_dtvcto.'", "type":"string"},
				{"name":"doc_dtpgto", "value":"NULL", "type":"other"},
				{"name":"doc_vlrpg", "value":"NULL", "type":"other"},
				{"name":"doc_descr", "value":"", "type":"string"},
				{"name":"doc_status", "value":"0", "type":"integer"},
				{"name":"doc_codbar", "value":" ", "type":"string"},
				{"name":"doc_linhadig", "value":"NULL", "type":"other"},
				{"name":"doc_banco", "value":"NULL", "type":"other"},
				{"name":"doc_agencia", "value":"NULL", "type":"other"},
				{"name":"doc_conta", "value":"NULL", "type":"other"},
				{"name":"doc_multa", "value":"NULL", "type":"other"},
				{"name":"doc_juros", "value":"NULL", "type":"other"},
				{"name":"doc_honorarios", "value":"NULL", "type":"other"},
				{"name":"doc_dias_envio", "value":"0", "type":"integer"},
				{"name":"doc_nparc", "value":"'.$doc_nparc.'", "type":"integer"},
				{"name":"doc_tparc", "value":"'.$doc_tparc.'", "type":"integer"},
				{"name":"doc_json_parcial", "value":"NULL", "type":"other"},
				{"name":"doc_obs", "value":"", "type":"string"},
				{"name":"cad_codigo", "value":"'.$cad_codigo.'", "type":"string"},
				{"name":"ser_codigo", "value":"'.$ser_codigo.'", "type":"string"},
				{"name":"ccu_codigo","value":"NULL","type":"other"},
				{"name":"doc_cod_pai", "value":"NULL", "type":"other"},
				{"name":"plc_codigo", "value":"NULL", "type":"other"},
				{"name":"cad_codatend", "value":"NULL", "type":"other"},
				{"name":"doc_carteira", "value":"NULL", "type":"other"},
				{"name":"doc_nossonumero", "value":"NULL", "type":"other"},
				{"name":"svc_codigo", "value":"NULL", "type":"other"},
				{"name":"doc_sacador", "value":"NULL", "type":"other"},
				{"name":"cta_codigo","value":"NULL","type":"other"},
				{"name":"doc_dias_protesto", "value":"NULL", "type":"other"},
				{"name":"doc_protesto", "value":"NULL", "type":"other"},
				{"name":"doc_previsao", "value":"0", "type":"integer"},
				{"name":"doc_origem", "value":"7", "type":"integer"},
				{"name":"doc_origem_codigo", "value":"'.$not_codigo.'", "type":"string"},
				{"name":"cad_codvend", "value":"NULL", "type":"other"},
				{"name":"doc_comissao", "value":"0.00", "type":"float"}
			]}';
			
			//VINCULO NF-e -> PARCELA
			$filtroParcNota = '{"cod":"700107","params":[
				{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"},
				{"name":"doc_codigo","value":"'.$doc_codigo.'","type":"string"}
			]}';
			
			//log inclusao docto
			$filtrolog = '{"cod":"501240","params":[
				{"name":"lgd_tipo","value":"1","type":"integer"},
				{"name":"doc_codigo","value":"'.$doc_codigo.'","type":"string"},
				{"name":"usu_login","value":"SISTEMA","type":"string"},
				{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
				{"name":"lgd_descr","value":"Documento cadastrado e vinculado a NF-e nro '.$not_numero.' via importação de XML","type":"string"}
			]}';
			
			Datapacket::add($filtro);
			Datapacket::add($filtroParcNota);
			Datapacket::add($filtrolog);
			Datapacket::open();

		}
		
		public function cadastraItem($not_codigo, $ref_codigo, $itn_ordem, $itn_descr, $itn_qtde, $itn_valordesc, $itn_valor, $itn_subtotal, $itn_baseicms, $itn_icms, $itn_aliqicms, $itn_baseipi, $itn_ipi, $itn_aliqipi, $itn_baseicmsst, $itn_icmssubst, $itn_tribjson, $itn_ncm, $ref_codbar, $uni_codigo, $tipo_nota){
			
			Datapacket::clear();
			Datapacket::setHost($this->Params->getHost($this->company->{'emp_db_sge'}));
			
			$array1 = array("á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç", "\"", "'", "-");
			$array2 = array("a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C", "", "", "");
			$itn_descr = str_replace($array1, $array2, $itn_descr);
			
			$filtro = '{"cod":"700099","params":[
				{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"},
				{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
				{"name":"itn_ordem","value":"'.$itn_ordem.'","type":"integer"},
				{"name":"itn_descr","value":"'.$itn_descr.'","type":"string"},
				{"name":"itn_qtde","value":"'.$itn_qtde.'","type":"float"},
				{"name":"itn_valordesc","value":"'.$itn_valordesc.'","type":"float"},
				{"name":"itn_valor","value":"'.$itn_valor.'","type":"float"},
				{"name":"itn_subtotal","value":"'.$itn_subtotal.'","type":"float"},
				{"name":"itn_baseicms","value":"'.$itn_baseicms.'","type":"float"},
				{"name":"itn_icms","value":"'.$itn_icms.'","type":"float"},
				{"name":"itn_aliqicms","value":"'.$itn_aliqicms.'","type":"float"},
				{"name":"itn_baseipi","value":"'.$itn_baseipi.'","type":"float"},
				{"name":"itn_ipi","value":"'.$itn_ipi.'","type":"float"},
				{"name":"itn_aliqipi","value":"'.$itn_aliqipi.'","type":"float"},
				{"name":"itn_baseicmsst","value":"'.$itn_baseicmsst.'","type":"float"},
				{"name":"itn_icmssubst","value":"'.$itn_icmssubst.'","type":"float"},
				{"name":"itn_custovenda","value":"NULL","type":"other"},
				{"name":"itn_tribjson","value":"'.base64_encode($itn_tribjson).'","type":"string"},
				{"name":"itn_ncm","value":"'.$itn_ncm.'","type":"string"},
				{"name":"ref_codbar","value":"'.$ref_codbar.'","type":"string"},
				{"name":"loc_codigo","value":"99999","type":"string"},
				{"name":"itn_obs","value":" ","type":"string"},
				{"name":"uni_codigo","value":"'.$uni_codigo.'","type":"string"},
				{"name":"itn_altura","value":"NULL","type":"other"},
				{"name":"itn_largura","value":"NULL","type":"other"},
				{"name":"itn_modelo","value":"NULL","type":"other"},
				{"name":"itn_comando","value":"NULL","type":"other"},
				{"name":"fml_codigo","value":"NULL","type":"other"},
				{"name":"lot_codigo","value":"99999","type":"string"}
			]}';
			
			Datapacket::add($filtro);
			
			if($tipo_nota && $tipo_nota=="entrada"){
				$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
				$filtrostk = '{"cod":"700111","params":[
					{"name":"db","value":"'.$this->company->{'emp_db_comum'}.'","type":"other"},
					{"name":"emp_codigo","value":"'.$this->company->{'emp_codigo'}.'","type":"string"},
					{"name":"loc_codigo","value":"99999","type":"string"},
					{"name":"lot_codigo","value":"99999","type":"string"},
					{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
					{"name":"ser_codigo","value":"1","type":"string"},
					{"name":"stk_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
					{"name":"stk_qde","value":"'.$itn_qtde.'","type":"float"},
					{"name":"stk_tipo","value":"1","type":"integer"},
					{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"}
				]}';
				Datapacket::add($filtrostk);
				
				if($itn_icmssubst>0){
					$icmsProd = $itn_icmssubst/$itn_qtde;
				}else{
					$icmsProd=0;
				}
				if($itn_ipi>0){
					$ipiProd = $itn_ipi/$itn_qtde;
				}else{
					$ipiProd=0;
				}
				$custoRepos = $itn_valor+$icmsProd+$ipiProd;
				$cus_medio = $custoRepos;
				$filtrocusto = '{"cod":"700202","params":[
					{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
					{"name":"ser_codigo","value":"1","type":"string"},
					{"name":"cus_qtde","value":"'.$itn_qtde.'","type":"float"},
					{"name":"cus_repos","value":"'.str_replace(",", ".", $custoRepos).'","type":"float"},
					{"name":"cus_medio","value":"'.$cus_medio.'","type":"float"},
					{"name":"cus_venda","value":"'.str_replace( ",", ".", ( $custoRepos + ($custoRepos * $this->company->{'emp_overhead'})/100 ) ).'","type":"float"},
					{"name":"cus_ipi","value":"'.str_replace(",", ".", $ipiProd).'","type":"float"},
					{"name":"cus_icms","value":"'.str_replace(",", ".", $icmsProd).'","type":"float"}
				]}';
				Datapacket::add($filtrocusto);
			}
				
			Datapacket::open();

		}
		
		public function cadastraProduto($ref_codigo, $ref_codbar, $ref_descr, $ref_status, $ref_preco, $uni_codigo, $ref_ncm, $ref_propriedade, $ref_cest, $ref_codigo_forn, $cad_codigo){
			
			$array1 = array("á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç", "\"", "'", "-");
			$array2 = array("a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C", "", "", "");
			$ref_descr = str_replace($array1, $array2, $ref_descr);
			
			Datapacket::clear();
			Datapacket::setHost($this->Params->getHost($this->company->{'emp_db_comum'}));
			$ref_codigo = (int) str_replace(".", "", $ref_codigo);
			
			$uni_codigo = substr($uni_codigo, 0, 4);
			
			$filtro = '{"cod":"700522","params":[
				{"name":"uni_codigo","value":"'.$uni_codigo.'","type":"string"}
			]}';
			Datapacket::add($filtro);
			$ret = Datapacket::open();
			Datapacket::clear();
			
			if(isset($ret) && count($ret)==0){

				$filtro = '{"cod":"700519","params":[
					{"name":"uni_codigo","value":"'.$uni_codigo.'","type":"string"},
					{"name":"uni_descr","value":"'.$uni_codigo.'","type":"string"}
				]}';
				Datapacket::add($filtro);
				Datapacket::open();
				Datapacket::clear();
				
			}

			
			$filtro = '{"cod":"600148","params":[
				{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
				{"name":"ref_codbar","value":"'.$ref_codbar.'","type":"string"},
				{"name":"ref_descr","value":"'.$ref_descr.'","type":"string"},
				{"name":"ref_status","value":"'.$ref_status.'","type":"integer"},
				{"name":"ref_preco","value":"'.$ref_preco.'","type":"float"},
				{"name":"uni_codigo","value":"'.$uni_codigo.'","type":"string"},
				{"name":"ref_ncm","value":"'.$ref_ncm.'","type":"string"},
				{"name":"ref_propriedade","value":"'.$ref_propriedade.'","type":"string"},
				{"name":"ref_cest","value":"'.$ref_cest.'","type":"string"}
			]}';
			$filtroStk = '{"cod":"700501","params":[
				{"name":"emp_codigo","value":"'.$this->company->{'emp_codigo'}.'","type":"string"},
				{"name":"loc_codigo","value":"99999","type":"string"},
				{"name":"lot_codigo","value":"99999","type":"string"},
				{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
				{"name":"ser_codigo","value":"1","type":"string"},
				{"name":"stk_seq","value":"'.mt_rand().'","type":"string"},
				{"name":"stk_qde","value":"0","type":"string"}
			]}';
			$filtroUM = '{"cod":"700367","params":[
				{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
				{"name":"uni_codigo","value":"'.$uni_codigo.'","type":"string"},
				{"name":"urf_precoata","value":"'.$ref_preco.'","type":"float"},
				{"name":"urf_precovar","value":"'.$ref_preco.'","type":"float"},
				{"name":"urf_precomin","value":"'.$ref_preco.'","type":"float"},
				{"name":"qtde_conversor","value":"0","type":"float"}
			]}';
			
			Datapacket::add($filtroStk);
			Datapacket::add($filtroUM);
			Datapacket::open();
			Datapacket::clear();
			
			Datapacket::add($filtro);
			$ref_codigo = Datapacket::open(false, true);
			Datapacket::clear();
			
			$filtroHist = '{"cod":"700797","params":[
				{"name":"db","value":"'.$this->company->{'emp_db_sge'}.'","type":"other"},
				{"name":"codigo","value":"'.$ref_codigo.'","type":"integer"},
				{"name":"descr","value":"Novo produto cadastrado por xml","type":"string"},
				{"name":"usuario","value":"SISTEMA","type":"string"}
			]}';
			Datapacket::add($filtroHist);
			Datapacket::open();
			Datapacket::clear();
			
			if( $ref_codigo_forn && $ref_codigo_forn!="" && $cad_codigo && $cad_codigo!="" ){
				$filtroForn = '{"cod":"700469","params":[
					{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
					{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
					{"name":"ref_codigo_forn","value":"'.$ref_codigo_forn.'","type":"string"}
				]}';
				Datapacket::add($filtroForn);
				Datapacket::open();
				Datapacket::clear();
			}
			
			return $ref_codigo;

		}

	}
?>