<?php 
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');

	if(isset($argv[1])){
		$argPath = $argv[1];
	}else{
		$argPath = 'fausto';
	}
	
	$path = '/home/'.$argPath.'/FACIL/';
	include $path.'php/TParams.class.php';

	$project_id = '6,139,179,208'; //id projects no redmine (Fácil Desktop, CRM UDS, Fácil - Chamados, Remessa e Retorno)
	$status_id 	= 12; //id issue_statuses no redmine (Aguardando Build)
	$appFile	= $path.'app/Application.js';
	$changelog	= $path.'changelog.html';
	
	$datapacket = new TParams();
	$datapacket->debug(true);
	$datapacket->setUtf8(true);

	/*	versão		*/
	$newFile='';

	$handleApp = fopen($appFile, "r");
	if($handleApp) {

		$contentApp = '';
		while(($line = fgets($handleApp)) !== false) {
			if(strstr($line,'version:')){
				$versionArray = explode('.',$line);
				$lastPos = str_pad($versionArray[2],4,'0',STR_PAD_RIGHT);
				$lastBuildDay = $versionArray[1].'.'.substr($lastPos,0,2);

				if(date('ym.d')==$lastBuildDay){
					$numBuild = substr($lastPos,2,2);
					$numBuild++;
				}else{
					$numBuild = '01';
				}

				$version = '1.'.date('ym.d').str_pad($numBuild,2,'0',STR_PAD_LEFT);
				$contentApp.=chr(9)."version: '".$version."',".chr(13).chr(10);
			}else{
				$contentApp.= $line;
			}
		}
		fclose($handleApp);

		unlink($appFile);
		$newappFile = fopen($appFile,'w+');
		fwrite($newappFile,$contentApp);
		fclose($newappFile);
	}else{
		exit('Erro ao ler o Application.js');
	}

	/*	----------	*/
	
	/*	changelog	*/
	$filtro = '{"cod":"501300","params":[
		{"name":"status_id","value":"'.$status_id.'","type":"integer"},
		{"name":"project_id","value":"'.$project_id.'","type":"other"}
	]}';

	$datapacket->setHost($datapacket->getHost('redmine'));
	$datapacket->add($filtro);
	$ret = $datapacket->open(true);
	$retCount = $datapacket->getRecordCount();
	$datapacket->clear();

	$handle = fopen($changelog, "r");
	if($handle) {

		$content = '';
		while(($line = fgets($handle)) !== false) {
			if(strstr($line,'<body id="top">')){
				$content.=chr(9).'<body id="top">'.chr(13).chr(10).chr(9).chr(9).'<div>'.chr(13).chr(10).chr(9).chr(9).chr(9).date('m/m/Y')." - ".$version.chr(13).chr(10).chr(9).chr(9).chr(9).'<ul id="bulk-selection">'.chr(13).chr(10);

				for($i=0;$i<$retCount;$i++){
					$content.=chr(9).chr(9).chr(9).chr(9).'<li><a class="issue tracker-8 status-12 priority-4 priority-high2 overdue assigned-to-me" href="http://redmine.grupouds.com.br/issues/'.$ret[$i]->{'id'}.'">'.$ret[$i]->{'tracker'}.' #'.$ret[$i]->{'id'}.'</a>: '.$ret[$i]->{'subject'}.'</li>'.chr(13).chr(10);

					if($i==$retCount-1){
						$content.=chr(9).chr(9).chr(9).'</ul>'.chr(13).chr(10).chr(9).chr(9).'</div>'.chr(13).chr(10);
					}

				}

			}else{
				$content.= $line;
			}
		}
		fclose($handle);

		unlink($changelog);
		$newChangelog = fopen($changelog,'w+');
		fwrite($newChangelog,$content);
		fclose($newChangelog);
		
		$datapacket->setHost($datapacket->getHost("empresas"));

		$filtro = '{"cod":"600200","params":[
			{"name":"fac_versao","value":"'.$version.'","type":"string"},
			{"name":"fac_changelog","value":"'.base64_encode($changelog).'","type":"string"},
			{"name":"fac_tipo","value":"2","type":"integer"}
		]}';
		$datapacket->add($filtro);
		
		$filtro = '{"cod":"600008","params":[
			{"name":"cfg_versao","value":"'.$version.'","type":"string"},
			{"name":"cfg_servidor","value":"\'facil.uds.com.br\', \'dev.grupouds.com.br\'","type":"other"}
		]}';
		$datapacket->add($filtro);
		
		$ret = $datapacket->open();
		$datapacket->clear();

	}else{
		exit('Erro ao ler o changelog.');
	}
	/*	----------	*/
?>