<?php

class GERAR_HTML{
	private $digito;
	private $resto;
	private $parte1;
	private $parte2;
	private $codigo_banco_com_dv;
	private $dv;
	private $fatorvenc;
	private $fator_vencto;
	private $dttodays;
	private $valor;
	private $nnum;
	private $agencia;
	private $conta;
	private $codigo_barras;
	private $conta_dv;
	private $linha;
	private $agencia_codigo;
	private $boletoCodigo_barras;
	private $boletoLinha_digitavel;
	private $boletoAgencia_codigo;
	private $boletoNosso_numero;
	private $boletoCodigo_banco_com_dv;
	private $logo="logoitau.jpg";
	private $texto;
	public $html;
	public $carteira;
	public $nossonumero;
	public $linhaDigitavel;
	
	/**
	 * Formata um numero em notacao de moeda, assim como a funcao money_format do PHP
	 * @author Rubens Takiguti Ribeiro
	 * @see http://php.net/manual/en/function.money-format.php
	 * @param string $formato Formato aceito por money_format
	 * @param float $valor Valor monetario
	 * @return string Valor formatado
	*/
	private	function my_money_format($formato, $valor) {

		// Se a funcao money_format esta disponivel: usa-la
		if (function_exists('money_format')) {
			return money_format($formato, $valor);
		}

		// Se nenhuma localidade foi definida, formatar com number_format
		if (setlocale(LC_MONETARY, 0) == 'C') {
			return number_format($valor, 2);
		}

		// Obter dados da localidade
		$locale = localeconv();

		// Extraindo opcoes do formato
		$regex = '/^'.             // Inicio da Expressao
				 '%'.              // Caractere %
				 '(?:'.            // Inicio das Flags opcionais
				 '\=([\w\040])'.   // Flag =f
				 '|'.
				 '([\^])'.         // Flag ^
				 '|'.
				 '(\+|\()'.        // Flag + ou (
				 '|'.
				 '(!)'.            // Flag !
				 '|'.
				 '(-)'.            // Flag -
				 ')*'.             // Fim das flags opcionais
				 '(?:([\d]+)?)'.   // W  Largura de campos
				 '(?:#([\d]+))?'.  // #n Precisao esquerda
				 '(?:\.([\d]+))?'. // .p Precisao direita
				 '([in%])'.        // Caractere de conversao
				 '$/';             // Fim da Expressao

		if (!preg_match($regex, $formato, $matches)) {
			trigger_error('Formato invalido: '.$formato, E_USER_WARNING);
			return $valor;
		}

		// Recolhendo opcoes do formato
		$opcoes = array(
			'preenchimento'   => ($matches[1] !== '') ? $matches[1] : ' ',
			'nao_agrupar'     => ($matches[2] == '^'),
			'usar_sinal'      => ($matches[3] == '+'),
			'usar_parenteses' => ($matches[3] == '('),
			'ignorar_simbolo' => ($matches[4] == '!'),
			'alinhamento_esq' => ($matches[5] == '-'),
			'largura_campo'   => ($matches[6] !== '') ? (int)$matches[6] : 0,
			'precisao_esq'    => ($matches[7] !== '') ? (int)$matches[7] : false,
			'precisao_dir'    => ($matches[8] !== '') ? (int)$matches[8] : $locale['int_frac_digits'],
			'conversao'       => $matches[9]
		);

		// Sobrescrever $locale
		if ($opcoes['usar_sinal'] && $locale['n_sign_posn'] == 0) {
			$locale['n_sign_posn'] = 1;
		} elseif ($opcoes['usar_parenteses']) {
			$locale['n_sign_posn'] = 0;
		}
		if ($opcoes['precisao_dir']) {
			$locale['frac_digits'] = $opcoes['precisao_dir'];
		}
		if ($opcoes['nao_agrupar']) {
			$locale['mon_thousands_sep'] = '';
		}

		// Processar formatacao
		$tipo_sinal = $valor >= 0 ? 'p' : 'n';
		if ($opcoes['ignorar_simbolo']) {
			$simbolo = '';
		} else {
			$simbolo = $opcoes['conversao'] == 'n' ? $locale['currency_symbol']
												   : $locale['int_curr_symbol'];
		}
		$numero = number_format(abs($valor), $locale['frac_digits'], $locale['mon_decimal_point'], $locale['mon_thousands_sep']);

	/*
	//TODO: dar suporte a todas as flags
		list($inteiro, $fracao) = explode($locale['mon_decimal_point'], $numero);
		$tam_inteiro = strlen($inteiro);
		if ($opcoes['precisao_esq'] && $tam_inteiro < $opcoes['precisao_esq']) {
			$alinhamento = $opcoes['alinhamento_esq'] ? STR_PAD_RIGHT : STR_PAD_LEFT;
			$numero = str_pad($inteiro, $opcoes['precisao_esq'] - $tam_inteiro, $opcoes['preenchimento'], $alinhamento).
					  $locale['mon_decimal_point'].
					  $fracao;
		}
	*/

		$sinal = $valor >= 0 ? $locale['positive_sign'] : $locale['negative_sign'];
		$simbolo_antes = $locale[$tipo_sinal.'_cs_precedes'];

		// Espaco entre o simbolo e o numero
		$espaco1 = $locale[$tipo_sinal.'_sep_by_space'] == 1 ? ' ' : '';

		// Espaco entre o simbolo e o sinal
		$espaco2 = $locale[$tipo_sinal.'_sep_by_space'] == 2 ? ' ' : '';

		$formatado = '';
		switch ($locale[$tipo_sinal.'_sign_posn']) {
		case 0:
			if ($simbolo_antes) {
				$formatado = '('.$simbolo.$espaco1.$numero.')';
			} else {
				$formatado = '('.$numero.$espaco1.$simbolo.')';
			}
			break;
		case 1:
			if ($simbolo_antes) {
				$formatado = $sinal.$espaco2.$simbolo.$espaco1.$numero;
			} else {
				$formatado = $sinal.$numero.$espaco1.$simbolo;
			}
			break;
		case 2:
			if ($simbolo_antes) {
				$formatado = $simbolo.$espaco1.$numero.$sinal;
			} else {
				$formatado = $numero.$espaco1.$simbolo.$espaco2.$sinal;
			}
			break;
		case 3:
			if ($simbolo_antes) {
				$formatado = $sinal.$espaco2.$simbolo.$espaco1.$numero;
			} else {
				$formatado = $numero.$espaco1.$sinal.$espaco2.$simbolo;
			}
			break;
		case 4:
			if ($simbolo_antes) {
				$formatado = $simbolo.$espaco2.$sinal.$espaco1.$numero;
			} else {
				$formatado = $numero.$espaco1.$simbolo.$espaco2.$sinal;
			}
			break;
		}

		// Se a string nao tem o tamanho minimo
		if ($opcoes['largura_campo'] > 0 && strlen($formatado) < $opcoes['largura_campo']) {
			$alinhamento = $opcoes['alinhamento_esq'] ? STR_PAD_RIGHT : STR_PAD_LEFT;
			$formatado = str_pad($formatado, $opcoes['largura_campo'], $opcoes['preenchimento'], $alinhamento);
		}

		return $formatado;
	}
	
  function digitoVerificador_barra($numero) {
  $resto2 = $this->modulo_11($numero, 9, 1);
  $digito = 11 - $resto2;
      if ($digito == 0 || $digito == 1 || $digito == 10  || $digito == 11) {
         $dv = 1;
      } else {
         $dv = $digito;
      }
   return $dv;
  }

  function formata_numero($numero,$loop,$insert,$tipo = "geral") {
		if ($tipo == "geral") {
			$numero = str_replace(",","",$numero);
			while(strlen($numero)<$loop){
				$numero = $insert . $numero;
			}
		}
		if ($tipo == "valor") {
			$numero = str_replace(",","",$numero);
			while(strlen($numero)<$loop){
				$numero = $insert . $numero;
			}
		}
		if ($tipo == "convenio") {
			while(strlen($numero)<$loop){
				$numero = $numero . $insert;
			}
		}
		return $numero;	
  }

	function fbarcode($valor){
		$fino = 1.5 ;
		$largo = 3.5 ;
		$altura = 65 ;

		$barcodes[0] = "00110" ;
		$barcodes[1] = "10001" ;
		$barcodes[2] = "01001" ;
		$barcodes[3] = "11000" ;
		$barcodes[4] = "00101" ;
		$barcodes[5] = "10100" ;
		$barcodes[6] = "01100" ;
		$barcodes[7] = "00011" ;
		$barcodes[8] = "10010" ;
		$barcodes[9] = "01010" ;
		for($f1=9;$f1>=0;$f1--){ 
			for($f2=9;$f2>=0;$f2--){  
				$f = ($f1 * 10) + $f2 ;
				$texto = "" ;
				for($i=1;$i<6;$i++){ 
					$texto .=  substr($barcodes[$f1],($i-1),1) . substr($barcodes[$f2],($i-1),1);
				}
				$barcodes[$f] = $texto;
			}
		}
		//Desenho da barra
		//Guarda inicial
		$barcode='<img src="imagens/p.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		src="imagens/b.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		src="imagens/p.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		src="imagens/b.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		';
		$texto = $valor ;
		if((strlen($texto) % 2) <> 0){
			$texto = "0" . $texto;
		}

		// Draw dos dados
		while (strlen($texto) > 0) {
			$i = round($this->esquerda($texto,2));
			$texto = $this->direita($texto,strlen($texto)-2);
			$f = $barcodes[$i];
			for($i=1;$i<11;$i+=2){
				if (substr($f,($i-1),1) == "0") {
					$f1 = $fino ;
				}else{
					$f1 = $largo ;
				}
				$barcode.='
				src="imagens/p.png" width="'.$f1.'" height="'.$altura.'" border="0"><img 
				';
				if (substr($f,$i,1) == "0") {
					$f2 = $fino ;
				}else{
					$f2 = $largo ;
				}
				$barcode.='
				src="imagens/b.png" width="'.$f2.'" height="'.$altura.'" border="0"><img 
				';
			}
		}

		// Draw guarda final
		$barcode.='
		src="imagens/p.png" width="'.$largo.'" height="'.$altura.'" border="0"><img 
		src="imagens/b.png" width="'.$fino.'" height="'.$altura.'" border="0"><img 
		src="imagens/p.png" width="1" height="'.$altura.'" border="0">';
		return $barcode;
	} //Fim da função

	function esquerda($entra,$comp){
		return substr($entra,0,$comp);
	}

	function direita($entra,$comp){
		return substr($entra,strlen($entra)-$comp,$comp);
	}

	function _dateToDays($year,$month,$day) {
		$century = substr($year, 0, 2);
		$year = substr($year, 2, 2);
		if ($month > 2) {
			$month -= 3;
		} else {
			$month += 9;
			if ($year) {
				$year--;
			} else {
				$year = 99;
				$century --;
			}
		}
		$this->dttodays = (floor((146097*$century)/4)+floor((1461*$year)/4)+floor((153*$month+2)/5)+$day+1721119);
		return $this->dttodays;
	}

	function fator_vencimento($data) {
	$data = explode("/",$data);
	$ano = $data[2];
	$mes = $data[1];
	$dia = $data[0];
	return (abs(($this->_dateToDays("1997","10","07")) - ($this->_dateToDays($ano, $mes, $dia))));
	}

	function modulo_10($num) {
	$numtotal10 = 0;
	$fator = 2;
	for ($i = strlen($num); $i > 0; $i--) {
	   $numeros[$i] = substr($num,$i-1,1);
	   $temp = $numeros[$i] * $fator;
	   $temp0=0;
	   foreach (preg_split('//',$temp,-1,PREG_SPLIT_NO_EMPTY) as $k=>$v){ $temp0+=$v; }
	   $parcial10[$i] = $temp0;

	   $numtotal10 += $parcial10[$i];
	   if ($fator == 2) {
		   $fator = 1;
	   } else {
		   $fator = 2;
	   }
	}
	$resto = $numtotal10 % 10;
	$this->digito = 10 - $resto;
	if ($resto == 0) {
	   $this->digito = 0;
	}
	return $this->digito;
	}

	function modulo_11($num, $base=9, $r=0)  {
	$soma = 0;
	$fator = 2;

	for ($i = strlen($num); $i > 0; $i--) {
		$numeros[$i] = substr($num,$i-1,1);
		$parcial[$i] = $numeros[$i] * $fator;
		$soma += $parcial[$i];
		if ($fator == $base) {
			$fator = 1;
		}
		$fator++;
	}
	if ($r == 0) {
		$soma *= 10;
		$this->digito = $soma % 11;
		if ($digito == 10) {
			$digito = 0;
		}
		return $this->digito;
	} elseif ($r == 1){
		$this->resto = $soma % 11;
		return $this->resto;
	}
	}

	function monta_linha_digitavel($codigo) {
	$banco    = substr($codigo,0,3);
	$moeda    = substr($codigo,3,1);
	$ccc      = substr($codigo,19,3);
	$ddnnum   = substr($codigo,22,2);
	$dv1      = $this->modulo_10($banco.$moeda.$ccc.$ddnnum);
	$resnnum  = substr($codigo,24,6);
	$dac1     = substr($codigo,30,1);
	$dddag    = substr($codigo,31,3);
	$dv2      = $this->modulo_10($resnnum.$dac1.$dddag);
	$resag    = substr($codigo,34,1);
	$contadac = substr($codigo,35,6);
	$zeros    = substr($codigo,41,3);
	$dv3      = $this->modulo_10($resag.$contadac.$zeros);
	$dv4      = substr($codigo,4,1);
	$fator    = substr($codigo,5,4);
	$valor    = substr($codigo,9,10);
	$campo1 = substr($banco.$moeda.$ccc.$ddnnum.$dv1,0,5).'.'.substr($banco.$moeda.$ccc.$ddnnum.$dv1,5,5);
	$campo2 = substr($resnnum.$dac1.$dddag.$dv2,0,5).'.'.substr($resnnum.$dac1.$dddag.$dv2,5,6);
	$campo3 = substr($resag.$contadac.$zeros.$dv3,0,5).'.'.substr($resag.$contadac.$zeros.$dv3,5,6);
	$campo4 = $dv4;
	$campo5 = $fator.$valor;
	$linhaMontada = $campo1." ".$campo2." ".$campo3." ".$campo4." ".$campo5;
	return $linhaMontada;
	}

  function geraCodigoBanco($numero) {
    $this->parte1 = substr($numero, 0, 3);
  }
	function geraCodigoBanco2($numero) {
		$parte1 = substr($numero, 0, 3);
		$parte2 = $this->modulo_11($parte1);
		return $parte1 . "-" . $parte2;
	}  

	function _nnum($numero){
	  $numDocto = substr($numero,0,5);
		return $numDocto;
	}

  function cpny($company,$dadosArray,$bancos){
		$company= json_decode($company);

		$especieDoc = "DM";

		// DADOS DO BOLETO PARA O SEU CLIENTE
		$taxa_boleto   = $company->{'emp_taxa'};
		$valor_cobrado = $dadosArray[0];
		$valor_cobrado = str_replace(",", ".",$valor_cobrado);
		
		//<!-- corrigir bug do number_format
		setlocale(LC_MONETARY, 'pt_BR.UTF-8', 'Portuguese_Brazil.1252');
		$valor_boleto = $this->my_money_format('%n',floatval($valor_cobrado)+floatval($taxa_boleto));
		$valor_boleto = str_replace("R$ ","",$valor_boleto);
		//-->
		
		$dadosboleto["nossonumero"]        = substr($dadosArray[1],0,8);
		$dadosboleto["numero_documento"]   = $dadosArray[2]; 
		$dadosboleto["data_vencimento"]    = $dadosArray[4];
		$dadosboleto["data_documento"]     = $dadosArray[3];
		$dadosboleto["data_processamento"] = date("d/m/Y");
		$dadosboleto["valor_boleto"]       = $valor_boleto;

		// DADOS DO SEU CLIENTE
		if($dadosArray[14]!=""){
			$length = strlen($dadosArray[14]);
			if($length==11){
				$cnpjCpf = ' - CPF: '.substr($dadosArray[14],0,3).'.'.substr($dadosArray[14],3,3).'.'.substr($dadosArray[14],6,3).'-'.substr($dadosArray[14],9,2);				
				$cnpjCpf2 = '<br>CPF: '.substr($dadosArray[14],0,3).'.'.substr($dadosArray[14],3,3).'.'.substr($dadosArray[14],6,3).'-'.substr($dadosArray[14],9,2);				
			}
			if($length==14){
				$cnpjCpf = ' - CNPJ: '.substr($dadosArray[14],0,2).'.'.substr($dadosArray[14],2,3).'.'.substr($dadosArray[14],5,3).'/'.substr($dadosArray[14],8,4).'-'.substr($dadosArray[14],12,2);
				$cnpjCpf2 = '<br>CNPJ: '.substr($dadosArray[14],0,2).'.'.substr($dadosArray[14],2,3).'.'.substr($dadosArray[14],5,3).'/'.substr($dadosArray[14],8,4).'-'.substr($dadosArray[14],12,2);
			}
		}
		$dadosboleto["sacado"]    = strtoupper($dadosArray[13].$cnpjCpf);
		$dadosboleto["sacado2"]   = $dadosArray[13].$cnpjCpf2;
		$dadosboleto["endereco1"] = $dadosArray[15];
		$dadosboleto["endereco2"] = $dadosArray[16];
		$dadosboleto["observacao"]= $dadosArray[17];
		
		$dadosboleto['sacador_nome']	= $dadosArray[18];
		$dadosboleto['sacador_cnpjcpf']	= $dadosArray[19];	

		// INFORMACOES PARA O CLIENTE
		if($dadosArray[6]=="atualizar"){
		  $dadosboleto["instrucoes1"]="";
		}elseif($dadosArray[6]==""){
		  $dadosboleto["instrucoes1"]=$company->{'emp_instr1'};
		}else{
		  $dadosboleto["instrucoes1"]=$dadosArray[6];
		}
		
		if($dadosArray[7]==""){
		  $dadosboleto["instrucoes2"]=$company->{'emp_instr2'};
		}else{
		  $dadosboleto["instrucoes2"]=$dadosArray[7];
		}
		
		if($dadosArray[8]==""){
		  $dadosboleto["instrucoes3"]=$company->{'emp_instr3'};
		}else{
		  $dadosboleto["instrucoes3"]=$dadosArray[8];
		}
		
		if($dadosArray[9]==""){
		  $dadosboleto["instrucoes4"]=$company->{'emp_instr4'};
		}else{
		  $dadosboleto["instrucoes4"]=$dadosArray[9];
		}
		
		if($dadosArray[10]==""){
		  $dadosboleto["instrucoes5"]=$company->{'emp_instr5'};
		}else{
		  $dadosboleto["instrucoes5"]=$dadosArray[10];
		}
			
		// DADOS OPCIONAIS DE ACORDO COM O BANCO OU CLIENTE
		$dadosboleto["quantidade"]     = "";
		$dadosboleto["valor_unitario"] = "";
		$dadosboleto["aceite"]         = "";
		$dadosboleto["especie"]        = "R$";
		//$dadosboleto["especie_doc"]    = "";
		
		$dadosboleto["especie_doc"]    = $especieDoc;

		// ---------------------- DADOS FIXOS DE CONFIGURAÇÃO DO SEU BOLETO --------------- //

		// DADOS DA SUA CONTA - ITAÚ
		$dadosboleto["agencia"]  = $bancos->{'agencia'}; // Num da agencia, sem digito
		$dadosboleto["conta"]    = $bancos->{'conta'};	// Num da conta, sem digito
		$dadosboleto["conta_dv"] = $bancos->{'contadv'}; 	// Digito do Num da conta	
		$dadosboleto["carteira"] = $bancos->{'carteira'};  // Código da Carteira: pode ser 175, 174, 104, 109, 178, ou 157

		// SEUS DADOS
		$dadosboleto["identificacao"] = $company->{'emp_fantasia'};
		$dadosboleto["cpf_cnpj"]      = $company->{'emp_cpfcnpj'};
		$dadosboleto["endereco"]      = $company->{'emp_endereco'}.", ".$company->{'emp_num'}." - ".$company->{'emp_bairro'};
		$dadosboleto["cidade_uf"]     = "CEP:".$company->{'emp_cep'}." - ".$company->{'emp_cidade'}." - ".$company->{'emp_uf'};
		$dadosboleto["cedente"]       = $company->{'emp_razao'};
		
		//PARCELA (carnê)
		$dadosboleto["nparc"]       = $dadosArray[20];
		$dadosboleto["tparc"]       = $dadosArray[21];
		
		// ------------------------- FUNCOES -------------------- //
		$codigobanco = $bancos->{'banco_numero'};
		if($codigobanco=="Itaú"){
			$codigobanco="341";
		}elseif($codigobanco=="BB"){
			$codigobanco="001";
		}
		$nummoeda = "9";
		
		$this->geraCodigoBanco($codigobanco);
		$this->parte2 			   = $this->modulo_11($this->parte1);
		$this->codigo_banco_com_dv = $this->parte1."-".$this->parte2;
		$this->fator_vencto 	   = $this->fator_vencimento($dadosArray[4]);
		$this->valor 			   = $this->formata_numero(str_replace(".","",$dadosboleto["valor_boleto"]),10,0,"valor");
		$this->carteira 		   = $dadosboleto["carteira"];
		
		/*
			--------------
		*/

		/*
			Criar nosso número
		*/
		$filtro3 = '{"cod":"700701","params":[
			{"name":"nnu_banco","value":"'.$codigobanco.'","type":"string"},
			{"name":"nnu_carteira","value":"'.$bancos->{'carteira'}.'","type":"string"}
		]}';
		
		$dataPacket = new Datapacket();
		$TParams = new TParams();
		$dataPacket->setHost($TParams->getHost($company->{'emp_db_sge'}));
		$dataPacket->add($filtro3);	
		$nnumero = $dataPacket->open(true); /*pega o ultimo nosso numero cadastrado no banco relacionando numero do banco e carteira*/

		$registros=0;
		if(!$nnumero){	/* se não existir nosso número para o banco e a carteira selecionada será criado um novo a partir do nosso número inicial*/
			$this->nnum=$bancos->{'nnini'};
		}else{	/* se existir documentos com o número do banco e carteira selecionada, resgata o maior nosso número cadastrado */
			for($i=0;$i<count($nnumero);$i++){
				$len=strlen($nnumero[$i]->{'nnu_numero'});
				if(!isset($nnumMaior)) {
					$nnumMaior = $nnumero[$i]->{'nnu_numero'};
				}else{
					if($nnumMaior<$nnumero[$i]->{'nnu_numero'})
						$nnumMaior =$nnumero[$i]->{'nnu_numero'};
				}
				$this->nnum = $nnumMaior;
				if($dadosArray[1]==$nnumero[$i]->{'doc_codigo'}){
					$nnumAtual = $nnumero[$i]->{'nnu_numero'};
					$this->nnum = $nnumero[$i]->{'nnu_numero'};
					$registros++;
					break;
				}
			}

			if($bancos->{'nnini'} > $nnumMaior)
				$this->nnum=$bancos->{'nnini'}+count($nnumero);
		}

		if($registros==0){	/* se não existir o código do documento cadastrado, então ele cadastra um novo nosso número */
			$this->{'nnum'}=$this->{'nnum'}+1;
			$filtro4  = '{"cod":"700702","params":[
				{"name":"doc_codigo","value":"'.$dadosArray[1].'","type":"string"},
				{"name":"nnu_numero","value":"'.$this->{'nnum'}.'","type":"string"},
				{"name":"nnu_banco","value":"'.$codigobanco.'","type":"string"},
				{"name":"nnu_carteira","value":"'.$bancos->{'carteira'}.'","type":"string"}
			]}';

			$dataPacketNnu = new Datapacket();
			$dataPacketNnu->setHost($TParams->getHost($company->{'emp_db_sge'}));
			$dataPacketNnu->add($filtro4);
			$dataPacketNnu->open();
		}else{
			if($this->nnum < $nnumAtual)
				$this->nnum = $nnumAtual;
		}	
	
		$this->nnum = str_pad($this->nnum,8,"0",STR_PAD_LEFT);

		$this->agencia 			   = $this->formata_numero($dadosboleto["agencia"],4,0);
		$this->conta 			   = $this->formata_numero($dadosboleto["conta"],5,0);
		$this->codigo_barras 	   = $codigobanco.$nummoeda.$this->fator_vencto.$this->valor.$this->carteira.$this->nnum.$this->modulo_10($this->agencia.$this->conta.$this->carteira.$this->nnum).$this->agencia.$this->conta.$this->modulo_10($this->agencia.$this->conta).'000';

		$char=0;
		
		$this->nossonumero 	  	 = $this->carteira.'/'.$this->nnum.'-'.$this->modulo_10($this->agencia.$this->conta.$this->carteira.$this->nnum);
		$this->conta_dv 		 = $this->formata_numero($dadosboleto["conta_dv"],1,0);
		$this->dv 				 = $this->digitoVerificador_barra($this->codigo_barras);
		$this->linha 			 = substr($this->codigo_barras,0,4).$this->dv.substr($this->codigo_barras,4,43);
		
		$this->agencia_codigo 	 = $this->agencia." / ". $this->conta."-".$this->modulo_10($this->agencia.$this->conta);

		$dadosboleto["codigo_barras"] 		= $this->linha;
		$dadosboleto["linha_digitavel"] 	= $this->monta_linha_digitavel($this->linha);
		$dadosboleto["agencia_codigo"] 		= $this->agencia_codigo;
		$dadosboleto["nosso_numero"] 		= $this->nossonumero;
		$dadosboleto["codigo_banco_com_dv"] = $this->codigo_banco_com_dv;
		$dadosboleto["local_pagamento"] = utf8_decode("Até o vencimento, preferencialmente no Itaú. <br>Após o vencimento, somente no Itaú");
		
		$this->linhaDigitavel = $dadosboleto["linha_digitavel"];
		// ------------------------- LAYOUT -------------------- //    

		if( !isset($_REQUEST["carne"]) ){
			include "class_boletoLayout.php";
		}else{
			include "class_boletoLayoutCarne.php";
		}
		
		$this->nossonumero = $this->nnum;
		$this->nossonumero .= $this->modulo_10($this->agencia.$this->conta.$this->carteira.$this->nnum);

	}
}
?>