// monta o phanton
var page = require('webpage').create();
var system = require('system');

var address = system.args[1]; // pega o nome doeste arquivo
var output = system.args[2]; // pega o nome do arquivo html

var razao = system.args[4];
var titulo = atob(system.args[5]);
var periodo = system.args[6];

var _filtros = "";
if(system.args[7]) { 
	_filtros = JSON.parse(atob(system.args[7]));
}

var _colunas = "";
if(system.args[8]){
	_colunas = JSON.parse(atob(system.args[8]));
}

var _logo = "";
if (system.args[9]){
	_logo = atob(system.args[9]);
}

var _cabecalhoHeight = "290px";
if (system.args[10]){
	_cabecalhoHeight = system.args[10].replace(/[^0-9]/g, '') + "px";
}

// monta o documento
page.paperSize = {
	width:'1754px', // largura do documento
	height:'1240px', // altura do documento
	margin:'10px',
	header:{
		height:_cabecalhoHeight,
		contents:phantom.callback(function(pageNum, numPages) {
			
			/*
				Titulo
			*/
			var _ret = '<div style="width:'+page.paperSize.width+'; text-align:center; position:relative;">';
			
			if(_logo!=''){
			
				_ret +=	'<img src="' + _logo + '" style="max-width:25%; max-height:120px; position:absolute; top:0; left:0;">';
			}
			
			_ret +=	'<div style="width:100%; font-size:18px; text-align:center; font-family:signika; padding-top:40px;">'

			+		'<span style="font-weight:bold; font-size:30px; font-family:signika">' + razao + ' </span>'
			
			+ 	'</div>'

			+ '</div>'
			
			/*
				Infos
			*/
			+'<div style="width:'+page.paperSize.width+'; margin:45px 0px 20px -10px; float:left; background-color:#C95A39; color:#FFFFFF; position:relative;">'
				
			+	'<div style="width:100%; float:left; margin:10px 0px 10px 0px; font-size:18px; font-family:signika; text-align:center;">'

			+		'<span style="font-weight:bold;">' + titulo + ' </span>'
				
			+		'<div style="font-weight:light;">' + periodo.replace(" ", " | ") + '</div>'

			+	'</div>'

			+	'<div style="width:97%; padding-top:20px; position:absolute; text-align:right">'

			+ 		'<span style="font-weight:normal; font-size:18px; font-family:signika";>' + pageNum + '/' + numPages + '</span>'
			
			+	'</div>'
			
			+'</div>'

			/*
				filtros
			*/
			+'<div style="margin:0px; width:'+page.paperSize.width+'; float:left; font-size:18px; font-family:signika">';

				for(var _j=0; _j<_filtros.length; _j++) _ret += atob(_filtros[_j]);

			_ret += '</div>';
			
			/*
				colunas
			*/
			if(_colunas){

				_ret += '<div style="width:'+page.paperSize.width+'; float:left;width:100%;color:#FFFFFF;background-color:#2F4454;padding:3px 10px;font-size: 16px;font-family: signika; margin:8px -8px">';
				
					for(var _j=0; _j<_colunas.length; _j++) _ret += atob(_colunas[_j]);

				_ret += '</div>';
			}

			return _ret;
		})
	}
};
page.zoomFactor = 2; // zoom do documento

// faz o pdf
page.open(address, function (status) {
	if (status !== 'success') {
		console.log('Unable to load the address!');
		phantom.exit();
	} else {
		window.setTimeout(function () {
			page.render(output);
			page.close();
			phantom.exit();
		}, 200);
	}
});
