<?php
//
//Registros a serem definidos pelo cliente: 50,51,53,54,60M,60A,60D,70
//

class TUtil {
	public static $LeftPad=0;	//Alinha a esquerda com preenchimento a direita
	public static $RightPad=1;	//Alinha a direita com preenchimento a esquerda

	public static function Pad($_s,$_l,$_c,$_p){
		$_x='';
		for($i=0;$i<($_l-strlen($_s));$i++){
			$_x.=$_c;
		}
		if ($_p==TUtil::$RightPad)
			$_x=($_x.$_s);
		else
			$_x=($_s.$_x);
			
		return substr($_x,0,$_l);
	}
	public static function UnMask($_s,$_m){
		$_res='';
		for($i=0;$i<strlen($_s);$i++){
			$_c=substr($_s,$i,1);
			if (!stristr($_m,$_c)) $_res.=$_c;
		}
		return $_res;
	}
	public static function RightStr($_s,$_l){
		return substr($_s,strlen($_s)-$_l,$_l);
	}
}

class TVersaoValidador {
	public static $vv523=0;
	public static $vv524=1;
}

class TVersaoEan {
	public static $eanIndefinido=0;
	public static $ean8=1;
	public static $ean12=2;
	public static $ean13=3;
	public static $ean14=4;
}

class TTipoReceita {
	public static $trPropria=1;
	public static $trTerceiros=2;
}

//Lista de objetos
class TObjectList {
	protected $container=array();
	protected $type="";
	protected $_container;
	protected $_order;
	
	public function Add($obj){
		if (get_class($obj)!=$this->type) throw new Exception('Objeto deve ser do tipo '.$this->type);
		array_push($this->container,$obj);
	}
	public function Get($index){
		if ($index<0 || $index>= count($this->container)) throw new Exception('Índice fora dos limites');
		return $this->container[$index];
	}
	public function Count(){
		return count($this->container);
	}
	public function Sort(){
		$this->container=array();
		sort($this->_order);
		for ($i=0;$i<count($this->_order);$i++){
			array_push($this->container,$this->_container[$this->_order[$i][count($this->_order[$i])-1]]);
		}
	}
}

class TRegistro10 {
	public $CNPJ;
	public $Inscricao;
    public $RazaoSocial;
    public $Cidade;
    public $Estado;
    public $Telefone;
    public $DataInicial;
    public $DataFinal;
    public $CodigoConvenio;
    public $NaturezaInformacoes;
    public $FinalidadeArquivo;
}

class TRegistro11 {
    public $Endereco;
    public $Numero;
    public $Complemento;
    public $Bairro;
    public $Cep;
    public $Responsavel;
    public $Telefone;
}

class TRegistro88EC {
    public $NomeContabilista;
    public $CPFContabilista;
    public $CRCContabilista;
    public $TelefoneContabilista;
    public $EmailContabilista;
    public $AlteraContabilista;
}

class TRegistro88SF {
    public $NomeEmpresa;
    public $CNPJEmpresa;
    public $CPFTecnico;
    public $TelefoneEmpresa;
    public $EmailEmpresa;
    public $AlteraEmpresa;
}

class TRegistro88C {
    public $CPFCNPJ;
    public $Modelo;
    public $Serie;
    public $Numero;
    public $CFOP;
    public $NumeroItem;
    public $Codigo;
    public $Quantidade;
    public $BaseST;
    public $ValorIcmsSTRepassar;
    public $ValorIcmsSTComplementar;
    public $BaseDeCalculoRetencao;
    public $ValorParcelaImpostoRetido;
}

class TRegistro88D {
    public $CPFCNPJ;
    public $Inscricao;
    public $UF;
    public $Modelo;
    public $Serie;
    public $Numero;
    public $EmissorDocumento;
    public $DataDocumento;
    public $DataSaidaEntrada;
    public $CNPJLocalSaida;
    public $UFLocalSaida;
    public $IeLocalSaida;
    public $CNPJLocalEntrega;
    public $UFLocalEntrega;
    public $IeLocalEntrega;
}

class TRegistro88E {
    public $CPFCNPJ;
    public $Inscricao;
    public $CodigoInformante;
    public $CodigoSefaz;
}

class TRegistro88T {
    public $CPFCNPJ;
    public $DataDocumento;
    public $UF;
    public $Modelo;
    public $Serie;
    public $Numero;
    public $EmissorDocumento;
    public $CifFob;
    public $CPFCNPJFrete;
    public $UFFrete;
    public $IeFrete;
    public $Modal;
    public $Placa1;
    public $UFPlaca1;
    public $Placa2;
    public $UFPlaca2;
    public $Placa3;
    public $UFPlaca3;
}

class TRegistro54 {
    public $CPFCNPJ;
    public $Modelo;
    public $Serie;
    public $Numero;
    public $CFOP;
    public $CST;
    public $NumeroItem;
    public $Codigo;
//    public $Descricao;
    public $Quantidade;
    public $Valor;
    public $ValorDescontoDespesa;
    public $BaseDeCalculo;
    public $BaseST;
    public $ValorIpi;
    public $Aliquota;
}

class TRegistro55 {
    public $CNPJ;
    public $Inscricao;
    public $DataPagamento;
    public $UF;
    public $UFFavorecida;
    public $Banco;
    public $Agencia;
    public $Numero;
    public $Valor;
    public $Vencimento;
    public $MesAno;
    public $NumeroConvenio;
}

class TRegistro56 {
    public $Cnpj;
    public $Modelo;
    public $Serie;
    public $Numero;
    public $CFOP;
    public $CST;
    public $NumeroItem;
    public $Codigo;
    public $TipoOperacao;
    public $CnpjConcessionaria;
    public $Ipi;
    public $Chassi;
}

class TRegistro74 {
    public $Data;
    public $Codigo;
    public $Quantidade;
    public $ValorProduto;
    public $CodigoPosse;
    public $CNPJPossuidor;
    public $InscricaoPossuidor;
    public $UFPossuidor;
}

class TRegistro75 {
    public $DataInicial;
    public $DataFinal;
    public $Codigo;
    public $NCM;
    public $Descricao;
    public $Unidade;
    public $AliquotaIpi;
    public $AliquotaIcms;
    public $Reducao;
    public $BaseST;
}

class TRegistro76 {
    public $CPFCNPJ;
    public $Inscricao;
    public $Modelo;
    public $Serie;
    public $SubSerie;
    public $Numero;
    public $CFOP;
    public $TipoReceita;
    public $DataDocumento;
    public $UF;
    public $ValorTotal;
    public $BaseDeCalculo;
    public $Icms;
    public $Isentas;
    public $Outras;
    public $Aliquota;
    public $Situacao;	
}

class TRegistro77 {
    public $CPFCNPJ;
    public $Modelo;
    public $Serie;
    public $SubSerie;
    public $Numero;
    public $CFOP;
    public $TipoReceita;
    public $NumeroItem;
    public $Codigo;
    public $Quantidade;
    public $ValorServico;
    public $ValorDesconto;
    public $BaseDeCalculo;
    public $Aliquota;
    public $CNPJMF;
    public $NumeroTerminal;
}

class TRegistro50 {
    public $CPFCNPJ;
    public $Inscricao;
    public $DataDocumento;
    public $UF;
    public $Modelo;
    public $Serie;
    public $Numero;
    public $CFOP;
    public $EmissorDocumento;
    public $ValorContabil;
    public $BaseDeCalculo;
    public $Icms;
    public $Isentas;
    public $Outras;
    public $Aliquota;
    public $Situacao;
    public $Registros54;
    public $Registros56;
	
    public function __construct(){
		$this->Registros54=new TRegistros54();
		$this->Registros56=new TRegistros56();
	}
}

class TRegistro51 {
    public $CPFCNPJ;
    public $Inscricao;
    public $DataDocumento;
    public $Estado;
    public $Serie;
    public $Numero;
    public $CFOP;
    public $ValorContabil;
    public $ValorIpi;
    public $ValorOutras;
    public $ValorIsentas;
    public $Situacao;
}

class TRegistro53 {
    public $CPFCNPJ;
    public $Inscricao;
    public $DataDocumento;
    public $Estado;
    public $Modelo;
    public $Serie;
    public $Numero;
    public $CFOP;
    public $Emitente;
    public $BaseST;
    public $IcmsRetido;
    public $Despesas;
    public $Situacao;
    public $CodigoAntecipacao;
}

class TRegistro70 {
    public $CPFCNPJ;
    public $Inscricao;
    public $DataDocumento;
    public $UF;
    public $Modelo;
    public $Serie;
    public $SubSerie;
    public $Numero;
    public $CFOP;
    public $ValorContabil;
    public $BaseDeCalculo;
    public $Icms;
    public $Isentas;
    public $Outras;
    public $CifFobOutros;
    public $Situacao;
}

class TRegistro71 {
    public $CPFCNPJ;
    public $Inscricao;
    public $DataDocumento;
    public $Modelo;
    public $Serie;
    public $SubSerie;
    public $Numero;
    public $UF;
    public $CPFCNPJNF;
    public $InscricaoNF;
    public $DataNF;
    public $ModeloNF;
    public $SerieNF;
    public $NumeroNF;
    public $UFNF;
    public $ValorNF;
}

class TRegistro60A {
    public $Emissao;
    public $NumSerie;
    public $StAliquota;
    public $Valor;
}

class TRegistro60I {
    public $Emissao;
    public $NumSerie;
    public $ModeloDoc;
    public $Cupom;
    public $Item;
    public $Codigo;
    public $Quantidade;
    public $Valor;
    public $BaseDeCalculo;
    public $StAliquota;
    public $ValorIcms;
}

class TRegistro60D {
    public $Emissao;
    public $NumSerie;
    public $Codigo;
    public $Quantidade;
    public $Valor;
    public $BaseDeCalculo;
    public $StAliquota;
    public $ValorIcms;
}

class TRegistro60R {
    public $MesAno;
    public $Codigo;
    public $Qtd;
    public $Valor;
    public $BaseDeCalculo;
    public $Aliquota;
}

class TRegistro60M {
    public $Registros60A;
    public $Registros60D;
    public $Registros60I;
    
    public $Emissao;
    public $NumSerie;
    public $NumOrdem;
    public $ModeloDoc;
    public $CooInicial;
    public $CooFinal;
    public $CRZ;
    public $CRO;
    public $VendaBruta;
    public $ValorGT;

    public function __construct(){
		$this->Registros60A=new TRegistros60A();
		$this->Registros60D=new TRegistros60D();
		$this->Registros60I=new TRegistros60I();
	}
}

class TRegistro61 {
    public $Emissao;
    public $Modelo;
    public $Serie;
    public $SubSerie;
    public $NumOrdemInicial;
    public $NumOrdemFinal;
    public $Valor;
    public $BaseDeCalculo;
    public $ValorIcms;
    public $Isentas;
    public $Outras;
    public $Aliquota;
}

class TRegistro61R {
    public $MesAno;
    public $Codigo;
    public $Qtd;
    public $Valor;
    public $BaseDeCalculo;
    public $Aliquota;
}

class TRegistro85 {
    public $Declaracao;
    public $DataDeclaracao;
    public $NaturezaExportacao;
    public $RegistroExportacao;
    public $DataRegistro;
    public $Conhecimento;
    public $DataConhecimento;
    public $TipoConhecimento;
    public $Pais;
    public $DataAverbacao;
    public $NumeroNotaFiscal;
    public $DataNotaFiscal;
    public $Modelo;
    public $Serie;
}

class TRegistro86 {
    public $RegistroExportacao;
    public $DataRegistro;
    public $CPFCNPJ;
    public $Inscricao;
    public $UF;
    public $NumeroNotaFiscal;
    public $DataDocumento;
    public $Modelo;
    public $Serie;
    public $Codigo;
    public $Quantidade;
    public $ValorUnitario;
    public $ValorTotalProduto;
    public $Relacionamento;
}

class TRegistro88Ean {
    public $VersaoEan;
    public $Codigo;
    public $Descricao;
    public $Unidade;
    public $CodigoBarras;
	
	public function __construct(){
		$this->VersaoEan=TVersaoEan::$eanIndefinido;
	}
}

//Lista de objetos do tipo Registro88C
class TRegistros88C extends TObjectList {
	public function __construct(){
		$this->type="TRegistro88C";
	}
}

//Lista de objetos do tipo Registro88D
class TRegistros88D extends TObjectList {
	public function __construct(){
		$this->type="TRegistro88D";
	}
}

//Lista de objetos do tipo Registro88E
class TRegistros88E extends TObjectList {
	public function __construct(){
		$this->type="TRegistro88E";
	}
}

//Lista de objetos do tipo Registro88D
class TRegistros88T extends TObjectList {
	public function __construct(){
		$this->type="TRegistro88T";
	}
}

//Lista de objetos do tipo Registro54
class TRegistros54 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro54";
	}
}

//Lista de objetos do tipo Registro55
class TRegistros55 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro55";
	}
}

//Lista de objetos do tipo Registro56
class TRegistros56 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro56";
	}
}

//Lista de objetos do tipo Registro74
class TRegistros74 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro74";
	}
	public function Sort(){
		$this->_container=$this->container;
		$this->_order=array();
		for ($i=0;$i<count($this->_container);$i++){
			$_b=array($this->_container[$i]->Data,$this->_container[$i]->Codigo,$i);
			array_push($this->_order,$_b);
		}
		parent::Sort();
	}
}

//Lista de objetos do tipo Registro54
class TRegistros75 extends TObjectList {
	private function GetRegistroExiste($codigo){
		$res=false;
		for($i=0;$i<count($this->container);$i++){
			if ($this->container[$i]->Codigo==$codigo){
				$res=true;
				break;
			}
		}
		return $res;
	}

	public function __construct(){
		$this->type="TRegistro75";
	}
	public function Add($obj){
		if (get_class($obj)!=$this->type) throw new Exception('Objeto deve ser do tipo '.$this->type);
		if (!$this->GetRegistroExiste($obj->Codigo)){
			parent::Add($obj);
		}
	}
	public function Sort(){
		$this->_container=$this->container;
		$this->_order=array();
		for ($i=0;$i<count($this->_container);$i++){
			$_b=array($this->_container[$i]->Codigo,$i);
			array_push($this->_order,$_b);
		}
		parent::Sort();
	}
}

//Lista de objetos do tipo Registro76
class TRegistros76 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro76";
	}
}

//Lista de objetos do tipo Registro77
class TRegistros77 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro77";
	}
}

//Lista de objetos do tipo Registro50
class TRegistros50 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro50";
	}
	public function Sort(){
		$this->_container=$this->container;
		$this->_order=array();
		for ($i=0;$i<count($this->_container);$i++){
			$_b=array($this->_container[$i]->DataDocumento,$this->_container[$i]->Numero,$i);
			array_push($this->_order,$_b);
		}
		parent::Sort();
	}
}

//Lista de objetos do tipo Registro51
class TRegistros51 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro51";
	}
	public function Sort(){
		$this->_container=$this->container;
		$this->_order=array();
		for ($i=0;$i<count($this->_container);$i++){
			$_b=array($this->_container[$i]->DataDocumento,$i);
			array_push($this->_order,$_b);
		}
		parent::Sort();
	}
}

//Lista de objetos do tipo Registro53
class TRegistros53 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro53";
	}
	public function Sort(){
		$this->_container=$this->container;
		$this->_order=array();
		for ($i=0;$i<count($this->_container);$i++){
			$_b=array($this->_container[$i]->DataDocumento,$i);
			array_push($this->_order,$_b);
		}
		parent::Sort();
	}
}

//Lista de objetos do tipo Registro70
class TRegistros70 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro70";
	}
	public function Sort(){
		$this->_container=$this->container;
		$this->_order=array();
		for ($i=0;$i<count($this->_container);$i++){
			$_b=array($this->_container[$i]->DataDocumento,$i);
			array_push($this->_order,$_b);
		}
		parent::Sort();
	}
}

//Lista de objetos do tipo Registro71
class TRegistros71 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro71";
	}
	public function Sort(){
		$this->_container=$this->container;
		$this->_order=array();
		for ($i=0;$i<count($this->_container);$i++){
			$_b=array($this->_container[$i]->DataDocumento,$i);
			array_push($this->_order,$_b);
		}
		parent::Sort();
	}
}

//Lista de objetos do tipo Registro60A
class TRegistros60A extends TObjectList {
	public function __construct(){
		$this->type="TRegistro60A";
	}
	public function Sort(){
		$this->_container=$this->container;
		$this->_order=array();
		for ($i=0;$i<count($this->_container);$i++){
			$_b=array($this->_container[$i]->Emissao,$this->_container[$i]->NumSerie,$i);
			array_push($this->_order,$_b);
		}
		parent::Sort();
	}
}

//Lista de objetos do tipo Registro60I
class TRegistros60I extends TObjectList {
	public function __construct(){
		$this->type="TRegistro60I";
	}
	public function Sort(){
		$this->_container=$this->container;
		$this->_order=array();
		for ($i=0;$i<count($this->_container);$i++){
			$_b=array($this->_container[$i]->Emissao,$this->_container[$i]->NumSerie,$i);
			array_push($this->_order,$_b);
		}
		parent::Sort();
	}
}

//Lista de objetos do tipo Registro60D
class TRegistros60D extends TObjectList {
	public function __construct(){
		$this->type="TRegistro60D";
	}
	public function Sort(){
		$this->_container=$this->container;
		$this->_order=array();
		for ($i=0;$i<count($this->_container);$i++){
			$_b=array($this->_container[$i]->Emissao,$this->_container[$i]->NumSerie,$i);
			array_push($this->_order,$_b);
		}
		parent::Sort();
	}
}

//Lista de objetos do tipo Registro60R
class TRegistros60R extends TObjectList {
	public function __construct(){
		$this->type="TRegistro60R";
	}
}

//Lista de objetos do tipo Registro60M
class TRegistros60M extends TObjectList {
	public function __construct(){
		$this->type="TRegistro60M";
	}
	public function Sort(){
		$this->_container=$this->container;
		$this->_order=array();
		for ($i=0;$i<count($this->_container);$i++){
			$_b=array($this->_container[$i]->Emissao,$i);
			array_push($this->_order,$_b);
		}
		parent::Sort();
	}
}

//Lista de objetos do tipo Registro61
class TRegistros61 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro61";
	}
}

//Lista de objetos do tipo Registros61R
class TRegistros61R extends TObjectList {
	public function __construct(){
		$this->type="TRegistro61R";
	}
}

//Lista de objetos do tipo Registro85
class TRegistros85 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro85";
	}
}

//Lista de objetos do tipo Registro86
class TRegistros86 extends TObjectList {
	public function __construct(){
		$this->type="TRegistro86";
	}
	public function Sort(){
		$this->_container=$this->container;
		$this->_order=array();
		for ($i=0;$i<count($this->_container);$i++){
			$_b=array($this->_container[$i]->DataRegistro,$i);
			array_push($this->_order,$_b);
		}
		parent::Sort();
	}
}

//Lista de objetos do tipo Registros88Ean
class TRegistros88Ean extends TRegistros75 {
	public function __construct(){
		$this->type="TRegistro88Ean";
	}
}


class TSintegra {
	private $file;
	private $wtotal90;
	private $wseque90;

    public $Registro10;
    public $Registro11;

    public $Registros50;
    public $Registros51;
    public $Registros53;

    public $Registros54;
    public $Registros55;
    public $Registros56;

    public $Registros60M;
    public $Registros60A;
    public $Registros60D;
    public $Registros60I;
    public $Registros60R;
    public $Registros61;
    public $Registros61R;
    public $Registros70;
    public $Registros71;
    public $Registros74;
    public $Registros75;
    public $Registros76;
    public $Registros77;

    public $Registros85;
    public $Registros86;
    public $Registros88Ean;
    public $Registro88EC;
    public $Registro88SF;
    public $Registros88C;
    public $Registros88D;
    public $Registros88E;
    public $Registros88T;
	
    //public $FileName;
    public $VersaoValidador; //TVersaoValidador;
    public $Informa88SME=false;
    public $Informa88SMS=false;
    public $Informa88EAN=false;
    public $Informa88C=false;

    public function __construct(){
		$this->Registro10=new TRegistro10();
		$this->Registro11=new TRegistro11();

		$this->Registros50=new TRegistros50();
		$this->Registros51=new TRegistros51();
		$this->Registros53=new TRegistros53();
		$this->Registros54=new TRegistros54();
		$this->Registros55=new TRegistros55();
		$this->Registros56=new TRegistros56();
		$this->Registros60M=new TRegistros60M();
		$this->Registros60A=new TRegistros60A();
		$this->Registros60D=new TRegistros60D();
		$this->Registros60I=new TRegistros60I();
		$this->Registros60R=new TRegistros60R();
		$this->Registros61=new TRegistros61();
		$this->Registros61R=new TRegistros61R();
		$this->Registros70=new TRegistros70();
		$this->Registros71=new TRegistros71();
		$this->Registros74=new TRegistros74();
		$this->Registros75=new TRegistros75();
		$this->Registros76=new TRegistros76();
		$this->Registros77=new TRegistros77();
		$this->Registros85=new TRegistros85();
		$this->Registros86=new TRegistros86();
		$this->Registros88Ean=new TRegistros88Ean();
		$this->Registro88EC=new TRegistro88EC();
		$this->Registro88SF=new TRegistro88SF();
		$this->Registros88C=new TRegistros88C();
		$this->Registros88D=new TRegistros88D();
		$this->Registros88E=new TRegistros88E();
		$this->Registros88T=new TRegistros88T();
		//
		$this->VersaoValidador=TVersaoValidador::$vv524;
	}
	//
	private function WriteRecord($_rec){
		
		echo "rec: ".$_rec;
		
		if (strlen($_rec)!=126) throw new Exception('Registro inválido! Deve conter 126 posições. Registro: '.$_rec.' possui '.(string)strlen($_rec).' posições.');
		
		if (!$this->Debug){
			//fwrite($this->file,$_rec);
			//fwrite($this->file,chr(13).chr(10));
			gzwrite($this->file, $_rec);
			gzwrite($this->file, chr(13).chr(10));
			//echo chr(13).chr(10);
		}
		else{
			echo $_rec;
			echo "<br>";
		}
	}
	
	private function GeraRegistro10(){
	
		$wregistro='10';	
		$wregistro.=  str_pad(TUtil::UnMask($this->Registro10->CNPJ,'/-.)(,'), 14, "0", STR_PAD_LEFT);
		$wregistro.=  str_pad(trim(TUtil::UnMask($this->Registro10->Inscricao,'/-.)(,')), 14, " ", STR_PAD_RIGHT);
		$wregistro.=  str_pad(substr($this->Registro10->RazaoSocial,0,35),35, " ", STR_PAD_RIGHT);
		$wregistro.=  str_pad(substr($this->Registro10->Cidade,0,30),30, " ", STR_PAD_RIGHT);
		$wregistro.=  str_pad($this->Registro10->Estado,2, " ", STR_PAD_RIGHT);
		$wregistro.=  str_pad(TUtil::UnMask($this->Registro10->Telefone,'/-.)(,'),10, "0", STR_PAD_LEFT);
		$wregistro.=  substr($this->Registro10->DataInicial,0,4).substr($this->Registro10->DataInicial,5,2).substr($this->Registro10->DataInicial,8,2);
		$wregistro.=  substr($this->Registro10->DataFinal,0,4).substr($this->Registro10->DataFinal,5,2).substr($this->Registro10->DataFinal,8,2);
		$wregistro.=  str_pad($this->Registro10->CodigoConvenio,1, " ", STR_PAD_RIGHT);
		$wregistro.=  str_pad($this->Registro10->NaturezaInformacoes,1, " ", STR_PAD_RIGHT);
		$wregistro.=  str_pad($this->Registro10->FinalidadeArquivo,1, " ", STR_PAD_RIGHT);
		$this->WriteRecord($wregistro);
	}
	private function GeraRegistro11(){
		$wregistro='11';
		$wregistro.=TUtil::Pad(substr($this->Registro11->Endereco,0,34),34,' ',TUtil::$LeftPad);
		$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registro11->Numero,'/-.)(,'),5,'0',TUtil::$RightPad);
		$wregistro.=TUtil::Pad(substr($this->Registro11->Complemento,0,22),22,' ',TUtil::$LeftPad);
		$wregistro.=TUtil::Pad(substr($this->Registro11->Bairro,0,15),15,' ',TUtil::$LeftPad);
		$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registro11->Cep,'/-.)(,'),8,'0',TUtil::$RightPad);
		$wregistro.=TUtil::Pad(substr($this->Registro11->Responsavel,0,28),28,' ',TUtil::$LeftPad);
		$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registro11->Telefone,'/-.)(,'),12,'0',TUtil::$RightPad);
		//
		$this->WriteRecord($wregistro);
	}
	private function GerarRegistros50(){
		//Registro 50 requer ordenacao por data do documento
		//$this->Registros50->Sort(); //removido temporariamente por questoes de erro de soma no validador
		for($i=0;$i<$this->Registros50->Count();$i++){
			$wregistro='50';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros50->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registros50->Get($i)->Inscricao,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=substr($this->Registros50->Get($i)->DataDocumento,0,4).substr($this->Registros50->Get($i)->DataDocumento,5,2).substr($this->Registros50->Get($i)->DataDocumento,8,2);
			$wregistro.=TUtil::Pad($this->Registros50->Get($i)->UF,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros50->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros50->Get($i)->Serie,3,'0',TUtil::$RightPad);
			
			// $tam = strlen($this->Registros50->Get($i)->Numero);
			// $ini = ($tam>6) ? $tam-6 : 0;
			// $wregistro.=str_pad(substr($this->Registros50->Get($i)->Numero, $ini, $tam),6,'0',STR_PAD_LEFT);
			
			$wregistro.=TUtil::Pad(TUtil::RightStr($this->Registros50->Get($i)->Numero,6),6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros50->Get($i)->CFOP,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros50->Get($i)->EmissorDocumento,1,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros50->Get($i)->ValorContabil),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros50->Get($i)->BaseDeCalculo),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros50->Get($i)->Icms),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros50->Get($i)->Isentas),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros50->Get($i)->Outras),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros50->Get($i)->Aliquota),'/-.)(,'),4,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros50->Get($i)->Situacao,1,' ',TUtil::$LeftPad);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros51(){
		$this->Registros51->Sort();
		for($i=0;$i<$this->Registros51->Count();$i++){
			$wregistro='51';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros51->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registros51->Get($i)->Inscricao,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=substr($this->Registros51->Get($i)->DataDocumento,0,4).substr($this->Registros51->Get($i)->DataDocumento,5,2).substr($this->Registros51->Get($i)->DataDocumento,8,2);
			$wregistro.=TUtil::Pad($this->Registros51->Get($i)->Estado,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros51->Get($i)->Serie,3,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::RightStr($this->Registros51->Get($i)->Numero,6),6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros51->Get($i)->CFOP,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros51->Get($i)->ValorContabil),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros51->Get($i)->ValorIpi),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros51->Get($i)->ValorIsentas),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros51->Get($i)->ValorOutras),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=str_repeat(' ',20);
			$wregistro.=TUtil::Pad($this->Registros51->Get($i)->Situacao,1,' ',TUtil::$LeftPad);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros53(){
		$this->Registros53->Sort();
		for($i=0;$i<$this->Registros53->Count();$i++){
			$wregistro='53';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros53->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registros53->Get($i)->Inscricao,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=substr($this->Registros53->Get($i)->DataDocumento,0,4).substr($this->Registros53->Get($i)->DataDocumento,5,2).substr($this->Registros53->Get($i)->DataDocumento,8,2);
			$wregistro.=TUtil::Pad($this->Registros53->Get($i)->Estado,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros53->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros53->Get($i)->Serie,3,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::RightStr($this->Registros53->Get($i)->Numero,6),6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros53->Get($i)->CFOP,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros53->Get($i)->Emitente,1,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros53->Get($i)->BaseST),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros53->Get($i)->IcmsRetido),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros53->Get($i)->Despesas),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros53->Get($i)->Situacao,1,' ',TUtil::$LeftPad);
			// $wregistro.=TUtil::Pad($this->Registros53->Get($i)->CodigoAntecipacao,1,' ',TUtil::$LeftPad);
			$wregistro.=str_repeat(' ',30);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros54(){
		for($i=0;$i<$this->Registros54->Count();$i++){
			$wregistro='54';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros54->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros54->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros54->Get($i)->Serie,3,'0',TUtil::$RightPad);
			// $wregistro.=TUtil::Pad(str_pad($this->Registros54->Get($i)->Numero,6,'0',STR_PAD_LEFT),6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::RightStr($this->Registros54->Get($i)->Numero,6),6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros54->Get($i)->CFOP,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros54->Get($i)->CST,3,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros54->Get($i)->NumeroItem,3,'0',TUtil::$RightPad);
//			if ($this->Registros54->Get($i)->NumeroItem<=990)
				$wregistro.=TUtil::Pad($this->Registros54->Get($i)->Codigo,14,' ',TUtil::$LeftPad); //codigo do produto
//			else
//				$wregistro.=str_repeat(' ',14);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.3f',$this->Registros54->Get($i)->Quantidade,3),'/-.)(,'),11,'0',TUtil::$RightPad); //quantidade do produto
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros54->Get($i)->Valor),'/-.)(,'),12,'0',TUtil::$RightPad); //total do produto
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros54->Get($i)->ValorDescontoDespesa),'/-.)(,'),12,'0',TUtil::$RightPad); //desconto/despesa
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros54->Get($i)->BaseDeCalculo),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros54->Get($i)->BaseST),'/-.)(,'),12,'0',TUtil::$RightPad);  //base de calculo substituicao tributária
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros54->Get($i)->ValorIpi),'/-.)(,'),12,'0',TUtil::$RightPad);  //valor do ipi
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros54->Get($i)->Aliquota),'/-.)(,'),4,'0',TUtil::$RightPad);
			//
			$this->WriteRecord($wregistro);
			for($j=0;$j<$this->Registros56->Count();$j++){
				if ($this->Registros56->Get($j)->CFOP==$this->Registros54->Get($i)->CFOP &&
					$this->Registros56->Get($j)->Modelo==$this->Registros54->Get($i)->Modelo &&
					$this->Registros56->Get($j)->Serie==$this->Registros54->Get($i)->Serie &&
					$this->Registros56->Get($j)->Numero==$this->Registros54->Get($i)->Numero &&
					$this->Registros56->Get($j)->NumeroItem==$this->Registros54->Get($i)->NumeroItem){
					$wregistro='56';
					$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros56->Get($j)->CNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
					$wregistro.=TUtil::Pad($this->Registros56->Get($j)->Modelo,2,'0',TUtil::$RightPad);
					$wregistro.=TUtil::Pad($this->Registros56->Get($j)->Serie,3,'0',TUtil::$RightPad);
					$wregistro.=TUtil::Pad(TUtil::RightStr($this->Registros56->Get($j)->Numero,6),6,'0',TUtil::$RightPad);
					$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros56->Get($j)->CFOP,'/-.)(,'),4,' ',TUtil::$LeftPad);
					$wregistro.=TUtil::Pad($this->Registros56->Get($j)->CST,3,' ',TUtil::$LeftPad);
					$wregistro.=TUtil::Pad($this->Registros56->Get($j)->NumeroItem,3,'0',TUtil::$RightPad);
					$wregistro.=TUtil::Pad($this->Registros56->Get($j)->Codigo,14,' ',TUtil::$LeftPad); //codigo do produto
					$wregistro.=TUtil::Pad($this->Registros56->Get($j)->TipoOperacao,1,' ',TUtil::$LeftPad);
					$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros56->Get($j)->CnpjConcessionaria,'/-.)(,'),14,'0',TUtil::$RightPad);
					$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros56->Get($j)->Ipi),'/-.)(,'),4,'0',TUtil::$RightPad);
					$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros56->Get($j)->Chassi,'/-.)(,'),17,'0',TUtil::$RightPad);
					$wregistro.=str_repeat(' ',39);
					//
					$this->WriteRecord($wregistro);
				}
			}
		}
	}
	private function GerarRegistros55(){
		for($i=0;$i<$this->Registros55->Count();$i++){
			$wregistro='55';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros55->Get($i)->CNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registros55->Get($i)->Inscricao,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=substr($this->Registros55->Get($i)->DataPagamento,0,4).substr($this->Registros55->Get($i)->DataPagamento,5,2).substr($this->Registros55->Get($i)->DataPagamento,8,2);
			$wregistro.=TUtil::Pad($this->Registros55->Get($i)->UF,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros55->Get($i)->UFFavorecida,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros55->Get($i)->Banco,3,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros55->Get($i)->Agencia,4,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros55->Get($i)->Numero,20,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros55->Get($i)->Valor),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=substr($this->Registros55->Get($i)->Vencimento,0,4).substr($this->Registros55->Get($i)->Vencimento,5,2).substr($this->Registros55->Get($i)->Vencimento,8,2);
			$wregistro.=TUtil::Pad($this->Registros55->Get($i)->MesAno,6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros55->Get($i)->NumeroConvenio,30,' ',TUtil::$LeftPad);
			//
			$this->WriteRecord($wregistro);
		}
	}

	private function GerarRegistros60M($reg60M){
		$wregistro='60M';
		$wregistro.=substr($reg60M->Emissao,0,4).substr($reg60M->Emissao,5,2).substr($reg60M->Emissao,8,2);
		$wregistro.=TUtil::Pad(trim($reg60M->NumSerie),20,' ',TUtil::$LeftPad);
		$wregistro.=TUtil::Pad($reg60M->NumOrdem,3,'0',TUtil::$RightPad);
		$wregistro.=TUtil::Pad(trim($reg60M->ModeloDoc),2,' ',TUtil::$LeftPad);	
		$wregistro.=TUtil::Pad($reg60M->CooInicial,6,'0',TUtil::$RightPad);
		$wregistro.=TUtil::Pad($reg60M->CooFinal,6,'0',TUtil::$RightPad);
		$wregistro.=TUtil::Pad($reg60M->CRZ,6,'0',TUtil::$RightPad);
		$wregistro.=TUtil::Pad($reg60M->CRO,3,'0',TUtil::$RightPad);
		$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$reg60M->VendaBruta),'/-.)(,'),16,'0',TUtil::$RightPad);
		$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$reg60M->ValorGT),'/-.)(,'),16,'0',TUtil::$RightPad);
		$wregistro.=str_repeat(' ',37);
		//
		$this->WriteRecord($wregistro);
	}
	private function GerarRegistros60A($regs60A){
		for($i=0;$i<$regs60A->Count();$i++){
			$wregistro='60A';
			$wregistro.=substr($regs60A->Get($i)->Emissao,0,4).substr($regs60A->Get($i)->Emissao,5,2).substr($regs60A->Get($i)->Emissao,8,2);
			$wregistro.=TUtil::Pad(trim($regs60A->Get($i)->NumSerie),20,' ',TUtil::$LeftPad);
			//$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$regs60A->Get($i)->StAliquota),'/-.)(,'),4,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($regs60A->Get($i)->StAliquota,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$regs60A->Get($i)->Valor),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=str_repeat(' ',79);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros60D($regs60D){
		for($i=0;$i<$regs60D->Count();$i++){
			$wregistro='60D';
			$wregistro.=substr($regs60D->Get($i)->Emissao,0,4).substr($regs60D->Get($i)->Emissao,5,2).substr($regs60D->Get($i)->Emissao,8,2);
			$wregistro.=TUtil::Pad(trim($regs60D->Get($i)->NumSerie),20,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($regs60D->Get($i)->Codigo,14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.3f',$regs60D->Get($i)->Quantidade),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$regs60D->Get($i)->Valor),'/-.)(,'),16,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$regs60D->Get($i)->BaseDeCalculo),'/-.)(,'),16,'0',TUtil::$RightPad);
			//$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$regs60D->Get($i)->StAliquota),'/-.)(,'),4,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($regs60D->Get($i)->StAliquota,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$regs60D->Get($i)->ValorIcms),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=str_repeat(' ',19);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros60I($regs60I){
		for($i=0;$i<$regs60I->Count();$i++){
			$wregistro='60I';
			$wregistro.=substr($regs60I->Get($i)->Emissao,0,4).substr($regs60I->Get($i)->Emissao,5,2).substr($regs60I->Get($i)->Emissao,8,2);
			$wregistro.=TUtil::Pad(trim($regs60I->Get($i)->NumSerie),20,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(trim($regs60I->Get($i)->ModeloDoc),2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($regs60I->Get($i)->Cupom,6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($regs60I->Get($i)->Item,3,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($regs60I->Get($i)->Codigo,14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.3f',$regs60I->Get($i)->Quantidade),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$regs60I->Get($i)->Valor),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$regs60I->Get($i)->BaseDeCalculo),'/-.)(,'),12,'0',TUtil::$RightPad);
			//$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$regs60I->Get($i)->StAliquota),'/-.)(,'),4,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($regs60I->Get($i)->StAliquota,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$regs60I->Get($i)->ValorIcms),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=str_repeat(' ',16);
			//
			$this->WriteRecord($wregistro);
		}
	}
	
	private function GetRegistro60M($emissao,$numSerie){
		$_res=null;
		for($i=0;$i<$this->Registros60M->Count();$i++){
			if ($this->Registros60M->Get($i)->Emissao==$emissao &&
				$this->Registros60M->Get($i)->NumSerie==$numSerie){
				$_res=$this->Registros60M->Get($i);
				break;
			}
		}
		return $_res;
	}
	private function GerarConjuntoRegistros60(){
		if ($this->VersaoValidador==TVersaoValidador::$vv524){
			//60A
			for($i=0;$i<$this->Registros60A->Count();$i++){
				$wregistro60M=$this->GetRegistro60M($this->Registros60A->Get($i)->Emissao,$this->Registros60A->Get($i)->NumSerie);
				if (!$wregistro60M) throw new Exception('Registro 60A sem registro 60M correspondente! '.$this->Registros60A->Get($i)->Emissao.' - '.$this->Registros60A->Get($i)->NumSerie);
				$wregistro60M->Registros60A->Add($this->Registros60A->Get($i));
			}
			//60D
			for($i=0;$i<$this->Registros60D->Count();$i++){
				$wregistro60M=$this->GetRegistro60M($this->Registros60D->Get($i)->Emissao,$this->Registros60D->Get($i)->NumSerie);
				if (!$wregistro60M) throw new Exception('Registro 60D sem registro 60M correspondente! '.$this->Registros60D->Get($i)->Emissao.' - '.$this->Registros60D->Get($i)->NumSerie);
				$wregistro60M->Registros60D->Add($this->Registros60D->Get($i));
			}
			//60I
			for($i=0;$i<$this->Registros60I->Count();$i++){
				$wregistro60M=$this->GetRegistro60M($this->Registros60I->Get($i)->Emissao,$this->Registros60I->Get($i)->NumSerie);
				if (!$wregistro60M) throw new Exception('Registro 60I sem registro 60M correspondente! '.$this->Registros60I->Get($i)->Emissao.' - '.$this->Registros60I->Get($i)->NumSerie);
				$wregistro60M->Registros60I->Add($this->Registros60I->Get($i));
			}
			
			//ordenando e gerando de acordo com o manual...
			$this->Registros60M->Sort();
			for($i=0;$i<$this->Registros60M->Count();$i++){
				//$this->Registros60M->Get($i)->Registros60A->Sort();
				//$this->Registros60M->Get($i)->Registros60D->Sort();
				//$this->Registros60M->Get($i)->Registros60I->Sort();
				
				$this->GerarRegistros60M($this->Registros60M->Get($i));
				$this->GerarRegistros60A($this->Registros60M->Get($i)->Registros60A);
				$this->GerarRegistros60D($this->Registros60M->Get($i)->Registros60D);
				$this->GerarRegistros60I($this->Registros60M->Get($i)->Registros60I);
			}
		}
		elseif ($this->VersaoValidador==TVersaoValidador::$vv523){
			//ordenando e gerando de acordo com o manual...
			$this->Registros60M->Sort();
			for($i=0;$i<$this->Registros60M->Count();$i++){
				$this->GerarRegistros60M($this->Registros60M->Get($i));
			}
			//$this->Registros60A->Sort();
			$this->GerarRegistros60A($this->Registros60A);
			//$this->Registros60D->Sort();
			$this->GerarRegistros60D($this->Registros60D);
			//$this->Registros60I->Sort();
			$this->GerarRegistros60I($this->Registros60I);
		}
	}
	private function GerarRegistros60R(){
		for($i=0;$i<$this->Registros60R->Count();$i++){
			$wregistro='60R';
			$wregistro.=TUtil::Pad($this->Registros60R->Get($i)->MesAno,6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros60R->Get($i)->Codigo,14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.3f',$this->Registros60R->Get($i)->Qtd),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros60R->Get($i)->Valor),'/-.)(,'),16,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros60R->Get($i)->BaseDeCalculo),'/-.)(,'),16,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros60R->Get($i)->Aliquota,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=str_repeat(' ',54);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros61(){
		for($i=0;$i<$this->Registros61->Count();$i++){
			$wregistro='61';
			$wregistro.=str_repeat(' ',28);
			$wregistro.=substr($this->Registros61->Get($i)->Emissao,0,4).substr($this->Registros61->Get($i)->Emissao,5,2).substr($this->Registros61->Get($i)->Emissao,8,2);
			$wregistro.=TUtil::Pad($this->Registros61->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros61->Get($i)->Serie,3,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros61->Get($i)->SubSerie,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros61->Get($i)->NumOrdemInicial,6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros61->Get($i)->NumOrdemFinal,6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros61->Get($i)->Valor),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros61->Get($i)->BaseDeCalculo),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros61->Get($i)->ValorIcms),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros61->Get($i)->Isentas),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros61->Get($i)->Outras),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros61->Get($i)->Aliquota),'/-.)(,'),4,'0',TUtil::$RightPad);
			$wregistro.=str_repeat(' ',1);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros61R(){
		for($i=0;$i<$this->Registros61R->Count();$i++){
			$wregistro='61R';
			$wregistro.=TUtil::Pad($this->Registros61R->Get($i)->MesAno,6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros61R->Get($i)->Codigo,14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.3f',$this->Registros61R->Get($i)->Qtd),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros61R->Get($i)->Valor),'/-.)(,'),16,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros61R->Get($i)->BaseDeCalculo),'/-.)(,'),16,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros61R->Get($i)->Aliquota,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=str_repeat(' ',54);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros70(){
		$this->Registros70->Sort();
		for($i=0;$i<$this->Registros70->Count();$i++){
			$wregistro='70';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros70->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registros70->Get($i)->Inscricao,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=substr($this->Registros70->Get($i)->DataDocumento,0,4).substr($this->Registros70->Get($i)->DataDocumento,5,2).substr($this->Registros70->Get($i)->DataDocumento,8,2);
			$wregistro.=TUtil::Pad($this->Registros70->Get($i)->UF,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros70->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(substr($this->Registros70->Get($i)->Serie,0,1),1,' ',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(substr($this->Registros70->Get($i)->SubSerie,0,2),2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::RightStr($this->Registros70->Get($i)->Numero,6),6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros70->Get($i)->CFOP,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros70->Get($i)->ValorContabil),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros70->Get($i)->BaseDeCalculo),'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros70->Get($i)->Icms),'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros70->Get($i)->Isentas),'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros70->Get($i)->Outras),'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros70->Get($i)->CifFobOutros,1,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros70->Get($i)->Situacao,1,' ',TUtil::$LeftPad);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros71(){
		$this->Registros71->Sort();
		for($i=0;$i<$this->Registros71->Count();$i++){
			$wregistro='71';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros71->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registros71->Get($i)->Inscricao,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=substr($this->Registros71->Get($i)->DataDocumento,0,4).substr($this->Registros71->Get($i)->DataDocumento,5,2).substr($this->Registros71->Get($i)->DataDocumento,8,2);
			$wregistro.=TUtil::Pad($this->Registros71->Get($i)->UF,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros71->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(substr($this->Registros71->Get($i)->Serie,0,1),1,' ',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(substr($this->Registros71->Get($i)->SubSerie,0,2),2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::RightStr($this->Registros71->Get($i)->Numero,6),6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros71->Get($i)->UFNF,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros71->Get($i)->CPFCNPJNF,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registros71->Get($i)->InscricaoNF,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=substr($this->Registros71->Get($i)->DataNF,0,4).substr($this->Registros71->Get($i)->DataNF,5,2).substr($this->Registros71->Get($i)->DataNF,8,2);
			$wregistro.=TUtil::Pad($this->Registros71->Get($i)->ModeloNF,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(substr($this->Registros71->Get($i)->SerieNF,0,3),3,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::RightStr($this->Registros71->Get($i)->NumeroNF,6),6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros71->Get($i)->ValorNF),'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=str_repeat(' ',12);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros74(){
		//$this->Registros74->Sort();
		for($i=0;$i<$this->Registros74->Count();$i++){
			$wregistro='74';
			$wregistro.=substr($this->Registros74->Get($i)->Data,0,4).substr($this->Registros74->Get($i)->Data,5,2).substr($this->Registros74->Get($i)->Data,8,2);
			$wregistro.=TUtil::Pad($this->Registros74->Get($i)->Codigo,14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.3f',$this->Registros74->Get($i)->Quantidade),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros74->Get($i)->ValorProduto),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros74->Get($i)->CodigoPosse,1,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros74->Get($i)->CNPJPossuidor,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registros74->Get($i)->InscricaoPossuidor,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros74->Get($i)->UFPossuidor,2,' ',TUtil::$LeftPad);
			$wregistro.=str_repeat(' ',45);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros75(){
		$this->Registros75->Sort();
		for($i=0;$i<$this->Registros75->Count();$i++){
			$wregistro='75';
			$wregistro.=substr($this->Registros75->Get($i)->DataInicial,0,4).substr($this->Registros75->Get($i)->DataInicial,5,2).substr($this->Registros75->Get($i)->DataInicial,8,2);
			$wregistro.=substr($this->Registros75->Get($i)->DataFinal,0,4).substr($this->Registros75->Get($i)->DataFinal,5,2).substr($this->Registros75->Get($i)->DataFinal,8,2);
			$wregistro.=TUtil::Pad($this->Registros75->Get($i)->Codigo,14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros75->Get($i)->NCM,8,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(substr(trim($this->Registros75->Get($i)->Descricao),0,53),53,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros75->Get($i)->Unidade,6,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros75->Get($i)->AliquotaIpi),'/-.)(,'),5,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros75->Get($i)->AliquotaIcms),'/-.)(,'),4,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros75->Get($i)->Reducao),'/-.)(,'),5,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros75->Get($i)->BaseST),'/-.)(,'),13,'0',TUtil::$RightPad);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros76(){
		for($i=0;$i<$this->Registros76->Count();$i++){
			$wregistro='76';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros76->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registros76->Get($i)->Inscricao,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros76->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros76->Get($i)->Serie,2,' ',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros76->Get($i)->SubSerie,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros76->Get($i)->Numero,10,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros76->Get($i)->CFOP,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros76->Get($i)->TipoReceita,1,'0',TUtil::$RightPad);
			$wregistro.=substr($this->Registros76->Get($i)->DataDocumento,0,4).substr($this->Registros76->Get($i)->DataDocumento,5,2).substr($this->Registros76->Get($i)->DataDocumento,8,2);
			$wregistro.=TUtil::Pad($this->Registros76->Get($i)->UF,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros76->Get($i)->ValorTotal),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros76->Get($i)->BaseDeCalculo),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros76->Get($i)->Icms),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros76->Get($i)->Isentas),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros76->Get($i)->Outras),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros76->Get($i)->Aliquota,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros76->Get($i)->Situacao,1,' ',TUtil::$LeftPad);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros77(){
		
		for($i=0;$i<$this->Registros77->Count();$i++){
			$wregistro='77';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros77->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros77->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros77->Get($i)->Serie,2,' ',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros77->Get($i)->SubSerie,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros77->Get($i)->Numero,10,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros77->Get($i)->CFOP,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros77->Get($i)->TipoReceita,1,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros77->Get($i)->NumeroItem,3,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros77->Get($i)->Codigo,11,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.3f',$this->Registros77->Get($i)->Quantidade),'/-.)(,'),13,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros77->Get($i)->ValorServico),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros77->Get($i)->ValorDesconto),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros77->Get($i)->BaseDeCalculo),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros77->Get($i)->Aliquota,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros77->Get($i)->CNPJMF,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros77->Get($i)->NumeroTerminal,10,'0',TUtil::$RightPad);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros85(){
		for($i=0;$i<$this->Registros85->Count();$i++){
			$wregistro='85';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros85->Get($i)->Declaracao,'/-.)(,'),11,'0',TUtil::$RightPad);
			$wregistro.=substr($this->Registros85->Get($i)->DataDeclaracao,0,4).substr($this->Registros85->Get($i)->DataDeclaracao,5,2).substr($this->Registros85->Get($i)->DataDeclaracao,8,2);
			$wregistro.=TUtil::Pad($this->Registros85->Get($i)->NaturezaExportacao,1,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros85->Get($i)->RegistroExportacao,12,' ',TUtil::$LeftPad);
			$wregistro.=substr($this->Registros85->Get($i)->DataRegistro,0,4).substr($this->Registros85->Get($i)->DataRegistro,5,2).substr($this->Registros85->Get($i)->DataRegistro,8,2);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros85->Get($i)->Conhecimento,'/-.)(,'),16,'0',TUtil::$RightPad);
			$wregistro.=substr($this->Registros85->Get($i)->DataConhecimento,0,4).substr($this->Registros85->Get($i)->DataConhecimento,5,2).substr($this->Registros85->Get($i)->DataConhecimento,8,2);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros85->Get($i)->TipoConhecimento,'/-.)(,'),2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros85->Get($i)->Pais,'/-.)(,'),4,'0',TUtil::$RightPad);
			$wregistro.=str_repeat(' ',8);
			$wregistro.=substr($this->Registros85->Get($i)->DataAverbacao,0,4).substr($this->Registros85->Get($i)->DataAverbacao,5,2).substr($this->Registros85->Get($i)->DataAverbacao,8,2);
			$wregistro.=TUtil::Pad($this->Registros85->Get($i)->NumeroNotaFiscal,6,'0',TUtil::$RightPad);
			$wregistro.=substr($this->Registros85->Get($i)->DataNotaFiscal,0,4).substr($this->Registros85->Get($i)->DataNotaFiscal,5,2).substr($this->Registros85->Get($i)->DataNotaFiscal,8,2);
			$wregistro.=TUtil::Pad($this->Registros85->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(substr($this->Registros85->Get($i)->Serie,0,3),3,' ',TUtil::$RightPad);
			$wregistro.=str_repeat(' ',19);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros86(){
		for($i=0;$i<$this->Registros86->Count();$i++){
			$wregistro='86';
			$wregistro.=TUtil::Pad($this->Registros86->Get($i)->RegistroExportacao,12,' ',TUtil::$LeftPad);
			$wregistro.=substr($this->Registros86->Get($i)->DataRegistro,0,4).substr($this->Registros86->Get($i)->DataRegistro,5,2).substr($this->Registros86->Get($i)->DataRegistro,8,2);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros86->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registros86->Get($i)->Inscricao,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros86->Get($i)->UF,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros86->Get($i)->NumeroNotaFiscal,6,'0',TUtil::$RightPad);
			$wregistro.=substr($this->Registros86->Get($i)->DataDocumento,0,4).substr($this->Registros86->Get($i)->DataDocumento,5,2).substr($this->Registros86->Get($i)->DataDocumento,8,2);
			$wregistro.=TUtil::Pad($this->Registros86->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(substr($this->Registros86->Get($i)->Serie,0,3),3,' ',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros86->Get($i)->Codigo,14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.3f',$this->Registros86->Get($i)->Quantidade),'/-.)(,'),11,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros86->Get($i)->ValorUnitario),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros86->Get($i)->ValorTotalProduto),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros86->Get($i)->Relacionamento,1,' ',TUtil::$LeftPad);
			$wregistro.=str_repeat(' ',5);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros88Ean(){
		for($i=0;$i<$this->Registros88Ean->Count();$i++){
			$wregistro='88EAN';
			if ($this->Registros88Ean->Get($i)->VersaoEan==TVersaoEan::$eanIndefinido){
				switch (strlen($this->Registros88Ean->Get($i)->CodigoBarras)){
					case 8:
						$wregistro.='08';
						break;
					case 12:
						$wregistro.='12';
						break;
					case 13:
						$wregistro.='13';
						break;
					case 14:
						$wregistro.='14';
						break;
					default:
						$wregistro.='13';
						break;
				}
			}
			else{
				switch ($this->Registros88Ean->Get($i)->VersaoEan){
					case TVersaoEan::$ean8:
						$wregistro.='08';
						break;
					case TVersaoEan::$ean12:
						$wregistro.='12';
						break;
					case TVersaoEan::$ean13:
						$wregistro.='13';
						break;
					case TVersaoEan::$ean14:
						$wregistro.='14';
						break;
				}
			}
			$wregistro.=TUtil::Pad($this->Registros88Ean->Get($i)->Codigo,14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros88Ean->Get($i)->Descricao,53,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88Ean->Get($i)->Unidade,6,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88Ean->Get($i)->CodigoBarras,14,' ',TUtil::$LeftPad);
			$wregistro.=str_repeat(' ',32);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistro88EC(){
		for($i=0;$i<$this->Registro88EC->Count();$i++){
			$wregistro='88EC';
			$wregistro.=TUtil::Pad(substr($this->Registro88EC->Get($i)->NomeContabilista,0,39),39,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registro88EC->Get($i)->CPFContabilista,'/-.)(,')),11,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(substr($this->Registro88EC->Get($i)->CRCContabilista,0,10),10,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(substr($this->Registro88EC->Get($i)->TelefoneContabilista,0,11),11,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(substr($this->Registro88EC->Get($i)->EmailContabilista,0,50),50,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registro88EC->Get($i)->AlteraContabilista,1,'0',TUtil::$RightPad);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistro88SF(){
		for($i=0;$i<$this->Registro88SF->Count();$i++){
			$wregistro='88SF';
			$wregistro.=TUtil::Pad(substr($this->Registro88SF->Get($i)->NomeEmpresa,0,35),35,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registro88SF->Get($i)->CNPJEmpresa,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registro88SF->Get($i)->CPFTecnico,'/-.)(,')),11,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(substr($this->Registro88SF->Get($i)->TelefoneEmpresa,0,11),11,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(substr($this->Registro88SF->Get($i)->EmailEmpresa,0,50),50,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registro88SF->Get($i)->AlteraEmpresa,1,'0',TUtil::$RightPad);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistro88SME(){
			$wregistro='88SME';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registro10->CNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad('Sem Movimento de Entradas',34,' ',TUtil::$LeftPad);
			$wregistro.=str_repeat(' ',73);
			//
			$this->WriteRecord($wregistro);
	}
	private function GerarRegistro88SMS(){
			$wregistro='88SMS';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registro10->CNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad('Sem Movimento de Saídas',34,' ',TUtil::$LeftPad);
			$wregistro.=str_repeat(' ',73);
			//
			$this->WriteRecord($wregistro);
	}
	private function GerarRegistros88C(){
		for($i=0;$i<$this->Registros88C->Count();$i++){
			$wregistro='88C';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros88C->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros88C->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(substr($this->Registros88C->Get($i)->Serie,0,3),3,' ',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::RightStr($this->Registros88C->Get($i)->Numero,6),6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros88C->Get($i)->CFOP,'/-.)(,'),4,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88C->Get($i)->NumeroItem,3,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros88C->Get($i)->Codigo,14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.3f',$this->Registros88C->Get($i)->Quantidade),'/-.)(,'),11,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros88C->Get($i)->BaseST),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros88C->Get($i)->ValorIcmsSTRepassar),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros88C->Get($i)->ValorIcmsSTComplementar),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros88C->Get($i)->BaseDeCalculoRetencao),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask(sprintf('%.2f',$this->Registros88C->Get($i)->ValorParcelaImpostoRetido),'/-.)(,'),12,'0',TUtil::$RightPad);
			$wregistro.=str_repeat(' ',6);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros88D(){
		for($i=0;$i<$this->Registros88D->Count();$i++){
			$wregistro='88D';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros88D->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registros88D->Get($i)->Inscricao,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88D->Get($i)->UF,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88D->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(substr($this->Registros88D->Get($i)->Serie,0,3),3,' ',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::RightStr($this->Registros88D->Get($i)->Numero,6),6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros88D->Get($i)->EmissorDocumento,1,' ',TUtil::$LeftPad);
			$wregistro.=substr($this->Registros88D->Get($i)->DataDocumento,0,4).substr($this->Registros88D->Get($i)->DataDocumento,5,2).substr($this->Registros88D->Get($i)->DataDocumento,8,2);
			$wregistro.=substr($this->Registros88D->Get($i)->DataSaidaEntrada,0,4).substr($this->Registros88D->Get($i)->DataSaidaEntrada,5,2).substr($this->Registros88D->Get($i)->DataSaidaEntrada,8,2);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros88D->Get($i)->CNPJLocalSaida,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros88D->Get($i)->UFLocalSaida,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros88D->Get($i)->IeLocalSaida,'/-.)(,'),14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros88D->Get($i)->CNPJLocalEntrega,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros88D->Get($i)->UFLocalEntrega,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros88D->Get($i)->IeLocalEntrega,'/-.)(,'),14,' ',TUtil::$LeftPad);
			$wregistro.=str_repeat(' ',5);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros88E(){
		for($i=0;$i<$this->Registros88E->Count();$i++){
			$wregistro='88E';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros88E->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registros88E->Get($i)->Inscricao,'/-.)(,')),14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88E->Get($i)->CodigoInformante,14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88E->Get($i)->CodigoSefaz,14,' ',TUtil::$LeftPad);
			$wregistro.=str_repeat(' ',67);
			//
			$this->WriteRecord($wregistro);
		}
	}
	private function GerarRegistros88T(){
		for($i=0;$i<$this->Registros88T->Count();$i++){
			$wregistro='88T';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros88T->Get($i)->CPFCNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=substr($this->Registros88T->Get($i)->DataDocumento,0,4).substr($this->Registros88T->Get($i)->DataDocumento,5,2).substr($this->Registros88T->Get($i)->DataDocumento,8,2);
			$wregistro.=TUtil::Pad($this->Registros88T->Get($i)->UF,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88T->Get($i)->Modelo,2,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(substr($this->Registros88T->Get($i)->Serie,0,3),3,' ',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(TUtil::RightStr($this->Registros88T->Get($i)->Numero,6),6,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros88T->Get($i)->EmissorDocumento,1,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88T->Get($i)->CifFob,1,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros88T->Get($i)->CPFCNPJFrete,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros88T->Get($i)->UFFrete,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registros88T->Get($i)->IeFrete,'/-.)(,'),14,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88T->Get($i)->Modal,1,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad($this->Registros88T->Get($i)->Placa1,7,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88T->Get($i)->UFPlaca1,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88T->Get($i)->Placa2,7,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88T->Get($i)->UFPlaca2,2,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88T->Get($i)->Placa3,7,' ',TUtil::$LeftPad);
			$wregistro.=TUtil::Pad($this->Registros88T->Get($i)->UFPlaca3,2,' ',TUtil::$LeftPad);
			$wregistro.=str_repeat(' ',28);
			//
			$this->WriteRecord($wregistro);
		}
	}
	
	private function Totaliza90($wregistro,$print,$total90=0){
		if (strlen($wregistro)>115){
			//$wregistro.=str_repeat(' ',125-strlen($wregistro)).($this->wseque90+1);
			$wregistro.=str_repeat(' ',125-strlen($wregistro)).($total90);
			//
			if ($print) $this->WriteRecord($wregistro);
			$this->wtotal90+=1;
			$this->wseque90+=1;

			//
			$wregistro='90';
			$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registro10->CNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
			$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registro10->Inscricao,'/-.)(,')),14,' ',TUtil::$LeftPad);
		}
		
		return $wregistro;
	}

	private function GerarRegistros90($print,$total90=0){
		$this->wtotal90=3;
		$this->wseque90=0;
		
		$wregistro='90';
		$wregistro.=TUtil::Pad(TUtil::UnMask($this->Registro10->CNPJ,'/-.)(,'),14,'0',TUtil::$RightPad);
		$wregistro.=TUtil::Pad(trim(TUtil::UnMask($this->Registro10->Inscricao,'/-.)(,')),14,' ',TUtil::$LeftPad);
		if ($this->Registros50->Count()) $wregistro.='50'.TUtil::Pad($this->Registros50->Count(),8,'0',TUtil::$RightPad);
		if ($this->Registros51->Count()) $wregistro.='51'.TUtil::Pad($this->Registros51->Count(),8,'0',TUtil::$RightPad);
		if ($this->Registros53->Count()) $wregistro.='53'.TUtil::Pad($this->Registros53->Count(),8,'0',TUtil::$RightPad);
		if ($this->Registros54->Count()) $wregistro.='54'.TUtil::Pad($this->Registros54->Count(),8,'0',TUtil::$RightPad);
		if ($this->Registros55->Count()) $wregistro.='55'.TUtil::Pad($this->Registros55->Count(),8,'0',TUtil::$RightPad);
		if ($this->Registros56->Count()) $wregistro.='56'.TUtil::Pad($this->Registros56->Count(),8,'0',TUtil::$RightPad);
		if ($this->Registros60M->Count()){
			$wtotal=$this->Registros60M->Count()+$this->Registros60A->Count()+$this->Registros60D->Count()+
					$this->Registros60I->Count()+$this->Registros60R->Count();
			$wregistro.='60'.TUtil::Pad($wtotal,8,'0',TUtil::$RightPad);
		}
		if ($this->Registros61->Count()){
			$wtotal=$this->Registros61->Count()+$this->Registros61R->Count();
			$wregistro.='61'.TUtil::Pad($wtotal,8,'0',TUtil::$RightPad);
		}
		if ($this->Registros70->Count()) $wregistro.='70'.TUtil::Pad($this->Registros70->Count(),8,'0',TUtil::$RightPad);
		$wregistro=$this->Totaliza90($wregistro,$print,$total90);
		if ($this->Registros71->Count()) $wregistro.='71'.TUtil::Pad($this->Registros71->Count(),8,'0',TUtil::$RightPad);
		$wregistro=$this->Totaliza90($wregistro,$print,$total90);
		if ($this->Registros74->Count()) $wregistro.='74'.TUtil::Pad($this->Registros74->Count(),8,'0',TUtil::$RightPad);
		$wregistro=$this->Totaliza90($wregistro,$print,$total90);
		if ($this->Registros75->Count()) $wregistro.='75'.TUtil::Pad($this->Registros75->Count(),8,'0',TUtil::$RightPad);
		$wregistro=$this->Totaliza90($wregistro,$print,$total90);
		if ($this->Registros76->Count()) $wregistro.='76'.TUtil::Pad($this->Registros76->Count(),8,'0',TUtil::$RightPad);
		$wregistro=$this->Totaliza90($wregistro,$print,$total90);
		if ($this->Registros77->Count()) $wregistro.='77'.TUtil::Pad($this->Registros77->Count(),8,'0',TUtil::$RightPad);
		$wregistro=$this->Totaliza90($wregistro,$print,$total90);
		if ($this->Registros85->Count()) $wregistro.='85'.TUtil::Pad($this->Registros85->Count(),8,'0',TUtil::$RightPad);
		$wregistro=$this->Totaliza90($wregistro,$print,$total90);
		if ($this->Registros86->Count()) $wregistro.='86'.TUtil::Pad($this->Registros86->Count(),8,'0',TUtil::$RightPad);
		$wregistro=$this->Totaliza90($wregistro,$print,$total90);
		//
		//totalizador para registros 88
		$wtotal88=0;
		if ($this->Informa88EAN) $wtotal88+=$this->Registros88Ean->Count();
		if (trim($this->Registro88EC->NomeContabilista)!='') $wtotal88+=1;
		if (trim($this->Registro88SF->NomeEmpresa)!='') $wtotal88+=1;
		if ($this->Informa88SME) $wtotal88+=1;
		if ($this->Informa88SMS) $wtotal88+=1;
		if ($this->Informa88C){
			$wtotal88+=$this->Registros88C->Count();
			$wtotal88+=$this->Registros88D->Count();
			$wtotal88+=$this->Registros88E->Count();
			$wtotal88+=$this->Registros88T->Count();
		}
		if ($wtotal88) $wregistro.='88'.TUtil::Pad($wtotal88,8,'0',TUtil::$RightPad);
		$wregistro=$this->Totaliza90($wregistro,$print,$total90);
		$wtotal=$this->Registros50->Count()+$this->Registros51->Count()+
			$this->Registros53->Count()+$this->Registros54->Count()+$this->Registros55->Count()+$this->Registros56->Count()+
			($this->Registros60M->Count()+$this->Registros60A->Count()+$this->Registros60D->Count()+$this->Registros60I->Count()+$this->Registros60R->Count())+
			($this->Registros61->Count()+$this->Registros61R->Count())+$this->Registros70->Count()+$this->Registros71->Count()+
			$this->Registros74->Count()+$this->Registros75->Count()+$this->Registros76->Count()+$this->Registros77->Count()+
			$this->Registros85->Count()+$this->Registros86->Count()+$wtotal88+$this->wtotal90;
		$wregistro.='99'.TUtil::Pad($wtotal,8,'0',TUtil::$RightPad);
		//$wregistro.=str_repeat(' ',125-strlen($wregistro)).($this->wseque90+1); 
		$wregistro.=str_repeat(' ',125-strlen($wregistro)).($total90); 
		//
		if ($print) $this->WriteRecord($wregistro);
		
		return ($this->wseque90+1);
	}
	//
	//Datas devem ser inseridas no seguinte formato: yyyy-mm-dd
    public function GeraArquivo(){
	
		$TParams = new TParams();
		$uploaddir = "/var/www/uploads/".$TParams->getCodigo()."/sintegra/";
		if(!is_dir($uploaddir)) mkdir($uploaddir, 0777, true);
		
		if (!$this->Debug){
			
			$not_dtfatini  = $_REQUEST["ini"];
			$mes = substr($not_dtfatini,5,2);
		
			$arqname = $TParams->getCodigo().'.txt';
			// $zipname = $TParams->getCodigo().'_'.date('Y').'-'.$mes.'.zip';
			$zipname = $TParams->getCodigo().'_'.substr($not_dtfatini,0,4).'-'.$mes.'.zip';
			$this->file = fopen($uploaddir.$arqname,"w+");
			// $a = fopen($arqname,"w+");
			// $this->file=gzopen($zipname, "w9");
			//if (!strlen($this->FileName)) throw new Exception('Informe nome do arquivo');
			// header('Content-Type: application/octet-stream; charset=ISO-8859-1');
			// header('Content-Disposition: attachment; filename="'.$this->FileName.'"');
			
		}else{
			echo "TSintegra em Modo Debug<br><hr>";
		}
		
		$this->GeraRegistro10();
		$this->GeraRegistro11();
		$this->GerarRegistros50();
		$this->GerarRegistros51();
		$this->GerarRegistros53();
		$this->GerarRegistros54();
		$this->GerarRegistros55();
		$this->GerarConjuntoRegistros60();
		$this->GerarRegistros60R();
		$this->GerarRegistros61();
		$this->GerarRegistros61R();
		$this->GerarRegistros70();
		$this->GerarRegistros71();
		$this->GerarRegistros74();
		$this->GerarRegistros75();		
		$this->GerarRegistros76();	
		$this->GerarRegistros77();
		$this->GerarRegistros85();
		$this->GerarRegistros86();
		if ($this->Informa88EAN) $this->GerarRegistros88Ean();
		if (trim($this->Registro88EC->NomeContabilista)!='') $this->GerarRegistro88EC();
		if (trim($this->Registro88SF->NomeEmpresa)!='') $this->GerarRegistro88SF();
		if ($this->Informa88SME) $this->GerarRegistro88SME();
		if ($this->Informa88SMS) $this->GerarRegistro88SMS();
		if ($this->Informa88C){
			$this->GerarRegistros88C();
			$this->GerarRegistros88D();
			$this->GerarRegistros88E();
			$this->GerarRegistros88T();
		}
		$total90=$this->GerarRegistros90(false);
		$this->GerarRegistros90(true,$total90);
		
		if (!$this->Debug){
			
			fclose($this->file);
			
			$zip = new ZipArchive();

			if ($zip->open($uploaddir.$zipname, ZipArchive::CREATE)!==TRUE) {
				exit("cannot open <$zipname>\n");
			}
			
			$zip->addFile($uploaddir.$arqname,$arqname);
			
			// @unlink($arqname);
			
			$zip->close();
			
		}
		
		header('Content-type: application/zip');
		header('Content-disposition: filename="'.$zipname.'"');
		header("Content-length: ".filesize($zipname));
		readfile($zipname);
		
	}
}
?>