
<!DOCTYPE html>
<?php
	$arquivoChamada = explode('/', $_SERVER['SCRIPT_FILENAME']);
	$arquivoChamada = end($arquivoChamada);

	$arquivoAtual = explode('/', __FILE__);
	$arquivoAtual = end($arquivoAtual);

	if($arquivoAtual == $arquivoChamada) {
?>


<html>
<head>
	<title>Pedidos</title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta charset="utf-8">

	<link rel="stylesheet" href="css/materialize.min.css">
	<link type="text/css" rel="stylesheet" href="css/estilo.css">
	
	<script type="text/javascript" src="https://code.jquery.com/jquery-2.1.1.min.js"></script>

	<script type="text/javascript" src="js/videoScript.js"></script>
	

</head>
<body>
<?php
	}
?>
	<h2 class="center">Vídeo Treinamento - Pedidos</h2>

	<div class="row">		
		<div class="col s10 offset-s1">
			<div class="video-container">
				<div class="videoContainer" id="fYRB12tu_VM"></div>
			</div>
		</div>
	</div>


	<div class="container">

		<h2 class="center">Início</h2>

		<p class="flow-text">O módulo pedidos serve, para cadastrar pedidos do cliente, que posteriormente podem ser transformados em notas fiscais eletrônicas ou notas de serviço eletrônicas. Os pedidos podem ser digitados normalmente, ou os dados podem ser transferidos automaticamente a partir da escolha de um orçamento.
		</p>
		<p class="flow-text">O pedido, ao fim da inclusão, pode ser transformado também em ordem de produção, se for necessário.</p>
		<p class="flow-text">Após escolher o cliente deste pedido, o sistema permitirá cadastrar os produtos e ou serviços.</p>

		<h4 class="center">Produtos</h4>

		<p class="flow-text">Os produtos podem ser adicionados na aba produtos digitando o código do produto, ou usando leitor de código de barras, ou digitando uma parte do nome do produto.</p>

		<p class="flow-text">Clicando na imagem verde “mais”, o produto será adicionado ao pedido.</p>

		<p class="flow-text">Os produtos selecionados aparecerão na parte de baixo da tela sob o título “produtos adicionados”.</p>

		<p class="flow-text">Clicando na imagem vermelha “X”, o produto poderá ser excluído do pedido ou simplesmente modificado.</p>

		<h4 class="center">Serviços</h4>

		<p class="flow-text">Os serviços podem ser adicionados na aba serviços digitando o código do serviço, ou digitando uma parte do nome do serviço.</p>
		<p class="flow-text">Clicando na imagem verde “mais”, o serviço será adicionado ao pedido.</p>
		<p class="flow-text">Os Serviços selecionados aparecerão na parte de baixo da tela sob o título “serviços adicionados”.</p>
		<p class="flow-text">Clicando na imagem vermelha “X”, o serviço poderá ser excluído do pedido ou simplesmente modificado.</p>


		<h4 class="center">Detalhes</h4>

		<ul class="flow-text collection with-header">

			<li class="flo-text collection-header"><strong>A aba detalhes é subdividida em 5 sub-abas:</strong></li>
			<li class="flow-text collection-item">Na <strong>sub-aba financeiro</strong> escolheremos as condições de pagamento deste pedido, qual é o centro de custo para este pedido, poderemos dar um desconto em porcentagem ou em valor.</li>
			<li class="flow-text collection-item">Na <strong>sub-aba frete</strong> escolheremos o tipo do frete (se existir) CIF ou FOB, o valor do frete, qual é a transportadora e tudo que se refere à um frete como: quantidade, espécie, marca peso bruto, peso líquido.</li>
			<li class="flow-text collection-item">Na <strong>sub-aba observação</strong> poderemos cadastrar uma observação para este pedido..</li>
			<li class="flow-text collection-item">Na <strong>sub-aba parcelas</strong> visualizaremos as parcelas deste pedido (conforme as condições de pagamento), poderemos alterar alguma parcela, mas ao alterar o valor, as outras serão alteradas automaticamente para que o valor total do pedido permaneça inalterado.</li>
			<li class="flow-text collection-item">Na <strong>sub-aba histórico</strong> do pedido veremos tudo o que aconteceu com o pedido em questão (log).</li>
		</ul>

		<br>

		<ul class="collection with-header">

			<li class="flow-text collection-header"><strong>Pós salvar o pedido, o sistema apresenta, na parte inferior da tela, entre outros, 4 botões:</strong></li>

			<li class="flow-text collection-item">FATURAR – clicando no botão faturar, o sistema gravará as parcelas que foram geradas a partir da condição de pagamento do pedido. E quando for feita uma nota fiscal eletrônica a partir deste pedido, o financeiro não será atualizado pela nota, e isso quer dizer, que na nota os valores dos produtos podem ser alterados que isso não implicará na mudança das parcelas que já foram gravadas.</li>

			<li class="flow-text collection-item">CANCELAR – Cancelar um pedido salvo que não foi ainda transformado em nota fiscal eletrônica.</li>

			<li class="flow-text collection-item">EMITIR NF-e – Transformar o pedido (somente os produtos sem os serviços) em nota fiscal eletrônica.</li>

		</ul>

		<br>

		<ul class="collection with-header">
			<li class="flow-text collection-header"><h5>IMPRIMIR – este botão se subdivide em outros 5 botões:</h5></li>
			<li class="flow-text collection-item">PEDIDO -  vai imprimir o pedido propriamente dito (somente dos produtos sem os serviços).</li>
			<li class="flow-text collection-item">NOTA PROMISSÓRIA - vai imprimir o pedido propriamente dito (somente dos produtos sem os serviços) e no fim imprimirá uma nota promissória no valor total do pedido.</li>
			<li class="flow-text collection-item">ORDEM DE PRODUÇÃO – Emitirá ordem para produzir os produtos para este pedido.</li>
			<li class="flow-text collection-item">ORDEM DE SERVIÇO - vai imprimir o pedido propriamente dito (somente dos serviços sem os produtos).</li>
			<li class="flow-text collection-item">ETIQUETAS – vai imprimir as etiquetas dos produtos existentes no pedido. O usuário poderá informar ao sistema qual a quantidade de etiquetas emitir para cada produto.</li>
		</ul>
		<br>
		<br>	
	</div>
<?php
	if($arquivoAtual == $arquivoChamada) {
?>
	</body>
	</html>
<?php
	}
?>