<?php 
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');

	include 'TParams.class.php';
	include_once '../class/atualiza_cep.class.php';
	
	$datapacket = new TParams();
	$datapacket->debug(true);
	$atualizaCep = new atualizaCep();
	$datapacket->setHost($datapacket->getHost("empresas"));
	
	//salvar
	if(isset($_REQUEST['acao']) && $_REQUEST['acao'] == "salvar"){
		
		$dados = json_decode(base64_decode($_REQUEST['dados']));

		if(isset($dados->{'emp_codigo'}) && !empty($dados->{'emp_codigo'})){$emp_codigo = $dados->{'emp_codigo'};}else{$emp_codigo = "";};
		if(isset($dados->{'emp_cpfcnpj'}) && !empty($dados->{'emp_cpfcnpj'})){$emp_cpfcnpj = $dados->{'emp_cpfcnpj'};}else{$emp_cpfcnpj = "";};
		if(isset($dados->{'emp_inscrg'}) && !empty($dados->{'emp_inscrg'})){$emp_inscrg = $dados->{'emp_inscrg'};}else{$emp_inscrg = "";};
		if(isset($dados->{'emp_inscrmun'}) && !empty($dados->{'emp_inscrmun'})){$emp_inscrmun = $dados->{'emp_inscrmun'};}else{$emp_inscrmun = "";};
		
		$emp_razao = "";
		if(isset($dados->{'emp_razao'}) && !empty($dados->{'emp_razao'})){
			$emp_razao = mb_strtoupper($dados->{'emp_razao'}, 'UTF-8');
			$emp_razao = str_replace(array("Á", "Ã", "Â", "À", "É", "Ê", "Í", "Ó", "Ô", "Õ", "Ú", "Ü", "Ç"), array("A", "A", "A", "A", "E", "E", "I", "O", "O", "O", "U", "U", "C"), $emp_razao);
			$emp_razao = trim($emp_razao);
		}
		
		$emp_fantasia = "";
		if(isset($dados->{'emp_fantasia'}) && !empty($dados->{'emp_fantasia'})){
			$emp_fantasia = mb_strtoupper($dados->{'emp_fantasia'}, 'UTF-8');
			$emp_fantasia = str_replace(array("Á", "Ã", "Â", "À", "É", "Ê", "Í", "Ó", "Ô", "Õ", "Ú", "Ü", "Ç"), array("A", "A", "A", "A", "E", "E", "I", "O", "O", "O", "U", "U", "C"), $emp_fantasia);
			$emp_fantasia = trim($emp_fantasia);
		}
				
		if(isset($dados->{'emp_cep'}) && !empty($dados->{'emp_cep'})){$emp_cep = $dados->{'emp_cep'};}else{$emp_cep = "";};
		
		$emp_endereco = "";
		if(isset($dados->{'emp_endereco'}) && !empty($dados->{'emp_endereco'})){
			$emp_endereco = mb_strtoupper($dados->{'emp_endereco'}, 'UTF-8');
			$emp_endereco = str_replace(array("Á", "Ã", "Â", "À", "É", "Ê", "Í", "Ó", "Ô", "Õ", "Ú", "Ü", "Ç"), array("A", "A", "A", "A", "E", "E", "I", "O", "O", "O", "U", "U", "C"), $emp_endereco);
			$emp_endereco = trim($emp_endereco);
		}
		
		$emp_num = "";
		if(isset($dados->{'emp_num'}) && !empty($dados->{'emp_num'})){
			$emp_num = mb_strtoupper($dados->{'emp_num'}, 'UTF-8');
			$emp_num = str_replace(array("Á", "Ã", "Â", "À", "É", "Ê", "Í", "Ó", "Ô", "Õ", "Ú", "Ü", "Ç"), array("A", "A", "A", "A", "E", "E", "I", "O", "O", "O", "U", "U", "C"), $emp_num);
			$emp_num = trim($emp_num);
		}
		
		$emp_complem = "";
		if(isset($dados->{'emp_complem'}) && !empty($dados->{'emp_complem'})){
			$emp_complem = mb_strtoupper($dados->{'emp_complem'}, 'UTF-8');
			$emp_complem = str_replace(array("Á", "Ã", "Â", "À", "É", "Ê", "Í", "Ó", "Ô", "Õ", "Ú", "Ü", "Ç"), array("A", "A", "A", "A", "E", "E", "I", "O", "O", "O", "U", "U", "C"), $emp_complem);
			$emp_complem = trim($emp_complem);
		}
		
		$emp_bairro = "";
		if(isset($dados->{'emp_bairro'}) && !empty($dados->{'emp_bairro'})){
			$emp_bairro = mb_strtoupper($dados->{'emp_bairro'}, 'UTF-8');
			$emp_bairro = str_replace(array("Á", "Ã", "Â", "À", "É", "Ê", "Í", "Ó", "Ô", "Õ", "Ú", "Ü", "Ç"), array("A", "A", "A", "A", "E", "E", "I", "O", "O", "O", "U", "U", "C"), $emp_bairro);
			$emp_bairro = trim($emp_bairro);
		}
		
		$emp_cidade = "";
		if(isset($dados->{'emp_cidade'}) && !empty($dados->{'emp_cidade'})){
			$emp_cidade = mb_strtoupper($dados->{'emp_cidade'}, 'UTF-8');
			$emp_cidade = str_replace(array("Á", "Ã", "Â", "À", "É", "Ê", "Í", "Ó", "Ô", "Õ", "Ú", "Ü", "Ç"), array("A", "A", "A", "A", "E", "E", "I", "O", "O", "O", "U", "U", "C"), $emp_cidade);
			$emp_cidade = trim($emp_cidade);
		}

		if(isset($dados->{'emp_codmun'}) && !empty($dados->{'emp_codmun'})){$emp_codmun = $dados->{'emp_codmun'};}else{$emp_codmun = "";};
		
		if(!$atualizaCep->getCep($dados->{'emp_cep'})){
			$endereco = new stdClass();
			$endereco->{'cep_cep'} = $dados->{'emp_cep'};
			$endereco->{'cep_logradouro'} = $dados->{'emp_endereco'};
			$endereco->{'cep_bairro'} = $dados->{'emp_bairro'};
			$endereco->{'cep_uf'} = substr($dados->{'emp_codmun'}, 0, 2);
			$endereco->{'cep_municipio'} = substr($dados->{'emp_codmun'}, 2, 4);
			$atualizaCep->addCep($endereco);
			unset($endereco);
		}
		
		if(isset($dados->{'emp_uf'}) && !empty($dados->{'emp_uf'})){$emp_uf = $dados->{'emp_uf'};}else{$emp_uf = "";};
		if(isset($dados->{'emp_fone'}) && !empty($dados->{'emp_fone'})){$emp_fone = $dados->{'emp_fone'};}else{$emp_fone = "";};
		if(isset($dados->{'emp_cel'}) && !empty($dados->{'emp_cel'})){$emp_cel = $dados->{'emp_cel'};}else{$emp_cel = "";};
		if(isset($dados->{'emp_ctrl_preco'}) && !empty($dados->{'emp_ctrl_preco'})){$emp_ctrl_preco = $dados->{'emp_ctrl_preco'};}else{$emp_ctrl_preco = 0;};
		if(isset($dados->{'emp_ctrl_qtde'}) && !empty($dados->{'emp_ctrl_qtde'})){$emp_ctrl_qtde = $dados->{'emp_ctrl_qtde'};}else{$emp_ctrl_qtde = 0;};
		if(isset($dados->{'emp_ctrl_limite'}) && !empty($dados->{'emp_ctrl_limite'})){$emp_ctrl_limite = $dados->{'emp_ctrl_limite'};}else{$emp_ctrl_limite = 0;};
		if(isset($dados->{'emp_redirect'}) && !empty($dados->{'emp_redirect'})){$emp_redirect = $dados->{'emp_redirect'};}else{$emp_redirect = "null";};
		if(isset($dados->{'emp_modelo_imp'}) && !empty($dados->{'emp_modelo_imp'})){$emp_modelo_imp = $dados->{'emp_modelo_imp'};}else{$emp_modelo_imp = "null";};
		if(isset($dados->{'emp_layout_orcamento'}) && !empty($dados->{'emp_layout_orcamento'})){$emp_layout_orcamento = $dados->{'emp_layout_orcamento'};}else{$emp_layout_orcamento = 0;};
		if(isset($dados->{'emp_amb_nfe'}) && !empty($dados->{'emp_amb_nfe'})){$emp_amb_nfe = $dados->{'emp_amb_nfe'};}else{$emp_amb_nfe = "null";};
		if(isset($dados->{'emp_ambcte'}) && !empty($dados->{'emp_ambcte'})){$emp_ambcte = $dados->{'emp_ambcte'};}else{$emp_ambcte = "null";};
		if(isset($dados->{'emp_amb_nfse'}) && !empty($dados->{'emp_amb_nfse'})){$emp_amb_nfse = $dados->{'emp_amb_nfse'};}else{$emp_amb_nfse = "0";};
		if(isset($dados->{'emp_inf_fisco'}) && !empty($dados->{'emp_inf_fisco'})){$emp_inf_fisco = $dados->{'emp_inf_fisco'};}else{$emp_inf_fisco = "";};
		if(isset($dados->{'emp_gmt'}) && !empty($dados->{'emp_gmt'})){$emp_gmt = $dados->{'emp_gmt'};}else{$emp_gmt = 0;};
		if(isset($dados->{'emp_dias_protesto'}) && !empty($dados->{'emp_dias_protesto'})){$emp_dias_protesto = $dados->{'emp_dias_protesto'};}else{$emp_dias_protesto = "";};
		if(isset($dados->{'emp_protesto'}) && !empty($dados->{'emp_protesto'})){$emp_protesto = $dados->{'emp_protesto'};}else{$emp_protesto = 0;};
		if(isset($dados->{'emp_codregtrib'}) && !empty($dados->{'emp_codregtrib'})){$emp_codregtrib = $dados->{'emp_codregtrib'};}else{$emp_codregtrib = 'null';};
		if(isset($dados->{'emp_aliq_sn'}) && !empty($dados->{'emp_aliq_sn'})){$emp_aliq_sn = $dados->{'emp_aliq_sn'};}else{$emp_aliq_sn = "";};
		if(isset($dados->{'emp_overhead'}) && !empty($dados->{'emp_overhead'})){$emp_overhead = $dados->{'emp_overhead'};}else{$emp_overhead = 0;};
		if(isset($dados->{'emp_honorarios'}) && !empty($dados->{'emp_honorarios'})){$emp_honorarios = $dados->{'emp_honorarios'};}else{$emp_honorarios = 0;};
		if(isset($dados->{'emp_jurosdiario'}) && !empty($dados->{'emp_jurosdiario'})){$emp_jurosdiario = $dados->{'emp_jurosdiario'};}else{$emp_jurosdiario = 0;};
		if(isset($dados->{'emp_multa'}) && !empty($dados->{'emp_multa'})){$emp_multa = $dados->{'emp_multa'};}else{$emp_multa = 0;};
		if(isset($dados->{'emp_precomin'}) && !empty($dados->{'emp_precomin'})){$emp_precomin = $dados->{'emp_precomin'};}else{$emp_precomin = "null";};
		if(isset($dados->{'emp_limitcred'}) && !empty($dados->{'emp_limitcred'})){$emp_limitcred = $dados->{'emp_limitcred'};}else{$emp_limitcred = "null";};
		if(isset($dados->{'emp_qtdemin'}) && !empty($dados->{'emp_qtdemin'})){$emp_qtdemin = $dados->{'emp_qtdemin'};}else{$emp_qtdemin = "null";};
		if(isset($dados->{'emp_ncm_padrao'}) && !empty($dados->{'emp_ncm_padrao'})){$emp_ncm_padrao = $dados->{'emp_ncm_padrao'};}else{$emp_ncm_padrao = "";};
		if(isset($dados->{'emp_cnae'}) && !empty($dados->{'emp_cnae'})){$emp_cnae = $dados->{'emp_cnae'};}else{$emp_cnae = "";};
		if(isset($dados->{'emp_serie'}) && !empty($dados->{'emp_serie'})){$emp_serie = $dados->{'emp_serie'};}else{$emp_serie = "";};
		if(isset($dados->{'emp_serie_nfse'}) && !empty($dados->{'emp_serie_nfse'})){$emp_serie_nfse = $dados->{'emp_serie_nfse'};}else{$emp_serie_nfse = "";};
		if(isset($dados->{'emp_cfop_devolucao'}) && !empty($dados->{'emp_cfop_devolucao'})){$emp_cfop_devolucao = $dados->{'emp_cfop_devolucao'};}else{$emp_cfop_devolucao = "";};
		if(isset($dados->{'emp_pdv'}) && !empty($dados->{'emp_pdv'})){$emp_pdv = $dados->{'emp_pdv'};}else{$emp_pdv = "";};
		if(isset($dados->{'emp_cli_padrao'}) && !empty($dados->{'emp_cli_padrao'})){$emp_cli_padrao = $dados->{'emp_cli_padrao'};}else{$emp_cli_padrao = "";};
		if(isset($dados->{'emp_pdv_msgpadrao'}) && !empty($dados->{'emp_pdv_msgpadrao'})){$emp_pdv_msgpadrao = $dados->{'emp_pdv_msgpadrao'};}else{$emp_pdv_msgpadrao = "";};
		if(isset($dados->{'emp_pdv_msgpadrao_delimit'}) && !empty($dados->{'emp_pdv_msgpadrao_delimit'})){$emp_pdv_msgpadrao_delimit = $dados->{'emp_pdv_msgpadrao_delimit'};}else{$emp_pdv_msgpadrao_delimit = "";};
		if(isset($dados->{'emp_pdv_msgsecund'}) && !empty($dados->{'emp_pdv_msgsecund'})){$emp_pdv_msgsecund = $dados->{'emp_pdv_msgsecund'};}else{$emp_pdv_msgsecund = "";};
		if(isset($dados->{'emp_pdv_msgsecund_delimit'}) && !empty($dados->{'emp_pdv_msgsecund_delimit'})){$emp_pdv_msgsecund_delimit = $dados->{'emp_pdv_msgsecund_delimit'};}else{$emp_pdv_msgsecund_delimit = "";};
		if(isset($dados->{'emp_rntrc'}) && !empty($dados->{'emp_rntrc'})){$emp_rntrc = $dados->{'emp_rntrc'};}else{$emp_rntrc = "null";};
		if(isset($dados->{'emp_csc'}) && !empty($dados->{'emp_csc'})){$emp_csc = $dados->{'emp_csc'};}else{$emp_csc = "";};
		if(isset($dados->{'emp_instr1'}) && !empty($dados->{'emp_instr1'})){$emp_instr1 = mb_strtoupper($dados->{'emp_instr1'}, 'UTF-8');}else{$emp_instr1 = "";};
		if(isset($dados->{'emp_instr2'}) && !empty($dados->{'emp_instr2'})){$emp_instr2 = mb_strtoupper($dados->{'emp_instr2'}, 'UTF-8');}else{$emp_instr2 = "";};
		if(isset($dados->{'emp_instr3'}) && !empty($dados->{'emp_instr3'})){$emp_instr3 = mb_strtoupper($dados->{'emp_instr3'}, 'UTF-8');}else{$emp_instr3 = "";};
		if(isset($dados->{'emp_instr4'}) && !empty($dados->{'emp_instr4'})){$emp_instr4 = mb_strtoupper($dados->{'emp_instr4'}, 'UTF-8');}else{$emp_instr4 = "";};
		if(isset($dados->{'emp_instr5'}) && !empty($dados->{'emp_instr5'})){$emp_instr5 = mb_strtoupper($dados->{'emp_instr5'}, 'UTF-8');}else{$emp_instr5 = "";};
		if(isset($dados->{'emp_carne_instr1'}) && !empty($dados->{'emp_carne_instr1'})){$emp_carne_instr1 = mb_strtoupper($dados->{'emp_carne_instr1'}, 'UTF-8');}else{$emp_carne_instr1 = "";};
		if(isset($dados->{'emp_carne_instr2'}) && !empty($dados->{'emp_carne_instr2'})){$emp_carne_instr2 = mb_strtoupper($dados->{'emp_carne_instr2'}, 'UTF-8');}else{$emp_carne_instr2 = "";};
		if(isset($dados->{'emp_sconsig1'}) && !empty($dados->{'emp_sconsig1'})){$emp_sconsig1 = $dados->{'emp_sconsig1'};}else{$emp_sconsig1 = "";};
		if(isset($dados->{'emp_sconsig2'}) && !empty($dados->{'emp_sconsig2'})){$emp_sconsig2 = $dados->{'emp_sconsig2'};}else{$emp_sconsig2 = "";};
		if(isset($dados->{'emp_hostsmtp'}) && !empty($dados->{'emp_hostsmtp'})){$emp_hostsmtp = $dados->{'emp_hostsmtp'};}else{$emp_hostsmtp = "";};
		if(isset($dados->{'emp_emailremetente'}) && !empty($dados->{'emp_emailremetente'})){$emp_emailremetente = $dados->{'emp_emailremetente'};}else{$emp_emailremetente = "";};
		if(isset($dados->{'emp_pwdsmtp'}) && !empty($dados->{'emp_pwdsmtp'})){$emp_pwdsmtp = $dados->{'emp_pwdsmtp'};}else{$emp_pwdsmtp = "";};
		if(isset($dados->{'emp_msgemail'}) && !empty($dados->{'emp_msgemail'})){$emp_msgemail = $dados->{'emp_msgemail'};}else{$emp_msgemail = "";};
		if(isset($dados->{'emp_msgsms'}) && !empty($dados->{'emp_msgsms'})){$emp_msgsms = $dados->{'emp_msgsms'};}else{$emp_msgsms = "";};
		if(isset($dados->{'emp_msgnfe'}) && !empty($dados->{'emp_msgnfe'})){$emp_msgnfe = $dados->{'emp_msgnfe'};}else{$emp_msgnfe = "";};
		if(isset($dados->{'emp_ctb_nome'}) && !empty($dados->{'emp_ctb_nome'})){$emp_ctb_nome = $dados->{'emp_ctb_nome'};}else{$emp_ctb_nome = "";};
		if(isset($dados->{'emp_ctb_cpf'}) && !empty($dados->{'emp_ctb_cpf'})){$emp_ctb_cpf = $dados->{'emp_ctb_cpf'};}else{$emp_ctb_cpf = "";};
		if(isset($dados->{'emp_ctb_crc'}) && !empty($dados->{'emp_ctb_crc'})){$emp_ctb_crc = $dados->{'emp_ctb_crc'};}else{$emp_ctb_crc = "";};
		if(isset($dados->{'emp_ctb_escritorio'}) && !empty($dados->{'emp_ctb_escritorio'})){$emp_ctb_escritorio = $dados->{'emp_ctb_escritorio'};}else{$emp_ctb_escritorio = "";};
		if(isset($dados->{'emp_ctb_cnpj'}) && !empty($dados->{'emp_ctb_cnpj'})){$emp_ctb_cnpj = $dados->{'emp_ctb_cnpj'};}else{$emp_ctb_cnpj = "";};
		if(isset($dados->{'emp_ctb_cep'}) && !empty($dados->{'emp_ctb_cep'})){$emp_ctb_cep = $dados->{'emp_ctb_cep'};}else{$emp_ctb_cep = "";};
		if(isset($dados->{'emp_ctb_codmun'}) && !empty($dados->{'emp_ctb_codmun'})){$emp_ctb_codmun = $dados->{'emp_ctb_codmun'};}else{$emp_ctb_codmun = "";};
		if(isset($dados->{'emp_ctb_endereco'}) && !empty($dados->{'emp_ctb_endereco'})){$emp_ctb_endereco = $dados->{'emp_ctb_endereco'};}else{$emp_ctb_endereco = "";};
		if(isset($dados->{'emp_ctb_num'}) && !empty($dados->{'emp_ctb_num'})){$emp_ctb_num = $dados->{'emp_ctb_num'};}else{$emp_ctb_num = "";};
		if(isset($dados->{'emp_ctb_compl'}) && !empty($dados->{'emp_ctb_compl'})){$emp_ctb_compl = $dados->{'emp_ctb_compl'};}else{$emp_ctb_compl = "";};
		if(isset($dados->{'emp_ctb_bairro'}) && !empty($dados->{'emp_ctb_bairro'})){$emp_ctb_bairro = $dados->{'emp_ctb_bairro'};}else{$emp_ctb_bairro = "";};
		if(isset($dados->{'emp_ctb_fone'}) && !empty($dados->{'emp_ctb_fone'})){$emp_ctb_fone = $dados->{'emp_ctb_fone'};}else{$emp_ctb_fone = "";};
		if(isset($dados->{'emp_ctb_fax'}) && !empty($dados->{'emp_ctb_fax'})){$emp_ctb_fax = $dados->{'emp_ctb_fax'};}else{$emp_ctb_fax = "";};
		if(isset($dados->{'emp_ctb_email'}) && !empty($dados->{'emp_ctb_email'})){$emp_ctb_email = $dados->{'emp_ctb_email'};}else{$emp_ctb_email = "";};
		if(isset($dados->{'emp_decimais'}) && !empty($dados->{'emp_decimais'})){$emp_decimais = $dados->{'emp_decimais'};}else{$emp_decimais = "";};
		if(isset($dados->{'emp_referencia'}) && !empty($dados->{'emp_referencia'})){$emp_referencia = $dados->{'emp_referencia'};}else{$emp_referencia = 1;};
		if(isset($dados->{'emp_titulo'}) && !empty($dados->{'emp_titulo'})){$emp_titulo = $dados->{'emp_titulo'};}else{$emp_titulo = 1;};
		if(isset($dados->{'emp_dias_envio'}) && !empty($dados->{'emp_dias_envio'})){$emp_dias_envio = $dados->{'emp_dias_envio'};}else{$emp_dias_envio = 10;};
		if(isset($dados->{'cfg_dia'}) && !empty($dados->{'cfg_dia'})){$cfg_dia = $dados->{'cfg_dia'};}else{$cfg_dia = "01";};
		if(isset($dados->{'cfg_qtde_decimais'}) && !empty($dados->{'cfg_qtde_decimais'})){$cfg_qtde_decimais = $dados->{'cfg_qtde_decimais'};}else{$cfg_qtde_decimais = 2;};
		if(isset($dados->{'cfg_pedido_desc'}) && !empty($dados->{'cfg_pedido_desc'})){$cfg_pedido_desc = $dados->{'cfg_pedido_desc'};}else{$cfg_pedido_desc = 0;};
		if(isset($dados->{'cfg_rotina'}) && !empty($dados->{'cfg_rotina'})){$cfg_rotina= $dados->{'cfg_rotina'};}else{$cfg_rotina = 0;};
		if(isset($dados->{'cfg_inativa_ctt'}) && !empty($dados->{'cfg_inativa_ctt'})){$cfg_inativa_ctt= $dados->{'cfg_inativa_ctt'};}else{$cfg_inativa_ctt = 0;};
		if(isset($dados->{'cfg_suspende_host'}) && !empty($dados->{'cfg_suspende_host'})){$cfg_suspende_host= $dados->{'cfg_suspende_host'};}else{$cfg_suspende_host = 0;};
		if(isset($dados->{'cfg_suspende_facil'}) && !empty($dados->{'cfg_suspende_facil'})){$cfg_suspende_facil= $dados->{'cfg_suspende_facil'};}else{$cfg_suspende_facil = 0;};
		if(isset($dados->{'cfg_gera_parcela'}) && !empty($dados->{'cfg_gera_parcela'})){$cfg_gera_parcela= $dados->{'cfg_gera_parcela'};}else{$cfg_gera_parcela = 0;};
		if(isset($dados->{'cfg_gera_nfse'}) && !empty($dados->{'cfg_gera_nfse'})){$cfg_gera_nfse= $dados->{'cfg_gera_nfse'};}else{$cfg_gera_nfse = 0;};
		if(isset($dados->{'cfg_agrupa_boleto'}) && !empty($dados->{'cfg_agrupa_boleto'})){$cfg_agrupa_boleto= $dados->{'cfg_agrupa_boleto'};}else{$cfg_agrupa_boleto = 0;};
		if(isset($dados->{'cfg_envia_boleto'}) && !empty($dados->{'cfg_envia_boleto'})){$cfg_envia_boleto= $dados->{'cfg_envia_boleto'};}else{$cfg_envia_boleto = 0;};
		if(isset($dados->{'cfg_envia_msg'}) && !empty($dados->{'cfg_envia_msg'})){$cfg_envia_msg= $dados->{'cfg_envia_msg'};}else{$cfg_envia_msg = 0;};
		if(isset($dados->{'cfg_envia_rel'}) && !empty($dados->{'cfg_envia_rel'})){$cfg_envia_rel= $dados->{'cfg_envia_rel'};}else{$cfg_envia_rel = 0;};
		if(isset($dados->{'cfg_email_rotina'}) && !empty($dados->{'cfg_email_rotina'})){$cfg_email_rotina= $dados->{'cfg_email_rotina'};}else{$cfg_email_rotina = '';};
		if(isset($dados->{'cfg_servidor'}) && !empty($dados->{'cfg_servidor'})){$cfg_servidor = $dados->{'cfg_servidor'};}else{$cfg_servidor = '';};
		if(isset($dados->{'cfg_versao'}) && !empty($dados->{'cfg_versao'})){$cfg_versao = $dados->{'cfg_versao'};}else{$cfg_versao = '';};
		if(isset($dados->{'cfg_ibpt_detalhe'}) && !empty($dados->{'cfg_ibpt_detalhe'})){$cfg_ibpt_detalhe = $dados->{'cfg_ibpt_detalhe'};}else{$cfg_ibpt_detalhe = 0;};

		$sintegra = new stdClass();
		$sintegra->responsavel = isset($dados->{'responsavel'})?$dados->{'responsavel'}:0;
		$sintegra->cod_conv = isset($dados->{'cod_conv'})?$dados->{'cod_conv'}:0;
		$sintegra->nat_info = isset($dados->{'nat_info'})?$dados->{'nat_info'}:0;
		$sintegra->fin_arq = isset($dados->{'fin_arq'})?$dados->{'fin_arq'}:0;
		$sintegra->reg50 = isset($dados->{'reg50'})?$dados->{'reg50'}:0;
		$sintegra->reg51 = isset($dados->{'reg51'})?$dados->{'reg51'}:0;
		$sintegra->reg53 = isset($dados->{'reg53'})?$dados->{'reg53'}:0;
		$sintegra->reg54 = isset($dados->{'reg54'})?$dados->{'reg54'}:0;
		$sintegra->reg60M = isset($dados->{'reg60M'})?$dados->{'reg60M'}:0;
		$sintegra->reg60A = isset($dados->{'reg60A'})?$dados->{'reg60A'}:0;
		$sintegra->reg60D = isset($dados->{'reg60D'})?$dados->{'reg60D'}:0;
		$sintegra->reg60I = isset($dados->{'reg60I'})?$dados->{'reg60I'}:0;
		$sintegra->reg60R = isset($dados->{'reg60R'})?$dados->{'reg60R'}:0;
		$sintegra->reg74 = isset($dados->{'reg74'})?$dados->{'reg74'}:0;
		$sintegra->reg75 = isset($dados->{'reg75'})?$dados->{'reg75'}:0;	
		$sintegra = array($sintegra);
		$sintegra = base64_encode(json_encode($sintegra));
		
		//verificar se há alteração no ambiente da NFS-e, caso haja enviar requisição ao servidor
		$filtro = '{"cod":"600115","params":[
			{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"}
		]}';
		$datapacket->add($filtro);
		$amb = $datapacket->open();
		if( $amb[0] && $amb[0]["emp_amb_nfse"] && $amb[0]["emp_amb_nfse"]!=$emp_amb_nfse && $emp_amb_nfse!="0" ){
			$url = 'http://prn.grupouds.com.br/php/nfse_config.php'; //url servidor nfs-e
			$fields = array(
				'emp_codigo' => $emp_codigo,
				'emp_cpfcnpj' => $emp_cpfcnpj,
				'emp_amb_nfse' => $emp_amb_nfse
			);
			//abrir conexao
			$ch = curl_init();
			//define url, numero de variaveis POST e dados POST
			curl_setopt($ch,CURLOPT_URL, $url);
			curl_setopt($ch,CURLOPT_POST, count($fields));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
			//executa POST
			$result = curl_exec($ch);
			//fechar conexao
			curl_close($ch);
		}
		$datapacket->clear();

		$filtro = '{"cod":"600111","params":[
			{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"},
			{"name":"emp_cpfcnpj","value":"'.$emp_cpfcnpj.'","type":"string"},
			{"name":"emp_inscrg","value":"'.$emp_inscrg.'","type":"string"},
			{"name":"emp_inscrmun","value":"'.$emp_inscrmun.'","type":"string"},
			{"name":"emp_razao","value":"'.$emp_razao.'","type":"string"},
			{"name":"emp_fantasia","value":"'.$emp_fantasia.'","type":"string"},
			{"name":"emp_cep","value":"'.$emp_cep.'","type":"string"},
			{"name":"emp_endereco","value":"'.$emp_endereco.'","type":"string"},
			{"name":"emp_num","value":"'.$emp_num.'","type":"string"},
			{"name":"emp_complem","value":"'.$emp_complem.'","type":"string"},
			{"name":"emp_bairro","value":"'.$emp_bairro.'","type":"string"},
			{"name":"emp_cidade","value":"'.$emp_cidade.'","type":"string"},
			{"name":"emp_codmun","value":"'.$emp_codmun.'","type":"string"},
			{"name":"emp_uf","value":"'.$emp_uf.'","type":"string"},
			{"name":"emp_fone","value":"'.$emp_fone.'","type":"string"},
			{"name":"emp_cel","value":"'.$emp_cel.'","type":"string"},
			{"name":"emp_ctrl_preco","value":"'.$emp_ctrl_preco.'","type":"other"},
			{"name":"emp_ctrl_qtde","value":"'.$emp_ctrl_qtde.'","type":"other"},
			{"name":"emp_ctrl_limite","value":"'.$emp_ctrl_limite.'","type":"other"},
			{"name":"emp_redirect","value":"'.$emp_redirect.'","type":"other"},
			{"name":"emp_modelo_imp","value":"'.$emp_modelo_imp.'","type":"other"},
			{"name":"emp_layout_orcamento","value":"'.$emp_layout_orcamento.'","type":"other"},
			{"name":"emp_amb_nfe","value":"'.$emp_amb_nfe.'","type":"other"},
			{"name":"emp_ambcte","value":"'.$emp_ambcte.'","type":"other"},
			{"name":"emp_amb_nfse","value":"'.$emp_amb_nfse.'","type":"other"},
			{"name":"emp_inf_fisco","value":"'.$emp_inf_fisco.'","type":"string"},
			{"name":"emp_gmt","value":"'.$emp_gmt.'","type":"integer"},
			{"name":"emp_codregtrib","value":"'.$emp_codregtrib.'","type":"other"},
			{"name":"emp_aliq_sn","value":"'.$emp_aliq_sn.'","type":"float"},
			{"name":"emp_overhead","value":"'.$emp_overhead.'","type":"float"},
			{"name":"emp_honorarios","value":"'.$emp_honorarios.'","type":"float"},
			{"name":"emp_jurosdiario","value":"'.$emp_jurosdiario.'","type":"float"},
			{"name":"emp_multa","value":"'.$emp_multa.'","type":"float"},
			{"name":"emp_maskcc","value":"NULL","type":"other"},
			{"name":"emp_maskpc","value":"NULL","type":"other"},
			{"name":"emp_precomin","value":"'.$emp_precomin.'","type":"other"},
			{"name":"emp_limitcred","value":"'.$emp_limitcred.'","type":"other"},
			{"name":"emp_qtdemin","value":"'.$emp_qtdemin.'","type":"other"},
			{"name":"emp_ncm_padrao","value":"'.$emp_ncm_padrao.'","type":"string"},
			{"name":"emp_cnae","value":"'.$emp_cnae.'","type":"string"},
			{"name":"emp_serie","value":"'.$emp_serie.'","type":"string"},
			{"name":"emp_serie_nfse","value":"'.$emp_serie_nfse.'","type":"string"},
			{"name":"emp_cfop_devolucao","value":"'.$emp_cfop_devolucao.'","type":"string"},
			{"name":"emp_pdv","value":"'.$emp_pdv.'","type":"string"},
			{"name":"emp_cli_padrao","value":"'.$emp_cli_padrao.'","type":"string"},
			{"name":"emp_pdv_msgpadrao","value":"'.$emp_pdv_msgpadrao.'","type":"string"},
			{"name":"emp_pdv_msgpadrao_delimit","value":"'.$emp_pdv_msgpadrao_delimit.'","type":"string"},
			{"name":"emp_pdv_msgsecund","value":"'.$emp_pdv_msgsecund.'","type":"string"},
			{"name":"emp_pdv_msgsecund_delimit","value":"'.$emp_pdv_msgsecund_delimit.'","type":"string"},
			{"name":"emp_rntrc","value":"'.$emp_rntrc.'","type":"other"},
			{"name":"emp_csc","value":"'.$emp_csc.'","type":"string"},
			{"name":"emp_instr1","value":"'.$emp_instr1.'","type":"string"},
			{"name":"emp_instr2","value":"'.$emp_instr2.'","type":"string"},
			{"name":"emp_instr3","value":"'.$emp_instr3.'","type":"string"},
			{"name":"emp_instr4","value":"'.$emp_instr4.'","type":"string"},
			{"name":"emp_instr5","value":"'.$emp_instr5.'","type":"string"},
			{"name":"emp_sconsig1","value":"'.$emp_sconsig1.'","type":"string"},
			{"name":"emp_sconsig2","value":"'.$emp_sconsig2.'","type":"string"},
			{"name":"emp_hostsmtp","value":"'.$emp_hostsmtp.'","type":"string"},
			{"name":"emp_emailremetente","value":"'.$emp_emailremetente.'","type":"string"},
			{"name":"emp_pwdsmtp","value":"'.$emp_pwdsmtp.'","type":"string"},
			{"name":"emp_msgemail","value":"'.$emp_msgemail.'","type":"string"},
			{"name":"emp_msgsms","value":"'.$emp_msgsms.'","type":"string"},
			{"name":"emp_msgnfe","value":"'.$emp_msgnfe.'","type":"string"},
			{"name":"emp_ctb_nome","value":"'.$emp_ctb_nome.'","type":"string"},
			{"name":"emp_ctb_cpf","value":"'.$emp_ctb_cpf.'","type":"string"},
			{"name":"emp_ctb_crc","value":"'.$emp_ctb_crc.'","type":"string"},
			{"name":"emp_ctb_escritorio","value":"'.$emp_ctb_escritorio.'","type":"string"},
			{"name":"emp_ctb_cnpj","value":"'.$emp_ctb_cnpj.'","type":"string"},
			{"name":"emp_ctb_cep","value":"'.$emp_ctb_cep.'","type":"string"},
			{"name":"emp_ctb_codmun","value":"'.$emp_ctb_codmun.'","type":"string"},
			{"name":"emp_ctb_endereco","value":"'.$emp_ctb_endereco.'","type":"string"},
			{"name":"emp_ctb_num","value":"'.$emp_ctb_num.'","type":"string"},
			{"name":"emp_ctb_compl","value":"'.$emp_ctb_compl.'","type":"string"},
			{"name":"emp_ctb_bairro","value":"'.$emp_ctb_bairro.'","type":"string"},
			{"name":"emp_ctb_fone","value":"'.$emp_ctb_fone.'","type":"string"},
			{"name":"emp_ctb_fax","value":"'.$emp_ctb_fax.'","type":"string"},
			{"name":"emp_ctb_email","value":"'.$emp_ctb_email.'","type":"string"},
			{"name":"emp_sintegra","value":"'.$sintegra.'","type":"string"},
			{"name":"emp_dias_protesto","value":"'.$emp_dias_protesto.'","type":"integer"},
			{"name":"emp_protesto","value":"'.$emp_protesto.'","type":"integer"},
			{"name":"emp_decimais","value":"'.$emp_decimais.'","type":"integer"},
			{"name":"emp_referencia","value":"'.$emp_referencia.'","type":"integer"},
			{"name":"emp_titulo","value":"'.$emp_titulo.'","type":"integer"},
			{"name":"emp_dias_envio","value":"'.$emp_dias_envio.'","type":"integer"},
			{"name":"emp_carne_instr1","value":"'.$emp_carne_instr1.'","type":"string"},
			{"name":"emp_carne_instr2","value":"'.$emp_carne_instr2.'","type":"string"}
		]}';
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		if($ret == "Template 600111: OK"){
			echo "OK";
		}else{
			echo "falha";
		}

		$filtro = '{"cod":"600117","params":[
			{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"},
			{"name":"cfg_dia","value":"'.$cfg_dia.'","type":"integer"},
			{"name":"cfg_qtde_decimais","value":"'.$cfg_qtde_decimais.'","type":"integer"},
			{"name":"cfg_pedido_desc","value":"'.$cfg_pedido_desc.'","type":"integer"},
			{"name":"cfg_rotina","value":"'.$cfg_rotina.'","type":"integer"},
			{"name":"cfg_inativa_ctt","value":"'.$cfg_inativa_ctt.'","type":"integer"},
			{"name":"cfg_suspende_host","value":"'.$cfg_suspende_host.'","type":"integer"},
			{"name":"cfg_suspende_facil","value":"'.$cfg_suspende_facil.'","type":"integer"},
			{"name":"cfg_gera_parcela","value":"'.$cfg_gera_parcela.'","type":"integer"},
			{"name":"cfg_gera_nfse","value":"'.$cfg_gera_nfse.'","type":"integer"},
			{"name":"cfg_agrupa_boleto","value":"'.$cfg_agrupa_boleto.'","type":"integer"},
			{"name":"cfg_envia_boleto","value":"'.$cfg_envia_boleto.'","type":"integer"},
			{"name":"cfg_envia_msg","value":"'.$cfg_envia_msg.'","type":"integer"},
			{"name":"cfg_envia_rel","value":"'.$cfg_envia_rel.'","type":"integer"},
			{"name":"cfg_email_rotina","value":"'.$cfg_email_rotina.'","type":"string"},
			{"name":"cfg_servidor","value":"'.$cfg_servidor.'","type":"string"},
			{"name":"cfg_versao","value":"'.$cfg_versao.'","type":"string"},
			{"name":"cfg_ibpt_detalhe","value":"'.$cfg_ibpt_detalhe.'","type":"string"}
		]}';
		$datapacket->setHost($datapacket->getHost("empresas"));
		$datapacket->add($filtro);
		$datapacket->open();
		$datapacket->clear();
		
	} else if ( isset($_REQUEST['acao']) && $_REQUEST['acao'] == "logo"){

		//logo
		if( isset($_FILES['upload_logo']['tmp_name']) ){
			
			$uploaddir = $datapacket->uploads.$datapacket->getCodigo()."/";
			if (!is_dir($uploaddir))   mkdir($uploaddir, 0777, true);
			$extensao = array_reverse(explode(".", $_FILES['upload_logo']['name']));
			$nome = $extensao[1];
			$extensao = strtolower($extensao[0]);
			
			if($extensao=="jpg" || $extensao=="jpeg" || $extensao=="png" || $extensao=="gif"){
			
				$array1 = array(" ", "á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç");
				$array2 = array("_", "a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C");
				$arq = str_replace($array1, $array2, $_FILES['upload_logo']['name']);
				$nome = str_replace($array1, $array2, $nome);
	
				if(@move_uploaded_file($_FILES['upload_logo']['tmp_name'], $uploaddir.$arq)){
					
					if($extensao != "jpg" && $extensao != "jpeg"){

						if($extensao == "png"){
							$img = imagecreatefrompng($uploaddir.$arq);
						}else if($extensao == "gif"){
							$img = imagecreatefromgif($uploaddir.$arq);
						}
						
						list($width, $height) = getimagesize($uploaddir.$arq);
						$output = imagecreatetruecolor($width, $height);
						$white = imagecolorallocate($output,  255, 255, 255);
						imagefilledrectangle($output, 0, 0, $width, $height, $white);
						imagecopy($output, $img, 0, 0, 0, 0, $width, $height);
						imagejpeg($output, $uploaddir.$nome.".jpg");
						$extensao = "jpg";
					}
					
					$filtro = '{"cod":"700262","params":[
						{"name":"emp_logo","value":"'.$nome.".".$extensao.'","type":"string"},
						{"name":"emp_codigo","value":"'.$datapacket->getCodigo().'","type":"string"}
					]}';
					$datapacket->add($filtro);
					$datapacket->open();
					
					echo '{"success":"true", "msg":"ok"}';
					
				}
				
			}else{
				
				echo "Erro! Somente são aceitos arquivos com extensão: jpg, png ou gif";
				
			}
		
		}

	} else if ( isset($_REQUEST['acao']) && $_REQUEST['acao'] == "certificado"){
		
		if( isset($_FILES['arq_cert']['tmp_name']) ){
			
			$uploaddir = $datapacket->uploads.$datapacket->getCodigo()."/certificados/";
			if (!is_dir($datapacket->uploads.$datapacket->getCodigo()))   mkdir($datapacket->uploads.$datapacket->getCodigo(), 0777, true);
			if (!is_dir($uploaddir))   mkdir($uploaddir, 0777, true);
			$extensao = array_reverse(explode(".", $_FILES['arq_cert']['name']));
			$extensao = strtolower($extensao[0]);
			
			if($extensao=="pfx"){
			
				$array1 = array(" ", "á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç");
				$array2 = array("_", "a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C");
				$arq = str_replace($array1, $array2, $_FILES['arq_cert']['name']);
				
				$filtro = '{"cod":"700174","params":[
					{"name":"emp_pwd_cert","value":"'.$_REQUEST['emp_pwd_cert'].'","type":"string"},
					{"name":"emp_valid_cert","value":" ","type":"string"},
					{"name":"emp_certificado","value":"'.$arq.'","type":"string"},
					{"name":"emp_codigo","value":"'.$datapacket->getCodigo().'","type":"string"}
				]}';
				$datapacket->add($filtro);
				$datapacket->open();
				$datapacket->clear();
	
				if(@move_uploaded_file($_FILES['arq_cert']['tmp_name'], $uploaddir.$arq)){
					
					include 'phpnfe/libs/NFe/ToolsNFePHP.class.php';
					$tools = new ToolsNFePHP;

					if ($aResp = $tools->pLoadCerts()){
				
						if ($tools->certDaysToExpire > 0){
							
							if ($handle = opendir($uploaddir)) {
								while (false !== ($file = readdir($handle))) {
									if($file!=$arq && $file!='.' && $file!='..' && !strstr($file, ".pem") ){
										@unlink($uploaddir.$file);
									}
								}
								closedir($handle);
							}

							if($tools->certDaysToExpire>365){
								$dias = round($tools->certDaysToExpire/10,0);
							} else {
								$dias = $tools->certDaysToExpire;
							}
							$validade = date( "d-m-Y", strtotime("+".$dias." day", strtotime("now")) );
							$validade = implode("-", array_reverse(explode("-", $validade)));
							
							//CERTIFICADO
							$filtro = '{"cod":"700174","params":[
								{"name":"emp_pwd_cert","value":"'.$_REQUEST['emp_pwd_cert'].'","type":"string"},
								{"name":"emp_valid_cert","value":"'.$validade.'","type":"string"},
								{"name":"emp_certificado","value":"'.$arq.'","type":"string"},
								{"name":"emp_codigo","value":"'.$datapacket->getCodigo().'","type":"string"}
							]}';
							$datapacket->add($filtro);
							$datapacket->open();
							
							//enviar dados da empresa e certificado para servidor da NFS-e
							if( isset($_POST["emp_amb_nfse"]) && $_POST["emp_amb_nfse"]!="0" ){
								$url = 'http://prn.grupouds.com.br/php/nfse_config.php'; //url servidor nfs-e
								$host = base64_encode($_SERVER['HTTP_HOST']);
									
								$fields = array(
									'emp_codigo' => $datapacket->getCodigo(),
									'host' => $host,
									'arq'=>new CURLFile($uploaddir.$arq)
								);
								
								if( isset($_POST["emp_logo"]) && $_POST["emp_logo"]!="" && is_file($datapacket->uploads.$datapacket->getCodigo()."/".$_POST["emp_logo"]) && file_exists($datapacket->uploads.$datapacket->getCodigo()."/".$_POST["emp_logo"]) ){
									$fields["emp_logo"] = new CURLFile($datapacket->uploads.$datapacket->getCodigo()."/".substr($_POST["emp_logo"],0,-3)."jpg");
								}

								//abrir conexao
								$ch = curl_init();

								//define url, numero de variaveis POST e dados POST
								curl_setopt($ch,CURLOPT_URL, $url);
								curl_setopt($ch,CURLOPT_POST, count($fields));
								curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
								curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);

								//executa POST
								$result = curl_exec($ch);

								//fechar conexao
								curl_close($ch);
							}
					
							echo '{"success":"true", "msg":"ok"}'; //String que confirma que não houve erros anteriormente (deve ser mantida)

						} else {
							
							echo "Certificado INV&Aacute;LIDO !!!";
							
						}
						
					} else {
						
						echo "Erro!  $tools->errMsg";
						
					}
				}else{
					echo "Erro! Não foi possível enviar o arquivo, verifique as permissões dos diretórios.";
				}
				
			}else{
				echo "Erro! Somente são aceitos arquivos com extensão pfx";
			}
		
		}

	} else if ( isset($_REQUEST['acao']) && $_REQUEST['acao'] == "personalizar"){
		
		print_r(json_encode($datapacket->getCompany()));

	} else if ( isset($_REQUEST['acao']) && $_REQUEST['acao'] == "setBackground"){
		
		$retorno = new stdClass();
		
		if(isset($_REQUEST['usu_login']) && !empty($_REQUEST['usu_login'])) {

			$usuario = explode("@", $_REQUEST['usu_login']);
			$usuario = $usuario[0];
			$usu_login = $_REQUEST['usu_login'];

			$filtro = '{"cod":"600118","params":[
				{"name":"usu_login","value":"'.$usu_login.'","type":"string"}
			]}';
			$datapacket->setHost($datapacket->getHost("empresas"));
			$datapacket->add($filtro);
			$consulta = $datapacket->open(true);
			$datapacket->clear();
			
			if(!empty($consulta) && (isset($consulta[0]->{"usu_background"}) && !empty($consulta[0]->{"usu_background"}))){

				if(is_file($datapacket->getUploads() . $datapacket->getCompany()->{"emp_codigo"} . "/background/" . $usuario . "/" . $consulta[0]->{"usu_background"})){

					$retorno->{"msg"} = "success";
					$retorno->{"imagem"} = $consulta[0]->{"usu_background"};
					$retorno->{"imagem_cfg"} = $consulta[0]->{"usu_background_cfg"};
					echo json_encode($retorno);
					exit();
				}
			}
		}
		
		$retorno->{"msg"} = "error";
		echo json_encode($retorno);
		exit();

	} else {

		if(isset($_REQUEST["emp_codigo"]) && !empty($_REQUEST["emp_codigo"])){
			$emp_codigo = $_REQUEST["emp_codigo"];
		}

		$filtro = '{"cod":"600110","params":[
			{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"}
		]}';
		$datapacket->setHost($datapacket->getHost("empresas"));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		print_r(json_encode($ret));

	}


	
?>