<?php
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	include 'datapacket.php';
	include 'TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	
	function diffDate($d1, $d2, $tipo='mes', $sep='-'){
		$d1 = explode($sep, $d1);
		$d2 = explode($sep, $d2);
		if($tipo=='mes') $X = 2592000;
		elseif($tipo=='dia') $X = 86400;
		return floor( ( ( mktime(0, 0, 0, $d2[1], $d2[2], $d2[0]) - mktime(0, 0, 0, $d1[1], $d1[2], $d1[0] ) ) / $X ) );
	}
	
	function mes($mes){
		switch($mes){
			case "01":
				return "janeiro";
			case "02":
				return "fevereiro";
			case "03":
				return "março";
			case "04":
				return "abril";
			case "05":
				return "maio";
			case "06":
				return "junho";
			case "07":
				return "julho";
			case "08":
				return "agosto";
			case "09":
				return "setembro";
			case "10":
				return "outubro";
			case "11":
				return "novembro";
			case "12":
				return "dezembro";
		}
	}
	
	function extenso($valor=0, $complemento=true) {
		$rt="";
		$singular = array("centavo", "real", "mil", "milhão", "bilhão", "trilhão", "quatrilhão");
		$plural = array("centavos", "reais", "mil", "milhões", "bilhões", "trilhões","quatrilhões");
	 
		$c = array("", "cem", "duzentos", "trezentos", "quatrocentos","quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos");
		$d = array("", "dez", "vinte", "trinta", "quarenta", "cinquenta","sessenta", "setenta", "oitenta", "noventa");
		$d10 = array("dez", "onze", "doze", "treze", "quatorze", "quinze","dezesseis", "dezesete", "dezoito", "dezenove");
		$u = array("", "um", "dois", "três", "quatro", "cinco", "seis","sete", "oito", "nove");
	 
		$z=0;
	 
		$valor = number_format($valor, 2, ".", ".");
		$inteiro = explode(".", $valor);
		for($i=0;$i<count($inteiro);$i++)
			for($ii=strlen($inteiro[$i]);$ii<3;$ii++)
				$inteiro[$i] = "0".$inteiro[$i];
	 
		// $fim identifica onde que deve se dar junção de centenas por "e" ou por "," ;) 
		$fim = count($inteiro) - ($inteiro[count($inteiro)-1] > 0 ? 1 : 2);
		for ($i=0;$i<count($inteiro);$i++) {
			$valor = $inteiro[$i];
			$rc = (($valor > 100) && ($valor < 200)) ? "cento" : $c[$valor[0]];
			$rd = ($valor[1] < 2) ? "" : $d[$valor[1]];
			$ru = ($valor > 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : $u[$valor[2]]) : "";
		
			$r = $rc.(($rc && ($rd || $ru)) ? " e " : "").$rd.(($rd && $ru) ? " e " : "").$ru;
			$t = count($inteiro)-1-$i;
			if ($complemento == true) {
				$r .= $r ? " ".($valor > 1 ? $plural[$t] : $singular[$t]) : "";
				if ($valor == "000")$z++; elseif ($z > 0) $z--;
				if (($t==1) && ($z>0) && ($inteiro[0] > 0)) $r .= (($z>1) ? " de " : "").$plural[$t]; 
			}
			
			if ($r) $rt = $rt . ((($i > 0) && ($i <= $fim) && ($inteiro[0] > 0) && ($z < 1)) ? ( ($i < $fim) ? ", " : " e ") : " ") . $r;
		}
	 
		return($rt ? $rt : "zero");
	}
	
	$uploaddir = $TParams->uploads.$TParams->getCodigo()."/contratos/modelos/";
	$contratosdir = $TParams->uploads.$TParams->getCodigo()."/contratos/";
	
	
	
	//excluir arquivo modelo
	if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="excluir" ){
		
		if( unlink($uploaddir.$_REQUEST["arq"]) ) echo "ok";
	
	//impressão
	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="imprimir" ){
		
		include_once "../class/PHPWord.php";
		$PHPWord = new PHPWord();
		
		$ctt_codigo = $_REQUEST["ctt_codigo"];
		
		$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
		
		$filtro = '{"cod":"700718","params":[
			{"name":"ctt_codigo","value":"'.$ctt_codigo.'","type":"integer"},
			{"name":"db","value":"'.$TParams->getDb().'","type":"other"}
		]}';
		$datapacket->add($filtro);
		$contrato = $datapacket->open();
		$contrato = $contrato[0];
		
		if($contrato){
			
			//tratamento de dados
			$cad_cnpjcpf = ( strlen($contrato["cad_cnpjcpf"])==11 ) ? substr($contrato["cad_cnpjcpf"], 0, 3).".".substr($contrato["cad_cnpjcpf"], 3, 3).".".substr($contrato["cad_cnpjcpf"], 6, 3)."-".substr($contrato["cad_cnpjcpf"], 9, 11) : substr($contrato["cad_cnpjcpf"], 0, 2).".".substr($contrato["cad_cnpjcpf"], 2, 3).".".substr($contrato["cad_cnpjcpf"], 5, 3)."/".substr($contrato["cad_cnpjcpf"], 8, 4)."-".substr($contrato["cad_cnpjcpf"], 12, 2);
			$ctt_valor = number_format(($contrato["ctt_valor"]-$contrato["ctt_desconto"]+$contrato["ctt_acrescimo"]), 2, ",", ".");
			$ctt_valor2 = number_format(($contrato["ctt_valor"]-$contrato["ctt_desconto"]+$contrato["ctt_acrescimo"]), 2, ".", ",");
			$vencimento = (isset($contrato["frq_codigo"])) ? $contrato["ctt_datavcto"] : substr($contrato["ctt_datacobr"], 8, 2);
			$cep = substr($contrato["end_cep"], 0, 5)."-".substr($contrato["end_cep"], 5, 3);
			$vigencia = diffDate($contrato["ctt_dataini"], $contrato["ctt_datafim"]);
			$vigenciaDias = diffDate($contrato["ctt_dataini"], $contrato["ctt_datafim"], 'dia');
			
			$doc = $PHPWord->loadTemplate($uploaddir.$_REQUEST["arq"]);
			
			//substituição dos campos fixos por dados reais
			$doc->setValue('NUMERO', $contrato["ctt_numero"]);
			$doc->setValue('CLIENTE', $contrato["cad_nomeraz"]);
			$doc->setValue('FANTASIA', $contrato["cad_snomefant"]);
			$doc->setValue('CPF', $cad_cnpjcpf);
			$doc->setValue('RG', $contrato["cad_inscrg"]);
			$doc->setValue('ENDERECO', utf8_decode($contrato["end_nome"].", nº ".$contrato["end_num"]." - Bairro: ".$contrato["end_bairro"].", CEP: ".$cep.", Município de ".$contrato["end_cidade"]." - ".$contrato["end_uf"]));
			$doc->setValue('TELEFONE', "(".$contrato["tel_ddd"].") ".$contrato["tel_prefixo"]."-".$contrato["tel_numero"]);
			$doc->setValue('EMAIL', strtolower($contrato["eml_ender"]));
			$doc->setValue('DATA', substr($contrato["ctt_data"], 8, 2)." de ".mes(substr($contrato["ctt_data"], 5, 2))." de ".substr($contrato["ctt_data"], 0, 4));
			$doc->setValue('INICIO', implode("/", array_reverse(explode("-", $contrato["ctt_dataini"]))));
			$doc->setValue('TERMINO', implode("/", array_reverse(explode("-", $contrato["ctt_datafim"]))));
			$doc->setValue('VIGENCIA', $vigencia." meses");
			$doc->setValue('DIASVIGENCIA', $vigenciaDias." dias");
			$doc->setValue('SERVICO', $contrato["svc_descr"]);
			$doc->setValue('DESCRICAO', base64_decode($contrato["ctt_svc_obs"]));
			$doc->setValue('LOCAL', $contrato["eve_descricao"]);
			$doc->setValue('LOCALDATA1', implode("/", array_reverse(explode("-", substr($contrato["eve_inicio"], 0, 10)))));
			$doc->setValue('LOCALSEMANA1', $contrato["eve_inicio_semana"]);
			$doc->setValue('LOCALHORA1', substr($contrato["eve_inicio"], 11, 5));
			$doc->setValue('LOCALDATA2', implode("/", array_reverse(explode("-", substr($contrato["eve_termino"], 0, 10)))));
			$doc->setValue('LOCALSEMANA2', $contrato["eve_termino_semana"]);
			$doc->setValue('LOCALHORA2', substr($contrato["eve_termino"], 11, 5));
			$doc->setValue('VALOR', $ctt_valor." (".trim(extenso($ctt_valor2)).")");
			$doc->setValue('FREQUENCIA', $contrato["frq_descricao"]);
			$doc->setValue('VENCIMENTO', $vencimento);
			$doc->setValue('PAGAMENTO', $contrato["cdp_descr"]);
			$doc->setValue('OBS', base64_decode($contrato["ctt_obs"]));
			$doc->setValue('TESTEMUNHA1', $contrato["ctt_testemunha1"]);
			$doc->setValue('TESTEMUNHACPF1', $contrato["ctt_testemunha1cpf"]);
			$doc->setValue('TESTEMUNHA2', $contrato["ctt_testemunha2"]);
			$doc->setValue('TESTEMUNHACPF2', $contrato["ctt_testemunha2cpf"]);
			
			if (!is_dir($contratosdir.$ctt_codigo)) mkdir($contratosdir.$ctt_codigo, 0777, true);
			
			$doc->save($contratosdir.$ctt_codigo."/".$ctt_codigo.".docx");
			
			sleep(2);
			
			exit($TParams->uploads2.$TParams->getCodigo()."/contratos/".$ctt_codigo."/".$ctt_codigo.".docx");
			
		}
	
	//upload de modelo
	}elseif( isset($_FILES['photo']['tmp_name']) ){
		
		$extensao = array_reverse(explode(".", $_FILES['photo']['name']));
		$extensao = strtolower($extensao[0]);
		
		if($extensao!="docx") exit("Somente são aceitos arquivos com extensão .docx");
		
		$array1 = array(" ", "á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç");
		$array2 = array("_", "a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C");
		
		$arq = str_replace($array1, $array2, $_FILES['photo']['name']);

		if (!is_dir($uploaddir))   mkdir($uploaddir, 0777, true);
			
		if(move_uploaded_file($_FILES['photo']['tmp_name'], $uploaddir.$arq)){
			
			echo "ok";
			
		}else{
			
			echo "Erro ao tentar efetuar upload!";
			
		}
	
	//listar arquivos de modelo
	}else{
		$arquivos = array();
		if(is_dir($uploaddir)){
			$diretorio = dir($uploaddir);
			$i=0;
			while($arquivo = $diretorio -> read()){
				if($arquivo!="" && $arquivo!="." && $arquivo!=".."){
					$arquivos[$i]["arquivo"] = $arquivo;
					$i++;
				}
			}
			$diretorio -> close();
			print_r(json_encode($arquivos));
		}
	}

?>