<?php

	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	include 'datapacket.php';
	include 'TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
	
	function modulo_11($num, $base=9, $r=0){
		$soma = 0;
		$fator = 2;
		for ($i = strlen($num); $i > 0; $i--) {
			$numeros[$i] = substr($num,$i-1,1);
			$parcial[$i] = $numeros[$i] * $fator;
			$soma += $parcial[$i];
			if ($fator == $base) {
				$fator = 1;
			}
			$fator++;
		}
		if ($r == 0) {
			$soma *= 10;
			$digito = $soma % 11;
			if ($digito == 10) {
				$digito = 0;
			}
			return $digito;
		} elseif ($r == 1){
			$resto = $soma % 11;
			return $resto;
		}
	}
	
	//servidor de homologação
	$url = 'http://b.grupouds.com.br:8082/php/';
	
	$fields_string="";
	
	if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="gerar" && isset($_REQUEST["boletos"]) ){
		
		$company = $TParams->getCompany();
		
		$bancos = json_decode(base64_decode($company->emp_bancos));
		
		if( is_array($bancos) && count($bancos)>0 ){
			
			foreach($bancos as $banco){
				if( $banco->carteira==$_REQUEST["carteira"] ){
					$ban = $banco;
				}
			}
			
			if( isset($ban) ){
			
				//validar bancos e carteiras ja homologados
				if( ($ban->banco_numero=="033" && $ban->layout_remessa=="FEBRABAN240") || ($ban->banco_numero=="756") || ($ban->banco_numero=="001" && $ban->layout_remessa=="CBR641") || ($ban->banco_numero=="237" && $ban->layout_remessa=="FEBRABAN240") || ($_SERVER['HTTP_HOST']=="dev.grupouds.com.br" || $_SERVER['HTTP_HOST']=="192.168.1.251") ){
					
					include_once "./remessaPHP/Remessa.class.php";
					include_once "./remessaPHP/Documento.class.php";
					
					//ultima remessa
					$filtro = '{"cod":"700755","params":[
						{"name":"db","value":"'.$TParams->getDbSge().'","type":"string"}
					]}';
					$datapacket->add($filtro);
					$rem = $datapacket->open();
					$datapacket->clear();
					$rem = $rem[0]["rem_codigo"];
					
					if( isset($_REQUEST["codigoMovimento"]) ){
						$codigoMovimento = $_REQUEST["codigoMovimento"];
					}else{
						$codigoMovimento = 1; // 1 para registro de titulos no banco, alterar em caso de outras ações na remessa
					}
					
					//doctos
					$doc_codigo = json_decode($_REQUEST["boletos"]);
					$codigos="";
					if( is_array($doc_codigo)){
						$total = count($doc_codigo);
						foreach($doc_codigo as $c) $codigos.= "'".$c."', ";
						$codigos = substr($codigos, 0, -2);
					}else{
						$total=1;
						$codigos="'".$_REQUEST["boletos"]."'";
					}
					if($codigos!=""){
						$filtro = '{"cod":"500480","params":[
							{"name":"doc_codigo","value":"'.$codigos.'","type":"other"},
							{"name":"database","value":"'.$company->{'emp_db_comum'}.'","type":"other"}
						]}';
						$datapacket->add($filtro);
						$doctos = $datapacket->open(true);
						$datapacket->clear();
					}
					
					$dir = $TParams->uploads.$_REQUEST["emp_codigo"]."/remessa/";
					if( !is_dir($dir) ){
						mkdir($dir, 0777);
					}
					
					//nome do arquivo
					$arquivo = $rem.".txt";
					
					//registro da remessa no banco
					$filtro= '{"cod":"700733", "params":[
						{"name":"rem_arquivo", "value":"'.$arquivo.'", "type":"string"},
						{"name":"rem_usuario", "value":"'.$_POST["usu_login"].'", "type":"string"},
						{"name":"rem_total", "value":"'.$total.'", "type":"integer"},
						{"name":"rem_movimento", "value":"'.$codigoMovimento.'", "type":"integer"}
					]}';
					$datapacket->add($filtro);
					//atualização flags
					$filtro= '{"cod":"700734", "params":[
						{"name":"doc_codigo", "value":"'.$codigos.'", "type":"other"}
					]}';
					$datapacket->add($filtro);
					$datapacket->open();
					$datapacket->clear();
					
					$Remessa = new Remessa($dir.$arquivo, $ban->layout_remessa, $ban->banco_numero);
					$Documento = new Documento($ban->layout_remessa, $ban->banco_numero);
					
					$contrato=""; //numero do contrato ou código de transmissão
					$versao=20; //versao do layout do arquivo
					$versaoLote=20; //versao do lote
					$convenio = $ban->convenio; //convenio, cliente, cedente ou psk
					$carteira = substr($ban->carteira, -1, 1); //codigo da carteira na remessa
					$numeroCarteira = $ban->carteira; //codigo da carteira no sistema
					$dv=" "; //dv agencia/conta
					
					//validar o banco - atribuir valores conforme as variações de banco/carteira
					//Banco do Brasil
					if($ban->banco_numero=="001"){
						$ban->variacao = str_pad($ban->variacao, 3, "0", STR_PAD_LEFT);
						if($ban->layout_remessa=="CBR641"){
							$convenio = $ban->convenio;
						}else{
							$convenio = str_pad($ban->convenio, 9, "0", STR_PAD_LEFT)."0014".$ban->carteira.$ban->variacao;
						}
						$carteira = substr($ban->carteira, -1, 1);
					//Santander
					}elseif($ban->banco_numero=="033"){
						$convenio = $ban->contrato;
						$contrato = $ban->contrato;
						$versao=40;
						$versaoLote=30;
						$dv = $ban->conta.$ban->contadv;
						if($ban->carteira=="101"){
							$carteira = '5';
						}elseif($ban->carteira=="201"){
							$carteira = '6';
						}else{
							$carteira = '5';
						}
					//Caixa
					}elseif($ban->banco_numero=="104"){
						$carteira = "1";
						$versao=50;
						$versaoLote=30;
					//Bradesco
					}elseif($ban->banco_numero=="237"){
						$carteira = "1";
						$versao=82;
						$versaoLote=41;
					//Sicoob
					}elseif($ban->banco_numero=="756"){
						$ban->agencia = $ban->carteira;
						$ban->agenciadv = modulo_11($ban->carteira);
						$convenio = $ban->convenio;
						$carteira = "1";
						$versao=81;
						$versaoLote=40;
					}				
					
					//atribuir valores a remessa
					$Remessa->_set('banco', $ban->banco_numero) //código do banco
					->_set('arquivoLayout', $versao) //versao do layout do arquivo
					->_set('inscricaoNumero', $company->emp_cpfcnpj) //cpf/cnpj do beneficiario
					->_set('convenio', $convenio) //cedente, cliente, convenio ou psk
					->_set('agenciaCodigo', $ban->agencia) //numero da agencia
					->_set('agenciaDv', $ban->agenciadv) //dv da agencia
					->_set('contaNumero', $ban->conta) // numero da conta
					->_set('contaDv', $ban->contadv) //dv da conta
					->_set('empresaNome', $company->emp_razao) //nome da pesoa ou empresa beneficiaria
					->_set('arquivoSequenciaNsa', $rem) //numero sequencial do arquivo de remessa
					;
					
					//cabeçalho do arquivo
					$Remessa->write($Remessa->headerArquivo());				
					
					if( isset($doctos) && count($doctos)>0 ){
						
						$i=0;
						foreach($doctos as $docto){
							
							//vinculo remessa->docto
							$filtro = '{"cod":"700737", "params":[
								{"name":"rem_codigo", "value":"'.$rem.'", "type":"integer"},
								{"name":"doc_codigo", "value":"'.$docto->doc_codigo.'", "type":"string"}
							]}';
							$datapacket->add($filtro);
							
							//verifica se titulo sera protestado
							if(isset($docto->doc_protesto) && $docto->doc_protesto>0 ){
								$protesto = "1"; //protestar titulo
								$prazoProtesto = $docto->doc_dias_protesto; //dias para protestar
								$devolucao = "2"; //nao devolver
								$prazoDevolucao = "000";
							}else{
								$protesto = "0"; //nao protestar titulo
								$prazoProtesto = "00";
								$devolucao = "1"; //devolver
								$prazoDevolucao = $docto->doc_dias_protesto; //dias para devolução
							}
							
							//instrução boleto
							if($docto->doc_descr!=""){
								$informacao3 = $docto->doc_descr;
							}elseif($company->emp_instr1!=""){
								$informacao3 = $company->emp_instr1;
							}else{
								$informacao3 = "";
							}
							
							//juros
							$jurosMora = ($docto->doc_valor*$docto->doc_juros)/100;
							if($jurosMora>0){
								$jurosMora = number_format($jurosMora,2);
							}
							
							//atribuir valores ao documento
							$Documento->_set('banco', $ban->banco_numero)
							->_set('layoutLote', $versaoLote)
							->_set('inscricaoNumero', $company->emp_cpfcnpj)
							->_set('convenio', $convenio)
							->_set('contrato', $contrato)
							->_set('agenciaCodigo', $ban->agencia)
							->_set('agenciaDv', $ban->agenciadv)
							->_set('contaNumero', $ban->conta)
							->_set('contaDv', $ban->contadv)
							->_set('dv', $dv)
							->_set('empresaNome', $company->emp_razao)
							->_set('numeroRemessaRetorno', $rem)
							->_set('codigoMovimento', $codigoMovimento) // 1 para registro de titulos no banco, alterar em caso de outras ações na remessa
							->_set('carteira', $carteira) //código da carteira na remessa
							->_set('variacao', $ban->variacao) //código da carteira na remessa
							->_set('numeroCarteira', $numeroCarteira) //codigo da carteira no sistema
							->_set('nossoNumero', $docto->doc_nossonumero)
							->_set('numeroDocumento', $docto->doc_numero)
							->_set('vencimento', implode("", array_reverse(explode("-", substr($docto->doc_dtvcto,0,10)))))
							->_set('valorTitulo', $docto->doc_valor)
							->_set('dataEmissaoTitulo', implode("", array_reverse(explode("-", substr($docto->doc_data,0,10)))))
							->_set('dataJurosMora', implode("", array_reverse(explode("-", substr($docto->doc_dtvcto,0,10)))))
							->_set('jurosMora', $jurosMora)
							->_set('codigoProtesto', $protesto)
							->_set('prazoProtesto', $prazoProtesto)
							->_set('codigoBaixaDevolucao', $devolucao)
							->_set('prazoBaixaDevolucao', $prazoDevolucao)
							->_set('inscricaoNumeroSacado', $docto->cad_cnpjcpf)
							->_set('sacadoNome', $docto->cad_nomeraz)
							->_set('endereco', $docto->cad_end.", ".$docto->end_num)
							->_set('bairro', $docto->end_bairro)
							->_set('cep', $docto->end_cep)
							->_set('cidade', $docto->end_cidade)
							->_set('uf', $docto->end_uf)
							->_set('inscricaoNumeroSacadorAvalista', $docto->sac_cnpjcpf)
							->_set('nomeSacadorAvalista', $docto->sac_nomeraz)
							->_set('dataMulta', implode("", array_reverse(explode("-", substr($docto->doc_dtvcto,0,10)))))
							->_set('multa', $docto->doc_multa)
							->_set('informacao3', $informacao3)
							;
							
							//cabecalho do lote
							if($i==0) $Remessa->write($Documento->headerLote());
							
							//detalhe do lote
							$Remessa->write($Documento->detalheLote());
							
							//trailer do  lote
							$Documento->_set('quantidadeRegistro', ($Documento->numeroRegistro+2));
							if($i==(count($doctos)-1)) $Remessa->write($Documento->trailerLote());
							
							$i++;
						}
						
						//trailer do arquivo
						$Remessa->_set('quantidadeRegistro', ($Documento->quantidadeRegistro+2));
						$Remessa->write($Remessa->trailerArquivo());
						
						$Remessa->close();
						
						$datapacket->open();
						$datapacket->clear();
						exit("ok");
						
					}else{
						exit("Não há documentos para remessa");
					}
					
					
					
				//cobrebemX para demais casos	
				}else{
					
					$fields = array(
						'emp_codigo' => base64_encode($_REQUEST["emp_codigo"]),
						'carteira' => urlencode($_REQUEST["carteira"]),
						'boletos' => urlencode($_REQUEST["boletos"])
					);
					
					if($_SERVER['HTTP_HOST']=="192.168.1.251"){
						$fields["sis"]="251";
					}elseif($_SERVER['HTTP_HOST']=="facil.uds.com.br"){
						$fields["sis"]="248";
					}elseif($_SERVER['HTTP_HOST']=="dev.grupouds.com.br"){
						$fields["sis"]="110";
					}

					//url-ify os dados para o POST
					foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
					rtrim($fields_string, '&');

					//abrir conexao
					$ch = curl_init();

					//define url, numero de variaveis POST e dados POST
					curl_setopt($ch,CURLOPT_URL, $url."gerar_remessa_novo.php");
					curl_setopt($ch,CURLOPT_POST, count($fields));
					curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

					//executa POST
					$result = curl_exec($ch);

					//fechar conexao
					curl_close($ch);
					
				}
			
			}else{
				exit("a carteira selecionada não está cadastrada no sistema");
			}
			
		}else{
			exit("Não existem contas bancárias cadastradas para esta empresa.");
		}

	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="baixar" && isset($_REQUEST["rem_codigo"]) && isset($_REQUEST["arq"]) ){
		
		$company = $TParams->getCompany();

		$filtro = '{"cod":"700741","params":[
			{"name":"rem_codigo","value":"'.$_REQUEST['rem_codigo'].'","type":"integer"}
		]}';
		
		$datapacket->add($filtro);
		
		$datapacket->open();
		
		//antigo
		if( strlen($_REQUEST["arq"])==12 ){
			exit($url."salvararquivo.php?arquivo=".$company->emp_cpfcnpj."/remessa/".$_REQUEST["arq"]);
		//novo
		}else{
			exit("./php/download.php?file=".$TParams->uploads.$company->emp_codigo."/remessa/".$_REQUEST["arq"]);
		}

	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="desfazer" && isset($_REQUEST["rem_codigo"]) && isset($_REQUEST["arq"]) ){
		
		$company = $TParams->getCompany();
		
		//CORRIGIR REMESSA GERADA (VOLTAR FLAG DA REMESSA PARA BOLETO PODER VOLTAR A SER INCLUIDO)
		$datapacket->add('{"cod":"700735", "params":[{"name":"rem_codigo", "value":"'.$_REQUEST["rem_codigo"].'", "type":"integer"}]}');
		$datapacket->open();
		
		$fields = array(
			'arquivo' => "../uploads/sge/".$company->emp_cpfcnpj."/remessa/".$_REQUEST["arq"]
		);
		
		if($_SERVER['HTTP_HOST']=="192.168.1.251"){
			$fields["sis"]="251";
		}elseif($_SERVER['HTTP_HOST']=="dev.grupouds.com.br"){
			$fields["sis"]="110";
		}
		
		//url-ify os dados para o POST
		foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
		rtrim($fields_string, '&');

		//abrir conexao
		$ch = curl_init();

		//define url, numero de variaveis POST e dados POST
		curl_setopt($ch,CURLOPT_URL, $url."excluirarquivo.php");
		curl_setopt($ch,CURLOPT_POST, count($fields));
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

		//executa POST
		$result = curl_exec($ch);

		//fechar conexao
		curl_close($ch);
		
	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="excluir" && isset($_REQUEST["rem_codigo"]) && isset($_REQUEST["arq"]) ){
		
		$company = $TParams->getCompany();
		
		//EXCLUIR REMESSA GERADA
		$datapacket->add('{"cod":"700742", "params":[{"name":"rem_codigo", "value":"'.$_REQUEST["rem_codigo"].'", "type":"integer"}]}');
		$datapacket->open();
		
		$fields = array(
			'arquivo' => "../uploads/sge/".$company->emp_cpfcnpj."/remessa/".$_REQUEST["arq"]
		);
		
		if($_SERVER['HTTP_HOST']=="192.168.1.251"){
			$fields["sis"]="251";
		}elseif($_SERVER['HTTP_HOST']=="dev.grupouds.com.br"){
			$fields["sis"]="110";
		}

		//url-ify os dados para o POST
		foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
		rtrim($fields_string, '&');

		//abrir conexao
		$ch = curl_init();

		//define url, numero de variaveis POST e dados POST
		curl_setopt($ch,CURLOPT_URL, $url."excluirarquivo.php");
		curl_setopt($ch,CURLOPT_POST, count($fields));
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

		//executa POST
		$result = curl_exec($ch);

		//fechar conexao
		curl_close($ch);
		
	}else{
		
		$filtro = '{"cod":"700739","params":[]}';
		
		$datapacket->add($filtro);
		
		$ret = $datapacket->open();
		
		print_r(json_encode($ret));
		
	}

?>