<?php

	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	include 'datapacket.php';
	include 'TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
	
	$uploaddir = $TParams->uploads.$TParams->getCodigo()."/retorno/";
	
	//servidor de homologação
	if($_SERVER['HTTP_HOST']=="192.168.1.251"){
		$url = "http://131.161.72.52/php/retorno_novo.php";
	}else{
		$url = 'http://b.grupouds.com.br/php/retorno_novo.php';
	}
	
	$fields_string = "";
	$cont=0;
	
	if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="incluir" && isset($_FILES["arquivo_ret"]["tmp_name"]) ){
		
		foreach($_FILES['arquivo_ret']['name'] as $nomeArq){
			
			$erro = false;
			
			$extensao = array_reverse(explode(".", $nomeArq));
			$nomeArq = $extensao[1];
			$extensao = strtolower($extensao[0]);
			
			if($extensao!="ret"){
				$erro = true;
				echo "Arquivo ".$nomeArq." inválido, somente são aceitos arquivos com extensão .ret<br>   ";
			}
			$arq = $nomeArq.".".$extensao;
			
			/*busca por já cadastrados*/
			$filtroB = '{"cod":"700752","params":[
				{"name":"ret_arquivo","value":"'.$arq.'","type":"string"}
			]}';
			$datapacket->add($filtroB);
			$ret = $datapacket->open();
			$datapacket->clear();
			
			if( is_array($ret) && isset($ret[0]["ret_arquivo"]) && $ret[0]["ret_arquivo"]==$arq ){
				$erro = true;
				echo "O arquivo ".$arq." já foi enviado!<br>   ";
			}
			
			if($erro ==false){
				//se nao existir diretoria, cria
				if (!is_dir($uploaddir))   mkdir($uploaddir, 0777, true);
				
				//upload local
				if(move_uploaded_file($_FILES['arquivo_ret']['tmp_name'][$cont], $uploaddir.$arq)){
					
					$company = $TParams->getCompany();
					
					//salvando no banco
					$filtro = '{"cod":"700743","params":[
						{"name":"ret_arquivo","value":"'.$arq.'","type":"string"}
					]}';
					$datapacket->add($filtro);
					if($datapacket->open()){
						
						//pegando dados do arquivo para salvá-lo remotamente
						$conteudo = file_get_contents($uploaddir.$arq);
						
						$fields = array(
							'acao' => 'incluir',
							'emp_cpfcnpj' => $company->emp_cpfcnpj,
							'arq' => urlencode($arq),
							'conteudo' => urlencode($conteudo)
						);

						//url-ify os dados para o POST
						foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
						rtrim($fields_string, '&');

						//abrir conexao
						$ch = curl_init();

						//define url, numero de variaveis POST e dados POST
						curl_setopt($ch,CURLOPT_URL, $url);
						curl_setopt($ch,CURLOPT_POST, count($fields));
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

						//executa POST
						$result = curl_exec($ch);

						//fechar conexao
						curl_close($ch);				
						$datapacket->clear();
						
					}else{
						echo "Não foi possível inserir o registro do Arquivo ".$arq."<br>";
					}
					
				}else{
					echo "Erro ao tentar efetuar upload do arquivo ".$arq."<br>";
				}
				$cont++;
			}
		}

	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="excluir" && isset($_REQUEST["arq"]) ){
		
		$company = $TParams->getCompany();
		$codigos = "";
		$_REQUEST["ret_codigo"] = json_decode($_REQUEST["ret_codigo"]);
		if( strstr($_REQUEST["arq"], "[") && strstr($_REQUEST["arq"], "]") ) $_REQUEST["arq"] = json_decode($_REQUEST["arq"]);

		if( is_array($_REQUEST["ret_codigo"]) ){
			foreach($_REQUEST["ret_codigo"] as $codigo){
				$codigos.= $codigo.", ";
			}
			$codigos = substr($codigos, 0, -2);
			foreach($_REQUEST["arq"] as $arquivo){
				if( is_file($uploaddir.$arquivo) ) @unlink($uploaddir.$arquivo);	
			}
		}else{
			$codigos = $_REQUEST["ret_codigo"];
			if( is_file($uploaddir.$_REQUEST["arq"]) ) @unlink($uploaddir.$_REQUEST["arq"]);	
		}
		
		//excluindo no banco
		$filtro = '{"cod":"700745","params":[
			{"name":"ret_codigo","value":"'.$codigos.'","type":"other"}
		]}';
		
		$datapacket->add($filtro);
		if($datapacket->open()){
			
			$fields = array(
				'acao' => 'excluir',
				'emp_cpfcnpj' => $company->emp_cpfcnpj,
				'arq' => urlencode(json_encode($_REQUEST["arq"]))
			);

			//url-ify os dados para o POST
			foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
			rtrim($fields_string, '&');

			//abrir conexao
			$ch = curl_init();

			//define url, numero de variaveis POST e dados POST
			curl_setopt($ch,CURLOPT_URL, $url);
			curl_setopt($ch,CURLOPT_POST, count($fields));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

			//executa POST
			$result = curl_exec($ch);

			//fechar conexao
			curl_close($ch);
		}
		
	}elseif( isset($_POST["acao"]) && $_POST["acao"]=="executar" && isset($_POST["arq"]) ){
		
		include_once "remessaPHP/Retorno.class.php";
		include_once "remessaPHP/Documento.class.php";
		
		$Retorno = new Retorno($uploaddir.$_POST["arq"]);
		
		$company = $TParams->getCompany();
		
		//somente Sicoob layout de 400 posições
		if( isset($Retorno->banco) && isset($Retorno->layout) && (($Retorno->banco=="756" && $Retorno->layout=="CNAB400") || ($Retorno->banco=="033" && $Retorno->layout=="FEBRABAN240") ) ){
			
			if($Retorno->inscricaoNumero==$company->emp_cpfcnpj){
				
				//dados do retorno
				$certo=0;
				$errado=0;
				
				$banco = $Retorno->banco;
				$agencia = $Retorno->agenciaCodigo."-".$Retorno->agenciaDv;
				$convenio = $Retorno->convenio;
				$layout = $Retorno->layout;
				$inscricao = $Retorno->inscricaoNumero;
				$conta = $Retorno->contaNumero."-".$Retorno->contaDv;
				
				//dados dos documentos (ocorrencias)
				$Documento = new Documento($Retorno->layout, $Retorno->banco);
				
				//total de titulos confoirme layout
				if($Retorno->layout=="CNAB400"){
					$inicio=1;
					$total = (count($Retorno->arquivo)-2);
					$incremento=1;
				}elseif($Retorno->layout=="FEBRABAN240"){
					$inicio=2;
					$total = (count($Retorno->arquivo)-2);
					$incremento=2;
				}

				for($i = $inicio; $i <= $total; $i = $i + $incremento){
					
					$nossoNumero = $Documento->_get('nossoNumero', $Retorno->arquivo[$i]);
					$parcela = $Documento->_get('parcela', $Retorno->arquivo[$i]);
					$codigoBaixaDevolucao = $Documento->_get('codigoBaixaDevolucao', $Retorno->arquivo[$i]);
					$codigoMovimento = $Documento->_get('codigoMovimento', $Retorno->arquivo[$i]);
					$dataRegistroLiquidacao = $Documento->_get('dataEmissaoTitulo', $Retorno->arquivo[$i]);
					$numeroDocumento = $Documento->_get('numeroDocumento', $Retorno->arquivo[$i]);
					$vencimento = $Documento->_get('vencimento', $Retorno->arquivo[$i]);
					$valorTitulo = $Documento->_get('valorTitulo', $Retorno->arquivo[$i]);
					$especieTitulo = $Documento->_get('especieTitulo', $Retorno->arquivo[$i]);
					$dataCredito = ($Retorno->layout=="FEBRABAN240") ? $Documento->_get('dataCredito', $Retorno->arquivo[$i+1]) : $Documento->_get('dataCredito', $Retorno->arquivo[$i]);
					$valorTarifa = $Documento->_get('valorTarifa', $Retorno->arquivo[$i]);
					$valorRecebido = ($Retorno->layout=="FEBRABAN240") ? $Documento->_get('valorRecebido', $Retorno->arquivo[$i+1]) : $Documento->_get('valorRecebido', $Retorno->arquivo[$i]);
					$valorLancamento = ($Retorno->layout=="FEBRABAN240") ? $Documento->_get('valorLancamento', $Retorno->arquivo[$i+1]) : $Documento->_get('valorLancamento', $Retorno->arquivo[$i]);
					$desconto = ($Retorno->layout=="FEBRABAN240") ? $Documento->_get('desconto1', $Retorno->arquivo[$i+1]) : $Documento->_get('desconto1', $Retorno->arquivo[$i]);
					$juros = ($Retorno->layout=="FEBRABAN240") ? $Documento->_get('jurosMora', $Retorno->arquivo[$i+1]) : $Documento->_get('jurosMora', $Retorno->arquivo[$i]);
					$multa = $Documento->_get('multa', $Retorno->arquivo[$i]);
					$descr = "";
					
					if( $nossoNumero!="" && (int) $nossoNumero!=0 ){
						//descrição da ocorrencia de acordo com o layout/banco
						switch($codigoMovimento){
							case '02':
								$descr = "Título registrado pelo Banco";
								break;
							case '03':
								$descr = "Entrada rejeitada";
								break;
							case '05':
								$descr = "Transferência de carteira/ baixa";
								break;
							case '06':
								$descr = "Liquidação Normal";
								break;
							case '09':
								$descr = "Baixa Manual";
								break;
							case '10':
								$descr = "Baixa Solicitada";
								break;
							case '11':
								$descr = "Em Ser (em aberto)";
								break;
							case '14':
								$descr = "Alteração de Vencimento";
								break;
							case '15':
								$descr = "Liquidação em Cartório";
								break;
							case '17':
								$descr = "Liquidação Sem Registro";
								break;
							case '23':
								$descr = "Encaminhado p/ protesto";
								break;
							case '27':
								$descr = "Alteração de dados";
								break;
							case '48':
								$descr = "Transferência de carteira/ modalidade";
								break;
						}
						
						$datapacket->clear();
						$datapacket->add('{"cod":"700747", "params":[{"name":"doc_nossonumero", "value":"'.$nossoNumero.'", "type":"string"}]}'); //buscar o boleto
						$ret = $datapacket->open();
						$datapacket->clear();
						
						//boletos de e-commerce
						if( $valorRecebido>0 && isset($ret[0]["ser_codigo"]) && $ret[0]["ser_codigo"]=="ECM" ){
							
							$datapacket->add('{"cod":"700765", "params":[{"name":"doc_codigo", "value":"'.$ret[0]["doc_codigo"].'", "type":"string"}]}'); //buscar o pedido (e-commerce)
							$ped = $datapacket->open();
							$datapacket->clear();
							
							if( isset($ped[0]) && count($ped)>0 ){
								
								//atualizar pedido
								$filtro = '{"cod":"700756","params":[
									{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"}
								]}';
								$datapacket->add($filtro);
								$datapacket->open();
								$datapacket->clear();
								
								// Enviando o email para o FACIL através de uma requisição POST
								$fields = array(
									'p' => $_REQUEST['p'],
									'acao' => 'email',
									'not_codigo' => $ped[0]["not_codigo"]
								);

								$fields_string = ''; //url-ify the data for the POST
								foreach($fields as $key => $value) $fields_string .= $key.'='.$value.'&';
								rtrim($fields_string, '&');

								if(!empty($fields_string)){
									$ch = curl_init(); //Abre conexão
									curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/ecommerce.php"); //Seta URL
									curl_setopt($ch,CURLOPT_POST, count($fields)); //Seta quantidade de campos
									curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string); //Seta valores dos mesmos
									curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // ativa o retorno do curl
									$codigoSalvo = curl_exec($ch); //Executa o post
									curl_close($ch); //Fecha conexão
								}
								
							}
							
						}
						
						//boletos de contrato, desbloquear contrato (somente uds)
						if( $valorRecebido>0 && isset($ret[0]["ser_codigo"]) && $ret[0]["ser_codigo"]=="CTT" && isset($ret[0]["doc_origem"]) && $ret[0]["doc_origem"]==2 && ($company->emp_codigo=="UDS" || $company->emp_codigo=="MODELO") ){
							//buscar dominio para desbloqueio (cancelar suspensão pelo cpanel)
							$filtro = '{"cod":"700514","params":[
								{"name":"doc_origem_codigo","value":"'.$ret[0]["doc_origem_codigo"].'","type":"string"}
							]}';
							$datapacket->add($filtro);
							$user = $datapacket->open();
							$datapacket->clear();
							if(is_array($user) && count($user)>0){
								$usu="";
								if(strstr(base64_decode($user[0]["ctt_obs"]), "www.")){
									$usu = explode("www.", base64_decode($user[0]["ctt_obs"]));
									$usu = (strstr($usu[1], " ")) ? explode(" ", $usu[1]) : $usu[1];
									if(is_array($usu)) $usu=$usu[1];
								}elseif(strstr(base64_decode($user[0]["ctt_svc_obs"]), "www.")){
									$usu = explode("www.", base64_decode($user[0]["ctt_svc_obs"]));
									$usu = (strstr($usu[1], " ")) ? explode(" ", $usu[1]) : $usu[1];
									if(is_array($usu)) $usu=$usu[1];
								}
								$usu = strtolower($usu);
								
								if($usu!=""){
									//autenticação cpanel
									$whmusername = "rsrv12gr";
									$hash = "8cd0728cc093b222a6131c39194583b7f1c671326bfca5a190906249eb7d518e41ca51bc77a47bf3da4e37d6c8b6828cf6cd1957a8f5877c93e3dac961560579eff476cbe32b7fd18db4087f87a1d2309a43ef076232aca9087c6c7d19549749eecfcf6fb0075e74cbc7348ab1ef9dc6813221779cffc93df31d765d68f1847ee5e3655f63266e7066646b6f6328aa3a6dabb2b07b1ce8cd920da04df2f8b48b8cfb778a4f4452a34cf24b5bbe335b8d58502e7593eb152e5ff72aa8343f496ffce0e4e86a7c69557c621c04ab75d626600a5c0fa3a76602fb624cd78fd51c16464161b3c16ea9e9a9336aa281ef18d1f31312e49beefc490e3eccb5091ab80fab7f3f2a2a4a02fbef8eddccc273390ee5b3f9e2431b42c7149299b5e9230d9389b345b1978a8dce489ab6c06a920d51df7f9117d939d7990760a623a17ff0dc18c19d79dff0185310902a5d0fbfa2a9d5863f264d5c27c8e2032161e976389da8f3333fa46fde935fcb3f5d6b3004a6daf00b4fb28607ebbd888f67113210c3113381231ad0c34a7b0e4a6baaa8a297c271973df880342f5c30bc959309549b8bc4ea0013fb814a6cbcf2aa2d7b46d87a12fd6ad12cb8f435c9a7c45b67acc20846c2394b5ac1c9f0302b921c4de7291b17c24b4d1d3cbba75335e37c43daee";
									$query = "https://srv14.grupouds.com.br:2087/json-api/listaccts?api.version=1"; 
									$curl = curl_init();
									curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
									curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
									curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
									$header[0] = "Authorization: WHM $whmusername:" . preg_replace("'(\r|\n)'","",$hash);
									curl_setopt($curl,CURLOPT_HTTPHEADER,$header);
									curl_setopt($curl, CURLOPT_URL, $query);
									$result = curl_exec($curl);
									curl_close($curl);
									$res = json_decode($result);
									//verificacao usuarios
									for($count=0;$count<count($res->data->acct); $count++){
										//comparacao com dominio da obs
										if($usu==$res->data->acct[$count]->domain){
											//cancelar suspensão da conta
											$query = "https://srv14.grupouds.com.br:2087/json-api/unsuspendacct?api.version=1&user=".$res->data->acct[$count]->user; 
											$curl = curl_init();
											curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
											curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
											curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
											$header[0] = "Authorization: WHM $whmusername:" . preg_replace("'(\r|\n)'","",$hash);
											curl_setopt($curl,CURLOPT_HTTPHEADER,$header);
											curl_setopt($curl, CURLOPT_URL, $query);
											$result = curl_exec($curl);
											curl_close($curl);										
										}
									}
								}
							}
							//desbloquear contrato
							$filtro = '{"cod":"700509","params":[
								{"name":"doc_origem_codigo","value":"'.$ret[0]["doc_origem_codigo"].'","type":"string"}
							]}';
							$datapacket->add($filtro);
							$datapacket->open();
							$datapacket->clear();
						}
						
						if( is_array($ret) && count($ret)>0 ){
							
							$datapacket->clear();
							
							if( $valorRecebido>0 ){
								//tratando exceções de solicitação de baixa de banco/ layout/ movimento
								if( $banco=="756" && $layout=="CNAB400" && ($codigoMovimento=="09" || $codigoMovimento=="10") ){
									
									$datapacket->add('{"cod":"700759", "params":[{"name":"doc_nossonumero", "value":"'.$nossoNumero.'", "type":"string"}]}'); //resetar remessa
									
								}else{
								
									$status = ( $valorRecebido < $ret[0]["doc_valor"] ) ? 1 : 2;
									
									//atualizando boletos
									$filtro = '{"cod":"700758","params":[
										{"name":"doc_dtpgto","value":"'.implode("-", array_reverse(explode("/", $dataCredito))).' 00:00:00","type":"string"},
										{"name":"doc_valorpg","value":"'.$valorRecebido.'","type":"float"},
										{"name":"doc_multapg","value":"'.$multa.'","type":"float"},
										{"name":"doc_jurospg","value":"'.$juros.'","type":"float"},
										{"name":"doc_desconto","value":"'.$desconto.'","type":"float"},
										{"name":"doc_status","value":"'.$status.'","type":"integer"},
										{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"}
									]}';
									$datapacket->add($filtro);
									
									//efetuando lançamento (tipo e tarifa)
									$filtrolancto = '{"cod":"700279","params":[
										{"name":"lan_historico","value":"Docto Cód. '.$ret[0]["doc_codigo"].' - LANCAMENTO CRIADO A PARTIR DE BAIXA AUTOMÁTICA DE BOLETO (RETORNO)","type":"string"},
										{"name":"lan_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
										{"name":"lan_valor","value":"'.$valorRecebido.'","type":"float"},
										{"name":"lan_conc","value":"0","type":"integer"},
										{"name":"lan_dc","value":"2","type":"integer"},
										{"name":"ser_codigo","value":"1","type":"string"},';
									$filtrolancto.= (isset($ret[0]["cta_codigo"]) && $ret[0]["cta_codigo"]!='') ? '{"name":"cta_codigo","value":"'.$ret[0]["cta_codigo"].'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
									$filtrolancto.= (isset($ret[0]["plc_codigo"]) && $ret[0]["plc_codigo"]!='') ? '{"name":"plc_codigo","value":"'.$ret[0]["plc_codigo"].'","type":"string"},' : '{"name":"plc_codigo","value":"NULL","type":"other"},';
									$filtrolancto.= '{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"},';
									$filtrolancto.= (isset($ret[0]["ccu_codigo"]) && $ret[0]["ccu_codigo"]!='') ? '{"name":"ccu_codigo","value":"'.$ret[0]["ccu_codigo"].'","type":"string"},' : '{"name":"ccu_codigo","value":"NULL","type":"other"},';
									$filtrolancto.= '{"name":"lan_dtmov","value":"'.implode("-", array_reverse(explode("/", $dataCredito))).' 00:00:00","type":"string"},
										{"name":"lan_tipo","value":"2","type":"integer"},
										{"name":"lan_tarifa","value":"'.$valorTarifa.'","type":"float"}
									]}';
									$datapacket->add($filtrolancto);
									
									//atualizando o historico do documento com a baixa automatica
									$usu_login = ( isset($_POST["usu_login"]) ) ? $_POST["usu_login"] : "";
									$filtro = '{"cod":"501240","params":[
										{"name":"lgd_tipo","value":"5","type":"integer"},
										{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"},
										{"name":"usu_login","value":"'.$usu_login.'","type":"string"},
										{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
										{"name":"lgd_descr","value":"Baixa automática no valor de R$ '.$valorRecebido.'","type":"string"}
									]}';
									$datapacket->add($filtro);
									
								}
									
							}elseif( $codigoMovimento=="03" ){
								$datapacket->add('{"cod":"700767", "params":[{"name":"doc_nossonumero", "value":"'.$nossoNumero.'", "type":"string"}]}'); //titulo rejeitado
							}elseif( $codigoMovimento=="02" ){
								$datapacket->add('{"cod":"700766", "params":[{"name":"doc_nossonumero", "value":"'.$nossoNumero.'", "type":"string"}]}'); //titulo registrado no banco
							}
							
							//atualizando retorno
							$filtro = '{"cod":"700748","params":[
								{"name":"ret_codigo","value":"'.$_POST["ret_codigo"].'","type":"integer"},
								{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"},
								{"name":"doc_taxa","value":"'.$valorTarifa.'","type":"float"},
								{"name":"doc_ocorrencia","value":"'.$descr.'","type":"string"}
							]}';
							$datapacket->add($filtro);
							
							$datapacket->open();
							$certo++;
							
						}else{
							
							$errado++;
							
						}
					
					}
					
				}

				$datapacket->clear();
				
				if($Retorno->layout=="FEBRABAN240") $total = $total/3;
				echo "Foram encontradas ".($total)." ocorrências no arquivo de retorno.<br>";
				// $erro = $i- count($ret);
					
				if($certo>0){
					echo "Das quais, ".$certo." documentos correspondentes foram encontrados e atualizados.<br>";
				}
				
				if($errado>0){
					echo "Não foram encontrados documentos correspondentes para ".$errado." ocorrências!";
				}
				
				$filtro = '{"cod":"700746","params":[
					{"name":"ret_codigo","value":"'.$_POST["ret_codigo"].'","type":"integer"},
					{"name":"ret_total","value":"'.$certo.'","type":"integer"},
					{"name":"ret_carteira","value":"'.$_POST["carteira"].'","type":"string"}
				]}';
				$datapacket->add($filtro);
				$datapacket->open();
				
				exit();
				
			}else{
				exit("Número de inscrição (CPF/CNPJ) do arquivo de retorno diverge do cadastrado no sistema");
			}
		
		//demais casos usar cobrebemx
		}else{
			
			$fields = array(
				'p' => $_REQUEST["p"],
				'acao' => 'executar',
				'servidor' => $_SERVER['HTTP_HOST'],
				'emp_cpfcnpj' => $company->emp_cpfcnpj,
				'emp_db_sge' => urlencode($company->emp_db_sge),
				'emp_db_comum' => urlencode($company->emp_db_comum),
				'emp_codigo' => urlencode($company->emp_codigo),
				'arq' => urlencode($_POST["arq"]),
				'carteira' => urlencode($_POST["carteira"]),
				'banco_numero' => urlencode($_POST["banco_numero"]),
				'banco_nome' => urlencode($_POST["banco_nome"]),
				'banco_numero' => urlencode($_POST["banco_numero"]),
				'layout' => urlencode($_POST["layout"]),
				'ret_codigo' => urlencode($_POST["ret_codigo"])
			);
			
			if($_SERVER['HTTP_HOST']=="192.168.1.251" || $_SERVER['HTTP_HOST']=="hom.grupouds.com.br"){
				$fields["sis"]="251";
			}elseif($_SERVER['HTTP_HOST']=="dev.grupouds.com.br"){
				$fields["sis"]="110";
			}elseif($_SERVER['HTTP_HOST']=="facil.uds.com.br"){
				$fields["sis"]="248";
			}elseif($_SERVER['HTTP_HOST']=="facil.grupouds.com.br"){
				$fields["sis"]="247";
			}

			//url-ify os dados para o POST
			foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
			rtrim($fields_string, '&');

			//abrir conexao
			$ch = curl_init();

			//define url, numero de variaveis POST e dados POST
			curl_setopt($ch,CURLOPT_URL, $url);
			curl_setopt($ch,CURLOPT_POST, count($fields));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

			//executa POST
			$result = curl_exec($ch);
			
			//fechar conexao
			curl_close($ch);
			
		}

	}else{
		
		$filtro = '{"cod":"700744","params":[]}';
		
		$datapacket->add($filtro);
		
		$ret = $datapacket->open();
		
		print_r(json_encode($ret));
		
	}

?>