<?php 
	header('Access-Control-Allow-Origin: *'); 
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');

	require_once 'datapacket.php';

	class TParams extends Datapacket {

		private $dbSge = "e9997";
		private $dbComum = "e9997_comum";
		private $codigo = "MODELO";
		private $cpfcnpj = "";
		private $company = "";
		private $REQUEST_URI = "";

		public $HTTP_HOST = "";
		public $HostRoot = "/var/www/desktop/";
		public $uploads  = "/var/www/uploads/";
		public $HostClient = "http://dev.grupouds.com.br/desktop";

		public function __construct(){
			
			if(isset($_SERVER['HTTP_HOST'])){
				$this->HTTP_HOST=$_SERVER['HTTP_HOST'];
			}
			
			if(isset($_SERVER['REQUEST_URI'])){
				$this->REQUEST_URI=$_SERVER['REQUEST_URI'];
			}

			// $url = $_SERVER['REQUEST_URI'];
			// $pos = strrpos($url,'p=');
			// $code = base64_decode(substr(substr($url,$pos+2,strlen($url)),0,1).substr(substr($url,$pos+2,strlen($url)),2,strlen($url)));
			if(isset($_REQUEST["p"]) && $_REQUEST["p"]!=''){
				
				$code = base64_decode(substr($_REQUEST["p"],0,1).substr($_REQUEST["p"],2,strlen($_REQUEST["p"])));
				$filtro = '{"cod":"600011","params":[{"name":"emp_codigo","value":"'.$code.'","type":"string"}]}';
				Datapacket::setHost($this->getHost("empresas"));
				Datapacket::add($filtro);
				$ret = Datapacket::open(true);
				Datapacket::clear();

				$this->codigo = $ret[0]->emp_codigo;
				$this->cpfcnpj = $ret[0]->emp_cpfcnpj;
				$this->dbSge = $ret[0]->emp_db_sge;
				$this->dbComum = $ret[0]->emp_db_comum;
				$this->company = $ret[0];
			}
			
			$lastBar = strrpos($this->REQUEST_URI,"/");
			$lastBar = $lastBar-4;
			$this->uploads2 = "http://".$this->HTTP_HOST."/uploads/";

			if($_SERVER['SERVER_NAME'] == "dev.grupouds.com.br"){

				$ambiente = explode("/", substr($_SERVER['SCRIPT_NAME'], 1));
				
				if($ambiente[0] != "desktop"){

					$this->HostRoot = "/home/" . $ambiente[0] . "/" . $ambiente[1] . "/";
					$this->HostClient = "http://dev.grupouds.com.br/" . $ambiente[0] . "/" . $ambiente[1] . "/";
				}	
				
			} else {
				
				$this->HostClient = "http://" . $_SERVER["SERVER_NAME"] . "/desktop/";
			}
			
		}
		
		public function getDb(){
			return $this->dbComum;
		}
		
		public function getDbSge(){
			return $this->dbSge;
		}
		
		public function getCodigo(){
			return $this->codigo;
		}

		public function getHost($db){
			return "localhost:facildesktop:fcDk@t0p!2a:".$db;
		}

		public function getHostDev($db){
			return "dev.grupouds.com.br:facildesktop:fcDk@t0p!2a:".$db;
		}
		
		public function getCompany(){
			return $this->company;
		}

		public function getHostRoot(){
			return $this->HostRoot;
		}

		public function getCpfCnpj(){
			return $this->cpfcnpj;
		}

		public function getUploads(){
			return $this->uploads;
		}

		public function pre($a, $exit=false){
			echo "<pre>";
			print_r($a);
			echo "</pre>";
			if($exit) exit();
		}

	}
?>