<?php
	include_once 'datapacket.php';
	include_once 'TParams.class.php';
	
	
	if(isset($_REQUEST['acao']) && $_REQUEST['acao'] == 'validar'){

		header('Access-Control-Allow-Origin: *'); header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
		

		$datapacket = new datapacket();
		$datapacket->debug(true);
		$TParams = new TParams();

		if(isset($_REQUEST['emp_codigo']) && !empty($_REQUEST['emp_codigo'])){
			$emp_codigo = $_REQUEST['emp_codigo'];
		}

		$filtro = '{"cod":"600090","params":[
			{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"}
		]}';
		$datapacket->setHost($TParams->getHost("empresas"));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();

		if(count($ret) > 0){
			echo 'true';
		}else{
			echo 'false';
		}

	}else{

		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		header('Expires: 0');
		
	    include_once("../class/PHPMailer_v5.1/class.phpmailer.php");

		$TParams = new TParams();
		$json = json_decode(base64_decode($_REQUEST['dados']));
		$emp_codigo = $json->{'emp_codigo'};
		$mes = $json->{"mes"};
		$ano = $json->{"ano"};
		$btn_email = "";

		$ambNfe = 'homologacao';
		if(isset($json->{'emp_amb_nfe'}) && $json->{'emp_amb_nfe'} == 1){
			$ambNfe = 'producao';
		}
		
		$cad_nomeraz = "";
		if(isset($json->{'cad_nomeraz'}) && !empty($json->{'cad_nomeraz'}) && $json->{'cad_nomeraz'} != "Novo Registro"){
			$cad_nomeraz = $json->{'cad_nomeraz'};
		}
		
		$email_destinatario = "";
		if(isset($json->{"email"})&&!empty($json->{'email'})){
			$email_destinatario = $json->{'email'};
		}

		class Manager extends TParams {
			public $company;
			public $notas;
			public $metadata = Array();
			public $ambNfe;
			private $TParams;  
			private $emp_codigo;
			private $mes;
			private $ano;
			
			public function __construct($emp_codigo, $mes, $ano, $ambNfe){
				$this->TParams		= new TParams();
				$this->emp_codigo	= $emp_codigo;
				$this->mes			= $mes;
				$this->ano			= $ano;
				$this->ambNfe 		= $ambNfe;

				$datapacket = new datapacket();
				$datapacket->debug(true);

				$filtroCompany = '{"cod":"600001","params":[
					{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"}
				]}';
				$datapacket->setHost($this->TParams->getHost("empresas"));
				$datapacket->add($filtroCompany);
				$company = $datapacket->open(true);
				$this->company = $company[0];
				$datapacket->clear();

				$not_dtini = $ano . '-' . $mes . '-01 00:00:00';
				$not_dtfim = $ano . '-' . $mes . '-' . date('t', strtotime($ano.'/'.$mes.'/01')) . " 23:59:59";

				$filtroNf = '{"cod":"600150","params":[
					{"name":"not_dtini","value":"'.$not_dtini.'","type":"string"},
					{"name":"not_dtfim","value":"'.$not_dtfim.'","type":"string"}
				]}';
				$datapacket->setHost($this->TParams->getHost($company[0]->{'emp_db_sge'}));
				$datapacket->add($filtroNf);
				$this->notas = $datapacket->open(true);
				// echo $datapacket->getLastQuery();
				$datapacket->clear();
			}

			public function addMetadata($nNf, $cStat, $key_nfe){			
				
				if($nNf){
				
					$foundNNf	 = 0;
					$foundCstat	 = 0;
					$foundFile	 = 0;

					for($i = 0; $i < count($this->notas); $i++){

						if($this->notas[$i]->not_tipo == 9 || $this->notas[$i]->not_tipo == 7 || $this->notas[$i]->not_tipo == 12 || $this->notas[$i]->not_tipo == 13){
							
							if(intval($this->notas[$i]->not_numero) == intval($nNf)){

								if(intval($this->notas[$i]->not_cstat) == intval($cStat)){ // nota autorizada e denegada cstat 100 e 110 respectivamente
									
									$notaAut  = $this->TParams->uploads . $this->company->emp_codigo . '/nfe/' . $this->ambNfe . '/autorizadas/' . $this->ano . $this->mes . '/' . $this->notas[$i]->not_key_nfe;
									
									if(is_file($notaAut . '-nfe.xml')) {
										array_push($this->metadata, '{"not_numero":"' . $nNf . '","not_key_nfe":"' . $this->notas[$i]->not_key_nfe . '","status":"true","cstat":"' . $this->notas[$i]->not_cstat . '","tipo":"' . $this->notas[$i]->not_tipo . '","erro":""}');
										$foundFile++;
									}
									
									$foundCstat++;

								}else if(intval($this->notas[$i]->not_cstat) == 101 || intval($this->notas[$i]->not_cstat) == 135){ // nota cancelada
									
									$notaCanc = $this->TParams->uploads . $this->company->emp_codigo . '/nfe/' . $this->ambNfe . '/canceladas/'  . $this->ano . $this->mes . '/' . $this->notas[$i]->not_key_nfe;
									
									if(is_file($notaCanc . '1101111-procEventoNFe.xml') || is_file($notaCanc . '-nfe.xml')) {
										array_push($this->metadata, '{"not_numero":"' . $nNf . '","not_key_nfe":"' . $this->notas[$i]->not_key_nfe . '","status":"true","cstat":"' . $this->notas[$i]->not_cstat . '","tipo":"' . $this->notas[$i]->not_tipo . '","erro":""}');
										$foundFile++;
									}
									
									$foundCstat++;

								}else if(intval($this->notas[$i]->not_cstat) == 102 || intval($this->notas[$i]->not_cstat) == 0){	// nota inutilizada
									
									$notaInut = $this->TParams->uploads . $this->company->emp_codigo . '/nfe/' . $this->ambNfe . '/aguardando/'  . $this->ano . $this->mes . '/' . $this->notas[$i]->not_key_nfe;
									
									if(is_file($notaInut . '-ProcInutNFe.xml')) {
										array_push($this->metadata, '{"not_numero":"' . $nNf . '","not_key_nfe":"' . $this->notas[$i]->not_key_nfe . '","status":"true","cstat":"' . $this->notas[$i]->not_cstat . '","tipo":"' . $this->notas[$i]->not_tipo . '","erro":""}');
										$foundFile++;
									}
									
									$foundCstat++;
								}
								
								$foundNNf++;
							}

							if( $i + 1 == count($this->notas)){

								if($foundFile==0){

									array_push($this->metadata, '{"not_numero":"' . $nNf . '","not_key_nfe":"' . $key_nfe . '","status":"false","cstat":"' . $cStat . '","tipo":"' . $this->notas[$i]->not_tipo . '","erro":"O arquivo XML não foi encontrado."}');

								} else {

									if($foundCstat==0){

										array_push($this->metadata, '{"not_numero":"' . $nNf . '","not_key_nfe":"' . $key_nfe . '","status":"false","cstat":"' . $cStat . '","tipo":"' . $this->notas[$i]->not_tipo . '","erro":"O status não é o mesmo cadastrado."}');

									}else{

										if($foundNNf==0){
											
											array_push($this->metadata, '{"not_numero":"' . $nNf . '","status":"false","erro":"O número ' . $nNf . ' que consta no XML da nota não foi encontrado no banco de dados."}');
										}
									}
								}
							}
						}
					}
				}
			}

			public function getMetadata(){
				return $this->metadata;
			}

			public function getCompany(){
				return $this->company;
			}

			public function getNotas(){
				return $this->notas;
			}
		}

		$erro = 'Relatório de erros da exportação de arquivos magnéticos do período '.$mes.'/'.$ano.chr(13).chr(10).chr(13).chr(10).chr(13);
		
		$manager = new Manager($emp_codigo, $mes, $ano, $ambNfe);
		
		$zipDir = '../tmp';
		if(!is_dir($zipDir)) mkdir($zipDir,0777);
		$zipName = 'MAGNETICOS NFE '.$mes.'-'.$ano.'.zip';
		if(is_file($zipDir.'/'.$zipName)) unlink($zipDir.'/'.$zipName);

		$zip = new ZipArchive();
		if ($zip->open($zipDir.'/'.$zipName, ZipArchive::CREATE)!==TRUE) exit("cannot open <$zipName>\n");

		$diretorios = array("autorizadas", "denegadas", "canceladas");

		foreach($diretorios as $diretorio) {

			$dirXML = $TParams->uploads . $emp_codigo . '/nfe/' . $ambNfe . '/' . $diretorio . '/' . $ano . $mes;
			
			if(is_dir($dirXML)){

				$dir = dir($dirXML);

				$XmlInconsistente="";				

				while($arquivo = $dir->read()) {

					$posExtensao = strrpos($arquivo, '.');
					$extensao = substr($arquivo, $posExtensao, strlen($arquivo));

					if(strtolower($extensao)=='.xml') {
						
						if(simplexml_load_file($dirXML . '/' . $arquivo)) {
						
							$xml = simplexml_load_file($dirXML . '/' . $arquivo);

							if(!empty($cad_nomeraz)) {
								
								if(isset($xml->NFe->infNFe->ide->nNF)) {
									
									if(isset($xml->protNFe->infProt->cStat)) {
									
										if(isset($xml->protNFe->infProt->chNFe)) {
									
											if($xml->NFe->infNFe->dest->xNome == $cad_nomeraz) {
												
												$add = $manager->addMetadata($xml->NFe->infNFe->ide->nNF, $xml->protNFe->infProt->cStat, $xml->protNFe->infProt->chNFe);
											}
										}
									}
								}

							} else {
								
								if(isset($xml->NFe->infNFe->ide->nNF)) {
									
									if(isset($xml->protNFe->infProt->cStat)) {
									
										if(isset($xml->protNFe->infProt->chNFe)) {

											$add = $manager->addMetadata($xml->NFe->infNFe->ide->nNF, $xml->protNFe->infProt->cStat, $xml->protNFe->infProt->chNFe);
										}
									}
								}
							}

						} else {

							$XmlInconsistente .= $dirXML . '/' . $arquivo . chr(13) . chr(10);
						}
					}
				}

				$dir->close();

			} else {

				$erro .= "O diretório " . $dirXML . " não foi encontrado" . chr(13) . chr(10);
				mkdir($dirXML, 0777, true);
			}
		}

		$ret = $manager->getMetadata();

		if(is_file($dirXML . '/erros.txt')) unlink($dirXML . '/erros.txt');

		$i=1;

		if(!empty($ret) && count($ret) > 0){
									
			foreach($ret as $obj){

				$obj = json_decode($obj);

				if($obj->cstat == '101' || $obj->cstat == '135'){
					
					$dirXML = $TParams->uploads.$emp_codigo.'/nfe/'.$ambNfe.'/canceladas/'.$ano.$mes.'/';
					
					if(!is_dir($dirXML)) mkdir($dirXML, 0777, true);
					
					// $tipo 	= '-1-procCanc.xml';
					$tipo 	= '-nfe.xml';

				}else if($obj->cstat == '102' || (!$obj->cstat)){
					
					$dirXML = $TParams->uploads.$emp_codigo.'/nfe/'.$ambNfe.'/aguardando/'.$ano.$mes.'/';

					if(!is_dir($dirXML)) mkdir($dirXML, 0777, true);

					$tipo 	= '-ProcInutNFe.xml';

				} else {
					
					$dirXML = $TParams->uploads.$emp_codigo.'/nfe/'.$ambNfe.'/autorizadas/'.$ano.$mes.'/';

					if(!is_dir($dirXML)) mkdir($dirXML, 0777, true);

					$tipo	= '-nfe.xml';
				}

				if($obj->status == 'true' && is_file($dirXML . '/' . $obj->not_key_nfe . $tipo)){

					$zip->addFile($dirXML . '/' . $obj->not_key_nfe . $tipo, $obj->not_key_nfe . $tipo);
					
					//Cartas de correção
					$cont=1;
					while( is_file($dirXML . '/' . $obj->not_key_nfe . "-" . $cont . "-cce.xml") && file_exists($dirXML . '/' . $obj->not_key_nfe . "-" . $cont . "-cce.xml") ){
						$zip->addFile($dirXML . '/' . $obj->not_key_nfe . $tipo, $obj->not_key_nfe . "-" . $cont . "-cce.xml");
						$cont++;
					}

				}else{

					if(strlen($obj->erro) == 0){

						$obj->erro = 'O arquivo não existe.';

					}

					if($obj->erro != "complementar"){

						$keyNfe = $obj->not_key_nfe.'-nfe.xml';

						if($keyNfe == '-nfe.xml'){

							$keyNfe = 'indefinida (esta nota pode não existir no banco de dados).';
						}

						$erro .= 'Número: '.$obj->not_numero. ' - Chave: '.$obj->not_key_nfe.' - Erro: '.$obj->erro.chr(13).chr(10);
					}
				}
			}

		} else {
			
			$dirXML = $TParams->uploads . $emp_codigo . '/nfe/' . $ambNfe . '/autorizadas/' . $ano . $mes . '/';
			$fp = fopen('/var/www/desktop/tmp/aviso.txt','w+');
			fwrite($fp, "Nenhuma nota encontrada!");
			fclose($fp);
			$zip->addFile('/var/www/desktop/tmp/aviso.txt', 'aviso.txt');
			// unlink('/var/www/desktop/tmp/aviso.txt');
		}

		if($erro!=""&&count($ret)>0){
			if(!is_dir($dirXML)){
				mkdir($dirXML, 0777, true);
			}
			
			$fileError = fopen($dirXML . '/erros.txt', 'w+');
			fwrite($fileError,"Arquivos inconsistentes:" . chr(13) . chr(10) . $XmlInconsistente);
			fwrite($fileError,chr(13).chr(10).chr(13).chr(10));
			fwrite($fileError,$erro);
			fclose($fileError);
			$zip->addFile($dirXML.'/erros.txt','erros.txt');
		}
		// print_r($zip);

		$zip->close();

		sleep(1);

		if ($email_destinatario != "") {

			$mail = new PHPMailer();
			$mail->Charset = 'UTF-8';
		    $mensagem = "
		        <html>
		            <body>
		                <div style='text-align:justify;'>
		            		Segue em anexo um pacote .zip contendo os arquivos xml.	
		        		<div>	
		            </body>
			    </html>";
		    $assunto = utf8_decode("Arquivos magnéticos referente ao mês ").$mes." de ".$ano;
		    $mail->IsHTML(true);
		    $mail->SetLanguage("br");
		    // $mail->isSMTP();
		    // $mail->SMTPAuth = true;
		    $mail->Port = 587;
		    $mail->Host = $manager->getCompany()->emp_hostsmtp;
		    $mail->Username = $manager->getCompany()->emp_emailremetente;
		    $mail->Password = $manager->getCompany()->emp_pwdsmtp;
		    $mail->From = $manager->getCompany()->emp_emailremetente;    
		    $mail->Subject = $assunto;
		    $mail->Body = $mensagem;
		    $mail->AddAddress($email_destinatario);
		    $mail->AddAttachment($zipDir."/".$zipName);
		    
		    if($mail->send()){
		    	if (isset($_REQUEST['btn_email'])) $email_enviado = "ok";
		    }
		}
		
		if (!isset($_REQUEST['btn_email'])) {
			header('Content-Disposition: attachment; filename="'.$zipName.'"');
			header('Content-Length: '.filesize($zipDir."/".$zipName));
			while (ob_get_level()) ob_end_clean();
			@readfile($zipDir."/".$zipName);
		}

		if(is_file('/var/www/desktop/tmp/aviso.txt')) unlink('/var/www/desktop/tmp/aviso.txt');	
		if(is_file($dirXML."erros.txt")) unlink($dirXML."erros.txt");
		if(is_file($zipDir.'/'.$zipName)) unlink($zipDir.'/'.$zipName);
		exit($email_enviado);
	}
?>