﻿<?php
	include_once 'datapacket.php';
	include_once 'TParams.class.php';
    include_once '../class/PHPMailer_v5.1/class.phpmailer.php';

 //    header('Content-Description: File Transfer');
	// header('Content-type: application/zip');
	// header('Content-Transfer-Encoding: binary');
	// header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
	// header('Pragma: public');
	// header('Expires: 0');

	class Manager extends TParams {

		private $emp_codigo;
		public $TParams;
	
		public $anomes;
		public $company;
		public $cte;
		public $metadata = Array();
		public $dirXml;
		public $tpAmb = "homologacao";

		public function __construct($emp_codigo,$mes,$ano){

			$this->TParams		= new TParams();
			$this->emp_codigo	= $emp_codigo;
			$this->mes			= $mes;
			$this->ano			= $ano;

			$datapacket = new datapacket();
			$datapacket->debug(true);

			$filtroCompany = '{"cod":"600001","params":[
				{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"}
			]}';
			$datapacket->setHost($this->TParams->getHost("empresas"));
			$datapacket->add($filtroCompany);
			$company = $datapacket->open(true);
			$this->company = $company[0];
			$datapacket->clear();

			$not_dtini = $ano.'-'.$mes.'-01';
			$not_dtfim = $ano.'-'.$mes.'-'.date('t', strtotime($ano.'/'.$mes.'/01'));
			$filtro = '{"cod":"001152","params":[
				{"name":"not_dtini","value":"'.$not_dtini.'","type":"string"},
				{"name":"not_dtfim","value":"'.$not_dtfim.'","type":"string"}
			]}';
			$datapacket->setHost($this->TParams->getHost($this->TParams->getDbSge()));
			$datapacket->add($filtro);
			$this->cte = $datapacket->open(true);
			$datapacket->clear();
			
			if($this->company->emp_ambcte == 1){
				$this->tpAmb = "producao";
			}else{
				$this->tpAmb = "homologacao";
			}

			$this->anomes = substr($ano,-2).$mes;
			$this->dirXml = $this->TParams->getUploads().$this->company->emp_codigo."/cte/".$this->tpAmb."/";
		}

		public function addMetadata($nCT){
		
			if($nCT){

				for($i=0;$i<count($this->cte);$i++){

					$diretorio = array("canceladas", "denegadas", "autorizadas");
					
					foreach ($diretorio as $pasta) {
						
						if(intval($this->cte[$i]->cte_nct) == intval($nCT)){

							if(is_file($this->dirXml.$pasta.'/'.$this->anomes.'/'.$this->cte[$i]->cte_key.'-cte.xml')){
							
								array_push($this->metadata,'{"cte_nct":"'.$nCT.'","cte_key":"'.$this->cte[$i]->cte_key.'","status":"true","cstat":"'.$this->cte[$i]->cte_cstat.'","erro":""}');
								
							}
						}
					}
				}
			}
		}

		public function getMetadata(){
			return $this->metadata;
		}

		public function getCompany(){
			return $this->company;
		}

		public function getcte(){
			return $this->cte;
		}
	}

	$dados 				= json_decode(base64_decode($_REQUEST['dados']));
	$emp_codigo 		= $dados->{'emp_codigo'};
	$cad_nomeraz		= "";
	$email_destinatario = "";
	$email_enviado		= "";
	
	if(isset($dados->{'cad_nomeraz'}) && !empty($dados->{'cad_nomeraz'})){
		$cad_nomeraz = $dados->{'cad_nomeraz'};
	}
	
	if(isset($dados->{'email'})&&!empty($dados->{'email'})){
		$email_destinatario = $dados->{'email'};
	}

	$manager = new Manager($emp_codigo, $dados->{'mes'}, $dados->{'ano'});

	$erro='Relatório de erros da exportação de arquivos magnéticos do período '.$dados->{'mes'}.'/'.$dados->{'ano'}.chr(13).chr(10).chr(13).chr(10).chr(13);

	$zipDir='../tmp';
	if(!is_dir($zipDir)){
		mkdir($zipDir,0777);
	}

	$zipName = 'MAGNETICOS CTE '.$dados->{'mes'}.'-'.$dados->{'ano'}.'.zip';
	if(is_file($zipDir.'/'.$zipName)){
		unlink($zipDir.'/'.$zipName);
	}

	$zip = new ZipArchive();
	if ($zip->open($zipDir.'/'.$zipName, ZipArchive::CREATE)!==TRUE) {
		exit("cannot open <$zipName>\n");
	}

	$diretorio = array("autorizadas", "canceladas", "denegadas");

	foreach ($diretorio as $pasta) {

		if(is_dir($manager->dirXml.$pasta."/".$manager->anomes."/")){

			$XmlInconsistente="";

			$dir = dir($manager->dirXml.$pasta."/".$manager->anomes."/");

			while($arquivo = $dir->read()){

				$posExtensao = strrpos($arquivo, '.');
				$extensao    = substr($arquivo, $posExtensao, strlen($arquivo));

				if(strtolower($extensao) == '.xml'){
				 	
				 	if(simplexml_load_file($manager->dirXml . $pasta . "/" . $manager->anomes . "/" . $arquivo)){
						
				 		$xml = simplexml_load_file($manager->dirXml . $pasta . "/" . $manager->anomes . "/" . $arquivo);

				 		if(isset($xml->CTe->infCte->ide->nCT) && gettype($xml->CTe->infCte->ide->nCT) != null){

				 			if(!empty($cad_nomeraz)){
				 				if($xml->CTe->infCte->dest->xNome == $cad_nomeraz){
				 					$add = $manager->addMetadata($xml->CTe->infCte->ide->nCT);
				 				}
				 			}else{
				 				$add = $manager->addMetadata($xml->CTe->infCte->ide->nCT);
				 			}
				 		}
				 	}else{
				 		$XmlInconsistente .= $manager->dirXml.$pasta."/".$manager->anomes."/".$arquivo.chr(13).chr(10);
				 	}
				}
			}

			$dir->close();

		} else {

			$erro .= "Nenhum arquivo magnético para ".$pasta.chr(13).chr(10);
		}
	}
	
	$ret = $manager->getMetadata();

	if(is_file($manager->dirXml.'/erros.txt')){
		unlink($manager->dirXml.'/erros.txt');
	}

	if(!empty($ret) && count($ret) > 0){

		foreach($ret as $obj){

			$obj = json_decode($obj);

			if($obj->cstat == '100'){
				$dir = $manager->dirXml."/autorizadas/".$manager->anomes."/";
			}else if($obj->cstat == '110' || $obj->cstat == '205'){
				$dir = $manager->dirXml."/denegadas/".$manager->anomes."/";
			}else if($obj->cstat == '101' || $obj->cstat == '218'){
				$dir = $manager->dirXml."/canceladas/".$manager->anomes."/";
			}

			if($obj->status=='true' && is_file($dir.$obj->cte_key.'-cte.xml') ){
				
				$zip->addFile($dir.$obj->cte_key.'-cte.xml', $obj->cte_key.'-cte.xml') ;

			}else{

				if(strlen($obj->erro)==0){
					$obj->erro = 'O arquivo não existe.';
				}

				$keyNfe = $obj->cte_key.'-cte.xml';
				if($keyNfe == '-cte.xml'){
					$keyNfe = 'indefinida (esta nota pode não existir no banco de dados).';
				}

				$erro .= 'Número: '.$obj->cte_nct. '  - Erro: '.$obj->erro.chr(13).chr(10);
			}
		}

	} else {

		$ambNfe = ($manager->TParams->getCompany()->{"emp_ambcte"} == 1) ? "producao" : "homologacao";
		$dirXML = $manager->TParams->uploads.$emp_codigo.'/nfe/'.$ambNfe.'/autorizadas/'.$manager->ano.$manager->mes.'/';
		$fp = fopen('/var/www/desktop/tmp/aviso.txt','w+');
		fwrite($fp, "Nenhum CT-e encontrado!");
		fclose($fp);
		$zip->addFile('/var/www/desktop/tmp/aviso.txt','aviso.txt');
		// unlink('/var/www/desktop/tmp/aviso.txt');

	}

	if($erro != "" && $erro != 'Relatório de erros da exportação de arquivos magnéticos do período '.$dados->{'mes'}.'/'.$dados->{'ano'}.chr(13).chr(10).chr(13).chr(10)){
		if(!empty($XmlInconsistente)){
			if(!is_dir($manager->dirXml)){
				mkdir($manager->dirXml, 0777);
			}
			$fileError = fopen($manager->dirXml.'/erros.txt','w+');
			fwrite($fileError,"Arquivos inconsistentes:".chr(13).chr(10).$XmlInconsistente);
			fwrite($fileError,chr(13).chr(10).chr(13).chr(10));
			fwrite($fileError,$erro);
			fclose($fileError);
			$zip->addFile($manager->dirXml.'/erros.txt','erros.txt');
		}else{
			$fileError = fopen($manager->dirXml.'/erros.txt','w+');
			fwrite($fileError,$erro);
			$zip->addFile($manager->dirXml.'/erros.txt','erros.txt');
		}
	}

	$zip->close();

	if($email_destinatario != ""){
		
		$mail = new PHPMailer();
	    $mensagem = " 
	        <html>
	            <body>
	                <div style='text-align:justify;'>
	            		Segue em anexo um pacote .zip contendo os arquivos magnéticos.	
	        		<div>	
	            </body>
		    </html>";
	    $assunto = utf8_decode("Magnéticos")." de CT-e referente ao ".utf8_decode("mês").": ".$manager->mes." do ano: ".$manager->ano;
	    $mail->IsHTML(true);
	    $mail->SetLanguage("br");
	    // $mail->isSMTP();
	    // $mail->SMTPAuth = true;
	    $mail->Port = 587;
	    $mail->Host = $manager->getCompany()->emp_hostsmtp;
	    $mail->Username = $manager->getCompany()->emp_emailremetente;
	    $mail->Password = $manager->getCompany()->emp_pwdsmtp;
	    $mail->From = $manager->getCompany()->emp_emailremetente;
	    $mail->Subject = $assunto;
	    $mail->Body = $mensagem;
	    $mail->AddAddress($email_destinatario);
	    $mail->AddAttachment($zipDir . "/" . $zipName);
	    
	    if($mail->send()) {
	    	if (isset($_REQUEST['btn_email'])) $email_enviado = "ok";
	    }
	}

	if(!isset($_REQUEST['btn_email'])) {
		header('Content-Disposition: attachment; filename="' . $zipName . '"');
		header('Content-Length: ' . filesize($zipDir."/".$zipName));
		while (ob_get_level()) ob_end_clean();
		@readfile($zipDir . "/" . $zipName);
	}
	
	if(is_file('/var/www/desktop/tmp/aviso.txt')) unlink('/var/www/desktop/tmp/aviso.txt');	
	if(is_file($zipDir . '/' . $zipName)) unlink($zipDir . '/' . $zipName);
	exit($email_enviado);

?>