<?php header('Access-Control-Allow-Origin: *'); header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	include 'datapacket.php';
	include 'TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	
	// selecionar registro pelo codigo
	if (isset($_REQUEST["acao"]) && $_REQUEST["acao"] == "selecionar") {
	
		$retorno = new stdClass();
		
		$filtro = '{"cod":"700301","params":[
			{"name":"cad_codigo","value":"'.$_REQUEST["cad_codigo"].'","type":"string"}
		]}';
		$datapacket->setHost($TParams->getHost($TParams->getDb()));
		$datapacket->add($filtro);
		$retorno->{"cadastro"} = $datapacket->open(true);
		$datapacket->clear();

		foreach ($retorno->{"cadastro"} as $cadastro) {

			if(!base64_decode($cadastro->{"cad_obs"}, true)){

				$cadastro->{"cad_obs"} = base64_encode(urldecode($cadastro->{"cad_obs"}));
			}
		}

		$filtro = '{"cod":"701170","params":[
			{"name":"cad_codigo","value":"'.$_REQUEST["cad_codigo"].'","type":"string"}
		]}';
		$datapacket->setHost($TParams->getHost($TParams->getDb()));
		$datapacket->add($filtro);
		$retorno->{"email"} = $datapacket->open(true);
		$datapacket->clear();

		print_r(json_encode($retorno));
		exit();

	// busar dados da empresa na receita, com base no cnpj
	} else if (isset($_REQUEST["acao"]) && $_REQUEST["acao"] == "consulta") {
	
		// define caminho absoluto e relativo para arquivo cookie
		$pasta_cookies = $TParams->HostRoot.'tmp/cookies/';
		define('COOKIELOCAL', $pasta_cookies);
		define('HTTPCOOKIELOCAL', $pasta_cookies);
		// inicia sessão
		@session_start();

		// função para pegar o que interessa
		function pega_o_que_interessa($inicio,$fim,$total){
			$interesse = str_replace($inicio,'',str_replace(strstr(strstr($total,$inicio),$fim),'',strstr($total,$inicio)));
			return($interesse);
		}

		// função para pegar a resposta html da consulta pelo CNPJ na página da receita
		function getHtmlCNPJ($cnpj, $captcha){
			$cookieFile = COOKIELOCAL.session_id();
			$cookieFile_fopen = HTTPCOOKIELOCAL.session_id();
			if(!file_exists($cookieFile)){
				exit("Nâo foi possível efetuar a busca na receita, tente novamente mais tarde.");
			}else{
				// pega os dados de sessão gerados na visualização do captcha dentro do cookie
				$file = fopen($cookieFile_fopen, 'r');
				$conteudo = "";
				while (!feof($file))
				{$conteudo .= fread($file, 1024);}
				fclose ($file);

				$explodir = explode(chr(9),$conteudo);
				
				$sessionName = trim($explodir[count($explodir)-2]);
				$sessionId = trim($explodir[count($explodir)-1]);
				
				// constroe o parâmetro de sessão que será passado no próximo curl
				$cookie = $sessionName.'='.$sessionId.';flag=1';	
			}
			
			// dados que serão submetidos a consulta por post
			$post = array(
				'submit1'						=> 'Consultar',
				'origem'						=> 'comprovante',
				'cnpj' 							=> $cnpj, 
				'txtTexto_captcha_serpro_gov_br'=> $captcha,
				'search_type'					=> 'cnpj'
				
			);
			
			$post = http_build_query($post, NULL, '&');

			$ch = curl_init('http://www.receita.fazenda.gov.br/pessoajuridica/cnpj/cnpjreva/valida.asp');
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $post);		// aqui estão os campos de formulário
			curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);	// dados do arquivo de cookie
			curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);	// dados do arquivo de cookie
			curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:8.0) Gecko/20100101 Firefox/8.0');
			curl_setopt($ch, CURLOPT_COOKIE, $cookie);	    // dados de sessão e flag=1
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_MAXREDIRS, 3);
			curl_setopt($ch, CURLOPT_REFERER, 'http://www.receita.fazenda.gov.br/pessoajuridica/cnpj/cnpjreva/Cnpjreva_Solicitacao2.asp');
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			$html = curl_exec($ch);
			curl_close($ch);
			unlink($cookieFile);
			return $html;
		}

		// Função para extrair o que interessa da HTML e colocar em array
		function parseHtmlCNPJ($html){
			// respostas que interessam
			$campos = array(
			'NÚMERO DE INSCRIÇÃO',
			'DATA DE ABERTURA',
			'NOME EMPRESARIAL',
			'TÍTULO DO ESTABELECIMENTO (NOME DE FANTASIA)',
			// 'CÓDIGO E DESCRIÇÃO DA ATIVIDADE ECONÔMICA PRINCIPAL',
			// 'CÓDIGO E DESCRIÇÃO DAS ATIVIDADES ECONÔMICAS SECUNDÁRIAS',
			'CÓDIGO E DESCRIÇÃO DA NATUREZA JURÍDICA',
			'LOGRADOURO',
			'NÚMERO',
			'COMPLEMENTO',
			'CEP',
			'BAIRRO/DISTRITO',
			'MUNICÍPIO',
			'UF',
			'ENDEREÇO ELETRÔNICO',
			'TELEFONE',
			'ENTE FEDERATIVO RESPONSÁVEL (EFR)',
			'SITUAÇÃO CADASTRAL',
			'DATA DA SITUAÇÃO CADASTRAL',
			'MOTIVO DE SITUAÇÃO CADASTRAL',
			'SITUAÇÃO ESPECIAL',
			'DATA DA SITUAÇÃO ESPECIAL');

			// caracteres que devem ser eliminados da resposta
			$caract_especiais = array(
			chr(9),
			chr(10),
			chr(13),
			'&nbsp;',
			'</b>',
			'  ',
			'<b>MATRIZ<br>',
			'<b>FILIAL<br>'
			 );

			// prepara a resposta para extrair os dados
			$html = str_replace('<br><b>','<b>',str_replace($caract_especiais,'',strip_tags($html,'<b><br>')));
			
			$html = substr($html, strpos($html, "BLICA FEDERATIVA DO BRASIL"));
			// print_r($html);
			
			$html3 = $html;

			// faz a extração
			for($i=0;$i<count($campos);$i++){		
				$html2 = strstr($html,utf8_decode($campos[$i]));
				$resultado[$i] = trim(pega_o_que_interessa(utf8_decode($campos[$i]).'<b>','<br>',$html2));
				$html=$html2;
			}
			// print_r($resultado);

			// extrai os CNAEs secundarios , quando forem mais de um
			if(strstr($resultado[5],'<b>')){
				$cnae_secundarios = explode('<b>',$resultado[5]);
				$resultado[5] = $cnae_secundarios;
				unset($cnae_secundarios);
			}

			// devolve STATUS da consulta correto
			if(!$resultado[0]){
				if(strstr($html3,utf8_decode('O número do CNPJ não é válido'))){
					$resultado['status'] = 'CNPJ incorreto ou não existe';
				}elseif(strstr($html3,'Captcha Corporativo')){
					$resultado['status'] = 'Texto digitado incorretamente, tente novamente.';
				}else{
					$resultado['status'] = 'Serviço indisponível no momento, tente novamente mais tarde.';
				}
				// {$resultado['status'] = 'Imagem digitada incorretamente';}
			}else{
				$resultado['status'] = 'OK';
			}
			
			return $resultado;
		}

		// pega html resposta da receita
		$getHtmlCNPJ = getHtmlCNPJ( str_replace(array(".", "-", "/", " "), array("", "", "", ""), $_POST["cnpj"]), $_POST["captcha"]);

		if($getHtmlCNPJ){
			$campos = parseHtmlCNPJ($getHtmlCNPJ);
			print_r(json_encode($campos));
			exit();
		}else{
			exit("Nâo foi possível efetuar a busca na receita, tente novamente mais tarde.");
		}
	
	//verifica duplicidade no codigo do vendedor (cad_ra)
	} elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="vendedor" ){
		
		$filtro = '{"cod":"700417","params":[
			{"name":"cad_codigo","value":"'.$_REQUEST["cad_codigo"].'","type":"string"},
			{"name":"cad_ra","value":"'.$_REQUEST["cad_ra"].'","type":"string"}
		]}';
		$datapacket->setHost($TParams->getHost($TParams->getDb()));
		$datapacket->add($filtro);
		$retorno = $datapacket->open(true);

		if( is_array($retorno) && count($retorno)>0 ){
			exit("erro");
		}else{
			exit("ok");
		}
		
	}else {

		$cad_nomeraz = "";
		$cad_snomefant = "";
		$cad_cnpjcpf = "";
		$cad_data = "";
		$cad_uf = "";
		$cad_codmun = "";
		$cad_tipo = "";
		
		if(isset($_REQUEST["cad_cnpjcpf"])&&!empty($_REQUEST["cad_cnpjcpf"])){
			$_REQUEST["cad_cnpjcpf"] = str_replace("-", "", $_REQUEST["cad_cnpjcpf"]);
			$_REQUEST["cad_cnpjcpf"] = str_replace(".", "", $_REQUEST["cad_cnpjcpf"]);
			$_REQUEST["cad_cnpjcpf"] = str_replace("/", "", $_REQUEST["cad_cnpjcpf"]);
			$_REQUEST["cad_cnpjcpf"] = str_replace(" ", "", $_REQUEST["cad_cnpjcpf"]);
		}
		
		if(isset($_REQUEST['cad_nomeraz'])&&!empty($_REQUEST['cad_nomeraz'])){
			$cad_nomeraz.= "AND (cadastro.cad_nomeraz LIKE '%".$_REQUEST["cad_nomeraz"]."%' OR cadastro.cad_snomefant LIKE '%".$_REQUEST["cad_nomeraz"]."%') ";
		}
		if(isset($_REQUEST['cad_snomefant'])&&!empty($_REQUEST['cad_snomefant'])){
			$cad_snomefant.= "AND cadastro.cad_snomefant LIKE '%".$_REQUEST["cad_snomefant"]."%'";
		}
		if(isset($_REQUEST['cad_cnpjcpf'])&&!empty($_REQUEST['cad_cnpjcpf'])){
			$cad_cnpjcpf.= "AND cadastro.cad_cnpjcpf LIKE '".$_REQUEST["cad_cnpjcpf"]."%'";
		}
		if(isset($_REQUEST['cad_uf'])&&!empty($_REQUEST['cad_uf'])){
			$cad_uf.= "AND cadastro.cad_uf = '".$_REQUEST["cad_uf"]."'";
		}
		if(isset($_REQUEST['cad_codmun'])&&!empty($_REQUEST['cad_codmun'])){
			$cad_codmun.= "AND cadastro.cad_codmun = '".$_REQUEST["cad_codmun"]."'";
		}
		if(isset($_REQUEST['cad_tipo'])&&!empty($_REQUEST['cad_tipo'])){
			$cad_tipo.= "AND cadastro.cad_tipo = '".$_REQUEST["cad_tipo"]."'";
		}
		if(isset($_REQUEST['cad_data1'])&&!empty($_REQUEST['cad_data1'])){
			$cad_data.= "AND cadastro.cad_data >= '".$_REQUEST["cad_data1"]."'";
		}
		if(isset($_REQUEST['cad_data2'])&&!empty($_REQUEST['cad_data2'])){
			$cad_data.= " AND cadastro.cad_data <= '".$_REQUEST["cad_data2"]."'";
		}
		if(isset($_REQUEST['cad_fone_ddd'])&&!empty($_REQUEST['cad_fone_ddd'])){
			$cad_data.= " AND telefone.tel_ddd LIKE '".$_REQUEST["cad_fone_ddd"]."%'";
		}
		if(isset($_REQUEST['cad_fone1'])&&!empty($_REQUEST['cad_fone1'])){
			$cad_data.= " AND telefone.tel_prefixo LIKE '".$_REQUEST["cad_fone1"]."%'";
		}
		if(isset($_REQUEST['cad_fone2'])&&!empty($_REQUEST['cad_fone2'])){
			$cad_data.= " AND telefone.tel_numero LIKE '".$_REQUEST["cad_fone2"]."%'";
		}
		
		$filtro = '{"cod":"700300","params":[
			{"name":"cad_nomeraz","value":"'.$cad_nomeraz.'","type":"other"},
			{"name":"cad_snomefant","value":"'.$cad_snomefant.'","type":"other"},
			{"name":"cad_cnpjcpf","value":"'.$cad_cnpjcpf.'","type":"other"},
			{"name":"cad_data","value":"'.$cad_data.'","type":"other"},
			{"name":"cad_uf","value":"'.$cad_uf.'","type":"other"},
			{"name":"cad_codmun","value":"'.$cad_codmun.'","type":"other"},
			{"name":"cad_tipo","value":"'.$cad_tipo.'","type":"other"}
		]}';
		//exit($filtro);

	}
	$datapacket->setHost($TParams->getHost($TParams->getDb()));
	$datapacket->add($filtro);
	$ret = $datapacket->open(true);
	// echo $datapacket->getLastQuery();
	print_r(json_encode($ret));
	
?>