<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');

error_reporting(0);

include 'TParams.class.php';
include 'funcoes.php';

$datapacket = new TParams();

if (isset($_REQUEST['acao']) && $_REQUEST['acao'] == 'salvar') {

    /*
        salvar chamado
    */
    if (isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {

        $dados = json_decode(base64_decode($_REQUEST['dados']));

        $chmd_codigo = "chmd_codigo";
        if (isset($dados->{'chmd_codigo'}) && !empty($dados->{'chmd_codigo'})) {
            $chmd_codigo = $dados->{'chmd_codigo'};
        }

        $chmd_numero = "";
        if (isset($dados->{'chmd_numero'}) && !empty($dados->{'chmd_numero'})) {
            $chmd_numero = $dados->{'chmd_numero'};
        } else {
            $filtro = '{"cod":"501154","params":[]}';
            $datapacket->add($filtro);
            $datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
            $datapacket->add($filtro);
            $ret = $datapacket->open(true);
            $chmd_numero = $ret[0]->{'chmd_numero'};
            $datapacket->clear();
        }

        $chmd_data = "";
        if (isset($dados->{'chmd_data'}) && !empty($dados->{'chmd_data'})) {
            $chmd_data = $dados->{'chmd_data'};
        } else {
            $chmd_data = date('Y-m-d H:i:s');
        }

        $cad_codigo = "";
        if (isset($dados->{'cad_codigo'}) && !empty($dados->{'cad_codigo'})) {
            $cad_codigo = $dados->{'cad_codigo'};
        }

        $svc_codigo = "";
        if (isset($dados->{'svc_codigo'}) && !empty($dados->{'svc_codigo'})) {
            $svc_codigo = $dados->{'svc_codigo'};
        }

        $cod_modulo = "";
        if (isset($dados->{'cod_modulo'}) && !empty($dados->{'cod_modulo'})) {
            $cod_modulo = $dados->{'cod_modulo'};
        }

        $chmd_tpatendimento = "";
        if (isset($dados->{'chmd_tpatendimento'}) && !empty($dados->{'chmd_tpatendimento'})) {
            $chmd_tpatendimento = $dados->{'chmd_tpatendimento'};
        }

        $chmd_tipo = 1;
        if (isset($dados->{'chmd_tipo'}) && !empty($dados->{'chmd_tipo'})) {
            $chmd_tipo = $dados->{'chmd_tipo'};
        }

        $chmd_tecnico = "";
        if (isset($dados->{'chmd_tecnico'}) && !empty($dados->{'chmd_tecnico'})) {
            $chmd_tecnico = $dados->{'chmd_tecnico'};
        }

        $chmd_contato = "";
        if (isset($dados->{'chmd_contato'}) && !empty($dados->{'chmd_contato'})) {
            $chmd_contato = $dados->{'chmd_contato'};
        }

        $chmd_descr = "";
        if (isset($dados->{'chmd_descr'}) && !empty($dados->{'chmd_descr'})) {
            $chmd_descr = $dados->{'chmd_descr'};
        }

        $chmd_resolucao = "";
        if (isset($dados->{'chmd_resolucao'}) && !empty($dados->{'chmd_resolucao'})) {
            $chmd_resolucao = $dados->{'chmd_resolucao'};
        }

        $chmd_ddd = "";
        if (isset($dados->{'chmd_ddd'}) && !empty($dados->{'chmd_ddd'})) {
            $chmd_ddd = $dados->{'chmd_ddd'};
        }

        $chmd_telefone = "";
        if (isset($dados->{'chmd_telefone'}) && !empty($dados->{'chmd_telefone'})) {
            $chmd_telefone = $dados->{'chmd_telefone'};
        }
		
		$chmd_email = "";
        if (isset($dados->{'chmd_email'}) && !empty($dados->{'chmd_email'})) {
            $chmd_email = $dados->{'chmd_email'};
        }

        $chmd_status = "1";
        $chmd_termino = "null";
        if (isset($dados->{'chmd_status'}) && !empty($dados->{'chmd_status'})) {

            $chmd_status = $dados->{'chmd_status'};

            if ($dados->{'chmd_status'} == 3) {
                $chmd_tpatendimento = 4;
                $chmd_termino = "'" . date('Y-m-d H:i:s') . "'";
            }
        }

        $chmd_prioridade = "3";
        if (isset($dados->{'chmd_prioridade'}) && !empty($dados->{'chmd_prioridade'})) {
            $chmd_prioridade = $dados->{'chmd_prioridade'};
        }

        $chmd_prox_retorno = "null";
        if (isset($dados->{'chmd_prox_retorno'}) && !empty($dados->{'chmd_prox_retorno'})) {
            $chmd_prox_retorno = "'" . $dados->{'chmd_prox_retorno'} . "'";
        }

        $usu_login = "null";
        if (isset($dados->{'usu_login'}) && !empty($dados->{'usu_login'})) {
            $usu_login = $dados->{'usu_login'};
        }
		
		$chmd_sla = 3;
        if (isset($dados->{'chmd_sla'}) && !empty($dados->{'chmd_sla'})) {
            $chmd_sla = $dados->{'chmd_sla'};
        }

        if (!empty($chmd_codigo)) {

            /*
                log
            */
            $filtro = '{"cod":"501158","params":[
					{"name":"chmd_codigo","value":"' . $chmd_codigo . '","type":"string"}
				]}';
            $datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
            $datapacket->add($filtro);
            $chamado2log = $datapacket->open(true);
            $datapacket->clear();

            if (!empty($chamado2log)) {

                $filtro = '{"cod":"501158","params":[
						{"name":"chmd_codigo","value":"' . $chmd_codigo . '","type":"string"}
					]}';
                $datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
                $datapacket->add($filtro);
                $chamado2log = $datapacket->open(true);
                $datapacket->clear();

                $alteracao = "";
                $alteracao_descr = array();

                if ($chmd_status != $chamado2log[0]->{"chmd_status"}) {

                    $alteracao = $alteracao = "Alterado status";

                    $obj = new stdClass();
                    $obj->{"tipo"} = "status";
                    $obj->{"antigo"} = $chamado2log[0]->{"chmd_status"};
                    $obj->{"novo"} = $chmd_status;
                    array_push($alteracao_descr, $obj);
                }

                if ($chmd_tecnico != $chamado2log[0]->{"chmd_tecnico"}) {

                    if (empty($alteracao)) {
                        $alteracao = $alteracao = "Alterado técnico";
                    } else {
                        $alteracao = $alteracao .= ", alterado técnico";
                    }

                    $obj = new stdClass();
                    $obj->{"tipo"} = "tecnico";
                    $obj->{"antigo"} = $chamado2log[0]->{"chmd_tecnico"};
                    $obj->{"novo"} = $chmd_tecnico;
                    array_push($alteracao_descr, $obj);
                }

                if (!empty($alteracao_descr)) {

                    $alteracao_descr = base64_encode(json_encode($alteracao_descr));

                    $filtro = '{"cod":"501159","params":[
							{"name":"chmd_codigo","value":"' . $chmd_codigo . '","type":"string"},
							{"name":"chl_data","value":"' . date('Y-m-d H:i:s') . '","type":"string"},
							{"name":"chl_alteracao","value":"' . $alteracao . '","type":"string"},
							{"name":"chl_alteracao_descr","value":"' . $alteracao_descr . '","type":"string"},
							{"name":"usu_login","value":"' . $usu_login . '","type":"string"}
						]}';
                    $datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
                    $datapacket->add($filtro);
                    $datapacket->open(true);
                    $datapacket->clear();
                }
            }
        }

        $filtro = '{"cod":"501153","params":[
			{"name":"chmd_codigo","value":"' . $chmd_codigo . '","type":"string"},
			{"name":"chmd_numero","value":"' . $chmd_numero . '","type":"string"},
			{"name":"chmd_data","value":"' . $chmd_data . '","type":"string"},
			{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"},
			{"name":"svc_codigo","value":"' . $svc_codigo . '","type":"string"},
			{"name":"cod_modulo","value":"' . $cod_modulo . '","type":"string"},
			{"name":"chmd_tpatendimento","value":"' . $chmd_tpatendimento . '","type":"string"},
			{"name":"chmd_tecnico","value":"' . $chmd_tecnico . '","type":"string"},
			{"name":"chmd_contato","value":"' . $chmd_contato . '","type":"string"},
			{"name":"chmd_descr","value":"' . $chmd_descr . '","type":"string"},
			{"name":"chmd_resolucao","value":"' . $chmd_resolucao . '","type":"string"},
			{"name":"chmd_tipo","value":"' . $chmd_tipo . '","type":"integer"},
			{"name":"chmd_status","value":"' . $chmd_status . '","type":"string"},
			{"name":"chmd_prioridade","value":"' . $chmd_prioridade . '","type":"string"},
			{"name":"chmd_prox_retorno","value":"' . $chmd_prox_retorno . '","type":"other"},
			{"name":"chmd_termino","value":"' . $chmd_termino . '","type":"other"},
			{"name":"chmd_ddd","value":"' . $chmd_ddd . '","type":"string"},
			{"name":"chmd_telefone","value":"' . $chmd_telefone . '","type":"string"},
			{"name":"chmd_email","value":"' . $chmd_email . '","type":"string"},
			{"name":"chmd_sla","value":"' . $chmd_sla . '","type":"integer"}
		]}';
        $datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
        $datapacket->add($filtro);
        $ret = $datapacket->open(false, true);
        $datapacket->clear();

        if (!empty($chmd_codigo)) {
            $chmd_codigo = $ret;
        }

        /*
            Movimentacao
        */
        if (isset($dados->{'movimentacao'}) && !empty($dados->{'movimentacao'})) {

            foreach ($dados->{'movimentacao'} as $movimentacao) {
                $filtro = '{"cod":"701067","params":[
					{"name":"chmd_codigo","value":"' . $chmd_codigo . '","type":"integer"},
					{"name":"chmm_codigo","value":"' . $movimentacao->{'chmm_codigo'} . '","type":"string"},
					{"name":"chmm_tecnico","value":"' . $movimentacao->{'chmm_tecnico'} . '","type":"string"},
					{"name":"chmm_tecnico_nome","value":"' . $movimentacao->{'chmm_tecnico_nome'} . '","type":"string"},
					{"name":"chmm_data","value":"' . $movimentacao->{'chmm_data'} . '","type":"string"},
					{"name":"chmm_comentario","value":"' . $movimentacao->{'chmm_comentario'} . '","type":"string"},
					{"name":"chmm_tempo","value":"' . $movimentacao->{'chmm_tempo'} . '","type":"string"}
				]}';
                $datapacket->add($filtro);
            }
            $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
            $datapacket->open(true);
            $datapacket->clear();
        }
		
		//atualizando e-mails do cadastro
		$filtro = '{"cod":"701171","params":[
			{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"},
			{"name":"eml_ender","value":"' . $chmd_email . '","type":"string"},
			{"name":"eml_obs","value":"NULL","type":"other"},
			{"name":"eml_tipo","value":"4","type":"integer"}
		]}';
		$datapacket->add($filtro);
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->open();
		$datapacket->clear();

        $retorno = new stdClass();
        $retorno->{'chmd_codigo'} = $chmd_codigo;
        print_r(json_encode($retorno));
        exit();
    }

    exit('erro');

} else if (isset($_REQUEST['acao']) && $_REQUEST['acao'] == 'contato') {

    if (isset($_REQUEST['modo']) && $_REQUEST['modo'] == 'salvar') {

        if (isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {

            $dados = json_decode(base64_decode($_REQUEST['dados']));

            $cad_codigo = "";
            if (isset($dados->{"cad_codigo"}) && !empty($dados->{"cad_codigo"})) {
                $cad_codigo = $dados->{"cad_codigo"};
            } else {
                exit("o cadastro para vincular ao telefone nao foi passado!");
            }

            $chmt_ddd = "";
            if (isset($dados->{"chmt_ddd"}) && !empty($dados->{"chmt_ddd"})) {
                $chmt_ddd = $dados->{"chmt_ddd"};
            } else {
                exit("o ddd nao foi passado!");
            }

            $chmt_numero = "";
            if (isset($dados->{"chmt_numero"}) && !empty($dados->{"chmt_numero"})) {
                $chmt_numero = $dados->{"chmt_numero"};
            } else {
                exit("o telefone nao foi passado!");
            }

            $chmt_contato = "";
            if (isset($dados->{"chmt_contato"}) && !empty($dados->{"chmt_contato"})) {
                $chmt_contato = $dados->{"chmt_contato"};
            }

            $filtro = '{"cod":"701076","params":[
					{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"},
					{"name":"chmt_numero","value":"' . $chmt_numero . '","type":"string"}
				]}';
            $datapacket->add($filtro);
            $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
            $retorno = $datapacket->open(true);
            $datapacket->clear();

            if ($retorno[0]->{'total'} == 0) {

                $filtro = '{"cod":"701060","params":[
						{"name":"chmt_codigo","value":"","type":"string"},
						{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"},
						{"name":"chmt_ddd","value":"' . $chmt_ddd . '","type":"string"},
						{"name":"chmt_numero","value":"' . $chmt_numero . '","type":"string"},
						{"name":"chmt_contato","value":"' . $chmt_contato . '","type":"string"}
					]}';
                $datapacket->add($filtro);
                $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
                $datapacket->open(true);
                $datapacket->clear();

                exit("ok");
            }

            exit("Telefone já cadastrado!");
        }

        exit("Nenhum parametro foi passado!");

    } else if (isset($_REQUEST['modo']) && $_REQUEST['modo'] == 'deletar') {

        if (isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {

            $dados = json_decode(base64_decode($_REQUEST['dados']));

            $chmt_codigo = "";
            if (isset($dados->{"chmt_codigo"}) && !empty($dados->{"chmt_codigo"})) {
                $chmt_codigo = $dados->{"chmt_codigo"};
            }

            $filtro = '{"cod":"701068","params":[
					{"name":"chmt_codigo","value":"' . $chmt_codigo . '","type":"string"}
				]}';
            $datapacket->add($filtro);
            $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
            $retorno = $datapacket->open(true);
            $datapacket->clear();

            exit("ok");
        }

        exit("Nenhum parametro foi passado!");

    } else {

        /*
            buscar contatos quando seleciono cadastro na tela de abertura de chamado
        */
        $cad_codigo = "";
        if (isset($_REQUEST['cad_codigo']) && !empty($_REQUEST['cad_codigo'])) {
            $cad_codigo = $_REQUEST['cad_codigo'];
        }

        $filtro = '{"cod":"701064","params":[
				{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"}
			]}';
        $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
        $datapacket->add($filtro);
        $ret = $datapacket->open(true);
        $datapacket->clear();
        print_r(json_encode($ret));
    }

} else if (isset($_REQUEST['acao']) && $_REQUEST['acao'] == 'email') {

    if (isset($_REQUEST['modo']) && $_REQUEST['modo'] == 'deletar') {

        if (isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {

            $dados = json_decode(base64_decode($_REQUEST['dados']));

            $chme_codigo = "";
            if (isset($dados->{"chme_codigo"}) && !empty($dados->{"chme_codigo"})) {
                $chme_codigo = $dados->{"chme_codigo"};
            }

            $filtro = '{"cod":"701066","params":[
					{"name":"chme_codigo","value":"' . $chme_codigo . '","type":"string"}
				]}';
            $datapacket->add($filtro);
            $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
            $retorno = $datapacket->open(true);
            $datapacket->clear();

            exit("ok");
        }

        exit("Nenhum parametro foi passado!");

    } else if (isset($_REQUEST['modo']) && $_REQUEST['modo'] == 'salvar') {

        if (isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {

            $dados = json_decode(base64_decode($_REQUEST['dados']));

            $cad_codigo = "";
            if (isset($dados->{"cad_codigo"}) && !empty($dados->{"cad_codigo"})) {
                $cad_codigo = $dados->{"cad_codigo"};
            } else {
                exit("o cadastro para vincular ao email nao foi passado!");
            }

            $chme_email = "";
            if (isset($dados->{"chme_email"}) && !empty($dados->{"chme_email"})) {
                $chme_email = $dados->{"chme_email"};
            } else {
                exit("o email nao foi passado!");
            }

            $filtro = '{"cod":"701075","params":[
					{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"},
					{"name":"chme_email","value":"' . $chme_email . '","type":"string"}
				]}';
            $datapacket->add($filtro);
            $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
            $retorno = $datapacket->open(true);
            $datapacket->clear();

            if ($retorno[0]->{'total'} == 0) {

                $filtro = '{"cod":"701065","params":[
						{"name":"chme_codigo","value":"","type":"string"},
						{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"},
						{"name":"chme_email","value":"' . $chme_email . '","type":"string"}
					]}';
                $datapacket->add($filtro);
                $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
                $datapacket->open(true);
                $datapacket->clear();

                exit("ok");

            }

            exit("Email já cadastrado!");
        }

        exit("Nenhum parametro foi passado!");

    } else if( isset($_REQUEST["modo"]) && $_REQUEST["modo"]=="enviar" ) {
		
		define("__CURLMSG__", $datapacket->HostClient . "/php/mensagem.php");
		
		if(isset($_POST["chmd_numero"]) && $_POST["chmd_numero"]!=""){
			$chmd_numero=$_POST["chmd_numero"];
			$chmd_codigo=$_POST["chmd_codigo"];
		}else{
			//pegar ultimo numero
			$filtro = '{"cod":"501154","params":[]}';
			$datapacket->add($filtro);
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$ret = $datapacket->open(true);
			$chmd_numero = $ret[0]->{'chmd_numero'};
			$chmd_codigo = $ret[0]->{'chmd_codigo'};
			$datapacket->clear();
		}
		//template chamado
		if( isset($_REQUEST["men_codigo"]) && $_REQUEST["men_codigo"]!="" ){
			$men_codigo = $_REQUEST["men_codigo"];
		}else{
			$men_codigo = 20;
		}
		//texto de avaliação do chamado (caso seja uma finalização)
		$avaliacao="";
		if($men_codigo==21){
			$lnk = $datapacket->HostClient.'/avaliar/'.$chmd_codigo."/".$_REQUEST["p"]."/";
			
			$avaliacao = "Por favor, ajude-nos a continuar oferecendo a voc&ecirc; cliente um atendimento cada vez melhor, avalie nosso atendimento clicando em uma das op&ccedil;&otilde;es abaixo, sendo 1 estrela para ruim e 5 estrelas para excelente:</div><div><br></div><div>Avalie nosso atendimento</div><div><a href='".$lnk."1'>&#x2605;</a>&nbsp;<a href='".$lnk."2'>&#x2605;</a>&nbsp;<a href='".$lnk."3'>&#x2605;</a>&nbsp;<a href='".$lnk."4'>&#x2605;</a>&nbsp;<a href='".$lnk."5'>&#x2605;</a>&nbsp;";
		}
		//strings a serem substituidas nas templates de envio
		$textos = array(
			'contrato' => utf8_decode($_POST["contrato"]),
			'tecnico' => $_POST["tecnico"],
			'atendimento' => $_POST["atendimento"],
			'prioridade' => $_POST["prioridade"],
			'status' => $_POST["status"],
			'contato' => utf8_decode($_POST["contato"]),
			'data' => utf8_decode($_POST["data"]),
			'chmd_numero' => $chmd_numero,
			'chmd_descr' => base64_decode($_POST["chmd_descr"]),
			'chmd_resolucao' => base64_decode($_POST["chmd_resolucao"]),
			'avaliacao' => $avaliacao
		);
		// Enviando o email para o FACIL através de uma requisição POST
		$fields = array(
			'p' => $_REQUEST['p'],
			'acao' => 'salvar',
			'men_codigo' => $men_codigo,
			'msg_destinatario' => $_POST["chmd_email"],
			'cad_codigo' => $_POST["cad_codigo"],
			'auto' => true
		);
		$fields = http_build_query($fields);

		$ch = curl_init(); //Abre conexão
		curl_setopt($ch,CURLOPT_URL, __CURLMSG__); //Seta URL
		curl_setopt($ch,CURLOPT_POST, true); //Seta quantidade de campos
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields); //Seta valores dos mesmos
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // ativa o retorno do curl
		$codigoSalvo = curl_exec($ch); //Executa o post
		curl_close($ch); //Fecha conexão
		// Enviando o email para o FACIL através de uma requisição POST
		$fields = array(
			'p' => $_REQUEST['p'],
			'acao' => urlencode('enviar'),
			'msg_codigo' => urlencode(str_replace('ok', '', $codigoSalvo)),
			'textos' => $textos
		);
		$fields = http_build_query($fields);
		
		$ch = curl_init(); //Abre conexão
		curl_setopt($ch,CURLOPT_URL, __CURLMSG__); //Seta URL
		curl_setopt($ch,CURLOPT_POST, true); //Seta quantidade de campos
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields); //Seta valores dos mesmos
		$resultadoEnvio = curl_exec($ch); //Executa o post
		curl_close($ch); //Fecha conexão
		exit("ok");
		
	} else {

        $cad_codigo = "%%";
        if (isset($_REQUEST['cad_codigo']) && !empty($_REQUEST['cad_codigo'])) {
            $cad_codigo = $_REQUEST['cad_codigo'];
        }

        $filtro = '{"cod":"701069","params":[
			{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"}
		]}';
        $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
        $datapacket->add($filtro);
        $retorno = $datapacket->open(true);
        $datapacket->clear();
        print_r(json_encode($retorno));

    }
//registrar avaliação por parte do cliente atendido
} else if (isset($_REQUEST['acao']) && $_REQUEST['acao'] == 'avaliar') {
	
	if( isset($_GET["p"]) && (base64_decode(substr($_GET["p"],0,1).substr($_GET["p"],2))=="UDS" || base64_decode(substr($_GET["p"],0,1).substr($_GET["p"],2))=="MODELO") && isset($_GET["id"]) && is_numeric($_GET["id"]) && isset($_GET["avaliacao"]) && is_numeric($_GET["id"]) && is_numeric($_GET["avaliacao"]) && $_GET["avaliacao"]>0 && $_GET["avaliacao"]<6  ){
		
		if( isset($_POST["txt"]) ){
			
			if($_POST["txt"]!=""){
				$_POST["txt"] = str_replace(array(";","'", "\""), "", $_POST["txt"]);
				$filtro = '{"cod":"501172","params":[
					{"name":"chmd_codigo","value":"' . $_GET["id"] . '","type":"integer"},
					{"name":"chmd_avaliacao_txt","value":"' . $_POST["txt"] . '","type":"string"}
				]}';
				$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
				$datapacket->add($filtro);
				$datapacket->open(true);
				$datapacket->clear();
			}
			echo "Obrigado por enviar sua avaliação!";
			
		}else{
		
			$filtro = '{"cod":"501171","params":[
				{"name":"chmd_codigo","value":"' . $_GET["id"] . '","type":"integer"},
				{"name":"chmd_avaliacao","value":"' . $_GET["avaliacao"] . '","type":"integer"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$datapacket->open(true);
			$datapacket->clear();
			
			echo "Obrigado por enviar sua avaliação!<br><br>Sua nota foi: ".$_GET["avaliacao"]."<br>Gostaria de justificar sua nota com uma breve descrição?<br><br><form action='' method='post'><textarea name='txt' maxlength='255' style='width:300px; height:80px;'></textarea><br><br><input type='submit' value='Enviar'></form>";
			
		}
		
	}else{
		exit("A página que você está tentando exibir não existe!");
	}
	
} else if (isset($_REQUEST['acao']) && $_REQUEST['acao'] == 'buscaChamado') {
    /*
        buscar chamado quando selecionado na tela de selecao de chamados
    */
    $chmd_codigo = "";
    if (isset($_REQUEST['chmd_codigo']) && !empty($_REQUEST['chmd_codigo'])) {

        $chmd_codigo = $_REQUEST['chmd_codigo'];

        $filtro = '{"cod":"501156","params":[
			{"name":"database","value":"' . $datapacket->getDb() . '","type":"other"},
			{"name":"chmd_codigo","value":"' . $chmd_codigo . '","type":"integer"}
		]}';
        $datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
        $datapacket->add($filtro);
        $ret = $datapacket->open(true);
        $datapacket->clear();

        if (!empty($ret)) {

            $retorno = $ret[0];

            $filtro = '{"cod":"701063","params":[
					{"name":"chmd_codigo","value":"and a.chmd_codigo = ' . $chmd_codigo . '","type":"other"}
				]}';
            $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
            $datapacket->add($filtro);
            $retorno->{'movimentacao'} = $datapacket->open(true);
            $datapacket->clear();

            print_r(json_encode($retorno));
            exit();
        }

        exit('chamado nao encontrado');
    }

    exit('nenhum codigo foi passado');

} else if (isset($_REQUEST['acao']) && $_REQUEST['acao'] == 'buscaCadastro') {
    /*
        buscar dados do cadastro selecionado
    */
    $retorno = new stdClass();

    $cad_codigo = "";
    if (isset($_REQUEST['cad_codigo']) && !empty($_REQUEST['cad_codigo'])) {

        $cad_codigo = $_REQUEST['cad_codigo'];

        $filtro = '{"cod":"701064","params":[
				{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"}
			]}';
        $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
        $datapacket->add($filtro);
        $retorno->{'telefone'} = $datapacket->open(true);


        $datapacket->clear();

        $filtro = '{"cod":"701172","params":[
			{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"},
			{"name":"eml_tipo","value":"2,4","type":"other"}
		]}';
        $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
        $datapacket->add($filtro);
        $retorno->{'email'} = $datapacket->open(true);
		
		$datapacket->clear();
		
		$filtro = '{"cod":"701078","params":[
				{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"}
			]}';
        $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
        $datapacket->add($filtro);
        $retorno->{'facil'} = $datapacket->open(true);

        $datapacket->clear();

        $filtro = '{"cod":"501152","params":[
				{"name":"database","value":"' . $datapacket->getDb() . '","type":"other"},
				{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"},
				{"name":"emp_codigo","value":"' . $datapacket->getCompany()->{'emp_codigo'} . '","type":"string"}
			]}';
        $datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
        $datapacket->add($filtro);


        $retorno->{'contrato'} = $datapacket->open(true);
        $datapacket->clear();

        if (isset($_REQUEST['chmd_codigo']) && !empty($_REQUEST['chmd_codigo'])) {
            $filtro = '{"cod":"701063","params":[
					{"name":"chmd_codigo","value":"and a.chmd_codigo = ' . $_REQUEST['chmd_codigo'] . '","type":"other"}
				]}';
            $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
            $datapacket->add($filtro);
            $retorno->{'movimentacao'} = $datapacket->open(true);
            $datapacket->clear();
        }

        print_r(json_encode($retorno));
    }

} else if (isset($_REQUEST['acao']) && $_REQUEST['acao'] == 'contatocrm') {
    /*
        Salvar cadastro e contato tela contato CRM
    */
    if (isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {

        $dados = json_decode(base64_decode($_REQUEST['dados']));

        $cad_codigo = "";
        if (isset($dados->{'cad_codigo'}) && !empty($dados->{'cad_codigo'})) {
            $cad_codigo = $dados->{'cad_codigo'};
        }

        $cad_nomeraz = "";
        if (isset($dados->{'cad_nomeraz'}) && !empty($dados->{'cad_nomeraz'})) {
            $cad_nomeraz = $dados->{'cad_nomeraz'};
        }

        $cad_snomefant = "";
        if (isset($dados->{'cad_snomefant'}) && !empty($dados->{'cad_snomefant'})) {
            $cad_snomefant = $dados->{'cad_snomefant'};
        }

        $filtro = '{"cod":"701061","params":[
				{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"},
				{"name":"cad_nomeraz","value":"' . $cad_nomeraz . '","type":"string"},
				{"name":"cad_snomefant","value":"' . $cad_snomefant . '","type":"string"}
			]}';
        $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
        $datapacket->add($filtro);
        $datapacket->open(true);
        $datapacket->clear();

        $cad_email = "";
        if (isset($dados->{'cad_email'}) && !empty($dados->{'cad_email'})) {

            $filtro = '{"cod":"701065","params":[
					{"name":"chme_codigo","value":"","type":"string"},
					{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"},
					{"name":"chme_email","value":"' . $dados->{'cad_email'} . '","type":"string"}
				]}';
            $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
            $datapacket->add($filtro);
            $datapacket->open(true);
            $datapacket->clear();
        }

        if (isset($dados->{'contatos'}) && !empty($dados->{'contatos'})) {

            foreach ($dados->{'contatos'} as $contato) {

                $filtro = '{"cod":"701060","params":[
						{"name":"chmt_codigo","value":"","type":"string"},
						{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"},
						{"name":"chmt_ddd","value":"' . $contato->{'chmt_ddd'} . '","type":"string"},
						{"name":"chmt_numero","value":"' . $contato->{'chmt_numero'} . '","type":"string"},
						{"name":"chmt_contato","value":"' . $contato->{'chmt_contato'} . '","type":"string"}
					]}';
                $datapacket->add($filtro);
            }

            $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
            $datapacket->open(true);
            $datapacket->clear();
        }

        exit('ok');

    } else {

        exit('erro');
    }

} else if (isset($_REQUEST['acao']) && $_REQUEST['acao'] == 'consultaFinanceiro') {
    /*
        consultar pendencias de financeiro quando seleciono cadastro na tela de abertura de chamado
    */

    $cad_codigo = "";
    if (isset($_REQUEST['cad_codigo']) && !empty($_REQUEST['cad_codigo'])) {
        $cad_codigo = $_REQUEST['cad_codigo'];
    }

    $filtro = '{"cod":"501151","params":[
			{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"}
		]}';
    $datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
    $datapacket->add($filtro);
    $ret = $datapacket->open(true);
    // echo $datapacket->getLastQuery();
    $datapacket->clear();
    if ($ret[0]->{'pendencias'} > 0) {
        exit('ok');
    } else {
        exit('sem pendencias');
    }

} else if (isset($_REQUEST['acao']) && $_REQUEST['acao'] == 'movimentacao') {
    /*
        Gerenciamento de movimentacao na tela de chamados
    */

    if (isset($_REQUEST['modo']) && $_REQUEST['modo'] == 'deletar') {

        if (isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {

            $dados = json_decode(base64_decode($_REQUEST['dados']));

            $chmd_codigo = "";
            if (isset($dados->{'chmd_codigo'}) && !empty($dados->{'chmd_codigo'})) {
                $chmd_codigo = "and a.chmd_codigo = " . $dados->{'chmd_codigo'};
            }

            $chmm_codigo = "";
            if (isset($dados->{'chmm_codigo'}) && !empty($dados->{'chmm_codigo'})) {
                $chmm_codigo = "and a.chmm_codigo = " . $dados->{'chmm_codigo'};
            }

            $filtro = '{"cod":"701062","params":[
					{"name":"chmd_codigo","value":"' . $chmd_codigo . '","type":"string"},
					{"name":"chmm_codigo","value":"' . $chmm_codigo . '","type":"string"}
				]}';
            $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
            $datapacket->add($filtro);
            $ret = $datapacket->open(true);
            $datapacket->clear();

            exit('ok');
        } else {

            exit('erro dados');
        }

    } else {

        $chmd_codigo = "";
        if (isset($_REQUEST['chmd_codigo']) && !empty($_REQUEST['chmd_codigo'])) {
            $chmd_codigo = "and a.chmd_codigo = " . $_REQUEST['chmd_codigo'];
        }

        $filtro = '{"cod":"701063","params":[
				{"name":"chmd_codigo","value":"' . $chmd_codigo . '","type":"other"}
			]}';
        $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
        $datapacket->add($filtro);
        $ret = $datapacket->open(true);
        print_r(json_encode($ret));
        $datapacket->clear();
    }

} else if (isset($_REQUEST['acao']) && $_REQUEST['acao'] == 'carregaCadastro') {
    /*
        Buscar dados para preencher aba do cadastro
    */

    if (isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {

        $dados = json_decode(base64_decode($_REQUEST['dados']));

        $cad_codigo = "";
        if (isset($dados->{'cad_codigo'}) && !empty($dados->{'cad_codigo'})) {
            $cad_codigo = $dados->{'cad_codigo'};
        }

        $filtro = '{"cod":"701070","params":[
				{"name":"cad_codigo","value":"' . $cad_codigo . '","type":"string"}
			]}';
        $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
        $datapacket->add($filtro);
        $ret = $datapacket->open(true);
        $datapacket->clear();
        print_r(json_encode($ret));
    }

} else if (isset($_REQUEST['acao']) && $_REQUEST['acao'] == 'anexos') {
    /*
        Anexos relacionados ao chamado
    */
    if (isset($_REQUEST['modo']) && $_REQUEST['modo'] == 'salvar') {

        if (isset($_FILES) && !empty($_FILES)) {

            if (isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {

                $dados = json_decode(base64_decode($_REQUEST['dados']));

                $chmd_codigo = "";
                if (isset($dados->{'chmd_codigo'}) && !empty($dados->{'chmd_codigo'})) {
                    $chmd_codigo = $dados->{'chmd_codigo'};
                }

                $chma_descr = "";
                if (isset($dados->{'chma_descr'}) && !empty($dados->{'chma_descr'})) {
                    $chma_descr = $dados->{'chma_descr'};
                }

                define("__UPDIR__", $datapacket->getUploads() . $datapacket->getCompany()->{'emp_codigo'} . "/chamado/" . $chmd_codigo . "/");
                if (!is_dir(__UPDIR__)) @mkdir(__UPDIR__, 0777, true);

                foreach ($_FILES as $indice => $arquivo) {

                    $microtime = str_replace(array(",", "."), array("", ""), microtime(true));
                    $arquivo['name'] = str_replace(" ", "_", $arquivo['name']);

                    move_uploaded_file($arquivo['tmp_name'], __UPDIR__ . $microtime . "_" . $arquivo['name']);

                    $filtro = '{"cod":"701072","params":[
							{"name":"chmd_codigo","value":"' . $chmd_codigo . '","type":"integer"},
							{"name":"chma_nome","value":"' . $arquivo['name'] . '","type":"string"},
							{"name":"chma_nome_disco","value":"' . $microtime . "_" . $arquivo['name'] . '","type":"string"},
							{"name":"chma_descr","value":"' . $chma_descr[str_replace("file", "", $indice)] . '","type":"string"}
						]}';
                    $datapacket->add($filtro);
                }

                $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
                $datapacket->open(true);
                $datapacket->clear();

                exit('ok');

            } else {

                exit('codigo');
            }

        } else {

            exit('files');
        }

    } else if (isset($_REQUEST['modo']) && $_REQUEST['modo'] == 'deletar') {

        if (isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {

            $dados = json_decode(base64_decode($_REQUEST['dados']));

            $chma_codigo = "";
            if (isset($dados->{'chma_codigo'}) && !empty($dados->{'chma_codigo'})) {
                $chma_codigo = $dados->{'chma_codigo'};
            }

            $chma_nome_disco = "";
            if (isset($dados->{'chma_nome_disco'}) && !empty($dados->{'chma_nome_disco'})) {
                $chma_nome_disco = $dados->{'chma_nome_disco'};
            }

            $chmd_codigo = "";
            if (isset($dados->{'chmd_codigo'}) && !empty($dados->{'chmd_codigo'})) {
                $chmd_codigo = $dados->{'chmd_codigo'};
            }

            $filtro = '{"cod":"701073","params":[
					{"name":"chmd_codigo","value":"' . $chmd_codigo . '","type":"integer"},
					{"name":"chma_codigo","value":"' . $chma_codigo . '","type":"integer"}
				]}';
            $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
            $datapacket->add($filtro);
            $ret = $datapacket->open(true);
            $datapacket->clear();

            if ($ret == "Template 701073: OK") {
                define("__UPDIR__", $datapacket->getUploads() . $datapacket->getCompany()->{'emp_codigo'} . "/chamado/" . $chmd_codigo . "/");
                if (is_file(__UPDIR__ . $chma_nome_disco)) unlink(__UPDIR__ . $chma_nome_disco);
            }

            exit('ok');

        } else {

            exit('params');
        }

    } else if (isset($_REQUEST['modo']) && $_REQUEST['modo'] == 'baixar') {

        if (isset($_REQUEST['d']) && !empty($_REQUEST['d'])) {

            $dados = json_decode(base64_decode($_REQUEST['d']));

            $chmd_codigo = "";
            if (isset($dados->{'chmd_codigo'}) && !empty($dados->{'chmd_codigo'})) {
                $chmd_codigo = $dados->{'chmd_codigo'};
            }

            $chma_nome = "";
            if (isset($dados->{'chma_nome'}) && !empty($dados->{'chma_nome'})) {
                $chma_nome = $dados->{'chma_nome'};
            }

            define("__UPDIR__", $datapacket->getUploads() . $datapacket->getCompany()->{'emp_codigo'} . "/chamado/" . $chmd_codigo . "/");

            header('Content-Disposition: attachment; filename="' . $chma_nome . '"');
            header('Content-Length: ' . filesize(__UPDIR__ . $chma_nome));
            while (ob_get_level()) ob_end_clean();
            @readfile(__UPDIR__ . $chma_nome);


        } else {

            exit('params');
        }

    } else {

        if (isset($_REQUEST['chmd_codigo']) && !empty($_REQUEST['chmd_codigo'])) {

            $chmd_codigo = $_REQUEST['chmd_codigo'];

            $filtro = '{"cod":"701071","params":[
					{"name":"chmd_codigo","value":"' . $chmd_codigo . '","type":"integer"}
				]}';
            $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
            $datapacket->add($filtro);
            $ret = $datapacket->open(true);
            $datapacket->clear();

            if (!empty($ret)) {

                foreach ($ret as $anexo) {

                    $image_formats = array(".jpg", ".jpeg", ".bmp", ".gif", ".png");
                    $extension = substr($anexo->{'chma_nome_disco'}, strpos($anexo->{'chma_nome_disco'}, '.'), strlen($anexo->{'chma_nome_disco'}));

                    if (in_array($extension, $image_formats)) {

                        $anexo->{'imagem'} = "/uploads/" . $datapacket->getCompany()->{'emp_codigo'} . "/chamado/" . $chmd_codigo . "/" . $anexo->{'chma_nome_disco'};
                        $anexo->{'url'} = "/uploads/" . $datapacket->getCompany()->{'emp_codigo'} . "/chamado/" . $chmd_codigo . "/" . $anexo->{'chma_nome_disco'};

                    } else {

                        $anexo->{'url'} = "/uploads/" . $datapacket->getCompany()->{'emp_codigo'} . "/chamado/" . $chmd_codigo . "/" . $anexo->{'chma_nome_disco'};
                        $anexo->{'imagem'} = "resources/images/download-chamado.png";
                    }
                }
            }

            print_r(json_encode($ret));

        } else {

            print_r(json_encode(array()));
        }
    }

} else {
    /*
     *	Pesquisa de chamados
     */

    if (!isset($_REQUEST['start']) || (isset($_REQUEST['start']) && empty($_REQUEST['start']))) {
        $_REQUEST['start'] = 0;
    }
    if (!isset($_REQUEST['limit']) || (isset($_REQUEST['limit']) && empty($_REQUEST['limit']))) {
        $_REQUEST['limit'] = 25;
    }

    $params = "";
    if (isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {

        $dados = json_decode(base64_decode($_REQUEST['dados']));


        if (isset($dados->{"pesquisaMista"}) && !empty($dados->{"pesquisaMista"})) {

            /*
            * a.chmd_numero = numero do chamado;
            * b.cad_cnpjcpf = cnpj ou cpf do cliente;
            * b.cad_nomeraz = nome do cliente;
            * c.cad_nomeraz = nome do tecnico;
            */
            $params = " and (a.chmd_numero like '" . $dados->{"pesquisaMista"} . "%' or b.cad_cnpjcpf like '" . $dados->{"pesquisaMista"} . "%' or b.cad_nomeraz like '%" . $dados->{"pesquisaMista"} . "%' or c.cad_nomeraz like '%" . $dados->{"pesquisaMista"} . "%')";

        } else {

            if (isset($dados->{"chmd_numero"}) && !empty($dados->{"chmd_numero"})) {
                $params = " and a.chmd_numero = '" . $dados->{"chmd_numero"} . "'";
            }

            if (isset($dados->{"cad_codigo"}) && !empty($dados->{"cad_codigo"})) {
                $params .= " and a.cad_codigo = '" . $dados->{"cad_codigo"} . "'";
            }


            if (isset($dados->{"chmd_status"}) && is_integer($dados->{"chmd_status"}) && $dados->{"chmd_status"} !== '') {

                if ($dados->{"chmd_status"} === 'aberto' || $dados->{"chmd_status"} == 1) {

                    $params .= " and a.chmd_status in (0,1,2,4)";

                } else {

                    if (
                        $dados->{"chmd_status"} === 0
                        || $dados->{"chmd_status"} === 1
                        || $dados->{"chmd_status"} === 2
                        || $dados->{"chmd_status"} === 3
                        || $dados->{"chmd_status"} === 4
                        || $dados->{"chmd_status"} === 5
                        || $dados->{"chmd_status"} === 6
                    ) {

                        $params .= " and a.chmd_status = " . $dados->{"chmd_status"} . " ";

                    }
                }

            }
            /*    if (isset($dados->{"chmd_status"}) && is_integer($dados->{"chmd_status"}) && $dados->{"chmd_status"} > 0) {


                    if ($dados->{"chmd_status"} === 'aberto' || $dados->{"chmd_status"} == 1) {

                        $params .= " and a.chmd_status in (0,1,2,4)";

                    } else {

                        $params .= " and a.chmd_status = " . $dados->{"chmd_status"} . " ";

                    }

                } elseif (isset($dados->{"chmd_status"}) && $dados->{"chmd_status"} == 0 || $dados->{"chmd_status"} == '0') {

                    if ($dados->{"chmd_status"} != '') {
                        if (is_string($dados->{"chmd_status"})) {
                            $params .= " and a.chmd_status = '" . $dados->{"chmd_status"} . "'";
                        } else {
                            $params .= " and a.chmd_status = " . $dados->{"chmd_status"} . " ";
                        }
                    }
                }*/

            if (isset($dados->{"chmd_tecnico"}) && !empty($dados->{"chmd_tecnico"})) {
                $params .= " and a.chmd_tecnico = '" . $dados->{"chmd_tecnico"} . "'";
            }

            if (isset($dados->{"chmd_ddd"}) && !empty($dados->{"chmd_ddd"})) {
                $params .= " and a.chmd_ddd like '" . $dados->{"chmd_ddd"} . "%'";
            }

            if (isset($dados->{"chmd_telefone"}) && !empty($dados->{"chmd_telefone"})) {
                $params .= " and a.chmd_numero like '" . preg_replace('/[^0-9]/', "", $dados->{"chmd_telefone"}) . "%'";
            }

            if (isset($dados->{"dias_aberto"}) && !empty($dados->{"dias_aberto"})) {
                $params .= " and a.chmd_status != 3 and a.chmd_data between '" . date('Y-m-d', strtotime("-" . $dados->{"dias_aberto"} . " days")) . " 00:00:00' and '" . date('Y-m-d', strtotime("-" . $dados->{"dias_aberto"} . " days")) . " 23:59:59'";
            }

            if (isset($dados->{"chmd_prox_retorno"}) && !empty($dados->{"chmd_prox_retorno"})) {
                $params .= " and a.chmd_prox_retorno between '" . date("Y-m-d 00:00:00", strtotime(implode("-", array_reverse(explode("/", $dados->{"chmd_prox_retorno"}))))) . "' and '" . date("Y-m-d 23:59:59", strtotime(implode("-", array_reverse(explode("/", $dados->{"chmd_prox_retorno"}))))) . "'";
            }

            if (isset($dados->{"chmd_tpatendimento"}) && !empty($dados->{"chmd_tpatendimento"})) {
                $params .= " and a.chmd_tpatendimento = '" . $dados->{"chmd_tpatendimento"} . "'";
            }


            if (isset($dados->{"periodo"}) && !empty($dados->{"periodo"}) && $dados->{"periodo"} == 1) {

                $params .= " and a.chmd_data between '" . date("Y-m-d 00:00:00") . "' and '" . date("Y-m-d 23:59:59") . "'";

            } else if (isset($dados->{"periodo"}) && !empty($dados->{"periodo"}) && $dados->{"periodo"} == 2) {

                $params .= " and a.chmd_data between '" . date('Y-m-d 00:00:00', strtotime("-1 days")) . "' and '" . date('Y-m-d 23:59:59', strtotime("-1 days")) . "'";

            } else if (isset($dados->{"periodo"}) && !empty($dados->{"periodo"}) && $dados->{"periodo"} == 3) {

                $params .= " and a.chmd_data between '" . date('Y-m-d 00:00:00', strtotime("-7 days")) . "' and '" . date('Y-m-d 23:59:59') . "'";

            } else if (isset($dados->{"periodo"}) && !empty($dados->{"periodo"}) && $dados->{"periodo"} == 4) {

                $params .= " and a.chmd_data between '" . date('Y-m-d 00:00:00', strtotime("-15 days")) . "' and '" . date('Y-m-d 23:59:59') . "'";

            } else if (isset($dados->{"periodo"}) && !empty($dados->{"periodo"}) && $dados->{"periodo"} == 5) {

                $params .= " and a.chmd_data between '" . date('Y-m-d 00:00:00', strtotime("-30 days")) . "' and '" . date('Y-m-d 23:59:59') . "'";

            } else if (isset($dados->{"periodo"}) && !empty($dados->{"periodo"}) && $dados->{"periodo"} == 6) {

                if (isset($dados->{"chmd_data_ini"}) && !empty($dados->{"chmd_data_ini"})) {

                    $params .= " and a.chmd_data >= '" . date("Y-m-d 00:00:00", strtotime(implode("-", array_reverse(explode("/", $dados->{"chmd_data_ini"}))))) . "'";

                    if (isset($dados->{"chmd_data_fim"}) && !empty($dados->{"chmd_data_fim"})) {

                        $params .= " and a.chmd_data <= '" . date("Y-m-d 23:59:59", strtotime(implode("-", array_reverse(explode("/", $dados->{"chmd_data_fim"}))))) . "'";
                    }

                } else if (isset($dados->{"chmd_data_fim"}) && !empty($dados->{"chmd_data_fim"})) {

                    $params .= " and a.chmd_data <= '" . date("Y-m-d 23:59:59", strtotime(implode("-", array_reverse(explode("/", $dados->{"chmd_data_fim"}))))) . "'";
                }
            }
        }

    }

    $filtro = '{"cod":"501150","params":[
        {"name":"database","value":"' . $datapacket->getDb() . '","type":"other"},
        {"name":"params","value":"' . $params . '","type":"other"},
        {"name":"start","value":"' . $_REQUEST['start'] . '","type":"integer"},
        {"name":"limit","value":"' . $_REQUEST['limit'] . '","type":"integer"}
    ]}';

    $datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
    $datapacket->add($filtro);
    $ret = $datapacket->open(true);
    //print_r($datapacket->getLastQuery());
    $datapacket->clear();
    $filtro = json_decode($filtro);
    $filtro->cod = '501157';
    $datapacket->add(json_encode($filtro));
    $datapacket->open();
    $count = $datapacket->getRecordCount();
    $datapacket->clear();
    // $total = (!empty($count)) ? $count[0]->{'total'} : 0;
    $total = (!empty($count)) ? $count : 0;

    $obj = new StdClass();
    $obj->total = $total;
    $obj->data = $ret;
    print_r(json_encode($obj));

}

?>
