<?php
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	error_reporting(E_ALL);
	set_time_limit(0);
	ob_start();

	include '../php/funcoes.php';
	include '../php/TParams.class.php';
	
	$datapacket = new TParams();
	$datapacket->debug(true);
	
	$company = $datapacket->getCompany();
	$imagem = $datapacket->HostClient . "resources/images/logo_facil.png";

	if(!isset($_REQUEST['cmp_codigo']) || empty($_REQUEST['cmp_codigo'])){
		exit("Erro ao receber o codigo da proposta");
	}
	if(!isset($_REQUEST['tap_codigo']) || empty($_REQUEST['tap_codigo'])){
		exit("Erro ao receber o codigo do TAP");
	}

	$cmp_codigo = $_REQUEST['cmp_codigo'];
	$tap_codigo = $_REQUEST['tap_codigo'];

	$filtro = '{"cod":"501274","params":[
		{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
		{"name":"cmp_codigo","value":"'.$cmp_codigo.'","type":"integer"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$rowdata = $datapacket->open(true);
	$atendimento = $rowdata[0];
	$datapacket->clear();

	$filtro = '{"cod":"501217","params":[
		{"name":"cmp_codigo","value":"'.$cmp_codigo.'","type":"integer"},
		{"name":"coa_codigo","value":"%","type":"string"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$rowdata = $datapacket->open(true);
	$atendimento->{'proposta'} = $rowdata[0];
	$datapacket->clear();

	$filtro = '{"cod":"501273","params":[
		{"name":"tap_codigo","value":"'.$tap_codigo.'","type":"integer"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$rowdata = $datapacket->open(true);
	$atendimento->{"proposta"}->{"tap"} = $rowdata[0];
	$datapacket->clear();

	$filtro = '{"cod":"501260","params":[
		{"name":"tck_codigo","value":"%","type":"string"},
		{"name":"tap_codigo","value":"'.$atendimento->{"proposta"}->{"tap"}->{"tap_codigo"}.'","type":"integer"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$atendimento->{"proposta"}->{"tap"}->{"checklist"} = $datapacket->open(true);
	$datapacket->clear();

	$filtro = '{"cod":"501261","params":[
		{"name":"tsh_codigo","value":"%","type":"string"},
		{"name":"tap_codigo","value":"'.$atendimento->{"proposta"}->{"tap"}->{"tap_codigo"}.'","type":"integer"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$atendimento->{"proposta"}->{"tap"}->{"steakholder"} = $datapacket->open(true);
	$datapacket->clear();

	$filtro = '{"cod":"501262","params":[
		{"name":"tae_codigo","value":"%","type":"string"},
		{"name":"tap_codigo","value":"'.$atendimento->{"proposta"}->{"tap"}->{"tap_codigo"}.'","type":"integer"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$atendimento->{"proposta"}->{"tap"}->{"equipe"} = $datapacket->open(true);
	$datapacket->clear();

	$filtro = '{"cod":"501263","params":[
		{"name":"tar_codigo","value":"%","type":"string"},
		{"name":"tap_codigo","value":"'.$atendimento->{"proposta"}->{"tap"}->{"tap_codigo"}.'","type":"integer"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$atendimento->{"proposta"}->{"tap"}->{"restricoes"} = $datapacket->open(true);
	$datapacket->clear();

	$filtro = '{"cod":"501264","params":[
		{"name":"tpr_codigo","value":"%","type":"string"},
		{"name":"tap_codigo","value":"'.$atendimento->{"proposta"}->{"tap"}->{"tap_codigo"}.'","type":"integer"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$atendimento->{"proposta"}->{"tap"}->{"riscos"} = $datapacket->open(true);
	$datapacket->clear();

	$filtro = '{"cod":"501265","params":[
		{"name":"tpm_codigo","value":"%","type":"string"},
		{"name":"tap_codigo","value":"'.$atendimento->{"proposta"}->{"tap"}->{"tap_codigo"}.'","type":"integer"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$atendimento->{"proposta"}->{"tap"}->{"marcos"} = $datapacket->open(true);
	$datapacket->clear();

	$filtro = '{"cod":"501224","params":[
		{"name":"cpi_codigo","value":"%","type":"string"},
		{"name":"cmp_codigo","value":"'.$cmp_codigo.'","type":"string"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$atendimento->{"proposta"}->{"orcamento"} = $datapacket->open(true);
	$datapacket->clear();

	?>
		<!DOCTYPE HTML>
		<html lang="pt-BR">
			
			<head>

				<meta http-equiv="Content-Type" content="text/html"; charset="utf-8" />
			
			</head>

			<body style="-webkit-print-color-adjust: exact; font-size:10px; ">

				<img src="<?php echo $imagem; ?>" hidden>

				<div style="width:20%; padding:10px 2%; float:left; font-size:12px;">

					<div style="width:100%;"> 
						<span style="font-weight:bold; color:#626262;"> Nome do Projeto </span> <br />
						<span style="color:#FF8400; font-size:11px;"> <?php echo substr(base64_decode($atendimento->{"proposta"}->{"cmp_nome"}), 0, 20); ?> </span> 
					</div>

					<div style="width:100%;"> 
						<span style="font-weight:bold; color:#626262;"> Contato do Projeto </span> <br />
						<span style="color:#FF8400; font-size:11px;"> <?php echo substr(base64_decode($atendimento->{"proposta"}->{"cmp_responsavel"}), 0, 20); ?> </span> 
					</div>

					<div style="width:100%;"> 
						<span style="font-weight:bold; color:#626262;"> Nome do Cliente </span> <br />
						<span style="color:#FF8400; font-size:11px;"> <?php echo substr($atendimento->{"cad_nomeraz"}, 0, 20); ?> </span> 
					</div>

					<div style="width:100%;"> 
						<span style="font-weight:bold; color:#626262;"> Preparado por </span> <br />
						<span style="color:#FF8400; font-size:11px;"> <?php echo substr($atendimento->{"coa_responsavel_nome"}, 0, 20); ?> </span> 
					</div>

				</div>								

				<?php 

					if(isset($atendimento->{"proposta"}->{"tap"}->{"tap_objetivo"}) && !empty($atendimento->{"proposta"}->{"tap"}->{"tap_objetivo"})){

						?>
							<div style="width:75%; float:right; margin-top:20px; padding-bottom:;">

								<div style="width:96%; float:left; padding:5px 2%; background-color:#FF8400; color:#FFF; font-size:20px;"><span> Objetivo do Documento </span></div>
								
								<div style="width:98%; float:left; padding:10px 0px 0px 2px;">  

									<?php 

										echo ucfirst(json_decode(base64_decode($atendimento->{"proposta"}->{"tap"}->{"tap_objetivo"})));

									?>

								</div>

							</div>

						<?php
					}

					if(isset($atendimento->{"proposta"}->{"tap"}->{"tap_beneficios"}) && !empty($atendimento->{"proposta"}->{"tap"}->{"tap_beneficios"})){

						?>
							<div style="width:75%; float:right; margin-top:20px; padding-bottom:;">

								<div style="width:96%; float:left; padding:5px 2%; background-color:#FF8400; color:#FFF; font-size:20px;"><span> Benefícios do Projeto </span></div>
								
								<div style="width:98%; float:left; padding:10px 0px 0px 2px;">

									<?php 

										echo ucfirst(json_decode(base64_decode($atendimento->{"proposta"}->{"tap"}->{"tap_beneficios"})));

									?>

								</div>

							</div>

						<?php
					}

					if(isset($atendimento->{"proposta"}->{"tap"}->{"checklist"}) && !empty($atendimento->{"proposta"}->{"tap"}->{"checklist"})){

						?>
							<div style="width:75%; float:right; margin-top:20px; padding-bottom:;">

								<div style="width:96%; float:left; padding:5px 2%; background-color:#FF8400; color:#FFF; font-size:20px;"><span> Checklist de Aceitação </span></div>
								
								<div style="width:99.5%; float:left; padding:10px 0px 0px 2px;">  

									<div style="width:100%; float:left; border:1px solid #000;">
										<div style="width:19%; float:left; padding:5px 0px 5px 5px; text-align:center;"> <strong> CÓD. </strong> </div>
										<div style="width:78%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <strong> DESCRIÇÃO </strong> </div>
									</div>

									<?php 

										foreach ($atendimento->{"proposta"}->{"tap"}->{"checklist"} as $list) {
											?>

												<div style="width:100%; float:left; border-right:1px solid #000; border-bottom:1px solid #000; border-left:1px solid #000;">
													<div style="width:19%; float:left; padding:5px 0px 5px 5px; text-align:center;"> <?php echo $list->{"tck_numero"}; ?> </div>
													<div style="width:78%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <?php echo $list->{"tck_descr"}; ?> </div>
												</div>
											<?php
										}

									?>

								</div>

							</div>

						<?php
					}

					if(isset($atendimento->{"proposta"}->{"tap"}->{"steakholder"}) && !empty($atendimento->{"proposta"}->{"tap"}->{"steakholder"})){

						?>
							<div style="width:75%; float:right; margin-top:20px; padding-bottom:;">

								<div style="width:96%; float:left; padding:5px 2%; background-color:#FF8400; color:#FFF; font-size:20px;"><span> Envolvidos </span></div>
								
								<div style="width:99.5%; float:left; padding:10px 0px 0px 2px;">  

									<div style="width:100%; float:left; border:1px solid #000;">
										<div style="width:25%; float:left; padding:5px 0px 5px 5px;"> <strong> Nome </strong> </div>
										<div style="width:35%; float:left; padding:5px 0px 5px 5px;border-left:1px solid #000;"> <strong> Papel no Projeto </strong> </div>
										<div style="width:35%; float:left; padding:5px 0px 5px 5px;border-left:1px solid #000;"> <strong> E-mail </strong> </div>
									</div>

									<?php 

										foreach ($atendimento->{"proposta"}->{"tap"}->{"steakholder"} as $list) {
											?>

												<div style="width:100%; float:left; border-right:1px solid #000; border-bottom:1px solid #000; border-left:1px solid #000;">
													<div style="width:25%; float:left; padding:5px 0px 5px 5px;"> <?php echo $list->{"tsh_nome"}; ?> </div>
													<div style="width:35%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <?php echo $list->{"tsh_papel"}; ?> </div>
													<div style="width:35%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <?php echo $list->{"tsh_email"}; ?> </div>
												</div>
											<?php
										}

									?>

								</div>

							</div>

						<?php
					}

					if(isset($atendimento->{"proposta"}->{"tap"}->{"equipe"}) && !empty($atendimento->{"proposta"}->{"tap"}->{"equipe"})){

						?>
							<div style="width:75%; float:right; margin-top:50px; padding-bottom:;">

								<div style="width:96%; float:left; padding:5px 2%; background-color:#FF8400; color:#FFF; font-size:20px;"><span> Equipe do Projeto </span></div>
								
								<div style="width:99.5%; float:left; padding:10px 0px 0px 2px;">  

									<div style="width:100%; float:left; border:1px solid #000;">
										<div style="width:40%; float:left; padding:5px 0px 5px 5px;"> <strong> Nome </strong> </div>
										<div style="width:40%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <strong> Papel desempenhado </strong> </div>
										<div style="width:11%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <strong> Externos</strong> </div>
									</div>

									<?php 

										foreach ($atendimento->{"proposta"}->{"tap"}->{"equipe"} as $list) {
											?>

												<div style="width:100%; float:left; border-right:1px solid #000; border-bottom:1px solid #000; border-left:1px solid #000;">
													<div style="width:40%; float:left; padding:5px 0px 5px 5px;"> <?php echo $list->{"tae_nome"}; ?> </div>
													<div style="width:40%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <?php echo $list->{"tae_papel"}; ?> </div>
													<div style="width:11%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000; text-align:center;"> <?php echo ($list->{"tae_externo"} == 1) ? "S" : "N"; ?> </div>
												</div>
											<?php
										}

									?>

								</div>

							</div>

						<?php
					}

					if(isset($atendimento->{"proposta"}->{"tap"}->{"restricoes"}) && !empty($atendimento->{"proposta"}->{"tap"}->{"restricoes"})){

						?>
							<div style="width:75%; float:right; margin-top:20px; padding-bottom:;">

								<div style="width:96%; float:left; padding:5px 2%; background-color:#FF8400; color:#FFF; font-size:20px;"><span> Restrições </span></div>
								
								<div style="width:99.5%; float:left; padding:10px 0px 0px 2px;">  

									<div style="width:100%; float:left; border:1px solid #000;">
										<div style="width:30%; float:left; padding:5px 0px 5px 5px;"> <strong> TÍTULO </strong> </div>
										<div style="width:67%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <strong> DESCRIÇÃO </strong> </div>
									</div>

									<?php 

										foreach ($atendimento->{"proposta"}->{"tap"}->{"restricoes"} as $list) {
											?>

												<div style="width:100%; float:left; border-right:1px solid #000; border-bottom:1px solid #000; border-left:1px solid #000;">
													<div style="width:30%; float:left; padding:5px 0px 5px 5px; "> <?php echo $list->{"tar_titulo"}; ?> </div>
													<div style="width:67%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <?php echo $list->{"tar_descr"}; ?> </div>
												</div>
											<?php
										}

									?>

								</div>

							</div>

						<?php
					}

					if(isset($atendimento->{"proposta"}->{"tap"}->{"riscos"}) && !empty($atendimento->{"proposta"}->{"tap"}->{"riscos"})){

						?>
							<div style="width:75%; float:right; margin-top:20px; padding-bottom:;">

								<div style="width:96%; float:left; padding:5px 2%; background-color:#FF8400; color:#FFF; font-size:20px;"><span> Riscos </span></div>
								
								<div style="width:99.5%; float:left; padding:10px 0px 0px 2px;">  

									<div style="width:100%; float:left; border:1px solid #000;">
										<div style="width:20%; float:left; padding:5px 0px 5px 5px;"> <strong> TÍTULO </strong> </div>
										<div style="width:38%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <strong> DESCRIÇÃO </strong> </div>
										<div style="width:38%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <strong> AÇÃO DE CONTENÇÃO </strong> </div>
									</div>

									<?php 

										foreach ($atendimento->{"proposta"}->{"tap"}->{"riscos"} as $list) {
											?>

												<div style="width:100%; float:left; border-right:1px solid #000; border-bottom:1px solid #000; border-left:1px solid #000;">
													<div style="width:20%; float:left; padding:5px 0px 5px 5px;"> <?php echo $list->{"tpr_titulo"}; ?> </div>
													<div style="width:38%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <?php echo $list->{"tpr_descr"}; ?> </div>
													<div style="width:38%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000;"> <?php echo base64_decode($list->{"tpr_contencao"}); ?> </div>
												</div>
											<?php
										}

									?>

								</div>

							</div>

						<?php
					}

					if(isset($atendimento->{"proposta"}->{"orcamento"}) && !empty($atendimento->{"proposta"}->{"orcamento"})){

						?>
							<div style="width:75%; float:right; margin-top:20px; padding-bottom:;">

								<div style="width:96%; float:left; padding:5px 2%; background-color:#FF8400; color:#FFF; font-size:20px;"><span> Orçamento </span></div>
								
								<div style="width:99.5%; float:left; padding:10px 0px 0px 2px;">  

									<div style="width:100%; float:left; border:1px solid #000;">
										<div style="width:66%; float:left; padding:5px 0px 5px 5px;"> <strong> Descrição </strong> </div>
										<div style="width:15%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000; text-align:center;"> <strong> Tempo </strong> </div>
										<div style="width:15%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000; text-align:center;"> <strong> Valor </strong> </div>
									</div>

									<?php 

										foreach ($atendimento->{"proposta"}->{"orcamento"} as $list) {
											?>

												<div style="width:100%; float:left; border-right:1px solid #000; border-bottom:1px solid #000; border-left:1px solid #000;">
													<div style="width:66%; float:left; padding:5px 0px 5px 5px;"> <?php echo $list->{"cpi_descr"}; ?> </div>
													<div style="width:15%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000; text-align:center;"> <?php echo valorFormat($list->{"cpi_tempo"}); ?> </div>
													<div style="width:15%; float:left; padding:5px 0px 5px 5px; border-left:1px solid #000; text-align:center;"> <?php echo valorFormat($list->{"cpi_valor"}); ?> </div>
												</div>
											<?php
										}

									?>

								</div>

								<div style="width:98%; float:left; padding:10px 0px 0px 2px;">  

									<span>

										<?php 

											echo "Foi previsto um orçamento de R$" . valorFormat($atendimento->{"proposta"}->{"cmp_valor"}) . ", considerando o tempo de " . $atendimento->{"proposta"}->{"cmp_tempoEstimado"} . " horas para entrega do projeto.";

										?>

									</span>

								</div>

							</div>

						<?php
					}

				?>

			</body>

		</html>

	<?php 

	$html = ob_get_clean();
	$arquivo = str_replace(array(".",","), "", microtime(true));
	$fp = fopen($datapacket->getHostRoot()."tmp/".$arquivo.'.html', 'w');
	fwrite($fp, $html);
	fclose($fp);

	$params = array();
	array_push($params, $datapacket->getHostRoot().'class/phantomjs/bin/phantomjs');
	array_push($params, $datapacket->getHostRoot().'class/phantomjs/rasterizeTap.js');
	array_push($params, $datapacket->getHostRoot().'tmp/'.$arquivo.'.html');
	array_push($params, $datapacket->getHostRoot().'tmp/'.$arquivo.'.pdf');
	array_push($params, base64_encode(json_encode($company)));
	array_push($params, base64_encode($imagem));
	exec(implode(" ", $params));

	if(file_exists($datapacket->getHostRoot()."tmp/".$arquivo.'.pdf')){
		
		if($_SERVER['SERVER_NAME'] == "dev.grupouds.com.br"){

			$ambiente = explode("/", substr($_SERVER['SCRIPT_NAME'], 1));
			
			if($ambiente[0] != "desktop"){

				exit("/" . $ambiente[0] . "/" . $ambiente[1] . "/tmp/" . $arquivo . ".pdf");
			}	
		} 
	
		echo "/desktop/tmp/" . $arquivo . ".pdf";

	} else { 
		
		echo "Ocorreu um erro ao gerar o arquivo.";
	}

 
 ?> 