<?php 
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');

	include 'TParams.class.php';
	include 'funcoes.php';

	$datapacket = new TParams();
	$datapacket->debug(true);

	$params = "";
	$doc_atualizado = "";

	if(isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])){

		$dados = json_decode(base64_decode($_REQUEST['dados']));

		if(isset($dados->{'doc_tipo'}) && !empty($dados->{'doc_tipo'})){
			$params .= " and a.doc_tipo in (" . implode(',', $dados->{'doc_tipo'}) . ")";
		}
		
		if(isset($dados->{'doc_status'}) && !empty($dados->{'doc_status'})){
			$params .= " and a.doc_status in (" . implode(',', $dados->{'doc_status'}) . ")";
		}
		
		if(isset($dados->{'cad_codigo'}) && !empty($dados->{'cad_codigo'})){
			$params .= " and a.cad_codigo = '" . $dados->{'cad_codigo'} . "'";
		}
		
		if(isset($dados->{'doc_valor_ini'}) && !empty($dados->{'doc_valor_ini'})){
			$params .= " and a.doc_valor >= " . $dados->{'doc_valor_ini'};
		}
		
		if(isset($dados->{'doc_valor_fim'}) && !empty($dados->{'doc_valor_fim'})){
			$params .= " and a.doc_valor <= " . $dados->{'doc_valor_fim'};
		}
		
		if(isset($dados->{'doc_pagrec'}) && !empty($dados->{'doc_pagrec'})){
			$params .= " and a.doc_pagrec = " . $dados->{'doc_pagrec'};
		}
		
		if(isset($dados->{'doc_codigo'}) && !empty($dados->{'doc_codigo'})){
			$params .= " and (a.doc_codigo like '" . $dados->{'doc_codigo'} . "%' or a.doc_numero like '" . $dados->{'doc_codigo'} . "%')";
		}
		
		if(isset($dados->{'doc_numero'}) && !empty($dados->{'doc_numero'})){
			$params .= " and (a.doc_codigo like '" . $dados->{'doc_numero'} . "%' or a.doc_numero like '" . $dados->{'doc_numero'} . "%')";
		}
		
		if(isset($dados->{'doc_origem'}) && !empty($dados->{'doc_origem'})){
			$params .= " and a.doc_origem = " . $dados->{'doc_origem'};
		}
		
		if(isset($dados->{'doc_atualizado'}) && !empty($dados->{'doc_atualizado'})){
			$doc_atualizado = "1";
		}

		/* datas */
			
			$cad_codigo = (isset($dados->{'cad_codigo'}) 	 && !empty($dados->{'cad_codigo'})) 	? $dados->{'cad_codigo'} 	 : "";
			$data_ini   = (isset($dados->{'doc_data_ini'}) 	 && !empty($dados->{'doc_data_ini'})) 	? $dados->{'doc_data_ini'} 	 : "";
			$data_fim   = (isset($dados->{'doc_data_fim'}) 	 && !empty($dados->{'doc_data_fim'})) 	? $dados->{'doc_data_fim'} 	 : "";
			$vcto_ini   = (isset($dados->{'doc_dtvcto_ini'}) && !empty($dados->{'doc_dtvcto_ini'})) ? $dados->{'doc_dtvcto_ini'} : "";
			$vcto_fim   = (isset($dados->{'doc_dtvcto_fim'}) && !empty($dados->{'doc_dtvcto_fim'})) ? $dados->{'doc_dtvcto_fim'} : "";

			if ($cad_codigo) {

				if ($vcto_ini) $params .= " and a.doc_dtvcto >= '" . substr($vcto_ini, 0, 10) . " 00:00:00'";
				if ($vcto_fim) $params .= " and a.doc_dtvcto <= '" . substr($vcto_fim, 0, 10) . " 23:59:00'";
				if ($data_ini) $params .= " and a.doc_data >= '" . substr($data_ini, 0, 10) . " 00:00:00'";
				if ($data_fim) $params .= " and a.doc_data <= '" . substr($data_fim, 0, 10) . " 23:59:00'";

			} else {

				/* se tiver vencimento inicial ou vencimento final */
				if ($vcto_ini || $vcto_fim) {
					
					/* se tiver vencimento inicial e vencimento final */
					if ($vcto_ini && $vcto_fim) {

						$params .= " and a.doc_dtvcto between '" . substr($vcto_ini, 0, 10) . " 00:00:00' and '" . substr($vcto_fim, 0, 10) . " 23:59:59'";

					/* se tiver vencimento inicial e não vencimento final */
					} else if ($vcto_ini && !$vcto_fim) {

						// $params .= " and a.doc_dtvcto between '" . substr($vcto_ini, 0, 10) . " 00:00:00' and '" . date('Y-m-d 23:59:59', strtotime("+30 days", strtotime($vcto_ini))). "'";
						$params .= " and a.doc_dtvcto between '" . substr($vcto_ini, 0, 10) . " 00:00:00' and '" . date('Y-m-d 23:59:59', strtotime("+365 days", strtotime($vcto_ini))). "'";

					/* se não tiver vencimento inicial e tiver vencimento final */
					} else if (!$vcto_ini && $vcto_fim) {

						// $params .= " and a.doc_dtvcto between '". date('Y-m-d H:i:s', strtotime("-30 days", strtotime($vcto_fim))) . "' and '" . substr($vcto_fim, 0, 10) . " 23:59:59'";
						$params .= " and a.doc_dtvcto between '". date('Y-m-d H:i:s', strtotime("-365 days", strtotime($vcto_fim))) . "' and '" . substr($vcto_fim, 0, 10) . " 23:59:59'";
						
					/* se não tiver vencimento inicial e não vencimento final */
					} else {

						// $params .= " and a.doc_dtvcto between '" . date('Y-m-1 00:00:00') . "' and '" . date('Y-m-' . date("t", mktime(0, 0, 0, date("m"), '01', date("Y"))) . ' 23:59:59') . "'";
						$params .= " and a.doc_dtvcto between '" . date('Y-m-d 00:00:00', strtotime("-182 days")) . "' and '" . date('Y-m-d 23:59:59', strtotime("+182 days")) . "'";
					}

					/* se tiver data de inclusao inicial e final */
					if ($data_ini && $data_fim) {
						
						$params .= " and a.doc_data between '" . substr($data_ini, 0, 10) . " 00:00:00' and '" . substr($data_fim, 0, 10) . " 23:59:59'";
					
					/* se tiver data de inclusao final e não tiver final */
					} else if ($data_ini && !$data_fim) {
						
						// $params .= " and a.doc_data between '" . substr($data_ini, 0, 10) . " 00:00:00' and '" . date('Y-m-d 23:59:59', strtotime("+30 days", strtotime($data_ini))). "'";
						$params .= " and a.doc_data between '" . substr($data_ini, 0, 10) . " 00:00:00' and '" . date('Y-m-d 23:59:59', strtotime("+365 days", strtotime($data_ini))). "'";

					/* se não tiver data de inclusao inicial e tiver final */
					} else if (!$data_ini && $data_fim) {
						
						// $params .= " and a.doc_data between '". date('Y-m-d H:i:s', strtotime("-30 days", strtotime($data_fim))) . "' and '" . substr($data_fim, 0, 10) . " 23:59:59'";
						$params .= " and a.doc_data between '". date('Y-m-d H:i:s', strtotime("-365 days", strtotime($data_fim))) . "' and '" . substr($data_fim, 0, 10) . " 23:59:59'";
					}

				/* se tiver data de inclusao inicial ou data de inclusao final */
				} else if ($data_ini || $data_fim) {
					
					/* se tiver data de inlcusao inicial e data de inlcusao final */
					if ($data_ini && $data_fim) {

						$params .= " and a.doc_data between '" . substr($data_ini, 0, 10) . " 00:00:00' and '" . substr($data_fim, 0, 10) . " 23:59:59'";

					/* se tiver data de inlcusao inicial e não data de inlcusao final */
					} else if ($data_ini && !$data_fim) {

						// $params .= " and a.doc_data between '" . substr($data_ini, 0, 10) . " 00:00:00' and '" . date('Y-m-d 23:59:59', strtotime("+30 days", strtotime($data_ini))). "'";
						$params .= " and a.doc_data between '" . substr($data_ini, 0, 10) . " 00:00:00' and '" . date('Y-m-d 23:59:59', strtotime("+365 days", strtotime($data_ini))). "'";

					/* se não tiver data de inlcusao inicial e tiver data de inlcusao final */
					} else if (!$data_ini && $data_fim) {

						// $params .= " and a.doc_data between '". date('Y-m-d H:i:s', strtotime("-30 days", strtotime($data_fim))) . "' and '" . substr($data_fim, 0, 10) . " 23:59:59'";
						$params .= " and a.doc_data between '". date('Y-m-d H:i:s', strtotime("-365 days", strtotime($data_fim))) . "' and '" . substr($data_fim, 0, 10) . " 23:59:59'";
						
					/* se não tiver data de inlcusao inicial e não data de inlcusao final */
					} else {

						// $params .= " and a.doc_data between '" . date('Y-m-1 00:00:00') . "' and '" . date('Y-m-' . date("t", mktime(0, 0, 0, date("m"), '01', date("Y"))) . ' 23:59:59') . "'";
						$params .= " and a.doc_data between '" . date('Y-m-d 00:00:00', strtotime("-182 days")) . "' and '" . date('Y-m-d 23:59:59', strtotime("+182 days")) . "'";
					}

				/* se  não tiver data de inclusao e nem data final */
				} else {

					// $params .= " and a.doc_dtvcto between '". date('Y-m-1 00:00:00') . "' and '" . date('Y-m-' . date("t", mktime(0, 0, 0, date("m"), '01', date("Y"))) . ' 23:59:59') . "'";
					$params .= " and a.doc_dtvcto between '". date('Y-m-d 00:00:00', strtotime("-182 days")) . "' and '" . date('Y-m-d 23:59:59', strtotime("+182 days")) . "'";
				}
			}
		/************     *************/
	
	}else if(isset($_REQUEST['doc_pagrec']) && !empty($_REQUEST['doc_pagrec'])){
		
		$params .= " and a.doc_pagrec = " . $_REQUEST['doc_pagrec'];

	}
	
	if( $params!="" ){
	
		$filtro = '{"cod":"500650","params":[
			{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
			{"name":"doc_atualizado","value":"'.$doc_atualizado.'","type":"string"},
			{"name":"params","value":"'.$params.'","type":"other"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
		$datapacket->add($filtro);
		$retorno = $datapacket->open(true);
		$datapacket->clear();

		$documentos = array();
		
		if(!empty($retorno)){

			$datasAtualizadas = array();
			foreach($retorno as $docto){

				if(isset($docto->{"lgd_dtatualizada"}) && !empty($docto->{"lgd_dtatualizada"})){

					$obj = new stdClass();
					$obj->{"doc_codigo"} = $docto->{"doc_codigo"};
					$obj->{"lgd_data"} = $docto->{"lgd_data"};
					$obj->{"lgd_dtatualizada"} = $docto->{"lgd_dtatualizada"};
					array_push($datasAtualizadas, $obj);
				}
			}

			foreach($retorno as $docto){

				if(!objectInArray($documentos, "doc_codigo", $docto->{"doc_codigo"})){

					array_push($documentos, $docto);
				}
			}

			foreach($documentos as $docto){

				$docto->{"lgd_dtatualizada"} = array();

				$datasAtualizadas = ordenacao($datasAtualizadas, "lgd_data", "desc");

				foreach($datasAtualizadas as $data){

					if($docto->{"doc_codigo"} == $data->{"doc_codigo"}){

						array_push($docto->{"lgd_dtatualizada"}, $data->{"lgd_dtatualizada"});
					}
				}
				
				$docto->{"lgd_dtatualizada"} = base64_encode(json_encode($docto->{"lgd_dtatualizada"}));
			}
		}

		print_r(json_encode($documentos));
	
	}

?>