<?php

	setlocale (LC_ALL, 'pt_BR.UTF-8');
	set_time_limit(1500);
	error_reporting(E_ALL ^ E_NOTICE);
	
	include_once "../class/useful.php";
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';

	$datapacket = new Datapacket();
	$Useful = new Useful();
	$TParams=new TParams();
	
	function diffDate($d1, $d2){
		$d1 = explode("-", $d1);
		$d2 = explode("-", $d2);
		$X = 86400;
		return floor( ( ( mktime(0, 0, 0, $d2[1], $d2[2], $d2[0]) - mktime(0, 0, 0, $d1[1], $d1[2], $d1[0] ) ) / $X ) );
	}
	
	// empresa
	// $company = $TParams->getCompany();	

	$_REQUEST['ini'] = ( isset($_REQUEST['ini']) ) ? $_REQUEST['ini'] : 9997;
	$_REQUEST['fim'] = ( isset($_REQUEST['fim']) ) ? $_REQUEST['fim'] : 9997;
	
	$doctos = array();
	$emails = array();
	
	for($i=$_REQUEST['ini'];$i<=$_REQUEST['fim'];$i++){
		
		$num="e".str_pad($i,4,"0",STR_PAD_LEFT);
		$datapacket->setHost($TParams->getHost($num));
		$comum = ($num==9998) ? ($num+1)."_comum" : $num."_comum";
		
		//atualizar contratos ativos com data final vencida, para o status de inativo
		$filtro = '{"cod":"700199","params":[]}';
		$datapacket->add($filtro);
		$datapacket->open();
		$datapacket->clear();
		
		//selecionar todos os contratos por frequencia (sem condição de pagamento) e ativos cuja data final não esteja definida
		$filtro = '{"cod":"500485","params":[
			{"name":"dbcomum","value":"'.$comum.'","type":"other"}
		]}';
		$datapacket->add($filtro);
		$contratos = $datapacket->open();
		$datapacket->clear();
		
		//percorre contratos selecionados, simula parcelas, e verifica se a diferença entre o vencimento e a data atual coincide com os dias de antecedencia para geração (emp_dias_envio), em caso afirmativo gera a parcela
		foreach($contratos as $cont){
			
			//verificar a ultima parcela de cada contrato, caso nao exista criar a primeira
			$filtro = '{"cod":"500486","params":[
				{"name":"doc_numero","value":"CTT'.$cont["ctt_numero"].'","type":"other"}
			]}';
			$datapacket->add($filtro);
			$parc = $datapacket->open();
			$datapacket->clear();
			
			if(isset($parc[0]["doc_codigo"])){ //existem parcelas criadas?
				
				$add = $cont["frq_dias"]/ 30; //numero de meses a adicionar
				$data = explode("-", $parc[0]["doc_dtvcto"]);
				$mes = str_pad(($data[1]+$add), 2, "0", STR_PAD_LEFT);
				$prox_vcto = ($mes>12) ? ($data[0]+1)."-01-".str_pad($cont["ctt_datavcto"], 2, "0", STR_PAD_LEFT) : $data[0]."-".$mes."-".str_pad($cont["ctt_datavcto"], 2, "0", STR_PAD_LEFT);
				$dias = diffDate(date("Y-m-d"), $prox_vcto);
				
				if($dias>0 && $dias <= $cont["emp_dias_envio"]){ // verificar se diferença entre data atual e prox vcto é igual (ou menor) ao definido nas configurações para geração da parcela
					
					$descricao = "Contrato nro ".$cont["ctt_numero"]." - parcela ".($parc[0]["doc_nparc"]+1)." - ".$cont["svc_descr"];
					$descricao.= ( $cont["ctt_svc_obs"]!="" ) ? " - ".base64_decode($cont["ctt_svc_obs"]) : "";
				
					$filtroParc  = '{"cod":"500130", "params":[
						{"name":"doc_codigo", "value":"'.substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 12).'", "type":"string"},
						{"name":"doc_numero", "value":"CTT'.$cont["ctt_numero"].'-'.($parc[0]["doc_nparc"]+1).'", "type":"string"},
						{"name":"doc_tipo", "value":"'.$cont["doc_tipo"].'", "type":"integer"},
						{"name":"doc_pagrec", "value":"2", "type":"integer"},
						{"name":"doc_data", "value":"'.date('Y-m-d H:i:s').'", "type":"string"},
						{"name":"doc_valor", "value":"'.$cont["ctt_valor"].'", "type":"float"},
						{"name":"doc_dtvcto", "value":"'.$prox_vcto.' 00:00:00", "type":"string"},
						{"name":"doc_dtpgto", "value":"NULL", "type":"other"},
						{"name":"doc_vlrpg", "value":"NULL", "type":"other"},
						{"name":"doc_descr", "value":"'.$descricao.'", "type":"string"},
						{"name":"doc_status", "value":"0", "type":"integer"},
						{"name":"doc_codbar", "value":" ", "type":"string"},
						{"name":"doc_linhadig", "value":"NULL", "type":"other"},
						{"name":"doc_banco", "value":"NULL", "type":"other"},
						{"name":"doc_agencia", "value":"NULL", "type":"other"},
						{"name":"doc_conta", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($cont["emp_multa"]) && $cont["emp_multa"]>0 ) ? '{"name":"doc_multa", "value":"'.$cont["emp_multa"].'", "type":"float"},' : '{"name":"doc_multa", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($cont["emp_jurosdiario"]) && $cont["emp_jurosdiario"]>0 ) ? '{"name":"doc_juros", "value":"'.$cont["emp_jurosdiario"].'", "type":"float"},' : '{"name":"doc_juros", "value":"NULL", "type":"other"},';
					$filtroParc.='{"name":"doc_honorarios", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($cont["ctt_previsao"]) && $cont["ctt_previsao"]>0 ) ? '{"name":"doc_dias_envio", "value":"'.$cont["ctt_previsao"].'", "type":"integer"},' : '{"name":"doc_dias_envio", "value":"0", "type":"integer"},';
					$filtroParc.= '{"name":"doc_nparc", "value":"'.($parc[0]["doc_nparc"]+1).'", "type":"integer"},
						{"name":"doc_tparc", "value":"NULL", "type":"other"},
						{"name":"doc_json_parcial", "value":"NULL", "type":"other"},
						{"name":"doc_obs", "value":"'.$descricao.'", "type":"string"},
						{"name":"cad_codigo", "value":"'.$cont["cad_codigo"].'", "type":"string"},
						{"name":"ser_codigo", "value":"CTT", "type":"string"},
						{"name":"ccu_codigo","value":"NULL","type":"other"},
						{"name":"doc_cod_pai", "value":"NULL", "type":"other"},
						{"name":"plc_codigo", "value":"NULL", "type":"other"},
						{"name":"cad_codatend", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($cont["ctt_carteira"]) && $cont["ctt_carteira"]!="" ) ? '{"name":"doc_carteira", "value":"'.$cont["ctt_carteira"].'", "type":"string"},' : '{"name":"doc_carteira", "value":"'.$parc[0]["doc_carteira"].'", "type":"string"},';
					$filtroParc.= '{"name":"doc_nossonumero", "value":"NULL", "type":"other"},
						{"name":"svc_codigo", "value":"NULL", "type":"other"},
						{"name":"doc_sacador", "value":"NULL", "type":"other"}
					]}';
					
					$datapacket->add($filtroParc);
					$datapacket->open();
					$datapacket->clear();
				}
				
			}else{ //caso não existam parcelas para o contrato, cria a primeira
				
				$dias = round(diffDate($cont["ctt_dataini"], $cont["ctt_datacobr"]));
				$prop = $dias * round($cont["ctt_valor"]/ $cont["frq_dias"]);
				$valorprop = ( $cont["ctt_dataini"]<$cont["ctt_datacobr"] && $prop<$cont["ctt_valor"] ) ?  $cont["ctt_valor"]+$prop :  $cont["ctt_valor"]-$prop;
				$valor = ( isset($cont["ctt_proporcional"]) && $cont["ctt_proporcional"]==1 ) ? $valorprop : $cont["ctt_valor"];
				$descricao = "Contrato nro ".$cont["ctt_numero"]." - parcela 1 - ".$cont["svc_descr"];
				$descricao.= ( $cont["ctt_svc_obs"]!="" ) ? " - ".base64_decode($cont["ctt_svc_obs"]) : "";
				
				$filtroParc  = '{"cod":"500130", "params":[
					{"name":"doc_codigo", "value":"'.substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 12).'", "type":"string"},
					{"name":"doc_numero", "value":"CTT'.$cont["ctt_numero"].'-1", "type":"string"},
					{"name":"doc_tipo", "value":"'.$cont["doc_tipo"].'", "type":"integer"},
					{"name":"doc_pagrec", "value":"2", "type":"integer"},
					{"name":"doc_data", "value":"'.date('Y-m-d H:i:s').'", "type":"string"},
					{"name":"doc_valor", "value":"'.$valor.'", "type":"float"},
					{"name":"doc_dtvcto", "value":"'.$cont["ctt_datacobr"].' 00:00:00", "type":"string"},
					{"name":"doc_dtpgto", "value":"NULL", "type":"other"},
					{"name":"doc_vlrpg", "value":"NULL", "type":"other"},
					{"name":"doc_descr", "value":"'.$descricao.'", "type":"string"},
					{"name":"doc_status", "value":"0", "type":"integer"},
					{"name":"doc_codbar", "value":" ", "type":"string"},
					{"name":"doc_linhadig", "value":"NULL", "type":"other"},
					{"name":"doc_banco", "value":"NULL", "type":"other"},
					{"name":"doc_agencia", "value":"NULL", "type":"other"},
					{"name":"doc_conta", "value":"NULL", "type":"other"},';
				$filtroParc.= ( isset($cont["emp_multa"]) && $cont["emp_multa"]>0 ) ? '{"name":"doc_multa", "value":"'.$cont["emp_multa"].'", "type":"float"},' : '{"name":"doc_multa", "value":"NULL", "type":"other"},';
				$filtroParc.= ( isset($cont["emp_jurosdiario"]) && $cont["emp_jurosdiario"]>0 ) ? '{"name":"doc_juros", "value":"'.$cont["emp_jurosdiario"].'", "type":"float"},' : '{"name":"doc_juros", "value":"NULL", "type":"other"},';
				$filtroParc.='{"name":"doc_honorarios", "value":"NULL", "type":"other"},';
				$filtroParc.= ( isset($cont["ctt_previsao"]) && $cont["ctt_previsao"]>0 ) ? '{"name":"doc_dias_envio", "value":"'.$cont["ctt_previsao"].'", "type":"integer"},' : '{"name":"doc_dias_envio", "value":"0", "type":"integer"},';
				$filtroParc.= '{"name":"doc_nparc", "value":"1", "type":"integer"},
					{"name":"doc_tparc", "value":"NULL", "type":"other"},
					{"name":"doc_json_parcial", "value":"NULL", "type":"other"},
					{"name":"doc_obs", "value":"'.$descricao.'", "type":"string"},
					{"name":"cad_codigo", "value":"'.$cont["cad_codigo"].'", "type":"string"},
					{"name":"ser_codigo", "value":"CTT", "type":"string"},
					{"name":"ccu_codigo","value":"NULL","type":"other"},
					{"name":"doc_cod_pai", "value":"NULL", "type":"other"},
					{"name":"plc_codigo", "value":"NULL", "type":"other"},
					{"name":"cad_codatend", "value":"NULL", "type":"other"},';
				$filtroParc.= ( isset($cont["ctt_carteira"]) && $cont["ctt_carteira"]!="" ) ? '{"name":"doc_carteira", "value":"'.$cont["ctt_carteira"].'", "type":"string"},' : '{"name":"doc_carteira", "value":"NULL", "type":"other"},';
				$filtroParc.= '{"name":"doc_nossonumero", "value":"NULL", "type":"other"},
					{"name":"svc_codigo", "value":"NULL", "type":"other"},
					{"name":"doc_sacador", "value":"NULL", "type":"other"}
				]}';
				
				$datapacket->add($filtroParc);
				$datapacket->open();
				$datapacket->clear();
					
			}
			
		}
		
		//selecionar todos os boletos a receber em aberto ordenados por cliente e vencimento
		$filtro = '{"cod":"500487","params":[]}';
		$datapacket->add($filtro);
		$boletos = $datapacket->open();
		$cont=0;
		$codigos = "";
		$valor=0;
		$vcto="";
		$cad="";
		
		//percorrer boletos selecionados e verificar os que possuem mesmo vencimento e cliente, criar boleto unificado (doc_tipo=14) e atualizar grupo de boletos com o código pai do novo boleto único bem como o tipo vinculado (doc_tipo=0)
		foreach($boletos as $bol){
			
			if($bol["doc_dtvcto"]==$vcto && $bol["cad_codigo"]==$cad ){
				
				$codigos.= "'".$bol["doc_codigo"]."', ";
				$valor+=$bol["doc_valor"];
				
				$cont++;
				
			}elseif($cont>1){
				
				//boleto unico integrado
				$valor = number_format($valor, 4, ".", "");
				$cod = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 12);
				$filtroParc  = '{"cod":"500130", "params":[
					{"name":"doc_codigo", "value":"'.$cod.'", "type":"string"},
					{"name":"doc_numero", "value":"'.$cod.'", "type":"string"},
					{"name":"doc_tipo", "value":"14", "type":"integer"},
					{"name":"doc_pagrec", "value":"2", "type":"integer"},
					{"name":"doc_data", "value":"'.date('Y-m-d H:i:s').'", "type":"string"},
					{"name":"doc_valor", "value":"'.$valor.'", "type":"float"},
					{"name":"doc_dtvcto", "value":"'.$vcto.'", "type":"string"},
					{"name":"doc_dtpgto", "value":"NULL", "type":"other"},
					{"name":"doc_vlrpg", "value":"NULL", "type":"other"},
					{"name":"doc_descr", "value":"BOLETO ÚNICO INTEGRADO", "type":"string"},
					{"name":"doc_status", "value":"0", "type":"integer"},
					{"name":"doc_codbar", "value":" ", "type":"string"},
					{"name":"doc_linhadig", "value":"NULL", "type":"other"},
					{"name":"doc_banco", "value":"NULL", "type":"other"},
					{"name":"doc_agencia", "value":"NULL", "type":"other"},
					{"name":"doc_conta", "value":"NULL", "type":"other"},';
				$filtroParc.= ( isset($multa) && $multa>0 ) ? '{"name":"doc_multa", "value":"'.$multa.'", "type":"float"},' : '{"name":"doc_multa", "value":"NULL", "type":"other"},';
				$filtroParc.= ( isset($juros) && $juros>0 ) ? '{"name":"doc_juros", "value":"'.$juros.'", "type":"float"},' : '{"name":"doc_juros", "value":"NULL", "type":"other"},';
				$filtroParc.='{"name":"doc_honorarios", "value":"NULL", "type":"other"},';
				$filtroParc.= ( isset($prev) && $prev>0) ? '{"name":"doc_dias_envio", "value":"'.$prev.'", "type":"integer"},' : '{"name":"doc_dias_envio", "value":"0", "type":"integer"},';
				$filtroParc.= '{"name":"doc_nparc", "value":"1", "type":"integer"},
					{"name":"doc_tparc", "value":"1", "type":"integer"},
					{"name":"doc_json_parcial", "value":"NULL", "type":"other"},
					{"name":"doc_obs", "value":"BOLETO ÚNICO INTEGRADO", "type":"string"},
					{"name":"cad_codigo", "value":"'.$cad.'", "type":"string"},
					{"name":"ser_codigo", "value":"1", "type":"string"},
					{"name":"ccu_codigo","value":"NULL","type":"other"},
					{"name":"doc_cod_pai", "value":"NULL", "type":"other"},
					{"name":"plc_codigo", "value":"NULL", "type":"other"},
					{"name":"cad_codatend", "value":"NULL", "type":"other"},';
				$filtroParc.= ( isset($carteira) && $carteira!="" ) ? '{"name":"doc_carteira", "value":"'.$carteira.'", "type":"string"},' : '{"name":"doc_carteira", "value":"NULL", "type":"other"},';
				$filtroParc.= '{"name":"doc_nossonumero", "value":"NULL", "type":"other"},
					{"name":"svc_codigo", "value":"NULL", "type":"other"},
					{"name":"doc_sacador", "value":"NULL", "type":"other"}
				]}';
				
				$datapacket->add($filtroParc);
				$datapacket->open();
				$datapacket->clear();
				
				$filtro  = '{"cod":"500488", "params":[
					{"name":"doc_codigo", "value":"'.substr($codigos, 0, -2).'", "type":"other"},
					{"name":"doc_codigo_pai", "value":"'.$cod.'", "type":"string"}
				]}';
				$datapacket->add($filtro);
				$datapacket->open();
				$datapacket->clear();
				
				$valor=0;
				$codigos="";
				$cont=0;

			}else{
			
				$codigos = "'".$bol["doc_codigo"]."', ";
				$valor=$bol["doc_valor"];
				$vcto = $bol["doc_dtvcto"];
				$multa = $bol["doc_multa"];
				$juros = $bol["doc_juros"];
				$prev = $bol["doc_dias_envio"];
				$cad = $bol["cad_codigo"];
				$carteira = $bol["doc_carteira"];
				
			}
			
		}
		
		$datapacket->clear();
		
		//selecionar boletos marcados para envio automático cujos dias antecedentes para envio coincida com a diferença entre o vencimento e a data atual
		$filtro = '{"cod":"500484","params":[
			{"name":"emp_db_sge","value":"'.$num.'","type":"string"},
			{"name":"dbcomum","value":"'.$comum.'","type":"other"}
		]}';
		$datapacket->add($filtro);
		$res = $datapacket->open();
		
		$ant = "";
		
		//percorre boletos selecionados e monta array com: boleto, e-mail para envio e codigo da empresa
		foreach($res as $r){
			if($ant!=$r["emp_codigo"]){
				$doctos[$r["emp_codigo"]] = array();
				$ant = $r["emp_codigo"];
			}
			$emails[$r["emp_codigo"]][$r["doc_codigo"]]=$r["email"];
			array_push($doctos[$r["emp_codigo"]], $r["doc_codigo"]);
		}

	}
	
	// print_r($doctos);
	
	
	//percorre todos os boletos selecionados, gera e faz o envio por e-mail
	foreach($doctos as $emp=>$docto){
		
		$p = base64_encode($emp);
		$p = substr($p, 0, 1)."2".substr($p, 1);
			
		foreach($docto as $doc){			
			$fields = array(
				'p' => $p,
				'email' => json_encode($emails[$emp][$doc]),
				'doc_codigo' => urlencode($doc)
			);

			//url-ify os dados para o POST
			$fields_string="";
			foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
			rtrim($fields_string, '&');

			//abrir conexao
			$ch = curl_init();

			//define url, numero de variaveis POST e dados POST
			curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/rel/relboleto.php");
			curl_setopt($ch,CURLOPT_POST, count($fields));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

			//executa POST
			$result = curl_exec($ch);

			//fechar conexao
			curl_close($ch);
			
		}
		
	}
	

?>
