<?php

	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');

	require_once 'TParams.class.php';
	include '../class/importarXml.php';

	$TParams = new TParams();
	$company = $TParams->getCompany();	

	if(isset($_FILES) && isset($_FILES['fileXml'])){
		//NF-e Saída
		if( isset($_POST["tipo"]) && $_POST["tipo"]=="saida" ){
			
			$importarXml = new importarXml("saida");
			$tot = count($_FILES['fileXml']["name"]);
			$numeros = array();
			$modelo = "";
			$certo = 0;
			$errado = 0;
			$erro="";
			
			//percorre arquivos XML
			for($i=0;$i<$tot;$i++){
				if($_FILES['fileXml']["type"][$i]=="text/xml" || $_FILES['fileXml']["type"][$i]=="application/octet-stream"){
					
					$arquivoXml = $_FILES['fileXml']["name"][$i];
					$ambiente = ($company->{"emp_amb_nfe"}==1) ? "producao" : "homologacao";
					if(!is_dir($TParams->uploads.$company->{'emp_codigo'})){
						@mkdir($TParams->uploads.$company->{'emp_codigo'}, 0777, true);
					}
					if(!is_dir($TParams->uploads.$company->{'emp_codigo'}."/nfe")){
						@mkdir($TParams->uploads.$company->{'emp_codigo'}."/nfe", 0777, true);
					}
					if(!is_dir($TParams->uploads.$company->{'emp_codigo'}."/nfe/".$ambiente)){
						@mkdir($TParams->uploads.$company->{'emp_codigo'}."/nfe/".$ambiente, 0777, true);
					}
					if(!is_dir($TParams->uploads.$company->{'emp_codigo'}."/nfe/".$ambiente."/autorizadas/")){
						@mkdir($TParams->uploads.$company->{'emp_codigo'}."/nfe/".$ambiente."/autorizadas/", 0777, true);
					}
					$uploadDir = $TParams->uploads.$company->{'emp_codigo'}."/nfe/".$ambiente."/autorizadas/";

					move_uploaded_file($_FILES['fileXml']['tmp_name'][$i], $uploadDir.$arquivoXml);

					$arquivoXmlPath = $uploadDir.$arquivoXml;

					$xml = simplexml_load_file($arquivoXmlPath);

					if( isset($xml->{'NFe'}) && isset($xml->{'NFe'}->{'infNFe'}->{'ide'}->{'mod'}) && ($xml->{'NFe'}->{'infNFe'}->{'ide'}->{'mod'}==55 || $xml->{'NFe'}->{'infNFe'}->{'ide'}->{'mod'}==65) ){
						//verifica CNPJ da empresa
						if(isset($xml->{'NFe'}->{'infNFe'}->{'emit'}->{'CNPJ'}) && $xml->{'NFe'}->{'infNFe'}->{'emit'}->{'CNPJ'}==$company->{'emp_cpfcnpj'} ){
							
							if(isset($xml->{'protNFe'}) && isset($xml->{'protNFe'}->{'infProt'}->{'cStat'}) && (int)$xml->{'protNFe'}->{'infProt'}->{'cStat'}==100){
								
								$not_numero = (int)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'nNF'};
								array_push($numeros, $not_numero);
								$modelo = (int)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'mod'};
								$ser_codigo = (int)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'serie'};
								$not_entrsaida = ((int)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'tpNF'}+1);
								//verifica se ja existe numero, modelo e serie cadastrado no sistema
								$checkNota = $importarXml->checkNota($not_numero, $modelo, $ser_codigo);
								
								if($checkNota==false){
								
									$cad_cnpjcpf = ( $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'CPF'} ) ? (string)$xml->{'NFe'}->{'infNFe'}->{'dest'}->{'CPF'} : (string)$xml->{'NFe'}->{'infNFe'}->{'dest'}->{'CNPJ'};
									$checkPessoa = $importarXml->checkPessoa($cad_cnpjcpf);
									
									//cadastro do cliente
									if($checkPessoa!=false){
										$cad_codigo = $checkPessoa;
									}else{
										$cad_codigo = substr(str_replace(array(","," ","."),array("","",""),microtime()), -16);
										$cad_nomeraz = $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'xNome'};
										$cad_inscrg = ( $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'IE'} ) ? (string)$xml->{'NFe'}->{'infNFe'}->{'dest'}->{'IE'} : "isento";
										$cad_codmun = $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'enderDest'}->{'cMun'};
										$cad_cidade = $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'enderDest'}->{'xMun'};
										$cad_uf = $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'enderDest'}->{'UF'};
										$end_nome = $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'enderDest'}->{'xLgr'};
										$end_compl = (isset($xml->{'NFe'}->{'infNFe'}->{'dest'}->{'enderDest'}->{'xCpl'})) ? $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'enderDest'}->{'xCpl'} : "";
										$end_bairro = $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'enderDest'}->{'xBairro'};
										$end_cep = $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'enderDest'}->{'CEP'};
										$end_num = $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'enderDest'}->{'nro'};
										$eml_ender = (isset($xml->{'NFe'}->{'infNFe'}->{'dest'}->{'email'})) ? $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'email'} : "";
										$tel_fone = (isset($xml->{'NFe'}->{'infNFe'}->{'dest'}->{'enderDest'}->{'fone'})) ? $xml->{'NFe'}->{'infNFe'}->{'dest'}->{'enderDest'}->{'fone'} : "";
										$importarXml->cadastraPessoa($cad_codigo, $cad_cnpjcpf, $cad_nomeraz, $cad_inscrg, $cad_codmun, $cad_cidade, $cad_uf);
										$importarXml->cadastraEndereco($cad_codigo, $end_nome, $end_compl, $end_bairro, $cad_cidade, $cad_uf, $end_cep, $end_num);
										$importarXml->cadastraEmail($cad_codigo, $eml_ender);
										$importarXml->cadastraTelefone($cad_codigo, $tel_fone);
									}
									//cadastro da nota
									$not_tipo = ((int)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'mod'}==55) ? 9 : 12;
									$not_data = str_replace("T", " ", substr((string)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'dhEmi'},0,19));
									$not_totalnota = (float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vNF'};
									$not_valordesc = (float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vDesc'};
									$not_percdesc = ($not_valordesc>0) ? ($not_valordesc*100/$not_totalnota) : 0;
									$not_totalprod = $not_totalnota + $not_valordesc;
									$not_totbaseicms = (float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vBC'};
									$not_toticms = (float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vICMS'};
									$not_totbaseipi = ((float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vIPI'}>0) ? (float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vBC'} : 0;
									$not_totipi = ((float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vIPI'}>0) ? (float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vIPI'} : 0;
									$cfo_codigo = (string) $xml->{'NFe'}->{'infNFe'}->{'det'}[0]->{'prod'}->{'CFOP'};
									$not_frete = (float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vFrete'};
									$not_seguro = (float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vSeg'};
									$not_despesa = (float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vOutro'};
									$not_tpfrete = ((float)$xml->{'NFe'}->{'infNFe'}->{'transp'}->{'modFrete'}+1);
									$not_toticmssubst = (float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vST'};
									$not_obs1 = (string)$xml->{'NFe'}->{'infNFe'}->{'infAdic'}->{'infCpl'};
									$not_qtde = (isset($xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}) && isset($xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}->{'qVol'})) ? (float)$xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}->{'qVol'} : 0;
									$not_especie = (isset($xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}) && isset($xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}->{'esp'})) ? (string)$xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}->{'esp'} : "";
									$not_marca = (isset($xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}) && isset($xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}->{'marca'})) ? (string)$xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}->{'marca'} : "";
									$not_nro = (isset($xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}) && isset($xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}->{'nVol'})) ? (string)$xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}->{'nVol'} : "";
									$not_pesobruto = (isset($xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}) && isset($xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}->{'pesoB'})) ? (float)$xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}->{'pesoB'} : 0;
									$not_pesoliquido = (isset($xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}) && isset($xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}->{'pesoL'})) ? (float)$xml->{'NFe'}->{'infNFe'}->{'transp'}->{'vol'}->{'pesoL'} : 0;
									$not_totbaseicmsst = ((float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vBCST'}>0) ? (float)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vBCST'} : 0;
									$not_key_nfe = (isset($xml->{'protNFe'}) && isset($xml->{'protNFe'}->{'infProt'}->{'chNFe'})) ? (string)$xml->{'protNFe'}->{'infProt'}->{'chNFe'} : "";
									$not_cstat = (isset($xml->{'protNFe'}) && isset($xml->{'protNFe'}->{'infProt'}->{'cStat'})) ? (string)$xml->{'protNFe'}->{'infProt'}->{'cStat'} : "";
									$not_xmotivo = (isset($xml->{'protNFe'}) && isset($xml->{'protNFe'}->{'infProt'}->{'xMotivo'})) ? (string)$xml->{'protNFe'}->{'infProt'}->{'xMotivo'} : "";
									$not_nprot = (isset($xml->{'protNFe'}) && isset($xml->{'protNFe'}->{'infProt'}->{'nProt'})) ? (string)$xml->{'protNFe'}->{'infProt'}->{'nProt'} : "";
									$not_inf_fisco =  (string)$xml->{'NFe'}->{'infNFe'}->{'infAdic'}->{'infAdFisco'};
									$not_nferef = "";
									$conta=0;
									if( isset($xml->{'NFe'}->{'infNFe'}->{'ide'}->{'NFref'}) ){
										$not_nferef = "{";
										foreach($xml->{'NFe'}->{'infNFe'}->{'ide'}->{'NFref'} as $ref){
											$not_nferef.= '"'.$conta.'":"'.$ref->{'refNFe'}.'"';
											$conta++;
										}
										$not_nferef .= "}";
									}
									$not_codigo = $importarXml->cadastraNota($not_numero, $ser_codigo, $cad_codigo, $not_tipo, $not_data, $not_percdesc, $not_valordesc, $not_totalnota, $not_totalprod, $not_entrsaida, $not_totbaseicms, $not_toticms, $not_totbaseipi, $not_totipi, $cfo_codigo, $not_frete, $not_seguro, $not_despesa, $not_tpfrete, $not_toticmssubst, $not_obs1, $not_qtde, $not_especie, $not_marca, $not_nro, $not_pesobruto, $not_pesoliquido, $not_totbaseicmsst, $not_key_nfe, $not_cstat, $not_xmotivo, $not_nprot, $not_inf_fisco, $not_nferef);
									
									//parcelas
									if( isset($xml->{'NFe'}->{'infNFe'}->{'cobr'}) && $_POST["parcelas"]=='sim' ){
										$doc_codigo  = substr(str_replace(array(","," ","."),array("","",""),microtime()), -10).mt_rand(1000,9999);
										for($parc=0; $parc <count($xml->{'NFe'}->{'infNFe'}->{'cobr'}->{'dup'}); $parc++){
											$doc_codigo+=$parc;
											$doc_numero = "NFE".$not_numero."-".($parc+1);
											$doc_valor = $xml->{'NFe'}->{'infNFe'}->{'cobr'}->{'dup'}[$parc]->{'vDup'};
											$doc_dtvcto = $xml->{'NFe'}->{'infNFe'}->{'cobr'}->{'dup'}[$parc]->{'dVenc'};
											$doc_nparc = $parc+1;
											$doc_tparc = count($xml->{'NFe'}->{'infNFe'}->{'cobr'}->{'dup'});
											$importarXml->cadastraDocto($doc_codigo, $doc_numero, $doc_valor, $doc_dtvcto, $doc_nparc, $doc_tparc, $cad_codigo, $ser_codigo, $not_codigo, $not_numero);
										}
									}
									
									//percorre itens da nota
									for($i2=0;$i2<count($xml->{'NFe'}->{'infNFe'}->{'det'});$i2++){
										$objItn = $xml->{'NFe'}->{'infNFe'}->{'det'}[$i2];

										$checkProd = $importarXml->checkProd((string)$objItn->{'prod'}->{'cProd'}, $_POST["ref_id"]);
										
										$ref_codbar = (isset($objItn->{'prod'}->{'cEAN'})) ? (string)$objItn->{'prod'}->{'cEAN'} : "";
										$ref_descr = (string)$objItn->{'prod'}->{'xProd'};
										$ref_status = ($_POST["inativos"]=='sim') ? 1 : 0;
										$ref_preco = (float)$objItn->{'prod'}->{'vProd'};
										$itn_valor = (float)$objItn->{'prod'}->{'vUnCom'};
										$uni_codigo = str_replace(".", "", (string)$objItn->{'prod'}->{'uCom'});
										$ref_ncm = (string)$objItn->{'prod'}->{'NCM'};
										$cfo_codigo = (string)$objItn->{'prod'}->{'CFOP'};
										$ref_cest = (isset($objItn->{'prod'}->{'CEST'})) ? (string)$objItn->{'prod'}->{'CEST'} : "0000000";
											
										//cadastro de produto
										if($checkProd!=false){
											$ref_codigo = $checkProd;
										}else{
											if($_POST["ref_id"]==1){
												$ref_codigo = (string)$objItn->{'prod'}->{'cProd'};
												$ref_propriedade="";
											}else{
												$ref_codigo = "";
												$ref_propriedade=(string)$objItn->{'prod'}->{'cProd'};
											}
											$ref_codigo = $importarXml->cadastraProduto($ref_codigo, $ref_codbar, $ref_descr, $ref_status, $ref_preco, $uni_codigo, $ref_ncm, $ref_propriedade, $ref_cest);
										}
										
										//cadastro de itens da nota
										$arrayICMS = (array) $objItn->{'imposto'}->{'ICMS'};
										$arrayICMS = array_values($arrayICMS);
										$arrayIPI = (array) $objItn->{'imposto'}->{'IPI'};
										$arrayIPI = array_values($arrayIPI);
										$arrayPIS = (array) $objItn->{'imposto'}->{'PIS'};
										$arrayPIS = array_values($arrayPIS);
										$arrayCOFINS = (array) $objItn->{'imposto'}->{'COFINS'};
										$arrayCOFINS = array_values($arrayCOFINS);
										
										$itn_descr = (string)$objItn->{'prod'}->{'xProd'};
										$itn_qtde = (float)$objItn->{'prod'}->{'qCom'};
										$itn_valordesc = (float)$objItn->{'prod'}->{'vDesc'};
										$itn_subtotal = ($itn_qtde * ($itn_valor-$itn_valordesc));
										$itn_baseicms = (isset($arrayICMS[0]->{'vBC'})) ? (float)$arrayICMS[0]->{'vBC'} : 0;
										$itn_icms = (isset($arrayICMS[0]->{'vICMS'})) ? (float)$arrayICMS[0]->{'vICMS'} : 0;
										$itn_aliqicms = (isset($arrayICMS[0]->{'pICMS'})) ? (float)$arrayICMS[0]->{'pICMS'} : 0;
										$itn_baseipi = (isset($arrayIPI[1]->{'vBC'})) ? (float)$arrayIPI[1]->{'vBC'} : 0;
										$itn_ipi = (isset($arrayIPI[1]->{'vIPI'})) ? (float)$arrayIPI[1]->{'vIPI'} : 0;
										$itn_aliqipi = (isset($arrayIPI[1]->{'pIPI'})) ? (float)$arrayIPI[1]->{'pIPI'} : 0;
										$itn_baseicmsst = (isset($arrayICMS[0]->{'vBCST'})) ? (float)$arrayICMS[0]->{'vBCST'} : 0;
										$itn_icmssubst = (isset($arrayICMS[0]->{'vICMSST'})) ? (float)$arrayICMS[0]->{'vICMSST'} : 0;
										
										$tri_cenq = (isset($arrayIPI[0])) ? (string)$arrayIPI[0] : '';
										$tri_redbaseicms = (isset($arrayICMS[0]->{'pRedBC'})) ? (float)$arrayICMS[0]->{'pRedBC'} : 0;
										$tri_redbaseipi = (isset($arrayIPI[1]->{'pRedBC'})) ? (float)$arrayIPI[1]->{'pRedBC'} : 0;
										$tri_aliq_icms_st = (isset($arrayICMS[0]->{'pICMSST'})) ? (float)$arrayICMS[0]->{'pICMSST'} : 0;
										$tri_sit_ipi = (isset($arrayIPI[1]->{'CST'})) ? (string)$arrayIPI[1]->{'CST'} : 0;
										$tri_mva_st = (isset($arrayICMS[0]->{'pMVAST'})) ? (float)$arrayICMS[0]->{'pMVAST'} : 0;
										$tri_situacao = (isset($arrayICMS[0]->{'CST'})) ? (string)$arrayICMS[0]->{'CST'} : '';
										$tri_csosn = (isset($arrayICMS[0]->{'CSOSN'})) ? (string)$arrayICMS[0]->{'CSOSN'} : '';
										$tri_sit_pis = (isset($arrayPIS[0]->{'CST'})) ? (string)$arrayPIS[0]->{'CST'} : '';
										$tri_basepis = (isset($arrayPIS[0]->{'vBC'})) ? (float)$arrayPIS[0]->{'vBC'} : '';
										$tri_aliqpis = (isset($arrayPIS[0]->{'pPIS'})) ? (float)$arrayPIS[0]->{'pPIS'} : '';
										$tri_pis = (isset($arrayPIS[0]->{'vPIS'})) ? (float)$arrayPIS[0]->{'vPIS'} : '';
										$tri_sit_cofins = (isset($arrayCOFINS[0]->{'CST'})) ? (string)$arrayCOFINS[0]->{'CST'} : '';
										$tri_basecofins = (isset($arrayCOFINS[0]->{'vBC'})) ? (float)$arrayCOFINS[0]->{'vBC'} : '';
										$tri_aliqcofins = (isset($arrayCOFINS[0]->{'pCOFINS'})) ? (float)$arrayCOFINS[0]->{'pCOFINS'} : '';
										$tri_cofins = (isset($arrayCOFINS[0]->{'vCOFINS'})) ? (float)$arrayCOFINS[0]->{'vCOFINS'} : '';
										$tri_origem = (isset($arrayICMS[0]->{'orig'})) ? (string)$arrayICMS[0]->{'orig'} : '';
										$itn_tribjson = '{
											"metadata":[],
											"rowdata":[
												{
													"ref_codigo":"'.$ref_codigo.'",
													"ref_tipo":0,
													"ref_preco":'.$itn_valor.',
													"ref_cfop":"'.$cfo_codigo.'",
													"tri_codigo":"1",
													"tri_aliqipi":'.$itn_aliqipi.',
													"tri_aliqicms":'.$itn_aliqicms.',
													"tri_redbaseicms":'.$tri_redbaseicms.',
													"tri_redbaseipi":'.$tri_redbaseipi.',
													"tri_aliq_icms_st":'.$tri_aliq_icms_st.',
													"tri_sit_ipi":"'.$tri_sit_ipi.'",
													"tri_mva_st":'.$tri_mva_st.',
													"tri_situacao":"'.$tri_situacao.'",
													"tri_csosn":"'.$tri_csosn.'",
													"tri_sit_pis":"'.$tri_sit_pis.'",
													"tri_basepis":"'.$tri_basepis.'",
													"tri_aliqpis":"'.$tri_aliqpis.'",
													"tri_pis":"'.$tri_pis.'",
													"tri_sit_cofins":"'.$tri_sit_cofins.'",
													"tri_basecofins":"'.$tri_basecofins.'",
													"tri_aliqcofins":"'.$tri_aliqcofins.'",
													"tri_cofins":"'.$tri_cofins.'",
													"ncm_valor":"0",
													"tri_origem":"'.$tri_origem.'",
													"ref_cest":"'.$ref_cest.'",
													"tri_cenq":"'.$tri_cenq.'"
												}
											]
										}';
										
										$importarXml->cadastraItem($not_codigo, $ref_codigo, ($i2+1), $itn_descr, $itn_qtde, $itn_valordesc, $itn_valor, $itn_subtotal, $itn_baseicms, $itn_icms, $itn_aliqicms, $itn_baseipi, $itn_ipi, $itn_aliqipi, $itn_baseicmsst, $itn_icmssubst, $itn_tribjson, $ref_ncm, $ref_codbar, $uni_codigo);
									}
									
									$anomes = str_replace("-", "", substr($xml->{'NFe'}->{'infNFe'}->{'ide'}->{'dhEmi'}, 0, 7));
									if(!is_dir($TParams->uploads.$company->{'emp_codigo'}."/nfe/".$ambiente."/autorizadas/".$anomes)){
										@mkdir($TParams->uploads.$company->{'emp_codigo'}."/nfe/".$ambiente."/autorizadas/".$anomes, 0777, true);
									}
									copy( $uploadDir.$arquivoXml, $TParams->uploads.$company->{'emp_codigo'}."/nfe/".$ambiente."/autorizadas/".$anomes."/".$not_key_nfe."-nfe.xml" );
									chmod($TParams->uploads.$company->{'emp_codigo'}."/nfe/".$ambiente."/autorizadas/".$anomes."/".$not_key_nfe."-nfe.xml", 0777);
									$certo++;
									
								}else{
									$errado++;
									$erro = "NF-e já está cadastrada no Sistema";
								}
								
							}else{
								$errado++;
								$erro = "XML não é de uma NF-e Autorizada (cStat=100)";
							}
							
						}else{
							$errado++;
							$erro = "CNPJ do emitente da NF-e difere do CNPJ cadastrado no sistema!";
						}
					}else{
						$errado++;
						$erro = "Arquivo, não é um XML válido de uma NF-e";
					}
					
					unlink($uploadDir.$arquivoXml);
				
				}else{
					$errado++;
					$erro = "Arquivo não possui extensão válida para a importação";
				}
			}
			
			$objReturn = new StdCLass();
			$objReturn->success=true;
			$objReturn->data= $numeros;
			$objReturn->modelo=$modelo;
			$objReturn->tipo=$not_entrsaida;
			$objReturn->certo=$certo;
			$objReturn->errado=$errado;
			$objReturn->erro=$erro;
			
			echo json_encode($objReturn);
			exit();
			
		//NF Entrada
		}else{
			
			$importarXml = new importarXml("entrada");
			$file = json_encode($_FILES);
			$file = json_decode($file);
			$arquivoXml = $file->{'fileXml'}->{'name'};
			
			if($file->{'fileXml'}->{'type'}=='text/xml' || $file->{'fileXml'}->{'type'}=='application/octet-stream'){

				if(!is_dir($TParams->uploads.$company->{'emp_codigo'})){
					@mkdir($TParams->uploads.$company->{'emp_codigo'},0777);
				}

				if(!is_dir($TParams->uploads.$company->{'emp_codigo'}."/nfe")){
					@mkdir($TParams->uploads.$company->{'emp_codigo'}."/nfe",0777);
				}

				if(!is_dir($TParams->uploads.$company->{'emp_codigo'}."/nfe/importados")){
					@mkdir($TParams->uploads.$company->{'emp_codigo'}."/nfe/importados",0777);
				}

				$uploadDir = $TParams->uploads.$company->{'emp_codigo'}."/nfe/importados/";

				move_uploaded_file($_FILES['fileXml']['tmp_name'], $uploadDir.$arquivoXml);

				$arquivoXmlPath = $uploadDir.$arquivoXml;

				$xml = simplexml_load_file($arquivoXmlPath);

				$nota = Array();
				
				$checkPessoa = $importarXml->checkPessoa((string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'xNome'});
				if($checkPessoa!=false){
					$cad_codigo = $checkPessoa;
				}else{
					$cad_codigo = null;
				}

				for($i=0;$i<count($xml->{'NFe'}->{'infNFe'}->{'det'});$i++){
					
					$objNota = new StdClass();
					

					$serie = $xml->{'NFe'}->{'infNFe'}->{'ide'}->{'serie'};
					$objNota->{'not_codigo'}=str_replace(array(" ","."),"",(string)microtime(false));
					$objNota->{'not_numero'}=(string)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'nNF'};
					$objNota->{'ser_codigo'}=(string)$serie;
					$objNota->{'cad_codigo'}=$cad_codigo;
					$objNota->{'cad_codvend'}="";
					$objNota->{'not_tipo'}="9";
					$objNota->{'crt'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'CRT'};
					$objNota->{'not_cancelada'}="0";
					$objNota->{'not_dtcancdesc'}=null;
					$objNota->{'not_data'}=str_replace(array("T")," ",substr((string)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'dhEmi'},0,19));
					$objNota->{'not_dtemissao'}=str_replace(array("T")," ",substr((string)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'dhEmi'},0,19));
					$objNota->{'not_dtfaturam'}=str_replace(array("T")," ",substr((string)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'dhEmi'},0,19));
					$objNota->{'not_dtprevisao'}=str_replace(array("T")," ",substr((string)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'dhSaiEnt'},0,19));
					$objNota->{'not_dtentrega'}=str_replace(array("T")," ",substr((string)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'dhSaiEnt'},0,19));
					$objNota->{'not_finanatualiz'}="0";
					$objNota->{'not_stokatualiz'}="0";
					$objNota->{'not_custoautaliz'}="0";
					$objNota->{'not_percdesc'}="0";
					$objNota->{'not_valordesc'}=(string)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vDesc'};
					$objNota->{'not_totalnota'}=(string)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vNF'};
					$objNota->{'not_totalprod'}=(string)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vProd'};
					$objNota->{'not_totalserv'}="0";
					$objNota->{'not_entrsaida'}="1";
					$objNota->{'not_totbaseicms'}=(string)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vBC'};
					$objNota->{'not_toticms'}=(string)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vICMS'};
					$objNota->{'not_totbaseipi'}=(string)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vBC'};
					$objNota->{'not_totipi'}=(string)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vIPI'};
					$objNota->{'cdp_codigo'}=null;
					$objNota->{'pdv_codigo'}=null;
					$objNota->{'ccu_codigo'}=null;
					$objNota->{'tbp_codigo'}=null;
					$objNota->{'not_codigo_pai'}=null;
					$objNota->{'not_codigo_filho'}=null;
					$objNota->{'cad_codtransp'}=null;
					$objNota->{'not_frete'}=(string)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vFrete'};
					$objNota->{'not_seguro'}=(string)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vSeg'};
					$objNota->{'not_despesa'}=(string)$xml->{'NFe'}->{'infNFe'}->{'total'}->{'ICMSTot'}->{'vOutro'};
					if($xml->{'NFe'}->{'infNFe'}->{'det'}['transp']){
						$objNota->{'not_tpfrete'}=(string)$xml->{'NFe'}->{'infNFe'}->{'det'}['transp']->{'modFrete'};
					}else{
						$objNota->{'not_tpfrete'}="1";
					}
					$objNota->{'not_toticmssubst'}="0.00";
					if($xml->{'NFe'}->{'infNFe'}->{'infAdic'}->{'infCpl'}){
						$objNota->{'not_obs1'}= base64_encode((string)$xml->{'NFe'}->{'infNFe'}->{'infAdic'}->{'infCpl'});
					}else{
						$objNota->{'not_obs1'}='';
					}
					$objNota->{'not_obs2'}='';
					$objNota->{'not_obs3'}='';
					$objNota->{'not_obs4'}='';
					$objNota->{'not_devolucao'}='0.00';
					$objNota->{'not_hhmmss'}="0.00";
					$objNota->{'not_qtde'}=(string)count($xml->{'NFe'}->{'infNFe'}->{'det'});
					$objNota->{'not_especie'}=(string)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'tpNF'};
					$objNota->{'not_marca'}='';
					// $objNota->{'not_nro'}=(string)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'cNF'};
					if($xml->{'NFe'}->{'infNFe'}->{'det'}['transp']){
						$objNota->{'not_pesobruto'}=(string)$xml->{'NFe'}->{'infNFe'}->{'det'}['transp']->{'veicTransp'}->{'pesoB'};
					}else{
						$objNota->{'not_pesobruto'}="0";
					}
					if($xml->{'NFe'}->{'infNFe'}->{'det'}['transp']){
						$objNota->{'not_pesoliquido'}=(string)$xml->{'NFe'}->{'infNFe'}->{'det'}['transp']->{'veicTransp'}->{'pesoL'};
					}else{
						$objNota->{'not_pesoliquido'}="0";
					}
					
					$objNota->{'not_cadinscrito'}="0";
					
					$objNota->{'not_transportadora'}="";
					if($xml->{'NFe'}->{'infNFe'}->{'det'}['transp']){
						$objNota->{'not_placa'}=(string)$xml->{'NFe'}->{'infNFe'}->{'det'}['transp']->{'veicTransp'}->{'placa'};
					}
					$objNota->{'not_totbaseicmsst'}="0.00";
					$objNota->{'not_totiss'}="";
					$objNota->{'cad_atendente'}=null;
					
					if($xml->{'protNFe'}->{'infProt'}){
						$chNFe = (string)$xml->{'protNFe'}->{'infProt'}->{'chNFe'};
						$cStat = (string)$xml->{'protNFe'}->{'infProt'}->{'cStat'};
						$xMotivo = (string)$xml->{'protNFe'}->{'infProt'}->{'xMotivo'};
						$nProt = (string)$xml->{'protNFe'}->{'infProt'}->{'nProt'};
					}else{
						$chNFe = "";
						$cStat = "";
						$xMotivo = "";
						$nProt = "";
					}

					$objNota->{'not_key_nfe'}=(string)$chNFe;
					$objNota->{'not_cdp_desc'}='0';
					$objNota->{'not_cobranca'}="W10=";
					$objNota->{'not_entrada'}="0.00";
					$objNota->{'not_status'}="0";
					$objNota->{'not_tpprc'}=null;
					$objNota->{'not_nrodeposito'}=null;
					$objNota->{'not_codrastream'}=null;
					$objNota->{'cta_codigo'}=null;
					$objNota->{'not_result'}="0";
					$objNota->{'not_cstat'}=$cStat;
					$objNota->{'not_xmotivo'}=$xMotivo;
					$objNota->{'not_nrec'}="";
					$objNota->{'not_nprot'}=$nProt;
					$objNota->{'not_tpemis'}=(string)$xml->{'NFe'}->{'infNFe'}->{'ide'}->{'finNFe'};
					$objNota->{'not_aliq'}="12";
					$objNota->{'not_entrnfe'}="0";
					$objNota->{'not_mapa'}="0";
					$objNota->{'not_lote_ccev'}=null;
					$objNota->{'loc_codigo'}="99999";
					$objNota->{'not_cod_mesa'}=null;
					$objNota->{'not_sta_mesa'}=null;
					$objNota->{'not_aliqcredicms'}=null;
					if($xml->{'NFe'}->{'infNFe'}->{'infAdic'}->{'infAdFisco'}){
						$objNota->{'not_inf_fisco'}= base64_encode((string)$xml->{'NFe'}->{'infNFe'}->{'infAdic'}->{'infAdFisco'});
					}else{
						$objNota->{'not_inf_fisco'}='';
					}
					$objNota->{'lic_codigo'}=null;
					$objNota->{'not_nferef'}=null;
					$objNota->{'not_auxiliar'}=null;
					$objNota->{'not_anexo'}=null;
					$objNota->{'pdv_chave'}=null;
					$objNota->{'not_cpf'}=null;
					
					// parcelas
					$objParc = $xml->{'NFe'}->{'infNFe'}->{'cobr'};
					$objNota->{'parcelas'} = array();
					for( $z=0; $z<count($objParc->{'dup'}); $z++ ){
						$objNota->{'parcelas'}[$z] = new stdClass();
						$objNota->{'parcelas'}[$z]->{"doc_numero"} = str_replace("/", "-", (string)$objParc->{'dup'}[$z]->{'nDup'});
						$objNota->{'parcelas'}[$z]->{"doc_dtvcto"} = (string)$objParc->{'dup'}[$z]->{'dVenc'};
						$objNota->{'parcelas'}[$z]->{"doc_valor"} = (string)$objParc->{'dup'}[$z]->{'vDup'};
					}
					
					// itens
					$objItn = $xml->{'NFe'}->{'infNFe'}->{'det'}[$i];

					$checkProd = $importarXml->checkProd((string)$objItn->{'prod'}->{'cProd'});
					if($checkProd!=false){
						$ref_codigo = $checkProd;
					}else{
						$ref_codigo = null;
					}

					$objNota->{'ref_codigo'}=$ref_codigo;
					$objNota->{'itn_descr'}=(string)$objItn->{'prod'}->{'xProd'};
					$objNota->{'itn_qtde'}=(string)$objItn->{'prod'}->{'qCom'};
					$objNota->{'itn_doacao'}="0";
					$objNota->{'itn_valordesc'}="0";
					
					$arrayICMS = (array)$objItn->{'imposto'}->{'ICMS'};

					foreach($arrayICMS as $key => $value){

						if(strlen($key)==9){ //ICMSSN
							$tri_csosn=(string)$objItn->{'imposto'}->{'ICMS'}->{$key}->{'CSOSN'};
							$tri_situacao='';
						}else{ //CST
							$tri_situacao=(string)$objItn->{'imposto'}->{'ICMS'}->{$key}->{'CST'};
							$tri_csosn='';
						}

						if($objItn->{'imposto'}->{'ICMS'}->{$key}->{'vICMS'}){
							$objNota->{'itn_icms'}=(string)$objItn->{'imposto'}->{'ICMS'}->{$key}->{'vICMS'};
						}else{
							$objNota->{'itn_icms'}="0";
						}
						
						if($objItn->{'imposto'}->{'ICMS'}->{$key}->{'pICMS'}){
							$objNota->{'itn_aliqicms'}=(string)$objItn->{'imposto'}->{'ICMS'}->{$key}->{'pICMS'};
						}else{
							$objNota->{'itn_aliqicms'}="0";
						}
						
						if($objItn->{'imposto'}->{'IPI'}->{'IPITrib'}){
							$objNota->{'itn_ipi'}=(string)$objItn->{'imposto'}->{'IPI'}->{'IPITrib'}->{'vIPI'};
						}else{
							$objNota->{'itn_ipi'}=0;
						}
						
						if($objItn->{'imposto'}->{'IPI'}->{'IPITrib'}){
							$objNota->{'itn_aliqipi'}=(string)$objItn->{'imposto'}->{'IPI'}->{'IPITrib'}->{'pIPI'};
						}else{
							$objNota->{'itn_aliqipi'}=0;
						}
						
						if($objItn->{'imposto'}->{'ICMS'}->{$key}->{'vICMSST'}){
							$objNota->{'itn_icmssubst'}=(string)$objItn->{'imposto'}->{'ICMS'}->{$key}->{'vICMSST'};
						}else{
							$objNota->{'itn_icmssubst'}="0";
						}

						if($objItn->{'imposto'}->{'ICMS'}->{$key}->{'vBC'}){
							$objNota->{'itn_baseicms'}=(string)$objItn->{'imposto'}->{'ICMS'}->{$key}->{'vBC'};
						}else{
							$objNota->{'itn_baseicms'}="0";
						}

						if($objItn->{'imposto'}->{'ICMS'}->{$key}->{'vBC'}){
							$objNota->{'itn_baseipi'}=(string)$objItn->{'imposto'}->{'ICMS'}->{$key}->{'vBC'};
						}else{
							$objNota->{'itn_baseipi'}="0";
						}

						if($objItn->{'imposto'}->{'ICMS'}->{$key}->{'vBCST'}){
							$objNota->{'itn_baseicmsst'}=(string)$objItn->{'imposto'}->{'ICMS'}->{$key}->{'vBCST'};
						}else{
							$objNota->{'itn_baseicmsst'}="0";
						}
					}

					$objNota->{'itn_adicfin'}="0.00000";
					$objNota->{'itn_consumo'}="0";
					$objNota->{'itn_valor'}=(string)$objItn->{'prod'}->{'vUnCom'};				
					
					if($tri_situacao=="10"){
						//	vICMS / qCom + vUnCom
						$objNota->{'itn_custo'}=(string)$objItn->{'prod'}->{'vUnCom'}+($objNota->{'itn_icms'} / $objNota->{'itn_qtde'});
					}else{
						$objNota->{'itn_custo'}=(string)$objItn->{'prod'}->{'vUnCom'};				
					}
					
					$objNota->{'itn_custovenda'}=((string)$objItn->{'prod'}->{'vProd'}*$company->{'emp_overhead'})/100;
					
					$objNota->{'itn_subtotal'}=(string)$objItn->{'prod'}->{'vProd'};

					$objTribJson = new StdClass();

					$objTribJson->{"metadata"}=array();
					$objTribJson->{"rowdata"}=array();
					$objRowdata = new stdClass();

					$objRowdata->{'ref_tipo'}="0";
					$objRowdata->{'ref_preco'}=(string)$objItn->{'prod'}->{'vUnCom'};
					
					$cfopProd = (string)$objItn->{'prod'}->{'CFOP'};
					
					if(substr($cfopProd,0,1)=='5'){
						$cfopProd='1'.substr($cfopProd,1,3);
						if($cfopProd == '1405'){
							$cfopProd = '1403';
						}
					}
					if(substr($cfopProd,0,1)=='6'){
						$cfopProd='2'.substr($cfopProd,1,3);
					}
					
					$objNota->{'cfo_codigo'}=$cfopProd;
					$objRowdata->{'ref_cfop'}=$cfopProd;
					$objRowdata->{'tri_codigo'}="1";
					$objRowdata->{'tri_aliqipi'}="0";
					$objRowdata->{'tri_aliqicms'}=(string)$objItn->{'imposto'}->{'ICMS'}->{$key}->{'pICMS'};
					$objRowdata->{'tri_redbaseicms'}=(string)$objItn->{'imposto'}->{'ICMS'}->{$key}->{'vBC'};
					$objRowdata->{'tri_redbaseipi'}=(string)$objItn->{'imposto'}->{'ICMS'}->{$key}->{'vBC'};
					$objRowdata->{'tri_aliq_icms_st'}="0";
					$objRowdata->{'tri_sit_ipi'}="0";
					$objRowdata->{'tri_mva_st'}="0";
					$objRowdata->{'tri_sit_pis'}="07";
					$objRowdata->{'tri_basepis'}="0";
					$objRowdata->{'tri_aliqpis'}="0";
					$objRowdata->{'tri_pis'}="0";
					$objRowdata->{'tri_sit_cofins'}="07";
					$objRowdata->{'tri_basecofins'}="0";
					$objRowdata->{'tri_aliqcofins'}="0";
					$objRowdata->{'tri_cofins'}="0";
					$objRowdata->{'ncm_valor'}="0";
					if(isset($tri_csosn) && $tri_csosn!=""){
						$objRowdata->{'tri_csosn'}=$tri_csosn;
						$objRowdata->{'tri_situacao'}="";
					}else{
						$objRowdata->{'tri_situacao'}=$tri_situacao;
						$objRowdata->{'tri_csosn'}="";
					}
					
					array_push($objTribJson->{"rowdata"},$objRowdata);	
					
					$objNota->{'itn_tribjson'}=base64_encode(json_encode($objTribJson));
					$objNota->{'itn_obs'}="";
					if((string)$objItn->{'prod'}->{'vDesc'}>0){
						$objNota->{'itn_valordesc'}=(string)$objItn->{'prod'}->{'vDesc'}/(string)$objItn->{'prod'}->{'qCom'};
					}else{
						$objNota->{'itn_valordesc'}="0";
					}
					$objNota->{'itn_ncm'}=(string)$objItn->{'prod'}->{'NCM'};
					$objNota->{'itn_entregue'}="0.00000";
					$objNota->{'ref_codbar'}= ((string)$objItn->{'prod'}->{'cEAN'}!="") ? (string)$objItn->{'prod'}->{'cEAN'} : "";
					$objNota->{'uni_codigo'}=(string)$objItn->{'prod'}->{'uCom'};
					$objNota->{'itn_largura'}=null;
					$objNota->{'itn_altura'}=null;
					$objNota->{'itn_modelo'}=null;
					$objNota->{'itn_comando'}=null;
					$objNota->{'fml_codigo'}=null;
					$objNota->{'cdp_descr'}="";
					$objNota->{'cdp_json'}="W10=";
					$objNota->{'cdp_forma'}="";
					$objNota->{'cdp_indpag'}="1";
					$objNota->{'cdp_valmin'}="0.00";
					$objNota->{'cdp_valmax'}="0.00";
					
					$objNota->{'ref_codigo_forn'}=(string)$objItn->{'prod'}->{'cProd'};
					$objNota->{'ref_descr_forn'}=(string)$objItn->{'prod'}->{'xProd'};
					$objNota->{'cad_descr_forn'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'xNome'};
					$objNota->{'cad_forn_cnpj'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'CNPJ'};
					$objNota->{'cad_forn_fantasia'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'xFant'};
					$objNota->{'cad_forn_cep'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'enderEmit'}->{'CEP'};
					$objNota->{'cad_forn_end'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'enderEmit'}->{'xLgr'};
					$objNota->{'cad_forn_num'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'enderEmit'}->{'nro'};
					$objNota->{'cad_forn_compl'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'enderEmit'}->{'xCpl'};
					$objNota->{'cad_forn_bairro'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'enderEmit'}->{'xBairro'};
					$objNota->{'cad_forn_codmun'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'enderEmit'}->{'cMun'};
					$objNota->{'cad_forn_fone'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'enderEmit'}->{'fone'};
					$objNota->{'cad_forn_uf'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'enderEmit'}->{'UF'};
					$objNota->{'cad_forn_ie'}=(string)$xml->{'NFe'}->{'infNFe'}->{'emit'}->{'IE'};
					
					array_push($nota,$objNota);
				}
				
				$objReturn = new StdCLass();
				$objReturn->success=true;
				$objReturn->data=$nota;
				
				echo json_encode($objReturn);
			}else{
				
				exit("Extensão de arquivo inválida. Somente são aceitos arquivos XML.");
				
			}
			
			
		}
	}

	

?>