<?php

	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	
	include './TParams.class.php';
	include './funcoes.php';
	
	$datapacket = new TParams();
	$datapacket->debug(true);
	
	if(isset($_REQUEST["acao"]) && $_REQUEST["acao"] == "salvar") {

		if(isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {

			$dados = json_decode(base64_decode($_REQUEST['dados']));

			// lote
				$lot_codigo = substr(str_replace(array(","," ","."), array("","",""), microtime()), 0, 6);

				$lot_vencto = "";
				if(isset($dados->{"lot_vencto"}) && !empty($dados->{"lot_vencto"})) $lot_vencto = data($dados->{"lot_vencto"}, true, "/");
				
				$lot_descr = "";
				if(isset($dados->{"lot_descr"}) && !empty($dados->{"lot_descr"})) $lot_descr = $dados->{"lot_descr"};
				
				$ref_codigo = "";
				if(isset($dados->{"ref_codigo"}) && !empty($dados->{"ref_codigo"})) $ref_codigo = $dados->{"ref_codigo"};
				
				$filtro = '{"cod":"501281","params":[
					{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"string"},
					{"name":"lot_vencto","value":"'.$lot_vencto.'","type":"string"},
					{"name":"lot_descr","value":"'.$lot_descr.'","type":"string"},
					{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"}
				]}';
				$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
				$datapacket->add($filtro);
				$datapacket->open(true);
				$datapacket->clear();

			// insumo 
				if(isset($dados->{"ins_codigo"}) && !empty($dados->{"ins_codigo"})){
					$ins_codigo = $dados->{"ins_codigo"};
				}else{
					$ins_codigo = substr(str_replace(array(","," ","."), array("","",""), microtime()), 0, 10);
				}

				if(isset($dados->{"ins_numero"}) && !empty($dados->{"ins_numero"})) {					
					$ins_numero = $dados->{"ins_numero"};
				}else{
					$filtro = '{"cod":"501289","params":[]}';
					$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
					$datapacket->add($filtro);
					$retorno = $datapacket->open(true);
					$datapacket->clear();
					$ins_numero = $retorno[0]->{"ins_numero"};
				}

				$ins_data = date("Y-m-d H:i:s");
				if(isset($dados->{"ins_data"}) && !empty($dados->{"ins_data"})){
					$ins_data = implode("-", array_reverse(explode("/", substr($dados->{"ins_data"},0,10))));
				}

				$ref_descr = "";
				if(isset($dados->{"ref_descr"}) && !empty($dados->{"ref_descr"})) $ref_descr = $dados->{"ref_descr"};
				
				$ref_qtde = "";
				if(isset($dados->{"ref_qtde"}) && !empty($dados->{"ref_qtde"})) $ref_qtde = $dados->{"ref_qtde"};
				
				$ref_valor = "";
				if(isset($dados->{"ref_valor"}) && !empty($dados->{"ref_valor"})) $ref_valor = $dados->{"ref_valor"};
				
				$cad_codigo = "";
				if(isset($dados->{"cad_codigo"}) && !empty($dados->{"cad_codigo"})) $cad_codigo = $dados->{"cad_codigo"};

				$filtro = '{"cod":"501280","params":[
					{"name":"ins_codigo","value":"'.$ins_codigo.'","type":"string"},
					{"name":"ins_numero","value":"'.$ins_numero.'","type":"integer"},
					{"name":"ins_data","value":"'.$ins_data.'","type":"string"},
					{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"string"},
					{"name":"ref_descr","value":"'.$ref_descr.'","type":"string"},
					{"name":"ref_qtde","value":"'.$ref_qtde.'","type":"string"},
					{"name":"ref_valor","value":"'.$ref_valor.'","type":"string"},
					{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"string"},
					{"name":"lot_descr","value":"'.$lot_descr.'","type":"string"},
					{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"}
				]}';
				$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
				$datapacket->add($filtro);
				$datapacket->open(false, true);
				$datapacket->clear();
			
			// produto acabado
				$filtro = '{"cod":"700111","params":[
					{"name":"db","value":"'.$datapacket->getDb().'","type":"other"},
					{"name":"emp_codigo","value":"'.$datapacket->getCompany()->{"emp_codigo"}.'","type":"string"},
					{"name":"loc_codigo","value":"99999","type":"string"},
					{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"string"},
					{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
					{"name":"ser_codigo","value":"1","type":"string"},
					{"name":"stk_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"stk_seq","value":"'.substr(str_replace(array(","," ","."), array("","",""), microtime()), 0, 8).'","type":"integer"},
					{"name":"stk_qde","value":"'.$ref_qtde.'","type":"float"},
					{"name":"stk_tipo","value":"null","type":"other"},
					{"name":"not_codigo","value":"null","type":"other"}
				]}';
				$datapacket->add($filtro);
				$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
				$datapacket->open(true);
				$datapacket->clear();

			// produtos
				if(isset($dados->{"produtos"}) && !empty($dados->{"produtos"})){

					foreach ($dados->{"produtos"} as $produto) {

						// insumo_item
							$filtro = '{"cod":"501283","params":[
								{"name":"ins_codigo","value":"'.$ins_codigo.'","type":"string"},
								{"name":"ref_codigo","value":"'.$produto->{"ref_codigo"}.'","type":"integer"},
								{"name":"ref_descr","value":"'.$produto->{"ref_descr"}.'","type":"string"},
								{"name":"ref_conv_qtde","value":"'.$produto->{"ref_conv_qtde"}.'","type":"float"},
								{"name":"ref_unidade_entrada","value":"'.$produto->{"ref_unidade_entrada"}.'","type":"string"},
								{"name":"ref_qtde","value":"'.$produto->{"ref_qtde"}.'","type":"float"},
								{"name":"ref_valor","value":"'.$produto->{"ref_valor"}.'","type":"float"},
								{"name":"uni_codigo","value":"'.$produto->{"uni_codigo"}.'","type":"string"},
								{"name":"uni_descr","value":"'.$produto->{"uni_descr"}.'","type":"string"},
								{"name":"lot_codigo","value":"'.$produto->{"lot_codigo"}.'","type":"string"},
								{"name":"lot_descr","value":"'.$produto->{"lot_descr"}.'","type":"string"}
							]}';
							$datapacket->add($filtro);
							$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
							$datapacket->open(true);
							$datapacket->clear();
						
						// saldostk
							$stk_qde = $produto->{"ref_qtde"};
							if($produto->{"ref_unidade_entrada"} != $produto->{"uni_codigo"}) $stk_qde = $produto->{"ref_qtde"} / $produto->{"ref_conv_qtde"};

							$filtro = '{"cod":"700111","params":[
								{"name":"db","value":"'.$datapacket->getDb().'","type":"other"},
								{"name":"emp_codigo","value":"'.$datapacket->getCompany()->{"emp_codigo"}.'","type":"string"},
								{"name":"loc_codigo","value":"99999","type":"string"},
								{"name":"lot_codigo","value":"'.$produto->{"lot_codigo"}.'","type":"string"},
								{"name":"ref_codigo","value":"'.$produto->{"ref_codigo"}.'","type":"integer"},
								{"name":"ser_codigo","value":"1","type":"string"},
								{"name":"stk_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
								{"name":"stk_seq","value":"'.substr(str_replace(array(","," ","."), array("","",""), microtime()), 0, 8).'","type":"integer"},
								{"name":"stk_qde","value":"'.($stk_qde * -1).'","type":"float"},
								{"name":"stk_tipo","value":"null","type":"other"},
								{"name":"not_codigo","value":"null","type":"other"}
							]}';
							$datapacket->add($filtro);
							$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
							$datapacket->open(true);
							$datapacket->clear();
					}
				}

			exit('ok');
		}

		exit('Erro ao receber os parâmetros!');
		
	} else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"] == "excluir") {

		if(isset($_REQUEST['ins_codigo']) && !empty($_REQUEST['ins_codigo'])){

			// busca insumo
			$filtro = '{"cod":"501285","params":[
				{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
				{"name":"ins_codigo","value":"'.$_REQUEST['ins_codigo'].'","type":"string"},
				{"name":"ref_codigo","value":"%","type":"string"},
				{"name":"ins_data","value":"","type":"string"},
				{"name":"cad_codigo","value":"%","type":"string"},
				{"name":"lot_vencto","value":"%","type":"string"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$insumo = $datapacket->open(true);
			$datapacket->clear();

			if(empty($insumo[0]->{"not_codigo"})){
				
				// removo produto acabado do estoque
				$filtro = '{"cod":"700111","params":[
					{"name":"db","value":"'.$datapacket->getDb().'","type":"other"},
					{"name":"emp_codigo","value":"'.$datapacket->getCompany()->{"emp_codigo"}.'","type":"string"},
					{"name":"loc_codigo","value":"99999","type":"string"},
					{"name":"lot_codigo","value":"'.$insumo[0]->{"lot_codigo"}.'","type":"string"},
					{"name":"ref_codigo","value":"'.$insumo[0]->{"ref_codigo"}.'","type":"integer"},
					{"name":"ser_codigo","value":"1","type":"string"},
					{"name":"stk_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"stk_seq","value":"'.substr(str_replace(array(","," ","."), array("","",""), microtime()), 0, 8).'","type":"integer"},
					{"name":"stk_qde","value":"'.($insumo[0]->{"ref_qtde"} * -1).'","type":"float"},
					{"name":"stk_tipo","value":"null","type":"other"},
					{"name":"not_codigo","value":"null","type":"other"}
				]}';
				$datapacket->add($filtro);
				$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
				$datapacket->open(true);
				$datapacket->clear();

				// busco produtos do insumo
				$filtro = '{"cod":"501286","params":[
					{"name":"ins_codigo","value":"'.$_REQUEST['ins_codigo'].'","type":"string"}
				]}';
				$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
				$datapacket->add($filtro);
				$insumo_item = $datapacket->open(true);
				$datapacket->clear();

				// reponho produtos do insumo no estoque
				foreach ($insumo_item as $item) {

					$filtro = '{"cod":"700111","params":[
						{"name":"db","value":"'.$datapacket->getDb().'","type":"other"},
						{"name":"emp_codigo","value":"'.$datapacket->getCompany()->{"emp_codigo"}.'","type":"string"},
						{"name":"loc_codigo","value":"99999","type":"string"},
						{"name":"lot_codigo","value":"'.$item->{"lot_codigo"}.'","type":"string"},
						{"name":"ref_codigo","value":"'.$item->{"ref_codigo"}.'","type":"integer"},
						{"name":"ser_codigo","value":"1","type":"string"},
						{"name":"stk_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"stk_seq","value":"'.substr(str_replace(array(","," ","."), array("","",""), microtime()), 0, 8).'","type":"integer"},
						{"name":"stk_qde","value":"'.$item->{"ref_qtde"}.'","type":"float"},
						{"name":"stk_tipo","value":"null","type":"other"},
						{"name":"not_codigo","value":"null","type":"other"}
					]}';
					$datapacket->add($filtro);
					$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
					$datapacket->open(true);
					$datapacket->clear();
				}

				// removo insumo
				$filtro = '{"cod":"501287","params":[
					{"name":"ins_codigo","value":"'.$_REQUEST['ins_codigo'].'","type":"string"}
				]}';
				$datapacket->add($filtro);
				
				// removo produtos do insumo
				$filtro = '{"cod":"501288","params":[
					{"name":"ins_codigo","value":"'.$_REQUEST['ins_codigo'].'","type":"string"}
				]}';
				$datapacket->add($filtro);

				$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
				$insumo_item = $datapacket->open(true);
				$datapacket->clear();

				exit("ok");
			}

			exit("O insumo já foi trasmitido!");
		}

		exit("Erro ao receber os parametros!");

	} else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"] == "verificaLote") {
	
		$lot_descr = "";
		if(isset($_REQUEST['lot_descr']) && !empty($_REQUEST['lot_descr'])){
			$lot_descr = $_REQUEST['lot_descr'];
		}

		$filtro = '{"cod":"501282","params":[
			{"name":"lot_descr","value":"'.$lot_descr.'","type":"string"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$retorno = $datapacket->open(true);
		$datapacket->clear();
		print_r(json_encode($retorno));

	} else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"] == "storeInsumo") {
	
		$ins_codigo = "%";
		if(isset($_REQUEST['ins_codigo']) && !empty($_REQUEST['ins_codigo'])){
			$ins_codigo = $_REQUEST['ins_codigo'];
		}

		$ref_codigo = "%";
		if(isset($_REQUEST['ref_codigo']) && !empty($_REQUEST['ref_codigo'])){
			$ref_codigo = $_REQUEST['ref_codigo'];
		}

		$ins_data = "";
		if(isset($_REQUEST['ins_data']) && !empty($_REQUEST['ins_data'])){
			$ins_data = " and a.ins_data= '".implode("-", array_reverse(explode("/", substr($_REQUEST['ins_data'],0,10))))."' ";
		}

		$cad_codigo = "%";
		if(isset($_REQUEST['cad_codigo']) && !empty($_REQUEST['cad_codigo'])){
			$cad_codigo = $_REQUEST['cad_codigo'];
		}
		
		$lot_vencto = "";
		if(isset($_REQUEST['lot_vencto']) && !empty($_REQUEST['lot_vencto'])){
			$lot_vencto = " and b.lot_vencto='".implode("-", array_reverse(explode("/",substr($_REQUEST['lot_vencto'],0,10))))."' ";
		}

		$filtro = '{"cod":"501285","params":[
			{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
			{"name":"ins_codigo","value":"'.$ins_codigo.'","type":"string"},
			{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"string"},
			{"name":"ins_data","value":"'.$ins_data.'","type":"other"},
			{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
			{"name":"lot_vencto","value":"'.$lot_vencto.'","type":"other"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
		$datapacket->add($filtro);
		$retorno = $datapacket->open(true);
		$datapacket->clear();
		print_r(json_encode($retorno));

	} else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"] == "buscaInsumo") {
	
		if(isset($_REQUEST['ins_codigo']) && !empty($_REQUEST['ins_codigo'])){
			
			$filtro = '{"cod":"501285","params":[
				{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
				{"name":"ins_codigo","value":"'.$_REQUEST['ins_codigo'].'","type":"string"},
				{"name":"ref_codigo","value":"%","type":"string"},
				{"name":"ins_data","value":"","type":"string"},
				{"name":"cad_codigo","value":"%","type":"string"},
				{"name":"lot_vencto","value":"","type":"string"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$retorno = $datapacket->open(true);
			$datapacket->clear();

			$insumo = $retorno[0];

			$filtro = '{"cod":"501286","params":[
				{"name":"ins_codigo","value":"'.$_REQUEST['ins_codigo'].'","type":"string"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$insumo->{"produtos"} = $datapacket->open(true);
			$datapacket->clear();

			print_r(json_encode($insumo));
			exit();
		}

		exit("erro de parametros!");

	} else {

		$ins_codigo = "%";
		if(isset($_REQUEST['ins_codigo']) && !empty($_REQUEST['ins_codigo'])){
			$ins_codigo = $_REQUEST['ins_codigo'];
		}

		$filtro = '{"cod":"501285","params":[
			{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
			{"name":"ins_codigo","value":"'.$ins_codigo.'","type":"string"},
			{"name":"ref_codigo","value":"%","type":"string"},
			{"name":"ins_data","value":"","type":"string"},
			{"name":"cad_codigo","value":"%","type":"string"},
			{"name":"lot_vencto","value":"%","type":"string"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
		$datapacket->add($filtro);
		$retorno = $datapacket->open(true);
		$datapacket->clear();
		print_r(json_encode($retorno));

	}
	
?>