<?php

	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	
	include 'TParams.class.php';
	$datapacket = new TParams();
	$company = $datapacket->getCompany();
	
	//GMT
	if( isset($company->emp_gmt)  ){
		$gmt = (int) 3 - $company->emp_gmt;
		if( (date("I")==1) && strstr("DF|ES|GO|MT|MS|MG|PR|RJ|RS|SC|SP", $company->emp_uf) ){
			$gmt = $gmt-1;
		}
		$gmt = "-0".$gmt.":00";
	}else{
		$gmt = date("P");
	}
	
	$filtro = '{"cod":"600006","params":[
		{"name":"emp_codigo","value":"'.$company->emp_codigo.'","type":"string"}
	]}';
	$datapacket->setHost($datapacket->getHost("empresas"));
	$datapacket->add($filtro);
	$mkt = $datapacket->open(true);
	$datapacket->clear();
	
	if(isset($mkt) && isset($mkt[0]) && isset($_REQUEST["tipo"])){
		
		//requisição
		$ch = curl_init();
		
		//categorias
		if($_REQUEST["tipo"]=="categoria"){
			
			$url = $mkt[0]->eco_mkt_url."/categories/";
			
			if( isset($_REQUEST["acao"]) && ($_REQUEST["acao"]=="incluir" || $_REQUEST["acao"]=="alterar" || $_REQUEST["acao"]=="excluir" || $_REQUEST["acao"]=="buscar") ){
				
				if( isset($_REQUEST["id"]) ){
					
					$filtro = '{"cod":"700330","params":[
						{"name":"grupo","value":"where grp_codigo=\''.$_REQUEST["id"].'\'","type":"other"},
						{"name":"start","value":"0","type":"integer"},
						{"name":"limit","value":"1","type":"integer"}
					]}';
					$datapacket->setHost($datapacket->getHost($company->emp_db_comum));
					$datapacket->add($filtro);
					$cat = $datapacket->open(true);
					$datapacket->clear();
					
					$json = '{
					  "name": "'.$cat[0]->grp_descr.'",
					  "partnerId": "'.$cat[0]->grp_codigo.'",
					  "priceFactor": 1,
					  "children": []
					}';
					
					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]!="incluir" ){
						$url.=$cat[0]->grp_id."/";
					}
					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="alterar" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "PUT");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="excluir" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "DELETE");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="buscar" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "GET");
					}
					
				}
				
			}
		
		//subcategorias
		}elseif($_REQUEST["tipo"]=="subcategoria"){
			
			$url = $mkt[0]->eco_mkt_url."/categories/";
			
			if( isset($_REQUEST["acao"]) && ($_REQUEST["acao"]=="incluir" || $_REQUEST["acao"]=="alterar" || $_REQUEST["acao"]=="excluir" || $_REQUEST["acao"]=="buscar") ){
				
				if( isset($_REQUEST["id"]) ){
					
					$filtro = '{"cod":"700415","params":[
						{"name":"sgp_codigo","value":"'.$_REQUEST["id"].'","type":"integer"}
					]}';
					$datapacket->setHost($datapacket->getHost($company->emp_db_comum));
					$datapacket->add($filtro);
					$sub = $datapacket->open(true);
					$datapacket->clear();
					
					if($sub[0]->grp_id && $sub[0]->grp_id!=""){
						$json = '{
						  "name": "'.$sub[0]->sgp_descr.'",
						  "partnerId": "'.$sub[0]->sgp_codigo.'",
						  "parent": {
							"id": '.$sub[0]->grp_id.'
						  },
						  "priceFactor": 1,
						  "calculatedPrice": true
						}';
					}
					
					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]!="incluir" ){
						$url.=$sub[0]->sgp_id."/";
					}
					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="alterar" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "PUT");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="excluir" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "DELETE");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="buscar" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "GET");
					}
					
				}
				
			}
		
		//marcas
		}elseif($_REQUEST["tipo"]=="marca"){
			
			$url = $mkt[0]->eco_mkt_url."/brands/";
			
			if( isset($_REQUEST["acao"]) && ($_REQUEST["acao"]=="incluir" || $_REQUEST["acao"]=="alterar" || $_REQUEST["acao"]=="excluir" || $_REQUEST["acao"]=="buscar") ){
				
				if( isset($_REQUEST["id"]) ){
					
					$filtro = '{"cod":"700340","params":[
						{"name":"marca","value":"where mar_codigo=\''.$_REQUEST["id"].'\'","type":"other"}
					]}';
					$datapacket->setHost($datapacket->getHost($company->emp_db_comum));
					$datapacket->add($filtro);
					$mar = $datapacket->open(true);
					$datapacket->clear();
					
					$json = '{
					  "name": "'.$mar[0]->mar_descr.'",
					  "partnerId": "'.$mar[0]->mar_codigo.'"
					}';
					
					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]!="incluir" ){
						$url.=$mar[0]->mar_id."/";
					}
					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="alterar" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "PUT");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="excluir" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "DELETE");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="buscar" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "GET");
					}
					
				}
				
			}
		
		//variacoes
		}elseif($_REQUEST["tipo"]=="variacao"){
			
			$url = $mkt[0]->eco_mkt_url."/variations/";
			
			$json='{
			  "name": "Cor"
			}';
			
			$ch2 = curl_init();
			curl_setopt($ch2,CURLOPT_URL, $url."?gumgaToken=".$mkt[0]->eco_mkt_token);
			curl_setopt($ch2,CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length:'.strlen($json)));
			curl_setopt($ch2,CURLOPT_POST, true);
			curl_setopt($ch2,CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch2,CURLOPT_POSTFIELDS, $json);
			$result = curl_exec($ch2);
			curl_close($ch2);
			
			$json='{
			  "name": "Tamanho"
			}';
	
		//cores
		}elseif($_REQUEST["tipo"]=="cor"){
			
			$url = $mkt[0]->eco_mkt_url."/variations/";
			$ch2 = curl_init();
			curl_setopt($ch2,CURLOPT_CUSTOMREQUEST, "GET");
			curl_setopt($ch2,CURLOPT_URL, $url."?gumgaToken=".$mkt[0]->eco_mkt_token);
			curl_setopt($ch2,CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length: 0'));
			curl_setopt($ch2,CURLOPT_POST, true);
			curl_setopt($ch2,CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch2,CURLOPT_POSTFIELDS, '');
			$result = curl_exec($ch2);
			curl_close($ch2);
			$result = ( is_object(json_decode($result)) ) ? json_decode($result) : $result;
			foreach($result->content as $var){
				if($var->name && strtolower($var->name)=="cor"){
					$varid = $var->id;
				}
			}
			
			$url = $mkt[0]->eco_mkt_url."/variations/".$varid."/values/";

			if( isset($_REQUEST["acao"]) && ($_REQUEST["acao"]=="incluir" || $_REQUEST["acao"]=="alterar" || $_REQUEST["acao"]=="excluir" || $_REQUEST["acao"]=="buscar") ){
				
				if( isset($_REQUEST["id"]) ){
					
					$filtro = '{"cod":"700440","params":[
						{"name":"cor","value":"where cor_codigo=\''.$_REQUEST["id"].'\'","type":"other"}
					]}';
					$datapacket->setHost($datapacket->getHost($company->emp_db_comum));
					$datapacket->add($filtro);
					$cor = $datapacket->open(true);
					$datapacket->clear();
					
					$json = '{
					  "description": "'.$cor[0]->cor_descr.'",
					  "partnerId" : "'.$cor[0]->cor_codigo.'"
					}';
					
					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]!="incluir" ){
						$url.=$cor[0]->cor_id."/";
					}
					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="alterar" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "PUT");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="excluir" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "DELETE");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="buscar" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "GET");
					}
					
				}
				
			}
			
		//tamanhos
		}elseif($_REQUEST["tipo"]=="tamanho"){
			
			$url = $mkt[0]->eco_mkt_url."/variations/";
			$ch2 = curl_init();
			curl_setopt($ch2,CURLOPT_CUSTOMREQUEST, "GET");
			curl_setopt($ch2,CURLOPT_URL, $url."?gumgaToken=".$mkt[0]->eco_mkt_token);
			curl_setopt($ch2,CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length: 0'));
			curl_setopt($ch2,CURLOPT_POST, true);
			curl_setopt($ch2,CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch2,CURLOPT_POSTFIELDS, '');
			$result = curl_exec($ch2);
			curl_close($ch2);
			$result = ( is_object(json_decode($result)) ) ? json_decode($result) : $result;
			foreach($result->content as $var){
				if($var->name && strtolower($var->name)=="tamanho"){
					$varid = $var->id;
				}
			}
			
			$url = $mkt[0]->eco_mkt_url."/variations/".$varid."/values/";

			if( isset($_REQUEST["acao"]) && ($_REQUEST["acao"]=="incluir" || $_REQUEST["acao"]=="alterar" || $_REQUEST["acao"]=="excluir" || $_REQUEST["acao"]=="buscar") ){
				
				if( isset($_REQUEST["id"]) ){
					
					$filtro = '{"cod":"700470","params":[
						{"name":"tamanho","value":"where tam_codigo=\''.$_REQUEST["id"].'\'","type":"other"}
					]}';
					$datapacket->setHost($datapacket->getHost($company->emp_db_comum));
					$datapacket->add($filtro);
					$tam = $datapacket->open(true);
					$datapacket->clear();
					
					$json = '{
					  "description": "'.$tam[0]->tam_descr.'",
					  "partnerId" : "'.$tam[0]->tam_codigo.'"
					}';
					
					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]!="incluir" ){
						$url.=$tam[0]->tam_id."/";
					}
					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="alterar" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "PUT");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="excluir" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "DELETE");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="buscar" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "GET");
					}
					
				}
				
			}
			
		//produtos
		}elseif($_REQUEST["tipo"]=="produto"){
			
			$url = $mkt[0]->eco_mkt_url."/products/";
			
			if( isset($_REQUEST["acao"]) && ($_REQUEST["acao"]=="incluir" || $_REQUEST["acao"]=="alterar" || $_REQUEST["acao"]=="excluir" || $_REQUEST["acao"]=="buscar") ){
				
				if( isset($_REQUEST["id"]) ){
					
					$filtro = '{"cod":"700397","params":[
						{"name":"ref_codigo","value":"'.$_REQUEST["id"].'","type":"other"},
						{"name":"emp_codigo","value":"'.$company->emp_codigo.'","type":"string"}
					]}';
					$datapacket->setHost($datapacket->getHost($company->emp_db_comum));
					$datapacket->add($filtro);
					$ref = $datapacket->open(true);
					$datapacket->clear();
					if($ref && $ref[0]){

						$ref_img = json_decode(base64_decode($ref[0]->ref_img));
						if(is_array($ref_img) && isset($ref_img[0])){
							$ref_img = $ref_img[0]->imagem;
						}elseif(is_object($ref_img) && $ref_img->imagem){
							$ref_img = $ref_img->imagem;
						}
						if(is_array($ref_img)) $ref_img="";
						
						
						$json = '
						{
						  "title": "'.$ref[0]->ref_descr.'",
						  "description": "'.base64_decode($ref[0]->ref_detalhes).'",
						  "partnerId": "'.$ref[0]->ref_codigo.'",
						  "category": {
							"id": ';
							if( isset($ref[0]->sgp_id) && $ref[0]->sgp_id!="" ){
								$json.= $ref[0]->sgp_id;
							}else{
								$json.= (isset($ref[0]->grp_id)) ? $ref[0]->grp_id : '0';		
							}
						$json.= '},
						  "brand": {
							"id": ';
							$json.= (isset($ref[0]->mar_id)) ? $ref[0]->mar_id : '0';
							$json.='
						  },
						  "nbm": {
							"id": "'.$ref[0]->ref_ncm.'",
							"description": "'.$ref[0]->ref_ncm.'"
						  },
						  "origin": {
							"id": 0
						  },
						  "model": "'.$ref[0]->agr_descr.'",
						  "warrantyTime": '.$ref[0]->ref_validade.',
						  "warrantyText": "'.base64_decode($ref[0]->ref_ecom_garantia).'",
						  "height": '.$ref[0]->ref_fre_altura.',
						  "width": '.$ref[0]->ref_fre_largura.',
						  "weight": '.$ref[0]->ref_fre_peso.',
						  "length": '.$ref[0]->ref_fre_comprimento.',
						  "priceFactor": 1,
						  "calculatedPrice": true,
						  "characteristics": [],
						  "images": [
							{
							  "index": 0,
							  "main": true,
							  "url": "'.$datapacket->uploads2.$company->emp_codigo."/produtos/".$ref[0]->ref_codigo."/".$ref_img.'",
							  "thumbnailUrl": "'.$datapacket->uploads2.$company->emp_codigo."/produtos/".$ref[0]->ref_codigo."/thumbs/".$ref_img.'"
							}
						  ],
						  "skus": [';
						  
						 //skus
						$json_sku =	'{';
						$json_sku.= ( isset($ref[0]->ref_id) && $ref[0]->ref_id!='' ) ? '"id": '.$ref[0]->ref_id.',' : '';
						$json_sku.=  '"title": "'.$ref[0]->ref_descr.'",
						  "partnerId": "'.$ref[0]->ref_codigo.'",
						  "ean": "'.$ref[0]->ref_codbar.'",
						  "amount": '.$ref[0]->estoque.',
						  "price": '.$ref[0]->ref_preco.',
						  "additionalTime": 0';
							if( $ref[0]->cor_id || $ref[0]->tam_id ){
								$json_sku.= ', "variations": {';
								if($ref[0]->cor_id) $json_sku.='"cor" : "'.$ref[0]->cor_descr.'",';
								if($ref[0]->tam_id) $json_sku.='"tamanho" : "'.$ref[0]->tam_descr.'",';
								$json_sku = substr($json_sku, 0, -1);
								$json_sku.='}';
							}
						 $json_sku.='
						}';
						
						if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="alterar" ){
							$ch2 = curl_init();
							curl_setopt($ch2,CURLOPT_CUSTOMREQUEST, "PUT");
							curl_setopt($ch2,CURLOPT_URL, $mkt[0]->eco_mkt_url."/products/".$ref[0]->ref_propriedade."/skus/".$ref[0]->ref_id."?gumgaToken=".$mkt[0]->eco_mkt_token);
							curl_setopt($ch2,CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length:'.strlen($json_sku)));
							curl_setopt($ch2,CURLOPT_POST, true);
							curl_setopt($ch2,CURLOPT_RETURNTRANSFER, true);
							curl_setopt($ch2,CURLOPT_POSTFIELDS, $json_sku);
							curl_exec($ch2);
							curl_close($ch2);
							
							$json_stk = '[{
								"id": '.$ref[0]->ref_id.',
								"partnerId": '.$ref[0]->ref_codigo.',
								"quantity": '.$ref[0]->estoque.',
								"cost": '.$ref[0]->ref_preco.',
								"additionalTime": 0
							 }]';
							$ch2 = curl_init();
							curl_setopt($ch2,CURLOPT_CUSTOMREQUEST, "PUT");
							curl_setopt($ch2,CURLOPT_URL, $mkt[0]->eco_mkt_url."/stocks/?gumgaToken=".$mkt[0]->eco_mkt_token);
							curl_setopt($ch2,CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length:'.strlen($json_stk)));
							curl_setopt($ch2,CURLOPT_POST, true);
							curl_setopt($ch2,CURLOPT_RETURNTRANSFER, true);
							curl_setopt($ch2,CURLOPT_POSTFIELDS, $json_stk);
							curl_exec($ch2);
							curl_close($ch2);
						}
						
						$json.= $json_sku;
						$json_sku='';
						
						if( $ref[0]->ref_tipo==9 ){
							$filtro = '{"cod":"700405","params":[
								{"name":"ref_codbase","value":"'.$ref[0]->ref_codigo.'","type":"integer"},
								{"name":"emp_codigo","value":"'.$company->emp_codigo.'","type":"string"}
							]}';
							$datapacket->setHost($datapacket->getHost($company->emp_db_comum));
							$datapacket->add($filtro);
							$skus = $datapacket->open(true);
							$datapacket->clear();
							if(count($skus)>0){
								foreach($skus as $sku){
									
									$json_sku.=	',{';
									$json_sku.= ( isset($sku->ref_id) && $sku->ref_id!='' ) ? '"id": '.$sku->ref_id.',' : '';
									$json_sku.=  '"title": "'.$sku->ref_descr.'",
									  "partnerId": "'.$sku->ref_codigo.'",
									  "ean": "'.$sku->ref_codbar.'",
									  "amount": '.$sku->estoque.',
									  "price": '.$sku->ref_preco.',
									  "additionalTime": 0';
										if( $sku->cor_id || $sku->tam_id ){
											$json_sku.= ', "variations": {';
											if($sku->cor_id) $json_sku.='"cor" : "'.$sku->cor_descr.'",';
											if($sku->tam_id) $json_sku.='"tamanho" : "'.$sku->tam_descr.'",';
											$json_sku = substr($json_sku, 0, -1);
											$json_sku.='}';
										}
									 $json_sku.='
									}';
									
									if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="alterar" ){
										$ch2 = curl_init();
										curl_setopt($ch2,CURLOPT_CUSTOMREQUEST, "PUT");
										curl_setopt($ch2,CURLOPT_URL, $mkt[0]->eco_mkt_url."/products/".$ref[0]->ref_propriedade."/skus/".$sku->ref_id."?gumgaToken=".$mkt[0]->eco_mkt_token);
										curl_setopt($ch2,CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length:'.(strlen($json_sku)-1)));
										curl_setopt($ch2,CURLOPT_POST, true);
										curl_setopt($ch2,CURLOPT_RETURNTRANSFER, true);
										curl_setopt($ch2,CURLOPT_POSTFIELDS, substr($json_sku,1));
										curl_exec($ch2);
										curl_close($ch2);
										
										$json_stk = '[{
											"id": '.$sku->ref_id.',
											"partnerId": '.$sku->ref_codigo.',
											"quantity": '.$sku->estoque.',
											"cost": '.$sku->ref_preco.',
											"additionalTime": 0
										}]';
										$ch2 = curl_init();
										curl_setopt($ch2,CURLOPT_CUSTOMREQUEST, "PUT");
										curl_setopt($ch2,CURLOPT_URL, $mkt[0]->eco_mkt_url."/stocks/?gumgaToken=".$mkt[0]->eco_mkt_token);
										curl_setopt($ch2,CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length:'.strlen($json_stk)));
										curl_setopt($ch2,CURLOPT_POST, true);
										curl_setopt($ch2,CURLOPT_RETURNTRANSFER, true);
										curl_setopt($ch2,CURLOPT_POSTFIELDS, $json_stk);
										curl_exec($ch2);
										curl_close($ch2);
									}
									
									$json.= $json_sku;
									$json_sku='';
									
								}
							}
						}
						
						$json.=  ']
						}';
						
					}else{
						$json="";
					}

					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]!="incluir" ){
						$url.=$ref[0]->ref_propriedade."/";
					}
					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="alterar" ){						
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "PUT");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="excluir" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "DELETE");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="buscar" ){
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "GET");
					}
					
				}
				
			}
			
		//pedidos
		}elseif($_REQUEST["tipo"]=="pedido"){
			
			$url = $mkt[0]->eco_mkt_url."/orders/";
			
			if( isset($_REQUEST["acao"]) && ($_REQUEST["acao"]=="incluir" || $_REQUEST["acao"]=="alterar" || $_REQUEST["acao"]=="buscar") ){
				
				if( isset($_REQUEST["id"]) ){
					
					if( $_REQUEST["acao"]=="incluir" ){
						
						$url = $mkt[0]->eco_mkt_url."/orders/".$_REQUEST["id"]."/";
						$ch2 = curl_init();
						curl_setopt($ch2,CURLOPT_CUSTOMREQUEST, "GET");
						curl_setopt($ch2,CURLOPT_URL, $url."?gumgaToken=".$mkt[0]->eco_mkt_token);
						curl_setopt($ch2,CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length: 0'));
						curl_setopt($ch2,CURLOPT_POST, true);
						curl_setopt($ch2,CURLOPT_RETURNTRANSFER, true);
						curl_setopt($ch2,CURLOPT_POSTFIELDS, '');
						$result = curl_exec($ch2);
						curl_close($ch2);
						$result = ( is_object(json_decode($result)) ) ? json_decode($result) : $result;
						
						//verifia se o pedido já existe no sistema
						if( isset($result->partnerId) && $result->partnerId!="" ){
							$filtro = '{"cod":"700399","params":[
								{"name":"db","value":"'.$company->emp_db_comum.'","type":"other"},
								{"name":"id","value":"'.$result->partnerId.'","type":"integer"}
							]}';
							$datapacket->setHost($datapacket->getHost($company->emp_db_sge));
							$datapacket->add($filtro);
							$ped = $datapacket->open(true);
							$datapacket->clear();
						}else{
							$ped=array();
						}
						
						if( count($ped)==0 ){
							
							//verifica se o cliente já existe no sistema
							$filtrocad = '{"cod":"700560","params":[
								{"name":"cad_cnpjcpf","value":"'.$result->buyer->document.'","type":"string"}
							]}';
							$datapacket->add($filtrocad);
							$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
							$res = $datapacket->open(true);
							$datapacket->clear();
							
							$arr1 = array("á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç", "º", "ª", "\"", "'");
							$arr2 = array("a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C", "", "", "", "");
							
							if( count($res)==0 ){					
								
								$cad_pessoa = ($result->buyer->documentType=="CPF") ? 1 : 2;
								$cad_nomeraz = strtoupper(str_replace($arr1, $arr2, $result->buyer->name));
								$cad_codigo = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 13);
								
								//buscar codigo do municipio pelo cep
								$filtrocep = '{"cod":"700004","params":[
									{"name":"cep","value":"'.$result->shipping->zipCode.'","type":"string"}
								]}';
								$datapacket->add($filtrocep);
								$cep = $datapacket->open(true);
								$datapacket->clear();
								$cad_codmun = (isset($cep) && isset($cep[0]) && isset($cep[0]->mun_codigo)) ? $cep[0]->mun_codigo : "";
								
								//cliente
								$filtro = '{"cod":"700280","params":[
									{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
									{"name":"cad_nomeraz","value":"'.$cad_nomeraz.'","type":"string"},
									{"name":"cad_snomefant","value":"'.$cad_nomeraz.'","type":"string"},
									{"name":"cad_pessoa","value":"'.$cad_pessoa.'","type":"integer"},
									{"name":"cad_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
									{"name":"cad_tipo","value":"1","type":"integer"},
									{"name":"cad_status","value":"0","type":"integer"},
									{"name":"cad_cnpjcpf","value":"'.$result->buyer->document.'","type":"string"},
									{"name":"cad_inscrg","value":"","type":"string"},
									{"name":"cad_dtnascfund","value":"NULL","type":"other"},
									{"name":"cad_conjuge","value":"NULL","type":"other"},
									{"name":"cad_dtnascconj","value":"NULL","type":"other"},
									{"name":"cad_codigo_pai","value":"NULL","type":"other"},
									{"name":"cad_obs","value":"","type":"string"},
									{"name":"usu_login","value":"NULL","type":"other"},
									{"name":"cad_foto","value":"NULL","type":"other"},
									{"name":"cad_inscrito","value":"0","type":"integer"},
									{"name":"cad_codbanco","value":"NULL","type":"other"},
									{"name":"cad_nomebanco","value":"NULL","type":"other"},
									{"name":"cad_codcedente","value":"NULL","type":"other"},
									{"name":"cad_uf","value":"'.$result->shipping->state.'","type":"string"},
									{"name":"cad_suframa","value":"NULL","type":"other"},
									{"name":"cad_email_nfe","value":"NULL","type":"other"},
									{"name":"cad_codmun","value":"'.$cad_codmun.'","type":"string"},
									{"name":"cad_cidade","value":"'.$result->shipping->city.'","type":"string"},
									{"name":"cad_comissao","value":"NULL","type":"other"},
									{"name":"cad_instrucao1","value":"","type":"string"},
									{"name":"cad_instrucao2","value":"","type":"string"},
									{"name":"cad_instrucao3","value":"","type":"string"},
									{"name":"cad_instrucao4","value":"","type":"string"},
									{"name":"cad_instrucao5","value":"","type":"string"},
									{"name":"cad_honorarios","value":"NULL","type":"other"},
									{"name":"cad_multa","value":"NULL","type":"other"},
									{"name":"cad_jurosdiario","value":"NULL","type":"other"},
									{"name":"rat_codigo","value":"NULL","type":"other"},
									{"name":"sat_codigo","value":"NULL","type":"other"},
									{"name":"cad_ra","value":"'.$result->buyer->id.'","type":"string"},
									{"name":"cad_rem_bco","value":"NULL","type":"other"},
									{"name":"cad_rem_ag","value":"NULL","type":"other"},
									{"name":"cad_rem_cc","value":"NULL","type":"other"},
									{"name":"cad_cced","value":"NULL","type":"other"},
									{"name":"cad_rem_layout","value":"NULL","type":"other"},
									{"name":"cad_rem_cart","value":"NULL","type":"other"},
									{"name":"cad_limite","value":"NULL","type":"other"},
									{"name":"cad_codvend","value":"NULL","type":"other"},
									{"name":"cad_preco","value":"0","type":"integer"},
									{"name":"cad_descontomax","value":"NULL","type":"other"},
									{"name":"emp_codigo","value":"'.$company->emp_codigo.'","type":"string"},
									{"name":"cad_sexo","value":"3","type":"integer"}
								]}';

								$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
								$datapacket->add($filtro);
								$datapacket->open();
								$datapacket->clear();
								$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
								
								// INCLUIR/ ALTERAR O ENDERECO PRINCIPAL VINCULADO AO CADASTRO
								$end = explode("-", $result->shipping->address);
								$bairro = ($end[1]) ? $end[1] : '';
								$end = explode(" ", $end[0]);
								foreach($end as $e){
									if(is_numeric($e)) $num = $e;
								}
								if(isset($num)){
									$end = implode(" ", $end);
									$end = str_replace($num, "", $end);
								}else{
									$num="";
								}
								$filtro3 = '{"cod":"700282","params":[
									{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
									{"name":"end_tipo","value":"1","type":"integer"},
									{"name":"end_nome","value":"'.mb_strtoupper($end, 'UTF-8').'","type":"string"},
									{"name":"end_compl","value":"","type":"string"},
									{"name":"end_bairro","value":"'.mb_strtoupper($bairro, 'UTF-8').'","type":"string"},
									{"name":"end_cidade","value":"'.$result->shipping->city.'","type":"string"},
									{"name":"end_uf","value":"'.$result->shipping->state.'","type":"string"},
									{"name":"end_cep","value":"'.$result->shipping->zipCode.'","type":"string"},
									{"name":"end_num","value":"'.$num.'","type":"string"},
									{"name":"end_obs","value":"","type":"string"}
								]}';
								$datapacket->add($filtro3);
								
								$filtroemail = '{"cod":"701171","params":[
									{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
									{"name":"eml_ender","value":"'.strtolower($result->buyer->email).'","type":"string"},
									{"name":"eml_obs","value":"","type":"string"},
									{"name":"eml_tipo","value":"1","type":"integer"}
								]}';
								$datapacket->add($filtroemail);
								
								$tel_codigo = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 7);
								$phone = str_replace(array("(", ")", "-", " "), array("","","",""), $result->buyer->phone);
								$ddd = substr($phone,0,2);
								$sufixo = substr($phone, -4);
								$prefixo = substr(str_replace($sufixo, "", $phone), 2);
								$filtro8 = '{"cod":"700286","params":[
									{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
									{"name":"tel_codigo","value":"'.$tel_codigo.'","type":"integer"},
									{"name":"tel_ddd","value":"'.$ddd.'","type":"string"},
									{"name":"tel_prefixo","value":"'.$prefixo.'","type":"string"},
									{"name":"tel_numero","value":"'.$sufixo.'","type":"string"},
									{"name":"tel_ramal","value":"","type":"string"},
									{"name":"tel_obs","value":"NULL","type":"other"},
									{"name":"tel_tipo","value":"3","type":"integer"}
								]}';
								$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
								$datapacket->add($filtro8);
								$datapacket->open();
								$datapacket->clear();
							
							}else{
								$cad_codigo = $res[0]->cad_codigo;
							}

							//buscar numero atualizado
							$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
							$filtronum = '{"cod":"500925","params":[]}';
							$datapacket->add($filtronum);
							$num = $datapacket->open(true);
							$datapacket->clear();
							if($num[0] && $num[0]->not_numero) $not_numero = $num[0]->not_numero;
							
							$not_dtfaturam = (isset($result->paymentDate) && $result->paymentDate!="") ? substr(str_replace("T", " ", $result->paymentDate), 0, 19) : "";
							$not_codigo = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 19);
							
							//ecommerce
							$ecm_status = ($result->status=="PAID_WAITING_SHIP") ? 3 : 1;
							$filtroecm = '{"cod":"555106","params":[
								{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"},
								{"name":"ecm_tpfrete","value":"1","type":"float"},
								{"name":"ecm_valor_frete","value":"'.$result->freight.'","type":"float"},
								{"name":"ecm_prazo_frete","value":"6","type":"float"},
								{"name":"ecm_status","value":"'.$ecm_status.'","type":"integer"},
								{"name":"ecm_obs","value":"'.base64_encode($result->marketPlace).'","type":"string"},
								{"name":"ecm_id","value":"'.$result->id.'","type":"string"},
								{"name":"ecm_id_mkt","value":"'.$result->marketPlaceId.'","type":"string"}
							]}';
							$datapacket->add($filtroecm);
							$partnerId = $datapacket->open(false, true);
							$datapacket->clear();
							
							$filtro = '{"cod":"500926","params":[
								{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"},
								{"name":"not_numero","value":"'.$not_numero.'","type":"string"},
								{"name":"ser_codigo","value":"ECM","type":"string"},
								{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
								{"name":"cad_codvend","value":"NULL","type":"other"},
								{"name":"not_tipo","value":"11","type":"integer"},
								{"name":"not_cancelada","value":"0","type":"integer"},
								{"name":"not_dtcancdesc","value":"","type":"null"},
								{"name":"not_data","value":"'.date("Y-m-d H:i:s",strtotime($result->createdAt)).'","type":"string"},
								{"name":"not_dtemissao","value":"'.date("Y-m-d H:i:s",strtotime($result->createdAt)).'","type":"string"},
								{"name":"not_dtfaturam","value":"'.$not_dtfaturam.'","type":"string"},
								{"name":"not_dtprevisao","value":"","type":"null"},
								{"name":"not_dtentrega","value":"","type":"null"},
								{"name":"not_finanatualiz","value":"0","type":"integer"},
								{"name":"not_stokatualiz","value":"0","type":"integer"},
								{"name":"not_custoautaliz","value":"0","type":"integer"},
								{"name":"not_percdesc","value":"0","type":"float"},
								{"name":"not_valordesc","value":"'.$result->discount.'","type":"float"},
								{"name":"not_totalnota","value":"'.$result->total.'","type":"float"},
								{"name":"not_totalprod","value":"'.$result->total.'","type":"float"},
								{"name":"not_totalserv","value":"NULL","type":"other"},
								{"name":"not_entrsaida","value":"2","type":"integer"},
								{"name":"not_totbaseicms","value":"0","type":"float"},
								{"name":"not_toticms","value":"0","type":"float"},
								{"name":"not_totbaseipi","value":"0","type":"float"},
								{"name":"not_totipi","value":"0","type":"float"},
								{"name":"cfo_codigo","value":"5101","type":"integer"},
								{"name":"cdp_codigo","value":"NULL","type":"other"},
								{"name":"pdv_codigo","value":"","type":"null"},
								{"name":"ccu_codigo","value":"NULL","type":"other"},
								{"name":"tbp_codigo","value":"NULL","type":"other"},
								{"name":"not_codigo_pai","value":"NULL","type":"other"},
								{"name":"not_codigo_filho","value":"","type":"null"},
								{"name":"cad_codtransp","value":"NULL","type":"other"},
								{"name":"not_frete","value":"'.$result->freight.'","type":"float"},
								{"name":"not_seguro","value":"0","type":"float"},
								{"name":"not_despesa","value":"'.$result->interestValue.'","type":"float"},
								{"name":"not_tpfrete","value":"2","type":"integer"},
								{"name":"not_toticmssubst","value":"0","type":"float"},
								{"name":"not_obs1","value":"","type":"string"},
								{"name":"not_obs2","value":"","type":"string"},
								{"name":"not_obs3","value":"","type":"string"},
								{"name":"not_obs4","value":"","type":"string"},
								{"name":"not_devolucao","value":"","type":"null"},
								{"name":"not_hhmmss","value":"","type":"null"},
								{"name":"not_qtde","value":"","type":"float"},
								{"name":"not_especie","value":"","type":"string"},
								{"name":"not_marca","value":"","type":"string"},
								{"name":"not_nro","value":"","type":"string"},
								{"name":"not_pesobruto","value":"","type":"float"},
								{"name":"not_pesoliquido","value":"","type":"float"},
								{"name":"not_cadinscrito","value":"","type":"null"},
								{"name":"not_transportadora","value":"","type":"string"},
								{"name":"not_placa","value":"","type":"string"},
								{"name":"not_totbaseicmsst","value":"0","type":"float"},
								{"name":"not_totiss","value":"","type":"null"},
								{"name":"cad_atendente","value":"","type":"null"},
								{"name":"not_key_nfe","value":"NULL","type":"other"},
								{"name":"not_cdp_desc","value":"0","type":"float"},
								{"name":"not_cobranca","value":"","type":"null"},
								{"name":"not_entrada","value":"","type":"null"},
								{"name":"not_status","value":"0","type":"integer"},
								{"name":"not_tpprc","value":"","type":"null"},
								{"name":"not_nrodeposito","value":"","type":"null"},
								{"name":"not_codrastream","value":"","type":"null"},
								{"name":"cta_codigo","value":"NULL","type":"other"},
								{"name":"not_result","value":"","type":"null"},
								{"name":"not_cstat","value":"NULL","type":"other"},
								{"name":"not_xmotivo","value":"NULL","type":"other"},
								{"name":"not_nrec","value":"","type":"null"},
								{"name":"not_nprot","value":"NULL","type":"other"},
								{"name":"not_tpemis","value":"1","type":"integer"},
								{"name":"not_aliq","value":"","type":"null"},
								{"name":"not_entrnfe","value":"","type":"null"},
								{"name":"not_mapa","value":"","type":"null"},
								{"name":"not_lote_ccev","value":"","type":"null"},
								{"name":"loc_codigo","value":"","type":"null"},
								{"name":"not_cod_mesa","value":"","type":"null"},
								{"name":"not_sta_mesa","value":"","type":"null"},
								{"name":"not_aliqcredicms","value":"NULL","type":"other"},
								{"name":"not_inf_fisco","value":"","type":"string"},
								{"name":"lic_codigo","value":"NULL","type":"other"},
								{"name":"not_nferef","value":"NULL","type":"other"},
								{"name":"not_auxiliar","value":"NULL","type":"other"},
								{"name":"not_anexo","value":"NULL","type":"other"},
								{"name":"ors_codigo","value":"NULL","type":"other"},
								{"name":"not_ibpt_federal","value":"0","type":"float"},
								{"name":"not_ibpt_estadual","value":"0","type":"float"},
								{"name":"not_ibpt_municipal","value":"0","type":"float"}
							]}';
							$datapacket->add($filtro);

							$i=0;
							foreach($result->items as $item){

								//json com os dados  da tributação
								$tribjson = '';
								
								$itn_descr = strtoupper(str_replace($arr1, $arr2, trim($item->sku->title))); //tratamento da string com o nome do produto
								
								$filtro3 = '{"cod":"700099","params":[
									{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"},
									{"name":"ref_codigo","value":"'.$item->sku->partnerId.'","type":"integer"},
									{"name":"itn_ordem","value":"'.$i.'","type":"integer"},
									{"name":"itn_descr","value":"'.$itn_descr.'","type":"string"},
									{"name":"itn_qtde","value":"'.$item->amount.'","type":"float"},
									{"name":"itn_valordesc","value":"'.$item->discount.'","type":"float"},
									{"name":"itn_valor","value":"'.$item->unit.'","type":"float"},
									{"name":"itn_subtotal","value":"'.$item->total.'","type":"float"},
									{"name":"itn_baseicms","value":"0","type":"float"},
									{"name":"itn_icms","value":"0","type":"float"},
									{"name":"itn_aliqicms","value":"0","type":"float"},
									{"name":"itn_baseipi","value":"0","type":"float"},
									{"name":"itn_ipi","value":"0","type":"float"},
									{"name":"itn_aliqipi","value":"0","type":"float"},
									{"name":"itn_baseicmsst","value":"0","type":"float"},
									{"name":"itn_icmssubst","value": "0","type":"float"},
									{"name":"itn_custovenda","value":"NULL","type":"other"},
									{"name":"itn_tribjson","value":"","type":"string"},
									{"name":"itn_ncm","value":"","type":"string"},
									{"name":"ref_codbar","value":"","type":"string"},
									{"name":"loc_codigo","value":"","type":"string"},
									{"name":"itn_obs","value":" ","type":"string"},
									{"name":"uni_codigo","value":"NULL","type":"other"},
									{"name":"itn_altura","value":"NULL","type":"other"},
									{"name":"itn_largura","value":"NULL","type":"other"},
									{"name":"itn_modelo","value":"NULL","type":"other"},
									{"name":"itn_comando","value":"NULL","type":"other"},
									{"name":"fml_codigo","value":"NULL","type":"other"},
									{"name":"lot_codigo","value":"99999","type":"string"}
								]}';

								$datapacket->add($filtro3);
								
								$i++;
							}
							
							$datapacket->open();

							$url = $mkt[0]->eco_mkt_url."/orders/".$_REQUEST["id"]."/";
							curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "PUT");
							$json = '{
								"partnerId" : "'.$partnerId.'"
							}';
							
						}else{
							if(isset($result->status) && $result->status=="PAID_WAITING_SHIP"){
								echo '{"status":"erro", "msg": "pedido ja cadastrado", "not_codigo":"'.$ped[0]->not_codigo.'", "id":"'.$ped[0]->id.'"}';
							}else{
								echo '{"status":"erro", "msg": "pedido ja cadastrado"}';
							}
						}
						
					}elseif($_REQUEST["acao"]=="alterar"){
					
						$filtro = '{"cod":"700399","params":[
							{"name":"db","value":"'.$company->emp_db_comum.'","type":"other"},
							{"name":"id","value":"'.$_REQUEST["id"].'","type":"integer"}
						]}';
						$datapacket->setHost($datapacket->getHost($company->emp_db_sge));
						$datapacket->add($filtro);
						$ped = $datapacket->open(true);
						$datapacket->clear();
						
						if( $_REQUEST["status"]==3 ){
							if( isset($_REQUEST["not_codigo"]) ){
								$filtro = '{"cod":"600303","params":[
									{"name":"ecm_status","value":"3","type":"integer"},
									{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"}
								]}';
								$datapacket->add($filtro);
								$datapacket->open();
								$datapacket->clear();
								$json='{}';
							}else{
								$json = '{
								  "status": "PAID_WAITING_SHIP"
								}';
							}
						}elseif( $_REQUEST["status"]==4 ){
							$json = '{
							  "order_id": "'.$ped[0]->ecm_id.'",
							  "status": "INVOICED",
							  "invoice": {
								"series": "'.$_REQUEST["serie"].'",
								"number": "'.$_REQUEST["num"].'",
								"accessKey": "'.$_REQUEST["chave"].'",
								"date": "'.date("Y-m-d").'T'.date("H:i:s").$gmt.'"
							  }
							}';
						}elseif( $_REQUEST["status"]==5 && isset($ped[0]->ecm_id) ){
							$json='{
							  "order_id": "'.$ped[0]->ecm_id.'",
							  "status": "PAID_WAITING_DELIVERY",
							  "tracking": {
								"date": "'.date("Y-m-d").'T'.date("H:i:s").$gmt.'",
								"shippedDate": "'.date("Y-m-d").'T'.date("H:i:s").$gmt.'",
								"estimateDate": "'.date("Y-m-d", strtotime(date("Y-m-d")."+ ".$ped[0]->ecm_prazo_frete." days")).'T'.date("H:i:s").$gmt.'",
								"carrier": "Correios Correios-Sedex",
								"number": "'.$ped[0]->ecm_cod_rastreamento.'",
								"url": ""
							  }
							}';
						}elseif( $_REQUEST["status"]==9 && isset($ped[0]->ecm_id) ){
							$json='{
							  "order_id": "'.$ped[0]->ecm_id.'",
							  "status": "PAID_WAITING_DELIVERY",
							  "tracking": {
								"date": "'.date("Y-m-d").'T'.date("H:i:s").$gmt.'",
								"deliveredDate": "'.date("Y-m-d").'T'.date("H:i:s").$gmt.'",
								"carrier": "Correios Correios-Sedex",
								"number": "'.$ped[0]->ecm_cod_rastreamento.'",
								"url": ""
							  }
							}';
						}
						
					}

					if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="alterar" ){
						$url = $mkt[0]->eco_mkt_url."/orders/".$ped[0]->ecm_id."/";
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "PUT");
					}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="buscar" ){
						$url = $mkt[0]->eco_mkt_url."/orders/".$_REQUEST["id"]."/";
						$json='{}';
						curl_setopt($ch,CURLOPT_CUSTOMREQUEST, "GET");
					}
					
				}
				
			}
			
		}
		// echo "<pre>";
		// print_r($json);
		// exit();
		if(isset($url) && $url!="" && isset($json) && $json!=""){
			//define url, numero de variaveis POST e dados POST
			curl_setopt($ch,CURLOPT_URL, $url."?gumgaToken=".$mkt[0]->eco_mkt_token);
			curl_setopt($ch,CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length: ' . strlen($json)));
			curl_setopt($ch,CURLOPT_POST, true);
			curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch,CURLOPT_POSTFIELDS, $json);

			$result = curl_exec($ch);
			$result = ( is_object(json_decode($result)) ) ? json_decode($result) : $result;
			
			if( is_object($result) ){
				
				if( isset($result->message) ){
					echo '{"status":"erro", "msg": "'.addslashes($result->message).'"}';
				}elseif( $_REQUEST["acao"]=="incluir" && isset($result->id) ){
					
					//categorias
					if($_REQUEST["tipo"]=="categoria"){
						if(isset($_REQUEST["id"])){
							$filtro = '{"cod":"700387","params":[
								{"name":"grp_id","value":"'.$result->id.'","type":"string"},
								{"name":"grp_codigo","value":"'.$_REQUEST["id"].'","type":"integer"}
							]}';
						}
						$datapacket->add($filtro);
						$datapacket->open();
					//subcategorias
					}elseif($_REQUEST["tipo"]=="subcategoria"){
						if(isset($_REQUEST["id"])){
							$filtro = '{"cod":"700416","params":[
								{"name":"sgp_id","value":"'.$result->id.'","type":"string"},
								{"name":"sgp_codigo","value":"'.$_REQUEST["id"].'","type":"integer"}
							]}';
						}
						$datapacket->add($filtro);
						$datapacket->open();
					//marcas
					}elseif($_REQUEST["tipo"]=="marca"){
						if(isset($_REQUEST["id"])){
							$filtro = '{"cod":"700388","params":[
								{"name":"mar_id","value":"'.$result->id.'","type":"string"},
								{"name":"mar_codigo","value":"'.$_REQUEST["id"].'","type":"integer"}
							]}';
						}
						$datapacket->add($filtro);
						$datapacket->open();
					//cores
					}elseif($_REQUEST["tipo"]=="cor"){
						if(isset($_REQUEST["id"])){
							$filtro = '{"cod":"700389","params":[
								{"name":"cor_id","value":"'.$result->id.'","type":"string"},
								{"name":"cor_codigo","value":"'.$_REQUEST["id"].'","type":"integer"}
							]}';
						}
						$datapacket->add($filtro);
						$datapacket->open();
					//tamanhos
					}elseif($_REQUEST["tipo"]=="tamanho"){
						if(isset($_REQUEST["id"])){
							$filtro = '{"cod":"700396","params":[
								{"name":"tam_id","value":"'.$result->id.'","type":"string"},
								{"name":"tam_codigo","value":"'.$_REQUEST["id"].'","type":"string"}
							]}';
						}
						$datapacket->add($filtro);
						$datapacket->open();
					//produtos
					}elseif($_REQUEST["tipo"]=="produto"){
						// echo "<pre>";
						// print_r($result);
						if(isset($_REQUEST["id"])){
							if( $result->skus && is_array($result->skus) ){
								foreach($result->skus as $sku){
									$filtro = '{"cod":"700406","params":[
										{"name":"ref_id","value":"'.$sku->id.'","type":"string"},
										{"name":"ref_codigo","value":"'.$sku->partnerId.'","type":"integer"}
									]}';
									$datapacket->add($filtro);
								}
							}
							$filtro = '{"cod":"700398","params":[
								{"name":"ref_propriedade","value":"'.$result->id.'","type":"string"},
								{"name":"ref_codigo","value":"'.$_REQUEST["id"].'","type":"integer"}
							]}';
							$datapacket->add($filtro);
							$datapacket->open();
						}
						
					}
					
					echo '{"status":"ok", "msg": "Registro cadastrado com sucesso."}';
				}elseif($_REQUEST["acao"]=="alterar"){
					echo '{"status":"ok", "msg": "Registro alterado com sucesso"}';
				}elseif($_REQUEST["acao"]=="buscar"){
					echo "<pre>";
					print_r($result);
				}
				
			}else{
				if($_REQUEST["acao"]=="excluir"){
					echo '{"status":"ok", "msg": "Registro excluido com sucesso."}';
				}else{
					print_r($result);
				}
			}
		}
		
		//fechar conexao
		curl_close($ch);
		
	}else{
		echo '{"status":"erro", "msg": "Nao foram encontrados dados marketplace!"}';
	}
	
?>