<?php

	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	if(!class_exists("Datapacket")) include 'datapacket.php';
	if(!class_exists("TParams")) include 'TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	$datapacket->setHost($TParams->getHost($TParams->getDbSge()));

	if(!isset($_REQUEST['start'])) $_REQUEST['start']=0;
	if(!isset($_REQUEST['limit'])) $_REQUEST['limit']=100;
	
	$company = $TParams->getCompany();
	
	if(isset($_POST["acao"]) && $_POST["acao"]=="salvar"){
		
		//opção para autocompletar dados da mensagem a partir da finalidade da mesma
		if( isset($_POST["auto"]) && isset($_POST['men_codigo']) ){
			$_POST['msg_codigo']='';
			$_POST['msg_tipo']=1;
			$_POST['msg_anexo']='';
			$_POST['msg_dtenvio'] = date('d/m/Y H:i:s');
			$filter = '{"cod":"700268","params":[
				{"name":"dbcomum","value":"'.$company->emp_db_comum.'","type":"other"},
				{"name":"men_codigo","value":"'.$_POST['men_codigo'].'","type":"integer"}
			]}';
			$datapacket->add($filter);
			$ret = $datapacket->open(true);
			$datapacket->clear();
			
			if($ret && $ret[0] && $ret[0]->men_conteudo && $ret[0]->men_conteudo!=""){
				$_POST['msg_remetente'] = $ret[0]->men_remetente;
				$_POST['msg_assunto'] = $ret[0]->men_assunto;
				$_POST['msg_conteudo'] = utf8_encode(base64_decode($ret[0]->men_conteudo));
			}
		}
		
		//CADASTRAR
		$filtro = '{"cod":"700321","params":[
			{"name":"msg_codigo","value":"'.$_POST['msg_codigo'].'","type":"string"},
			{"name":"msg_tipo","value":"'.$_POST['msg_tipo'].'","type":"integer"},
			{"name":"men_codigo","value":"'.$_POST['men_codigo'].'","type":"integer"},
			{"name":"msg_remetente","value":"'.strtolower($_POST['msg_remetente']).'","type":"string"},
			{"name":"msg_destinatario","value":"'.strtolower($_POST['msg_destinatario']).'","type":"string"},
			{"name":"cad_codigo","value":"'.$_POST['cad_codigo'].'","type":"string"},
			{"name":"msg_assunto","value":"'.$_POST['msg_assunto'].'","type":"string"},
			{"name":"msg_conteudo","value":"'.base64_encode(utf8_decode($_POST['msg_conteudo'])).'","type":"string"},
			{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"msg_dtenvio","value":"'.implode("-", array_reverse(explode("/", substr($_POST['msg_dtenvio'], 0, 10)))).substr($_POST['msg_dtenvio'],10, 9).'","type":"string"},
			{"name":"msg_status","value":"0","type":"integer"},
			{"name":"msg_anexo","value":"'.$_POST['msg_anexo'].'","type":"string"}
		]}';
		
		$datapacket->add($filtro);
		
		$ret = $datapacket->open(false, true);
		
		$datapacket->clear();
		
		if( isset($_POST["vin_tabela"]) && isset($_POST["vin_codigo"]) ){
			$filtro = '{"cod":"700329","params":[
				{"name":"msg_codigo","value":"'.$ret.'","type":"integer"},
				{"name":"vin_tabela","value":"'.$_POST['vin_tabela'].'","type":"string"},
				{"name":"vin_codigo","value":"'.$_POST['vin_codigo'].'","type":"string"}
			]}';
			
			$datapacket->add($filtro);
			
			$datapacket->open();
		}
		
		print_r("ok".$ret);
		
	}elseif(isset($_POST["acao"]) && $_POST["acao"]=="excluir"){
		
		//EXCLUIR
		$filtro = '{"cod":"700322","params":[
			{"name":"msg_codigo","value":"'.$_POST['msg_codigo'].'","type":"integer"}
		]}';
		
		$datapacket->add($filtro);
		$datapacket->open();
		
		echo "ok";
		
	}elseif(isset($_POST["acao"]) && $_POST["acao"]=="cancelar"){
		
		//EXCLUIR
		$filtro = '{"cod":"700327","params":[
			{"name":"msg_status","value":"4","type":"integer"},
			{"name":"msg_codigo","value":"'.$_POST['msg_codigo'].'","type":"integer"}
		]}';
		
		$datapacket->add($filtro);
		
		$datapacket->open();
		
		echo "ok";
		
	}elseif(isset($_POST["acao"]) && $_POST["acao"]=="anexar"){
		
		if( isset($_FILES['msg_anexo']['tmp_name']) ){
			
			$uploaddir = $TParams->uploads.$TParams->getCodigo()."/mensagens/";
			if (!is_dir($uploaddir))   mkdir($uploaddir, 0777, true);
			$uploaddir.= $_POST["msg_codigo"]."/";
			if (!is_dir($uploaddir))   mkdir($uploaddir, 0777, true);
			$extensao = array_reverse(explode(".", $_FILES['msg_anexo']['name']));
			$nome = $extensao[1];
			$extensao = strtolower($extensao[0]);
			
			if($extensao!="php" && $extensao!="exe" && $extensao!="js" && $extensao!="html"){
			
				$array1 = array(" ", "á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç");
				$array2 = array("_", "a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C");
				$arq = str_replace($array1, $array2, $_FILES['msg_anexo']['name']);
				
				if( is_file($uploaddir.$arq) && file_exists($uploaddir.$arq) ){
					exit("Já existem um anexo com este nome, favor escolha outro arquivo ou renomeie.");
				}
				
				if(@move_uploaded_file($_FILES['msg_anexo']['tmp_name'], $uploaddir.$arq)){
					echo '{"success":"true", "arquivo":"'.$uploaddir.$arq.'"}';
					
					if( isset($_REQUEST["ane_descricao"]) ){
						$filtro = '{"cod":"700357","params":[
							{"name":"msg_codigo","value":"'.$_POST['msg_codigo'].'","type":"integer"}
						]}';
						$datapacket->add($filtro);
						$ret = $datapacket->open(true);
						$datapacket->clear();
						if( isset($ret[0]) ){
							$obj = new StdClass();
							$obj->descricao=$_REQUEST["ane_descricao"];
							$obj->arquivo=$uploaddir.$arq;
							if(isset($ret[0]->msg_anexo) && $ret[0]->msg_anexo!=""){
								$msg_anexo = json_decode(base64_decode($ret[0]->msg_anexo));
							}else{
								$msg_anexo = array();
							}
							array_push($msg_anexo, $obj);
							$msg_anexo = base64_encode(json_encode($msg_anexo));
							$filtro = '{"cod":"700358","params":[
								{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"},
								{"name":"msg_codigo","value":"'.$_POST['msg_codigo'].'","type":"integer"}
							]}';
							$datapacket->add($filtro);
							$datapacket->open();
						}
					}
					
				}else{
					exit("Erro ao efetuar upload.");
				}
				
			}else{
				echo "Erro! extensão de arquivo inválida";
			}
		
		}
		
	}elseif(isset($_POST["acao"]) && $_POST["acao"]=="desanexar"){
		
		@unlink($_POST["arquivo"]);		

	}elseif(isset($_GET["acao"]) && $_GET["acao"]=="ler"){
		
		$filtro = '{"cod":"700325","params":[
			{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
			{"name":"msg_codigo","value":"'.$_GET["msg_codigo"].'","type":"integer"}
		]}';
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		
		//marcar boleto como lido
		if($ret[0]["men_codigo"] && $ret[0]["men_codigo"]==2 && $ret[0]["msg_anexo"] && $ret[0]["msg_anexo"]!=""){
			$filtro = '{"cod":"700348","params":[
				{"name":"msg_codigo","value":"'.$_GET["msg_codigo"].'","type":"integer"}
			]}';
			$datapacket->add($filtro);
			$vin = $datapacket->open();
			$datapacket->clear();
			//documentos vinculados a mensagem
			if(is_array($vin) && count($vin)>0){
				foreach($vin as $v){
					$filtro = '{"cod":"700355","params":[
						{"name":"doc_codigo","value":"'.$v["vin_codigo"].'","type":"string"}
					]}';
					$datapacket->add($filtro);
				}
			}
		}
		
		$filtro = '{"cod":"700328","params":[
			{"name":"msg_codigo","value":"'.$_GET["msg_codigo"].'","type":"integer"},
			{"name":"msg_ipleitura","value":"'.$_SERVER["REMOTE_ADDR"].'","type":"string"}
		]}';
		$datapacket->add($filtro);
		$datapacket->open();
		
	}elseif(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="testar"){
		
		include_once $TParams->HostRoot."class/PHPMailer_v5.1/class.phpmailer.php";
		
		$mail = new PHPMailer();
		$mail->Charset = 'UTF-8';
		$mail->IsHTML(true);
		$mail->SetLanguage("br");
		// $mail->isSMTP();
		$mail->Port = 587;
		$mail->Host = $_POST["host"];
		// $mail->isHTML(true);
		// $mail->SMTPAuth = true;
		$mail->Username = $_POST["user"];
		$mail->Password = $_POST["pass"];
		$mail->From = $_POST["user"];
		$mail->Subject = "Teste";
		$mail->AddAddress("naoresponda@site.grupouds.com.br");
		$mail->AltBody = "teste";
		$mail->Body = "teste";
		if($mail->send()){
			exit("ok");
		}else{
			exit("erro");
		}
		
	}elseif(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="enviar"){
		
		$p = base64_encode($company->emp_codigo);
		$p = substr($p, 0, 1)."9".substr($p, 1);
		
		$filtro = '{"cod":"700325","params":[
			{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
			{"name":"msg_codigo","value":"'.$_REQUEST["msg_codigo"].'","type":"integer"}
		]}';
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		
		if($ret[0]["msg_tipo"]==1){
			
			include_once $TParams->HostRoot."class/PHPMailer_v5.1/class.phpmailer.php";

			$mail = new PHPMailer();
			$mail->Charset = 'UTF-8';
			$mail->IsHTML(true);
			$mail->SetLanguage("br");
			$mail->isHTML(true);

				$mail->Port = 587;
				$mail->Host = $company->emp_hostsmtp;
				$mail->isSMTP();
				$mail->SMTPAuth = true;
				$mail->Username = $company->emp_emailremetente;
				$mail->Password = $company->emp_pwdsmtp;
			
			$mail->From = $company->emp_emailremetente;
			$mail->ReplayTo = $ret[0]["msg_remetente"];
			$mail->Sender = "return@bounce.grupouds.com.br"; //bounce para tratar retorno com erro
			$mail->FromName = $company->emp_razao;
			
			//assunto da mensagem
			$msg_assunto = $ret[0]["msg_assunto"];
			
			//corpo da mensagem, substituição de textos fixos por variaveis
			$texto = base64_decode($ret[0]["msg_conteudo"]);
			if($ret[0]["cad_nomeraz"]){
				$texto = str_replace("{{destinatario}}", utf8_decode($ret[0]["cad_nomeraz"]), $texto);
			}else{
				$texto = str_replace("{{destinatario}}", strtolower($ret[0]["msg_destinatario"]), $texto);
			}
			$texto = str_replace("{{remetente}}", utf8_decode($company->emp_razao), $texto);
			$texto = str_replace("{{logo}}", $TParams->uploads2.$company->emp_codigo."/".$company->emp_logo, $texto);
			//verificar se esta sendo informado array de textos a serem substituidos
			if( isset($_REQUEST["textos"]) ){
				if(  is_string($_REQUEST["textos"]) && (is_object(json_decode($_REQUEST["textos"])) || is_array(json_decode($_REQUEST["textos"]))) ){
					$_REQUEST["textos"] = json_decode($_REQUEST["textos"]);
					$_REQUEST["textos"] = (array) $_REQUEST["textos"];
				}
				if( is_array($_REQUEST["textos"]) && count($_REQUEST["textos"])>0 ){
					foreach( $_REQUEST["textos"] as $chave=>$valor ){
						$texto = str_replace("{{".$chave."}}", $valor, $texto);
						$msg_assunto = str_replace("{{".$chave."}}", $valor, $msg_assunto);
					}
				}
			}
			//verificar se esta sendo informado array de produtos (e-mails de e-commerce)
			if( isset($_REQUEST["produtos"]) ){
				if(  is_string($_REQUEST["produtos"]) && (is_object(json_decode($_REQUEST["produtos"])) || is_array(json_decode($_REQUEST["produtos"]))) ){
					$_REQUEST["produtos"] = json_decode($_REQUEST["produtos"]);
					$_REQUEST["produtos"] = (array) $_REQUEST["produtos"];
					if(is_object($_REQUEST["produtos"][0])){
						foreach($_REQUEST["produtos"] as $k=>$v){
							$_REQUEST["produtos"][$k] = (array) $v;
						}
					}
				}
				if( is_array($_REQUEST["produtos"]) && count($_REQUEST["produtos"])>0 ){
					if( strstr($texto, "<!-- produto -->") ){
						$htmlProd = substr($texto, (strpos($texto, "<!-- produto -->")+16), (strpos($texto, "<!-- /produto -->")-strpos($texto, "<!-- produto -->")-16) );						
						$htmlProd2="";
						foreach($_REQUEST["produtos"] as $k=>$v){
							$htmlProd2.= str_replace(array("{{foto}}", "{{produto}}", "{{qtde}}", "{{preco}}"), array($v["foto"], $v["produto"], $v["qtde"], $v["preco"]), $htmlProd);
						}
						$texto = str_replace($htmlProd, $htmlProd2, $texto);
					}
				}
			}
			// tratamento dos anexos da mensagem
			$descricao_anexo="";
			if($ret[0]["msg_anexo"] && $ret[0]["msg_anexo"]!=""){
				$msg_anexo = json_decode(base64_decode($ret[0]["msg_anexo"]));
				if(is_array($msg_anexo) && count($msg_anexo)>0){
					foreach($msg_anexo as $anexo){
						$arq = array_reverse(explode("/", $anexo->arquivo));
						$arq = $arq[0];
						if( strstr($anexo->arquivo, "http://") ){
							$uploaddir = $TParams->uploads.$TParams->getCodigo()."/mensagens/";
							if (!is_dir($uploaddir))   mkdir($uploaddir, 0777, true);
							$uploaddir.= $_POST["msg_codigo"]."/";
							if (!is_dir($uploaddir))   mkdir($uploaddir, 0777, true);
							copy($anexo->arquivo, $uploaddir.$arq);
							$mail->AddAttachment($uploaddir.$arq);
						}elseif( is_file($anexo->arquivo) ){
							$mail->AddAttachment($anexo->arquivo);
						}
						$descricao_anexo.=base64_decode($anexo->descricao)." ";
						$arq = str_replace(array("/var/www", "/home"), "http://".$TParams->HTTP_HOST, $anexo->arquivo);
						$texto = str_replace("{{link}}", "<a href='".$arq."' target='_blank'>".$arq."</a>", $texto);
					}
				}
			}
			
			$mail->Subject = utf8_decode(str_replace(array("{{destinatario}}", "{{remetente}}", "{{anexo}}"), array($ret[0]["cad_nomeraz"], $company->emp_razao,  $descricao_anexo), $msg_assunto));
			
			$texto = str_replace("{{anexo}}", $descricao_anexo, $texto);
			if( strstr($texto, "{{link}}") ) $texto = str_replace("{{link}}", "", $texto);
			
			$mensagem = "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>
			<html lang='pt-BR'>
			<head>
				<meta charset='UTF-8'>
				<meta name='viewport' content='width=device-width, initial-scale=1'>
				<meta name='apple-mobile-web-app-capable' content='yes'>
				<meta name='mobile-web-app-capable' content='yes'>
				<title>".$msg_assunto."</title>
			</head>
			<body>";
			$mensagem.= "<img style='width:1px;height:1px' src='http://".$TParams->HTTP_HOST."/desktop/php/mensagem.php?p=".$p."&acao=ler&msg_codigo=".$ret[0]["msg_codigo"]."'>"; //link de verificação de leitura
			$mensagem.= $texto;
			$mensagem.= "</body></html>";

			$mail->AddAddress(strtolower($ret[0]["msg_destinatario"]));
			$mail->AltBody = $texto;
			$mail->Body = $mensagem;
			
			if($mail->send()){
				$filtro = '{"cod":"700326","params":[
					{"name":"msg_codigo","value":"'.$_REQUEST["msg_codigo"].'","type":"integer"},
					{"name":"msg_assunto","value":"'.$msg_assunto.'","type":"string"},
					{"name":"msg_conteudo","value":"'.base64_encode($texto).'","type":"string"}
				]}';
				$datapacket->add($filtro);
				$datapacket->open();
				echo "Mensagem enviada com sucesso!";
			}
			
		}else{
			echo "Não é possível enviar mensagens do tipo selecionado.";
		}

	}elseif(isset($_POST["acao"]) && $_POST["acao"]=="selecionar"){
		
		$filtro = '{"cod":"700325","params":[
			{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
			{"name":"msg_codigo","value":"'.$_POST["msg_codigo"].'","type":"integer"}
		]}';
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		print_r(json_encode($ret));
		
	}elseif(isset($_POST["acao"]) && $_POST["acao"]=="receber"){
		
		//MARCA COMO RECEBIDA
		$filtro = '{"cod":"700386","params":[
			{"name":"msg_codigo","value":"'.$_POST['msg_codigo'].'","type":"integer"}
		]}';
		
		$datapacket->add($filtro);
		
		$datapacket->open();
		
		echo "ok";
		
	}elseif(isset($_POST["acao"]) && $_POST["acao"]=="erro"){
		
		//MARCA COMO ERRO NA ENTREGA
		$filtro = '{"cod":"700327","params":[
			{"name":"msg_status","value":"5","type":"integer"},
			{"name":"msg_codigo","value":"'.$_POST['msg_codigo'].'","type":"integer"}
		]}';
		
		$datapacket->add($filtro);
		
		$datapacket->open();
		
		echo "ok";
		
	}else{

		$busca="";
		//BUSCAR
		if( isset($_REQUEST["msg_codigo"]) && is_numeric($_REQUEST["msg_codigo"]) ){
			$busca.= ' and msg_codigo='.$_REQUEST["msg_codigo"].' ';
		}
		if( isset($_REQUEST["msg_tipo"]) && is_numeric($_REQUEST["msg_tipo"]) ){
			$busca.= ' and msg_tipo='.$_REQUEST["msg_tipo"].' ';
		}
		if( isset($_REQUEST["men_codigo"]) && is_numeric($_REQUEST["men_codigo"]) ){
			$busca.= ' and mensagem.men_codigo='.$_REQUEST["men_codigo"].' ';
		}
		if( isset($_REQUEST["cad_codigo"]) && $_REQUEST["cad_codigo"]!="" ){
			$busca.= ' and mensagem.cad_codigo = \"'.$_REQUEST["cad_codigo"].'\" ';
		}
		if( isset($_REQUEST["msg_destinatario"]) && $_REQUEST["msg_destinatario"]!="" ){
			$busca.= ' and msg_destinatario LIKE \"%'.$_REQUEST["msg_destinatario"].'%\" ';
		}
		if( isset($_REQUEST["msg_assunto"]) && $_REQUEST["msg_assunto"]!="" ){
			$busca.= ' and msg_assunto LIKE \"%'.$_REQUEST["msg_assunto"].'%\" ';
		}
		if( isset($_REQUEST["msg_dtenvio1"]) && $_REQUEST["msg_dtenvio1"]!="" && isset($_REQUEST["msg_dtenvio2"]) && $_REQUEST["msg_dtenvio2"]!="" ){
			$busca.= ' and (msg_dtenvio >= \"'.substr($_REQUEST["msg_dtenvio1"], 0, 10).' 00:00:00\" and msg_dtenvio <= \"'.substr($_REQUEST["msg_dtenvio2"], 0, 10).' 23:59:59\") ';
		}
		if( isset($_REQUEST["msg_status"]) && is_numeric($_REQUEST["msg_status"]) ){
			$busca.= ' and msg_status='.$_REQUEST["msg_status"].' ';
		}

		$filtro = '{"cod":"700323","params":[
			{"name":"busca","value":"'.$busca.'","type":"other"},
			{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
			{"name":"start","value":"'.$_REQUEST['start'].'","type":"integer"},
			{"name":"limit","value":"'.$_REQUEST['limit'].'","type":"integer"}
		]}';
		//exit($filtro);
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		
		$datapacket->clear();

		$filtro=json_decode($filtro);
		$filtro->cod='700324';
		$datapacket->add(json_encode($filtro));
		$count = $datapacket->open(true);
		// echo $datapacket->getLastQuery();
		$total = $count[0]->total;


		$obj = new StdClass();
		$obj->total=$total;
		$obj->data=$ret;

		print_r(json_encode($obj));

	}

?>