<?php 
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	
	include 'TParams.class.php';
	
	$datapacket = new TParams();
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	
	$company = $datapacket->getCompany(); //dados da empresa

	if( isset($_REQUEST['acao']) && $_REQUEST['acao']=="salvar"){
		
		//excluir parcelas anteriores
		$filtroLimpaParc = '{"cod":"700106","params":[
			{"name":"not_codigo","value":"'.$_POST["nfs_codigo"].'","type":"string"}
		]}';
		$datapacket->add($filtroLimpaParc);
		
		$datapacket->open();
		$datapacket->clear();
		
		//verifica se o numero do RPS esta sendo passado via post
		if( !isset($_POST["nfs_nrorps"]) || $_POST["nfs_nrorps"]=="" ){
			//caso nao esteja, buscar o ultimo numero cadastrado da serie informada
			$filtro = '{"cod":"700214","params":[
				{"name":"ser_codigo","value":"'.$_POST["nfs_serierps"].'","type":"string"}
			]}';
			$datapacket->add($filtro);
			$cad = $datapacket->open();
			$datapacket->clear();
			$_POST["nfs_nrorps"] = $cad[0]["nfs_nrorps"];
			// e o ultimo numero transmitido
			$filtro = '{"cod":"501034","params":[
				{"name":"nfs_serierps","value":"'.$_POST["nfs_serierps"].'","type":"string"}
			]}';
			$datapacket->add($filtro);
			$ret = $datapacket->open();
			$datapacket->clear();
			//verifica se o ultimo numero cadastrado é diferente do ultimo transmitido
			if( isset($cad[0]["nfs_nrorps"]) && isset($ret[0]["nfs_nrorps"]) && $cad[0]["nfs_nrorps"]!=($ret[0]["nfs_nrorps"]+1) ){
				$filtro = '{"cod":"501038","params":[
					{"name":"nfs_nrorps1","value":"'.$cad[0]["nfs_nrorps"].'","type":"integer"},
					{"name":"nfs_nrorps2","value":"'.($ret[0]["nfs_nrorps"]+1).'","type":"integer"},
					{"name":"nfs_serierps","value":"'.$_POST["nfs_serierps"].'","type":"string"}
				]}';
				$datapacket->add($filtro);
				$datapacket->open();
				$datapacket->clear();
				$_POST["nfs_nrorps"] = ($ret[0]["nfs_nrorps"]+1);
			}
		}
		
		//LOG DE INSERÇÃO/EDIÇÃO DA NFS-e
		$descr_log = ($_POST['log_acao_cod']==1) ? "inclusão" : "edição";
		$obs = ($_POST['log_acao_cod']==1) ? "Cadastro da NFS-e" : "Alteração dos dados da NFS-e";
		
		
		$filtrolog = '{"cod":"700103","params":[
			{"name":"log_tipo","value":"1","type":"integer"},
			{"name":"log_nro","value":"'.$_POST['nfs_codigo'].'","type":"string"},
			{"name":"log_serie","value":"'.$_POST['nfs_serierps'].'","type":"string"},
			{"name":"log_usu_login","value":"'.$_POST["usu_login"].'","type":"string"},
			{"name":"log_acao_cod","value":"'.$_POST['log_acao_cod'].'","type":"integer"},
			{"name":"log_acao_descr","value":"'.$descr_log.'","type":"string"},
			{"name":"log_data","value":"","type":"string"},
			{"name":"log_protocolo","value":"NULL","type":"other"},
			{"name":"log_ret","value":"NULL","type":"other"},
			{"name":"log_outro","value":"'.base64_encode($obs).'","type":"string"}
		]}';
		
		$nfs_issret = ( $_POST["nfs_responsavel"]=='2' ) ? '1' : '2'; //retenção do ISS pelo tomador
		$nfs_vlrissret = ( $nfs_issret=='1' ) ? $_POST["nfs_vlriss"] : '0.00';
		
		$filtro = '{"cod":"501030", "params":[
			{"name":"nfs_codigo", "value":"'.$_POST["nfs_codigo"].'", "type":"string"},
			{"name":"nfs_nrorps", "value":"'.$_POST["nfs_nrorps"].'", "type":"integer"},
			{"name":"nfs_serierps", "value":"'.$_POST["nfs_serierps"].'", "type":"string"},
			{"name":"nfs_tiporps", "value":"1", "type":"integer"},
			{"name":"nfs_dtemissao", "value":"'.date("Y-m-d H:i:s").'", "type":"string"},
			{"name":"nfs_dtprestacao", "value":"'.implode("-", array_reverse( explode("/", substr($_POST['nfs_dtprestacao'],0,10)))).' '.date("H:i:s").'", "type":"string"},
			{"name":"nfs_dtfaturam", "value":"NULL", "type":"other"},';
		$filtro.= ( isset($_POST["nfs_nrorpssub"]) && $_POST["nfs_nrorpssub"]!='' ) ? '{"name":"nfs_nrorpssub", "value":"'.$_POST["nfs_nrorpssub"].'", "type":"integer"},' : '{"name":"nfs_nrorpssub", "value":"NULL", "type":"other"},';
		$filtro.= ( isset($_POST["nfs_serierpssub"]) && $_POST["nfs_serierpssub"]!='' ) ? '{"name":"nfs_serierpssub", "value":"'.$_POST["nfs_serierpssub"].'", "type":"string"},' : '{"name":"nfs_serierpssub", "value":"NULL", "type":"other"},';
		$filtro.= ( isset($_POST["nfs_tiporpssub"]) && $_POST["nfs_tiporpssub"]!='' ) ? '{"name":"nfs_tiporpssub", "value":"'.$_POST["nfs_tiporpssub"].'", "type":"integer"},' : '{"name":"nfs_tiporpssub", "value":"NULL", "type":"other"},';
		$filtro.= ( isset($_POST["nfs_dtrpssub"]) && $_POST["nfs_dtrpssub"]!=0 ) ? '{"name":"nfs_dtrpssub", "value":"'.implode("-", array_reverse( explode("/", substr($_POST['nfs_dtrpssub'],0,10)))).' '.date("H:i:s").'", "type":"string"},' : '{"name":"nfs_dtrpssub", "value":"NULL", "type":"other"},';
		$filtro.= '{"name":"nfs_vlrservico", "value":"'.$_POST["nfs_vlrservico"].'", "type":"float"},
			{"name":"nfs_vlrdeducao", "value":"'.$_POST["nfs_vlrdeducao"].'", "type":"float"},
			{"name":"nfs_vlrpis", "value":"'.$_POST["nfs_vlrpis"].'", "type":"float"},
			{"name":"nfs_vlrcofins", "value":"'.$_POST["nfs_vlrcofins"].'", "type":"float"},
			{"name":"nfs_vlrinss", "value":"'.$_POST["nfs_vlrinss"].'", "type":"float"},
			{"name":"nfs_vlrir", "value":"'.$_POST["nfs_vlrir"].'", "type":"float"},
			{"name":"nfs_vlrcsll", "value":"'.$_POST["nfs_vlrcsll"].'", "type":"float"},
			{"name":"nfs_issret", "value":"'.$nfs_issret.'", "type":"integer"},
			{"name":"nfs_vlriss", "value":"'.$_POST["nfs_vlriss"].'", "type":"float"},
			{"name":"nfs_vlrissret", "value":"'.$nfs_vlrissret.'", "type":"float"},
			{"name":"nfs_basecalc", "value":"'.($_POST["nfs_vlrservico"] - $_POST["nfs_vlrdeducao"]).'", "type":"float"},
			{"name":"nfs_vlrliqnfse", "value":"'.$_POST["nfs_vlrservico"].'", "type":"float"},
			{"name":"nfs_descincond", "value":"0.00", "type":"float"},
			{"name":"nfs_desccond", "value":"0.00", "type":"float"},
			{"name":"nfs_aliqiss", "value":"'.$_POST["nfs_aliqiss"].'", "type":"float"},
			{"name":"nfs_aliqpis", "value":"'.$_POST["nfs_aliqpis"].'", "type":"float"},
			{"name":"nfs_aliqcofins", "value":"'.$_POST["nfs_aliqcofins"].'", "type":"float"},
			{"name":"nfs_aliqinss", "value":"'.$_POST["nfs_aliqinss"].'", "type":"float"},
			{"name":"nfs_aliqir", "value":"'.$_POST["nfs_aliqir"].'", "type":"float"},
			{"name":"nfs_aliqcsll", "value":"'.$_POST["nfs_aliqcsll"].'", "type":"float"},
			{"name":"nfs_coditnlistserv", "value":"'.$_POST["nfs_coditnlistserv"].'", "type":"string"},
			{"name":"nfs_descrserv", "value":"'.base64_encode(utf8_decode($_POST["nfs_descrserv"])).'", "type":"string"},
			{"name":"nfs_tomador", "value":"'.$_POST["nfs_tomador"].'", "type":"string"},
			{"name":"nfs_intermediario", "value":"NULL", "type":"other"},
			{"name":"nfs_nronfsesubst", "value":"NULL", "type":"other"},
			{"name":"nfs_dtnfsesubst", "value":"NULL", "type":"other"},
			{"name":"nfs_serieprest", "value":"NULL", "type":"other"},
			{"name":"nfs_motcanc", "value":"NULL", "type":"other"},
			{"name":"nfs_operacao", "value":"NULL", "type":"other"},
			{"name":"nfs_codobra", "value":"NULL", "type":"other"},
			{"name":"nfs_art", "value":"NULL", "type":"other"},
			{"name":"nfs_deducpor", "value":"NULL", "type":"other"},
			{"name":"nfs_tpded", "value":"NULL", "type":"other"},
			{"name":"nfs_cpfcnpjref", "value":"NULL", "type":"other"},
			{"name":"nfs_nronfref", "value":"NULL", "type":"other"},
			{"name":"nfs_vlrtotref", "value":"0.00", "type":"float"},
			{"name":"nfs_percded", "value":"NULL", "type":"other"},
			{"name":"nfs_tributavel", "value":"NULL", "type":"other"},';
		$filtro.= ( isset($_POST["ccu_codigo"]) && $_POST["ccu_codigo"]!='' ) ? '{"name":"ccu_codigo", "value":"'.$_POST["ccu_codigo"].'", "type":"string"},' : '{"name":"ccu_codigo", "value":"NULL", "type":"other"},';
		$filtro.= ( isset($_POST["plc_codigo"]) && $_POST["plc_codigo"]!='' ) ? '{"name":"plc_codigo", "value":"'.$_POST["plc_codigo"].'", "type":"string"},' : '{"name":"plc_codigo", "value":"NULL", "type":"other"},';
		$filtro.= ( isset($_POST["cta_codigo"]) && $_POST["cta_codigo"]!='' ) ? '{"name":"cta_codigo", "value":"'.$_POST["cta_codigo"].'", "type":"integer"},' : '{"name":"cta_codigo", "value":"NULL", "type":"other"},';
		$filtro.= ( isset($_POST["nfs_vendedor"]) && $_POST["nfs_vendedor"]!='' ) ? '{"name":"nfs_vendedor", "value":"'.$_POST["nfs_vendedor"].'", "type":"string"},' : '{"name":"nfs_vendedor", "value":"NULL", "type":"other"},';
		$filtro.= '{"name":"cdp_codigo", "value":"'.$_POST["cdp_codigo"].'", "type":"integer"},
			{"name":"nfs_exigibilidadeiss", "value":"'.$_POST["nfs_exigibilidadeiss"].'", "type":"integer"},
			{"name":"nfs_responsavel", "value":"'.$_POST["nfs_responsavel"].'", "type":"integer"},
			{"name":"nfs_situacao", "value":"0", "type":"integer"},';
		$filtro.= ( isset($_POST["lic_codigo"]) && $_POST["lic_codigo"]!='' ) ? '{"name":"lic_codigo", "value":"'.$_POST["lic_codigo"].'", "type":"integer"},' : '{"name":"lic_codigo", "value":"NULL", "type":"other"},';
		$filtro.= ( isset($_POST["ctt_codigo"]) && $_POST["ctt_codigo"]!='' ) ? '{"name":"ctt_codigo", "value":"'.$_POST["ctt_codigo"].'", "type":"integer"}' : '{"name":"ctt_codigo", "value":"NULL", "type":"other"}';
		$filtro.= ']}';
		
		$datapacket->add($filtro);
		$datapacket->add($filtrolog);
		
		
		if( isset($_POST["parcelas"]) ){
			
			$parcelas = json_decode(base64_decode($_POST["parcelas"]));
			
			if( is_array($parcelas) ){
				
				$doc_codigo  = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 12);
				
				foreach ($parcelas as $parc) {
					
					$doc_codigo2 = $doc_codigo + ($parc->{'doc_nparc'}-1);
					$descritivo = "NFS-e nro {{nro}}";
					$descritivo.= (count($parcelas)>1) ? "- parcela ".$parc->{'doc_nparc'} : "";
					$doc_numero = "NFSE".$_POST["nfs_nrorps"];
					
					//PARCELA
					$filtroParc  = '{"cod":"500133", "params":[
						{"name":"doc_codigo", "value":"'.$doc_codigo2.'", "type":"string"},
						{"name":"doc_numero", "value":"'.$doc_numero.'-'.$parc->{'doc_nparc'}.'", "type":"string"},
						{"name":"doc_tipo", "value":"'.$parc->{'doc_tipo'}.'", "type":"integer"},
						{"name":"doc_pagrec", "value":"2", "type":"integer"},
						{"name":"doc_data", "value":"'.date('Y-m-d').' 00:00:00", "type":"string"},
						{"name":"doc_valor", "value":"'.$parc->{'doc_valor'}.'", "type":"float"},
						{"name":"doc_dtvcto", "value":"'.$parc->{'doc_dtvcto'}.'", "type":"string"},
						{"name":"doc_dtpgto", "value":"NULL", "type":"other"},
						{"name":"doc_vlrpg", "value":"NULL", "type":"other"},
						{"name":"doc_descr", "value":"'.$descritivo.'", "type":"string"},
						{"name":"doc_status", "value":"0", "type":"integer"},
						{"name":"doc_codbar", "value":" ", "type":"string"},
						{"name":"doc_linhadig", "value":"NULL", "type":"other"},
						{"name":"doc_banco", "value":"NULL", "type":"other"},
						{"name":"doc_agencia", "value":"NULL", "type":"other"},
						{"name":"doc_conta", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($company->emp_multa) && $company->emp_multa>0 ) ? '{"name":"doc_multa", "value":"'.$company->emp_multa.'", "type":"float"},' : '{"name":"doc_multa", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($company->emp_jurosdiario) && $company->emp_jurosdiario>0 ) ? '{"name":"doc_juros", "value":"'.$company->emp_jurosdiario.'", "type":"float"},' : '{"name":"doc_juros", "value":"NULL", "type":"other"},';
					$filtroParc.= '{"name":"doc_honorarios", "value":"NULL", "type":"other"},
						{"name":"doc_dias_envio", "value":"0", "type":"integer"},
						{"name":"doc_nparc", "value":"'.$parc->{'doc_nparc'}.'", "type":"integer"},
						{"name":"doc_tparc", "value":"'.(count($parcelas)).'", "type":"integer"},
						{"name":"doc_json_parcial", "value":"NULL", "type":"other"},
						{"name":"doc_obs", "value":"'.$descritivo.'", "type":"string"},
						{"name":"cad_codigo", "value":"'.$_POST["nfs_tomador"].'", "type":"string"},
						{"name":"ser_codigo", "value":"'.$_POST["nfs_serierps"].'", "type":"string"},';
					$filtroParc.= ( isset($_POST['ccu_codigo']) && $_POST['ccu_codigo']!='' ) ? '{"name":"ccu_codigo","value":"'.$_POST['ccu_codigo'].'","type":"string"},' : '{"name":"ccu_codigo","value":"NULL","type":"other"},';
					$filtroParc.= '{"name":"doc_cod_pai", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($_POST['plc_codigo']) && $_POST['plc_codigo']!='' ) ? '{"name":"plc_codigo", "value":"'.$_POST['plc_codigo'].'", "type":"string"},' : '{"name":"plc_codigo", "value":"NULL", "type":"other"},';
					$filtroParc.= '{"name":"cad_codatend", "value":"NULL", "type":"other"},
						{"name":"doc_carteira", "value":"'.$parc->{"doc_carteira"}.'", "type":"string"},
						{"name":"doc_nossonumero", "value":"NULL", "type":"other"},
						{"name":"svc_codigo", "value":"NULL", "type":"other"},
						{"name":"doc_sacador", "value":"NULL", "type":"other"},';
					$filtroParc.= (isset($_POST['cta_codigo']) && $_POST['cta_codigo']!='') ? '{"name":"cta_codigo","value":"'.$_POST['cta_codigo'].'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
					$filtroParc.= '{"name":"doc_dias_protesto", "value":"NULL", "type":"other"},';
					$filtroParc.= '{"name":"doc_protesto", "value":"NULL", "type":"other"},
						{"name":"doc_previsao", "value":"0", "type":"integer"},
						{"name":"doc_origem", "value":"8", "type":"integer"},
						{"name":"doc_origem_codigo", "value":"'.$_POST["nfs_codigo"].'", "type":"string"}';
					$filtroParc.= ']}';
					
					$datapacket->add($filtroParc);
					
					//VINCULO NF-e -> PARCELA
					$filtroParcNota = '{"cod":"700107","params":[
						{"name":"not_codigo","value":"'.$_POST["nfs_codigo"].'","type":"string"},
						{"name":"doc_codigo","value":"'.$doc_codigo2.'","type":"string"}
					]}';
					$datapacket->add($filtroParcNota);
					
				}
			}
		}
		
		//ATUALIZAR A OS, QUANDO FOR O CASO DE UMA NFS-E EMITIDA A PARTIR DE UMA OS
		if( isset($_POST["ose_codigo"]) && $_POST["ose_codigo"]!="" ){
			$datapacket2 = new TParams();
			$datapacket2->setHost($datapacket2->getHost($datapacket2->getDbSge()));
			$filtroobs = '{"cod":"700263","params":[
				{"name":"ose_codigo","value":"'.$_POST["ose_codigo"].'","type":"integer"}
			]}';
			$datapacket2->add($filtroobs);
			$res = $datapacket2->open();
			$ose_obs = json_decode(base64_decode($res[0]["ose_obs"]));
			if(!is_array($ose_obs)) $ose_obs = array();
			$pos = (count($ose_obs)>0) ? count($ose_obs) : 0; 
			$ose_obs[$pos] =  new StdClass();
			$ose_obs[$pos]->obs_ordem = $pos;
			$ose_obs[$pos]->obs_tipo = 0;
			$ose_obs[$pos]->obs_obs = base64_encode("NFS-e de RPS nro ".$_POST["nfs_nrorps"]." - serie ".$_POST["nfs_serierps"]." foi emitida a partir desta OS.");
			$ose_obs[$pos]->usu_login = "";
			$ose_obs[$pos]->usu_nome = "SISTEMA";
			$ose_obs[$pos]->obs_data = date("Y-m-d H:i:s");
			$filtroos = '{"cod":"700239","params":[
				{"name":"ose_codigo","value":"'.$_POST["ose_codigo"].'","type":"integer"},
				{"name":"nfs_codigo","value":"'.$_POST["nfs_codigo"].'","type":"string"},
				{"name":"ose_obs","value":"'.base64_encode(json_encode($ose_obs)).'","type":"string"}
			]}';
			$datapacket->add($filtroos);
		}
		
		/*
		$filtroSerie = '{"cod":"501032", "params":[
			{"name":"ser_codigo", "value":"'.$_POST["nfs_serierps"].'", "type":"string"},
			{"name":"ser_nfse_num", "value":"'.$_POST["nfs_nrorps"].'", "type":"integer"}
		]}';
		$datapacket->add($filtroSerie);
		*/
		
		$ret = $datapacket->open();
		$datapacket->clear();
		
		//solicitação de transmissão automática (somente rotina) - sem retorno
		if( isset($_POST["auto"]) && $_POST["auto"]==true ){
			
			$url_nfse = 'http://prn.grupouds.com.br/'; //endereço NFS-e
			$p = base64_encode($company->emp_codigo);
			$p = substr($p, 0, 1)."2".substr($p, 1);
			
			//criar nfs-e
			$nfse = array(
				'host'=>base64_encode($_SERVER["HTTP_HOST"]),
				'emp_codigo'=>$company->emp_codigo,
				'usu_login'=>'SISTEMA',
				'nfs_codigo'=>$_POST["nfs_codigo"]
			);
			$ch = curl_init();
			curl_setopt($ch,CURLOPT_URL, $url_nfse."php/nfse.php");
			curl_setopt($ch,CURLOPT_POST, count($nfse));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $nfse);
			curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
			curl_exec($ch);
			curl_close($ch);
			
			//verificar retorno da aplicação
			$nfse = array(
				'host'=>base64_encode($_SERVER["HTTP_HOST"]),
				'emp_codigo'=>$company->emp_codigo,
				'nfs_codigo'=>$_POST["nfs_codigo"],
				'nfs_serierps'=>$_POST["nfs_serierps"],
				'usu_login'=>'SISTEMA',
				'nfs_nrorps'=>$_POST["nfs_nrorps"]
			);
			$ch = curl_init();
			curl_setopt($ch,CURLOPT_URL, $url_nfse."php/nfse_retorno.php");
			curl_setopt($ch,CURLOPT_POST, count($nfse));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $nfse);
			curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
			$result = curl_exec($ch);
			// echo $result;
			curl_close($ch);
			
			if($result=="OK"){
				//consulta status nfs-e por nro de rps
				$nfse = array(
					'host'=>base64_encode($_SERVER["HTTP_HOST"]),
					'emp_codigo'=>$company->emp_codigo,
					'nfs_codigo'=>$_POST["nfs_codigo"],
					'nfs_serierps'=>$_POST["nfs_serierps"],
					'nfs_nrorps'=>$_POST["nfs_nrorps"],
					'usu_login'=>'SISTEMA',
					'nfs_tiporps'=>'1'
				);
				$ch = curl_init();
				curl_setopt($ch,CURLOPT_URL, $url_nfse."php/nfse_consulta.php");
				curl_setopt($ch,CURLOPT_POST, count($nfse));
				curl_setopt($ch,CURLOPT_POSTFIELDS, $nfse);
				curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
				curl_exec($ch);
				curl_close($ch);
			}elseif( substr($result, 0, 10)=="Protocolo=" ){
				//consulta de lote por numero de protocolo
				$nfse = array(
					'host'=>base64_encode($_SERVER["HTTP_HOST"]),
					'emp_codigo'=>$company->emp_codigo,
					'nfs_codigo'=>$_POST["nfs_codigo"],
					'nfs_serierps'=>$_POST["nfs_serierps"],
					'nfs_nrorps'=>$_POST["nfs_nrorps"],
					'nfs_tiporps'=>$_POST["nfs_tiporps"],
					'usu_login'=>'SISTEMA',
					'protocolo'=>substr($result,10)
				);
				$ch = curl_init();
				curl_setopt($ch,CURLOPT_URL, $url_nfse."php/nfse_consulta.php");
				curl_setopt($ch,CURLOPT_POST, count($nfse));
				curl_setopt($ch,CURLOPT_POSTFIELDS, $nfse);
				curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
				curl_exec($ch);
				curl_close($ch);
			}
			
			//impressao NFS-e
			$nfse = array(
				'host'=>base64_encode($_SERVER["HTTP_HOST"]),
				'emp_codigo'=>$company->emp_codigo,
				'emp_cpfcnpj'=>$company->emp_cpfcnpj,
				'nfs_nrorps'=>$_POST["nfs_nrorps"],
				'nfs_dtemissao'=>date("Y-m"),
				'email'=>''
			);
			$ch = curl_init();
			curl_setopt($ch,CURLOPT_URL, $url_nfse."php/nfse_gerarPdf.php");
			curl_setopt($ch,CURLOPT_POST, count($nfse));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $nfse);
			curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
			curl_exec($ch);
			curl_close($ch);			
			
			//modelo de e-mail
			$filtro = '{"cod":"700268","params":[
				{"name":"dbcomum","value":"'.$company->emp_db_comum.'","type":"other"},
				{"name":"men_codigo","value":"8","type":"integer"}
			]}';
			$datapacket->add($filtro);
			$msg = $datapacket->open(true);
			$datapacket->clear();
			
			//salvar e enviar mensagem de e-mail
			$msg_destinatario = ( isset($_POST["email"]) && $_POST["email"]!="" ) ? $_POST["email"] : "";
			if( $msg_destinatario!="" ){
				
				$msg_anexo = base64_encode("[{\"descricao\" : \"".base64_encode(utf8_decode("NFS-e de RPS nro ".$_POST["nfs_nrorps"]))."\", \"arquivo\" : \"http://prn.grupouds.com.br/MODELO/x-nfse-".$_POST["nfs_nrorps"].'_consulta.xml.pdf'."\" }]");
				
				$filtro = '{"cod":"700321","params":[
					{"name":"msg_codigo","value":"","type":"string"},
					{"name":"msg_tipo","value":"1","type":"integer"},
					{"name":"men_codigo","value":"8","type":"integer"},
					{"name":"msg_remetente","value":"'.$msg[0]->men_remetente.'","type":"string"},
					{"name":"msg_destinatario","value":"'.strtolower($msg_destinatario).'","type":"string"},
					{"name":"cad_codigo","value":"'.$_POST["cad_codigo"].'","type":"string"},
					{"name":"msg_assunto","value":"'.$msg[0]->men_assunto.'","type":"string"},
					{"name":"msg_conteudo","value":"'.utf8_decode($msg[0]->men_conteudo).'","type":"string"},
					{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"msg_status","value":"0","type":"integer"},
					{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
				]}';
				$datapacket->add($filtro);
				$msg = $datapacket->open(false, true);
				$datapacket->clear();
				//enviar mensagem de e-mail com aviso de bloqueio do serviço
				if($msg){
					//requisição para envio da mensagem
					$fields = array(
						'p' => $p,
						'acao' => 'enviar',
						'msg_codigo' => $msg
					);

					//url-ify os dados para o POST
					$fields_string="";
					foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
					rtrim($fields_string, '&');

					//abrir conexao
					$ch = curl_init();

					//define url, numero de variaveis POST e dados POST
					curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
					curl_setopt($ch,CURLOPT_POST, count($fields));
					curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

					//executa POST
					$result = curl_exec($ch);

					//fechar conexao
					curl_close($ch);
				}
			}
			
		}else{
		
			echo "OK";
			
		}
		exit();
	
	//selecionar nota pelo codigo
	}elseif(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="selecionar"){
		
		$filtro = '{"cod":"501031","params":[
			{"name":"nfs_codigo","value":"'.$_POST["nfs_codigo"].'","type":"string"}
		]}';
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		print_r(json_encode($ret));
	
	//validar ultimo numero de RPS
	}elseif(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="validar"){

		$filtro = '{"cod":"501034","params":[
			{"name":"nfs_serierps","value":"'.$_POST["nfs_serierps"].'","type":"string"}
		]}';
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		
		if( $ret && $ret[0] && $ret[0]["nfs_nrorps"] ){
			//caso a ultima nota autorizada possua numero de RPS diferente, inverte os numeros de RPS
			if( ($ret[0]["nfs_nrorps"]+1) != (int) $_POST["nfs_nrorps"] ){
				
				$filtro = '{"cod":"501038","params":[
					{"name":"nfs_nrorps1","value":"'.$_POST["nfs_nrorps"].'","type":"integer"},
					{"name":"nfs_nrorps2","value":"'.($ret[0]["nfs_nrorps"]+1).'","type":"integer"},
					{"name":"nfs_serierps","value":"'.$_POST["nfs_serierps"].'","type":"string"}
				]}';
				$datapacket->add($filtro);
				$datapacket->open();
				$datapacket->clear();
				
				$filtro = '{"cod":"501035","params":[
					{"name":"nfs_nrorps","value":"'.($ret[0]["nfs_nrorps"]+1).'","type":"integer"},
					{"name":"nfs_codigo","value":"'.$_POST["nfs_codigo"].'","type":"string"}
				]}';
				$datapacket->add($filtro);
				$datapacket->open();
				
				exit("rps=".($ret[0]["nfs_nrorps"]+1));
				
			}
		}
	
	}else{ //busca geral
		
		$busca="";
		
		if( isset($_REQUEST['nfs_nrorps']) ){
			$busca .= " and header_nfse.nfs_nrorps LIKE '".$_REQUEST['nfs_nrorps']."%' ";
		}
		if( isset($_REQUEST['nfs_tomador']) && $_REQUEST['nfs_tomador']!="" ){
			$busca.= " and header_nfse.nfs_tomador = '".$_REQUEST['nfs_tomador']."' ";
		}
		if( isset($_REQUEST['nfs_dtemissao1']) && $_REQUEST['nfs_dtemissao1']!="" && isset($_REQUEST['nfs_dtemissao2']) && $_REQUEST['nfs_dtemissao2']!="" ){
			$busca.= " and header_nfse.nfs_dtemissao between '".implode("-",array_reverse(explode("/",substr($_REQUEST['nfs_dtemissao1'],0,10))))." 00:00:00' and '".implode("-",array_reverse(explode("/",substr($_REQUEST['nfs_dtemissao2'],0,10))))." 23:59:59' ";
		}
		if( isset($_REQUEST['nfs_vlrservico']) && $_REQUEST['nfs_vlrservico']>0){
			$busca.= " and header_nfse.nfs_vlrservico = ".$_REQUEST['nfs_vlrservico']." ";
		}
		
		$filtro = '{"cod":"501033","params":[
			{"name":"nfs_codigo","value":"'.$busca.'","type":"other"},
			{"name":"db","value":"'.$datapacket->getDb().'","type":"other"}
		]}';

		$datapacket->add($filtro);
		$ret = $datapacket->open();
		print_r(json_encode($ret));

	}




?>