<?php 
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	
	include_once('TParams.class.php');
	$datapacket = new TParams();

	if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="salvar"){
		
		if(isset($_REQUEST['dados'])&&!empty($_REQUEST['dados'])){
			
			$dados = json_decode(base64_decode($_REQUEST['dados']));
			
			$cad_codigo = ""; 
			if(isset($dados->{'cad_codigo'})&&!empty($dados->{'cad_codigo'})){
				$cad_codigo = $dados->{'cad_codigo'};
			}

			$ptr_codigo = ""; 	
			if(isset($dados->{'ptr_codigo'})&&!empty($dados->{'ptr_codigo'})){
				$ptr_codigo = $dados->{'ptr_codigo'};
			}

			$ptr_identificacao = "";	
			if(isset($dados->{'ptr_identificacao'})&&!empty($dados->{'ptr_identificacao'})){
				$ptr_identificacao = $dados->{'ptr_identificacao'}; 
			}

			$mar_codigo = "";	
			if(isset($dados->{'mar_codigo'})&&!empty($dados->{'mar_codigo'})){
				$mar_codigo = $dados->{'mar_codigo'}; 
			}

			$cor_codigo = "";	
			if(isset($dados->{'cor_codigo'})&&!empty($dados->{'cor_codigo'})){
				$cor_codigo = $dados->{'cor_codigo'}; 
			}

			$tpr_codigo = "";	
			if(isset($dados->{'tpr_codigo'})&&!empty($dados->{'tpr_codigo'})){
				$tpr_codigo = $dados->{'tpr_codigo'}; 
			}

			$ptr_hodometro = "";	
			if(isset($dados->{'ptr_hodometro'})&&!empty($dados->{'ptr_hodometro'})){
				$ptr_hodometro = strtoupper($dados->{'ptr_hodometro'}); 
			}

			$filtro = '{"cod":"501042", "params":[
				{"name":"ptr_codigo","value":"'.$ptr_codigo.'","type":"integer"},
				{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
				{"name":"ptr_identificacao","value":"'.$ptr_identificacao.'","type":"string"},
				{"name":"mar_codigo","value":"'.$mar_codigo.'","type":"integer"},
				{"name":"tpr_codigo","value":"'.$tpr_codigo.'","type":"integer"},
				{"name":"ptr_dataCad","value":"'.date("Y-m-d H:i:s").'","type":"string"},
				{"name":"ptr_status","value":"ativo","type":"string"},
				{"name":"ptr_complemento1","value":"null","type":"other"},
				{"name":"ptr_complemento2","value":"null","type":"other"},
				{"name":"ptr_detalhes","value":"null","type":"other"},
				{"name":"ptr_dataCompra","value":"null","type":"other"},
				{"name":"ptr_valorCompra","value":"null","type":"other"},
				{"name":"ptr_valorAtual","value":"null","type":"other"},
				{"name":"ptr_valorizacao","value":"null","type":"other"},
				{"name":"ptr_obs","value":"null","type":"other"},
				{"name":"cor_codigo","value":"'.$cor_codigo.'","type":"integer"},
				{"name":"ptr_hodometro","value":"'.$ptr_hodometro.'","type":"string"}		
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			if(empty($ptr_codigo)){
				$ptr_codigo = $datapacket->open(false, true);
			}else{
				$datapacket->open();
			}
			$datapacket->clear();

			$ors_codigo = "";	
			if(isset($dados->{'ors_codigo'})&&!empty($dados->{'ors_codigo'})){
				$ors_codigo = $dados->{'ors_codigo'};
			}
			
			$ors_vendedor = "";	
			if(isset($dados->{'ors_vendedor'})&&!empty($dados->{'ors_vendedor'})){
				$ors_vendedor = $dados->{'ors_vendedor'};
			}

			$mdl_codigo = "";	
			if(isset($dados->{'mdl_codigo'})&&!empty($dados->{'mdl_codigo'})){
				$mdl_codigo = $dados->{'mdl_codigo'};
			}

			$filtro = '{"cod":"501050", "params":[
				{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"},
				{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
				{"name":"ptr_codigo","value":"'.$ptr_codigo.'","type":"string"},
				{"name":"mdl_codigo","value":"'.$mdl_codigo.'","type":"string"},
				{"name":"ors_vendedor","value":"'.$ors_vendedor.'","type":"string"},
				{"name":"ors_status","value":"1","type":"integer"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$datapacket->open(true);
			$datapacket->clear();

			if(isset($dados->{'item_osdef'})&&!empty($dados->{'item_osdef'})){

				foreach ($dados->{'item_osdef'} as $item_osdef) {
					$filtro = '{"cod":"501051", "params":[
						{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"},
						{"name":"iod_seq","value":"'.$item_osdef->{'iod_seq'}.'","type":"integer"},
						{"name":"iod_descr","value":"'.$item_osdef->{'iod_descr'}.'","type":"string"},
						{"name":"iod_status","value":"'.$item_osdef->{'iod_status'}.'","type":"integer"},
						{"name":"iod_orc","value":"'.$item_osdef->{'iod_orc'}.'","type":"integer"},
						{"name":"iod_obs","value":"'.$item_osdef->{'iod_obs'}.'","type":"string"},
						{"name":"iod_obtec","value":"null","type":"other"}
					]}';
					$datapacket->add($filtro);
				}
				$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
				$datapacket->open(true);
				$datapacket->clear();
			}

			echo "ok";
			exit();
		}		
		echo "erro";

	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="salvar_orcamento"){
		
		if(isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])){

			$dados = json_decode(base64_decode($_REQUEST['dados']));

			$ors_codigo = "";
			if(isset($dados->{'ors_codigo'})&&!empty($dados->{'ors_codigo'})){
				$ors_codigo = $dados->{'ors_codigo'};
			}
			$cdp_codigo = "";
			if(isset($dados->{'cdp_codigo'})&&!empty($dados->{'cdp_codigo'})){
				$cdp_codigo = $dados->{'cdp_codigo'};
			}
			$ors_desc = "";
			if(isset($dados->{'ors_desc'})&&!empty($dados->{'ors_desc'})){
				$ors_desc = $dados->{'ors_desc'};
			}
			$ors_total = "";
			if(isset($dados->{'ors_total'})&&!empty($dados->{'ors_total'})){
				$ors_total = $dados->{'ors_total'};
			}
			$ors_acres = "";
			if(isset($dados->{'ors_acres'})&&!empty($dados->{'ors_acres'})){
				$ors_acres = $dados->{'ors_acres'};
			}
			$ors_subtotal = "";
			if(isset($dados->{'ors_subtotal'})&&!empty($dados->{'ors_subtotal'})){
				$ors_subtotal = $dados->{'ors_subtotal'};
			}

			$filtro = '{"cod":"501054", "params":[
				{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"},
				{"name":"cdp_codigo","value":"'.$cdp_codigo.'","type":"integer"},
				{"name":"ors_desc","value":"'.$ors_desc.'","type":"float"},
				{"name":"ors_total","value":"'.$ors_total.'","type":"float"},
				{"name":"ors_acres","value":"'.$ors_acres.'","type":"float"},
				{"name":"ors_subtotal","value":"'.$ors_subtotal.'","type":"float"},
				{"name":"ors_status","value":"2","type":"integer"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$ret = $datapacket->open(true);
			$datapacket->clear();

			$filtro = '{"cod":"501065", "params":[
				{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"}
			]}';
			$datapacket->add($filtro);
			$filtro = '{"cod":"501066", "params":[
				{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"}
			]}';
			$datapacket->add($filtro);
			$filtro = '{"cod":"501067", "params":[
				{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"}
			]}';
			$datapacket->add($filtro);
			$datapacket->open();
			$datapacket->clear();

			if(isset($dados->{'item_osdef'})&&!empty($dados->{'item_osdef'})){

				foreach ($dados->{'item_osdef'} as $item_osdef) {
					$filtro = '{"cod":"501051", "params":[
						{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"},
						{"name":"iod_seq","value":"'.$item_osdef->{'iod_seq'}.'","type":"integer"},
						{"name":"iod_descr","value":"'.$item_osdef->{'iod_descr'}.'","type":"string"},
						{"name":"iod_status","value":"'.$item_osdef->{'iod_status'}.'","type":"integer"},
						{"name":"iod_orc","value":"'.$item_osdef->{'iod_orc'}.'","type":"integer"},
						{"name":"iod_obs","value":"'.$item_osdef->{'iod_obs'}.'","type":"string"},
						{"name":"iod_obtec","value":"'.$item_osdef->{'iod_obstec'}.'","type":"string"}
					]}';
					$datapacket->add($filtro);
				}
				$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
				$datapacket->open(true);
				$datapacket->clear();
			}

			if(isset($dados->{'item_osserv'})&&!empty($dados->{'item_osserv'})){
				foreach ($dados->{'item_osserv'} as $item_osserv) {
					$filtro = '{"cod":"501055", "params":[
						{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"},
						{"name":"svc_codigo","value":"'.$item_osserv->{'svc_codigo'}.'","type":"string"},
						{"name":"ios_valor","value":"'.$item_osserv->{'ios_valor'}.'","type":"float"},
						{"name":"ios_qtde","value":"'.$item_osserv->{'ios_qtde'}.'","type":"float"},
						{"name":"ios_desc","value":"'.$item_osserv->{'ios_desc'}.'","type":"float"},
						{"name":"ios_subtotal","value":"'.$item_osserv->{'ios_subtotal'}.'","type":"float"},
						{"name":"ios_obs","value":"'.$item_osserv->{'ios_obs'}.'","type":"string"}
					]}';
					$datapacket->add($filtro);
				}
				$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
				$datapacket->open(true);
				$datapacket->clear();
			}

			if(isset($dados->{'item_os'})&&!empty($dados->{'item_os'})){
				foreach ($dados->{'item_os'} as $item_os) {
					$filtro = '{"cod":"501056", "params":[
						{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"},
						{"name":"ref_codigo","value":"'.$item_os->{'ref_codigo'}.'","type":"integer"},
						{"name":"ito_ordem","value":"'.$item_os->{'ito_ordem'}.'","type":"integer"},
						{"name":"ito_descr","value":"'.$item_os->{'ito_descr'}.'","type":"string"},
						{"name":"ito_qtde","value":"'.$item_os->{'ito_qtde'}.'","type":"float"},
						{"name":"ito_valor","value":"'.$item_os->{'ito_valor'}.'","type":"float"},
						{"name":"ito_subtotal","value":"'.$item_os->{'ito_subtotal'}.'","type":"float"},
						{"name":"ito_desc","value":"'.$item_os->{'ito_desc'}.'","type":"float"},
						{"name":"ito_obs","value":"'.$item_os->{'ito_obs'}.'","type":"string"}
					]}';
					$datapacket->add($filtro);
				}
				$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
				$datapacket->open(true);
				$datapacket->clear();
			}

			echo "ok";
			exit();
		}
		echo "erro";

	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="findById"){
		
		if(isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])){

			$dados = json_decode(base64_decode($_REQUEST['dados']));

			$ptr_identificacao = "";
			if(isset($dados->{'ptr_identificacao'})&&!empty($dados->{'ptr_identificacao'})){
				$ptr_identificacao = $dados->{'ptr_identificacao'};
			}

			$filtro = '{"cod":"501045", "params":[
				{"name":"ptr_identificacao","value":"'.$ptr_identificacao.'","type":"string"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$ret = $datapacket->open(true);
			print_r(json_encode($ret));
		}

	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="abrirOs"){
		
		if(isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])){

			$dados = json_decode(base64_decode($_REQUEST['dados']));

			$ors_codigo = "";
			if(isset($dados->{'ors_codigo'})&&!empty($dados->{'ors_codigo'})){
				$ors_codigo = $dados->{'ors_codigo'};
			}
			$cad_codtecn = "";
			if(isset($dados->{'cad_codtecn'})&&!empty($dados->{'cad_codtecn'})){
				$cad_codtecn = $dados->{'cad_codtecn'};
			}
			$ors_obs = "";
			if(isset($dados->{'ors_obs'})&&!empty($dados->{'ors_obs'})){
				$ors_obs = $dados->{'ors_obs'};
			}

			$filtro = '{"cod":"501059", "params":[
				{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"},
				{"name":"cad_codtecn","value":"'.$cad_codtecn.'","type":"string"},
				{"name":"ors_obs","value":"'.$ors_obs.'","type":"string"},
				{"name":"ors_status","value":"3","type":"integer"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$datapacket->open(true);
			$datapacket->clear();
			echo "ok";
			exit();
		}
		echo "erro";

	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="cancelarOs"){
		
		if(isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])){

			$dados = json_decode(base64_decode($_REQUEST['dados']));

			$ors_codigo = "";
			if(isset($dados->{'ors_codigo'})&&!empty($dados->{'ors_codigo'})){
				$ors_codigo = $dados->{'ors_codigo'};
			}

			$filtro = '{"cod":"501064", "params":[
				{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"},
				{"name":"ors_status","value":"9","type":"string"},
				{"name":"ors_dtfim","value":"'.date("Y-m-d H:i:s").'","type":"string"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$datapacket->open(true);
			$datapacket->clear();
			echo "ok";
			exit();
		}
		echo "erro";

	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="concluirOs"){
		
		if(isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])){

			$dados = json_decode(base64_decode($_REQUEST['dados']));

			$ors_codigo = "";
			if(isset($dados->{'ors_codigo'})&&!empty($dados->{'ors_codigo'})){
				$ors_codigo = $dados->{'ors_codigo'};
			}

			$filtro = '{"cod":"501060", "params":[
				{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"},
				{"name":"ors_status","value":"4","type":"integer"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$datapacket->open(true);
			$datapacket->clear();
			echo "ok";
			exit();
		}
		echo "erro";

	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="carregaOs"){
		
		if(isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])){

			$dados = json_decode(base64_decode($_REQUEST['dados']));
			$retorno = new stdClass();

			$ors_codigo = "";
			if(isset($dados->{'ors_codigo'})&&!empty($dados->{'ors_codigo'})){
				$ors_codigo = $dados->{'ors_codigo'};
			}

			$filtro = '{"cod":"501053", "params":[
				{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$retorno->item_osdef = $datapacket->open(true);
			$datapacket->clear();

			$filtro = '{"cod":"501058", "params":[
				{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
				{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$retorno->item_os = $datapacket->open(true);
			$datapacket->clear();

			$filtro = '{"cod":"501057", "params":[
				{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
				{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$retorno->item_osserv = $datapacket->open(true);
			$datapacket->clear();

			$filtro = '{"cod":"501063", "params":[
				{"name":"doc_numero","value":"'.$ors_codigo.'","type":"other"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$retorno->parcelas = $datapacket->open(true);
			$datapacket->clear();

			print_r(json_encode($retorno));
		}

	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="faturar"){
		
		if(isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])){

			$dados = json_decode(base64_decode($_REQUEST['dados']));

			if(isset($dados->{'parcelas'})&&!empty($dados->{'parcelas'})){

				$ors_codigo = "";
				if(isset($dados->{'ors_codigo'})&&!empty($dados->{'ors_codigo'})){
					$ors_codigo = $dados->{'ors_codigo'};
				}
				$cdp_codigo = "";
				if(isset($dados->{'cdp_codigo'})&&!empty($dados->{'cdp_codigo'})){
					$cdp_codigo = $dados->{'cdp_codigo'};
				}
				$cad_codigo = "";
				if(isset($dados->{'cad_codigo'})&&!empty($dados->{'cad_codigo'})){
					$cad_codigo = $dados->{'cad_codigo'};
				}
				$ors_numero = "";
				if(isset($dados->{'ors_numero'})&&!empty($dados->{'ors_numero'})){
					$ors_numero = $dados->{'ors_numero'};
				}

				foreach ($dados->{'parcelas'} as $parcela) {

					$doc_codigo = "";
					if(isset($parcela->{'doc_codigo'}) && !empty($parcela->{'doc_codigo'})){
						$doc_codigo = $parcela->{'doc_codigo'};
					}
					$doc_numero = "";
					if(isset($parcela->{'doc_numero'}) && !empty($parcela->{'doc_numero'})){
						$doc_numero = $parcela->{'doc_numero'};
					}
					$doc_carteira = "";
					if(isset($parcela->{'doc_carteira'}) && !empty($parcela->{'doc_carteira'})){
						$doc_carteira = $parcela->{'doc_carteira'};
					}
					$doc_dtvcto = "";
					if(isset($parcela->{'doc_dtvcto'}) && !empty($parcela->{'doc_dtvcto'})){
						$doc_dtvcto = $parcela->{'doc_dtvcto'};
					}
					$doc_tipo = "";
					if(isset($parcela->{'doc_tipo'}) && !empty($parcela->{'doc_tipo'})){
						$doc_tipo = $parcela->{'doc_tipo'};
					}
					$doc_nparc = "";
					if(isset($parcela->{'doc_nparc'}) && !empty($parcela->{'doc_nparc'})){
						$doc_nparc = $parcela->{'doc_nparc'};
					}
					$doc_tparc = "";
					if(isset($parcela->{'doc_tparc'}) && !empty($parcela->{'doc_tparc'})){
						$doc_tparc = $parcela->{'doc_tparc'};
					}
					$doc_valor = "";
					if(isset($parcela->{'doc_valor'}) && !empty($parcela->{'doc_valor'})){
						$doc_valor = $parcela->{'doc_valor'};
					}

					$filtro = '{"cod":"501062", "params":[
						{"name":"doc_codigo","value":"'.$doc_codigo.'","type":"string"},
						{"name":"doc_numero","value":"'.$doc_numero.'","type":"string"},
						{"name":"doc_tipo","value":"'.$doc_tipo.'","type":"string"},
						{"name":"doc_pagrec","value":"2","type":"integer"},
						{"name":"doc_data","value":"'.date('Y-m-d H:i:s').'","type":"string"},
						{"name":"doc_valor","value":"'.$doc_valor.'","type":"float"},
						{"name":"doc_dtvcto","value":"'.$doc_dtvcto.'","type":"string"},
						{"name":"doc_descr","value":"OS nro '.$ors_numero.' - parcela '.$doc_nparc.'","type":"string"},
						{"name":"doc_status","value":"0","type":"integer"},
						{"name":"doc_nparc","value":"'.$doc_nparc.'","type":"integer"},
						{"name":"doc_tparc","value":"'.$doc_tparc.'","type":"integer"},
						{"name":"doc_obs","value":"OS nro '.$ors_numero.' - parcela '.$doc_nparc.'","type":"string"},
						{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
						{"name":"doc_carteira","value":"'.$doc_carteira.'","type":"string"},
						{"name":"ser_codigo","value":"1","type":"string"}
					]}';
					$datapacket->add($filtro);
				}
				$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
				$datapacket->open();
				$datapacket->clear();

				$filtro = '{"cod":"501061", "params":[
					{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"},
					{"name":"cdp_codigo","value":"'.$cdp_codigo.'","type":"integer"},
					{"name":"ors_status","value":"5","type":"integer"}
				]}';
				$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
				$datapacket->add($filtro);
				$datapacket->open();
				$datapacket->clear();
			
				echo "ok";
				exit();
			}
			echo "erro";

		}
		echo "erro";

	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="email"){

		if(isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])){
			
			$dados = json_decode(base64_decode($_REQUEST['dados']));
			
			$cad_email = "";
			if(isset($dados->{'cad_email'})&&!empty($dados->{'cad_email'})){
				$cad_email = $dados->{'cad_email'};
			}
			$ors_codigo = "";
			if(isset($dados->{'ors_codigo'})&&!empty($dados->{'ors_codigo'})){
				$ors_codigo = $dados->{'ors_codigo'};
			}
			$ptr_identificacao = "";
			if(isset($dados->{'ptr_identificacao'})&&!empty($dados->{'ptr_identificacao'})){
				$ptr_identificacao = $dados->{'ptr_identificacao'};
			}

			include_once("../rel/osEmail.php");

			if(file_exists($datapacket->getHostRoot()."tmp/".$arquivo.'.pdf')){
				
				//classe p/ envio
				include_once("../class/PHPMailer_v5.1/class.phpmailer.php");
				
				//mensagem (corpo do e-mail)
				$msg = utf8_decode('<p> Segue em anexo o orçamento relacionado ao patrimônio '.$ptr_identificacao.' </p>');

				$mail = new PHPMailer();
				$mail->Charset = 'UTF-8';
			    $assunto = utf8_decode("Sistema facil");
			    $mail->IsHTML(true);
			    $mail->SetLanguage("br");
			    $mail->isSMTP();
			    $mail->Port = 587;
			    $mail->Host = strtolower($datapacket->getCompany()->{'emp_hostsmtp'});
			    $mail->SMTPAuth = true;
			    $mail->Username = strtolower($datapacket->getCompany()->{'emp_emailremetente'});
			    $mail->Password = $datapacket->getCompany()->{'emp_pwdsmtp'};
			    $mail->From = strtolower($cad_email);    
			    $mail->Subject = $assunto;
			    $mail->Body = $msg;
			    $mail->AddAddress($cad_email);
			    $mail->AddAttachment($datapacket->getHostRoot()."tmp/".$arquivo.'.pdf');
				
				if($mail->send()){
					unlink($datapacket->getHostRoot()."tmp/".$arquivo.'.pdf');
					exit('ok');
				}else{
					unlink($datapacket->getHostRoot()."tmp/".$arquivo.'.pdf');
					exit('erro');
				}

			}else{
				echo "Ocorreu um erro ao gerar o arquivo.";
				exit();
			}
		}
		echo "erro ao receber os parametros";
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="nfe"){

		if(isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])){
			
			$dados = json_decode(base64_decode($_REQUEST['dados']));
			
			$ors_codigo = "";
			if(isset($dados->{'ors_codigo'})&&!empty($dados->{'ors_codigo'})){
				$ors_codigo = $dados->{'ors_codigo'};
			}

			$filtro = '{"cod":"501069", "params":[
				{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"string"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			$datapacket->add($filtro);
			$ret = $datapacket->open(true);
			$datapacket->clear();
			print_r(json_encode($ret));
			exit();
		}
		
	}else{

		$ors_codigo = "";
		$cad_codigo = "";
		$ors_status = "";
		$ptr_identificacao = "";
		$mar_codigo = "";
		$cor_codigo = "";
		$tpr_codigo = "";
		$mdl_codigo = "";
		$cad_codtecn = "";

		if(isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])){

			$dados = json_decode(base64_decode($_REQUEST['dados']));

			if(isset($dados->{'ors_codigo'})&&!empty($dados->{'ors_codigo'})){
				$ors_codigo = "and a.ors_codigo = ".$dados->{'ors_codigo'};
			}
			if(isset($dados->{'cad_codigo'})&&!empty($dados->{'cad_codigo'})){
				$cad_codigo = "and a.cad_codigo = ".$dados->{'cad_codigo'};
			}
			if(isset($dados->{'ors_status'})&&!empty($dados->{'ors_status'}) || isset($dados->{'ors_status'})&&$dados->{'ors_status'}==="0"){
				$ors_status = "and a.ors_status = ".$dados->{'ors_status'};
			}
			if(isset($dados->{'ptr_identificacao'})&&!empty($dados->{'ptr_identificacao'})){
				$ptr_identificacao = "and c.ptr_identificacao like '".$dados->{'ptr_identificacao'}."%'";
			}
			if(isset($dados->{'mar_codigo'})&&!empty($dados->{'mar_codigo'}) || isset($dados->{'ors_status'})&&$dados->{'mar_codigo'}==="0"){
				$mar_codigo = "and c.mar_codigo = ".$dados->{'mar_codigo'};
			}
			if(isset($dados->{'cor_codigo'})&&!empty($dados->{'cor_codigo'}) || isset($dados->{'ors_status'})&&$dados->{'cor_codigo'}==="0"){
				$cor_codigo = "and c.cor_codigo = ".$dados->{'cor_codigo'};
			}
			if(isset($dados->{'tpr_codigo'})&&!empty($dados->{'tpr_codigo'}) || isset($dados->{'ors_status'})&&$dados->{'tpr_codigo'}==="0"){
				$tpr_codigo = "and c.tpr_codigo = ".$dados->{'tpr_codigo'};
			}
			if(isset($dados->{'mdl_codigo'})&&!empty($dados->{'mdl_codigo'}) || isset($dados->{'ors_status'})&&$dados->{'mdl_codigo'}==="0"){
				$mdl_codigo = "and a.mdl_codigo = ".$dados->{'mdl_codigo'};
			}
			if(isset($dados->{'cad_codtecn'})&&!empty($dados->{'cad_codtecn'})){
				$cad_codtecn = "and c.cad_codtecn = ".$dados->{'cad_codtecn'};
			}
		}
		
		$filtro = '{"cod":"501052", "params":[
			{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
			{"name":"ors_codigo","value":"'.$ors_codigo.'","type":"other"},
			{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"other"},
			{"name":"ors_status","value":"'.$ors_status.'","type":"other"},
			{"name":"ptr_identificacao","value":"'.$ptr_identificacao.'","type":"other"},
			{"name":"mar_codigo","value":"'.$mar_codigo.'","type":"other"},
			{"name":"cor_codigo","value":"'.$cor_codigo.'","type":"other"},
			{"name":"tpr_codigo","value":"'.$tpr_codigo.'","type":"other"},
			{"name":"mdl_codigo","value":"'.$mdl_codigo.'","type":"other"},
			{"name":"cad_codtecn","value":"'.$cad_codtecn.'","type":"other"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
		$datapacket->add($filtro);
		$ret = $datapacket->open(true);
		print_r(json_encode($ret));
		$datapacket->clear();

	}

?>