<?php
/**
 * Este arquivo é parte do projeto NFePHP - Nota Fiscal eletrônica em PHP.
 *
 * Este programa é um software livre: você pode redistribuir e/ou modificá-lo
 * sob os termos da Licença Pública Geral GNU como é publicada pela Fundação
 * para o Software Livre, na versão 3 da licença, ou qualquer versão posterior.
 * e/ou
 * sob os termos da Licença Pública Geral Menor GNU (LGPL) como é publicada pela
 * Fundação para o Software Livre, na versão 3 da licença, ou qualquer versão posterior.
 *
 * Este programa é distribuído na esperança que será útil, mas SEM NENHUMA
 * GARANTIA; nem mesmo a garantia explícita definida por qualquer VALOR COMERCIAL
 * ou de ADEQUAÇÃO PARA UM PROPÓSITO EM PARTICULAR,
 * veja a Licença Pública Geral GNU para mais detalhes.
 *
 * Você deve ter recebido uma cópia da Licença Publica GNU e da
 * Licença Pública Geral Menor GNU (LGPL) junto com este programa.
 * Caso contrário consulte
 * <http://www.fsfla.org/svnwiki/trad/GPLv3>
 * ou
 * <http://www.fsfla.org/svnwiki/trad/LGPLv3>.
 *
 * @category  NFePHP
 * @package   NFePHP
 * @name      DanfceNFePHP.class.php
 * @copyright 2009-2013 &copy; NFePHP
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL v.3
 *            http://www.gnu.org/licenses/lgpl.html GNU/LGPL v.3
 * @version   1.12
 * @link      http://www.nfephp.org/
 * @author    Roberto Spadim <roberto at spadim dot com dot br>
 * 
 * 
 * CONTRIBUIDORES (por ordem alfabetica):
 *            Roberto L. Machado <linux dot rlm at gmail dot com>   
 *            Mario Almeida <mario at grupopmz dot com dot br>
 * 
 */

//namespace nfephp\NFe;

//define o caminho base da instalação do sistema
if (!defined('PATH_ROOT')) {
    define('PATH_ROOT', dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR);
}

//ajuste do tempo limite de resposta do processo
set_time_limit(1800);

//classes utilizadas
require_once PATH_ROOT.'libs/External/mpdf/mpdf.php';
require_once PATH_ROOT.'libs/External/qrcode/qrcode.class.php';
require_once PATH_ROOT.'libs/Common/CommonNFePHP.class.php';
require_once PATH_ROOT.'libs/Common/DocumentoNFePHP.interface.php';

/**
 * Classe DanfceNFePHP
 * Objetivo - impressão de NFC-e em uma unica pagina (bobina)
 */
class DanfeNFCeNFePHP extends CommonNFePHP implements DocumentoNFePHP
{
    //publicas
    public $idToken;
    public $emitToken;
    public $papel;
    public $emp_codigo;
	
	private $uploads;
    
    //privadas
    protected $xml; // string XML NFe
    protected $logomarca=''; // path para logomarca em jpg
    protected $formatoChave="#### #### #### #### #### #### #### #### #### #### ####";
    protected $debugMode=0; //ativa ou desativa o modo de debug
    protected $nfeProc;
    protected $nfe;
    protected $infNFe;
    protected $ide;
    protected $enderDest;
    protected $ICMSTot;
    protected $imposto;
    protected $emit;
    protected $enderEmit;
    protected $det;
    protected $pag;
    protected $dest;
    protected $mPDF;
    protected $html;
    protected $imgQRCode;
    protected $urlConsulta = array(
        '1'=> array(
            '12'=> array(
                'chave'=>'',
                'QR'=>'http://www.sefaznet.ac.gov.br/nfe/NFe.jsp?opc=3'),
            '13'=> array(
                'chave'=>'http://sistemas.sefaz.am.gov.br/nfceweb/formConsulta.do',
                'QR'=>'http://sistemas.sefaz.am.gov.br/nfceweb/consultarNFCe.jsp'),
            '21'=> array(
                'chave'=>'',
                'QR'=>'http://www.nfe.ma.gov.br/portal/consultarNFCe.jsp'),
            '51'=> array(
                'chave'=>'',
                'QR'=>'http://www.nfe.sefaz.mt.gov.br/portal/consultarNFCe.jsp'),
            '24'=> array(
                'chave'=>'',
                'QR'=>'http://www.nfe.rn.gov.br/portal/consultarNFCe.jsp'),
            '43'=> array(
                'chave'=>'',
                'QR'=>'https://www.sefaz.rs.gov.br/NFCE/NFCE-COM.aspx'),
            '28'=> array(
                'chave'=>'',
                'QR'=>'http://www.nfe.se.gov.br/portal/consultarNFCe.jsp'),
			'41'=> array(
                'chave'=>'http://www.sped.fazenda.pr.gov.br/modules/conteudo/conteudo.php?conteudo=100',
                'QR'=>'http://www.dfeportal.fazenda.pr.gov.br/dfe-portal/rest/servico/consultaNFCe')
        ),
        '2' => array(
            '12'=> array(
                'chave'=>'',
                'QR'=>'http://hml.sefaznet.ac.gov.br'),
            '13'=> array(
                'chave'=>'http://sistemas.sefaz.am.gov.br/nfceweb/formConsulta.do',
                'QR'=>'http://homnfe.sefaz.am.gov.br/nfceweb/consultarNFCe.jsp'),
            '21'=> array(
                'chave'=>'',
                'QR'=>'http://www.hom.nfe.ma.gov.br/portal/consultarNFCe.jsp'),
            '51'=> array(
                'chave'=>'',
                'QR'=>'http://www.hom.nfe.sefaz.mt.gov.br/portal/consultarNFCe.jsp'),
            '24'=> array(
                'chave'=>'',
                'QR'=>'http://www.hom.nfe.rn.gov.br/portal/consultarNFCe.jsp'),
            '43'=> array(
                'chave'=>'',
                'QR'=>'https://www.sefaz.rs.gov.br/NFCE/NFCE-COM.aspx'),
            '28'=> array(
                'chave'=>'',
                'QR'=>'http://www.hom.nfe.se.gov.br/portal/consultarNFCe.jsp'),
			'41'=> array(
                'chave'=>'http://www.sped.fazenda.pr.gov.br/modules/conteudo/conteudo.php?conteudo=100',
                'QR'=>'http://www.dfeportal.fazenda.pr.gov.br/dfe-portal/rest/servico/consultaNFCe')
        ));

    /**
     * __contruct
     * @param type $docXML
     * @param type $sPathLogo
     * @param type $mododebug
     * @param type $idToken
     * @param type $Token
     */
    public function __construct($docXML = '', $sPathLogo = '', $mododebug = 0, $idToken = '', $emitToken = '', $emp_codigo = '', $chave = '',$uploads='')
    {
        if (is_numeric($mododebug)) {
            $this->debugMode = $mododebug;
        }
        if ($this->debugMode) {
            //ativar modo debug
            error_reporting(E_ALL);
            ini_set('display_errors', 'On');
        } else {
            //desativar modo debug
            error_reporting(0);
            ini_set('display_errors', 'Off');
        }
        $this->papel = array(80, 'one-page');
        $this->xml          = $docXML;
        $this->uploads      = $uploads;
        $this->logomarca    = $sPathLogo;
        if (!empty($this->xml)) {
            $this->dom = new DomDocument;
            $this->dom->loadXML($this->xml);
            $this->nfeProc    = $this->dom->getElementsByTagName("nfeProc")->item(0);
            $this->nfe        = $this->dom->getElementsByTagName("NFe")->item(0);
            $this->infNFe     = $this->dom->getElementsByTagName("infNFe")->item(0);
            $this->ide        = $this->dom->getElementsByTagName("ide")->item(0);
            $this->emit       = $this->dom->getElementsByTagName("emit")->item(0);
            $this->enderEmit  = $this->dom->getElementsByTagName("enderEmit")->item(0);
            $this->det        = $this->dom->getElementsByTagName("det");
            $this->dest       = $this->dom->getElementsByTagName("dest")->item(0);
            $this->pag        = $this->dom->getElementsByTagName("pag");
            $this->imposto    = $this->dom->getElementsByTagName("imposto")->item(0);
            $this->ICMSTot    = $this->dom->getElementsByTagName("ICMSTot")->item(0);
        }
        $this->idToken = $idToken;
        $this->emitToken = $emitToken;
        $this->emp_codigo = $emp_codigo;
        $this->chave = $chave;
        
    } //fim __construct

    public function getIdToken()
    {
        return $this->idToken;
    }
    
    public function setIdToken($str)
    {
        $this->idToken = $str;
    }
    
    public function getEmitToken()
    {
        return $this->emitToken;
    }
    
    public function setEmitToken($str)
    {
        $this->emitToken = $str;
    }
    
    public function getPapel()
    {
        return $this->papel;
    }
    
    public function setPapel($aPap)
    {
        $this->papel = $aPap;
    }
    
    public function simpleConsistencyCheck()
    {
        if (1 == 2 || $this->xml == null || $this->infNFe == null || $this->ide == null) {
            return false;
        }
        return true;
    } //fim simpleConsistencyCheck
    
    /**
     * monta
     * @param type $orientacao
     * @param type $papel
     * @param type $logoAlign
     * @return type
     */
    public function monta ($orientacao = '', $papel = array(80, 'one-page'), $logoAlign = 'C', $detalhes = false)
    {
        return $this->montaDANFE($detalhes);
    }//fim monta
    
    /**
     * printDocument
     * @param type $nome
     * @param type $destino
     * @param type $printer
     * @return type
     */
    public function printDocument($nome = '', $destino = 'I', $printer = '')
    {
        return $this->printDANFE($nome, $destino, $printer);
    }//fim printDocument
    
    /**
     * o objetivo desta função é ler o XML e gerar o DANFE com auxilio de conversão HTML-PDF
     * @param type $detalhes
     * @return type
     */
    public function montaDANFE($detalhes = false, $calcNcm = "")
    {

        if(!empty($calcNcm)) {
            $calcNcm = json_decode(base64_decode($calcNcm));
        } else {
            $calcNcm = new StcdClass();
            $calcNcm->{"cfg_ibpt_detalhe"} = 0;
            $calcNcm->{"not_ibpt_federal"} = "0,00";
            $calcNcm->{"not_ibpt_estadual"} = "0,00";
            $calcNcm->{"not_ibpt_municipal"} = "0,00";
        }

        //DADOS DA NF
        if (isset($this->nfeProc)) {
            $nProt = $this->pSimpleGetValue($this->nfeProc, "nProt");
            $dhRecbto  = $this->pSimpleGetValue($this->nfeProc, "dhRecbto");
        }
        $digVal = $this->pSimpleGetValue($this->nfe, "DigestValue");
        $chNFe = str_replace('NFe', '', $this->infNFe->getAttribute("Id"));
        $tpAmb = $this->pSimpleGetValue($this->ide, 'tpAmb');
        $cUF = $this->pSimpleGetValue($this->ide, 'cUF');
        $nNF = $this->pSimpleGetValue($this->ide, 'nNF');
        $serieNF = str_pad($this->pSimpleGetValue($this->ide, "serie"), 3, "0", STR_PAD_LEFT);
        $dhEmi = $this->pSimpleGetValue($this->ide, "dhEmi");
        $vTotTrib = $this->pSimpleGetValue($this->imposto, "vTotTrib");
        $vProd = $this->pSimpleGetValue($this->ICMSTot, "vProd");
        $vNF = $this->pSimpleGetValue($this->ICMSTot, "vNF");
        $vDesc  = $this->pSimpleGetValue($this->ICMSTot, "vDesc");
        $vICMS = $this->pSimpleGetValue($this->ICMSTot, "vICMS");
        $qtdItens = $this->det->length;
        $urlChave = $this->urlConsulta[$tpAmb][$cUF]['chave'];
        $urlQR = $this->urlConsulta[$tpAmb][$cUF]['QR'];
        //DADOS DO EMITENTE
        $emitRazao  = $this->pSimpleGetValue($this->emit, "xNome");
        $emitCnpj   = $this->pSimpleGetValue($this->emit, "CNPJ");
        $emitCnpj   = $this->pFormat($emitCnpj, "##.###.###/####-##");
        $emitIE     = $this->pSimpleGetValue($this->emit, "IE");
        $emitFone = $this->pSimpleGetValue($this->enderEmit, "fone");
        $foneLen = strlen($emitFone);
        if ($foneLen>0) {
            $fone2 = substr($emitFone, 0, $foneLen-4);
            $fone1 = substr($emitFone, 0, $foneLen-8);
            $emitFone = '('.$fone1.') '.substr($fone2, -4).'-'.substr($emitFone, -4);
        } else {
            $emitFone = '';
        }
        $emitLgr = $this->pSimpleGetValue($this->enderEmit, "xLgr");
        $emitNro = $this->pSimpleGetValue($this->enderEmit, "nro");
        $emitCpl = $this->pSimpleGetValue($this->enderEmit, "xCpl", " - ");
        $emitBairro = $this->pSimpleGetValue($this->enderEmit, "xBairro");
        $emitCEP = $this->pFormat($this->pSimpleGetValue($this->enderEmit, "CEP"), "#####-###");
        $emitMun = $this->pSimpleGetValue($this->enderEmit, "xMun");
        $emitUF = $this->pSimpleGetValue($this->enderEmit, "UF");

        //pag
        $tPagNome = '';
        $pagHtml = $this->pagamento($this->pag, $tPagNome);
        
        //IMPOSTOS
        if($vDesc>0){
            $soma = (float)$vNF + (float)$vDesc;
            $vTotal = number_format($soma,2,',','.');
        }else{
            $vTotal = $vNF; 
        }
        $vDesc = ($vDesc>0) ? number_format($vDesc, 2, ',', '.') : "0,00";
        $vProd = ($vProd>0) ? number_format($vProd, 2, ',', '.') : "0,00";
        $vNF = ($vNF>0) ? number_format($vNF, 2, ',', '.') : "0,00";
		
        $impHtml = "<table width=\"100%\">\n";
        $impHtml .= "<tr>\n";
        $impHtml .= "<td align=\"left\">".htmlspecialchars('VALOR PRODUTOS/SERVIÇOS')."</td>\n";
        $impHtml .= "<td align=\"right\">".$vProd."</td>\n";
        $impHtml .= "</tr>\n";
        $impHtml .= "<tr>\n";
        $impHtml .= "<td align=\"left\">DESCONTOS</td>\n";
        $impHtml .= "<td align=\"right\">".$vDesc."</td>\n";
        $impHtml .= "</tr>\n";
        $impHtml .= "<tr>\n";
        $impHtml .= "<td align='left'>VALOR TOTAL</td>\n";
        $impHtml .= "<td align='right'>".$vNF."</td>\n";
        $impHtml .= "</tr>\n";
        $impHtml .= "</table>\n";
        
        $destinatario = $this->pSimpleGetValue($this->dest, "xNome");
        
        //cpf na nota
        $cnpjdest = $this->pSimpleGetValue($this->dest, "CNPJ");
        if(!empty($cnpjdest)){
            $cnpjdest = substr($cnpjdest, 0, 2).".".substr($cnpjdest, 2, 3).".".substr($cnpjdest, 5, 3)."/".substr($cnpjdest, 8, 4)."-".substr($cnpjdest, 12, 2);
        }
        $cpfdest = $this->pSimpleGetValue($this->dest, "CPF");
        if(!empty($cpfdest)){
            $cpfdest = substr($cpfdest, 0, 3).".".substr($cpfdest, 3, 3).".".substr($cpfdest, 6, 3)."-".substr($cpfdest, 9, 2);
        }
        if(!empty($cnpjdest)){
            $cpfnanota = $cnpjdest;
            $cpfnanotalabel = "CNPJ";
        }else if(!empty($cpfdest)){
            $cpfnanota = $cpfdest;
            $cpfnanotalabel = "CPF";
        }else{
            $cpfnanota = "";
            $cpfnanotalabel = "";
        }

        //necessário para QRCode
        $cDest  = '';
        if (isset($this->dest)) {
            $considEstrangeiro = !empty($this->dest->getElementsByTagName("idEstrangeiro")->item(0)->nodeValue)
                    ? $this->dest->getElementsByTagName("idEstrangeiro")->item(0)->nodeValue
                    : '';
            $consCPF = !empty($this->dest->getElementsByTagName("CPF")->item(0)->nodeValue)
                    ? $this->dest->getElementsByTagName("CPF")->item(0)->nodeValue
                    : '';
            $consCNPJ = !empty($this->dest->getElementsByTagName("CNPJ")->item(0)->nodeValue)
                    ? $this->dest->getElementsByTagName("CNPJ")->item(0)->nodeValue
                    : '';
            $cDest = $consCPF.$consCNPJ.$considEstrangeiro; //documentos do consumidor
        }
        
        //DADOS PARA QRCODE
        $idToken = '';
        $Token = '';
        $this->imgQRCode = $this->makeQRCode(
            $chNFe,
            $urlQR,
            $tpAmb,
            $cDest,
            $dhEmi,
            $vNF,
            $vICMS,
            $digVal,
            $idToken,
            $Token
        );

        //FORMATAÇÃO DOS CAMPOS
        $numNF = "NFCe nº ".$this->pFormat($nNF, "###.###.###");
        $tsHora = $this->pConvertTime($dhEmi);
        $tsProt = $this->pConvertTime($dhRecbto);
		$valorProdutos = ($valorProdutos>0) ? number_format($valorProdutos, 2, ',', '.') : "0,00";
		$valorTotal = ($valorTotal>0) ? number_format($valorTotal, 2, ',', '.') : "0,00";
		$vTotTrib = ($vTotTrib>0) ? number_format($vTotTrib, 2, ',', '.') : "0,00";
		
        //CABEÇALHO
        $this->html = "";
        $this->html .= "<html>\n";
        $this->html .= "<head>\n";
        $this->html .= "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">";
        $this->html .= "<style>";
        $this->html .= "body {";
        $this->html .= "    font-family: Arial;";
        $this->html .= "    font-size: 10px;";
        // $this->html .= "    background: transparent url('bgbarcode.png') repeat-y scroll left top;";
        $this->html .= "}";
        $this->html .= ".barcode {";
        $this->html .= "    padding: 1.5mm;";
        $this->html .= "    margin: 0;";
        $this->html .= "    vertical-align: top;";
        $this->html .= "    color: #000000;";
        $this->html .= "}";
        $this->html .= ".barcodecell {";
        $this->html .= "    text-align: center;";
        $this->html .= "    vertical-align: middle;";
        $this->html .= "    padding: 0;";
        $this->html .= "}";
        $this->html .= ".h5, p { margin: 0px; }";
        $this->html .= ".menor { font-size: 4px; }";
        $this->html .= ".qrcode { font-size: 6px; }";
        $this->html .= ".chave { font-size: 7px; }";
        $this->html .= ".empresa { font-size: 8px; }";
        $this->html .= ".quantidade { font-size: 9px; }";
        $this->html .= ".float-left { float: left; }";
        $this->html .= ".float-right { float: right; }";
        $this->html .= ".cinco { width: 5%; }";
        $this->html .= ".dez { width: 10%; }";
        $this->html .= ".quinze { width: 15%; }";
        $this->html .= ".vinte { width: 20%; }";
        $this->html .= ".vintecinco { width: 25%; }";
        $this->html .= ".trinta { width: 30%; }";
        $this->html .= ".terco { width: 33%; }";
        $this->html .= ".trintacinco { width: 35%; }";
        $this->html .= ".quarenta { width: 40%; }";
        $this->html .= ".quarentacinco { width: 45%; }";
        $this->html .= ".sessenta { width: 60%; }";
        $this->html .= ".setenta { width: 70%; }";
        $this->html .= ".oitenta { width: 80%; }";
        $this->html .= ".noventa { width: 90%; }";
        $this->html .= ".metade { width: 50%; }";
        $this->html .= ".cinquentacinco { width: 55%; }";
        $this->html .= ".inteiro { width: 100%; }";
        $this->html .= ".text-right { text-align: right; }";
        $this->html .= ".text-center { text-align: center; }";
        $this->html .= ".metade > h2{ text-align: center; }";
        $this->html .= ".espacamento { margin-top:10px; }";
        $this->html .= ".espacamentomedio { margin-top:20px; }";
        $this->html .= ".espacamentoqtde { padding: 2px 2px; }";
        $this->html .= ".item { border-top: 1px solid #C1C1C1; border-bottom: 1px solid #C1C1C1; }";
        $this->html .= "</style>\n";
        $this->html .= "</head>\n";
        $this->html .= "<body>\n";
        
        //LOGO / INFOS EMPRESA
        $this->html .= "<div class=\"float-left inteiro\">\n";
            $this->html .= "<div class=\"float-left inteiro\">\n";
                $this->html .= "<div class=\"float-left quarenta\">\n";
                    $this->html .= "<div class=\"inteiro text-center\"><h2>NFC-e</h2></div>\n";
                    if(isset($this->logomarca)&&!empty($this->logomarca)){
                        $this->html .= "<div class=\"inteiro text-center\"><img src=\"$this->logomarca\" width=\"90\" ></div>\n";
                    }
                $this->html .= "</div>\n";
                $this->html .= "<div class=\"float-right sessenta text-center\">";
                    $this->html .= "<div class=\"inteiro empresa\"><span>".htmlspecialchars($emitRazao)."</span></div>\n";
                    $this->html .= "<div class=\"inteiro empresa\"><span> CNPJ:$emitCnpj I.E.:$emitIE</span></div>\n";
                    $this->html .= "<div class=\"inteiro empresa\"><span>".htmlspecialchars($emitLgr.", ". $emitNro). "</span></div>\n";
                    $this->html .= "<div class=\"inteiro empresa\"><span>".htmlspecialchars($emitCpl)."</span></div>\n";
                    $this->html .= "<div class=\"inteiro empresa\"><span>".htmlspecialchars($emitBairro.", ". $emitMun . ", " . $emitUF)."</span></div>\n";
                $this->html .= "</div>\n";
            $this->html .= "</div>\n";
        $this->html .= "</div>\n";
        $this->html .= "<div class=\"float-left inteiro espacamento\">\n";
            $this->html .= "<div class=\"inteiro menor chave text-center\" style=\"white-space:nowrap\">".htmlspecialchars("DANFE NFC-E Nota Fiscal Eletrônica para $destinatario")."</div>\n";
            if ($tpAmb == 1) {
                $this->html .= "<div class=\"inteiro menor chave text-center\">".htmlspecialchars("NFC-e não permite aproveitamento de crédito de ICMS")."</div>\n";
            } else {
                $this->html .= "<div class=\"inteiro menor chave text-center\">NFC-e Emitida em Ambiente de Testes</div>\n";
                $this->html .= "<div class=\"inteiro menor chave text-center\"><b>SEM VALOR FISCAL</b></div>\n";
            }
        $this->html .= "</div>\n";
        //DADOS DA NOTA
        $this->html .= "<div class=\"float-left inteiro espacamento\">\n";
            $this->html .= "<div class=\"float-left espacamentoqtde quantidade\">".htmlspecialchars($numNF)."</div>\n";
            $this->html .= "<div class=\"float-left text-center vintecinco espacamentoqtde quantidade\">Série: $serieNF</div>\n";
            $this->html .= "<div class=\"float-right espacamentoqtde quantidade\">".date('d/m/Y H:i:s', $tsHora)."</div>\n";
        $this->html .= "</div>\n";
        //ITEM
        $this->html .= "<div class=\"float-left inteiro espacamento quantidade item\">\n";
            $this->html .= $this->itens($this->det);
        $this->html .= "</div>\n";
        //TOTAIS DA NF
        $this->html .= "<div class=\"float-left inteiro espacamento quantidade\">\n";
            if(!empty($cpfnanota)){
                $this->html .= "<div class=\"float-left inteiro espacamento espacamentoqtde\">\n";
                    $this->html .= "<div class=\"metade float-left\">$cpfnanotalabel</div>\n";
                    $this->html .= "<div class=\"metade float-left text-right\">$cpfnanota</div>\n";
                $this->html .= "</div>\n";
            }
            $this->html .= "<div class=\"float-left inteiro espacamentoqtde\">\n";
                $this->html .= "<div class=\"sessenta float-left\">TOTAL DE ITENS</div>\n";
                $this->html .= "<div class=\"quarenta float-left text-right\">$qtdItens</div>\n";
            $this->html .= "</div>\n";
            $this->html .= "<div class=\"float-left inteiro espacamentoqtde\">\n";
                $this->html .= "<div class=\"sessenta float-left\">VALOR TOTAL R$</div>\n";
                $this->html .= "<div class=\"quarenta float-left text-right\">".$vTotal."</div>\n";
            $this->html .= "</div>\n";
            $this->html .= "<div class=\"float-left inteiro espacamentoqtde\">\n";
                $this->html .= "<div class=\"sessenta float-left\">TOTAL DESCONTO R$</div>\n";
                $this->html .= "<div class=\"quarenta float-left text-right\">".$vDesc."</div>\n";
            $this->html .= "</div><br />\n";
            $this->html .= "<div class=\"float-left inteiro espacamentoqtde\">\n";
                $this->html .= "<div class=\"sessenta float-left\">VALOR PAGO R$</div>\n";
                $this->html .= "<div class=\"quarenta float-left text-right\">".$vNF."</div>\n";
            $this->html .= "</div>\n";
            $this->html .= "<div class=\"float-left inteiro espacamentoqtde\">\n";
                $this->html .= "<div class=\"inteiro float-left\">Informação dos Tributos Incidentes (Lei Federal 12.741/2012)</div>\n";
                
                if($calcNcm->{"cfg_ibpt_detalhe"} == 0){
                    
                    $this->html .= "<div class=\"metade float-left\">Tributos Federais</div>\n";
                    $this->html .= "<div class=\"metade float-left text-right\">".$calcNcm->{"not_ibpt_federal"}."</div>\n";

                } else {

                    $this->html .= "<div class=\"metade float-left\">Tributos Federais</div>\n";
                    $this->html .= "<div class=\"metade float-left text-right\">".$calcNcm->{"not_ibpt_federal"}."</div>\n";

                    $this->html .= "<div class=\"metade float-left\">Tributos Estaduais</div>\n";
                    $this->html .= "<div class=\"metade float-left text-right\">".$calcNcm->{"not_ibpt_estadual"}."</div>\n";

                    $this->html .= "<div class=\"metade float-left\">Tributos Municipais</div>\n";
                    $this->html .= "<div class=\"metade float-left text-right\">".$calcNcm->{"not_ibpt_municipal"}."</div>\n";
                }
            $this->html .= "</div>\n";

        $this->html .= "</div>\n";
        //CHAVE DE ACESSO
        $this->html .= "<div class=\"float-left inteiro espacamento\">\n";
            $this->html .= "<div class=\"float-left inteiro chave text-center\">Consulte pela Chave de Acesso em</div>\n";
            $this->html .= "<div class=\"float-left inteiro chave\"><a href=\"$urlChave\" >"."$urlChave</a></div>\n";
            $this->html .= "<div class=\"float-left inteiro chave text-center espacamento\">Chave de Acesso</div>\n";
            $this->html .= "<div class=\"float-left inteiro chave text-center\">$chNFe</div>\n";
            $this->html .= "<div class=\"float-left inteiro text-center qrcode espacamento\"><b>Consulta via leitor QR Code</b></div>\n";
            $this->html .= "<div class=\"float-left inteiro text-center\"><img src=\"http://".$_SERVER['SERVER_NAME'].$this->imgQRCode."\" width=\"125\" height=\"125\" ></div>\n";
        $this->html .= "</div>\n";
        //BLOCO DE DETALHES
        if ($detalhes) {
            //ITENS
            $this->html .= $this->itens($this->det);
            //IMPOSTOS
            $this->html .= $impHtml;
            //PAGAMENTOS
            $this->html .= $pagHtml;
            //CONSUMIDOR
            $this->html .= $this->consumidor($this->dest);
        }
        $this->html .= "<div class=\"float-left inteiro espacamento\">\n";
            $this->html .= "<div class=\"inteiro text-center empresa espacamento\">Autorização: $nProt - ".date('d/m/Y H:i:s', $tsProt)."</div>\n";
        $this->html .= "</div>\n";
        $this->html .= "</body>\n";
        $this->html .= "</html>\n";
        return $chNFe;
    }//fim da função montaDANFE
    protected function pagamento($pag, &$tPnome)
    {
        if (!isset($pag)) {
            return '';
        }
        //DADOS DE PAGAMENTO
        $oldtBand = '';
        $oldtPag = '';
        $pagHtml = "<table width=\"100%\">\n<tr>";
        $pagHtml .= "<td align=\"left\">PAGAMENTOS</td>\n";
        $pagHtml .= "<td></td></tr>\n";
        foreach ($pag as $pagI) {
            $tPag = $this->pSimpleGetValue($pagI, "tPag");
            $tPagNome = $this->tipoPag($tPag);
            $tPnome = $tPagNome;
            $vPag = ($this->pSimpleGetValue($pagI, "vPag")>0) ? number_format($this->pSimpleGetValue($pagI, "vPag"), 2, ",", ".") : "0";
            $card = $pagI->getElementsByTagName("card")->item(0);
            //cartão
            if (isset($card)) {
                $cardCNPJ = $this->pSimpleGetValue($card, "CNPJ");
                $tBand    = $this->pSimpleGetValue($card, "tBand");
                //$cAut = $this->pSimpleGetValue($card, "cAut");
                $tBandNome = self::getCardName($tBand);
            }
            if ($tPag != $oldtPag) {
                $pagHtml .= "<tr>\n";
                $pagHtml .= "<td align=\"left\">".htmlspecialchars($tPagNome)."</td>\n";
                $pagHtml .= "<td align=\"right\">$vPag</td>\n";
                $pagHtml .= "</tr>\n";
                $oldtPag = $tPag;
            }
            if ($cardCNPJ != '' && $oldtBand != $tBand) {
                $pagHtml .= "<tr>\n";
                $pagHtml .= "<td align=\"left\">".htmlspecialchars($tBandNome)."</td>\n";
                $pagHtml .= "<td align=\"right\">".$this->pFormat($cardCNPJ, "##.###.###/####-##")."</td>\n";
                $pagHtml .= "</tr>\n";
                $oldtBand = $tBand;
            }
        } //fim foreach
        $pagHtml .= "</table>\n";
        return $pagHtml;
    }

    protected static function getCardName($tBand)
    {
        switch ($tBand) {
            case '01':
                $tBandNome = 'VISA';
                break;
            case '02':
                $tBandNome = 'MASTERCARD';
                break;
            case '03':
                $tBandNome = 'AMERICAM EXPRESS';
                break;
            case '04':
                $tBandNome = 'SOROCRED';
                break;
            case '99':
                $tBandNome = 'OUTROS';
        }
        return $tBandNome;
    }//fim getCardName
    
    protected function tipoPag($tPag)
    {
        switch ($tPag) {
            case '01':
                $tPagNome = 'Dinheiro';
                break;
            case '02':
                $tPagNome = 'Cheque';
                break;
            case '03':
                $tPagNome = 'Cartão de Crédito';
                break;
            case '04':
                $tPagNome = 'Cartão de Débito';
                break;
            case '05':
                $tPagNome = 'Crédito Loja';
                break;
            case '10':
                $tPagNome = 'Vale Alimentação';
                break;
            case '11':
                $tPagNome = 'Vale Refeição';
                break;
            case '12':
                $tPagNome = 'Vale Presente';
                break;
            case '13':
                $tPagNome = 'Vale Combustível';
                break;
            case '99':
                $tPagNome = 'Outros';
        }
        return $tPagNome;
    }
    
    protected function itens($det)
    {
        if (!isset($det)) {
            return '';
        }
        //ITENS
        $itensHtml = "<div class=\"float-left inteiro espacamentoqtde\">\n";
        $itensHtml .= "<div class=\"inteiro empresa\">\n";
            $itensHtml .= "<div class=\"float-left cinco\"> #</div>\n";
            $itensHtml .= "<div class=\"float-left dez\">".htmlspecialchars('CÓD.')."</div>\n";
            $itensHtml .= "<div class=\"float-left cinquentacinco\">".htmlspecialchars('DESCRIÇÃO')."</div>\n";
            $itensHtml .= "<div class=\"float-left quinze\"> QUANT.</div>\n";
            $itensHtml .= "<div class=\"float-left quinze text-right\"> VL.TOTAL</div>\n";
        $itensHtml .= "</div><br>\n";
        foreach ($det as $detI) {     
               
            $thisItem   = $detI;
            $prod       = $thisItem->getElementsByTagName("prod")->item(0);
            $nitem      = $thisItem->getAttribute("nItem");
            $cProd      = $this->pSimpleGetValue($prod, "cProd");
            $xProd      = $this->pSimpleGetValue($prod, "xProd");
            $qCom       = $qCom;
            $uCom       = $this->pSimpleGetValue($prod, "uCom");
            $vUnCom     = $vUnCom;
            $vProd      = $vProd;
			
            $qCom       = ($this->pSimpleGetValue($prod, "qCom")>0) ? number_format($this->pSimpleGetValue($prod, "qCom"), 2, ",", ".") : "0";
			$vUnCom     = ($this->pSimpleGetValue($prod, "vUnCom")>0) ? number_format($this->pSimpleGetValue($prod, "vUnCom"), 2, ",", ".") : "0";
			$vProd      = ($this->pSimpleGetValue($prod, "vProd")>0) ? number_format($this->pSimpleGetValue($prod, "vProd"), 2, ",", ".") : "0";
            
            $itensHtml .=  "<div class=\"inteiro empresa\">\n";
                $itensHtml .=  "<div class=\"float-left cinco\">".htmlspecialchars($nitem)."&nbsp</div>\n";
                $itensHtml .=  "<div class=\"float-left dez\">".htmlspecialchars($cProd)."&nbsp</div>\n";
                $itensHtml .=  "<div class=\"float-left cinquentacinco\">".htmlspecialchars(substr($xProd,0,32))."&nbsp</div>\n";
                $itensHtml .=  "<div class=\"float-left quinze\"> $qCom &nbsp</div>\n";
                $itensHtml .=  "<div class=\"float-left quinze text-right\"> $vProd &nbsp</div>\n";
            $itensHtml .=  "</div><br><br>\n";
        }
        $itensHtml .= "</div>\n";
        return $itensHtml;
    }//fim itens

    protected function consumidor($dest)
    {
        //DADOS DO CONSUMIDOR
        if (!isset($dest)) {
            return '';
        }
        $enderDest = $dest->getElementsByTagName("enderDest")->item(0);
        $consNome = $this->pSimpleGetValue($enderDest, "xNome");
        $consFone = $this->pSimpleGetValue($enderDest, "fone");
        $foneLen = strlen($consFone);
        if ($foneLen > 0) {
            $fone2 = substr($consFone, 0, $foneLen-4);
            $fone1 = substr($consFone, 0, $foneLen-8);
            $consFone = '('.$fone1.') '.substr($fone2, -4).'-'.substr($consFone, -4);
        } else {
            $consFone = '';
        }
        $consLgr = $this->pSimpleGetValue($enderDest, "xLgr");
        $consNro = $this->pSimpleGetValue($enderDest, "nro");
        $consCpl = $this->pSimpleGetValue($enderDest, "xCpl", " - ");
        $consBairro = $this->pSimpleGetValue($enderDest, "xBairro");
        $consCEP = $this->pFormat($this->pSimpleGetValue($enderDest, "CEP"));
        $consMun = $this->pSimpleGetValue($enderDest, "xMun");
        $consUF = $this->pSimpleGetValue($enderDest, "UF");
        $considEstrangeiro = $this->pSimpleGetValue($dest, "idEstrangeiro");
        $consCPF = $this->pSimpleGetValue($dest, "CPF");
        $consCNPJ = $this->pSimpleGetValue($dest, "CNPJ");
        $consDoc = $consCPF.$consCNPJ.$considEstrangeiro; //documentos do consumidor
        
        $consHtml = '';
        $consHtml .= "<table width='100%'>\n";
        $consHtml .= "<tr>\n<td>CONSUMIDOR</td>\n</tr>\n";
        $consHtml .= "<tr>\n<td>CNPJ/CPF/ID Estrangeiro : ".htmlspecialchars($consDoc)."</td>\n</tr>\n";
        $consHtml .= "<tr>\n<td>".htmlspecialchars($consNome)."</td>\n</tr>\n";
        $consHtml .= "<tr>\n";
        $consHtml .= "<td>".htmlspecialchars($consLgr.", ".$consNro.$consCpl)."<BR>\n".
                htmlspecialchars($consBairro." - ".$consCEP)."<BR>\n".
                htmlspecialchars($consMun." - ".$consUF." "."Fone/Fax: ".$consFone)."</td>\n";
        $consHtml .= "</tr>\n";
        $consHtml .= "</table>\n";
        return $consHtml;
    }//fim consumidor

    /**
     * 
     * @param type $nome
     * @param type $destino
     * @return type
     */
    public function printDANFE($output = 'pdf', $nome = '', $destino = 'I',$anoMes){

        if ($output == 'pdf') {
            //montagem do pdf
            if (is_array($this->papel) && strtolower($this->papel[1])=='one-page') {
                $mpdf=new mPDF('', array($this->papel[0], 841.89), 0, 'chelvetica', 0, 0, 0, 0, 0, 'P');
                $mpdf->useCoreFontsOnly = true;
                $mpdf->WriteHTML($this->html, 0, true, false);
                $this->papel=array($this->papel[0], $mpdf->y);
            }
            $this->mpdf=new mPDF('', $this->papel, 0, 'chelvetica', 0, 0, 0, 0, 0, 'P');
            $this->mpdf->WriteHTML($this->html);
            if (is_file($this->imgQRCode)) {
                unlink($this->imgQRCode);
            }
            $this->mpdf->Output($nome, $destino);
            
        } else {
            $tpAmb = $this->pSimpleGetValue($this->ide, 'tpAmb');
            if($tpAmb == 1){
                $tpAmb = 'producao';
            }else{
                $tpAmb = 'homologacao';
            }
            // $code = str_replace(array(" ","."), "", microtime(false));
            $html = fopen($this->uploads.$this->emp_codigo.'/nfe/'.$tpAmb.'/autorizadas/'.$anoMes.'/'.$this->chave.'.html', 'a+');
            fwrite($html, $this->html);
            fclose($html);

            exit('/uploads/'.$this->emp_codigo.'/nfe/'.$tpAmb.'/autorizadas/'.$anoMes.'/'.$this->chave.'.html');

            // if (is_file($this->imgQRCode)) {
            //     unlink($this->imgQRCode);
            // }
        }
        return true;
    }//fim printDANFE
    
    /**
     * str2Hex
     * Converte string para haxadecimal ASCII
     * @param type $str
     * @return string
     */
    protected static function str2Hex($str)
    {
        if ($str == '') {
            return '';
        }
        $hex = "";
        $iCount = 0;
        do {
            $hex .= sprintf("%02x", ord($str{$iCount}));
            $iCount++;
        } while ($iCount < strlen($str));
        return $hex;
    }//fim str2Hex
    
    /**
     * hex2Str
     * Converte hexadecimal ASCII para string
     * @param type $str
     * @return type
     */
    protected static function hex2Str($str)
    {
        if ($str == '') {
            return '';
        }
        $bin = "";
        $iCount = 0;
        do {
            $bin .= chr(hexdec($str{$iCount}.$str{($iCount + 1)}));
            $iCount += 2;
        } while ($iCount < strlen($str));
        return $bin;
    }//fim hex2Str

    protected function makeQRCode(
        $chNFe,
        $url,
        $tpAmb,
        $cDest = '',
        $dhEmi = '',
        $vNF = '',
        $vICMS = '',
        $digVal = '',
        $idToken = '000001',
        $Token = ''
    ) {
        $nVersao = '100'; //versão do QRCode
        
        $dhHex = self::str2Hex($dhEmi);
        $digHex = self::str2Hex($digVal);
        
        $seq = '';
        $seq .= 'chNFe=' . $chNFe;
        $seq .= '&nVersao=' . $nVersao;
        $seq .= '&tpAmb=' . $tpAmb;
        if ($cDest != '') {
            $seq .= '&cDest=' . $cDest;
        }
        $seq .= '&dhEmi=' . strtoupper($dhHex);
        $seq .= '&vNF=' . $vNF;
        $seq .= '&vICMS=' . $vICMS;
        $seq .= '&digVal=' . strtoupper($digHex);
        $seq .= '&cIdToken=' . $idToken.$Token;
        //o hash code é calculado com o Token incluso
        $hash = sha1($seq);
        $seq .= '&cHashQRCode='.$hash;
        if (strpos($url, '?') === false) {
            $seq = $url.'?'.$seq;
        } else {
            $seq = $url.'&'.$seq;
        }
        //remove o Token da mensagem
        $seq = str_replace($Token, '', $seq);
        $imgQrCode = new QRcode($seq, 'M');
        
        $data = date('YmdHis');
        if($tpAmb == 1){
            $varAmb = 'producao';
        }else{
            $varAmb = 'homologacao';
        }

        if(!is_dir($this->uploads.$this->emp_codigo.'/nfe/'.$varAmb)){
            mkdir($this->uploads.$this->emp_codigo.'/nfe/'.$varAmb, 0777);
        }
        if(!is_dir($this->uploads.$this->emp_codigo.'/nfe/'.$varAmb.'/qrcode')){
            mkdir($this->uploads.$this->emp_codigo.'/nfe/'.$varAmb.'/qrcode', 0777);
        }
        if(!is_dir($this->uploads.$this->emp_codigo.'/nfe/'.$varAmb.'/qrcode/'.date('Ym'))){
            mkdir($this->uploads.$this->emp_codigo.'/nfe/'.$varAmb.'/qrcode/'.date('Ym'), 0777);
        }

        $filename = $this->uploads.$this->emp_codigo.'/nfe/'.$varAmb.'/qrcode/'.date('Ym').'/'.$chNFe.$data.'.png';
        $imgQrCode->displayPNG(200, array(255,255,255), array(0,0,0), $filename, 0);

        return '/uploads/'.$this->emp_codigo.'/nfe/'.$varAmb.'/qrcode/'.date('Ym').'/'.$chNFe.$data.'.png';
        
    }//fim makeQRCode

}//fim Classe
