<?php 

	date_default_timezone_set('America/Sao_Paulo');
	
	header('Access-Control-Allow-Origin: *');
	header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
	
	include_once "/var/www/desktop/php/TParams.class.php";
	
	class Mdfe extends TParams {

		private $company;
		private $rowdata;
		private $emitente;
		private $carga = array();
		private $percurso = array();
		private $descarga = array();
		private $condutor = array();
		private $lacres = array();
		private $xml = '<?xml version="1.0" encoding="UTF-8"?>';

		public $tpAmb;
		public $dirAguardando;
		public $dirAutorizada;
		public $dirCancelada;
		public $dirDenegada;
		public $dirTemporaria;
		public $dirEncerrada;
		public $dirEventos;

		public function __construct($mdf_codigo, $emp_codigo){

			$filtroCompany = '{"cod":"500890","params":[
				{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"}
			]}';
			$this->setHost($this->getHost("empresas"));
			$this->add($filtroCompany);
			$ret = $this->open(true);
			$this->{'company'} = $ret[0];
			$this->clear();

			$filtroRowdata = '{"cod":"501095","params":[
				{"name":"database","value":"'.$this->{'company'}->{'emp_db_comum'}.'","type":"other"},
				{"name":"mdf_codigo","value":"'.$mdf_codigo.'","type":"string"}
			]}';
			$this->setHost($this->getHost($this->{'company'}->{'emp_db_sge'}));
			$this->add($filtroRowdata);
			$res = $this->open(true);
			$this->rowdata = $res[0];
			// echo $this->getLastQuery();
			$this->clear();

			$array_municipios = array();

			foreach ($res as $dados) {
				if($dados->{'mdm_tipo'} == 1){
					array_push($this->{'carga'}, $dados);
				}else if($dados->{'mdm_tipo'} == 2){
					array_push($this->{'percurso'}, $dados);
				}else if($dados->{'mdm_tipo'} == 3){
					array_push($array_municipios, $dados->{'mun_codigo'});
				}
			}

			$array_municipios = array_values(array_unique($array_municipios));

			foreach ($array_municipios as $municipio) {
				
				$obj = new stdClass();
				$obj->{'mun_codigo'} = $municipio;
				$obj->cte_key = array();
				$obj->not_key_nfe = array();

				foreach ($res as $dados) {
					if($dados->{"mdm_tipo"} == 3){
						if($dados->{'mun_codigo'} == $municipio){
							$obj->{'mun_cidade'} = $dados->{'mun_cidade'};
							if(isset($dados->{'cte_key'})&&!empty($dados->{'cte_key'})){
								array_push($obj->{'cte_key'}, $dados->{'cte_key'});
							}else if(isset($dados->{'not_key_nfe'})&&!empty($dados->{'not_key_nfe'})){
								array_push($obj->{'not_key_nfe'}, $dados->{'not_key_nfe'});
							} 
						}
					}
				}
				array_push($this->{'descarga'}, $obj);
			}

			if(!empty($this->{'rowdata'}->{'mdf_condutor'})){
				$this->{'condutor'} = json_decode(base64_decode($this->{'rowdata'}->{'mdf_condutor'}));
			}

			if(!empty($this->{'rowdata'}->{'mdf_lacre'})){
				$this->{'lacres'} = json_decode(base64_decode($this->{'rowdata'}->{'mdf_lacre'}));
			}

			$this->{'anomes'} = substr(date("Y",strtotime($this->{'rowdata'}->{'mdf_data'})),2,2).date("m",strtotime($this->{'rowdata'}->{'mdf_data'}));

			if($this->{'company'}->{'emp_ambcte'} == 1){
				$this->{'tpAmb'} = 'producao';
			}else{
				$this->{'tpAmb'} = 'homologacao';
			}
			
			// estrutura de pastas para armazenamento da cte
			$this->{'dirAguardando'} = $this->getUploads().$this->{'company'}->{'emp_codigo'}.'/mdfe/'.$this->{'tpAmb'}.'/aguardando/';
			$this->{'dirAutorizada'} = $this->getUploads().$this->{'company'}->{'emp_codigo'}.'/mdfe/'.$this->{'tpAmb'}.'/autorizadas/';
			$this->{'dirCancelada'}  = $this->getUploads().$this->{'company'}->{'emp_codigo'}.'/mdfe/'.$this->{'tpAmb'}.'/canceladas/';
			$this->{'dirDenegada'} 	 = $this->getUploads().$this->{'company'}->{'emp_codigo'}.'/mdfe/'.$this->{'tpAmb'}.'/denegadas/';
			$this->{'dirTemporaria'} = $this->getUploads().$this->{'company'}->{'emp_codigo'}.'/mdfe/'.$this->{'tpAmb'}.'/temporarias/';
			$this->{'dirEventos'} 	 = $this->getUploads().$this->{'company'}->{'emp_codigo'}.'/mdfe/'.$this->{'tpAmb'}.'/eventos/';
			$this->{'dirEncerrada'}  = $this->getUploads().$this->{'company'}->{'emp_codigo'}.'/mdfe/'.$this->{'tpAmb'}.'/encerradas/';
			if(!is_dir($this->{'dirAguardando'}.$this->{'anomes'})){
				@mkdir($this->{'dirAguardando'}.$this->{'anomes'}, 0777, true);
			}
			if(!is_dir($this->{'dirAutorizada'}.$this->{'anomes'})){
				@mkdir($this->{'dirAutorizada'}.$this->{'anomes'}, 0777, true);
			}
			if(!is_dir($this->{'dirCancelada'}.$this->{'anomes'})){
				@mkdir($this->{'dirCancelada'}.$this->{'anomes'}, 0777, true);
			}
			if(!is_dir($this->{'dirDenegada'}.$this->{'anomes'})){
				@mkdir($this->{'dirDenegada'}.$this->{'anomes'}, 0777, true);
			}
			if(!is_dir($this->{'dirTemporaria'}.$this->{'anomes'})){
				@mkdir($this->{'dirTemporaria'}.$this->{'anomes'}, 0777, true);
			}
			if(!is_dir($this->{'dirEventos'}.$this->{'anomes'})){
				@mkdir($this->{'dirEventos'}.$this->{'anomes'}, 0777, true);
			}
			if(!is_dir($this->{'dirEncerrada'}.$this->{'anomes'})){
				@mkdir($this->{'dirEncerrada'}.$this->{'anomes'}, 0777, true);
			}

		}

		public function getRowData() {
			return $this->{'rowdata'};
		}

		public function getCompany() {
			return $this->{'company'};
		} 

		public function getKeyDv($chave) {
			$soma_ponderada = 0;
			$multiplicadores = array(2,3,4,5,6,7,8,9);
			$i = 42;
			while ($i >= 0) {
				for ($m=0; $m<count($multiplicadores) && $i>=0; $m++) {
					$soma_ponderada+= $chave[$i] * $multiplicadores[$m];
					$i--;
				}
			}
			$resto = $soma_ponderada % 11;
			if ($resto == '0' || $resto == '1') {
				return 0;
			} else {
				return (11 - $resto);
		   }
		}

		public function getKey() {

			/*
			  · cUF - Código da UF do emitente do Documento Fiscal   2
			  · AAMM - Ano e Mês de emissão do CT-e 4
			  · CNPJ - CNPJ do emitente 14
			  · mod - Modelo do Documento Fiscal 2
			  · serie - Série do Documento Fiscal 3
			  · nCT - Número do Documento Fiscal 9
			  · tpEmis ? Forma de emissão do CT-e 1
			  · cCT - Código Numérico que compõe a Chave de Acesso 8
			  · cDV - Dígito Verificador da Chave de Acesso 1
			*/

			$cUF	= substr($this->{'company'}->{'emp_codmun'},0,2);
			$AAMM	= substr($this->{'rowdata'}->{'mdf_data'},2,2).substr($this->{'rowdata'}->{'mdf_data'},5,2);
			$CNPJ	= $this->{'company'}->{'emp_cpfcnpj'};
			$mod	= 58;
			$serie	= $this->{'rowdata'}->{'mdf_serie'};
			$nMDF	= $this->{'rowdata'}->{'mdf_numero'};
			$tpEmis	= $this->{'rowdata'}->{'mdf_tpemis'};
			$cMdf	= $this->{'rowdata'}->{'mdf_codigo'};

			// 02 - cUF  - código da UF do emitente do Documento Fiscal
			$chave = sprintf("%02d", $cUF);

			// 04 - AAMM - Ano e Mes de emissão da NF-e
			$chave.= sprintf("%04s", $AAMM);

			// 14 - CNPJ - CNPJ do emitente
			$chave.= sprintf("%014s", $CNPJ);

			// 02 - mod  - Modelo do Documento Fiscal
			$chave.= sprintf("%02d", $mod);

			// 03 - serie - Série do Documento Fiscal
			$chave.= sprintf("%03d", $serie);

			// 09 - nMDF  - Número do Documento Fiscal
			$chave.= sprintf("%09d", $nMDF);

			// 01 - tpEmis  - Tipo emissão 
			$chave.= sprintf("%01d", $tpEmis);

			// 08 - cMdf  - Código Numérico que compõe a Chave de Acesso // diminui 1 digito na versão 2.0
			$chave.= sprintf("%08d", $cMdf);

			// 01 - cDV  - Dígito Verificador da Chave de Acesso
			$chave.= $this->getKeyDv($chave);

			return $chave;
		}

		public function getXml(){

			$qcte = 0;
			$qnfe = 0;

			$this->xml .= '<MDFe xmlns="http://www.portalfiscal.inf.br/mdfe">';

				$this->xml .= '<infMDFe versao="1.00" Id="MDFe'.$this->getKey().'">';

					$this->xml .= '<ide>';
						
						$this->xml .= '<cUF>'.substr($this->{'company'}->{"emp_codmun"},0,2).'</cUF>';
						
						/*
							Identificação do ambiente em que foi emitido o documento e que irá identificá-lo no servidor do fisco. 
							Nesse caso, a emissão foi feita em ambiente de Homologação, como segue: 1 - Produção; 2 - Homologação 
						*/
						$this->xml .= '<tpAmb>'.$this->{'company'}->{"emp_ambcte"}.'</tpAmb>';

						$this->xml .= '<tpEmit>'.$this->{'rowdata'}->{'mdf_emitente'}.'</tpEmit>';
						
						$this->xml .= '<mod>58</mod>';
						
						$this->xml .= '<serie>'.$this->{'rowdata'}->{'mdf_serie'}.'</serie>';
						
						$this->xml .= '<nMDF>'.$this->{'rowdata'}->{'mdf_numero'}.'</nMDF>';
						
						$this->xml .= '<cMDF>'.$this->{'rowdata'}->{'mdf_codigo'}.'</cMDF>';
						
						$this->xml .= '<cDV>'.$this->getKeyDv($this->getKey()).'</cDV>';
						
						/*
							Identificação do modal do XML: ferroviário, hidroviário, aquaviário, aéreo ou rodoviário 
						*/
						$this->xml .= '<modal>'.$this->{'rowdata'}->{'mdf_modalidade'}.'</modal>';
						
						$this->xml .= '<dhEmi>'.str_replace(" ", "T", $this->{'rowdata'}->{'mdf_data'}).'</dhEmi>';
						
						$this->xml .= '<tpEmis>'.$this->{'rowdata'}->{'mdf_tpemis'}.'</tpEmis>';
						
						$this->xml .= '<procEmi>0</procEmi>';
						
						$this->xml .= '<verProc>1.1.4</verProc>';

						/*
							O campo UFIni deve ser usado para identificação do estado onde o transporte irá começar. 
							Lembrando, como é descrito em outros comentários, que essa UF não é identificada no campo infPercurso
						*/
						$this->xml .= '<UFIni>'.$this->{'rowdata'}->{'mdf_uf_ini'}.'</UFIni>';
						
						/*
							O campo UFFim deve ser usado para identificação do estado onde o transporte irá terminar. 
							Lembrando, como é descrito em outros comentários, que essa UF não é identificada no campo infPercurso 
						*/
						$this->xml .= '<UFFim>'.$this->{'rowdata'}->{'mdf_uf_fim'}.'</UFFim>';
						
						// carregamento
						foreach($this->{'carga'} as $carga){
							/*
								Município onde o carregamento da carga é feito a partir do endereço de onde 
								o transporte está saindo para transporte (origem) 
							*/
							$this->xml .= '<infMunCarrega>';
								
								$this->xml .= '<cMunCarrega>'.$carga->{'mun_codigo'}.'</cMunCarrega>';
								
								$this->xml .= '<xMunCarrega>'.$carga->{'mun_cidade'}.'</xMunCarrega>';
							
							$this->xml .= '</infMunCarrega>';
						}
						
						// percurso
						if(!empty($this->{'percurso'})){
							
							foreach($this->{'percurso'} as $percurso){
								/* 
									No campo infPercurso, informar quais UF o transporte irá passar sem que tenha carregamento, 
									ou seja, são os intermediários entre o início e fim (o início e fim há campos específicos, 
									portando não são inseridos no campo infPercurso. 
									Necessariamente deve estar na ordem em que o veículo irá seguir 
								*/
								$this->xml .= '<infPercurso>'; 
							
									$this->xml .= '<UFPer>'.$percurso->{'mun_uf_sigla'}.'</UFPer>';
							
								$this->xml .= '</infPercurso>';

							}
						}

						if(isset($this->{'rowdata'}->{'mdf_data_ini'})&&!empty($this->{'rowdata'}->{'mdf_data_ini'})&&$this->{'rowdata'}->{'mdf_data_ini'} != '0000-00-00 00:00:00'){
							$this->xml .= '<dhIniViagem>'.str_replace(" ", "T", $this->{'rowdata'}->{'mdf_data_ini'}).'</dhIniViagem>';
						}

					$this->xml .= '</ide>';
					
					/*
						Não tem segredo, aqui são as informações do emitente do MDFe, assim como nos outros documentos eletrônicos 
					*/
					$this->xml .= '<emit>';
						
						$this->xml .= '<CNPJ>'.$this->{'company'}->{"emp_cpfcnpj"}.'</CNPJ>';
		                
		                $this->xml .= '<IE>'.$this->{'company'}->{"emp_inscrg"}.'</IE>';
		                
		                $this->xml .= '<xNome>'.str_replace("&","",$this->{'company'}->{"emp_razao"}).'</xNome>';
		                
		                $this->xml .= '<xFant>'.str_replace("&","",$this->{'company'}->{"emp_fantasia"}).'</xFant>';
		                
		                $this->xml.='<enderEmit>';
						
							$this->xml.='<xLgr>'.$this->{'company'}->{"emp_endereco"}.'</xLgr>';
						
							$this->xml.='<nro>'.$this->{'company'}->{"emp_num"}.'</nro>';
						
							$this->xml.='<xBairro>'.$this->{'company'}->{"emp_bairro"}.'</xBairro>';
						
							$this->xml.='<cMun>'.$this->{'company'}->{"emp_codmun"}.'</cMun>';
						
							$this->xml.='<xMun>'.$this->{'company'}->{"emp_cidade"}.'</xMun>';
						
							$this->xml.='<CEP>'.$this->{'company'}->{"emp_cep"}.'</CEP>';
						
							$this->xml.='<UF>'.$this->{'company'}->{"emp_uf"}.'</UF>';
						
							$this->xml.='<fone>'.str_replace(array('-','(',')'),array('','',''),$this->{'company'}->{"emp_fone"}).'</fone>';	
						
							// $this->xml.='<cPais>1058</cPais>';
						
							// $this->xml.='<xPais>BRASIL</xPais>';
						
						$this->xml.='</enderEmit>';

					$this->xml .= '</emit>';
					
					$this->xml .= '<infModal versaoModal="1.00">';
						
						$this->xml .= '<rodo xmlns="http://www.portalfiscal.inf.br/mdfe">';
							
							/*
								Código do transportador no Registro Nacional de Transportadores Rodoviários de carga, 
								verificar link: http://www.antt.gov.br/index.php/content/view/4929/RNTRC___Registro_Nacional_de_Transportadores_Rodoviarios_de_Cargas.html
							*/
							if($this->{'company'}->{'emp_rntrc'}){
								$this->xml .= '<RNTRC>'.$this->{'company'}->{'emp_rntrc'}.'</RNTRC>';
							}else{
								$this->xml .= '<RNTRC>00000000</RNTRC>';
							}

							$this->xml .= '<CIOT>000000000000</CIOT>';
							
							if($this->{'rowdata'}->{'vei_tipo'} == 0){

								$this->xml .= '<veicTracao>';
									
									$this->xml .= '<placa>'.strtoupper($this->{'rowdata'}->{'vei_placa'}).'</placa>';
									
									$this->xml .= '<tara>'.$this->{'rowdata'}->{'vei_tara'}.'</tara>';
									
									$this->xml .= '<capKG>'.$this->{'rowdata'}->{'vei_capkg'}.'</capKG>';
									
									$this->xml .= '<capM3>'.$this->{'rowdata'}->{'vei_capm'}.'</capM3>';
										
									/*
										Descrição do condutor do veículo. Em um MDFe podem ser inseridos até 10 condutores em um mesmo XML
									*/
									foreach ($this->{'condutor'} as $condutor) {
										
										$this->xml .= '<condutor>';
										
											$this->xml .= '<xNome>'.substr(str_replace("&", "", $condutor->{'cad_nomeraz'}), 0, 60).'</xNome>';
										
											$this->xml .= '<CPF>'.substr(str_replace(array(".","-","/"), array("",""), $condutor->{'cad_cnpjcpf'}), 0, 11).'</CPF>';
										
										$this->xml .= '</condutor>';
									}

									$this->xml .= '<tpRod>'.$this->{'rowdata'}->{'vei_rodado'}.'</tpRod>';
			                        
			                        $this->xml .= '<tpCar>'.$this->{'rowdata'}->{'vei_carroceria'}.'</tpCar>';
			                        
			                        $this->xml .= '<UF>'.$this->{'rowdata'}->{'vei_uf'}.'</UF>';

									/*
										Descrição do proprietário do veículo descrito acima. 
										Só preenchido quando o veículo não pertencer à empresa emitente do MDF-e
									*/
									// if($this->{'rowdata'}->{'vei_proprietario'} == 1){
										
									// 	$this->xml .= '<prop>';
											
									// 		if(strlen($this->{'rowdata'}->{'vei_prop_cpf'}) > 11){
									// 			$this->xml .= '<CNPJ>'.$this->{'rowdata'}->{'vei_prop_cpf'}.'</CNPJ>';
									// 		}else{
									// 			$this->xml .= '<CPF>'.$this->{'rowdata'}->{'vei_prop_cpf'}.'</CPF>';
									// 		}
				                            
				     //                        $this->xml .= '<RNTRC>'.$this->{'rowdata'}->{'vei_prop_rntrc'}.'</RNTRC>';
				                            
				     //                        $this->xml .= '<xNome>'.str_replace("&", "", $this->{'rowdata'}->{'vei_prop_nome'}).'</xNome>';
				                            
				     //                        $this->xml .= '<IE>'.$this->{'rowdata'}->{'vei_prop_rg'}.'</IE>';
				                            
				     //                        $this->xml .= '<UF>'.$this->{'rowdata'}->{'vei_prop_uf'}.'</UF>';
				                            
				     //                        $this->xml .= '<tpProp>'.$this->{'rowdata'}->{'vei_prop_tipo'}.'</tpProp>';
										
									// 	$this->xml .= '</prop>';
									// }

								$this->xml .= '</veicTracao>';

							}else if($this->{'rowdata'}->{'vei_tipo'} == 1){

								$this->xml .= '<veicReboque>';
									
									$this->xml .= '<placa>'.strtoupper($this->{'rowdata'}->{'vei_placa'}).'</placa>';
									
									$this->xml .= '<tara>'.$this->{'rowdata'}->{'vei_tara'}.'</tara>';
									
									$this->xml .= '<capKG>'.$this->{'rowdata'}->{'vei_capkg'}.'</capKG>';
									
									$this->xml .= '<capM3>'.$this->{'rowdata'}->{'vei_capm'}.'</capM3>';
										
									/*
										Descrição do proprietário do veículo descrito acima. 
										Só preenchido quando o veículo não pertencer à empresa emitente do MDF-e
									*/
									if($this->{'rowdata'}->{'vei_proprietario'} == 1){
										
										$this->xml .= '<prop>';
				                        
				                            $this->xml .= '<RNTRC>'.$this->{'rowdata'}->{'vei_prop_rntrc'}.'</RNTRC>';
										
										$this->xml .= '</prop>';
									}
									
								$this->xml .= '</veicReboque>';

							}
						
						$this->xml .= '</rodo>';

					$this->xml .= '</infModal>';

					$this->xml .= '<infDoc>';
						/*
							Nesse campo é preciso descrever o último município onde haverá descarga, 
							lembrando que não é preciso que o UF de descarregamento esteja no campo infPercurso. 
							O descarregamento utilizando esse modelo de MDFe que estamos utilizando de exemplo pode ser 
							feito em vários municípios desde que na mesma UF, que nesse caso é na Paraíba. 
							Se houver a necessidade de descarregar em duas UFs diferentes, é necessário que haja 2 MDFe.
						*/
						foreach ($this->{'descarga'} as $descarga) {

							$this->xml .= '<infMunDescarga>';
								
								$this->xml .= '<cMunDescarga>'.$descarga->{'mun_codigo'}.'</cMunDescarga>';
								
								$this->xml .= '<xMunDescarga>'.$descarga->{'mun_cidade'}.'</xMunDescarga>';
								
								foreach ($descarga->{'cte_key'} as $cte) {
									
									$this->xml .= '<infCTe>';
									
										$this->xml .= '<chCTe>'.$cte.'</chCTe>';
									
									$this->xml .= '</infCTe>';
									
									$qcte++;
								}

								foreach ($descarga->{'not_key_nfe'} as $nfe) {
									
									$this->xml .= '<infNFe>';
									
										$this->xml .= '<chNFe>'.$nfe.'</chNFe>';
									
									$this->xml .= '</infNFe>';
									
									$qnfe++;
								}
								
							$this->xml .= '</infMunDescarga>';
						}

					$this->xml .= '</infDoc>';

					/*
						Grupo totalizador de informações do MDFe de acordo com os CTe vinculados. 
						A SEFAZ não faz nenhum tipo de validação automática com os CTe que estão no MDFe, 
						por isso esse campo é informado manualmente pelo emitente. 
						Esse valor pode, por exemplo, ser inserido pelo software do emitente
					*/
					$this->xml .= '<tot>';
						
						/*
							Quantidade total de CTe que estão vinculadas no XML do MDFe
						*/
						if($qcte > 0){
							$this->xml .= '<qCTe>'.$qcte.'</qCTe>';
						}

						/*
							Quantidade total de NFe que estão vinculadas no XML do MDFe
						*/
						if($qnfe > 0){
							$this->xml .= '<qNFe>'.$qnfe.'</qNFe>';	
						}
						
						/*
							Valor total da carga do MDFe informado pelo emitente
						*/
						$this->xml .= '<vCarga>'.number_format($this->{'rowdata'}->{'mdf_vcarga'}, 2, '.', '').'</vCarga>';
						
						/*
							Unidade de carga que é utilizada no campo qCarga, de acordo com tabela do manual
						*/
						$this->xml .= '<cUnid>'.$this->{'rowdata'}->{'mdf_cunid'}.'</cUnid>';
						
						/*
							Peso bruto da carga informado pelo emitente
						*/
						$this->xml .= '<qCarga>'.number_format($this->{'rowdata'}->{'mdf_qcarga'}, 4, '.', '').'</qCarga>';

					$this->xml .= '</tot>';

					foreach ($this->{'lacres'} as $lacre) {
						
						$this->xml .= '<lacres>';
							
							$this->xml .= '<nLacre>'.$lacre->{'_id'}.'</nLacre>';
						
						$this->xml .= '</lacres>';
					
					}
				
				$this->xml .= '</infMDFe>';
			
			$this->xml .= '</MDFe>';

			return $this->xml;

		}
	}

	/* Validacao dos parametros necessarios */

		if(!isset($_REQUEST['acao']) || empty($_REQUEST['acao'])){
			echo "Informar a ação";
			return false;
		}else{
			$acao = $_REQUEST['acao'];
		}

		if($_REQUEST['acao'] != 'consulta'){
			
			if(!isset($_REQUEST['mdf_codigo']) || empty($_REQUEST['mdf_codigo'])){
				echo "Informar o código do manifesto";
				return false;
			}else{
				$mdf_codigo = $_REQUEST['mdf_codigo'];
			}

			if(!isset($_REQUEST['p']) || empty($_REQUEST['p'])){
				echo "Informar a empresa";
				return false;
			}else{
				$code = base64_decode(substr($_REQUEST["p"],0,1).substr($_REQUEST["p"],2,strlen($_REQUEST["p"])));	
			}
			
			$Mdfe = new Mdfe($mdf_codigo, $code);
		}

	/*****************************************/

	include_once "../libs/MDFe/MDFeNFePHP.class.php";
	$MdfeTools = new MDFeNFePHP();
	$datapacket = new TParams();

	if($acao=='transmitir'){
		
		if(is_dir($Mdfe->{'dirTemporaria'}.$Mdfe->{'anomes'})){	
			
			$xml = $MdfeTools->signXML($Mdfe->getXml(), 'infMDFe');
			$variavel = "";
			$validacao = $MdfeTools->validXML($xml, '../schemes/PL_MDFe_100a_NT032015/mdfe_v1.00.xsd', $variavel);

			$nomeArquivo = $Mdfe->{'dirTemporaria'}.$Mdfe->{'anomes'}.'/'.$Mdfe->getKey().'-mdfe.xml';
			$arquivoXML = fopen($nomeArquivo,'w+');
			fwrite($arquivoXML, $xml);
			fclose($arquivoXML);

			if($arquivoXML){

				$arrXML = array();
				array_push($arrXML, $xml);
			
				$retorno = $MdfeTools->sendLot($arrXML, $Mdfe->getRowData()->{'mdf_numero'}, '2');

				if($retorno['dhRecbto']!=""){
					$dhRecbto = str_replace(array(":","/"),array("-","-"),$retorno['dhRecbto']);
					$arrDhRecbto = explode("-",$dhRecbto);
					$dhRecbto = substr($arrDhRecbto[2],0,-3)."-".$arrDhRecbto[1]."-".$arrDhRecbto[0]." ".substr($arrDhRecbto[2],-2)."-".$arrDhRecbto[3];
				}else{
					$dhRecbto = $retorno['dhRecbto'];
				}

				if($retorno){
				
					sleep(2);
					$recibo = $retorno['nRec'];

					$getProt = $MdfeTools->getProtocol($recibo, "", $Mdfe->getCompany()->{'emp_ambcte'});
					
					if($getProt['aProt'][0]['cStat']=='105'){
						sleep(4);
						$getProt = $MdfeTools->getProtocol($recibo, "", $Mdfe->getCompany()->{'emp_ambcte'});
					}

					$mdfefile = $nomeArquivo;
					$protfile = $Mdfe->{'dirTemporaria'}.$getProt['aProt'][0]['chMDFe'].'-prot.xml';

					$addprot=0;
					if ($xml = $MdfeTools->addProt($mdfefile, $protfile)){
						$addprot=1;
						sleep(2);
						file_put_contents($nomeArquivo, $xml);
					}

					if(!$getProt['aProt'][0]['cStat']){
						if(!$retorno['cStat']){
							$getProt['aProt'][0]['cStat']=0;
						}else{
							$getProt['aProt'][0]['cStat']=$retorno['cStat'];
						}
					}

					if(isset($getProt['aProt'][0]['nProt'])){
						$nprotatt = $getProt['aProt'][0]['nProt'];
					}else{
						$nprotatt = "00000";
					}

					if($getProt['aProt'][0]['cStat'] == '100'){
						$mdf_status = 2;
					}else if($getProt['aProt'][0]['cStat'] == '103'){
						$mdf_status = 1;
					}else if($getProt['aProt'][0]['cStat'] == '999'){
						$mdf_status = 1;
					}else if($getProt['aProt'][0]['cStat'] == '9998'){
						$mdf_status = 1;
					}else{
						$mdf_status = 0;
					}

					if(!isset($getProt['aProt'][0]['chMDFe'])){
						$getProt['aProt'][0]['chMDFe'] = "";
					} 
					
					$filtroUpdt = '{"cod":"501101","params":[
						{"name":"mdf_codigo","value":"'.$mdf_codigo.'","type":"string"},
						{"name":"mdf_cstat","value":"'.$getProt['aProt'][0]['cStat'].'","type":"string"},
						{"name":"mdf_xmotivo","value":"'.base64_encode($getProt['aProt'][0]['xMotivo']).'","type":"string"},
						{"name":"mdf_chave","value":"'.$getProt['aProt'][0]['chMDFe'].'","type":"string"},
						{"name":"mdf_nprot","value":"'.$getProt['aProt'][0]['nProt'].'","type":"string"},
						{"name":"mdf_status","value":"'.$mdf_status.'","type":"integer"}
					]}';
					$datapacket->setHost($datapacket->getHost($Mdfe->getCompany()->{'emp_db_sge'}));
					$datapacket->add($filtroUpdt);
					$datapacket->open();
					$datapacket->clear();

					if($getProt['aProt'][0]['cStat'] == '100'){
						copy($Mdfe->{'dirTemporaria'}.$Mdfe->{'anomes'}.'/'.$getProt['aProt'][0]['chMDFe'].'-mdfe.xml', $Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}.'/'.$getProt['aProt'][0]['chMDFe'].'-mdfe.xml');
						unlink($Mdfe->{'dirTemporaria'}.$Mdfe->{'anomes'}.'/'.$getProt['aProt'][0]['chMDFe'].'-mdfe.xml');
					}

					print_r(json_encode($getProt));

				}else{
					exit('Possivelmente o certificado não está correto.');
				}
			}
		}

	}else if($acao=='encerrar'){

		$params = $_REQUEST;

		$resp='';
		$retorno = $MdfeTools->manifDest($Mdfe->getRowData()->{'mdf_chave'}, 12, $Mdfe->getCompany()->{'emp_ambcte'}, $Mdfe->getRowData()->{'mdf_uf_fim'}, 2, $resp, '', $params);

		if(is_array($retorno) || strpos($retorno, '631') > 0){
			
			if(strpos($retorno, '631') > 0){
				$retorno = array();
				$retorno['cStat'] = '135';
				$retorno['xMotivo'] = "Evento registrado e vinculado ao MDF-e";
			}

			$filtroUpdt = '{"cod":"501102","params":[
				{"name":"mdf_codigo","value":"'.$mdf_codigo.'","type":"string"},
				{"name":"mdf_cstat","value":"'.$retorno['cStat'].'","type":"string"},
				{"name":"mdf_xmotivo","value":"'.base64_encode($retorno['xMotivo']).'","type":"string"},
				{"name":"mdf_status","value":"4","type":"integer"}
			]}';
			$datapacket->setHost($datapacket->getHost($Mdfe->getCompany()->{'emp_db_sge'}));
			$datapacket->add($filtroUpdt);
			$datapacket->open();
			$datapacket->clear();

			if($retorno['cStat'] == '135'){
				copy($Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}.'/'.$Mdfe->getRowData()->{'mdf_chave'}.'-mdfe.xml', $Mdfe->{'dirEncerrada'}.$Mdfe->{'anomes'}.'/'.$Mdfe->getRowData()->{'mdf_chave'}.'-mdfe.xml');
				unlink($Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}.'/'.$Mdfe->getRowData()->{'mdf_chave'}.'-mdfe.xml');
			}
			
			print_r(json_encode($retorno));
		
		}else{

			print_r($retorno);
		}

	}else if($acao=='cancelar'){

		$params = $_REQUEST;
		$resp='';
		$retorno = $MdfeTools->manifDest($Mdfe->getRowData()->{'mdf_chave'}, 11, $Mdfe->getCompany()->{'emp_ambcte'}, $Mdfe->getRowData()->{'mdf_uf_fim'}, 2, $resp, $params['xJust'], $params);
		
		if(is_array($retorno)){
		
			$filtroUpdt = '{"cod":"501102","params":[
				{"name":"mdf_codigo","value":"'.$mdf_codigo.'","type":"string"},
				{"name":"mdf_cstat","value":"'.$retorno['cStat'].'","type":"string"},
				{"name":"mdf_xmotivo","value":"'.base64_encode($retorno['xMotivo']).'","type":"string"},
				{"name":"mdf_status","value":"3","type":"integer"}
			]}';
			$datapacket->setHost($datapacket->getHost($Mdfe->getCompany()->{'emp_db_sge'}));
			$datapacket->add($filtroUpdt);
			$datapacket->open();
			$datapacket->clear();

			if($retorno['cStat'] == '135'){
				copy($Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}.'/'.$Mdfe->getRowData()->{'mdf_chave'}.'-mdfe.xml', $Mdfe->{'dirCancelada'}.$Mdfe->{'anomes'}.'/'.$Mdfe->getRowData()->{'mdf_chave'}.'-mdfe.xml');
				unlink($Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}.'/'.$Mdfe->getRowData()->{'mdf_chave'}.'-mdfe.xml');
			}

			print_r(json_encode($retorno));
		
		}else{
			print_r($retorno);
		}

	}else if($acao=='email'){

		// classe p/ envio
		include_once(dirname(dirname(dirname(__DIR__))) . "/class/PHPMailer_v5.1/class.phpmailer.php");
		
		// xml
			
			if($Mdfe->getRowData()->{'mdf_status'} == 2){
				if(is_file($Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml")){
					$xml = $Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml";
				}else{
					echo "O MDFe não foi encontrado!";
					exit();
				}
			}else if($Mdfe->getRowData()->{'mdf_status'} == 3){
				if(is_file($Mdfe->{'dirCancelada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml")){
					$xml = $Mdfe->{'dirCancelada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml";
				}else{
					echo "O MDFe não foi encontrado!";
					exit();
				}
			}else if($Mdfe->getRowData()->{'mdf_status'} == 4){
				if(is_file($Mdfe->{'dirEncerrada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml")){
					$xml = $Mdfe->{'dirEncerrada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml";
				}else{
					if(is_file($Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml")){
						$xml = $Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml";
					}else{
						echo "O MDFe não foi encontrado!";
						exit();
					}
				}
			}else{
				echo "O MDF-e não foi encontrado!";
				exit();
			}

			ob_start();
			$ch = curl_init(); 
			curl_setopt($ch, CURLOPT_URL, $_SERVER['HTTP_REFERER']."rel/damdfePdf.php?mdf_codigo=" . $mdf_codigo . "&p=" . $_REQUEST['p']); 
			curl_exec($ch); 
			curl_close($ch);
			$pdf = ob_get_clean();
			sleep(2);

		/*******/

		// email
		$mail = new PHPMailer();
		$mail->Charset = 'UTF-8';
	    $mail->IsHTML(true);
	    $mail->SetLanguage("br");
	    // $mail->isSMTP();
	    // $mail->SMTPAuth = false;
	    $mail->Port = 587;
	    $mail->Host = strtolower($Mdfe->getCompany()->{'emp_hostsmtp'});
	    $mail->Username = strtolower($Mdfe->getCompany()->{'emp_emailremetente'});
	    $mail->Password = $Mdfe->getCompany()->{'emp_pwdsmtp'};
	    $mail->From = strtolower($_REQUEST['email']);    
	    $mail->Subject = utf8_decode("MDF-e " . $Mdfe->getRowData()->{'mdf_numero'});
	    $mail->Body = utf8_decode('<p> Segue em anexo o magnéticos relacionado ao MDF-e nº' . $Mdfe->getRowData()->{'mdf_numero'} . ' </p>');
	    $mail->AddAddress($_REQUEST['email']);
	    $mail->AddAttachment($xml);
	    $mail->AddAttachment($pdf);
		
		if($mail->send()){
			exit('ok');
		}else{
			exit('erro');
		}

	}else if($acao=='damdfe'){

		include_once dirname(__DIR__) . "/libs/MDFe/DamdfeNFePHP.class.php";

		if($Mdfe->getRowData()->{'mdf_status'} == 2){
			if(is_file($Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml")){
				$xml = $Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml";
			}else{
				echo "O MDFe não foi encontrado!";
				exit();
			}
		}else if($Mdfe->getRowData()->{'mdf_status'} == 3){
			if(is_file($Mdfe->{'dirCancelada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml")){
				$xml = $Mdfe->{'dirCancelada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml";
			}else{
				echo "O MDFe não foi encontrado!";
				exit();
			}
		}else if($Mdfe->getRowData()->{'mdf_status'} == 4){
			if(is_file($Mdfe->{'dirEncerrada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml")){
				$xml = $Mdfe->{'dirEncerrada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml";
			}else{
				echo "O MDFe não foi encontrado!";
				exit();
			}
		}else{
			echo "O MDF-e não foi encontrado!";
			exit();
		}

		$damdfe = new DamdfeNFePHP($xml, "P", "A4", $Mdfe->{'dirAutorizada'}, "I", "Times", 2);
		$as = $damdfe->printMDFe();
		print_r($as);


	}else if($acao=='baixaXml'){

		if($Mdfe->getRowData()->{'mdf_status'} == 2){
			if(is_file($Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml")){
				$xml = $Mdfe->{'dirAutorizada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml";
			}else{
				echo "O MDFe não foi encontrado!";
				exit();
			}
		}else if($Mdfe->getRowData()->{'mdf_status'} == 3){
			if(is_file($Mdfe->{'dirCancelada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml")){
				$xml = $Mdfe->{'dirCancelada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml";
			}else{
				echo "O MDFe não foi encontrado!";
				exit();
			}
		}else if($Mdfe->getRowData()->{'mdf_status'} == 4){
			if(is_file($Mdfe->{'dirEncerrada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml")){
				$xml = $Mdfe->{'dirEncerrada'}.$Mdfe->{'anomes'}."/".$Mdfe->getRowData()->{'mdf_chave'}."-mdfe.xml";
			}else{
				echo "O MDFe não foi encontrado!";
				exit();
			}
		}else{
			echo "O MDF-e não foi encontrado!";
			exit();
		}

		header("Content-Type: application/xml");
		header("Content-Length: ".filesize($xml));
		header("Content-Disposition: attachment; filename=".basename($xml));
		readfile($xml);
		exit();

	}else if($acao=='consulta'){

		/*
			p: codigo da empresa
			acao: consulta
			mdf_key: chave do manifesto
		*/
		if(isset($_REQUEST['mdf_key']) && !empty($_REQUEST['mdf_key'])) {
			print_r(json_encode($MdfeTools->getProtocol("", $_REQUEST['mdf_key'], 2)));
		} else {
			exit('Informe a chave para consulta!');
		}


	}

 ?>