<?php

	date_default_timezone_set('America/Sao_Paulo');
	
	header('Access-Control-Allow-Origin: *');
	header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");

	session_start();
	
	include_once"../../class/datapacket.php";
	include_once '../../sge/TParams.class.php';
	include_once "../libs/NFe/MakeNFePHP.class.php";
	include_once "../libs/NFe/ToolsNFePHP.class.php";
	include_once "../libs/NFe/DanfeNFePHP.class.php";
	include_once "../libs/NFe/DanfeNFCeNFePHP.class.php";

	//instancia ferramentas NFe e classes para atualização do BD
	$tools = new ToolsNFePHP;
	$TParams = new TParams();
	$Datapacket = new Datapacket();
	
	
	
	
	//pega dados da empresa
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$_REQUEST["emp_codigo"].'","type":"string"}
	]}';
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	$company = $company[0];
	//sleep(1);
	$Datapacket->clear();
	
	//pega dados da nfe
	$filtroNota = '{"cod":"700002","params":[
		{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
		{"name":"db","value":"'.$company->emp_db_comum.'","type":"other"}
	]}';
	$Datapacket->setHost($TParams->getHost($company->emp_db_sge));
	$Datapacket->add($filtroNota);
	$nota = $Datapacket->open(true);
	//sleep(1);
	$Datapacket->clear();
	
	
	
			
	$Datapacket->setHost($TParams->getHost($company->{'emp_db_sge'}));
	
	$amb = ($company->{'emp_amb_nfe'}==2) ? "homologacao" : "producao";
	
	//pasta padrão para o xml
	$nfeDir = TParams::$uploads.$_REQUEST["emp_codigo"].'/nfe/'.$amb.'/';

	if(!is_dir($nfeDir)){
		@mkdir($nfeDir,0777);
	}
	
	if(is_dir($nfeDir)){
		
		//Criar e escrever arquivo XML com os dados gerados
		$nomeArquivo = $nfeDir.$_REQUEST["key"].'-nfe.xml';		
		
		$aErro = array();
		$docxml = file_get_contents($nomeArquivo);

		//acao=transmitir
		if($_REQUEST["acao"]=="transmitir"){
			
			//Validar XML
			if (!$tools->validXML($docxml, '../schemes/PL_008d/nfe_v3.10.xsd', $aErro)) {
				
				//XML inválido - erro
				$erro = 'Erro(s) na estrutura XML: <br>';
				foreach ($aErro as $er) {
					$erro.= $er .'<br>';
				}
				//Atualização do log com os dados de erros no XML
				/*
				$filtrolog = '{"cod":"700103","params":[
					{"name":"log_tipo","value":"2","type":"integer"},
					{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
					{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
					{"name":"log_usu_login","value":"NULL","type":"other"},
					{"name":"log_acao_cod","value":"2","type":"integer"},
					{"name":"log_acao_descr","value":"edição","type":"string"},
					{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"log_protocolo","value":"NULL","type":"other"},
					{"name":"log_ret","value":"NULL","type":"other"},
					{"name":"log_outro","value":"'.base64_encode(str_replace("<br>", "; ", $erro)).'","type":"string"}
				]}';
				$Datapacket->add($filtrolog);
				$Datapacket->open();

				//classe p/ envio
				include_once "../libs/MailNFePHP.class.php";
				
				//dados de configuração de envio
				$config = array(
					"mailAuth"=>"0",
					"mailFROM"=>$company->{"emp_emailremetente"},
					"mailHOST"=>'127.0.0.1',
					"mailUSER"=>$company->{"emp_emailremetente"},
					"mailPASS"=>$company->{"emp_pwdsmtp"},
					"mailPORT"=>"587",
					"mailPROTOCOL"=>"",
					"mailFROMmail"=>$company->{"emp_emailremetente"},
					"mailFROMname"=>$company->{"emp_fantasia"},
					"mailREPLYTOmail"=>$company->{"emp_emailremetente"},
					"mailREPLYTOname"=>$company->{"emp_fantasia"},
					"mailIMAPhost"=>"",
					"mailIMAPport"=>"",
					"mailIMAPsecurity"=>"",
					"mailIMAPnocerts"=>"",
					"mailIMAPbox"=>"",
					"recebidasDir"=>"",
					"temporariasDir"=>"",
					"canceladasDir"=>"",
					"CNPJ"=>$company->{"emp_cpfcnpj"},
					"mailLayoutFile"=>""
				);

				$email = new MailNFePHP($config);
				$msg = str_replace(" ","+",$_REQUEST["msg"]);
				$msg = base64_decode($msg);

				$to = base64_decode($_REQUEST["email"]);
				$to = str_replace(" ", "", $to);
				if(strstr($to, ";")) $to = explode(";", $to);
				elseif(strstr($to, ",")) $to = explode(",", $to);
				
				$cliente = $nota[0]->{"cad_nomeraz"};
				$assunto = utf8_decode("Erro de NF-e - C: ".$company->{"emp_codigo"}." - S: ".$nota[0]->{"ser_codigo"}." - N: ".$nota[0]->{"not_numero"});
				if(isset($nomeArquivo) && $nomeArquivo!=""){
					$arqxml = $nomeArquivo;
				}else{
					$arqxml = "";
				}
				$arqpdf = "";
				$auth = "0";
				$outro = "";

				//texto puro (sem html)
				$txt = strip_tags($msg);

				if(is_array($to)){

					$msgfinal = "";
					foreach($to as $para){
						if($email->sendM($para, $cliente, $assunto, utf8_decode($txt), utf8_decode($msg), $arqxml, $arqpdf, $auth, $outro))
							$msgfinal.= $para." - Enviado!<br>";
						else
							$msgfinal.= $para." - Não Enviado!<br>";
					}
					exit($msgfinal);

				}else{

					if( $email->sendM($to, $cliente, $assunto, utf8_decode($txt), utf8_decode($msg).$arqpdf, $arqxml, $arqpdf, $auth, $outro) ){
						exit("E-mail enviado com sucesso!");
					}else{
						exit("<br><div style='margin:10px;background-color:#fde8e8;border:1px #ffd6d6 solid; border-radius:8px'><div style='padding:2px;border:1px #fee2e2 solid; border-radius:8px'>".$erro."</div></div><br>Ação:Validar Xml");
					}

				}
				*/
				
				echo $erro;

			}else if(1==2){ //XML válido prosseguir
				
				//Assinar XML
				if ($xml = $tools->signXML($docxml, 'infNFe')){
				
					file_put_contents($nomeArquivo, $xml);
					$docxml = file_get_contents($nomeArquivo);
				
					//Obter um numero de lote
					$lote = substr(str_replace(',','',number_format(microtime(true)*1000000,0)),0,15);
					
					//Enviar o lote
					if ($retorno = $tools->autoriza($docxml, $lote, $aResp)){

						if ($retorno['bStat']){
									
							//Pegar Protocolo
							if($prot = $tools->getProtocol("", $chave, $tpAmb, $retorno)){
								$nfefile 	= $nomeArquivo;
								$protfile 	= $nfeDir.$chave.'-prot.xml';

								//Criar arquivo protocolo
								$arquivoProt = fopen($protfile,'w+');
								fwrite($arquivoProt, $prot);
								fclose($arquivoProt);
								
								//Adicionar Protocolo ao XML da NF-e
								if ($xml = $tools->addProt($nfefile, $protfile)){
									file_put_contents($nfefile, $xml);
								}
							}
							
							
							$dhRecbto = implode("-", array_reverse(explode("/", substr($retorno["aProt"]["dhRecbto"], 0, 10))));
							$dhRecbto.= substr($retorno["aProt"]["dhRecbto"], 10, 9);
							
							if($retorno['cStat']=="100"){
								
								//Fazer lançamento no financeiro caso haja opção de pagamento com entrada em dinheiro
								if($nota[0]->{'not_entrsaida'}==2 && (!$nota[0]->{'not_finanatualiz'} || $nota[0]->{'not_finanatualiz'}==0) ){
									$cdp_json = json_decode(base64_decode($nota[0]->{"cdp_json"}));
									if($cdp_json){
										if($cdp_json->{'prazo'}[0]->{0}==10){
											$lan_valor = $nota[0]->{"not_totalnota"}/(int) (count($cdp_json->{'prazo'}));
											$lan_valor = number_format($lan_valor, 5, ".", "");
											$filtrolancto = '{"cod":"700109","params":[
												{"name":"lan_historico","value":"NF-e N '.$nota[0]->{"not_numero"}.' - LANCAMENTO CRIADO A PARTIR DE NOTA FISCAL DE SAIDA","type":"string"},
												{"name":"lan_data","value":"'.$dhRecbto.'","type":"string"},
												{"name":"lan_valor","value":"'.$lan_valor.'","type":"float"},
												{"name":"lan_conc","value":"0","type":"integer"},
												{"name":"lan_dc","value":"2","type":"integer"},
												{"name":"ser_codigo","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
												{"name":"cta_codigo","value":"'.$nota[0]->{"cta_codigo"}.'","type":"string"},
												{"name":"plc_codigo","value":"NULL","type":"other"},
												{"name":"doc_codigo","value":"NULL","type":"other"},
												{"name":"ccu_codigo","value":"NULL","type":"other"},
												{"name":"lan_dtmov","value":"NULL","type":"other"}
											]}';
											$Datapacket->add($filtrolancto);
										}
									}
								}
								
								//Atualização do estoque do(s) produto(s) (caso ainda não esteja atualizado)
								if( !$nota[0]->{'not_stokatualiz'} || $nota[0]->{'not_stokatualiz'}==0 ){
									foreach($nota as $not){
										$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
										$loc_codigo = ($not->{'loc_codigo'}) ? $not->{'loc_codigo'} : "1";
										$stk_qde = ($nota[0]->{'not_entrsaida'}==2) ? '-'.$not->{'itn_qtde'} : $not->{'itn_qtde'};
										$filtrostk = '{"cod":"700111","params":[
											{"name":"db","value":"'.$company->{"emp_db_comum"}.'","type":"other"},
											{"name":"emp_codigo","value":"'.$company->{"emp_codigo"}.'","type":"string"},
											{"name":"loc_codigo","value":"'.$loc_codigo.'","type":"string"},
											{"name":"lot_codigo","value":"018","type":"string"},
											{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"},
											{"name":"ser_codigo","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
											{"name":"stk_data","value":"'.$dhRecbto.'","type":"string"},
											{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
											{"name":"stk_qde","value":"'.$stk_qde.'","type":"float"}
										]}';
										$Datapacket->add($filtrostk);
									}
								}
								
								//Atualizar os dados de retorno da NF-e no banco de dados (autorizada)
								$filtroAtualiza = '{"cod":"700105","params":[
									{"name":"not_status","value":"2","type":"integer"},
									{"name":"not_dtfaturam","value":"'.$dhRecbto.'","type":"string"},
									{"name":"not_dtprevisao","value":"'.$dhRecbto.'","type":"string"},
									{"name":"not_dtentrega","value":"'.$dhRecbto.'","type":"string"},
									{"name":"not_finanatualiz","value":"1","type":"integer"},
									{"name":"not_stokatualiz","value":"1","type":"integer"},
									{"name":"not_custoautaliz","value":"1","type":"integer"},
									{"name":"not_key_nfe","value":"'.$retorno["chNFe"].'","type":"string"},
									{"name":"not_result","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
									{"name":"not_cstat","value":"'.$retorno['cStat'].'","type":"string"},
									{"name":"not_xmotivo","value":"'.base64_encode($retorno['xMotivo']).'","type":"string"},
									{"name":"not_aliq","value":"'.$itn_aliqicms.'","type":"string"},
									{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
									{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},';

								if($retorno["aProt"]["nProt"]){
									$filtroAtualiza .= '{"name":"not_nprot","value":"'.$retorno["aProt"]["nProt"].'","type":"string"}';
								}else{
									$filtroAtualiza .= '{"name":"not_nprot","value":"","type":"null"}';
								}

								$filtroAtualiza.=']}';
								
								$Datapacket->add($filtroAtualiza);
								
								//Atualização do Log da NF-e com os dados transmitidos
								$filtrolog = '{"cod":"700103","params":[
									{"name":"log_tipo","value":"2","type":"integer"},
									{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
									{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
									{"name":"log_usu_login","value":"NULL","type":"other"},
									{"name":"log_acao_cod","value":"3","type":"integer"},
									{"name":"log_acao_descr","value":"transmissão","type":"string"},
									{"name":"log_data","value":"'.$dhRecbto.'","type":"string"},
									{"name":"log_protocolo","value":"'.$retorno["aProt"]["nProt"].'","type":"string"},
									{"name":"log_ret","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
									{"name":"log_outro","value":"'.base64_encode("NF-e transmitida com sucesso!").'","type":"string"}
								]}';
								$Datapacket->add($filtrolog);
								
								$Datapacket->open(true);
								
								//print_r($Datapacket->getLastQuery());
								
								echo "NF-e transmitida com sucesso! Chave: ".$retorno["chNFe"];
							
							}else{
								
								$not_finanatualiz = ( isset($nota[0]->{"not_finanatualiz"}) ) ? $nota[0]->{"not_finanatualiz"} : "0";
								$not_stokatualiz = ( isset($nota[0]->{"not_stokatualiz"}) ) ? $nota[0]->{"not_stokatualiz"} : "0";
								$not_custoautaliz = ( isset($nota[0]->{"not_custoautaliz"}) ) ? $nota[0]->{"not_custoautaliz"} : "0";
								
								//atualiza status nf-e no banco para 1 (aguardando retorno)
								$filtroAtualiza = '{"cod":"700105","params":[
									{"name":"not_status","value":"1","type":"integer"},
									{"name":"not_dtfaturam","value":" ","type":"string"},
									{"name":"not_dtprevisao","value":" ","type":"string"},
									{"name":"not_dtentrega","value":" ","type":"string"},
									{"name":"not_finanatualiz","value":"'.$not_finanatualiz.'","type":"integer"},
									{"name":"not_stokatualiz","value":"'.$not_stokatualiz.'","type":"integer"},
									{"name":"not_custoautaliz","value":"'.$not_custoautaliz.'","type":"integer"},
									{"name":"not_key_nfe","value":"'.$chave.'","type":"string"},
									{"name":"not_result","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
									{"name":"not_cstat","value":"'.$retorno['cStat'].'","type":"string"},
									{"name":"not_xmotivo","value":"'.base64_encode($retorno['xMotivo']).'","type":"string"},
									{"name":"not_aliq","value":"'.$itn_aliqicms.'","type":"string"},
									{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
									{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},';

								if($retorno["aProt"]["nProt"]){
									$filtroAtualiza .= '{"name":"not_nprot","value":"'.$retorno["aProt"]["nProt"].'","type":"string"}';
								}else{
									$filtroAtualiza .= '{"name":"not_nprot","value":"NULL","type":"other"}';
								}

								$filtroAtualiza.=']}';
								
								$Datapacket->add($filtroAtualiza);
								
								//Atualização do Log da NF-e
								$filtrolog = '{"cod":"700103","params":[
									{"name":"log_tipo","value":"2","type":"integer"},
									{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
									{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
									{"name":"log_usu_login","value":"NULL","type":"other"},
									{"name":"log_acao_cod","value":"3","type":"integer"},
									{"name":"log_acao_descr","value":"transmissão","type":"string"},
									{"name":"log_data","value":"'.$dhRecbto.'","type":"string"},
									{"name":"log_protocolo","value":"'.$retorno["aProt"]["nProt"].'","type":"string"},
									{"name":"log_ret","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
									{"name":"log_outro","value":"'.base64_encode($retorno['xMotivo']).'","type":"string"}
								]}';
								$Datapacket->add($filtrolog);
								
								$Datapacket->open(true);
							
								echo "NF-e aguardando retorno!";
								
							}
								
						} else {
						
							$filtrolog = '{"cod":"700103","params":[
								{"name":"log_tipo","value":"2","type":"integer"},
								{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
								{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
								{"name":"log_usu_login","value":"NULL","type":"other"},
								{"name":"log_acao_cod","value":"3","type":"integer"},
								{"name":"log_acao_descr","value":"transmissão","type":"string"},
								{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
								{"name":"log_protocolo","value":"NULL","type":"other"},
								{"name":"log_ret","value":"NULL","type":"other"},
								{"name":"log_outro","value":"'.base64_encode("Erro!: ".$tools->errMsg).'","type":"string"}
							]}';
							$Datapacket->add($filtrolog);
							$Datapacket->open();
							echo "Erro!: ".$tools->errMsg;
							
						}

					} else {

						//Atualização do log com dados de erro na tentativa de transmissão
						$filtrolog = '{"cod":"700103","params":[
							{"name":"log_tipo","value":"2","type":"integer"},
							{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
							{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
							{"name":"log_usu_login","value":"NULL","type":"other"},
							{"name":"log_acao_cod","value":"3","type":"integer"},
							{"name":"log_acao_descr","value":"transmissão","type":"string"},
							{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
							{"name":"log_protocolo","value":"NULL","type":"other"},
							{"name":"log_ret","value":"NULL","type":"other"},
							{"name":"log_outro","value":"'.base64_encode("Erro!: ".$tools->errMsg).'","type":"string"}
						]}';
						$Datapacket->add($filtrolog);
						$Datapacket->open();
						echo "Erro!: ".$tools->errMsg;
						
					}
				
				} else {
			
					//Atualização do log com erro de assinatura de XML
					$filtrolog = '{"cod":"700103","params":[
						{"name":"log_tipo","value":"2","type":"integer"},
						{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
						{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
						{"name":"log_usu_login","value":"NULL","type":"other"},
						{"name":"log_acao_cod","value":"3","type":"integer"},
						{"name":"log_acao_descr","value":"transmissão","type":"string"},
						{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"log_protocolo","value":"NULL","type":"other"},
						{"name":"log_ret","value":"NULL","type":"other"},
						{"name":"log_outro","value":"'.base64_encode("Erro na Assinatura XML: ".$tools->errMsg).'","type":"string"}
					]}';
					$Datapacket->add($filtrolog);
					$Datapacket->open();
				
					echo "Erro na Assinatura XML: ".$tools->errMsg;
				}
				
			}
			
		//acao = imprimir DANFE
		}elseif($_REQUEST["acao"]=="imprimir"){
			
			//Atualização do log (impressao)
			$filtrolog = '{"cod":"700103","params":[
				{"name":"log_tipo","value":"2","type":"integer"},
				{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
				{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
				{"name":"log_usu_login","value":"NULL","type":"other"},
				{"name":"log_acao_cod","value":"4","type":"integer"},
				{"name":"log_acao_descr","value":"impressão","type":"string"},
				{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
				{"name":"log_protocolo","value":"NULL","type":"other"},
				{"name":"log_ret","value":"NULL","type":"other"},
				{"name":"log_outro","value":"'.base64_encode("Impressão da DANFE").'","type":"string"}
			]}';
			$Datapacket->add($filtrolog);
			$Datapacket->open();
			
			if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ){
				$danfe = new DanfeNFCeNFePHP($docxml, 'http://localhost/uploads/'.$_REQUEST["emp_codigo"]."/".$company->{"emp_logo"}, 0, '000001', 'JL2QZJP3TS3LNXSB07K1ZLUZC6DRG6QSBBU6');
				$id = $danfe->montaDANFE();
				$danfe->printDANFE('pdf', $nfeDir.$chave.'.pdf', 'F');
			}else{
				$danfe = new DanfeNFePHP($docxml, 'C', 'A4', 'http://localhost/uploads/'.$_REQUEST["emp_codigo"]."/".$company->{"emp_logo"}, 'F', $nfeDir);
				$id = $danfe->montaDANFE();
				$danfe->printDANFE($nfeDir.$chave.'.pdf', 'F');
			}
			
			
			exit('/uploads/'.$_REQUEST["emp_codigo"].'/nfe/'.$amb.'/'.$chave.'.pdf');
		
		//acao = baixar o XML da NF-e
		}elseif($_REQUEST["acao"]=="baixar"){
		
			header("Expires: 0");
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
			header("Content-Disposition: attachment; filename=".$chave."-nfe.xml");
			header("Content-Type: application/force-download");
			readfile('http://localhost/uploads/'.$_REQUEST["emp_codigo"].'/nfe/'.$amb.'/'.$chave.'-nfe.xml');
			
			exit();
		
		//acao = email - enviar um e-mail com os arquivos da NF-e
		}elseif($_REQUEST["acao"]=="email"){
			//classe p/ envio
			include_once "../libs/MailNFePHP.class.php";
			
			//dados de configuração de envio
			$config = array(
				"mailAuth"=>"1",
				"mailFROM"=>$company->{"emp_emailremetente"},
				"mailHOST"=>'127.0.0.1',
				"mailUSER"=>$company->{"emp_emailremetente"},
				"mailPASS"=>$company->{"emp_pwdsmtp"},
				"mailPORT"=>"25",
				"mailPROTOCOL"=>"",
				"mailFROMmail"=>$company->{"emp_emailremetente"},
				"mailFROMname"=>$company->{"emp_fantasia"},
				"mailREPLYTOmail"=>$company->{"emp_emailremetente"},
				"mailREPLYTOname"=>$company->{"emp_fantasia"},
				"mailIMAPhost"=>"",
				"mailIMAPport"=>"",
				"mailIMAPsecurity"=>"",
				"mailIMAPnocerts"=>"",
				"mailIMAPbox"=>"",
				"recebidasDir"=>"",
				"temporariasDir"=>"",
				"canceladasDir"=>"",
				"CNPJ"=>$company->{"emp_cpfcnpj"},
				"mailLayoutFile"=>""
			);

			$email = new MailNFePHP($config);
			
			$msg = base64_decode($_REQUEST["msg"]);
			
			$to = base64_decode($_REQUEST["email"]);
			$to = str_replace(" ", "", $to);
			if(strstr($to, ";")) $to = explode(";", $to);
			elseif(strstr($to, ",")) $to = explode(",", $to);

			$cliente = $nota[0]->{"cad_nomeraz"};
			$assunto = utf8_decode("Envio de NF-e N: ".$nota[0]->{"not_numero"}." - série: ".$nota[0]->{"ser_codigo"});
			$arqxml = $nomeArquivo;

			$arqpdf = $nfeDir.$chave.".pdf";
			$auth = "0";
			$outro = "";
			
			//mensagem (corpo do e-mail)
			if ($msg == '') {
				$msg = base64_decode($company->{"emp_msgnfe"});
			}
			//substitui os campos variáveis da mensagem html
			$msg = str_replace('{cliente}', $cliente, $msg);
			$msg = str_replace('{emitente}', $company->{"emp_razao"}, $msg);
			$msg = str_replace('{numero}', $nota[0]->{"not_numero"}, $msg);
			$msg = str_replace('{serie}', $nota[0]->{"ser_codigo"}, $msg);
			$msg = str_replace('{valor}', $nota[0]->{"not_totalnota"}, $msg);
			$msg = utf8_decode($msg);

			//texto puro (sem html)
			$txt = strip_tags($msg);
			
			if(is_array($to)){

				$msgfinal = "";
				foreach($to as $para){
					if($email->sendM($para, $cliente, $assunto, $txt, $msg, $arqxml, $arqpdf, $auth, $outro))
						$msgfinal.= $para." - Enviado!<br>";
					else
						$msgfinal.= $para." - Nâo Enviado!<br>";
				}
				exit($msgfinal);
				
			}else{

				if( $email->sendM($to, $cliente, $assunto, $arqpdf, $arqpdf, $arqxml, $arqpdf, $auth, $outro) ){
					exit("E-mail enviado com sucesso!");
				}else{
					exit("Erro ao tentar enviar e-mail, verifique as configurações de envio e tente novamente mais tarde.<br>Ação:E-mail");
				}
				
			}
			
		//acao = cancelar a NF-e
		}elseif($_REQUEST["acao"]=="cancelar"){
			
			$motivo = base64_decode($_REQUEST["motivo"]);
			
			if ($resp = $tools->cancelEvent($chave, $nota[0]->{"not_nprot"}, $motivo, $tpAmb, $modSOAP)){
				
				//atualização do XML
				file_put_contents($nomeArquivo, $resp["xml"]);
				
				//Atualização da NF-e no Banco (cancelamento)
				$dhRecbto = implode("-", array_reverse(explode("/", substr($resp["ret"]["dhRecbto"], 0, 10))));
				$dhRecbto.= substr($resp["ret"]["dhRecbto"], 10, 9);
				$filtroAtualiza = '{"cod":"700112","params":[
					{"name":"not_dtcancdesc","value":"'.$dhRecbto.'","type":"string"},
					{"name":"not_cstat","value":"'.$resp["ret"]["cStat"].'","type":"integer"},
					{"name":"not_xmotivo","value":"'.base64_encode($resp["ret"]["xMotivo"]).'","type":"string"},
					{"name":"not_nprot","value":"'.$resp["ret"]["nProt"].'","type":"integer"},
					{"name":"not_codigo","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"}
				]}';
				$Datapacket->add($filtroAtualiza);
				
				//Atualização do log com dados do cancelamento
				$filtrolog = '{"cod":"700103","params":[
					{"name":"log_tipo","value":"2","type":"integer"},
					{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
					{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
					{"name":"log_usu_login","value":"NULL","type":"other"},
					{"name":"log_acao_cod","value":"5","type":"integer"},
					{"name":"log_acao_descr","value":"cancelamento","type":"string"},
					{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"log_protocolo","value":"'.$resp["ret"]["nProt"].' ","type":"string"},
					{"name":"log_ret","value":"NULL","type":"other"},
					{"name":"log_outro","value":"'.base64_encode('NF-e cancelada, motivo: \''.$motivo.'\'').'","type":"string"}
				]}';
				$Datapacket->add($filtrolog);
				
				$Datapacket->open();
				
				echo "NF-e cancelada com sucesso em: ".$resp["ret"]["dhRecbto"];
				
				exit();
				
			} else {
			
				//Atualização do log com erro na tentativa de cancelamento
				$filtrolog = '{"cod":"700103","params":[
					{"name":"log_tipo","value":"2","type":"integer"},
					{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
					{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
					{"name":"log_usu_login","value":"NULL","type":"other"},
					{"name":"log_acao_cod","value":"5","type":"integer"},
					{"name":"log_acao_descr","value":"cancelamento","type":"string"},
					{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"log_protocolo","value":"NULL","type":"other"},
					{"name":"log_ret","value":"NULL","type":"other"},
					{"name":"log_outro","value":"'.base64_encode("Erro no cancelamento: ".$tools->errMsg).'","type":"string"}
				]}';
				$Datapacket->add($filtrolog);
				$Datapacket->open();
			
				echo "Erro no cancelamento: ".$tools->errMsg;
				exit();
				
			}
		
		//acao = corrigir - Carta de correção da NF-e
		}elseif($_REQUEST["acao"]=="corrigir"){
			
			//Busca por eventos anteriores para pegar sequencia da Carta de Correção
			$filtrocce = '{"cod":"700113","params":[
				{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
				{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"}
			]}';
			
			$Datapacket->add($filtrocce);
			
			$res = $Datapacket->open();
			$seq = count($res);
				
			$texto = base64_decode($_REQUEST["texto"]);
			$seq = ($seq>0) ? ($seq+1) : 1;
			
			if ($resp = $tools->envCCe($chave, $texto, $seq, $tpAmb, $retorno)){
				
				$ccefile = $nfeDir.$chave.'-'.$seq.'-cce.xml';
						
				//Criar arquivo carta correção e gravar dados retornados
				$arquivoCCe = fopen($ccefile,'w+');
				fwrite($arquivoCCe, $resp["xml"]);
				fclose($arquivoCCe);
						
				//Atualização do log com dados da carta de correção
				$filtrolog = '{"cod":"700103","params":[
					{"name":"log_tipo","value":"2","type":"integer"},
					{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
					{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
					{"name":"log_usu_login","value":"NULL","type":"other"},
					{"name":"log_acao_cod","value":"6","type":"integer"},
					{"name":"log_acao_descr","value":"correção","type":"string"},
					{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"log_protocolo","value":"'.$resp["retEvento"]["infEvento"]["nProt"].' ","type":"string"},
					{"name":"log_ret","value":"NULL","type":"other"},
					{"name":"log_outro","value":"'.base64_encode('Carta de correção: \''.$texto.'\'').'","type":"string"}
				]}';
				
				$Datapacket->add($filtrolog);
				
				$Datapacket->open();
				
				echo 'Carta de correção enviada com sucesso em: '.date("d/m/Y H:i:s h", strtotime($resp["retEvento"]["infEvento"]["dhRegEvento"]));
				
				exit();
				
			} else {
			
				//Atualização do log com erro de envio de carta de correção
				$filtrolog = '{"cod":"700103","params":[
					{"name":"log_tipo","value":"2","type":"integer"},
					{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
					{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
					{"name":"log_usu_login","value":"NULL","type":"other"},
					{"name":"log_acao_cod","value":"6","type":"integer"},
					{"name":"log_acao_descr","value":"correção","type":"string"},
					{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"log_protocolo","value":"NULL","type":"other"},
					{"name":"log_ret","value":"NULL","type":"other"},
					{"name":"log_outro","value":"'.base64_encode("Erro no envio da Carta de Correção: ".$tools->errMsg).'","type":"string"}
				]}';
				$Datapacket->add($filtrolog);
				$Datapacket->open();
			
				echo "Erro no envio da Carta de Correção: ".$tools->errMsg;
				exit();
				
			}
			
		}

	}

?>