<?php

	date_default_timezone_set('America/Sao_Paulo');
	
	header('Access-Control-Allow-Origin: *');
	header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");

	session_start();
	
	include_once"../../datapacket.php";
	include_once '../../TParams.class.php';
	include_once "../libs/NFe/MakeNFePHP.class.php";
	include_once "../libs/NFe/ToolsNFePHP.class.php";
	include_once "../libs/NFe/DanfeNFePHP.class.php";
	include_once "../libs/NFe/DanfeNFCeNFePHP.class.php";
	include_once "../libs/NFe/DanfeNFCeNFePHPantigo.class.php";
	
	//Classe geradora da chave e que carrega as informações da NF-e
	class NFe extends TParams{

		public $modelo = "55";
		public $codigoUF = array(
			"RO" => "11",
			"AC" => "12",
			"AM" => "13",
			"RR" => "14",
			"PA" => "15",
			"AP" => "16",
			"TO" => "17",
			"MA" => "21",
			"PI" => "22",
			"CE" => "23",
			"RN" => "24",
			"PB" => "25",
			"PE" => "26",
			"AL" => "27",
			"SE" => "28",
			"BA" => "29",
			"MG" => "31",
			"ES" => "32",
			"RJ" => "33",
			"SP" => "35",
			"PR" => "41",
			"SC" => "42",
			"RS" => "43",
			"MS" => "50",
			"MT" => "51",
			"DF" => "53"
		);
		private $company = '';
		private $nota = '';
		private $transportadora = '';
		private $doctos = '';
		public $anoMes='';
		
		public $ambNfe = 'homologacao';

		public function __construct($not_codigo,$emp_codigo){

			$TParams = new TParams();
			$Datapacket = new Datapacket();

			$filtroCompany = '{"cod":"600001","params":[
				{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"}
			]}';
			
			//pega dados da empresa
			$Datapacket->setHost($TParams->getHost("empresas"));
			$Datapacket->add($filtroCompany);
			$company = $Datapacket->open(true);
			$this->company = $company[0];
			sleep(1);
			$Datapacket->clear();

			if( isset($company) ){
				if($company[0]->emp_amb_nfe==1){
					$this->ambNfe="producao";
				}else{
					$this->ambNfe="homologacao";
				}
			}else{
				$this->ambNfe="homologacao";
			}

			$filtroNota = '{"cod":"700002","params":[
				{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"},
				{"name":"db","value":"'.$company[0]->emp_db_comum.'","type":"other"}
			]}';
			
			//pega dados da nfe
			$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
			$Datapacket->add($filtroNota);
			$nota = $Datapacket->open(true);

			$this->nota = $nota;
			sleep(1);

			$Datapacket->clear();
			
			$this->anoMes = substr($nota[0]->{'not_data'},0,4).substr($nota[0]->{'not_data'},5,2);
			
			if($nota[0]->cad_codtransp){
			
				$filtroTransp = '{"cod":"500002","params":[
					{"name":"cad_codigo","value":"'.$nota[0]->cad_codtransp.'","type":"string"}
				]}';
				
				//pega dados da transportadora
				$Datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
				$Datapacket->add($filtroTransp);
				$transportadora = $Datapacket->open(true);
				$this->transportadora = $transportadora;
				sleep(1);
				$Datapacket->clear();
				
			}
			
			$filtroDocto = '{"cod":"700703","params":[
				{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"}
			]}';
			
			//pega dados das parcelas da nota
			$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
			$Datapacket->add($filtroDocto);
			$doctos = $Datapacket->open(true);
			$this->doctos = $doctos;
			sleep(1);
			$Datapacket->clear();
			
		}
		
		function str2Hex($str)	{ //converter string para hexadecimal
			if ($str == '') return '';
			$hex = "";
			$iCount = 0;
			do {
				$hex .= sprintf("%02x", ord($str{$iCount}));
				$iCount++;
			} while ($iCount < strlen($str));
			return $hex;
		}
		
		//modulo 11 p/ gerar a chave
		function digito_modulo11($NumDado, $NumDig, $LimMult){

			$Dado = $NumDado;
			for($n=1; $n<=$NumDig; $n++){
				$Soma = 0;
				$Mult = 2;
				for($i=strlen($Dado) - 1; $i>=0; $i--){
					$Soma += $Mult * intval(substr($Dado,$i,1));
					if(++$Mult > $LimMult) $Mult = 2;
				}
				$Dado .= strval(fmod(fmod(($Soma * 10), 11), 10));
			}
			return substr($Dado, strlen($Dado)-$NumDig);
			
		}
		//formatação do código da nota
		public function codigoNota(){
		
			if (!$this->nota[0]->not_codigo) {
				exit("- Falta código da Nota");
			}
			$j = $this->nota[0]->not_codigo;
			$g = "";
			$h = 9;
			$i= "1";
			
			if (strlen($j) > $h) {
				$j = substr($j, 0, $h);
			}
			for ($f = 0; $f < ($h - strlen($j)); $f++) {
				$g .= "0";
			}
			$j .= $g;
			return ($i.$j);
			
		}
		//gerar a chave da nota
		public function gerarChave($e=true){
		
			if (!$this->company->emp_db_sge) {
				$erro.= "- Falta UF da empresa<br>";
			}
			if (!$this->nota[0]->not_dtemissao) {
				$erro.= "- Falta data de emissão da Nota<br>";
			}
			if (!$this->company->emp_cpfcnpj) {
				$erro.= "- Falta CNPJ da Empresa<br>";
			}
			if (!$this->nota[0]->ser_codigo) {
				$erro.= "- Falta número da série da nota<br>";
			}
			if (!$this->nota[0]->not_numero) {
				$erro.= "- Falta número da nota<br>";
			}
			$data = $this->nota[0]->not_dtemissao;
		
			if(!isset($erro)){
				$f = $this->codigoUF[strtoupper($this->company->emp_uf)].substr($data,2,2).substr($data,5,2).$this->company->emp_cpfcnpj.$this->modelo.str_pad($this->nota[0]->ser_codigo, 3, "0", STR_PAD_LEFT).str_pad($this->nota[0]->not_numero, 9, "0", STR_PAD_LEFT)."1".str_pad($this->nota[0]->not_numero, 8, "0", STR_PAD_LEFT);
			
				if ($e) {
					return ($f.$this->digito_modulo11($f, 1, 9));
				}else{
					return ($this->digito_modulo11($f, 1, 9));
				}
			}else{
				exit("Erro na geração da chave da Nota ".$erro);
			}
			
		}
		
		public function getCompany(){
			return $this->company;
		}
		
		public function getNota(){
			return $this->nota;
		}
		
		public function getTransportadora(){
			return $this->transportadora;
		}
		
		public function getDoctos(){
			return $this->doctos;
		}
		
		public function getUF($uf="PR"){
			return $this->codigoUF[$uf];
		}
		
	}
	
	//Intanciando classe de dados com os dados recebidos (código da nota e da empresa)
	$Nota 	 = new NFe($_REQUEST['not_codigo'],$_REQUEST['emp_codigo']);

	//$Nota 	 = new Nfe('1415634055041', 'DEMO');	
	
	$company = $Nota->getCompany();
	$nota = $Nota->getNota();
	$transportadora = $Nota->getTransportadora();
	$doctos = $Nota->getDoctos();
	

	/*
	echo "<pre>";
	print_r($nota);
	echo "</pre>";
	*/
	//exit();	
	
	//instanciando classe responsável por montar a Nota (XML)
	$nfe = new MakeNFe();
	
	//Identificar o modelo da NF-e (55) ou NFC-e (65) - padrão NF-e (55)
	if( isset($_REQUEST["mod"]) ){
		
		$mod = $_REQUEST["mod"];
		$Nota->modelo = $mod;
		
	}else{
		
		$mod = "55";
		
	}
	
	//criar todas as tags do XML em sequencia 

	//Numero e versão da NFe (infNFe)
	$chave = $Nota->gerarChave();
	$versao = '3.10';
	$resp = $nfe->taginfNFe($chave, $versao);

	//Dados da NFe (ide)
	$cUF = $Nota->getUF($company->{'emp_uf'}); //codigo numerico do estado
	$cNF = str_pad($nota[0]->{'not_numero'}, 8, "0", STR_PAD_LEFT); //numero aleatório da NF
	$natOp = substr($nota[0]->{'cfo_codigo'}."-".$nota[0]->{'cfo_descr'}, 0, 60); //natureza da operação
	$indPag = ($nota[0]->{'cdp_indpag'}) ? $nota[0]->{'cdp_indpag'} : "2"; //0=Pagamento à vista; 1=Pagamento a prazo; 2=Outros
	//$mod = '55'; //modelo da NFe 55 ou 65 essa última NFCe
	$serie = $nota[0]->{'ser_codigo'}; //serie da NFe
	$nNF = $nota[0]->{'not_numero'}; // numero da NFe
	
	//GMT
	if( isset($company->{'emp_gmt'})  ){
		$gmt = (int) 3 - $company->{'emp_gmt'};
		if( (date("I")==1) && strstr("DF|ES|GO|MT|MS|MG|PR|RJ|RS|SC|SP", $company->{'emp_uf'}) ){
			$gmt = $gmt-1;
		}
		$gmt = "-0".$gmt.":00";
	}else{
		$gmt = date("P");
	}
	
	if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ){
		$dhEmi = date('Y-m-d')."T".date('H:i:s').$gmt;
	}else{
		$dhEmi = substr($nota[0]->{'not_data'}, 0, 10)."T".substr($nota[0]->{'not_data'}, 11, 8).$gmt;  //para versão 3.00 '2014-02-03T13:22:42-3.00' não informar para NFCe
	}
	$dhSaiEnt = substr($nota[0]->{'not_dtemissao'}, 0, 10)."T".substr($nota[0]->{'not_dtemissao'}, 11, 8).$gmt; //versão 2.00, 3.00 e 3.10
	$tpNF = ($nota[0]->{'not_entrsaida'}==2) ? '1' : '0';
	
	//1=Operação interna; 2=Operação interestadual; 3=Operação com exterior.
	if($nota[0]->{'end_uf'}=="EX"){
		$idDest = '3';
	}else if( $company->{'emp_uf'} == $nota[0]->{'end_uf'} || (isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65") ){
		$idDest = '1';
	}else{
		$idDest = '2';
	}

	$cMunFG = $company->{'emp_codmun'};
	$tpImp = ( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ) ? '4' : '1'; //0=Sem geração de DANFE; 1=DANFE normal, Retrato; 2=DANFE normal, Paisagem;
				  //3=DANFE Simplificado; 4=DANFE NFC-e; 5=DANFE NFC-e em mensagem eletrônica
				  //(o envio de mensagem eletrônica pode ser feita de forma simultânea com a impressão do DANFE;
				  //usar o tpImp=5 quando esta for a única forma de disponibilização do DANFE).
	$tpEmis = '1'; //1=Emissão normal (não em contingência);
				   //2=Contingência FS-IA, com impressão do DANFE em formulário de segurança;
				   //3=Contingência SCAN (Sistema de Contingência do Ambiente Nacional);
				   //4=Contingência DPEC (Declaração Prévia da Emissão em Contingência);
				   //5=Contingência FS-DA, com impressão do DANFE em formulário de segurança;
				   //6=Contingência SVC-AN (SEFAZ Virtual de Contingência do AN);
				   //7=Contingência SVC-RS (SEFAZ Virtual de Contingência do RS);
				   //9=Contingência off-line da NFC-e (as demais opções de contingência são válidas também para a NFC-e);
				   //Nota: Para a NFC-e somente estão disponíveis e são válidas as opções de contingência 5 e 9.
	$cDV = $Nota->gerarChave(false); //digito verificador
	$tpAmb = $company->{'emp_amb_nfe'}; //1=Produção; 2=Homologação
	if($nota[0]->{'cfo_tipo'}==1){
		$finNFe = '4'; //1=NF-e normal; 2=NF-e complementar; 3=NF-e de ajuste; 4=Devolução/Retorno.
	}elseif( isset($_REQUEST["fin_nfe"]) ){
		$finNFe = $_REQUEST["fin_nfe"]; //1=NF-e normal; 2=NF-e complementar; 3=NF-e de ajuste; 4=Devolução/Retorno.
	}else{
		$finNFe = '1'; //1=NF-e normal; 2=NF-e complementar; 3=NF-e de ajuste; 4=Devolução/Retorno.
	}
	
	//indicador destinatário quanto à contribuição do ICMS; 1 - Contribuinte; 2 - Não Contribuinte; 9 - Não Contribuinte que pode ou não possuir IE
	if($nota[0]->{'cad_pessoa'}==2 && strlen($nota[0]->{'cad_cnpjcpf'})>11 && $nota[0]->{'end_uf'}!="EX"){
		if( strtolower($nota[0]->{'cad_inscrg'})=="isento" ){
			$indIEDest = "2";
		}elseif( !$nota[0]->{'cad_inscrg'} || trim($nota[0]->{'cad_inscrg'})=="" ){
			$indIEDest = "9";
		}else{
			$indIEDest = "1";
		}
	}else{
		$indIEDest = "9";
	}
	
	//0=Não é conumidor final; 1=Consumidor final;
	if( (isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65") || $indIEDest!="1" ){
		$indFinal = "1";
	}else{
		$indFinal = "0";
	}

	$indPres = ( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ) ? '1' : '9'; //0=Não se aplica (por exemplo, Nota Fiscal complementar ou de ajuste);
				   //1=Operação presencial;
				   //2=Operação não presencial, pela Internet;
				   //3=Operação não presencial, Teleatendimento;
				   //4=NFC-e em operação com entrega a domicílio;
				   //9=Operação não presencial, outros.
	$procEmi = '0'; //0=Emissão de NF-e com aplicativo do contribuinte;
					//1=Emissão de NF-e avulsa pelo Fisco;
					//2=Emissão de NF-e avulsa, pelo contribuinte com seu certificado digital, através do site do Fisco;
					//3=Emissão NF-e pelo contribuinte com aplicativo fornecido pelo Fisco.
	$verProc = '3.22.8'; //versão do aplicativo emissor
	$dhCont = ''; //entrada em contingência AAAA-MM-DDThh:mm:ssTZD
	$xJust = ''; //Justificativa da entrada em contingência

	$resp = $nfe->tagide($cUF, $cNF, $natOp, $indPag, $mod, $serie, $nNF, $dhEmi, $dhSaiEnt, $tpNF, $idDest, $cMunFG, $tpImp, $tpEmis, $cDV, $tpAmb, $finNFe, $indFinal, $indPres, $procEmi, $verProc, $dhCont, $xJust);

	//refNFe NFe referenciada  
	if( isset($nota[0]->{'not_nferef'}) && $nota[0]->{'not_nferef'}!='' ){
		$refjson = json_decode(base64_decode($nota[0]->{'not_nferef'}));
		foreach($refjson as $nferef){
			$resp = $nfe->tagrefNFe($nferef);
		}
	}

	//refNF Nota Fiscal 1A referenciada
	$cUF = '';
	$AAMM = '';
	$CNPJ = '';
	$mod = '';
	$serie = '';
	$nNF = '';
	//$resp = $nfe->tagrefNF($cUF, $AAMM, $CNPJ, $mod, $serie, $nNF);

	//NFPref Nota Fiscal Produtor Rural referenciada
	$cUF = '';
	$AAMM = '';
	$CNPJ = '';
	$CPF = '';
	$IE = '';
	$mod = '';
	$serie = '';
	$nNF = '';
	//$resp = $nfe->tagrefNFP($cUF, $AAMM, $CNPJ, $CPF, $IE, $mod, $serie, $nNF);

	//CTeref CTe referenciada
	$refCTe = '';
	//$resp = $nfe->tagrefCTe($refCTe);

	//ECFref ECF referenciada
	$mod = '';
	$nECF = '';
	$nCOO = '';
	//$resp = $nfe->tagrefECF($mod, $nECF, $nCOO);

	//Dados do emitente
	$CNPJ = $company->{'emp_cpfcnpj'};
	$CPF = '';
	$xNome = $company->{'emp_razao'};
	$xFant = $company->{'emp_fantasia'};
	$IE = $company->{'emp_inscrg'};
	// $IEST = ($nota[0]->{'cad_inscrg'}!="" && strtolower($nota[0]->{'cad_inscrg'})!="isento" && $nota[0]->{'cad_pessoa'}==2 ) ? $nota[0]->{'cad_inscrg'} : "";
	$IEST = "";
	$IM = (isset($company->{'emp_inscrmun'}) && $company->{'emp_inscrmun'}!="") ? $company->{'emp_inscrmun'} : "";
	$CNAE = ($company->{'emp_cnae'}!="") ? $company->{'emp_cnae'} : "";
	$CRT = $company->{'emp_codregtrib'};
	$resp = $nfe->tagemit($CNPJ, $CPF, $xNome, $xFant, $IE, $IEST, $IM, $CNAE, $CRT);

	//endereço do emitente
	$xLgr = $company->{'emp_endereco'};
	if($company->{'emp_num'}!=""){
		if(strlen($company->{'emp_num'})<5){
			$nro = str_pad($company->{'emp_num'}, 4, "0", STR_PAD_LEFT);
		}else{
			$nro = $company->{'emp_num'};
		}
	}
	$xCpl =  ($company->{'emp_complem'}!="") ? $company->{'emp_complem'} : "";
	$xBairro = $company->{'emp_bairro'};
	$cMun = $company->{'emp_codmun'};
	$xMun = ucwords(strtolower($company->{'emp_cidade'}));
	$UF = strtoupper($company->{'emp_uf'});
	$CEP = $company->{'emp_cep'};
	$cPais = '1058';
	$xPais = 'BRASIL';
	$fone = $company->{'emp_fone'};
	$resp = $nfe->tagenderEmit($xLgr, $nro, $xCpl, $xBairro, $cMun, $xMun, $UF, $CEP, $cPais, $xPais, $fone);
	
	if( isset($nota[0]->{'cod_cad'}) && $nota[0]->{'cod_cad'} != '99999999999999'){

		if(isset($nota[0]->{'cad_cnpjcpf'}) && !empty($nota[0]->{'cad_cnpjcpf'}) && $nota[0]->{'end_uf'}!="EX"){
			$CNPJ = (strlen($nota[0]->{'cad_cnpjcpf'})>11) ? $nota[0]->{'cad_cnpjcpf'} : "";
			$CPF = (strlen($nota[0]->{'cad_cnpjcpf'})<12) ? $nota[0]->{'cad_cnpjcpf'} : "";
			$idEstrangeiro = '';
		}else if($nota[0]->{'end_uf'}!="EX"){
			$CNPJ = (strlen($nota[0]->{'not_cpf'})>11) ? $nota[0]->{'not_cpf'} : "";
			$CPF = (strlen($nota[0]->{'not_cpf'})<12) ? $nota[0]->{'not_cpf'} : "";
			$idEstrangeiro = '';
		}else{
			$CNPJ = "";
			$CPF = "";
			$idEstrangeiro = $nota[0]->{'cad_cnpjcpf'};
		}
		
		$xNome =  substr($nota[0]->{'cad_nomeraz'}, 0, 64);
		$IE =  ($nota[0]->{'cad_inscrg'}!="" && strtolower($nota[0]->{'cad_inscrg'})!="isento") ? $nota[0]->{'cad_inscrg'} : "";
		$ISUF = ($nota[0]->{'cad_suframa'}!="") ? $nota[0]->{'cad_suframa'} : "";
		$IM = '';
		$email = (isset($nota[0]->{'cad_email_nfe'}) && $nota[0]->{'cad_email_nfe'}!='') ? $nota[0]->{'cad_email_nfe'} : 'naoinformado@naoinformado.com.br';
		if($tpAmb == 2){
			$resp = $nfe->tagdest($CNPJ, $CPF, $idEstrangeiro, 'NF-E EMITIDA EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL', $indIEDest, $IE, $ISUF, $IM, $email);
		}else{
			$resp = $nfe->tagdest($CNPJ, $CPF, $idEstrangeiro, $xNome, $indIEDest, $IE, $ISUF, $IM, $email);
		}

		//Endereço do destinatário
		$xLgr = $nota[0]->{'end_nome'};
		if($nota[0]->{'end_num'}!=""){
			if(strlen($nota[0]->{'end_num'})<5){
				$nro = str_pad($nota[0]->{'end_num'}, 4, "0", STR_PAD_LEFT);
			}else{
				$nro = $nota[0]->{'end_num'};
			}
		}
		$xCpl = $nota[0]->{'end_compl'};
		$xBairro = $nota[0]->{'end_bairro'};
		$cMun = $nota[0]->{'cad_codmun'};
		$xMun = $nota[0]->{'end_cidade'};
		$UF = $nota[0]->{'end_uf'};
		$CEP = ($nota[0]->{'end_cep'}) ? str_replace("-", "", $nota[0]->{'end_cep'}) : "";
		if( $nota[0]->{'end_uf'}=="EX" ){
			$cPais = (int) $nota[0]->{'end_compl'};
			$xPais = $nota[0]->{'end_obs'};
		}else{
			$cPais = '1058';
			$xPais = 'BRASIL';
		}
		$fone = trim($nota[0]->{'tel_ddd'}).trim($nota[0]->{'tel_prefixo'}).trim($nota[0]->{'tel_numero'});
		$resp = $nfe->tagenderDest($xLgr, $nro, $xCpl, $xBairro, $cMun, $xMun, $UF, $CEP, $cPais, $xPais, $fone);

	}else if( isset($nota[0]->{'not_cpf'}) && !empty($nota[0]->{'not_cpf'}) ){

		$IE =  ($nota[0]->{'cad_inscrg'}!="" && strtolower($nota[0]->{'cad_inscrg'})!="isento") ? $nota[0]->{'cad_inscrg'} : "";
		$CNPJ = (strlen($nota[0]->{'not_cpf'})>11) ? $nota[0]->{'not_cpf'} : "";
		$CPF = (strlen($nota[0]->{'not_cpf'})<12) ? $nota[0]->{'not_cpf'} : "";
		if($tpAmb == 2){
			$resp = $nfe->tagdest($CNPJ, $CPF, "",'NF-E EMITIDA EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL',$indIEDest, $IE);
		}else{
			$resp = $nfe->tagdest($CNPJ, $CPF, "", "CONSUMIDOR FINAL", $indIEDest, $IE);
		}

	}


	//Identificação do local de retirada (se diferente do emitente)
	$CNPJ = '';
	$CPF = '';
	$xLgr = '';
	$nro = '';
	$xCpl = '';
	$xBairro = '';
	$cMun = '';
	$xMun = '';
	$UF = '';
	//$resp = $nfe->tagretirada($CNPJ, $CPF, $xLgr, $nro, $xCpl, $xBairro, $cMun, $xMun, $UF);

	//Identificação do local de Entrega (se diferente do destinatário)
	$CNPJ = '';
	$CPF = '';
	$xLgr = '';
	$nro = '2';
	$xCpl = '';
	$xBairro = '';
	$cMun = '';
	$xMun = '';
	$UF = '';
	//$resp = $nfe->tagentrega($CNPJ, $CPF, $xLgr, $nro, $xCpl, $xBairro, $cMun, $xMun, $UF);

	//Identificação dos autorizados para fazer o download da NFe (somente versão 3.1)
	$aAut = array($company->{'emp_cpfcnpj'},$nota[0]->{'cad_cnpjcpf'});
	foreach ($aAut as $aut) {
		if (strlen($aut) == 14) {
			//$resp = $nfe->tagautXML($aut);
		} else {
			//$resp = $nfe->tagautXML('', $aut);
		}
	}

	//produtos
	$i=0;
	$vTotDesc=0;
	$vTotDescNota=0;
	$vTotOutro=0;
	$ant="";
	
	foreach($nota as $not){
		
		if( $not->{"itn_ordem"}!=$ant ){
			
			$tribjson = json_decode(base64_decode($not->{"itn_tribjson"}));
			$vdesc = '';
			$voutro = '';
			if($not->{"itn_valordesc"}>0){
				$vdesc = $not->{"itn_qtde"} * $not->{"itn_valordesc"};
			}
			
			if($not->{"not_valordesc"}>0){
				$p = ($not->{"itn_subtotal"} * 100)/ $not->{"not_totalprod"}; //porcentagem do desconto do produto em relacao ao total dos produtos
				$vdesc+= number_format(($not->{"not_valordesc"}*$p/100), 2, ".", "");
				$vTotDescNota+=number_format(($not->{"not_valordesc"}*$p/100), 2, ".", "");
			}
			if($not->{"not_despesa"}>0 && $i==0){
				$voutro = $not->{"not_despesa"};
			}
			
			//cdp (variação da condição de pagamento)
			if($not->{"not_cdp_desc"}<0 && $i==0){
				$vdesc -= $not->{"not_cdp_desc"};
			}elseif($not->{"not_cdp_desc"}>0 && $i==0){
				$voutro += $not->{"not_cdp_desc"};
			}
			
			//tbp (variação da tabela de preços)
			$variacao = 0;
			if($not->{"tbp_codigo"} && $not->{"tbp_da"}==1 && $i==0){
				if($not->{"tbp_tpdesc"}==1) $variacao = $not->{"not_totalprod"}*($not->{"tbp_valor"}/100);
				else $variacao = $not->{"tbp_valor"};
				if(isset($_REQUEST["variacao"]) && $_REQUEST["variacao"]=='sim'){ //monstrar variacao?
					$vdesc += $variacao;
					$variacao = 0;
				}else{
					$variacao = -$variacao;
				}
			}elseif($not->{"tbp_codigo"} && $not->{"tbp_da"}==2 && $i==0){
				if($not->{"tbp_tpdesc"}==1) $variacao = $not->{"not_totalprod"}*($not->{"tbp_valor"}/100);
				else $variacao = $not->{"tbp_valor"};
				if(isset($_REQUEST["variacao"]) && $_REQUEST["variacao"]=='sim'){ //monstrar variacao?
					$voutro+=$variacao;
					$variacao=0;
				}
			}
			
			$ref_codigo =  ($tribjson->{"rowdata"}[0]->{"ref_codigo"} && $tribjson->{"rowdata"}[0]->{"ref_codigo"}!="") ? $tribjson->{"rowdata"}[0]->{"ref_codigo"} :  $not->{"ref_codigo"};
			$ref_codigo = ( strlen($ref_codigo)>=3 ) ? $ref_codigo : str_pad($ref_codigo, 3, "0", STR_PAD_LEFT);

			if($not->{"itn_qtde"}>0){
				$not->{"itn_qtde"}=number_format($not->{"itn_qtde"},$company->{'emp_decimais'},".","");
			}else{
				$not->{"itn_qtde"}="0";
			}
			
			if($vdesc>0 && $vdesc!=""){
				// $vdesc=number_format($vdesc,$company->{'emp_decimais'},".","");
				$vdesc=number_format($vdesc,2,".","");
			}else{
				$vdesc=0;
			}
			
			$vTotDesc += $vdesc; //total de desconto

			if($voutro>0){
				$voutro=number_format($voutro,2,".","");
			}else{
				$voutro="0";
			}
			
			$not->{"itn_valor"} = $not->{"itn_valor"} + $variacao;
			$vprod = ( $not->{"itn_qtde"} * $not->{"itn_valor"} );

			if($not->{"itn_qtde"}>0){
				if($company->{'emp_decimais'}>=4){
					$itn_qtde = number_format($not->{"itn_qtde"},4,".","");
				}else{
					$itn_qtde = number_format($not->{"itn_qtde"},$company->{'emp_decimais'},".","");
				}
			}else{
				$itn_qtde = 0;
			}
			
			if($vprod>0){
				$vprod=number_format($vprod,2,".","");
			}else{
				$vprod="0";
			}
		
			if($not->{"itn_valor"}>0){
				$itn_valor = number_format($not->{"itn_valor"},$company->{'emp_decimais'},".","");
			}else{
				$itn_valor=0;
			}
		
			$aP[$i] = array(
				'nItem' => ($i+1),
				'cProd' =>  $ref_codigo,
				'cEAN' => '',
				'xProd' => $not->{"itn_descr"},
				'NCM' => $not->{"itn_ncm"},
				'NVE' => '',
				'CEST' => ($tribjson->{"rowdata"}[0]->{"ref_cest"}) ? $tribjson->{"rowdata"}[0]->{"ref_cest"} : '0000000',
				// 'CEST' => '',
				'EXTIPI' => '',
				'CFOP' => ($tribjson->{"rowdata"}[0]->{"ref_cfop"}) ? $tribjson->{"rowdata"}[0]->{"ref_cfop"} : $not->{"cfo_codigo"},
				'uCom' => (isset($not->{"uni_codigo"}) && $not->{"uni_codigo"}!="") ? $not->{"uni_codigo"}."." : "UN.",
				'qCom' => $itn_qtde,
				'vUnCom' => $itn_valor,
				'vProd' => $vprod,
				'cEANTrib' => '',
				'uTrib' => (isset($not->{"uni_codigo"}) && $not->{"uni_codigo"}!="") ? $not->{"uni_codigo"}."." : "UN.",
				'qTrib' =>  $itn_qtde,
				'vUnTrib' => $itn_valor,
				'vFrete' => ($i==0 &&  $not->{"not_frete"}>0 && ($nota[0]->{"not_tpfrete"}=='2')) ?  number_format($not->{"not_frete"},2,'.','') : '',
				'vSeg' => ($i==0 &&  $not->{"not_seguro"}>0) ?  $not->{"not_seguro"} : '',
				'vDesc' => ($vdesc>0) ? $vdesc : '',
				'vOutro' => ($voutro>0) ? $voutro : '',
				'indTot' => '1',
				'xPed' => '',
				'nItemPed' => '',
				'nFCI' => ''
			);
			$ant = $not->{"itn_ordem"};
		
			$i++;
			$vTotOutro += $voutro;
		}
		
	}
	
	//resolvendo problema da diferença no arredondamento do desconto
	if($nota[0]->{"not_valordesc"}>0 && $vTotDescNota>0 && $vTotDescNota!=$nota[0]->{"not_valordesc"}){
		$diff = $vTotDescNota - $nota[0]->{"not_valordesc"};
		$aP[0]["vDesc"] = number_format( ($aP[0]["vDesc"]-$diff), 2, ".", "");
		$vTotDesc = number_format( ($vTotDesc-$diff), 2, ".", "");
	}

	$vTotProd=0;
	foreach ($aP as $prod) {
		$nItem = $prod['nItem'];
		$cProd = $prod['cProd'];
		$cEAN = $prod['cEAN'];
		$xProd = $prod['xProd'];
		$NCM = $prod['NCM'];
		$NVE = $prod['NVE'];
		$CEST = $prod['CEST'];
		$EXTIPI = $prod['EXTIPI'];
		$CFOP = $prod['CFOP'];
		$uCom = $prod['uCom'];
		$qCom = $prod['qCom'];
		$vUnCom = $prod['vUnCom'];
		$vProd = $prod['vProd'];
		$vTotProd+=$prod['vProd'];
		$cEANTrib = $prod['cEANTrib'];
		$uTrib = $prod['uTrib'];
		$qTrib = $prod['qTrib'];
		$vUnTrib = $prod['vUnTrib'];
		$vFrete = $prod['vFrete'];
		$vSeg = $prod['vSeg'];
		$vDesc = $prod['vDesc'];
		$vOutro = $prod['vOutro'];
		$indTot = $prod['indTot'];
		$xPed = $prod['xPed'];
		$nItemPed = $prod['nItemPed'];
		$nFCI = $prod['nFCI'];
		$resp = $nfe->tagprod($nItem, $cProd, $cEAN, $xProd, $NCM, $NVE, $CEST, $EXTIPI, $CFOP, $uCom, $qCom, $vUnCom, $vProd, $cEANTrib, $uTrib, $qTrib, $vUnTrib, $vFrete, $vSeg, $vDesc, $vOutro, $indTot, $xPed, $nItemPed, $nFCI);
	}
	
	$i=1;
	$vTotTrib=0;
	$vTotTrib2=0;
	$vTotPIS=0;
	$vTotCOFINS=0;
	$ant="";
	
	$vFCPUFDestTot=0;
	$vICMSUFDestTot=0;
	$vICMSUFRemetTot=0;
	
	foreach($nota as $not){
		
		if( $not->{"itn_ordem"}!=$ant ){
			
			$tribjson = json_decode(base64_decode($not->{"itn_tribjson"}));
			
			//DI
			/*
			$nItem = $i;
			$nDI = '234556786';
			$dDI = '2014-02-02';
			$xLocDesemb = 'SANTOS';
			$UFDesemb = 'SP';
			$dDesemb = '2014-02-02';
			$tpViaTransp = '1';
			$vAFRMM = '1.00';
			$tpIntermedio = '0';
			$CNPJ = '';
			$UFTerceiro = '';
			$cExportador = '111';
			$resp = $nfe->tagDI($nItem, $nDI, $dDI, $xLocDesemb, $UFDesemb, $dDesemb, $tpViaTransp, $vAFRMM, $tpIntermedio, $CNPJ, $UFTerceiro, $cExportador);
			*/

			//imposto
			$nItem = $i;
			$val_ipi = ( !isset($_REQUEST["mod"]) ) ? $not->{"itn_ipi"} : "0";
			$vTotTrib = floor($not->{"itn_icms"}+$val_ipi+$not->{"itn_icmssubst"});
			$vTotTrib = ($vTotTrib > 0) ? number_format( $vTotTrib, 2, ".", "") : "0";
			$vTotTrib2 += $vTotTrib;
			$resp = $nfe->tagimposto($nItem, $vTotTrib);

			//ICMS
			$nItem =$i;
			$orig = ($tribjson->{"rowdata"}[0]->{"tri_origem"} && $tribjson->{"rowdata"}[0]->{"tri_origem"}!="") ? $tribjson->{"rowdata"}[0]->{"tri_origem"} : "0";
			$cst = str_pad($tribjson->{"rowdata"}[0]->{"tri_situacao"}, 2, "0", STR_PAD_LEFT);
			$modBC = '0';
			$tri_redbaseicms = ( $not->{"itn_icms"}>0 && ($cst=="20" || $cst=="70") && $company->{'emp_codregtrib'}==3 ) ? number_format($tribjson->{"rowdata"}[0]->{"tri_redbaseicms"}, 2, ".", "") : "0.00";
			$itn_baseicms = ( $not->{"itn_baseicms"}>0 ) ? number_format($not->{"itn_baseicms"}, 2, ".", "") : "0";
			$itn_aliqicms = ($not->{"itn_aliqicms"}>0) ? number_format($not->{"itn_aliqicms"}, 2, ".", "") : "0";
			$vICMS = ($not->{"itn_icms"}>0) ? number_format($not->{"itn_icms"}, 2, ".", "") : "0";
			if( ($cst=="30" || $cst=="40" || $cst=="41" || $cst=="90") && $company->{'emp_codregtrib'}==3 ){
				/*
				if($not->{"itn_valor"}>0 && $not->{"itn_aliqicms"}>0){
					$vICMSDeson = number_format($not->{"itn_valor"}*($not->{"itn_aliqicms"}/100), 2, ".", "");
					$vICMSDesonTot += number_format($not->{"itn_valor"}*($not->{"itn_aliqicms"}/100), 2, ".", "");
				}else{
				*/
					$vICMSDeson = "";
					$vICMSDesonTot += "";
				// }
			}elseif( ($cst=="20" || $cst=="70") && $company->{'emp_codregtrib'}==3 ){
				/*
				if($not->{"itn_valor"}>0 && $tribjson->{"rowdata"}[0]->{"tri_redbaseicms"}>0 && $not->{"itn_aliqicms"}>0){
					$vICMSDeson = number_format( (($not->{"itn_valor"}*$tribjson->{"rowdata"}[0]->{"tri_redbaseicms"})/100) * ($not->{"itn_aliqicms"}/100), 2, ".", "");
					$vICMSDesonTot += number_format( (($not->{"itn_valor"}*$tribjson->{"rowdata"}[0]->{"tri_redbaseicms"})/100) * ($not->{"itn_aliqicms"}/100), 2, ".", "");
				}else{
				*/
					$vICMSDeson = "";
					$vICMSDesonTot += "";
				// }
			}else{
				$vICMSDeson = "";
				$vICMSDesonTot += "";
			}
			$motDesICMS = '';
			$modBCST = '0';
			$pMVAST = ( isset($tribjson->{"rowdata"}[0]->{"tri_mva_st"}) && $tribjson->{"rowdata"}[0]->{"tri_mva_st"}>0 ) ? number_format($tribjson->{"rowdata"}[0]->{"tri_mva_st"}, 2, ".", "") : "0.00";
			$pRedBCST = ( isset($tribjson->{"rowdata"}[0]->{"tri_redbaseicmsst"}) && $tribjson->{"rowdata"}[0]->{"tri_redbaseicmsst"}>0 ) ? number_format($tribjson->{"rowdata"}[0]->{"tri_redbaseicmsst"}, 2, ".", "") : "0.00";
			$vBCST = ($not->{"itn_baseicmsst"}>0) ? number_format($not->{"itn_baseicmsst"}, 2, ".", "") : "0";
			$pICMSST =($tribjson->{"rowdata"}[0]->{"tri_aliq_icms_st"}>0) ? number_format($tribjson->{"rowdata"}[0]->{"tri_aliq_icms_st"}, 2, ".", "") : "0";
			$vICMSST = ($not->{"itn_icmssubst"}>0) ? number_format($not->{"itn_icmssubst"}, 2, ".", "") : "0";
			$pDif = '';
			$vICMSDif = '';
			$vICMSOp = '';
			$vBCSTRet = '0';
			$vICMSSTRet = '0';
			
			//SIMPES NACIONAL CRT=1
			$csosn = ($tribjson->{"rowdata"}[0]->{"tri_csosn"} && $tribjson->{"rowdata"}[0]->{"tri_csosn"}!="000") ? $tribjson->{"rowdata"}[0]->{"tri_csosn"} : "400";
			$pCredSN = ($not->{"not_aliqcredicms"}>0) ? number_format($not->{"not_aliqcredicms"}, 2, ".", "") : "0";
			$icmsXaliqcredicms = ($not->{"itn_baseicms"}*$not->{"not_aliqcredicms"});
			$vCredICMSSN = ($icmsXaliqcredicms>0) ? number_format($icmsXaliqcredicms, 2, ".", "") : "0";
			
			//ipi
			$cstIpi =  str_pad($tribjson->{"rowdata"}[0]->{"tri_sit_ipi"}, 2, "0", STR_PAD_LEFT);
			$clEnq = "";
			$cnpjProd = "";
			$cSelo = "";
			$qSelo="";
			$cEnq = ($tribjson->{"rowdata"}[0]->{"tri_cenq"} && $tribjson->{"rowdata"}[0]->{"tri_cenq"}!="") ? $tribjson->{"rowdata"}[0]->{"tri_cenq"} : "999";
			$vBCIPI = ($not->{"itn_baseipi"}>0) ? number_format($not->{"itn_baseipi"}, 2, ".", "") : "0";
			$pIPI = ($not->{"itn_aliqipi"}>0) ? number_format($not->{"itn_aliqipi"}, 2, ".", "") : "0";
			$qUnid = "";
			$vUnid = "";
			$vIPI=($not->{"itn_ipi"}>0) ? number_format($not->{"itn_ipi"}, 2, ".", "") : "0";
			
			//pis
			$cstPIS = ($tribjson->{"rowdata"}[0]->{"tri_sit_pis"}) ? str_pad($tribjson->{"rowdata"}[0]->{"tri_sit_pis"}, 2, "0", STR_PAD_LEFT) : "07";
			$vBCPIS = ( ($cstPIS=="01" || $cstPIS=="02") && $tribjson->{"rowdata"}[0]->{"tri_basepis"} && $tribjson->{"rowdata"}[0]->{"tri_basepis"}>0 ) ? number_format($tribjson->{"rowdata"}[0]->{"tri_basepis"}, 2, ".", "") : "0";
			$pPIS = ($tribjson->{"rowdata"}[0]->{"tri_aliqpis"} && $tribjson->{"rowdata"}[0]->{"tri_aliqpis"}>0 && $cstPIS!="03") ? number_format($tribjson->{"rowdata"}[0]->{"tri_aliqpis"}, 2, ".", "") : "0.00";
			$vPIS = ($tribjson->{"rowdata"}[0]->{"tri_pis"} && $tribjson->{"rowdata"}[0]->{"tri_pis"}>0) ? number_format($tribjson->{"rowdata"}[0]->{"tri_pis"}, 2, ".", "") : "0.00";
			$vTotPIS += $vPIS;
			$qBCProd = ($cstPIS=="03") ? $not->{"itn_qtde"} : "";
			$vAliqProd = ($cstPIS=="03" && $tribjson->{"rowdata"}[0]->{"tri_aliqpis"} && $tribjson->{"rowdata"}[0]->{"tri_aliqpis"}>0) ? number_format($tribjson->{"rowdata"}[0]->{"tri_aliqpis"}, 2, ".", "") : "";
			
			//cofins
			$cstCOFINS = ($tribjson->{"rowdata"}[0]->{"tri_sit_cofins"}) ? str_pad($tribjson->{"rowdata"}[0]->{"tri_sit_cofins"}, 2, "0", STR_PAD_LEFT) : "07";
			$vBCCOFINS = ( ($cstCOFINS=="01" || $cstCOFINS=="02") && $tribjson->{"rowdata"}[0]->{"tri_basecofins"} && $tribjson->{"rowdata"}[0]->{"tri_basecofins"}>0 ) ? number_format($tribjson->{"rowdata"}[0]->{"tri_basecofins"}, 2, ".", "") : "0.00";
			$pCOFINS = ($tribjson->{"rowdata"}[0]->{"tri_aliqcofins"}&& $tribjson->{"rowdata"}[0]->{"tri_aliqcofins"}>0 && $cstCOFINS!="03") ? number_format($tribjson->{"rowdata"}[0]->{"tri_aliqcofins"}, 2, ".", "") : "0.00";
			$vCOFINS =  ($tribjson->{"rowdata"}[0]->{"tri_cofins"} && $tribjson->{"rowdata"}[0]->{"tri_cofins"}>0) ? number_format($tribjson->{"rowdata"}[0]->{"tri_cofins"}, 2, ".", "") : "0.00";
			$vTotCOFINS += $vCOFINS;
			$qBCProdCOFINS = ($cstCOFINS=="03") ? $not->{"itn_qtde"} : "";
			$vAliqProdCOFINS = ($cstCOFINS=="03" && $tribjson->{"rowdata"}[0]->{"tri_aliqcofins"} && $tribjson->{"rowdata"}[0]->{"tri_aliqcofins"}>0) ? number_format($tribjson->{"rowdata"}[0]->{"tri_aliqcofins"}, 2, ".", "") : "";
			
			if($CRT==3 || $CRT=='3'){
				$resp = $nfe->tagICMS($nItem, $orig, $cst, $modBC, $tri_redbaseicms, $itn_baseicms, $itn_aliqicms, $vICMS, $vICMSDeson, $motDesICMS, $modBCST, $pMVAST, $pRedBCST, $vBCST, $pICMSST, $vICMSST, $pDif, $vICMSDif, $vICMSOp, $vBCSTRet, $vICMSSTRet);
			}else{
				$resp = $nfe->tagICMSSN($nItem, $orig, $csosn, $modBC, $itn_baseicms, $tri_redbaseicms, $itn_aliqicms, $vICMS, $pCredSN, $vCredICMSSN, $modBCST, $pMVAST, $pRedBCST, $vBCST, $pICMSST, $vICMSST, $vBCSTRet, $vICMSSTRet);
			}

			//ICMSPart
			//$resp = $nfe->tagICMSPart($nItem, $orig, $cst, $modBC, $vBC, $pRedBC, $pICMS, $vICMS, $modBCST, $pMVAST, $pRedBCST, $vBCST, $pICMSST, $vICMSST, $pBCOp, $ufST);
			//ICMSST
			//$resp = $nfe->tagICMSST($nItem, $orig, $tri_situacao, $vBCSTRet, $vICMSSTRet, $vBCSTDest, $vICMSSTDest);
			//ICMSSN
			
			//IPI
			if( !isset($_REQUEST["mod"]) ) $resp = $nfe->tagIPI($nItem, $cstIpi, $clEnq, $cnpjProd, $cSelo, $qSelo, $cEnq, $vBCIPI, $pIPI, $qUnid, $vUnid, $vIPI);
			//PIS
			$resp = $nfe->tagPIS($nItem, $cstPIS, $vBCPIS, $pPIS, $vPIS, $qBCProd, $vAliqProd);
			//PISST
			//$resp = $nfe->tagPISST($nItem, $vBC, $pPIS, $qBCProd, $vAliqProd, $vPIS);
			//COFINS
			$resp = $nfe->tagCOFINS($nItem, $cstCOFINS, $vBCCOFINS, $pCOFINS, $vCOFINS, $qBCProdCOFINS, $vAliqProdCOFINS);
			//COFINSST
			//$resp = $nfe->tagCOFINSST($nItem, $vBC, $pCOFINS, $qBCProd, $vAliqProd, $vCOFINS);
			//II
			//$resp = $nfe->tagII($nItem, $vBC, $vDespAdu, $vII, $vIOF);
			
			//Grupo a ser informado nas vendas interestaduais para consumidor final, não contribuinte de ICMS (a partir de 01/01/2016)
			if($indFinal=='1' && $idDest=='2'){
				$vBCUFDest = $itn_baseicms;
				$pFCPUFDest = ($nota[0]->{'end_uf'}=='SP' || $nota[0]->{'end_uf'}=='RJ') ? '1' : '0';
				$pICMSUFDest = $itn_aliqicms;
				if($orig=="1" || $orig=="2" || $orig=="6" || $orig=="7"){ //produto importado
					$pICMSInter = '4.00';
				}elseif( strstr("PR|SC|RS|SP|RJ|MG", $company->{'emp_uf'}) && strstr("ES|AM|AC|RO|RR|PA|AP|TO|MA|PB|PE|AL|SE|CE|PI|BA|RN|MT|MS|GO|DF", $nota[0]->{'end_uf'}) ){ //origem no sul/ sudeste - destino no norte/nordeste/centro-oeste (exceto ES)
					$pICMSInter = '7.00';
				}else{ //demais casos
					$pICMSInter = '12.00';
				}
				if(date("Y")<="2016"){
					$pICMSInterPart = '40.00';
				}elseif(date("Y")=="2017"){
					$pICMSInterPart = '60.00';
				}elseif(date("Y")=="2018"){
					$pICMSInterPart = '80.00';
				}elseif(date("Y")>="2019"){
					$pICMSInterPart = '100.00';
				}
				$vFCPUFDest = ($vBCUFDest >0 && $pFCPUFDest>0) ? number_format(($vBCUFDest *$pFCPUFDest/100), 2, '.', '') : '0.00';
				$vFCPUFDestTot+=$vFCPUFDest;
				$vICMSUFDest = ($vICMS>0) ? number_format(($vICMS*$pICMSInterPart/100), 2, '.', '') : '0.00';
				$vICMSUFDestTot+=$vICMSUFDest;
				$vICMSUFRemet = ($vICMS>0) ? number_format(($vICMS*((100-$pICMSInterPart))/100), 2, '.', '') : '0.00';
				$vICMSUFRemetTot+=$vICMSUFRemet;
				$resp = $nfe->tagICMSUFDest($nItem, $vBCUFDest, $pFCPUFDest, $pICMSUFDest, $pICMSInter, $pICMSInterPart, $vFCPUFDest, $vICMSUFDest, $vICMSUFRemet);
			}
			
			//
			//ISSQNTot
			//$resp = $nfe->tagISSQNTot($vServ, $vBC, $vISS, $vPIS, $vCOFINS, $dCompet, $vDeducao, $vOutro, $vDescIncond, $vDescCond, $vISSRet, $cRegTrib);
			//retTrib
			//$resp = $nfe->tagretTrib($vRetPIS, $vRetCOFINS, $vRetCSLL, $vBCIRRF, $vIRRF, $vBCRetPrev, $vRetPrev);
			
			$i++;
			
			$ant = $not->{"itn_ordem"};
			
		}	
			
	}
	if($vFCPUFDestTot>0) $vFCPUFDestTot = number_format($vFCPUFDestTot, 2, '.', '');
	if($vICMSUFDestTot>0) $vICMSUFDestTot = number_format($vICMSUFDestTot, 2, '.', '');
	if($vICMSUFRemetTot>0) $vICMSUFRemetTot = number_format($vICMSUFRemetTot, 2, '.', '');
	
	$vII="0";
	$vTotPIS = ($vTotPIS>0) ? number_format($vTotPIS, 2, ".", "") : "0";
	$vTotCOFINS = ($vTotCOFINS>0) ? number_format($vTotCOFINS, 2, ".", "") : "0";
	$vNF = ($nota[0]->{"not_totalnota"}>0) ? number_format($nota[0]->{"not_totalnota"}, 2, ".", "") : "0";
		
	$vFrete =  ($nota[0]->{"not_frete"}>0 && ($nota[0]->{"not_tpfrete"}=='2')) ? number_format($nota[0]->{"not_frete"}, 2, ".", "") : "0";
	$vSeg =  ($nota[0]->{"not_seguro"}>0) ? number_format($nota[0]->{"not_seguro"}, 2, ".", "") : "0";
	$vTotOutro = ($vTotOutro>0) ? number_format($vTotOutro, 2, ".", "") : '0';
	$totBaseicms  = ($nota[0]->{"not_totbaseicms"} >0) ? number_format($nota[0]->{"not_totbaseicms"}, 2, ".", "") : "0";
	$vTotICMS  = ($nota[0]->{"not_toticms"} >0) ? number_format($nota[0]->{"not_toticms"}, 2, ".", "") : "0";
	$vTotBCST  = ($nota[0]->{"not_totbaseicmsst"} >0) ? number_format($nota[0]->{"not_totbaseicmsst"}, 2, ".", "") : "0";
	$vTotST  = ($nota[0]->{"not_toticmssubst"} >0) ? number_format($nota[0]->{"not_toticmssubst"}, 2, ".", "") : "0";
	$vTotDesc = ($vTotDesc>0) ? number_format($vTotDesc, 2, ".", "") : "0";
	$vTotIPI =($nota[0]->{"not_totipi"} >0 && !isset($_REQUEST["mod"]) ) ? number_format($nota[0]->{"not_totipi"}, 2, ".", "") : "0";
	
	$vTotProd =($vTotProd >0) ? number_format($vTotProd, 2, ".", "") : "0";
	// $vTotProd =($nota[0]->{"not_totalprod"} > 0) ? number_format($nota[0]->{"not_totalprod"}, 2, ".", "") : "0";

	if($vICMSDesonTot>0){
		//str_pad($this->nota[0]->ser_codigo, 3, "0", STR_PAD_LEFT)
		$vICMSDesonTot = number_format($vICMSDesonTot, 2, ".", "");
	}else{
		$vICMSDesonTot=0;
	}
	//ICMSTot
	$resp = $nfe->tagICMSTot($totBaseicms , $vTotICMS, $vICMSDesonTot, $vFCPUFDestTot, $vICMSUFDestTot, $vICMSUFRemetTot, $vTotBCST, $vTotST, $vTotProd, $vFrete, $vSeg, $vTotDesc, $vII, $vTotIPI, $vTotPIS, $vTotCOFINS, $vTotOutro, $vNF, $vTotTrib2);
	
	//frete
	if($nota[0]->{"not_tpfrete"}=='1'){ //0=Por conta do emitente; 1=Por conta do destinatário/remetente; 2=Por conta de terceiros; 9=sem frete
		$modFrete = '0';
	}elseif($nota[0]->{"not_tpfrete"}=='2'){
		$modFrete = '1';
	}elseif($nota[0]->{"not_tpfrete"}=='3'){
		$modFrete = '2';
	}else{
		$modFrete = '9';
	}
	if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ) $modFrete = "9";
	$resp = $nfe->tagtransp($modFrete);

	//transportadora
	if($transportadora!=""){
		$CNPJ = ($transportadora[0]->{"cad_pessoa"}==2) ? $transportadora[0]->{"cad_cnpjcpf"} : '';
		$CPF = ($transportadora[0]->{"cad_pessoa"}==1) ? $transportadora[0]->{"cad_cnpjcpf"} : '';
		$xNome = $transportadora[0]->{"cad_nomeraz"};
		$IE = ($transportadora[0]->{"cad_inscrg"}) ? $transportadora[0]->{"cad_inscrg"} : '';
		$xEnder = ($transportadora[0]->{"end_nome"}) ? $transportadora[0]->{"end_nome"} : "";
		$xMun = ($transportadora[0]->{"end_cidade"}) ? $transportadora[0]->{"end_cidade"} : "";
		$UF = ( isset($transportadora[0]->{"end_uf"}) && $transportadora[0]->{"end_uf"}!="") ? $transportadora[0]->{"end_uf"} : "PR";
		$resp = $nfe->tagtransporta($CNPJ, $CPF, $xNome, $IE, $xEnder, $xMun, $UF);
		

		//dados dos veiculos de transporte
		$placa = ($not->{"not_placa"}) ? $not->{"not_placa"} : 'AAA0000';
		$UF = ( isset($transportadora[0]->{"end_uf"}) && $transportadora[0]->{"end_uf"}!="") ? $transportadora[0]->{"end_uf"} : "PR";
		$RNTC = '';
		$resp = $nfe->tagveicTransp($placa, $UF, $RNTC);
	}

	//dados dos volumes transportados
	if(!isset($_REQUEST['mod']) || $_REQUEST['mod'] != 65){
		$qVol = (int) $not->{"not_qtde"}; //Quantidade de volumes transportados
		$esp = $not->{"not_especie"}; //Espécie dos volumes transportados
		$marca = $not->{"not_marca"}; //Marca dos volumes transportados
		$nVol = $not->{"not_nro"}; //Numeração dos volume
		$pesoL = ($nota[0]->{"not_pesoliquido"}>0) ? number_format($nota[0]->{"not_pesoliquido"}, 3, ".", "") : "0";
		$pesoB = ($nota[0]->{"not_pesobruto"}>0) ? number_format($nota[0]->{"not_pesobruto"}, 3, ".", "") : "0";
		$aLacres = '';
		$resp = $nfe->tagvol($qVol, $esp, $marca, $nVol, $pesoL, $pesoB, $aLacres);
	}

	//dados da fatura
	$nFat = '';
	$vOrig = '';
	$vDesc = '';
	$vLiq = '';
	//$resp = $nfe->tagfat($nFat, $vOrig, $vDesc, $vLiq);

	//dados das duplicadas
	if(isset($_REQUEST["parc"]) && $_REQUEST["parc"]=='sim' && isset($doctos) && is_array($doctos) && $doctos!=""){
		foreach ($doctos as $docto) {
			$nDup = $docto->{"doc_numero"};
			$dVenc = substr($docto->{"doc_dtvcto"}, 0, 10);
			$vDup = ($docto->{"doc_valor"}>0) ? number_format($docto->{"doc_valor"}, 2, ".", "") : "0.00";
			$resp = $nfe->tagdup($nDup, $dVenc, $vDup);
		}
	}


	//*************************************************************
	//Grupo obrigatório para a NFC-e. Não informar para a NF-e.
	if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ){
		$tPag = '01'; //01=Dinheiro 02=Cheque 03=Cartão de Crédito 04=Cartão de Débito 05=Crédito Loja 10=Vale Alimentação 11=Vale Refeição 12=Vale Presente 13=Vale Combustível 99=Outros
		$vPag = ($nota[0]->{"not_totalnota"}>0) ? number_format($nota[0]->{"not_totalnota"}, 2, ".", "") : "0.00";
		$resp = $nfe->tagpag($tPag, $vPag);
		
		$qrCode = 'http://www.dfeportal.fazenda.pr.gov.br/dfe-portal/rest/servico/consultaNFCe?';
		$seq = 'chNFe='.$chave.'&nVersao=100&tpAmb='.$tpAmb; //URL do QR Code
		$seq.= ( isset($nota[0]->{'not_cpf'}) && $nota[0]->{'not_cpf'}!='' ) ? '&cDest='.$nota[0]->{"not_cpf"} : ''; //URL do QR Code
		$seq.= '&dhEmi='.strtoupper($Nota->str2Hex($dhEmi)).'&vNF='.$vPag.'&vICMS='.$vTotICMS.'&digVal={{digVal}}&cIdToken=000001'; //URL do QR Code
		$qrCode = $qrCode.$seq;
		$resp = $nfe->taginfNFeSupl($qrCode);

		//se a operação for com cartão de crédito essa informação é obrigatória
		$CNPJ = ''; //CNPJ da operadora de cartão
		$tBand = ''; //01=Visa 02=Mastercard 03=American Express 04=Sorocred 99=Outros
		$cAut = ''; //número da autorização da transação
		//$resp = $nfe->tagcard($CNPJ, $tBand, $cAut);
	}
	//**************************************************************

	//informações Adicionais
	$infAdFisco = (isset($not->{"not_inf_fisco"}) && $not->{"not_inf_fisco"}!="") ? str_replace("\n", ". ", trim(base64_decode($not->{"not_inf_fisco"}))) : "";
	$infAdFisco.= (isset($not->{"not_aliqcredicms"}) && $not->{"not_aliqcredicms"}>0) ? " - PERMITE O APROVEITAMENTO DE CREDITO DE ICMS NO VALOR DE R$ ".number_format(($not->{"not_aliqcredicms"}*$nota[0]->{"not_totalnota"}/100), 2, ",", "").", CORRESPONDENTE AO PERCENTUAL DE ".number_format($not->{"not_aliqcredicms"}, 2, ",", "")."% NOS TERMOS DO ART. 23 DA LC 123." : "";
	
	$infCpl = '';
	
	$array1 = array("á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç", "\n", "º", "ª", ":");
	$array2 = array("a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C", ". ", "", "", "");
		
	$infCpl .= (isset($not->{"not_obs1"}) && $not->{"not_obs1"}!="") ? str_replace($array1, $array2, trim(base64_decode($not->{"not_obs1"}))) : "";
	$infCpl .= (isset($not->{"not_obs4"}) && $not->{"not_obs4"}!="") ? str_replace($array1, $array2, trim(base64_decode($not->{"not_obs4"}))) : "";
	$resp = $nfe->taginfAdic($infAdFisco, $infCpl);

	//observações emitente
	$aObsC = array(
		array('email','roberto@x.com.br'),
		array('email','rodrigo@y.com.br'),
		array('email','rogerio@w.com.br')
	);
	foreach ($aObsC as $obs) {
		$xCampo = $obs[0];
		$xTexto = $obs[1];
		//$resp = $nfe->tagobsCont($xCampo, $xTexto);
	}

	//observações fisco
	$aObsF = array(
		array('email','roberto@x.com.br'),
		array('email','rodrigo@y.com.br'),
		array('email','rogerio@w.com.br')
	);
	foreach ($aObsF as $obs) {
		$xCampo = $obs[0];
		$xTexto = $obs[1];
		//$resp = $nfe->tagobsFisco($xCampo, $xTexto);
	}

	//Dados do processo
	//0=SEFAZ; 1=Justiça Federal; 2=Justiça Estadual; 3=Secex/RFB; 9=Outros
	$aProcRef = array(
		array('nProc1','0'),
		array('nProc2','1'),
		array('nProc3','2'),
		array('nProc4','3'),
		array('nProc5','9')
	);
	foreach ($aProcRef as $proc) {
		$nProc = $proc[0];
		$indProc = $proc[1];
		//$resp = $nfe->tagprocRef($nProc, $indProc);
	}

	//dados exportação
	$UFSaidaPais = 'PR';
	$xLocExporta = 'PARANA';
	$xLocDespacho = 'PARANA';
	if($nota[0]->{'end_uf'}=="EX") $resp = $nfe->tagexporta($UFSaidaPais, $xLocExporta, $xLocDespacho);

	//dados de compras
	$xNEmp = '';
	$xPed = '12345';
	$xCont = 'A342212';
	//$resp = $nfe->tagcompra($xNEmp, $xPed, $xCont);

	//dados da colheita de cana
	$safra = '2014';
	$ref = '01/2014';
	//$resp = $nfe->tagcana($safra, $ref);

	$aForDia = array(
		array('1', '100', '1400', '1000', '1400'),
		array('2', '100', '1400', '1000', '1400'),
		array('3', '100', '1400', '1000', '1400'),
		array('4', '100', '1400', '1000', '1400'),
		array('5', '100', '1400', '1000', '1400'),
		array('6', '100', '1400', '1000', '1400'),
		array('7', '100', '1400', '1000', '1400'),
		array('8', '100', '1400', '1000', '1400'),
		array('9', '100', '1400', '1000', '1400'),
		array('10', '100', '1400', '1000', '1400'),
		array('11', '100', '1400', '1000', '1400'),
		array('12', '100', '1400', '1000', '1400'),
		array('13', '100', '1400', '1000', '1400'),
		array('14', '100', '1400', '1000', '1400')
	);
	foreach ($aForDia as $forDia) {
		$dia = $forDia[0];
		$qtde = $forDia[1];
		$qTotMes = $forDia[2];
		$qTotAnt = $forDia[3];
		$qTotGer = $forDia[4];
		//$resp = $nfe->tagforDia($dia, $qtde, $qTotMes, $qTotAnt, $qTotGer);
	}

	//monta a NFe
	$resp = $nfe->montaNFe();

	$modSOAP = '2';
	
	if(!$resp){
		$erro = "Erro XML Incompleto: <br>";
		foreach ($nfe->erros as $err) {
			$erro.= 'tag: &lt;'.$err['tag'].'&gt; : '.$err['desc'].'<br>';
		}
		echo $erro;
		exit();
	}
	
	//instancia ferramentas NFe e classes para atualização do BD
	$tools = new ToolsNFePHP;
	$TParams = new TParams();
	$Datapacket = new Datapacket();
	$Datapacket->setHost($TParams->getHost($company->{'emp_db_sge'}));

	//pasta padrão para o xml
	if($nota[0]->{'not_status'}==2){
		if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas')){
			@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas',0777);
		}
		$nfeDir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas/'.$Nota->anoMes."/";
		if(!is_dir($nfeDir)){
			@mkdir($nfeDir,0777);
		}
		$situacao = "autorizadas";
	}else if($nota[0]->{'not_cstat'} == '110' || $nota[0]->{'not_cstat'} == '205' || $nota[0]->{'not_cstat'} == '233' || $nota[0]->{'not_cstat'} == '234' || $nota[0]->{'not_cstat'} == '301' || $nota[0]->{'not_cstat'} == '302'){
		if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas')){
			@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas',0777);
		}
		$nfeDir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas/'.$Nota->anoMes."/";
		if(!is_dir($nfeDir)){
			@mkdir($nfeDir,0777);
		}
		$situacao = "denegadas";
	}else if($nota[0]->{'not_cstat'} == '101' || $nota[0]->{'not_cstat'} == '135'){
		if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas')){
			@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas',0777);
		}
		$nfeDir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas/'.$Nota->anoMes."/";
		if(!is_dir($nfeDir)){
			@mkdir($nfeDir,0777);
		}
		$situacao = "canceladas";
	}else if($nota[0]->{'not_status'}==1){
		if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando')){
			@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando',0777);
		}
		$nfeDir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando/'.$Nota->anoMes."/";
		if(!is_dir($nfeDir)){
			@mkdir($nfeDir,0777);
		}
		$situacao = "aguardando";
	}else{
		if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/temporarias')){
			@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/temporarias',0777);
		}
		$nfeDir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/temporarias/'.$Nota->anoMes."/";
		if(!is_dir($nfeDir)){
			@mkdir($nfeDir,0777);
		}
		$situacao = "temporarias";
	}

	if(is_dir($nfeDir)){
		
		//Criar e escrever arquivo XML com os dados gerados
		if(!empty($nota[0]->{'not_key_nfe'})){
			$nomeArquivo = $nfeDir.$nota[0]->{'not_key_nfe'}.'-nfe.xml';
		}else{
			$nomeArquivo = $nfeDir.$Nota->gerarChave().'-nfe.xml';
		}
		
		if($nota[0]->{"not_status"}==0){
			$arquivoXML = fopen($nomeArquivo,'w+');
			if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ){
				$seq = str_replace("{{digVal}}", strtoupper($Nota->str2Hex($nfe->digVal)), $seq);
				$cHashQRCode = sha1($seq.$company->{"emp_csc"});
				fwrite($arquivoXML, str_replace( array("{{digVal}}", "&cIdToken=000001"), array(strtoupper($Nota->str2Hex($nfe->digVal)), "&cIdToken=000001&cHashQRCode=".$cHashQRCode), $nfe->getXML())); //substituir digval e hash no url do qrcode (somente NFC-e)
			}else{
				fwrite($arquivoXML, $nfe->getXML());
			}
			
			fclose($arquivoXML);
		}
		
		
		$aErro = array();
		$docxml = file_get_contents($nomeArquivo);
		
		if(isset($_REQUEST["motivo"]) && $_REQUEST["motivo"]=="erro"){

			//classe p/ envio
			include_once "../libs/MailNFePHP.class.php";
			
			//dados de configuração de envio
			$config = array(
				"mailAuth"=>"1",
				"mailFROM"=>strtolower($company->{"emp_emailremetente"}),
				"mailHOST"=>strtolower($company->{'emp_hostsmtp'}),
				"mailUSER"=>strtolower($company->{"emp_emailremetente"}),
				"mailPASS"=>$company->{"emp_pwdsmtp"},
				"mailPORT"=>"587",
				"mailPROTOCOL"=>"",
				"mailFROMmail"=>strtolower($company->{"emp_emailremetente"}),
				"mailFROMname"=>$company->{"emp_fantasia"},
				"mailREPLYTOmail"=>strtolower($company->{"emp_emailremetente"}),
				"mailREPLYTOname"=>$company->{"emp_fantasia"},
				"mailIMAPhost"=>"",
				"mailIMAPport"=>"",
				"mailIMAPsecurity"=>"",
				"mailIMAPnocerts"=>"",
				"mailIMAPbox"=>"",
				"recebidasDir"=>"",
				"temporariasDir"=>"",
				"canceladasDir"=>"",
				"CNPJ"=>$company->{"emp_cpfcnpj"},
				"mailLayoutFile"=>""
			);

			$email = new MailNFePHP($config);
			$msg = str_replace(" ","+",$_REQUEST["msg"]);
			$msg = base64_decode($msg);

			$to = base64_decode($_REQUEST["email"]);
			$to = str_replace(" ", "", $to);
			if(strstr($to, ";")) $to = explode(";", $to);
			elseif(strstr($to, ",")) $to = explode(",", $to);
			
			$cliente = $nota[0]->{"cad_nomeraz"};
			$assunto = utf8_decode("Erro de NF-e - C: ".$company->{"emp_codigo"}." - S: ".$nota[0]->{"ser_codigo"}." - N: ".$nota[0]->{"not_numero"});
			if(isset($nomeArquivo) && $nomeArquivo!=""){
				$arqxml = $nomeArquivo;
			}else{
				$arqxml = "";
			}
			$arqpdf = "";
			$auth = "1";
			$outro = "";

			//texto puro (sem html)
			$txt = strip_tags($msg);

			if(is_array($to)){

				$msgfinal = "";
				foreach($to as $para){
					if($email->sendM($para, $cliente, $assunto, utf8_decode($txt), utf8_decode($msg), $arqxml, $arqpdf, $auth, $outro))
						$msgfinal.= $para." - Enviado!<br>";
					else
						$msgfinal.= $para." - Não Enviado!<br>";
				}
				exit($msgfinal);

			}else{

				if( $email->sendM($to, $cliente, $assunto, $txt, $msg, $arqxml, "", "0", "") ){
					exit("E-mail enviado com sucesso!");
				}else{
					exit("Erro ao tentar enviar e-mail, verifique as configurações de envio e tente novamente mais tarde.<br>Ação:E-mail suporte");
				}

			}

		}else{

			//acao=transmitir
			if($_REQUEST["acao"]=="transmitir"){

				//Validar XML
				if (!$tools->validXML($docxml, '../schemes/PL_008h/nfe_v3.10.xsd', $aErro)) {
					
					//XML inválido - erro
					$erro = 'Erro(s) na estrutura XML: <br>';
					foreach ($aErro as $er) {
						$erro.= $er .'<br>';
					}
					//Atualização do log com os dados de erros no XML
					$filtrolog = '{"cod":"700103","params":[
						{"name":"log_tipo","value":"2","type":"integer"},
						{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
						{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
					$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
					$filtrolog.= '{"name":"log_acao_cod","value":"2","type":"integer"},
						{"name":"log_acao_descr","value":"edição","type":"string"},
						{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"log_protocolo","value":"NULL","type":"other"},
						{"name":"log_ret","value":"NULL","type":"other"},
						{"name":"log_outro","value":"'.base64_encode(str_replace("<br>", "; ", $erro)).'","type":"string"}
					]}';
					$Datapacket->add($filtrolog);
					$Datapacket->open();

					//classe p/ envio
					include_once "../libs/MailNFePHP.class.php";
					
					//dados de configuração de envio
					$config = array(
						"mailAuth"=>"0",
						"mailFROM"=>$company->{"emp_emailremetente"},
						"mailHOST"=>'127.0.0.1',
						"mailUSER"=>$company->{"emp_emailremetente"},
						"mailPASS"=>$company->{"emp_pwdsmtp"},
						"mailPORT"=>"587",
						"mailPROTOCOL"=>"",
						"mailFROMmail"=>$company->{"emp_emailremetente"},
						"mailFROMname"=>$company->{"emp_fantasia"},
						"mailREPLYTOmail"=>$company->{"emp_emailremetente"},
						"mailREPLYTOname"=>$company->{"emp_fantasia"},
						"mailIMAPhost"=>"",
						"mailIMAPport"=>"",
						"mailIMAPsecurity"=>"",
						"mailIMAPnocerts"=>"",
						"mailIMAPbox"=>"",
						"recebidasDir"=>"",
						"temporariasDir"=>"",
						"canceladasDir"=>"",
						"CNPJ"=>$company->{"emp_cpfcnpj"},
						"mailLayoutFile"=>""
					);

					$email = new MailNFePHP($config);
					$msg = str_replace(" ","+",$_REQUEST["msg"]);
					$msg = base64_decode($msg);

					$to = base64_decode($_REQUEST["email"]);
					$to = str_replace(" ", "", $to);
					if(strstr($to, ";")) $to = explode(";", $to);
					elseif(strstr($to, ",")) $to = explode(",", $to);
					
					$cliente = $nota[0]->{"cad_nomeraz"};
					$assunto = utf8_decode("Erro de NF-e - C: ".$company->{"emp_codigo"}." - S: ".$nota[0]->{"ser_codigo"}." - N: ".$nota[0]->{"not_numero"});
					if(isset($nomeArquivo) && $nomeArquivo!=""){
						$arqxml = $nomeArquivo;
					}else{
						$arqxml = "";
					}
					$arqpdf = "";
					$auth = "0";
					$outro = "";

					//texto puro (sem html)
					$txt = strip_tags($msg);

					if(is_array($to)){

						$msgfinal = "";
						foreach($to as $para){
							if($email->sendM($para, $cliente, $assunto, utf8_decode($txt), utf8_decode($msg), $arqxml, $arqpdf, $auth, $outro))
								$msgfinal.= $para." - Enviado!<br>";
							else
								$msgfinal.= $para." - Não Enviado!<br>";
						}
						exit($msgfinal);

					}else{

						if( $email->sendM($to, $cliente, $assunto, utf8_decode($txt), utf8_decode($msg).$arqpdf, $arqxml, $arqpdf, $auth, $outro) ){
							exit("E-mail enviado com sucesso!");
						}else{
							exit("<br><div style='margin:10px;background-color:#fde8e8;border:1px #ffd6d6 solid; border-radius:8px'><div style='padding:2px;border:1px #fee2e2 solid; border-radius:8px'>".$erro."</div></div><br>Ação:Validar Xml");
						}

					}
					
					echo $erro;

				}else{ //XML válido prosseguir

					//Assinar XML
					if ($xml = $tools->signXML($docxml, 'infNFe')){
					
						file_put_contents($nomeArquivo, $xml);
						$docxml = file_get_contents($nomeArquivo);
						//Obter um numero de lote
						$lote = substr(str_replace(',','',number_format(microtime(true)*1000000,0)),0,15);

						//Enviar o lote
						if ($retorno = $tools->autoriza($docxml, $lote, $aResp)){
							if ($retorno['bStat']){
								//Pegar Protocolo
								if($prot = $tools->getProtocol("", $chave, $tpAmb, $retorno)){
									$nfefile 	= $nomeArquivo;
									$protfile 	= $nfeDir.$chave.'-prot.xml';

									//Criar arquivo protocolo
									$arquivoProt = fopen($protfile,'w+');
									fwrite($arquivoProt, $prot);
									fclose($arquivoProt);
									
									//Adicionar Protocolo ao XML da NF-e
									if ($xml = $tools->addProt($nfefile, $protfile)){
										file_put_contents($nfefile, $xml);
									}
								}
								
								$docxmll = file_get_contents($nfefile);
								$dhRecbto = implode("-", array_reverse(explode("/", substr($retorno["aProt"]["dhRecbto"], 0, 10))));
								$dhRecbto.= substr($retorno["aProt"]["dhRecbto"], 10, 9);
								
								if($retorno['cStat']=="100"){
									
									if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas')){
										@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas',0777);
									}
									$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas/'.$Nota->anoMes.'/';
									if(!is_dir($dir)){
										@mkdir($dir,0777);
									}
									copy($nomeArquivo, $dir.$chave.'-nfe.xml');
									unlink($nomeArquivo);
									
									//Fazer lançamento no financeiro caso haja opção de pagamento com entrada em dinheiro
									/*
									if($nota[0]->{'not_entrsaida'}==2 && (!$nota[0]->{'not_finanatualiz'} || $nota[0]->{'not_finanatualiz'}==0) ){
										$cdp_json = json_decode(base64_decode($nota[0]->{"cdp_json"}));
										if($cdp_json){
											if($cdp_json->{'prazo'}[0]->{0}==10){
												$lan_valor = $nota[0]->{"not_totalnota"}/(int) (count($cdp_json->{'prazo'}));
												$lan_valor = ($lan_valor>0) ? number_format($lan_valor, 5, ".", "") : "0";
												$filtrolancto = '{"cod":"700109","params":[
													{"name":"lan_historico","value":"NF-e N '.$nota[0]->{"not_numero"}.' - LANCAMENTO CRIADO A PARTIR DE NOTA FISCAL DE SAIDA","type":"string"},
													{"name":"lan_data","value":"'.$dhRecbto.'","type":"string"},
													{"name":"lan_valor","value":"'.$lan_valor.'","type":"float"},
													{"name":"lan_conc","value":"0","type":"integer"},
													{"name":"lan_dc","value":"2","type":"integer"},
													{"name":"ser_codigo","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
													{"name":"cta_codigo","value":"'.$nota[0]->{"cta_codigo"}.'","type":"string"},
													{"name":"plc_codigo","value":"NULL","type":"other"},
													{"name":"doc_codigo","value":"NULL","type":"other"},
													{"name":"ccu_codigo","value":"NULL","type":"other"},
													{"name":"lan_dtmov","value":"NULL","type":"other"}
												]}';
												$Datapacket->add($filtrolancto);
											}
										}
									}
									*/
									
									$ant="";
									//Atualização do estoque do(s) produto(s) (caso ainda não esteja atualizado)
									if( !$nota[0]->{'not_stokatualiz'} || $nota[0]->{'not_stokatualiz'}==0 ){
										foreach($nota as $not){
											if( $not->{"itn_ordem"}!=$ant ){
												
												$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
												$loc_codigo = ($not->{'loc_codigo'}) ? $not->{'loc_codigo'} : "1";
												$lot_codigo = ($not->{'lot_codigo'}) ? $not->{'lot_codigo'} : "99999";
												$stk_qde = ($nota[0]->{'not_entrsaida'}==2) ? '-'.$not->{'itn_qtde'} : $not->{'itn_qtde'};
												$filtrostk = '{"cod":"700111","params":[
													{"name":"db","value":"'.$company->{"emp_db_comum"}.'","type":"other"},
													{"name":"emp_codigo","value":"'.$company->{"emp_codigo"}.'","type":"string"},
													{"name":"loc_codigo","value":"'.$loc_codigo.'","type":"string"},
													{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"string"},
													{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"},
													{"name":"ser_codigo","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
													{"name":"stk_data","value":"'.$dhRecbto.'","type":"string"},
													{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
													{"name":"stk_qde","value":"'.$stk_qde.'","type":"float"},
													{"name":"stk_tipo","value":"'.$nota[0]->{'not_entrsaida'}.'","type":"integer"},
													{"name":"not_codigo","value":"'.$_REQUEST['not_codigo'].'","type":"string"}
												]}';
												$Datapacket->add($filtrostk);
												$ant = $not->{"itn_ordem"};
												
											}
										}
									}
									
									//Atualizar os dados de retorno da NF-e no banco de dados (autorizada)
									$filtroAtualiza = '{"cod":"700105","params":[
										{"name":"not_status","value":"2","type":"integer"},
										{"name":"not_dtfaturam","value":"'.$dhRecbto.'","type":"string"},
										{"name":"not_dtprevisao","value":"'.$dhRecbto.'","type":"string"},
										{"name":"not_dtentrega","value":"'.$dhRecbto.'","type":"string"},
										{"name":"not_finanatualiz","value":"1","type":"integer"},
										{"name":"not_stokatualiz","value":"1","type":"integer"},
										{"name":"not_custoautaliz","value":"1","type":"integer"},
										{"name":"not_key_nfe","value":"'.$retorno["chNFe"].'","type":"string"},
										{"name":"not_result","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
										{"name":"not_cstat","value":"'.$retorno['cStat'].'","type":"string"},
										{"name":"not_xmotivo","value":"'.base64_encode($retorno['xMotivo']).'","type":"string"},
										{"name":"not_aliq","value":"'.$itn_aliqicms.'","type":"string"},
										{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
										{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},';

									if($retorno["aProt"]["nProt"]){
										$filtroAtualiza .= '{"name":"not_nprot","value":"'.$retorno["aProt"]["nProt"].'","type":"string"}';
									}else{
										$filtroAtualiza .= '{"name":"not_nprot","value":"","type":"null"}';
									}

									$filtroAtualiza.=']}';
									
									$Datapacket->add($filtroAtualiza);
									
									//Atualização do Log da NF-e com os dados transmitidos
									$filtrolog = '{"cod":"700103","params":[
										{"name":"log_tipo","value":"2","type":"integer"},
										{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
										{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
									$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
									$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
										{"name":"log_acao_descr","value":"transmissão","type":"string"},
										{"name":"log_data","value":"'.$dhRecbto.'","type":"string"},
										{"name":"log_protocolo","value":"'.$retorno["aProt"]["nProt"].'","type":"string"},
										{"name":"log_ret","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
										{"name":"log_outro","value":"'.base64_encode("NF-e transmitida com sucesso!").'","type":"string"}
									]}';
									$Datapacket->add($filtrolog);
									
									$Datapacket->open(true);
									
									//print_r($Datapacket->getLastQuery());
									
									//DANFE
									$logo = "http://".$_SERVER['SERVER_NAME']."/uploads/".$_REQUEST["emp_codigo"]."/".$company->{"emp_logo"};
									$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas/'.$Nota->anoMes.'/';

									if(isset($_REQUEST['calcNcm'])){
										$calcNcm = $_REQUEST['calcNcm'];
									}else{
										$calcNcm = 0;
									}
									if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ){
										if(isset($company->{"emp_logo"}) && !empty($company->{"emp_logo"})){
											$danfe = new DanfeNFCeNFePHP($docxmll, $logo, 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
										}else{
											$danfe = new DanfeNFCeNFePHP($docxmll, '', 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
										}
										
										$id = $danfe->montaDANFE(false, $calcNcm);
										
										$danfe->printDANFE('html', $dir.$chave.'.html', 'F',$Nota->anoMes);
										
									}else{
										$danfe = new DanfeNFePHP($docxmll, 'C', 'A4', $logo, 'F', $dir,$company);
										$id = $danfe->montaDANFE();
										$danfe->printDANFE($dir.$chave.'.pdf', 'F',$Nota->anoMes);
									}
									
									echo "NF-e transmitida com sucesso! Chave: ".$retorno["chNFe"];
								
								}else{
									
									//arquivo de protocolo
									$arq = substr($nfeDir,0,-7).$chave.'-prot.xml';
									if( is_file($arq) && file_exists($arq) ){
										
										$prot = file_get_contents($arq);
										$prot = str_replace(":","",$prot);
										$prot = simplexml_load_string($prot);
										if($prot->soapBody->nfeAutorizacaoLoteResult->retEnviNFe->protNFe->infProt->xMotivo){
											exit("Erro: ".$prot->soapBody->nfeAutorizacaoLoteResult->retEnviNFe->protNFe->infProt->xMotivo);
										}elseif($prot->soapBody->nfeAutorizacaoLoteResult->retEnviNFe->xMotivo){
											exit("Erro: ".$prot->soapBody->nfeAutorizacaoLoteResult->retEnviNFe->xMotivo);
										}else{
											"Erro: lote processado porem invalidado";
										}
										
									}else{
									
										$not_finanatualiz = ( isset($nota[0]->{"not_finanatualiz"}) ) ? $nota[0]->{"not_finanatualiz"} : "0";
										$not_stokatualiz = ( isset($nota[0]->{"not_stokatualiz"}) ) ? $nota[0]->{"not_stokatualiz"} : "0";
										$not_custoautaliz = ( isset($nota[0]->{"not_custoautaliz"}) ) ? $nota[0]->{"not_custoautaliz"} : "0";
										
										//atualiza status nf-e no banco para 1 (aguardando retorno)
										$filtroAtualiza = '{"cod":"700105","params":[
											{"name":"not_status","value":"1","type":"integer"},
											{"name":"not_dtfaturam","value":" ","type":"string"},
											{"name":"not_dtprevisao","value":" ","type":"string"},
											{"name":"not_dtentrega","value":" ","type":"string"},
											{"name":"not_finanatualiz","value":"'.$not_finanatualiz.'","type":"integer"},
											{"name":"not_stokatualiz","value":"'.$not_stokatualiz.'","type":"integer"},
											{"name":"not_custoautaliz","value":"'.$not_custoautaliz.'","type":"integer"},
											{"name":"not_key_nfe","value":"'.$chave.'","type":"string"},
											{"name":"not_result","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
											{"name":"not_cstat","value":"'.$retorno['cStat'].'","type":"string"},
											{"name":"not_xmotivo","value":"'.base64_encode($retorno['xMotivo']).'","type":"string"},
											{"name":"not_aliq","value":"'.$itn_aliqicms.'","type":"string"},
											{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
											{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},';

										if($retorno["aProt"]["nProt"]){
											$filtroAtualiza .= '{"name":"not_nprot","value":"'.$retorno["aProt"]["nProt"].'","type":"string"}';
										}else{
											$filtroAtualiza .= '{"name":"not_nprot","value":"NULL","type":"other"}';
										}

										$filtroAtualiza.=']}';
										
										$Datapacket->add($filtroAtualiza);
										
										//Atualização do Log da NF-e
										$filtrolog = '{"cod":"700103","params":[
											{"name":"log_tipo","value":"2","type":"integer"},
											{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
											{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
										$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
										$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
											{"name":"log_acao_descr","value":"transmissão","type":"string"},
											{"name":"log_data","value":"","type":"string"},
											{"name":"log_protocolo","value":"'.$retorno["aProt"]["nProt"].'","type":"string"},
											{"name":"log_ret","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
											{"name":"log_outro","value":"'.base64_encode($retorno['xMotivo']).'","type":"string"}
										]}';
										$Datapacket->add($filtrolog);
										
										$Datapacket->open(true);
											
										if($retorno['cStat'] == '110' || $retorno['cStat'] == '205' || $retorno['cStat'] == '233' || $retorno['cStat'] == '234' || $retorno['cStat'] == '301' || $retorno['cStat'] == '302'){
											if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas')){
												@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas',0777);
											}
											$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas/'.$Nota->anoMes.'/';
											if(!is_dir($dir)){
												@mkdir($dir,0777);
											}
											copy($nomeArquivo, $dir.$chave.'-nfe.xml');
											unlink($nomeArquivo);
										}else if($retorno['cStat'] == '101' || $retorno['cStat'] == '135'){
											if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas')){
												@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas',0777);
											}
											$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas/'.$Nota->anoMes.'/';
											if(!is_dir($dir)){
												@mkdir($dir,0777);
											}
											copy($nomeArquivo, $dir.$chave.'-nfe.xml');
											unlink($nomeArquivo);
										}else{
											if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando')){
												@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando',0777);
											}
											$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando/'.$Nota->anoMes.'/';
											if(!is_dir($dir)){
												@mkdir($dir,0777);
											}
											copy($nomeArquivo, $dir.$chave.'-nfe.xml');
											unlink($nomeArquivo);
										}
										
										echo "NF-e aguardando retorno!";
										
									}
									
								}

								//rotina para o facil novo
									
							} else {
							
								$filtrolog = '{"cod":"700103","params":[
									{"name":"log_tipo","value":"2","type":"integer"},
									{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
									{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
								$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
								$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
									{"name":"log_acao_descr","value":"transmissão","type":"string"},
									{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
									{"name":"log_protocolo","value":"NULL","type":"other"},
									{"name":"log_ret","value":"NULL","type":"other"},
									{"name":"log_outro","value":"'.base64_encode("Erro!: ".$tools->errMsg).'","type":"string"}
								]}';
								$Datapacket->add($filtrolog);
								$Datapacket->open();
								echo "Erro!: ".$tools->errMsg;
								
							}

						} else {

							//Atualização do log com dados de erro na tentativa de transmissão
							$filtrolog = '{"cod":"700103","params":[
								{"name":"log_tipo","value":"2","type":"integer"},
								{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
								{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
							$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
							$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
								{"name":"log_acao_descr","value":"transmissão","type":"string"},
								{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
								{"name":"log_protocolo","value":"NULL","type":"other"},
								{"name":"log_ret","value":"NULL","type":"other"},
								{"name":"log_outro","value":"'.base64_encode("Erro!: ".$tools->errMsg).'","type":"string"}
							]}';
							$Datapacket->add($filtrolog);
							$Datapacket->open();
							
							echo "Erro!: ".$tools->errMsg;
							$cStat = substr($tools->errMsg,0,3);

							if($cStat == '100'){
								if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas')){
									@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas',0777);
								}
								$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas/'.$Nota->anoMes.'/';
								if(!is_dir($dir)){
									@mkdir($dir,0777);
								}
								copy($nomeArquivo, $dir.$chave.'-nfe.xml');
								unlink($nomeArquivo);
							}else if($cStat == '110' || $cStat == '205' || $cStat == '233' || $cStat == '234' || $cStat == '301' || $cStat == '302'){
								if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas')){
									@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas',0777);
								}
								$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas/'.$Nota->anoMes.'/';
								if(!is_dir($dir)){
									@mkdir($dir,0777);
								}
								copy($nomeArquivo, $dir.$chave.'-nfe.xml');
								unlink($nomeArquivo);
							}else if($cStat == '101' || $cStat == '135'){
								if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas')){
									@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas',0777);
								}
								$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas/'.$Nota->anoMes.'/';
								if(!is_dir($dir)){
									@mkdir($dir,0777);
								}
								copy($nomeArquivo, $dir.$chave.'-nfe.xml');
								unlink($nomeArquivo);
							}else{
								if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando')){
									@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando',0777);
								}
								$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando/'.$Nota->anoMes.'/';
								if(!is_dir($dir)){
									@mkdir($dir,0777);
								}
								copy($nomeArquivo, $dir.$chave.'-nfe.xml');
								unlink($nomeArquivo);
							}

						}
					
					} else {
				
						//Atualização do log com erro de assinatura de XML
						$filtrolog = '{"cod":"700103","params":[
							{"name":"log_tipo","value":"2","type":"integer"},
							{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
							{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
						$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
						$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
							{"name":"log_acao_descr","value":"transmissão","type":"string"},
							{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
							{"name":"log_protocolo","value":"NULL","type":"other"},
							{"name":"log_ret","value":"NULL","type":"other"},
							{"name":"log_outro","value":"'.base64_encode("Erro na Assinatura XML: ".$tools->errMsg).'","type":"string"}
						]}';
						$Datapacket->add($filtrolog);
						$Datapacket->open();
					
						echo "Erro na Assinatura XML: ".$tools->errMsg;
						
					}
					
				}
				
			//acao = imprimir DANFE
			}elseif($_REQUEST["acao"]=="imprimir"){
				
				//Atualização do log (impressao)
				$filtrolog = '{"cod":"700103","params":[
					{"name":"log_tipo","value":"2","type":"integer"},
					{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
					{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
				$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
				$filtrolog.= '{"name":"log_acao_cod","value":"4","type":"integer"},
					{"name":"log_acao_descr","value":"impressão","type":"string"},
					{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"log_protocolo","value":"NULL","type":"other"},
					{"name":"log_ret","value":"NULL","type":"other"},
					{"name":"log_outro","value":"'.base64_encode("Impressão da DANFE").'","type":"string"}
				]}';
				$Datapacket->add($filtrolog);
				$Datapacket->open();
				
				$logo = $TParams->uploads.$_REQUEST["emp_codigo"]."/".$company->{"emp_logo"};
				// $logo = substr($logo, 0, -3)."jpg"; //tem quer ser jpg!!!!
				$dir = $nfeDir;
				if(isset($_REQUEST['calcNcm'])){
					$calcNcm = $_REQUEST['calcNcm'];
				}else{
					$calcNcm = 0;
				}
				
				if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ){
					if(isset($company->{"emp_logo"}) && !empty($company->{"emp_logo"})){
						$danfe = new DanfeNFCeNFePHP($docxml, $logo, 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
					}else{
						$danfe = new DanfeNFCeNFePHP($docxml, '', 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
					}
					$id = $danfe->montaDANFE(false, $calcNcm);
					$danfe->printDANFE('html', $dir.$chave.'.html', 'F',$Nota->anoMes);
				}else{
					if($situacao=="canceladas"){
						$docxml = file_get_contents(substr($nomeArquivo, 0, -7)."nfe2.xml");
					}
					$danfe = new DanfeNFePHP($docxml, 'C', 'A4', $logo, 'F', $dir,$company);
					if($situacao=="canceladas"){
						$id = $danfe->montaDANFE('', 'A4', 'C', 1);
					}else{
						$id = $danfe->montaDANFE();
					}
					$danfe->printDANFE($dir.$chave.'.pdf', 'F',$Nota->anoMes);
				}
				
				if(isset($_REQUEST['mod'])&&$_REQUEST['mod']=='65'){
					exit('/uploads/'.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/'.$situacao.'/'.$Nota->anoMes.'/'.$chave.'.html');
				}else{
					exit('/uploads/'.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/'.$situacao.'/'.$Nota->anoMes.'/'.$chave.'.pdf');
				}
			
			//acao = baixar o XML da NF-e
			}elseif($_REQUEST["acao"]=="baixar"){
			
				header("Expires: 0");
				header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
				header("Content-Disposition: attachment; filename=".$chave."-nfe.xml");
				header("Content-Type: application/force-download");
				readfile($nomeArquivo);
				
				exit();
			
			//acao = email - enviar um e-mail com os arquivos da NF-e
			}elseif($_REQUEST["acao"]=="email"){
				
				$Datapacket->clear();
				$filter = '{"cod":"700268","params":[
					{"name":"dbcomum","value":"'.$company->{'emp_db_comum'}.'","type":"other"},
					{"name":"men_codigo","value":"3","type":"integer"}
				]}';
				$Datapacket->add($filter);
				$ret = $Datapacket->open(true);
				
				$valor = ($nota[0]->{"not_totalnota"}>0) ? number_format($nota[0]->{"not_totalnota"}, 2, ",", "") : "0,00";
				
				if( isset($_REQUEST["msg"]) && $_REQUEST["msg"]!="" ){
					
					$msg_conteudo = $_REQUEST["msg"];
					
					$msg_remetente = $company->{'emp_emailremetente'};
					
					$msg_assunto = "Envio de NF-e N: ".$nota[0]->{"not_numero"}." - série: ".$nota[0]->{"ser_codigo"};
					
				}elseif($ret && $ret[0] && $ret[0]->men_conteudo && $ret[0]->men_conteudo!=""){
					
					$msg_conteudo = $ret[0]->men_conteudo;
					
					$msg_remetente = $ret[0]->men_remetente;
					
					$msg_assunto = $ret[0]->men_assunto;
					
				}else{
					
					$msg = "<p><b>Prezado Sr(a) {{destinatario}},</b></p>";
					$msg .= "<p>Você está recebendo a Nota Fiscal Eletrônica número ".$nota[0]->{"not_numero"}.", série ".$nota[0]->{"ser_codigo"}." de";
					$msg .= " ".$company->{"emp_razao"}.", no valor de R$ ".$valor.". Junto com a mercadoria, você receberá também um DANFE";
					$msg .= " (Documento Auxiliar da Nota Fiscal Eletrônica), que acompanha o trânsito das";
					$msg .= " mercadorias.</p>";
					$msg .= "<p><i>Podemos conceituar a Nota Fiscal Eletrônica como um documento de existência apenas";
					$msg .= " digital, emitido e armazenado eletronicamente, com o intuito de documentar, para fins";
					$msg .= " fiscais, uma operação de circulação de mercadorias, ocorrida entre as partes.";
					$msg .= " Sua validade jurídica garantida pela assinatura digital do remetente (garantia de autoria";
					$msg .= " e de integridade) e recepção, pelo Fisco, do documento eletrônico, antes da";
					$msg .= " ocorrência do Fato Gerador.</i></p>";
					$msg .= "<p><i>Os registros fiscais e contábeis devem ser feitos, a partir do próprio arquivo";
					$msg .= " da NF-e, anexo neste e-mail, ou utilizando o DANFE, que representa graficamente a Nota";
					$msg .= " Fiscal Eletrônica. A validade e autenticidade deste documento eletrônico pode ser";
					$msg .= " verificada no site nacional do projeto (www.nfe.fazenda.gov.br), através da chave de acesso";
					$msg .= " contida no DANFE.</i></p>";
					$msg .= "<p><i>Para poder utilizar os dados descritos do DANFE na escrituração da NF-e, tanto o";
					$msg .= " contribuinte destinatário, como o contribuinte emitente, terão de verificar a validade da";
					$msg .= " NF-e. Esta validade está vinculada à efetiva existência da NF-e nos arquivos da SEFAZ,";
					$msg .= " e comprovada através da emissão da Autorização de Uso.</i></p>";
					$msg .= "<p><b>O DANFE não é uma nota fiscal, nem substitui uma nota fiscal, servindo apenas";
					$msg .= " como instrumento auxiliar para consulta da NF-e no Ambiente Nacional.</b></p>";
					$msg .= "<p>Para mais detalhes sobre o projeto, consulte: ";
					$msg .= "<a href='http://www.nfe.fazenda.gov.br/portal/Default.aspx'>www.nfe.fazenda.gov.br</a></p>";
					$msg .= "<br /><p>Atenciosamente,<p>{{remetente}}</p>";
					
					$msg_conteudo = base64_encode(utf8_decode($msg));
					
					$msg_remetente = $company->{'emp_emailremetente'};
					
					$msg_assunto = "Envio de NF-e N: ".$nota[0]->{"not_numero"}." - série: ".$nota[0]->{"ser_codigo"};
					
				}

				$msg_anexo = base64_encode("[{\"descricao\" : \"".base64_encode(utf8_decode("Nota Fiscal Eletrônica número ".$nota[0]->{"not_numero"}.", série ".$nota[0]->{"ser_codigo"}." de ".$company->{"emp_razao"}.", no valor de R$ ".$valor))."\", \"arquivo\" : \"".$nfeDir.$chave.".pdf\" }, {\"descricao\" : \"\", \"arquivo\" : \"".$nomeArquivo."\" }]");
				
				$to = base64_decode($_REQUEST["email"]);
				$to = strtolower(str_replace(" ", "", $to));
				if(strstr($to, ";")) $to = explode(";", $to);
				elseif(strstr($to, ",")) $to = explode(",", $to);
				
				$msg_destinatario = (is_array($to)) ? str_replace("\"", "", $to[0]) : str_replace("\"", "", $to);
				
				$filtro = '{"cod":"700321","params":[
					{"name":"msg_codigo","value":"","type":"string"},
					{"name":"msg_tipo","value":"1","type":"integer"},
					{"name":"men_codigo","value":"3","type":"integer"},
					{"name":"msg_remetente","value":"'.$msg_remetente.'","type":"string"},
					{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
					{"name":"cad_codigo","value":"'.$nota[0]->cad_codigo.'","type":"string"},
					{"name":"msg_assunto","value":"'.$msg_assunto.'","type":"string"},
					{"name":"msg_conteudo","value":"'.$msg_conteudo.'","type":"string"},
					{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"msg_status","value":"0","type":"integer"},
					{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
				]}';
				
				$Datapacket->clear();
				$Datapacket->add($filtro);
				$ret = $Datapacket->open(false, true);
				
				if($ret){
					$Datapacket->clear();
					//vinculo mensagem-nota
					$filtro = '{"cod":"700329","params":[
						{"name":"msg_codigo","value":"'.$ret.'","type":"integer"},
						{"name":"vin_tabela","value":"header_nota","type":"string"},
						{"name":"vin_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"}
					]}';
					$Datapacket->add($filtro);
					$Datapacket->open();
					$_REQUEST["acao"] = "enviar";
					$_REQUEST["msg_codigo"] = $ret;
					
					include_once "../../mensagem.php";
				}
				
				
				/*
				//classe p/ envio
				include_once "../libs/MailNFePHP.class.php";
				
				//dados de configuração de envio
				$arqpdf = $nfeDir.$chave.".pdf";
				$auth = "1";
				$outro = "";
				
				$config = array(
					"mailAuth"=>"1",
					"mailFROM"=>strtolower($company->{"emp_emailremetente"}),
					"mailHOST"=>strtolower($company->{"emp_hostsmtp"}),
					"mailUSER"=>strtolower($company->{"emp_emailremetente"}),
					"mailPASS"=>$company->{"emp_pwdsmtp"},
					"mailPORT"=>"587",
					"mailPROTOCOL"=>"",
					"mailFROMmail"=>strtolower($company->{"emp_emailremetente"}),
					"mailFROMname"=>$company->{"emp_fantasia"},
					"mailREPLYTOmail"=>strtolower($company->{"emp_emailremetente"}),
					"mailREPLYTOname"=>$company->{"emp_fantasia"},
					"mailIMAPhost"=>"",
					"mailIMAPport"=>"",
					"mailIMAPsecurity"=>"",
					"mailIMAPnocerts"=>"",
					"mailIMAPbox"=>"",
					"recebidasDir"=>"",
					"temporariasDir"=>"",
					"canceladasDir"=>"",
					"CNPJ"=>$company->{"emp_cpfcnpj"},
					"mailLayoutFile"=>""
				);

				$email = new MailNFePHP($config);
				
				$msg = nl2br(utf8_encode(base64_decode($_REQUEST["msg"])));
				
				$to = base64_decode($_REQUEST["email"]);
				$to = str_replace(" ", "", $to);
				if(strstr($to, ";")) $to = explode(";", $to);
				elseif(strstr($to, ",")) $to = explode(",", $to);

				$cliente = $nota[0]->{"cad_nomeraz"};
				$assunto = utf8_decode("Envio de NF-e N: ".$nota[0]->{"not_numero"}." - série: ".$nota[0]->{"ser_codigo"});
				$arqxml = $nomeArquivo;

				//mensagem (corpo do e-mail)
				if ($msg == '') {

					if( $company->{"emp_msgnfe"} && strlen($company->{"emp_msgnfe"})>30 ){
						$msg = base64_decode($company->{"emp_msgnfe"});
					}else{
						$msg = "<p><b>Prezado Sr(a) {cliente},</b></p>";
						$msg .= "<p>Você está recebendo a Nota Fiscal Eletrônica número {numero}, série {serie} de";
						$msg .= " {emitente}, no valor de R$ {valor}. Junto com a mercadoria, você receberá também um DANFE";
						$msg .= " (Documento Auxiliar da Nota Fiscal Eletrônica), que acompanha o trânsito das";
						$msg .= " mercadorias.</p>";
						$msg .= "<p><i>Podemos conceituar a Nota Fiscal Eletrônica como um documento de existência apenas";
						$msg .= " digital, emitido e armazenado eletronicamente, com o intuito de documentar, para fins";
						$msg .= " fiscais, uma operação de circulação de mercadorias, ocorrida entre as partes.";
						$msg .= " Sua validade jurídica garantida pela assinatura digital do remetente (garantia de autoria";
						$msg .= " e de integridade) e recepção, pelo Fisco, do documento eletrônico, antes da";
						$msg .= " ocorrência do Fato Gerador.</i></p>";
						$msg .= "<p><i>Os registros fiscais e contábeis devem ser feitos, a partir do próprio arquivo";
						$msg .= " da NF-e, anexo neste e-mail, ou utilizando o DANFE, que representa graficamente a Nota";
						$msg .= " Fiscal Eletrônica. A validade e autenticidade deste documento eletrônico pode ser";
						$msg .= " verificada no site nacional do projeto (www.nfe.fazenda.gov.br), através da chave de acesso";
						$msg .= " contida no DANFE.</i></p>";
						$msg .= "<p><i>Para poder utilizar os dados descritos do DANFE na escrituração da NF-e, tanto o";
						$msg .= " contribuinte destinatário, como o contribuinte emitente, terão de verificar a validade da";
						$msg .= " NF-e. Esta validade está vinculada à efetiva existência da NF-e nos arquivos da SEFAZ,";
						$msg .= " e comprovada através da emissão da Autorização de Uso.</i></p>";
						$msg .= "<p><b>O DANFE não é uma nota fiscal, nem substitui uma nota fiscal, servindo apenas";
						$msg .= " como instrumento auxiliar para consulta da NF-e no Ambiente Nacional.</b></p>";
						$msg .= "<p>Para mais detalhes sobre o projeto, consulte: ";
						$msg .= "<a href='http://www.nfe.fazenda.gov.br/portal/Default.aspx'>www.nfe.fazenda.gov.br</a></p>";
						$msg .= "<br /><p>Atenciosamente,<p>{emitente}</p>";
					}
					
				}
				//substitui os campos variáveis da mensagem html
				$valor = ($nota[0]->{"not_totalnota"}>0) ? number_format($nota[0]->{"not_totalnota"}, 2, ",", "") : "0,00";
				$msg = str_replace('{cliente}', $cliente, $msg);
				$msg = str_replace('{emitente}', $company->{"emp_razao"}, $msg);
				$msg = str_replace('{numero}', $nota[0]->{"not_numero"}, $msg);
				$msg = str_replace('{serie}', $nota[0]->{"ser_codigo"}, $msg);
				$msg = str_replace('{valor}', $valor, $msg);
				$msg = utf8_decode($msg);

				//texto puro (sem html)
				$txt = strip_tags($msg);
				
				
				if(is_array($to)){

					$msgfinal = "";
					foreach($to as $para){
						if($email->sendM($para, $cliente, $assunto, $txt, $msg, $arqxml, $arqpdf, $auth, $outro)){
							$msgfinal.= $para." - Enviado!<br>";
						}else{
							$msgfinal.= $para." - Nâo Enviado!<br>";
						}
					}
					exit($msgfinal);
					
				}else{

					if( $email->sendM($to, $cliente, $assunto, $txt, $msg, $arqxml, $arqpdf, $auth, $outro) ){
						exit("E-mail enviado com sucesso!");
					}else{
						exit("Erro ao tentar enviar e-mail, verifique as configurações de envio e tente novamente mais tarde.<br>Ação:E-mail");
					}
					
				}
				*/
				
			//acao = cancelar a NF-e
			}elseif($_REQUEST["acao"]=="cancelar"){
				
				$motivo = base64_decode($_REQUEST["motivo"]);
				
				if ($resp = $tools->cancelEvent($chave, $nota[0]->{"not_nprot"}, $motivo, $tpAmb, $modSOAP)){
					
					//atualização do XML
					copy($nomeArquivo, substr($nomeArquivo, 0, -7)."nfe2.xml" ); //copia do original (usar para impressao)
					file_put_contents($nomeArquivo, $resp["xml"]); //substituição do conteúdo original pelo protocolo de cancelamento
					
					if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas')){
						@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas',0777);
					}
					$nfeDir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas/'.$Nota->anoMes."/";
					if(!is_dir($nfeDir)){
						@mkdir($nfeDir,0777);
					}
					copy($nomeArquivo, $nfeDir.$chave.'-nfe.xml'); //copiando para a pasta canceladas (protocolo de cancelamento)
					copy(substr($nomeArquivo, 0, -7)."nfe2.xml", $nfeDir.$chave.'-nfe2.xml'); //copiando para a pasta canceladas (original)
					unlink($nomeArquivo); //excluindo
					unlink(substr($nomeArquivo, 0, -7)."nfe2.xml"); //excluindo
					
					//alterar pedido vinculado
					$filtroPed = '{"cod":"700385","params":[
						{"name":"not_codigo","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"}
					]}';
					$Datapacket->add($filtroPed);
					
					$Datapacket->open();
					
					$Datapacket->clear();
					
					//Atualização da NF-e no Banco (cancelamento)
					$dhRecbto = implode("-", array_reverse(explode("/", substr($resp["ret"]["dhRecbto"], 0, 10))));
					$dhRecbto.= substr($resp["ret"]["dhRecbto"], 10, 9);
					$filtroAtualiza = '{"cod":"700112","params":[
						{"name":"not_dtcancdesc","value":"'.$dhRecbto.'","type":"string"},
						{"name":"not_cstat","value":"'.$resp["ret"]["cStat"].'","type":"integer"},
						{"name":"not_xmotivo","value":"'.base64_encode($resp["ret"]["xMotivo"]).'","type":"string"},
						{"name":"not_nprot","value":"'.$resp["ret"]["nProt"].'","type":"integer"},
						{"name":"not_codigo","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"}
					]}';
					$Datapacket->add($filtroAtualiza);
					
					//cancelamento de doctos
					$filtroDocto = '{"cod":"700704","params":[
						{"name":"not_codigo","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"}
					]}';
					$Datapacket->add($filtroDocto);
					
					$ant="";
					//Atualização do estoque do(s) produto(s) (reposição)
					foreach($nota as $not){
						if( $not->{"itn_ordem"}!=$ant ){
							$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
							$loc_codigo = ($not->{'loc_codigo'}) ? $not->{'loc_codigo'} : "1";
							$lot_codigo = ($not->{'lot_codigo'}) ? $not->{'lot_codigo'} : "99999";
							$stk_qde = $not->{'itn_qtde'};
							$filtrostk = '{"cod":"700111","params":[
								{"name":"db","value":"'.$company->{"emp_db_comum"}.'","type":"other"},
								{"name":"emp_codigo","value":"'.$company->{"emp_codigo"}.'","type":"string"},
								{"name":"loc_codigo","value":"'.$loc_codigo.'","type":"string"},
								{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"string"},
								{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"},
								{"name":"ser_codigo","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
								{"name":"stk_data","value":"'.$dhRecbto.'","type":"string"},
								{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
								{"name":"stk_qde","value":"'.$stk_qde.'","type":"float"},
								{"name":"stk_tipo","value":"3","type":"integer"},
								{"name":"not_codigo","value":"'.$_REQUEST['not_codigo'].'","type":"string"}
							]}';
							$Datapacket->add($filtrostk);
							$ant = $not->{"itn_ordem"};
						}
					}
					
					//Atualização do log com dados do cancelamento
					$filtrolog = '{"cod":"700103","params":[
						{"name":"log_tipo","value":"2","type":"integer"},
						{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
						{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
					$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
					$filtrolog.= '{"name":"log_acao_cod","value":"5","type":"integer"},
						{"name":"log_acao_descr","value":"cancelamento","type":"string"},
						{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"log_protocolo","value":"'.$resp["ret"]["nProt"].' ","type":"string"},
						{"name":"log_ret","value":"NULL","type":"other"},
						{"name":"log_outro","value":"'.base64_encode('NF-e cancelada, motivo: \''.$motivo.'\'').'","type":"string"}
					]}';
					$Datapacket->add($filtrolog);
					
					$Datapacket->open();
					
					echo "NF-e cancelada com sucesso em: ".$resp["ret"]["dhRecbto"];
					
					exit();
					
				} else {
				
					//Atualização do log com erro na tentativa de cancelamento
					$filtrolog = '{"cod":"700103","params":[
						{"name":"log_tipo","value":"2","type":"integer"},
						{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
						{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
					$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
					$filtrolog.= '{"name":"log_acao_cod","value":"5","type":"integer"},
						{"name":"log_acao_descr","value":"cancelamento","type":"string"},
						{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"log_protocolo","value":"NULL","type":"other"},
						{"name":"log_ret","value":"NULL","type":"other"},
						{"name":"log_outro","value":"'.base64_encode("Erro no cancelamento: ".$tools->errMsg).'","type":"string"}
					]}';
					$Datapacket->add($filtrolog);
					$Datapacket->open();
				
					echo "Erro no cancelamento: ".$tools->errMsg;
					exit();
					
				}
			
			//acao = corrigir - Carta de correção da NF-e
			}elseif($_REQUEST["acao"]=="corrigir"){
				
				//Busca por eventos anteriores para pegar sequencia da Carta de Correção
				$filtrocce = '{"cod":"700113","params":[
					{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
					{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"}
				]}';
				
				$Datapacket->add($filtrocce);
				
				$res = $Datapacket->open();
				$seq = count($res);
					
				$texto = base64_decode($_REQUEST["texto"]);
				$seq = ($seq>0) ? ($seq+1) : 1;
				
				if ($resp = $tools->envCCe($chave, $texto, $seq, $tpAmb, $retorno)){
					
					$ccefile = $nfeDir.$chave.'-'.$seq.'-cce.xml';
							
					//Criar arquivo carta correção e gravar dados retornados
					$arquivoCCe = fopen($ccefile,'w+');
					fwrite($arquivoCCe, $resp["xml"]);
					fclose($arquivoCCe);
							
					//Atualização do log com dados da carta de correção
					$filtrolog = '{"cod":"700103","params":[
						{"name":"log_tipo","value":"2","type":"integer"},
						{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
						{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
					$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
					$filtrolog.= '{"name":"log_acao_cod","value":"6","type":"integer"},
						{"name":"log_acao_descr","value":"correção","type":"string"},
						{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"log_protocolo","value":"'.$resp["retEvento"]["infEvento"]["nProt"].' ","type":"string"},
						{"name":"log_ret","value":"NULL","type":"other"},
						{"name":"log_outro","value":"'.base64_encode('Carta de correção: \''.$texto.'\'').'","type":"string"}
					]}';
					
					$Datapacket->add($filtrolog);
					
					$Datapacket->open();
					
					echo 'Carta de correção enviada com sucesso em: '.date("d/m/Y H:i:s h", strtotime($resp["retEvento"]["infEvento"]["dhRegEvento"]));
					
					exit();
					
				} else {
				
					//Atualização do log com erro de envio de carta de correção
					$filtrolog = '{"cod":"700103","params":[
						{"name":"log_tipo","value":"2","type":"integer"},
						{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
						{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
					$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
					$filtrolog.= '{"name":"log_acao_cod","value":"6","type":"integer"},
						{"name":"log_acao_descr","value":"correção","type":"string"},
						{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"log_protocolo","value":"NULL","type":"other"},
						{"name":"log_ret","value":"NULL","type":"other"},
						{"name":"log_outro","value":"'.base64_encode("Erro no envio da Carta de Correção: ".$tools->errMsg).'","type":"string"}
					]}';
					$Datapacket->add($filtrolog);
					$Datapacket->open();
				
					echo "Erro no envio da Carta de Correção: ".$tools->errMsg;
					exit();
					
				}
				
			}elseif($_REQUEST["acao"]=="consultar"){
				
				$chave = ( isset($nota[0]->{'not_key_nfe'}) && $nota[0]->{'not_key_nfe'}!="" ) ? $nota[0]->{'not_key_nfe'} : $chave;
				
				if ($prot = $tools->getProtocol("", $chave, $tpAmb, $retorno)){

					$dhRecbto = implode("-", array_reverse(explode("/", substr($retorno["aProt"]["dhRecbto"], 0, 10))));
					$dhRecbto.= substr($retorno["aProt"]["dhRecbto"], 10, 9);

					if( $retorno["cStat"]=="100" ){
						
						$protfile 	= $nfeDir.$chave.'-prot.xml';
						//Criar arquivo protocolo
						$arquivoProt = fopen($protfile,'w+');
						fwrite($arquivoProt, $prot);
						fclose($arquivoProt);
						
						//Adicionar Protocolo ao XML da NF-e
						if ($xml = $tools->addProt($nomeArquivo, $protfile)){
							file_put_contents($nomeArquivo, $xml);
						}
						
						if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas')){
							@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas',0777);
						}
						$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas/'.$Nota->anoMes.'/';
						if(!is_dir($dir)){
							@mkdir($dir,0777);
						}
						
						copy($nomeArquivo, $dir.$chave.'-nfe.xml');
						copy($protfile, $dir.$chave.'-prot.xml');
						unlink($nomeArquivo);
						unlink($protfile);
						
						$docxml = file_get_contents($dir.$chave.'-nfe.xml');
						
						$ant="";
						//Atualização do estoque do(s) produto(s) (caso ainda não esteja atualizado)
						if( !$nota[0]->{'not_stokatualiz'} || $nota[0]->{'not_stokatualiz'}==0 ){
							foreach($nota as $not){
								if( $not->{"itn_ordem"}!=$ant ){
									$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
									$loc_codigo = ($not->{'loc_codigo'}) ? $not->{'loc_codigo'} : "1";
									$lot_codigo = ($not->{'lot_codigo'}) ? $not->{'lot_codigo'} : "99999";
									$stk_qde = ($nota[0]->{'not_entrsaida'}==2) ? '-'.$not->{'itn_qtde'} : $not->{'itn_qtde'};
									$filtrostk = '{"cod":"700111","params":[
										{"name":"db","value":"'.$company->{"emp_db_comum"}.'","type":"other"},
										{"name":"emp_codigo","value":"'.$company->{"emp_codigo"}.'","type":"string"},
										{"name":"loc_codigo","value":"'.$loc_codigo.'","type":"string"},
										{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"string"},
										{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"},
										{"name":"ser_codigo","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
										{"name":"stk_data","value":"'.$dhRecbto.'","type":"string"},
										{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
										{"name":"stk_qde","value":"'.$stk_qde.'","type":"float"},
										{"name":"stk_tipo","value":"'.$nota[0]->{'not_entrsaida'}.'","type":"integer"},
										{"name":"not_codigo","value":"'.$_REQUEST['not_codigo'].'","type":"string"}
									]}';
									$Datapacket->add($filtrostk);
									$ant = $not->{"itn_ordem"};
								}
							}
						}
						
						//Atualizar os dados de retorno da NF-e no banco de dados (autorizada)
						$filtroAtualiza = '{"cod":"700105","params":[
							{"name":"not_status","value":"2","type":"integer"},
							{"name":"not_dtfaturam","value":"'.$dhRecbto.'","type":"string"},
							{"name":"not_dtprevisao","value":"'.$dhRecbto.'","type":"string"},
							{"name":"not_dtentrega","value":"'.$dhRecbto.'","type":"string"},
							{"name":"not_finanatualiz","value":"1","type":"integer"},
							{"name":"not_stokatualiz","value":"1","type":"integer"},
							{"name":"not_custoautaliz","value":"1","type":"integer"},
							{"name":"not_key_nfe","value":"'.$retorno["chNFe"].'","type":"string"},
							{"name":"not_result","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
							{"name":"not_cstat","value":"'.$retorno['cStat'].'","type":"string"},
							{"name":"not_xmotivo","value":"'.base64_encode($retorno['xMotivo']).'","type":"string"},
							{"name":"not_aliq","value":"'.$itn_aliqicms.'","type":"string"},
							{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
							{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},';

						if($retorno["aProt"]["nProt"]){
							$filtroAtualiza .= '{"name":"not_nprot","value":"'.$retorno["aProt"]["nProt"].'","type":"string"}';
						}else{
							$filtroAtualiza .= '{"name":"not_nprot","value":"","type":"null"}';
						}

						$filtroAtualiza.=']}';
						
						$Datapacket->add($filtroAtualiza);
						
						//Atualização do Log da NF-e com os dados transmitidos
						$filtrolog = '{"cod":"700103","params":[
							{"name":"log_tipo","value":"2","type":"integer"},
							{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
							{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
						$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
						$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
							{"name":"log_acao_descr","value":"transmissão","type":"string"},
							{"name":"log_data","value":"'.$dhRecbto.'","type":"string"},
							{"name":"log_protocolo","value":"'.$retorno["aProt"]["nProt"].'","type":"string"},
							{"name":"log_ret","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
							{"name":"log_outro","value":"'.base64_encode("NF-e transmitida com sucesso!").'","type":"string"}
						]}';
						$Datapacket->add($filtrolog);
						
						$Datapacket->open(true);
						
						//print_r($Datapacket->getLastQuery());
						
						//DANFE
						$logo = "http://".$_SERVER['SERVER_NAME']."/uploads/".$_REQUEST["emp_codigo"]."/".$company->{"emp_logo"};

						if(isset($_REQUEST['calcNcm'])){
							$calcNcm = $_REQUEST['calcNcm'];
						}else{
							$calcNcm = 0;
						}
						if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ){
							if(isset($company->{"emp_logo"}) && !empty($company->{"emp_logo"})){
								$danfe = new DanfeNFCeNFePHP($docxmll, $logo, 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
							}else{
								$danfe = new DanfeNFCeNFePHP($docxmll, '', 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
							}
							$id = $danfe->montaDANFE(false, $calcNcm);
							$danfe->printDANFE('html', $dir.$chave.'.html', 'F',$Nota->anoMes);
						}else{
							$danfe = new DanfeNFePHP($docxml, 'C', 'A4', $logo, 'F', $dir,$company);
							$id = $danfe->montaDANFE();
							$danfe->printDANFE($dir.$chave.'.pdf', 'F',$Nota->anoMes);
						}
						
					}
				}
				
			}
				
			
		}
	}

	/*
	if ($resp) {
		header('Content-type: text/xml; charset=UTF-8');
		echo $nfe->getXML();
	} else {
		header('Content-type: text/html; charset=UTF-8');
		foreach ($nfe->erros as $err) {
			echo 'tag: &lt;'.$err['tag'].'&gt; ---- '.$err['desc'].'<br>';
		}
	}
	*/
	
?>