<?php
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	
	include 'TParams.class.php';
	include 'funcoes.php';
	$datapacket = new TParams();
	
	if(!isset($_REQUEST['query'])) $_REQUEST['query']="";
	if(!isset($_REQUEST['start']) || $_REQUEST['start'] < 0) $_REQUEST['start']=0;
	if(!isset($_REQUEST['limit'])) $_REQUEST['limit']=25;
	
	if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="ncm"){ //buscar os valores para calculo da tributação referente ao ncm do produto
		
		
		$ref_codigo = (isset($_REQUEST['ref_codigo']) && !empty($_REQUEST['ref_codigo'])) ? $_REQUEST['ref_codigo'] : ""; 
		$estado = (isset($datapacket->getCompany()->{"emp_uf"}) && !empty($datapacket->getCompany()->{"emp_uf"})) ? strtolower($datapacket->getCompany()->{"emp_uf"}) : "pr";
		
		try {
			
			$filtro = '{"cod":"701180","params":[
				{"name":"ref_codigo","value":"'.$_REQUEST["ref_codigo"].'","type":"integer"},
				{"name":"estado","value":"'.$estado.'","type":"other"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
			$datapacket->add($filtro);
			$ret = $datapacket->open(true);
			// echo $datapacket->getLastQuery();
			$datapacket->clear();
			print_r(json_encode($ret));
			exit();

		} catch(exception $e) {

			exit(json_encode(array()));
		}
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="status"){ //alterar status
		
		$filtro = '{"cod":"700477","params":[
			{"name":"ref_codigo","value":"'.$_REQUEST['ref_codigo'].'","type":"integer"},
			{"name":"ref_status","value":"'.$_REQUEST['ref_status'].'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$datapacket->open();
		$datapacket->clear();
		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="selecionar"){ //buscar um produto pelo seu ref_codigo (tela de produtos)
		
		$filtro = '{"cod":"700460","params":[
			{"name":"database","value":"'.$datapacket->getDbSge().'","type":"other"},
			{"name":"ref_codigo","value":"'.$_REQUEST['ref_codigo'].'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		print_r(json_encode($ret));
		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="encontrar"){ //buscar um produto pelo seu ref_codigo (tela de notas e pedidos)
		
		$company = $datapacket->getCompany();
		
		$arr = json_decode($_REQUEST["ref_codigo"]);
		$codigos="";
		if(is_array($arr)){
			foreach($arr as $cod) $codigos.="'".$cod."',";
			$codigos = substr($codigos, 0, -1);
		}else{
			$codigos = "'".$_REQUEST["ref_codigo"]."'";
		}
		
		$filtro = '{"cod":"700164","params":[
			{"name":"emp_codigo","value":"'.$datapacket->getCodigo().'","type":"string"},
			{"name":"db","value":"'.$datapacket->getDbSge().'","type":"other"},
			{"name":"ref_codigo","value":"'.$codigos.'","type":"other"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		$i=0;
		foreach($ret as $r){
			$ret[$i]["referencia"] = ($company->{"emp_referencia"}==2 && $r["ref_propriedade"] && $r["ref_propriedade"]!="") ? $r["ref_propriedade"] : $r["ref_codigo"];
			$i++;
		}
		print_r(json_encode($ret));
		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="referencia"){ //verificar duplicidade de codigos de referencia
		
		if(!isset($_REQUEST['ref_codigo']) || $_REQUEST['ref_codigo']=="") $_REQUEST['ref_codigo']=-1;
		$filtro = '{"cod":"700219","params":[
			{"name":"ref_propriedade","value":"'.$_REQUEST['ref_propriedade'].'","type":"string"},
			{"name":"ref_codigo","value":"'.$_REQUEST['ref_codigo'].'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		if($ret && $ret[0] && $ret[0]["ref_codigo"]){
			exit("ok");
		}
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="precos"){ //de Alteração Múltipla de preços
		
		if( isset($_POST["operacao"]) ){
			// print_r($_POST);
			if(isset($_POST["linhas"])) $linhas = json_decode($_POST["linhas"]);
			// print_r($linhas);
			$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
			
			for($i = 0; $i<count($linhas); $i++){
				if($linhas[$i]){
					$urf_preco =" ";
					$urf_preco.= ($linhas[$i]->{"urf_precoata2"}) ? "urf_precoata = ".$linhas[$i]->{"urf_precoata2"}."," : "";
					$urf_preco.= ($linhas[$i]->{"urf_precovar2"}) ? "urf_precovar = ".$linhas[$i]->{"urf_precovar2"}."," : "";
					$urf_preco.= ($linhas[$i]->{"urf_precomin2"}) ? "urf_precomin = ".$linhas[$i]->{"urf_precomin2"}."," : "";
					$urf_preco = substr($urf_preco, 0, -1);
					
					$filtro = '{"cod":"700168","params":[
						{"name":"urf_preco","value":"'.$urf_preco.'","type":"other"},
						{"name":"uni_codigo","value":"'.$linhas[$i]->{"uni_codigo"}.'","type":"string"},
						{"name":"ref_codigo","value":"'.$linhas[$i]->{"ref_codigo"}.'","type":"integer"}
					]}';
					
					$datapacket->add($filtro);
					$datapacket->open();
					$datapacket->clear();
					
					if($linhas[$i]->{"urf_precovar2"} && $linhas[$i]->{"urf_precovar2"}>0){
						$ref_precomin = ($linhas[$i]->{"urf_precomin2"} && $linhas[$i]->{"urf_precomin2"}< $linhas[$i]->{"urf_precovar2"}) ? $linhas[$i]->{"urf_precomin2"} : $linhas[$i]->{"urf_precovar2"};
						$filtro = '{"cod":"700169","params":[
							{"name":"ref_preco","value":"'.$linhas[$i]->{"urf_precovar2"}.'","type":"float"},
							{"name":"ref_precomin","value":"'.$ref_precomin.'","type":"float"},
							{"name":"uni_codigo","value":"'.$linhas[$i]->{"uni_codigo"}.'","type":"string"},
							{"name":"ref_codigo","value":"'.$linhas[$i]->{"ref_codigo"}.'","type":"integer"}
						]}';
						$datapacket->add($filtro);
						$datapacket->open();
						$datapacket->clear();
					}
				}
			}

			exit("ok");

		}else{
			
			if(!isset($_REQUEST['limit'])) $_REQUEST['limit']=50;
			
			$busca = "";
			
			if( isset($_REQUEST["ref_descr"]) && $_REQUEST["ref_descr"] ){
				$busca.= " and r.ref_descr like '%".$_REQUEST["ref_descr"]."%' ";
			}
			if( isset($_REQUEST["ref_propriedade"]) && $_REQUEST["ref_propriedade"] ){
				$busca.= " and r.ref_propriedade like '".$_REQUEST["ref_propriedade"]."%' ";
			}
			if( isset($_REQUEST["mar_codigo"]) && $_REQUEST["mar_codigo"]!="" ){
				$busca.= " and  r.mar_codigo='".$_REQUEST["mar_codigo"]."' ";
			}
			if( isset($_REQUEST["ref_tipo"]) && $_REQUEST["ref_tipo"]!="" ){
				$busca.= " and  r.ref_tipo='".$_REQUEST["ref_tipo"]."' ";
			}
			if( isset($_REQUEST["ref_codbar"]) && $_REQUEST["ref_codbar"]!="" ){
				$busca.= " and  r.ref_codbar like '".$_REQUEST["ref_codbar"]."%' ";
			}
			if( isset($_REQUEST["agr_codigo"]) && $_REQUEST["agr_codigo"]!="" ){
				$busca.= " and  r.agr_codigo = '".$_REQUEST["agr_codigo"]."' ";
			}
			if( isset($_REQUEST["grp_codigo"]) && $_REQUEST["grp_codigo"]!="" ){
				$busca.= " and  r.grp_codigo = '".$_REQUEST["grp_codigo"]."' ";
			}
			if( isset($_REQUEST["sgp_codigo"]) && $_REQUEST["sgp_codigo"]!="" ){
				$busca.= " and  r.sgp_codigo = '".$_REQUEST["sgp_codigo"]."' ";
			}
			
			if( isset($_REQUEST["cad_codigo"]) && $_REQUEST["cad_codigo"]!="" ){
				$filtro = '{"cod":"700189","params":[
					{"name":"busca","value":"'.$busca.'","type":"other"},
					{"name":"cad_codigo","value":"'.$_REQUEST["cad_codigo"].'","type":"string"},
					{"name":"start","value":"'.$_REQUEST["start"].'","type":"integer"},
					{"name":"limit","value":"'.$_REQUEST["limit"].'","type":"integer"}
				]}';
			}else{
				$filtro = '{"cod":"700166","params":[
					{"name":"busca","value":"'.$busca.'","type":"other"},
					{"name":"start","value":"'.$_REQUEST["start"].'","type":"integer"},
					{"name":"limit","value":"'.$_REQUEST["limit"].'","type":"integer"}
				]}';
			}

			$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
			$datapacket->add($filtro);
			$ret = $datapacket->open();
			$datapacket->clear();

			$filtro=json_decode($filtro);
			if( isset($_REQUEST["cad_codigo"]) && $_REQUEST["cad_codigo"]!="" ){
				$filtro->cod='700198';
			}else{
				$filtro->cod='700167';
			}
			$datapacket->add(json_encode($filtro));
			$count = $datapacket->open(true);
			$total = $count[0]->total;
			$datapacket->clear();

			$obj = new StdClass();
			$obj->total=$total;
			$obj->data=$ret;

			print_r(json_encode($obj));	
		}

		exit();

	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="produtoCorrespondente"){
		
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		
		$filtro = '{"cod":"700516","params":[
			{"name":"ref_codigo","value":"'.$_REQUEST['ref_codigo'].'","type":"integer"},
			{"name":"cad_codigo","value":"'.$_REQUEST['cad_codigo'].'","type":"string"}
		]}';
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		
		if( $ret[0]["total"]==0 ){
			$filtro = '{"cod":"600143","params":[
				{"name":"cad_codigo","value":"'.$_REQUEST['cad_codigo'].'","type":"string"},
				{"name":"ref_codigo","value":"'.$_REQUEST['ref_codigo'].'","type":"string"},
				{"name":"ref_codigo_forn","value":"'.$_REQUEST['ref_codigo_forn'].'","type":"string"}
			]}';
			$datapacket->add($filtro);
			$datapacket->open();
			$datapacket->clear();
		}
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="fornecedor"){ 

		if(!empty($_POST['codigo'])&&isset($_POST['codigo'])){ $codigo = $_POST['codigo'];}else{ $codigo="";};

		$filtro = '{"cod":"700505","params":[
			{"name":"codigo","value":"'.$codigo.'","type":"other"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		print_r(json_encode($ret));
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="codFornecedor"){ 

		if(!empty($_POST['ref_codigo'])&&isset($_POST['ref_codigo'])){ $ref_codigo = $_POST['ref_codigo'];}else{ $ref_codigo="";}
		if(!empty($_POST['cad_codigo'])&&isset($_POST['cad_codigo'])){ $cad_codigo = $_POST['cad_codigo'];}else{ $cad_codigo="";}

		$filtro = '{"cod":"700515","params":[
			{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
			{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		print_r(json_encode($ret));
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="verificaCodBar"){ 

		if(!empty($_POST['codBar'])&&isset($_POST['codBar'])){ $codBar = $_POST['codBar'];}else{ $codBar="";};
		if(!empty($_POST['codigo'])&&isset($_POST['codigo'])){ $codigo = " and ref_codigo = ".$_POST['codigo'];}else{ $codigo="";};

		$filtro = '{"cod":"700497","params":[
			{"name":"codBar","value":"'.$codBar.'","type":"string"},
			{"name":"codigo","value":"'.$codigo.'","type":"string"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		
		if(count($ret) > 0 && empty($codigo)){
			echo "NO";
		}else if(count($ret) > 1 && !empty($codigo)){
			echo "NO";
		}else{
			echo "OK";
		}

		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="verificaRepetidos"){ 

		if($_REQUEST['param'] == "base"){
		
		if(!empty($_POST['codigo'])&&isset($_POST['codigo']))	{ $codigo 	= "and ref_codbase =".$_POST['codigo'];}	else{ $codigo="";};
		
		if(!empty($_POST['descricao'])&&isset($_POST['descricao']))	{ $descricao 	= $_POST['descricao'];}	else{ $descricao="";};
			$parametros = "where ref_descr = '".$descricao."' ".$codigo;
		}else{
			if(!empty($_POST['codBar'])&&isset($_POST['codBar'])){ $codBar = "and codBar_codigo = ".$_POST['codBar'];}else{ $codBar="";};
			$parametros = "where ref_codbar = ".$codBar;
		}

		$filtro = '{"cod":"700465","params":[
			{"name":"parametros","value":"'.$parametros.'","type":"other"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		
		if(count($ret) > 0 ){
			echo "NO";
		}else{
			echo "OK";
		}

		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="verificaDeletar"){ 

		if(!empty($_POST['descricao'])&&isset($_POST['descricao'])){ $descricao = $_POST['descricao'];}else{ $descricao="";};

		$referencia = "where ref_descr = '".$descricao."'";

		$filtro = '{"cod":"700467","params":[
			{"name":"referencia","value":"'.$referencia.'","type":"other"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		print_r(json_encode($ret));

		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="storeHistorico"){ 

		if(isset($_REQUEST['param']) && !empty($_REQUEST['param']) && $_REQUEST['param'] == "listar" && !empty($_POST['codigo'])){
			$filtro = '{"cod":"700364","params":[
				{"name":"historico","value":"where ref_codigo = '.$_POST['codigo'].'","type":"other"}
			]}';
		}else{
			$filtro = '{"cod":"700364","params":[
				{"name":"historico","value":"","type":"other"}
			]}';
		}
		$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		print_r(json_encode($ret));

		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="storeFornecedor"){ 

		$filtro = '{"cod":"700361","params":[
			{"name":"fornecedor","value":"where cad_tipo in (2,3) and cad_nomeraz LIKE \"%'.$_REQUEST['query'].'%\" OR cad_tipo in (2,3) and cad_codigo LIKE \"%'.$_REQUEST['query'].'%\"","type":"other"},
			{"name":"start","value":"'.$_REQUEST['start'].'","type":"integer"},
			{"name":"limit","value":"'.$_REQUEST['limit'].'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();

		$vazio = new StdClass();
		$vazio->cad_codigo = "Novo Registro";
		$vazio->cad_nomeraz = "";
		array_unshift($ret,$vazio);

		$filtro=json_decode($filtro);
		$filtro->cod='700750';
		$datapacket->add(json_encode($filtro));
		$count = $datapacket->open(true);
		$total = $count[0]->total;
		$datapacket->clear();

		$obj = new StdClass();
		$obj->total=$total;
		$obj->data=$ret;

		print_r(json_encode($obj));

		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="storeDesconto"){ 

		$aux = array();
		for($i=0;$i<100;$i++){
			$aux[$i] = array(
				'codigo' => $i+1,
				'value' => ($i+1)."%"
			);
		}
		$total = 1;

		$obj = new StdClass();
		$obj->total=$total;
		$obj->data=$aux;

		print_r(json_encode($obj));

		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="storeCodFornecedor"){ 

		$filtro = '{"cod":"700365","params":[
			{"name":"referencia","value":"where ref_codigo_forn LIKE \"'.$_REQUEST['query'].'%\"","type":"other"},
			{"name":"start","value":"'.$_REQUEST['start'].'","type":"integer"},
			{"name":"limit","value":"'.$_REQUEST['limit'].'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		print_r(json_encode($ret));

		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="deletar"){ 

		if(!empty($_REQUEST['codigo'])&&isset($_REQUEST['codigo'])){ $codigo = $_REQUEST['codigo']; }else{ $codigo=""; };
	
		$filtro = '{"cod":"700475","params":[
			{"name":"ref_codigo","value":"'.$codigo.'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
		$datapacket->add($filtro);
		$item = $datapacket->open();
		$datapacket->clear();
		
		//caso existam nota/pedidos com o produto proceder para inativação
		if( count($item)>0 ){
			
			if( isset($_REQUEST["param"]) && $_REQUEST["param"]=="inativar"){
				$filtro = '{"cod":"700476","params":[
					{"name":"ref_status","value":"1","type":"integer"},
					{"name":"ref_codigo","value":"'.$codigo.'","type":"integer"}
				]}';
				$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
				$datapacket->add($filtro);
				$item = $datapacket->open();
				$datapacket->clear();
				echo "ok";
			}elseif( isset($_REQUEST["param"]) && $_REQUEST["param"]=="ativar" ){
				$filtro = '{"cod":"700476","params":[
					{"name":"ref_status","value":"0","type":"integer"},
					{"name":"ref_codigo","value":"'.$codigo.'","type":"integer"}
				]}';
				$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
				$datapacket->add($filtro);
				$item = $datapacket->open();
				$datapacket->clear();
				echo "ok";
			}else{
				echo "no";
			}
		
		//caso não hajam vínculos excluir dados do produto
		}else{
			
			$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
			//produto
			$filtro = '{"cod":"700464","params":[
				{"name":"codigo","value":"'.$codigo.'","type":"integer"}
			]}';
			$datapacket->add($filtro);
			$ret = $datapacket->open();
			$datapacket->clear();
			// print_r(json_encode($ret));echo "<br>";
			
			//unidade_referencia
			$filtro = '{"cod":"700463","params":[
				{"name":"ref_codigo","value":"'.$codigo.'","type":"integer"}
			]}';
			$datapacket->add($filtro);
			$res = $datapacket->open();
			$datapacket->clear();
			// print_r(json_encode($res));echo "<br>";
			
			//fornecedor (correspondente)
			$filtro = '{"cod":"700495","params":[
				{"name":"codigo","value":"'.$codigo.'","type":"integer"}
			]}';
			$datapacket->add($filtro);
			$res = $datapacket->open();
			$datapacket->clear();
			// print_r(json_encode($res));echo "<br>";
			
			//estoque
			$filtro = '{"cod":"700503","params":[
				{"name":"codigo","value":"'.$codigo.'","type":"integer"}
			]}';
			$datapacket->add($filtro);
			$res = $datapacket->open();
			$datapacket->clear();
			// print_r(json_encode($res));echo "<br>";
			
			$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
			
			//custo
			$filtro = '{"cod":"700504","params":[
				{"name":"codigo","value":"'.$codigo.'","type":"integer"}
			]}';
			$datapacket->add($filtro);
			$res = $datapacket->open();
			$datapacket->clear();
			// print_r(json_encode($res));echo "<br>";
			
			echo "ok";
		}

		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="deletarObs"){ 

		if(isset($_POST['codigo'])&&!empty($_POST['codigo'])){$codigo=$_POST['codigo'];}else{$codigo="";};

		$filtro = '{"cod":"700468","params":[
			{"name":"codigo","value":"'.$codigo.'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		print_r(json_encode($ret));
		
		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="deletarBase"){ 

		if(!empty($_POST['codigo'])&&isset($_POST['codigo'])){ $codigo = $_POST['codigo'];}else{ $codigo="";};

		$filtro = '{"cod":"700464","params":[
			{"name":"codigo","value":"'.$codigo.'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		//print_r(json_encode($ret));

		$filtroDelete = '{"cod":"700463","params":[
			{"name":"codigo","value":"'.$codigo.'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtroDelete);
		$res = $datapacket->open();
		$datapacket->clear();
		//print_r(json_encode($res));

		$filtroDeleteOutro = '{"cod":"700495","params":[
			{"name":"codigo","value":"'.$codigo.'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtroDeleteOutro);
		$res = $datapacket->open();
		$datapacket->clear();
		//print_r(json_encode($res));

		$filtroDeleteStk = '{"cod":"700504","params":[
			{"name":"codigo","value":"'.$codigo.'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtroDeleteStk);
		$res = $datapacket->open();
		$datapacket->clear();
		//print_r(json_encode($res));

		$filtroDeleteStk = '{"cod":"700503","params":[
			{"name":"codigo","value":"'.$codigo.'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtroDeleteStk);
		$res = $datapacket->open();
		$datapacket->clear();
		//print_r(json_encode($res));

		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="salvarHistorico"){ 

		$data = date('Y-m-d H:i:s');
	
		if(!empty($_POST['codigo']) 	&& isset($_POST['codigo'])		&& $_POST['codigo'] != "Novo Registro"	){$codigo 		= $_POST['codigo'];			}else{	$codigo 		= "";}
		if(!empty($_POST['referencia']) && isset($_POST['referencia'])	&& $_POST['referencia'] != "Novo Registro"){$referencia 	= $_POST['referencia'];		}else{	$referencia 	= "";}
		if(!empty($_POST['referencia2'])&& isset($_POST['referencia2'])	&& $_POST['referencia2'] != "Novo Registro"){$referencia2 	= $_POST['referencia2'];	}else{	$referencia2	= "";}
		if(!empty($_POST['usuario']) 	&& isset($_POST['usuario'])		&& $_POST['usuario'] != "Novo Registro"	){$usuario 		= $_POST['usuario'];		}else{	$usuario 		= "";}

		if($_REQUEST['param'] == 'adicionar'){
			$descr = "Adicionado produto: ".$referencia.", marca: ".$referencia2;
		}
		if($_REQUEST['param'] == 'alterar'){
			$descr = "Alterado produto: ".$referencia.", marca: ".$referencia2;
		}
		if($_REQUEST['param'] == 'deletar'){
			$descr = "Deletado produto: ".$referencia.", marca: ".$referencia2;
		}
		if($_REQUEST['param'] == 'adicionarBase'){
			$descr = "Adicionado base do produto: ".$referencia.", marca: ".$referencia2;
		}
		if($_REQUEST['param'] == 'deletarObs'){
			$descr = "Removida alterações do produto: ".$referencia.", marca: ".$referencia2;
		}
		
		$filtro = '{"cod":"700461","params":[
			{"name":"codigo","value":"'.$codigo.'","type":"integer"},
			{"name":"data","value":"'.$data.'","type":"string"},
			{"name":"descr","value":"'.$descr.'","type":"string"},
			{"name":"usuario","value":"'.$usuario.'","type":"string"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();
		print_r(json_encode($ret));
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="salvarBase"){

		$refReduz = "";
		$setCodigo = "";
		$status = 0;

		//params dos produtos
			//produtos gerais
				if(!empty($_POST['codigo'])&&isset($_POST['codigo'])){ $codigo = $_POST['codigo'];}else{ $codigo="";};
				if(!empty($_POST['descrBase'])&&isset($_POST['descrBase'])){ $descricao = $_POST['descrBase'];}else{ $descricao="";};
				if(!empty($descricao)){ $refReduz = substr($descricao,0,25);}else{ $refReduz="";};
				if(!empty($_POST['fabricante'])&&isset($_POST['fabricante'])){ $fabricante = $_POST['fabricante'];}else{ $fabricante="";};
				if(!empty($_POST['marca'])&&isset($_POST['marca']) && $_POST['marca'] != "Novo Registro"){ $marca = $_POST['marca'];}else{ $marca="";};
				$tipo="0";
				if(!empty($_POST['codBarBase'])&&isset($_POST['codBarBase'])){ $codBar = $_POST['codBarBase'];}else if(!empty($_POST['codBar'])&&isset($_POST['codBar'])){$codBar = $_POST['codBar'];}else{ $codBar="";};
				if(!empty($_POST['agrupamento'])&&isset($_POST['agrupamento'])&&$_POST['agrupamento']!="Novo Registro"){ $agrupamento = $_POST['agrupamento'];}else{ $agrupamento="";};
				if(!empty($_POST['estante'])&&isset($_POST['estante'])){ $estante = $_POST['estante'];}else{ $estante="";};
				if(!empty($_POST['prateleira'])&&isset($_POST['prateleira'])){ $prateleira = $_POST['prateleira'];}else{ $prateleira="";};
				if(!empty($_POST['unidadeMedidaEntrada'])&&isset($_POST['unidadeMedidaEntrada'])&&$_POST['unidadeMedidaEntrada']!="Novo Registro"){ $unidadeMedidaEntrada = $_POST['unidadeMedidaEntrada'];}else{ $unidadeMedidaEntrada="";};
				if(!empty($_POST['unidadeMedidaTributavel'])&&isset($_POST['unidadeMedidaTributavel'])&&$_POST['unidadeMedidaTributavel']!="Novo Registro"){ $unidadeMedidaTributavel = $_POST['unidadeMedidaTributavel'];}else{ $unidadeMedidaTributavel="";};
				if(!empty($_POST['unidadeMedidaSaida'])&&isset($_POST['unidadeMedidaSaida'])&&$_POST['unidadeMedidaSaida']!="Novo Registro"){ $unidadeMedidaSaida = $_POST['unidadeMedidaSaida'];}else{ $unidadeMedidaSaida="";};
				if(!empty($_POST['unidadeMedidaSaidaoutra'])&&isset($_POST['unidadeMedidaSaidaoutra'])&&$_POST['unidadeMedidaSaidaoutra']!="Novo Registro"){ $unidadeMedidaSaidaoutra = $_POST['unidadeMedidaSaidaoutra'];}else{ $unidadeMedidaSaidaoutra="";};
			//**************
			//financeiro
				//valores
				if(!empty($_POST['custoMedio'])&&isset($_POST['custoMedio'])){ $custoMedio = $_POST['custoMedio'];}else{ $custoMedio="";};
				if(!empty($_POST['custoVenda'])&&isset($_POST['custoVenda'])){ $custoVenda = $_POST['custoVenda'];}else{ $custoVenda="";};
				if(!empty($_POST['custoReposicao'])&&isset($_POST['custoReposicao'])){ $custoReposicao = $_POST['custoReposicao'];}else{ $custoReposicao="";};
				if(!empty($_POST['custoPcp'])&&isset($_POST['custoPcp'])){ $custoPcp = $_POST['custoPcp'];}else{ $custoPcp="";};
				if(!empty($_POST['anp'])&&isset($_POST['anp'])){ $anp = $_POST['anp'];}else{ $anp="";};
				//venda
				if(!empty($_POST['vendaAtacado'])&&isset($_POST['vendaAtacado'])){ $vendaAtacado = $_POST['vendaAtacado'];}else{ $vendaAtacado="";};
				if(!empty($_POST['vendaVarejo'])&&isset($_POST['vendaVarejo'])){ $vendaVarejo = $_POST['vendaVarejo'];}else{ $vendaVarejo="";};
				//unidade de medida
				if(!empty($_POST['umAtacado'])&&isset($_POST['umAtacado'])){ $umAtacado = $_POST['umAtacado'];}else{ $umAtacado=0;};
				if(!empty($_POST['umVarejo'])&&isset($_POST['umVarejo'])){ $umVarejo = $_POST['umVarejo'];}else{ $umVarejo=0;};
				if(!empty($_POST['umPrecoMinimo'])&&isset($_POST['umPrecoMinimo'])){ $umPrecoMinimo = $_POST['umPrecoMinimo'];}else{ $umPrecoMinimo=0;};
				if(!empty($_POST['umAtacadoOutro'])&&isset($_POST['umAtacadoOutro'])){ $umAtacadoOutro = $_POST['umAtacadoOutro'];}else{ $umAtacadoOutro=0;};
				if(!empty($_POST['umVarejoOutro'])&&isset($_POST['umVarejoOutro'])){ $umVarejoOutro = $_POST['umVarejoOutro'];}else{ $umVarejoOutro=0;};
				if(!empty($_POST['umPrecoMinimoOutro'])&&isset($_POST['umPrecoMinimoOutro'])){ $umPrecoMinimoOutro = $_POST['umPrecoMinimoOutro'];}else{ $umPrecoMinimoOutro=0;};
				//tributacao
				if(!empty($_POST['tributacao'])&&isset($_POST['tributacao'])&&$_POST['tributacao']!="Novo Registro"){ $tributacao = $_POST['tributacao'];}else{ $tributacao=1;};
				if(!empty($_POST['ipi'])&&isset($_POST['ipi'])){ $ipi = $_POST['ipi'];}else{ $ipi="";};
				if(!empty($_POST['icms'])&&isset($_POST['icms'])){ $icms = $_POST['icms'];}else{ $icms="";};
				if(!empty($_POST['ncm'])&&isset($_POST['ncm'])&&$_POST['ncm']!="Novo Registro"){ $ncm = $_POST['ncm'];}else{ $ncm="";};
			//**********
			//estoque	
				if(!empty($_POST['minimoQtde'])&&isset($_POST['minimoQtde'])){ $minimoQtde = $_POST['minimoQtde'];}else{ $minimoQtde=0;};
				if(!empty($_POST['qtde_conversor'])&&isset($_POST['qtde_conversor'])){ $qtde_conversor = $_POST['qtde_conversor'];}else{ $qtde_conversor=0;};
			//*******
			//propriedades		
				if(!empty($_POST['grupo'])&&isset($_POST['grupo'])&&$_POST['grupo']!="Novo Registro"){ $grupo = $_POST['grupo'];}else{ $grupo="";};
				if(!empty($_POST['subGrupo'])&&isset($_POST['subGrupo'])&&$_POST['subGrupo']!="Novo Registro"){ $subGrupo = $_POST['subGrupo'];}else{ $subGrupo="";};
				if(!empty($_POST['tamanhoBase'])&&isset($_POST['tamanhoBase'])){$tamanho = $_POST['tamanhoBase'];}else{ $tamanho="";};
				if(!empty($_POST['corBase'])&&isset($_POST['corBase'])&&$_POST['corBase']!="Novo Registro"){ $cor = $_POST['corBase'];}else{ $cor="";};
				if(!empty($_POST['descricaoum'])&&isset($_POST['descricaoum'])){ $descricaoum = $_POST['descricaoum'];}else{ $descricaoum="";};
				if(!empty($_POST['formula'])&&isset($_POST['formula'])&&$_POST['formula']!="Novo Registro"){ $formula = $_POST['formula'];}else{ $formula="";};
				if(!empty($_POST['ref_codbase'])&&isset($_POST['ref_codbase'])&&$_POST['ref_codbase']!="Novo Registro"){ $ref_codbase = $_POST['ref_codbase'];}else{ $ref_codbase="";};
			//************
			//observação
				if(!empty($_POST['obs'])&&isset($_POST['obs'])){ $obs = $_POST['obs'];}else{ $obs="";};
			//**********
			//frete
				if(!empty($_POST['altura'])&&isset($_POST['altura'])){ $altura = $_POST['altura'];}else{ $altura="0";};
				if(!empty($_POST['largura'])&&isset($_POST['largura'])){ $largura = $_POST['largura'];}else{ $largura="0";};
				if(!empty($_POST['comprimento'])&&isset($_POST['comprimento'])){ $comprimento = $_POST['comprimento'];}else{ $comprimento="0";};
				if(!empty($_POST['peso'])&&isset($_POST['peso'])){ $peso = $_POST['peso'];}else{ $peso="0";};
				if($_POST['correios'] == 'true'){ $correios = 1;}else{ $correios = 0;};
				if($_POST['transportadora'] == 'true'){ $transportadora = 1;}else{ $transportadora = 0;};
				if(!empty($_POST['tipoFrete'])&&isset($_POST['tipoFrete'])){ $tipoFrete = base64_encode($_POST['tipoFrete']);}else{ $tipoFrete="";};
				if(!empty($_POST['codFabForn'])&&isset($_POST['codFabForn'])){ $codFabForn = json_decode($_POST['codFabForn']);}else{ $codFabForn="";};
				if($_POST['retLoja'] == 'true'){ $retLoja = 1;}else{ $retLoja = 0;};
			//*****
				//E-commerce
				if(!empty($_POST['desconto'])&&isset($_POST['desconto'])){ $desconto = $_POST['desconto'];}else{ $desconto="";};
				if(!empty($_POST['metaTag'])&&isset($_POST['metaTag'])){ $metaTag = $_POST['metaTag'];}else{ $metaTag="";};
				if(!empty($_POST['metaDescr'])&&isset($_POST['metaDescr'])){ $metaDescr = $_POST['metaDescr'];}else{ $metaDescr="";};
				if(!empty($_POST['title'])&&isset($_POST['title'])){ $title = $_POST['title'];}else{ $title="";};
				if(!empty($_POST['infosTec'])&&isset($_POST['infosTec'])){ $infosTec = $_POST['infosTec'];}else{ $infosTec="";};
				if(!empty($_POST['garantia'])&&isset($_POST['garantia'])){ $garantia = $_POST['garantia'];}else{ $garantia="";};
			//**********
			//*****
				//Galeria
				if($_POST['destaque'] == 'true')	{ $destaque   = 1;}else{ $destaque  =0;};
				if($_POST['promocao'] == 'true')	{ $promocao   = 1;}else{ $promocao  =0;};
				if($_POST['publicar'] == 'true')	{ $publicar   = 1;}else{ $publicar  =0;};
				if($_POST['lancamento'] == 'true')	{ $lancamento = 1;}else{ $lancamento=0;};
				if($_POST['marketplace'] == 'true')	{ $marketplace = 1;}else{ $marketplace=0;};
			//**********
			if( isset($_POST['ref_cest']) && !empty($_POST['ref_cest']) ){ $ref_cest = $_POST['ref_cest']; }else{ $ref_cest=""; }
		//****************************************************************************************


		$filtro = '{"cod":"700498","params":[
			{"name":"descricao","value":"'.$descricao.'","type":"string"},
			{"name":"refReduz","value":"'.$refReduz.'","type":"string"},
			{"name":"fabricante","value":"'.$fabricante.'","type":"string"},';
		$filtro.= ($marca!="") ? '{"name":"marca","value":"'.$marca.'","type":"integer"},' : '{"name":"marca","value":"NULL","type":"other"},';
		$filtro.= '{"name":"tipo","value":"'.$tipo.'","type":"integer"},
			{"name":"codeBar","value":"'.$codBar.'","type":"string"},';
		$filtro.= ($tamanho!="") ? '{"name":"tamanho","value":"'.$tamanho.'","type":"string"},' : '{"name":"tamanho","value":"NULL","type":"other"},';
		$filtro.= ($setCodigo!="") ? '{"name":"setor","value":"'.$setCodigo.'","type":"string"},' : '{"name":"setor","value":"NULL","type":"other"},';
		$filtro.= '{"name":"tributacao","value":"'.$tributacao.'","type":"string"},
			{"name":"uniCodigo","value":"'.$unidadeMedidaEntrada.'","type":"string"},
			{"name":"uniCodigo2","value":"'.$unidadeMedidaTributavel.'","type":"string"},';
		$filtro.= ($grupo) ? '{"name":"grpCodigo","value":"'.$grupo.'","type":"integer"},' : '{"name":"grpCodigo","value":"NULL","type":"other"},';
		$filtro.= '{"name":"ncm","value":"'.$ncm.'","type":"string"},
			{"name":"obs","value":"'.$obs.'","type":"string"},
			{"name":"vendaAtacado","value":"'.$vendaAtacado.'","type":"integer"},
			{"name":"vendaVarejo","value":"'.$vendaVarejo.'","type":"integer"},
			{"name":"subGrupo","value":"'.$subGrupo.'","type":"integer"},
			{"name":"agrupamento","value":"'.$agrupamento.'","type":"integer"},';
		$filtro.= ($cor!="") ? '{"name":"cor","value":"'.$cor.'","type":"integer"},' : '{"name":"cor","value":"NULL","type":"other"},';
		$filtro.= '{"name":"formula","value":"'.$formula.'","type":"integer"},
			{"name":"ref_codbase","value":"'.$ref_codbase.'","type":"integer"},
			{"name":"minimoQtde","value":"'.$minimoQtde.'","type":"float"},
			{"name":"umPrecoMinimo","value":"'.$umPrecoMinimo.'","type":"float"},
			{"name":"altura","value":"'.$altura.'","type":"string"},
			{"name":"largura","value":"'.$largura.'","type":"string"},
			{"name":"comprimento","value":"'.$comprimento.'","type":"string"},
			{"name":"peso","value":"'.$peso.'","type":"string"},
			{"name":"correios","value":"'.$correios.'","type":"integer"},
			{"name":"transportadora","value":"'.$transportadora.'","type":"integer"},
			{"name":"tipoFrete","value":"'.$tipoFrete.'","type":"string"},
			{"name":"anp","value":"'.$anp.'","type":"string"},
			{"name":"qtde_conversor","value":"'.$qtde_conversor.'","type":"float"},
			{"name":"retLoja","value":"'.$retLoja.'","type":"float"},
			{"name":"status","value":"'.$status.'","type":"string"},
			{"name":"preco","value":"'.$custoReposicao.'","type":"float"},
			{"name":"propriedade","value":"'.$descricaoum.'","type":"string"},
			{"name":"publicar","value":"'.$publicar.'","type":"integer"},
			{"name":"destaque","value":"'.$destaque.'","type":"integer"},
			{"name":"promocao","value":"'.$promocao.'","type":"integer"},
			{"name":"lancamento","value":"'.$lancamento.'","type":"integer"},
			{"name":"marketplace","value":"'.$marketplace.'","type":"integer"},
			{"name":"ref_cest","value":"'.$ref_cest.'","type":"string"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		$datapacket->clear();

		$filtroMaxCod = '{"cod":"700366","params":[]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtroMaxCod);
		$res = $datapacket->open();
		$datapacket->clear();
		echo($res[0]['ref_codigo']);
		
		$company = $datapacket->getCompany();
		
		$filtrocusto = '{"cod":"700499","params":[
			{"name":"codigo","value":"'.$res[0]['ref_codigo'].'","type":"integer"},
			{"name":"serie","value":"1","type":"string"},
			{"name":"qtde","value":"'.$minimoQtde.'","type":"float"},
			{"name":"cusRepos","value":"'.$custoReposicao.'","type":"float"},
			{"name":"cusMed","value":"'.$custoMedio.'","type":"float"},
			{"name":"cusVend","value":"'.$custoVenda.'","type":"float"},
			{"name":"cusIpi","value":"'.$ipi.'","type":"float"},
			{"name":"cusIcms","value":"'.$icms.'","type":"float"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
		$datapacket->add($filtrocusto);
		$rescus = $datapacket->open();
		$datapacket->clear();

		$filtroStk = '{"cod":"700501","params":[
			{"name":"emp_codigo","value":"'.$company->emp_codigo.'","type":"string"},
			{"name":"loc_codigo","value":"1","type":"string"},
			{"name":"lot_codigo","value":"1","type":"string"},
			{"name":"ref_codigo","value":"'.$res[0]['ref_codigo'].'","type":"integer"},
			{"name":"ser_codigo","value":"1","type":"string"},
			{"name":"stk_seq","value":"'.mt_rand().'","type":"string"},
			{"name":"stk_qde","value":"'.$minimoQtde.'","type":"string"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtroStk);
		$result = $datapacket->open();
		$datapacket->clear();

		if(isset($unidadeMedidaSaida) && !empty($unidadeMedidaSaida) && $ret == "Template 700498: OK"){
			
			$filtroUnidadeMedida = '{"cod":"700367","params":[
				{"name":"ref_codigo","value":"'.$res[0]['ref_codigo'].'","type":"integer"},
				{"name":"uni_codigo","value":"'.$unidadeMedidaSaida.'","type":"string"},
				{"name":"urf_precoata","value":"'.$umAtacado.'","type":"float"},
				{"name":"urf_precovar","value":"'.$umVarejo.'","type":"float"},
				{"name":"urf_precomin","value":"'.$umPrecoMinimo.'","type":"float"},
				{"name":"qtde_conversor","value":"0","type":"float"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
			$datapacket->add($filtroUnidadeMedida);
			$resu = $datapacket->open();
			$datapacket->clear();

			if(isset($unidadeMedidaSaidaoutra) && !empty($unidadeMedidaSaidaoutra)){

				$filtroUnidadeMedidaoutro = '{"cod":"700367","params":[
					{"name":"ref_codigo","value":"'.$res[0]['ref_codigo'].'","type":"integer"},
					{"name":"uni_codigo","value":"'.$unidadeMedidaSaidaoutra.'","type":"string"},
					{"name":"urf_precoata","value":"'.$umAtacadoOutro.'","type":"float"},
					{"name":"urf_precovar","value":"'.$umVarejoOutro.'","type":"float"},
					{"name":"urf_precomin","value":"'.$umPrecoMinimoOutro.'","type":"float"}
				]}';
				$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
				$datapacket->add($filtroUnidadeMedidaoutro);
				$result = $datapacket->open();
				$datapacket->clear();
				//print_r(json_encode($result));
			}else{
				//print_r(json_encode($resu));
			}
		}else{
			//echo "insert referencia: ";
			//print_r(json_encode($ret));
		}

		if(count($codFabForn) > 0 ){
			for($i=0;$i<count($codFabForn);$i++){

				$filtroFabricante = '{"cod":"700469","params":[
					{"name":"cad_codigo","value":"'.$codFabForn[$i]->{'cad_codigo'}.'","type":"string"},
					{"name":"ref_codigo_forn","value":"'.$codFabForn[$i]->{'ref_codigo_forn'}.'","type":"string"},
					{"name":"ref_codigo","value":"'.$res[0]['ref_codigo'].'","type":"integer"}
				]}';
				$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
				$datapacket->add($filtroFabricante);
				$result = $datapacket->open();
				$datapacket->clear();

			}
		}	

		exit();
		
	}else if(isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="salvar"){ 

		$refReduz = "";
		$setCodigo = "";
		$status = 0;
		$serie = "";
		
		$arr1 = array("á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç", "º", "ª", "\"", "'");
		$arr2 = array("a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C", "", "", "", "");
		
		//params dos produtos
			if(!empty($_POST['emp_codigo'])&&isset($_POST['emp_codigo'])){ $emp_codigo = $_POST['emp_codigo'];}else{ $emp_codigo="";};
			//produtos gerais
				if(!empty($_POST['codigo'])&&isset($_POST['codigo'])){ $ref_codigo = $_POST['codigo'];}else{ $ref_codigo="";};
				if(!empty($_POST['descricao'])&&isset($_POST['descricao'])){ $descricao = str_replace($arr1, $arr2, $_POST['descricao']);}else{ $descricao="";};
				if(!empty($descricao)){ $refReduz = substr($descricao,0,25);}else{ $refReduz="";};
				if(!empty($_POST['fabricante'])&&isset($_POST['fabricante'])){ $fabricante = $_POST['fabricante'];}else{ $fabricante="";};
				if(!empty($_POST['marca'])&&isset($_POST['marca']) && $_POST['marca'] != "Novo Registro"){ $marca = $_POST['marca'];}else{ $marca="";};
				if(!empty($_POST['tipo'])&&isset($_POST['tipo'])){ $tipo = $_POST['tipo'];}else{ $tipo="";};
				if(!empty($_POST['codBar'])&&isset($_POST['codBar'])){ $codBar = $_POST['codBar'];}else if(!empty($_POST['codBarBase'])&&isset($_POST['codBarBase'])){$codBar = $_POST['codBarBase'];}else{ $codBar="";};
				if(!empty($_POST['agrupamento'])&&isset($_POST['agrupamento'])&&$_POST['agrupamento']!="Novo Registro"){ $agrupamento = $_POST['agrupamento'];}else{ $agrupamento="";};
				if(!empty($_POST['estante'])&&isset($_POST['estante'])){ $estante = $_POST['estante'];}else{ $estante="";};
				if(!empty($_POST['prateleira'])&&isset($_POST['prateleira'])){ $prateleira = $_POST['prateleira'];}else{ $prateleira="";};
				if(!empty($_POST['unidadeMedidaEntrada'])&&isset($_POST['unidadeMedidaEntrada'])&&$_POST['unidadeMedidaEntrada']!="Novo Registro"){ $unidadeMedidaEntrada = $_POST['unidadeMedidaEntrada'];}else{ $unidadeMedidaEntrada="";};
				if(!empty($_POST['unidadeMedidaTributavel'])&&isset($_POST['unidadeMedidaTributavel'])&&$_POST['unidadeMedidaTributavel']!="Novo Registro"){ $unidadeMedidaTributavel = $_POST['unidadeMedidaTributavel'];}else{ $unidadeMedidaTributavel="";};
				if(!empty($_POST['unidadeMedidaSaida'])&&isset($_POST['unidadeMedidaSaida'])&&$_POST['unidadeMedidaSaida']!="Novo Registro"){ $unidadeMedidaSaida = $_POST['unidadeMedidaSaida'];}else{ $unidadeMedidaSaida="";};
				if(!empty($_POST['unidadeMedidaSaidaoutra'])&&isset($_POST['unidadeMedidaSaidaoutra'])&&$_POST['unidadeMedidaSaidaoutra']!="Novo Registro"){ $unidadeMedidaSaidaoutra = $_POST['unidadeMedidaSaidaoutra'];}else{ $unidadeMedidaSaidaoutra="";};
			//**************
			//financeiro
				//valores
				if(!empty($_POST['ref_preco'])&&isset($_POST['ref_preco'])){ $ref_preco = $_POST['ref_preco'];}else{ $ref_preco=0;};
				if(!empty($_POST['custoMedio'])&&isset($_POST['custoMedio'])){ $custoMedio = $_POST['custoMedio'];}else{ $custoMedio="";};
				if(!empty($_POST['custoVenda'])&&isset($_POST['custoVenda'])){ $custoVenda = $_POST['custoVenda'];}else{ $custoVenda="";};
				if(!empty($_POST['custoReposicao'])&&isset($_POST['custoReposicao'])){ $custoReposicao = $_POST['custoReposicao'];}else{ $custoReposicao="";};
				if(!empty($_POST['custoPcp'])&&isset($_POST['custoPcp'])){ $custoPcp = $_POST['custoPcp'];}else{ $custoPcp="";};
				if(!empty($_POST['anp'])&&isset($_POST['anp'])){ $anp = $_POST['anp'];}else{ $anp="";};
				if(!empty($_POST['ref_comissao'])&&isset($_POST['ref_comissao'])){ $ref_comissao = $_POST['ref_comissao'];}else{ $ref_comissao=0;};
				//venda
				if(!empty($_POST['vendaAtacado'])&&isset($_POST['vendaAtacado'])){ $vendaAtacado = $_POST['vendaAtacado'];}else{ $vendaAtacado="";};
				if(!empty($_POST['vendaVarejo'])&&isset($_POST['vendaVarejo'])){ $vendaVarejo = $_POST['vendaVarejo'];}else{ $vendaVarejo="";};
				//unidade de medida
				if(!empty($_POST['umAtacado'])&&isset($_POST['umAtacado'])){ $umAtacado = $_POST['umAtacado'];}else{ $umAtacado=0;};
				if(!empty($_POST['umVarejo'])&&isset($_POST['umVarejo'])){ $umVarejo = $_POST['umVarejo'];}else{ $umVarejo=0;};
				if(!empty($_POST['umPrecoMinimo'])&&isset($_POST['umPrecoMinimo'])){ $umPrecoMinimo = $_POST['umPrecoMinimo'];}else{ $umPrecoMinimo=0;};
				if(!empty($_POST['umAtacadoOutro'])&&isset($_POST['umAtacadoOutro'])){ $umAtacadoOutro = $_POST['umAtacadoOutro'];}else{ $umAtacadoOutro=0;};
				if(!empty($_POST['umVarejoOutro'])&&isset($_POST['umVarejoOutro'])){ $umVarejoOutro = $_POST['umVarejoOutro'];}else{ $umVarejoOutro=0;};
				if(!empty($_POST['umPrecoMinimoOutro'])&&isset($_POST['umPrecoMinimoOutro'])){ $umPrecoMinimoOutro = $_POST['umPrecoMinimoOutro'];}else{ $umPrecoMinimoOutro=0;};
				//tributacao
				if(!empty($_POST['tributacao'])&&isset($_POST['tributacao'])&&$_POST['tributacao']!="Novo Registro"){ $tributacao = $_POST['tributacao'];}else{ $tributacao=1;};
				if(!empty($_POST['ipi'])&&isset($_POST['ipi'])){ $ipi = $_POST['ipi'];}else{ $ipi="";};
				if(!empty($_POST['icms'])&&isset($_POST['icms'])){ $icms = $_POST['icms'];}else{ $icms="";};
				if(!empty($_POST['ncm'])&&isset($_POST['ncm'])&&$_POST['ncm']!="Novo Registro"){ $ncm = $_POST['ncm'];}else{ $ncm="";};
			//**********
			//estoque	
				if(!empty($_POST['minimoQtde'])&&isset($_POST['minimoQtde'])){ $minimoQtde = $_POST['minimoQtde'];}else{ $minimoQtde=0;};
				if(!empty($_POST['qtde_conversor'])&&isset($_POST['qtde_conversor'])){ $qtde_conversor = $_POST['qtde_conversor'];}else{ $qtde_conversor=0;};
				if(isset($_POST['ref_multiplicador']) && $_POST['ref_multiplicador']!=0){ $ref_multiplicador = $_POST['ref_multiplicador'];}else{ $ref_multiplicador="";};
			//*******
			//propriedades		
				if(!empty($_POST['grupo'])&&isset($_POST['grupo'])&&$_POST['grupo']!="Novo Registro"){ $grupo = $_POST['grupo'];}else{ $grupo="";};
				if(!empty($_POST['subGrupo'])&&isset($_POST['subGrupo'])&&$_POST['subGrupo']!="Novo Registro"){ $subGrupo = $_POST['subGrupo'];}else{ $subGrupo="";};
				if(!empty($_POST['tamanho'])&&isset($_POST['tamanho'])&&$_POST['tamanho']!="Novo Registro"){ $tamanho = $_POST['tamanho'];}else{ $tamanho="";};
				if(!empty($_POST['cor'])&&isset($_POST['cor'])&&$_POST['cor']!="Novo Registro"){ $cor = $_POST['cor'];}else{ $cor="";};
				if(!empty($_POST['descricaoum'])&&isset($_POST['descricaoum'])){ $descricaoum = str_replace($arr1, $arr2, $_POST['descricaoum']);}else{ $descricaoum="";};
				if(!empty($_POST['formula'])&&isset($_POST['formula'])&&$_POST['formula']!="Novo Registro"){ $formula = $_POST['formula'];}else{ $formula="";};
				if(!empty($_POST['ref_validade'])&&isset($_POST['ref_validade'])&&$_POST['ref_validade']!="Novo Registro"){ $ref_validade = $_POST['ref_validade'];}else{ $ref_validade=0;};
				if(!empty($_POST['ref_codbase'])&&isset($_POST['ref_codbase'])&&$_POST['ref_codbase']!="Novo Registro"){ $ref_codbase = $_POST['ref_codbase'];}else{ $ref_codbase="null";};
			//************
			//observação
				if(!empty($_POST['obs'])&&isset($_POST['obs'])){ $obs = $_POST['obs'];}else{ $obs="";};
			//**********
			//frete
				if(!empty($_POST['altura'])&&isset($_POST['altura'])){ $altura = $_POST['altura'];}else{ $altura="0";};
				if(!empty($_POST['largura'])&&isset($_POST['largura'])){ $largura = $_POST['largura'];}else{ $largura="0";};
				if(!empty($_POST['comprimento'])&&isset($_POST['comprimento'])){ $comprimento = $_POST['comprimento'];}else{ $comprimento="0";};
				if(!empty($_POST['peso'])&&isset($_POST['peso'])){ $peso = $_POST['peso'];}else{ $peso="0";};
				if($_POST['correios'] == 'true'){ $correios = 1;}else{ $correios = 0;};
				if($_POST['transportadora'] == 'true'){ $transportadora = 1;}else{ $transportadora = 0;};
				if(!empty($_POST['tipoFrete'])&&isset($_POST['tipoFrete'])){ $tipoFrete = $_POST['tipoFrete'];}else{ $tipoFrete="";};
				if(!empty($_POST['codFabForn'])&&isset($_POST['codFabForn'])){ $codFabForn = json_decode(base64_decode($_POST['codFabForn']));}else{ $codFabForn="";};
				if($_POST['retLoja'] == 'true'){ $retLoja = 1;}else{ $retLoja = 0;};
			//*****
				//E-commerce
				if(!empty($_POST['desconto'])&&isset($_POST['desconto'])){ $desconto = $_POST['desconto'];}else{ $desconto="";};
				if(!empty($_POST['metaTag'])&&isset($_POST['metaTag'])){ $metaTag = $_POST['metaTag'];}else{ $metaTag="";};
				if(!empty($_POST['metaDescr'])&&isset($_POST['metaDescr'])){ $metaDescr = $_POST['metaDescr'];}else{ $metaDescr="";};
				if(!empty($_POST['title'])&&isset($_POST['title'])){ $title = $_POST['title'];}else{ $title="";};
				if(!empty($_POST['infosTec'])&&isset($_POST['infosTec'])){ $infosTec = $_POST['infosTec'];}else{ $infosTec="";};
				if(!empty($_POST['garantia'])&&isset($_POST['garantia'])){ $garantia = $_POST['garantia'];}else{ $garantia="";};
			//**********
			//*****
				//Galeria
				if($_POST['destaque'] == 'true')	{ $destaque   = 1;}else{ $destaque  =0;};
				if($_POST['promocao'] == 'true')	{ $promocao   = 1;}else{ $promocao  =0;};
				if($_POST['publicar'] == 'true')	{ $publicar   = 1;}else{ $publicar  =0;};
				if($_POST['lancamento'] == 'true')	{ $lancamento = 1;}else{ $lancamento=0;};
				if($_POST['marketplace'] == 'true')	{ $marketplace = 1;}else{ $marketplace=0;};
			//**********
		if( isset($_POST['ref_cest']) && !empty($_POST['ref_cest']) ){ $ref_cest = $_POST['ref_cest']; }else{ $ref_cest=""; }
		//****************************************************************************************

		if(empty($ref_codigo)){
			
			$query_cod = "700360";

		} else {

			//limpar UM
			$filtroUnidadeMedida = '{"cod":"700463","params":[
				{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
			$datapacket->add($filtroUnidadeMedida);
			$datapacket->open();
			$datapacket->clear();
			
			//limpar Forn
			$filtroForn = '{"cod":"700490","params":[
				{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
			$datapacket->add($filtroForn);
			$datapacket->open();
			$datapacket->clear();
			
			$query_cod = "700462";
		}

		$filtro = '{"cod":"'.$query_cod.'","params":[
			{"name":"codigo","value":"'.$ref_codigo.'","type":"string"},
			{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"string"},
			{"name":"descricao","value":"'.$descricao.'","type":"string"},
			{"name":"refReduz","value":"'.$refReduz.'","type":"string"},
			{"name":"fabricante","value":"'.$fabricante.'","type":"string"},';
		$filtro.= ($marca!="") ? '{"name":"marca","value":"'.$marca.'","type":"integer"},' : '{"name":"marca","value":"NULL","type":"other"},';
		$filtro.= '{"name":"tipo","value":"'.$tipo.'","type":"integer"},
			{"name":"codeBar","value":"'.$codBar.'","type":"string"},';
		$filtro.= ($tamanho!="") ? '{"name":"tamanho","value":"'.$tamanho.'","type":"string"},' : '{"name":"tamanho","value":"NULL","type":"other"},';
		$filtro.= ($setCodigo!="") ? '{"name":"setor","value":"'.$setCodigo.'","type":"string"},' : '{"name":"setor","value":"NULL","type":"other"},';
		$filtro.= '{"name":"tributacao","value":"'.$tributacao.'","type":"string"},
			{"name":"uniCodigo","value":"'.$unidadeMedidaEntrada.'","type":"string"},
			{"name":"uniCodigo2","value":"'.$unidadeMedidaTributavel.'","type":"string"},';
		$filtro.= ($grupo!="") ? '{"name":"grpCodigo","value":"'.$grupo.'","type":"integer"},' : '{"name":"grpCodigo","value":"NULL","type":"other"},';
		$filtro.= '{"name":"ncm","value":"'.$ncm.'","type":"string"},
			{"name":"obs","value":"'.$obs.'","type":"string"},
			{"name":"vendaAtacado","value":"'.$vendaAtacado.'","type":"integer"},
			{"name":"vendaVarejo","value":"'.$vendaVarejo.'","type":"integer"},
			{"name":"subGrupo","value":"'.$subGrupo.'","type":"integer"},
			{"name":"agrupamento","value":"'.$agrupamento.'","type":"integer"},';
		$filtro.= ($cor!="") ? '{"name":"cor","value":"'.$cor.'","type":"integer"},' : '{"name":"cor","value":"NULL","type":"other"},';
		$filtro.= '{"name":"formula","value":"'.$formula.'","type":"integer"},
			{"name":"ref_codbase","value":"'.$ref_codbase.'","type":"other"},
			{"name":"minimoQtde","value":"'.$minimoQtde.'","type":"float"},
			{"name":"umPrecoMinimo","value":"'.$umPrecoMinimo.'","type":"float"},
			{"name":"altura","value":"'.$altura.'","type":"string"},
			{"name":"largura","value":"'.$largura.'","type":"string"},
			{"name":"comprimento","value":"'.$comprimento.'","type":"string"},
			{"name":"peso","value":"'.$peso.'","type":"string"},
			{"name":"correios","value":"'.$correios.'","type":"integer"},
			{"name":"transportadora","value":"'.$transportadora.'","type":"integer"},
			{"name":"tipoFrete","value":"'.$tipoFrete.'","type":"string"},
			{"name":"anp","value":"'.$anp.'","type":"string"},
			{"name":"qtde_conversor","value":"'.$qtde_conversor.'","type":"float"},
			{"name":"retLoja","value":"'.$retLoja.'","type":"string"},
			{"name":"desconto","value":"'.$desconto.'","type":"integer"},
			{"name":"metaTag","value":"'.$metaTag.'","type":"string"},
			{"name":"metaDescr","value":"'.$metaDescr.'","type":"string"},
			{"name":"title","value":"'.$title.'","type":"string"},
			{"name":"infosTec","value":"'.$infosTec.'","type":"string"},
			{"name":"garantia","value":"'.$garantia.'","type":"string"},
			{"name":"status","value":"'.$status.'","type":"string"},
			{"name":"preco","value":"'.$ref_preco.'","type":"float"},
			{"name":"propriedade","value":"'.$descricaoum.'","type":"string"},
			{"name":"publicar","value":"'.$publicar.'","type":"integer"},
			{"name":"destaque","value":"'.$destaque.'","type":"integer"},
			{"name":"promocao","value":"'.$promocao.'","type":"integer"},
			{"name":"lancamento","value":"'.$lancamento.'","type":"integer"},
			{"name":"ref_prc_atacado","value":"'.$umAtacado.'","type":"float"},
			{"name":"ref_multiplicador","value":"'.$ref_multiplicador.'","type":"float"},
			{"name":"ref_comissao","value":"'.$ref_comissao.'","type":"float"},
			{"name":"ref_validade","value":"'.$ref_validade.'","type":"integer"},
			{"name":"ref_marketplace","value":"'.$marketplace.'","type":"integer"},
			{"name":"ref_cest","value":"'.$ref_cest.'","type":"string"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$retInsert = $datapacket->open(false, true);
		$datapacket->clear();
		
		// if( $_POST["acao"]=="incluir" ){
		if( $ref_codigo=="" ){
			
			// $filtroMaxCod = '{"cod":"700366","params":[]}';
			// $datapacket->setHost($datapacket->getHost($datapacket->getDb()));
			// $datapacket->add($filtroMaxCod);
			// $res = $datapacket->open();
			// $datapacket->clear();
			
			// if($ref_codigo==""){
			// 	echo($res[0]['ref_codigo']);
			// 	$ref_codigo = $res[0]['ref_codigo'];
			// }else{
			// 	echo $ref_codigo;
			// }
			
			$ref_codigo = $retInsert;

			// if($ref_codigo==""){
				// echo($ret);
				// $ref_codigo = $ret;
			// }else{
				// echo $ref_codigo;
			// }

			$filtroStk = '{"cod":"700501","params":[
				{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"},
				{"name":"loc_codigo","value":"99999","type":"string"},
				{"name":"lot_codigo","value":"99999","type":"string"},
				{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
				{"name":"ser_codigo","value":"1","type":"string"},
				{"name":"stk_seq","value":"'.mt_rand().'","type":"string"},
				{"name":"stk_qde","value":"0","type":"string"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
			$datapacket->add($filtroStk);
			$result = $datapacket->open();
			$datapacket->clear();

		}

		echo $ref_codigo;

		$filtrocusto = '{"cod":"700499","params":[
			{"name":"codigo","value":"'.$ref_codigo.'","type":"integer"},
			{"name":"serie","value":"1","type":"string"},
			{"name":"qtde","value":"'.$minimoQtde.'","type":"float"},
			{"name":"cusRepos","value":"'.$custoReposicao.'","type":"float"},
			{"name":"cusMed","value":"'.$custoMedio.'","type":"float"},
			{"name":"cusVend","value":"'.$custoVenda.'","type":"float"},
			{"name":"cusIpi","value":"'.$ipi.'","type":"float"},
			{"name":"cusIcms","value":"'.$icms.'","type":"float"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
		$datapacket->add($filtrocusto);
		$rescus = $datapacket->open();
		$datapacket->clear();
		
		if(isset($unidadeMedidaSaida) && !empty($unidadeMedidaSaida)){

			$filtroUnidadeMedida = '{"cod":"700367","params":[
				{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
				{"name":"uni_codigo","value":"'.$unidadeMedidaSaida.'","type":"string"},
				{"name":"urf_precoata","value":"'.$umAtacado.'","type":"float"},
				{"name":"urf_precovar","value":"'.$umVarejo.'","type":"float"},
				{"name":"urf_precomin","value":"'.$umPrecoMinimo.'","type":"float"},
				{"name":"qtde_conversor","value":"0","type":"float"}
			]}';
			$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
			$datapacket->add($filtroUnidadeMedida);
			$resu = $datapacket->open();
			$datapacket->clear();

			if(isset($unidadeMedidaSaidaoutra) && !empty($unidadeMedidaSaidaoutra)){

				$filtroUnidadeMedidaoutro = '{"cod":"700367","params":[
					{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
					{"name":"uni_codigo","value":"'.$unidadeMedidaSaidaoutra.'","type":"string"},
					{"name":"urf_precoata","value":"'.$umAtacadoOutro.'","type":"float"},
					{"name":"urf_precovar","value":"'.$umVarejoOutro.'","type":"float"},
					{"name":"urf_precomin","value":"'.$umPrecoMinimoOutro.'","type":"float"}
				]}';
				$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
				$datapacket->add($filtroUnidadeMedidaoutro);
				$result = $datapacket->open();
				$datapacket->clear();
			}
		}
		
		if(!empty($codFabForn)){

			foreach($codFabForn as $fab){
				
				$filtroFabricante = '{"cod":"700469","params":[
					{"name":"cad_codigo","value":"'.$fab->{'cad_codigo'}.'","type":"string"},
					{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"integer"},
					{"name":"ref_codigo_forn","value":"'.$fab->{"ref_codigo_forn"}.'","type":"string"}
				]}';
				$datapacket->add($filtroFabricante);	
			}
			$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
			$datapacket->open(true);
			$datapacket->clear();
		}
		
		exit();
		
	} else { //busca geral
	
		$company = $datapacket->getCompany();

		$busca = '';
		
		if( isset($_REQUEST['ref_codigo']) || isset($_REQUEST['descricao']) || isset($_REQUEST['propriedade']) ||  isset($_REQUEST['marca']) ||  isset($_REQUEST['tipo']) ||  isset($_REQUEST['ref_tipo']) ||  isset($_REQUEST['codbar']) || isset($_REQUEST['loc_codigo']) || isset($_REQUEST['lot_codigo'])){
		
			if( isset($_REQUEST['descricao']) ){
				$busca .= "referencia.ref_descr LIKE '%".$_REQUEST['descricao']."%' ";
			}else{
				$busca .= "referencia.ref_descr LIKE '%' ";
			}
			if( isset($_REQUEST['ref_codigo']) && $_REQUEST['ref_codigo']!="" ){
				$busca.= " and referencia.ref_codigo = '".$_REQUEST['ref_codigo']."' ";
			}
			if( isset($_REQUEST['propriedade']) && $_REQUEST['propriedade']!="" ){
				$busca.= " and referencia.ref_propriedade like '%".$_REQUEST['propriedade']."%'";
			}
			if( isset($_REQUEST['marca']) && $_REQUEST['marca']!="" && $_REQUEST['marca']!="Novo Registro" ){
				$busca.= " and referencia.mar_codigo = '".$_REQUEST['marca']."%'";
			}
			if( isset($_REQUEST['tipo']) && $_REQUEST['tipo']!="" ){
				$busca.= " and referencia.ref_tipo = '".$_REQUEST['tipo']."'";
			}else if( isset($_REQUEST['ref_tipo']) && $_REQUEST['ref_tipo']!="" ){
				$busca.= " and referencia.ref_tipo in (".$_REQUEST['ref_tipo'].")";
			}
			if( isset($_REQUEST['codbar']) && $_REQUEST['codbar']!="" ){
				$busca.= " and referencia.ref_codbar like '%".$_REQUEST['codbar']."%'";
			}
			if( isset($_REQUEST['agrupamento']) && $_REQUEST['agrupamento']!="" && $_REQUEST['agrupamento']!="Novo Registro" ){
				$busca.= " and referencia.agr_codigo = '".$_REQUEST['agrupamento']."'";
			}
			if( isset($_REQUEST['grp_codigo']) && $_REQUEST['grp_codigo']!="" && $_REQUEST['grp_codigo']!="Novo Registro" ){
				$busca.= " and referencia.grp_codigo = ".$_REQUEST['grp_codigo']." ";
			}
			if( isset($_REQUEST['sgp_codigo']) && $_REQUEST['sgp_codigo']!="" && $_REQUEST['sgp_codigo']!="Novo Registro" ){
				$busca.= " and referencia.sgp_codigo = ".$_REQUEST['sgp_codigo']." ";
			}
			if( isset($_REQUEST['loc_codigo']) && $_REQUEST['loc_codigo']!="" && $_REQUEST['loc_codigo']!="Novo Registro" ){
				$busca.= " and referencia.ref_codigo in (select b.ref_codigo from saldostk b where b.ref_codigo=referencia.ref_codigo and b.emp_codigo='".$company->emp_codigo."' and b.loc_codigo='".$_REQUEST['loc_codigo']."' group by b.ref_codigo) ";
			}
			if( isset($_REQUEST['lot_codigo']) && $_REQUEST['lot_codigo']!="" && $_REQUEST['lot_codigo']!="Novo Registro" ){
				$busca.= " and referencia.ref_codigo in (select c.ref_codigo from saldostk c where c.ref_codigo=referencia.ref_codigo and c.emp_codigo='".$company->emp_codigo."' and c.lot_codigo='".$_REQUEST['lot_codigo']."' group by c.ref_codigo) ";
			}
			if(isset($_REQUEST['query']) && $_REQUEST['query']!=""){
				$busca .= ' and (referencia.ref_codigo = \"'.$_REQUEST['query'].'\" OR referencia.ref_descr LIKE \"%'.$_REQUEST['query'].'%\" OR (referencia.ref_codbar = \"'.str_pad($_REQUEST['query'], 13, 0, STR_PAD_LEFT).'\" OR referencia.ref_codbar = \"'.str_pad($_REQUEST['query'], 14, 0, STR_PAD_LEFT).'\" OR trim(leading 0 from referencia.ref_codbar) = \"'.ltrim($_REQUEST['query'], "0").'\") OR referencia.ref_propriedade LIKE \"%'.$_REQUEST['query'].'%\") ';
			}

		}else{
		
			if(!isset($_REQUEST['query'])) $_REQUEST['query']="";
			$busca .= 'referencia.ref_codigo = \"'.$_REQUEST['query'].'\" OR referencia.ref_descr LIKE \"%'.$_REQUEST['query'].'%\" OR (referencia.ref_codbar = \"'.str_pad($_REQUEST['query'], 13, 0, STR_PAD_LEFT).'\" OR referencia.ref_codbar = \"'.str_pad($_REQUEST['query'], 14, 0, STR_PAD_LEFT).'\" OR trim(leading 0 from referencia.ref_codbar) = \"'.ltrim($_REQUEST['query'], "0").'\") OR referencia.ref_propriedade LIKE \"%'.$_REQUEST['query'].'%\" ';
		
		}
		
		$filtro = '{"cod":"700165","params":[
			{"name":"ref_codigo","value":"'.$busca.'","type":"other"},
			{"name":"emp_codigo","value":"'.$datapacket->getCodigo().'","type":"string"},
			{"name":"start","value":"'.$_REQUEST['start'].'","type":"integer"},
			{"name":"limit","value":"'.$_REQUEST['limit'].'","type":"integer"}
		]}';
		$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
		$datapacket->add($filtro);
		$ret = $datapacket->open(true);
		$datapacket->clear();

		if(!isset($_REQUEST['novoRegistro']) && !isset($_REQUEST['naonovo'])){
			$vazio = new StdClass();
			$vazio->{"novo_registro"} = true;
			$vazio->tri_csosn = 1;
			$vazio->saldo_stk = '10';
			$vazio->ref_ncm = '39269090';
			array_unshift($ret,$vazio);
		}

		$filtro=json_decode($filtro);
		$filtro->cod='700830';
		$datapacket->add(json_encode($filtro));
		$count = $datapacket->open(true);
		$total = $count[0]->total;
		$datapacket->clear();

		$obj = new StdClass();
		$obj->total=$total;
		$obj->data=$ret;

		print_r(json_encode($obj));
	
	}
	
?>