<?php
/*
* Classe para definicao das propriedades de um documento, pode ser utilizado em remessa ou retorno
*/
class Remessa{
	
	/*
	string com caminho completo do arquivo de remessa
	*/
	public $nomeArquivo = "";
	
	/*
	referencia ao arquivo de remessa a ser escrito
	*/
	public $arquivo = "";
	
	/*
	layout da remessa, padrao febraban de 240 posições
	*/
	public $layout = "FEBRABAN240";
	
	/*
	Código do Banco na Compensação
	G001 tamanho 3 posição 1-3
	*/
	public $banco = "000";
	
	/*
	Lote de Serviço 
	G002 tamanho 4 posição 4-7
	*/
	public $lote = "0000";


	/*
	Uso Exclusivo FEBRABAN / CNAB  
	G004 tamanho 9 posição 9-17
	*/
	public $cnab = "         ";


	/*
	Tipo de Inscrição da Empresa
	G005 tamanho 1 posição 18-18
	*/
	public $inscricaoTipo = "0";


	/*
	Nº de Inscrição da Empresa
	G006 tamanho 14 posição 19-32
	*/
	public $inscricaoNumero = "00000000000000";
	

	/*
	Código do Convênio no Banco
	G007 tamanho 20 posição 33-52
	*/
	public $convenio = "                    ";


	/*
	Agência Mantenedora da Conta
	G008 tamanho 5 posição 53-57
	*/
	public $agenciaCodigo = "00000";


	/*
	Dígito Verificador da Conta
	G009 tamanho 1 posição 58-58
	*/
	public $agenciaDv = " ";


	/*
	Número da Conta Corrente
	G010 tamanho 12 posição 59-70
	*/
	public $contaNumero = "000000000000";


	/*
	Número da Conta Corrente
	G011 tamanho 1 posição 71-71
	*/
	public $contaDv = " ";


	/*
	Dígito Verificador da Ag/Conta 
	G012 tamanho 1 posição 72-72
	*/
	public $dvAgenciaConta = " ";


	/*
	Nome da Empresa 
	G013 tamanho 30 posição 73-102
	*/
	public $empresaNome = "                              ";


	/*
	Nome do Banco 
	G014 tamanho 30 posição 103-132
	*/
	public $nomeBanco = "                              ";


	/*
	Lote de Serviço 
	G004 tamanho 10 posição 133-142
	*/
	public $cnabHeader = "          ";


	/*
	Código Remessa / Retorno 
	G015 tamanho 1 posição 143-143
	*/
	public $arquivoCodigo = "1";


	/*
	Data de Geração do Arquivo
	G016 tamanho 8 posição 144-151
	*/
	public $arquivoDataGeracao = "00000000";
	
	/*
	Hora de Geração do Arquivo
	G017 tamanho 6 posição 152-157
	*/
	public $arquivoHoraGeracao = "000000";

	/*
	Número Seqüencial do Arquivo
	G018 tamanho 6 posição 158-163
	*/
	public $arquivoSequenciaNsa = "000000";

	/*
	No da Versão do Layout do Arquivo
	G019 tamanho 3 posição 164-166
	*/
	public $arquivoLayout = "087";


	/*
	Densidade de Gravação do Arquivo
	G020 tamanho 5 posição 167-171
	*/
	public $arquivoDensidade = "00000";


	/*
	Para Uso Reservado do Banco
	G021 tamanho 20 posição 172-191
	*/
	public $reservadoBanco = "                    ";


	/*
	Para Uso Reservado da Empresa
	G022 tamanho 20 posição 192-211
	*/
	public $reservadoEmpresa = "                    ";


	/*
	Uso Exclusivo FEBRABAN / CNAB
	G004 tamanho 29 posição 212-240
	*/
	public $cnabFinalHeader = "                             ";




	/*
	Uso Exclusivo FEBRABAN / CNAB
	G004 tamanho 9 posição 9-17
	*/
	public $cnabTrailer = "         ";

	/*
	Quantidade de Lotes do Arquivo
	G049 tamanho 6 posição 18-23
	*/
	public $quantidadeLote = "000001";


	/*
	Quantidade de Registros do Arquivo 
	G056 tamanho 6 posição 24-29
	*/
	public $quantidadeRegistro = "000000";


	/*
	Qtde de Contas p/ Conc. (Lotes)
	G037 tamanho 6 posição 30-35
	*/
	public $quantidadeContaConciliada = "      ";


	/*
	Uso Exclusivo FEBRABAN / CNAB
	G004 tamanho 205 posição 36-240
	*/
	public $cnabFinalTrailer = "                                                                                                                                                                                                             ";
	
	
	
	/**
	* Construtor padrao - abre o arquivo e armazena sua referencia
	* @param string $arquivo nome do arquivo a ser aberto ou escrito
	* @param string $layout layout do arquivo, 240 ou 400 posições
	* @param string $banco código do banco na FEBRABAN
	*/
	public function __construct($arquivo='teste.txt', $layout="FEBRABAN240", $banco="001"){
		$this->arquivoDataGeracao = date("dmY");
		$this->arquivoHoraGeracao = date("His");
		$this->arquivo = date("dmY");
		$this->nomeArquivo = $arquivo;
		$this->arquivo = fopen($this->nomeArquivo,"w");
		$this->layout = $layout;
		$this->banco = $banco;
		
		if( $this->banco=="033" ){
			$this->cnab="        ";
			$this->convenio="                                        ";
			$this->inscricaoNumero="000000000000000";
			$this->arquivoHoraGeracao = "      ";
			$this->arquivoDensidade = "     ";
		}
		
		if( $this->layout=="SIGCB240" ){
			$this->convenio="000000"; //6 posições
			if( strstr($_SERVER["HTTP_HOST"], "dev.") ){
				$this->reservadoEmpresa="REMESSA-TESTE       ";
			}else{
				$this->reservadoEmpresa="REMESSA-PRODUCAO    ";
			}
		}
		
		if( $this->layout=="CNAB400" || $this->layout=="CBR641" ){
			$this->arquivoDataGeracao = date("dmy");
			$this->agenciaCodigo = "0000"; //4 posições 27-30
			if( $this->layout=="CBR641" ){
				$this->contaNumero = "00000000";
				$this->convenio = "0000000"; //7 posições 130-138
			}else{
				$this->contaNumero = "00000";
				$this->convenio = "000000000"; //9 posições 32-40
			}
			
			$this->nomeBanco = "               "; //15 posições 79-94
			$this->arquivoSequenciaNsa = "0000000"; //7 posições
		}
		
	}
	
	/**
	* Escreve no arquivo de remessa
	*/
	public function write($linha){
		if(!empty($this->arquivo)){
			$linha = iconv("UTF-8", "Windows-1252", $linha); //codificação ASCI para validação dos arquivos no banco
			fwrite($this->arquivo, $linha);
		}else{
			throw new Exception('Nao foi possivel armazenar arquivo');
		}
	}
	
	/**
	* Fecha o arquivo de remessa
	*/
	public function close(){
		if(!empty($this->arquivo)){
			if(fclose($this->arquivo)){
				$this->arquivo=null;
			}else{
				throw new Exception('Nao foi possivel fechar arquivo');
			}
		}
	}
	
	/**
	* _set
	* Atribui valores para propriedades da classe
	* @param string $prop propriedade que deseja utilizar
	* @param string $value valor para ser armazenado na prop informada
	* @return $this
	*/
	public function _set($prop,$value){
		if(property_exists($this,$prop)){
			
			switch($prop){
				case 'inscricaoNumero':
					if(strlen($value)>11){
						$this->inscricaoTipo="2";
					}else{
						$this->inscricaoTipo="1";
					}
					break;
				case 'banco':
					if( $value=="001" ){
						$this->_set("nomeBanco", "BANCODOBRASIL");
					}elseif( $value=="033" ){
						$this->_set("nomeBanco", "BANCO SANTANDER");
					}elseif( $value=="104" ){
						$this->_set("nomeBanco", "CAIXA ECONOMICA FEDERAL");
					}elseif( $value=="237" ){
						$this->_set("nomeBanco", "BANCO BRADESCO");
					}elseif( $value=="341" ){
						$this->_set("nomeBanco", "BANCO ITAU SA");
					}elseif( $value=="748" ){
						$this->_set("nomeBanco", "BANCO SICREDI");
					}elseif( $value=="756" ){
						$this->_set("nomeBanco", "BANCOOBCED");
					}
					break;
			}
			
			$tam = strlen($this->$prop);
			if( is_numeric($this->$prop) ){
				// $value = (int) $value;
				$this->$prop = substr((string)$value, 0, $tam);
				$this->$prop = str_pad($value, $tam, "0", STR_PAD_LEFT);
			}else{
				$this->$prop = substr($value, 0, $tam);
				$this->$prop = str_pad($this->$prop, $tam, " ", STR_PAD_RIGHT);
			}
		}else{
			throw new Exception("Propriedade ".$prop." inexistente da Remessa");
		}
		return $this;
	}
	
	/**
	* headerArquivo
	* Monta a linha de cabeçalho do arquivo de remessa, usando as propriedades de acordo com o layout inofrmado
	* @return string $linha string com a linha completa do cabeçalho do arquivo
	*/
	public function headerArquivo(){
		$headerArquivo = "";
		
		if( $this->layout=="FEBRABAN240" ){
			
			if( $this->banco=="033" ){
				$headerArquivo = $this->banco.$this->lote."0".$this->cnab.$this->inscricaoTipo.$this->inscricaoNumero.$this->convenio.$this->empresaNome.$this->nomeBanco.$this->cnabHeader.$this->arquivoCodigo.$this->arquivoDataGeracao.$this->arquivoHoraGeracao.$this->arquivoSequenciaNsa.$this->arquivoLayout.$this->arquivoDensidade.$this->reservadoBanco.$this->reservadoEmpresa.$this->cnabFinalHeader."\n";
			}else{
				$headerArquivo = $this->banco.$this->lote."0".$this->cnab.$this->inscricaoTipo.$this->inscricaoNumero.$this->convenio.$this->agenciaCodigo.$this->agenciaDv.$this->contaNumero.$this->contaDv.$this->dvAgenciaConta.$this->empresaNome.$this->nomeBanco.$this->cnabHeader.$this->arquivoCodigo.$this->arquivoDataGeracao.$this->arquivoHoraGeracao.$this->arquivoSequenciaNsa.$this->arquivoLayout.$this->arquivoDensidade.$this->reservadoBanco.$this->reservadoEmpresa.$this->cnabFinalHeader."\n";
			}
			
		}elseif( $this->layout=="CNAB400" ){
			
			if( $this->banco=="341" ){
				
				$headerArquivo = "01REMESSA01COBRANCA       ".$this->agenciaCodigo."00".$this->contaNumero.$this->contaDv."        ".$this->empresaNome.$this->banco.$this->nomeBanco.$this->arquivoDataGeracao."                                                                                                                                                                                                                                                                                                      000001\r\n";
				
			}elseif( $this->banco=="756" ){
			
				$headerArquivo = "01REMESSA01COBRANÇA       ".$this->agenciaCodigo.$this->agenciaDv.$this->convenio."      ".$this->empresaNome.$this->banco.$this->nomeBanco.$this->arquivoDataGeracao.$this->arquivoSequenciaNsa."                                                                                                                                                                                                                                                                                               000001\n";
			}
			
		}elseif( $this->layout=="CBR641" ){
			
			$headerArquivo = "01REMESSA01COBRANÇA       ".$this->agenciaCodigo.$this->agenciaDv.$this->contaNumero.$this->contaDv."000000".$this->empresaNome.$this->banco.$this->nomeBanco.$this->arquivoDataGeracao.$this->arquivoSequenciaNsa."                      ".$this->convenio."                                                                                                                                                                                                                                                                  000001\n";

		}elseif( $this->layout=="SIGCB240" ){
			
			$headerArquivo = $this->banco.$this->lote."0".$this->cnab.$this->inscricaoTipo.$this->inscricaoNumero."00000000000000000000".$this->agenciaCodigo.$this->agenciaDv.$this->convenio."00000000".$this->empresaNome.$this->nomeBanco.$this->cnabHeader.$this->arquivoCodigo.$this->arquivoDataGeracao.$this->arquivoHoraGeracao.$this->arquivoSequenciaNsa.$this->arquivoLayout.$this->arquivoDensidade.$this->reservadoBanco.$this->reservadoEmpresa.$this->cnabFinalHeader."\n";
			
		}
		
		return $headerArquivo;
	}
	
	/**
	* trailerArquivo
	* Monta a linha de trailer do arquivo de remessa, usando as propriedades de acordo com o layout inofrmado
	* @return string $linha string com a linha completa do trailer do arquivo
	*/
	public function trailerArquivo(){
		$trailerArquivo = "";
		
		if( $this->layout=="FEBRABAN240" || $this->layout=="SIGCB240" ){
			
			$trailerArquivo = $this->banco."99999".$this->cnabTrailer.$this->quantidadeLote.$this->quantidadeRegistro.$this->quantidadeContaConciliada.$this->cnabFinalTrailer."\n";
			
		}
		
		return $trailerArquivo;
	}
	
}
?>