<?php 
/**
* Classe para definicao de metodos obrigatorio para gerar blocos para o sped
*/
abstract class Registro{
	/**
	* Definicao qual o path separador de colunas no 
	*/
	const SEPARATOR='|';
	/**
	* Seta valores para propriedades propriedade da classe extensora
	* @param string $prop propriedade que deseja utilizar
	* @param string $value valor para ser armazenado na prop informada
	* @return $this
	*/
	public function _set($prop,$value){
		if(property_exists($this,$prop))
			$this->$prop=$value;
		else
			throw new Exception("Nao definida propriedade ".$prop.' em  '.get_class($this));
		return $this;
	}
	/**
	* Retorno valor de determinadas propriedade da classe extensora
	* @param string $prop propriedade que deseja retornar o value	
	* @return string
	*/
	public function _get($prop){
		if(property_exists($this,$prop))
			return $this->$prop;
		else
			throw new Exception('Nao definida propriedade '.$prop.' em '.get_class($this));
	}
	/**
	* Metodo para printrar na tela debug
	* @return void
	*/
	public function d($v){
		echo '<pre>'.var_export($v,true).'</pre>';
	}
	/**
	* Retorna o objeto registro em string
	* @return string
	*/
	public function _toLine(){
		$class=new ReflectionClass($this);
		$linha='';
		if($props=$class->getProperties(ReflectionProperty::IS_PROTECTED)){
			foreach($props as $prop){
				$linha.=$this->_get($prop->getName()).self::SEPARATOR;
			}
		}
		return self::SEPARATOR.$linha;
	}
	
	/**
	* Retorna qual a nome da classe
	* @return string
	*/
	public function _getNameClass(){
		return get_class($this);
	}
	/**
	* Retorna qual bloco o registro representa
	* @return string
	*/
	public function _getNameBloco(){
		if(!isset($this->reg{3}))
			throw Exception('Nao foi defindo o tipo de registro em'.get_class($this));
	
			return substr($this->reg,0,1);
	}
	
	/**
	* Retorna o nome do registro
	* @return string
	*/
	public function _getRegistroName(){
		if(!isset($this->reg{3}))
			throw Exception('Nao foi defindo o tipo de registro em'.get_class($this));
			return $this->reg;
	}
	
	/**
	* Retorna a funcao do registro  open || close || registro
	* @return string
	*/
	public function _getRegistroFuncao(){
		if(!isset($this->reg{3}))
			throw Exception('Nao foi defindo o tipo de registro em'.get_class($this));
			$type=substr($this->reg,1,3);
			switch($type){
				case('000'):
				case('001'):
					return 'o';
				break;
				case('990'):
					return 'c';
				break;
				case(strlen($type)==3):
					return 'r';
				break;
				default:
					throw new Exception('Nao foi possivel indentificar a funcao arquivo');
			}
	}
}
?>