<?php
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
/**
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @version 1.0.0 
* @copyright 2014, VMtech ltda. 
* @access public  
* @package sped
* @subpackage SpedFiscal
* @example Classe SpedFiscal 
*/
class SpedFiscal{
	/**
	* Controle de versao do aplicativo
	*/
	const VERSION='1.0.0';
	
	/**
	* Nome do arquivo a ser criado ou sobreposto
	* @type string	
	*/
	private $nameArquivo;
	
	/**
	* Armazena o nome do ultimo registro add no arquivo do speed
	* @type string	
	*/
	private $old_registro;
	
	/**
	* Armazena a referencia do arquivo a ser escrito
	* @type string
	*/
	private $archive;

	/**
	* Armazena o total de linhas ja adicionadas no arquivo
	* @type integer
	*/
	private $totalizadorArquivo=1;
	
	/**
	* Armazena os bloco criados suas respctivas aberturas e fechamento
	* @type array
	*/
	private $blocos=array();

	/**
	* Armazena qual bloco esta ativo no momento
	* @type string
	*/
	private $active;

	/**
	* Armazena os registro adicionados e a qtde
	* @type array
	*/
	private $registros;
	
	/**
	* Construtor padrao
	* @param string $archive nome do arquivo a ser aberto ou escrito
	* @param string $rewrite caso exista o arquivo deve ou nao reescrito
	*/
	public function __construct($archive='teste.txt',$rewrite=true){
		try{
			if(!is_bool($rewrite)) throw new Exception('$rewrite tipo invalido esperado boolean!');
			$this->nameArquivo=$archive;
			$this->open(($rewrite==true)?'w':'a');
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	/**
	* Destrutor padrao
	*/
	public function __destruct(){
		// $this->close();
	}
	
	/**
	* Abre o arquivo para armazenar os registros
	* @return void;
	*/
	private function open($mod='a'){
		if(empty($this->archive))
			$this->archive=fopen($this->nameArquivo,$mod);
		
	}
	
	/**
	* Escreve no arquivo do sped
	* @return void;
	*/
	private function write($reg){
		if(!empty($this->archive)){
			if(is_object($reg)){
				fwrite($this->archive,(($this->totalizadorArquivo>=3)?PHP_EOL:'').$reg->_toLine());
			}else{
				fwrite($this->archive,(($this->totalizadorArquivo>=3)?PHP_EOL:'').$reg);
			}
		}else{
			throw new Exception('Nao foi possivel armazenar');
		}
	}
	
	/**
	* Fecha o arquivo do sped
	* @return void
	*/
	public function close(){
		if(!empty($this->archive)){
			$this->register('9900',(4+count($this->registros)));
			$this->register('9001');
			$this->register('9990');
			$this->register('9999');
		
			$this->write('|9001|0|');
			foreach($this->registros as $v){
				$this->write('|9900|'.key($v).'|'.$v[key($v)].'|');
			}				
			$this->write('|9990|'.($this->getRegister('9900')+3).'|');	
			$this->write('|9999|'.($this->totalizadorArquivo-1).'|');	
			//deixa linha em branco no final do arquivo
			$this->write('');

			if(fclose($this->archive)){
				
				$this->archive=null;
				
				//criar zip
				$zip = new ZipArchive();
				
				if ($zip->open(substr($this->nameArquivo, 0, -3).'zip', ZipArchive::CREATE)!==TRUE){
					exit("cannot open <$zipname>\n");
				}
				
				$nome = array_reverse(explode("/", $this->nameArquivo));
				$zip->addFile($this->nameArquivo, $nome[0]);
				
				$zip->close();
				
				@unlink($this->nameArquivo);
			
			}else{
				throw new Exception('Nao foi possivel fechar arquivo');
			}
		}
	}
	
	/**
	* Metodo para add registro para o sped
	* @access public
	* @param  Object $reg
	* @return void
	*/
	public function add(Registro $reg){
		try{
			if($this->checkLine($reg)==true){
				$this->write($reg);
			}
			// unset($reg);
		}catch(Exception $e){
			echo $e->getMessage();
		}
		return $this;
	}
	/**
	* Metodo para checar se a linha esta sendo adcionada no momento correto
	* @access private
	* @param  Object $reg
	* @return boolean
	*/	
	private function checkLine($reg){
		$ret=false;
		try{
			if($this->totalizadorArquivo==1&&$reg->_getRegistroName()!='0000')
				throw new Exception('A primeira linha do arquivo de ser o Registro_0000');
			if($this->totalizadorArquivo==2&&$reg->_getRegistroName()!='0001')
				throw new Exception('A segunda linha do arquivo de ser o Registro_0001');
				
			if($this->registerBloco($reg)){
				$this->register($reg->_getRegistroName());
				$ret= true;
			}
		}catch(Exception $e){
			throw new Exception($e->getMessage());
		}
			return $ret;
	
	}
	
	/**
	* Metodo para armezenar o registro por tipo e sua respectiva qtde
	* @access private
	* @param  string $reg
	* @param  integer $qtde
	* @return void
	*/	
	private function register($reg,$qtde=1){
		$p=null;
		if(!empty($reg)){
			if(!empty($this->registros)){
				foreach($this->registros as $k=>$v){
					if(isset($v[$reg])){
						$p=$k;
						break;
					}
				}
			}
			$this->totalizadorArquivo+=$qtde;
			if(is_null($p)){
				$this->registros[]=array($reg=>$qtde);
			}else{
				$this->registros[$p][$reg]+=$qtde;
			}

		}else{
			throw new Exception('Argumento invalido '.var_export($reg,true));
		}
	}
	/**
	* Retorno a qtde de registro do registro informado
	* @access public
	* @param  string $reg
	* @return boolean
	*/	
	private function getRegister($reg){
		$r=null;
		if(!empty($this->registros)){
			foreach($this->registros as $k=>$v){
				if(isset($v[$reg])){
					$r=$v[$reg];
					break;
				}
			}
		}	
		return $r;
	}
	/**
	* Retorno a qtde de registro do bloco/ou registro 
	* @access public
	* @param  string $bloco ou parte do registro
	* @return boolean
	*/	
	public function countBloco($bloco){
		$r=0;
		$length=strlen($bloco);
		if($length<=0) throw new Exception('Esperado algum valor!');
		if(!empty($this->registros)){
			foreach($this->registros as $k=>$v)
				if(!substr_compare(key($v),$bloco,0,$length,false))	$r+=current($v);
		}else{
			throw new Exception('Nao existe registros disponiveis');
		}
		return ($r+1);
	}
	
	/**
	* Metodo para registrar/validar a entrada dos blocos
	* @access private
	* @param  Object $reg
	* @return boolean
	*/	
	private function registerBloco($reg){
		try{
			if(!is_null($this->active)&&$this->active!=$reg->_getNameBloco())
				throw new Exception('Esperado um registro do bloco '.$this->active.' para adicionar este registro voce deve fechar o bloco '.$this->active.' e abrir o bloco '.$reg->_getNameBloco());
			if(array_key_exists($reg->_getNameBloco(),$this->blocos)&&$this->blocos[$reg->_getNameBloco()]['c']==true)
				throw new Exception('O bloco '.$reg->_getNameBloco().' ja foi fechado sendo assim ser incluido mais registro para ele!');
			
			
			if(!array_key_exists($reg->_getNameBloco(),$this->blocos))
				$this->blocos[$reg->_getNameBloco()]=array('o'=>false,'l'=>0,'c'=>false);
			
				
				if($reg->_getRegistroFuncao()=='o'){
					$this->active=$reg->_getNameBloco();
					$this->blocos[$reg->_getNameBloco()]['o']=true;
					$this->blocos[$reg->_getNameBloco()]['l']+=1;
					return true;
				}elseif($reg->_getRegistroFuncao()=='r'){
					$this->blocos[$reg->_getNameBloco()]['l']+=1;					
					return true;
				}elseif($reg->_getRegistroFuncao()=='c'){
					$this->active=null;
					$this->blocos[$reg->_getNameBloco()]['c']=true;
					$this->blocos[$reg->_getNameBloco()]['l']+=1;
					return true;
				}else{
					throw new Exception('Nao foi possivel registrar '.$reg->_getNameClass());
				}
		}catch(Exception $e){
			throw new Exception($e->getMessage());
		}
	}
}
?>