<?php 
/**
* REGISTRO 0015: DADOS DO CONTRIBUINTE SUBSTITUTO
* Registro obrigatório para todos os contribuintes substitutos tributários do ICMS, conforme definidos na legislação
* pertinente. Deve ser gerado um registro para cada uma das inscrições estaduais cadastradas nas unidades federadas dos
* contribuintes substituídos, ainda que não tenha tido movimentação no período, ficando obrigado à apresentação dos
* registros E200 e filhos.
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0015 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0015”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0015';
	
	/**
	* Sigla da unidade da federação do contribuinte substituído.
	* @name $uf_st
	* @size 2
	* @type string	
	* @position 02
	* @required true
	*/
	protected $uf_st;
	
	/**
	* Inscrição Estadual do contribuinte substituto na unidade da federação do contribuinte substituído.
	* @name $ie_st
	* @size 14
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $ie_st;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>