<?php 
/**
* REGISTRO 0175: ALTERAÇÃO DA TABELA DE CADASTRO DE PARTICIPANTE
* Este registro é de preenchimento obrigatório quando houver, dentro do período, alteração nos dados informados no
* registro 0150, campos: NOME, COD_PAIS, CNPJ, CPF, IE, COD_MUN, SUFRAMA, END, NUM, COMPL e BAIRRO.
* Não pode ser utilizado, em um mesmo arquivo, um mesmo código para representar um participante diferente do
* referenciado anteriormente por tal código.
* Os dados informados neste registro serão considerados até às 24:00 horas do dia anterior à data de alteração.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0175 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0175”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0175';
	
	/**
	* Data de alteração do cadastro
	* @name $dt_alt
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 02
	* @required true
	*/
	protected $dt_alt;
	
	/**
	* Número do campo alterado (Somente campos 03 a 13)
	* @name $nr_campo
	* @size 2
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $nr_campo;
	
	/**
	*
	* Conteúdo anterior do campo
	* $name $cont_ant
	* @size 100
	* @type string
	* @position 04
	* @required true
	*/
	protected $cont_ant;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>