<?php 
/**
* REGISTRO 0190: IDENTIFICAÇÃO DAS UNIDADES DE MEDIDA
* Este registro tem por objetivo descrever as unidades de medidas utilizadas no arquivo digital. Não podem ser
* informados dois ou mais registros com o mesmo código de unidade de medida. Somente devem constar as unidades de
* medidas informadas em qualquer outro registro.
* Nível hierárquico: 2
* Ocorrência: vários por arquivo
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0190 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0190”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0190';
	
	/**
	* Código da unidade de medida
	* @name $unid
	* @size 8
	* @type string
	* @position 02
	* @required true
	*/
	protected $unid;
	
	/**
	* Descrição da unidade de medida
	* @name $descr
	* @size undefined
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $descr;
	
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>