<?php 
/**
* REGISTRO 0220: FATORES DE CONVERSÃO DE UNIDADES
* Este registro tem por objetivo informar os fatores de conversão dos itens discriminados na Tabela de Identificação
* do Item (Produtos e Serviços) entre a unidade informada no registro 0200 e as unidades informadas nos registros dos documentos fiscais.
* Quando for utilizada unidade de inventário diferente da unidade comercial do produto é necessário informar o
* registro 0220 para informar os fatores de conversão entre as unidades.
* Não podem ser informados dois ou mais registros com o mesmo conteúdo no campo UNID_CONV.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0220 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo "0220".
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0220';
	
	/**
	* Unidade comercial a ser convertida na unidade de estoque, referida no registro 0200.
	* @name $unid_conv
	* @size 6
	* @type string	
	* @position 02
	* @required true
	*/
	protected $unid_conv;

	/**
	* Fator de conversão: fator utilizado para converter (multiplicar) a unidade a ser convertida na unidade adotada no inventário.
	* com 6 casas decimais
	* @name $fat_conv
	* @size undefined
	* @type decimal
	* @position 03
	* @required true
	*/
	protected $fat_conv;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>