<?php 
/**
* REGISTRO 0305: INFORMAÇÃO SOBRE A UTILIZAÇÃO DO BEM
* Este registro tem o objetivo de prestar informações sobre a utilização do bem, sendo obrigatório quando o conteúdo do campo IDENT_MERC do registro 0300 for igual a “1”.
* Nível hierárquico - 3
* Ocorrência – 1:1
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0305 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0305”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0305';
	
	/**
	* Código do centro de custo onde o bem está sendo ou será utilizado (campo 03 do Registro 0600)
	* @name $cod_ccus
	* @size 60
	* @type string	
	* @position 02
	* @required true
	*/
	protected $cod_ccus;
	
	/**
	* Descrição sucinta da função do bem na atividade do estabelecimento
	* @name $func
	* @size undefined
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $func;
	
	/**
	*
	* Vida útil estimada do bem, em número de meses
	* $name $vida_util
	* @size 3
	* @type numeric
	* @position 04
	* @required true
	*/
	protected $vida_util;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>