<?php 
/**
* REGISTRO 0450: TABELA DE INFORMAÇÃO COMPLEMENTAR DO  DOCUMENTO FISCAL
* Este registro tem por objetivo codificar todas as informações complementares dos documentos fiscais exigidas
* pela legislação fiscal. Estas informações constam no campo “Dados Adicionais” dos documentos fiscais.
* Esta codificação e suas descrições são livremente criadas e mantidas pelo contribuinte e não podem ser informados
* dois ou mais registros com o mesmo conteúdo no campo COD_INF.
* Deverão constar todas as informações complementares de interesse do fisco existentes nos documentos fiscais.
* Exemplo: nos casos de documentos fiscais de entradas de devolução, informar o documento fiscal referenciado.
* Nível hierárquico - 2
* Ocorrência –vários (por arquivo)
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0450 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0450”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0450';
	
	/**
	* Código da informação complementar do documento fiscal.
	* @name $cod_inf
	* @size 6
	* @type string	
	* @position 02
	* @required true
	*/
	protected $cod_inf;
	
	/**
	* Texto livre da informação complementar existente no documento fiscal, inclusive espécie de normas legais,
	* poder normativo, número, capitulação, data e demais referências pertinentes com indicação referentes ao tributo.
	* @name $txt
	* @size undefined
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $txt;
	
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>