<?php 
/**
* REGISTRO C170: ITENS DO DOCUMENTO (CÓDIGO 01, 1B, 04 e 55).
* conjugadas), inclusive em operações de entrada de mercadorias acompanhadas de Nota Fiscal Eletrônica (NF-e) de emissão
* de terceiros.
* Conforme item 2.4.2.2.1 do Ato COTEPE/ICMS nº 09, de 18 de abril de 2008, o termo "item" é aplicado às
* operações fiscais que envolvam mercadorias, serviços, produtos ou quaisquer outros itens concernentes às transações
* fiscais suportadas pelo documento, como, por exemplo, nota fiscal complementar, nota fiscal de ressarcimento,
* transferências de créditos e outros casos.
* Não podem ser informados para um mesmo documento fiscal dois ou mais registros com o mesmo conteúdo no
* campo NUM_ITEM.
* IMPORTANTE: para documentos de entrada, os campos de valor de imposto/contribuição, base de cálculo e alíquota só
* devem ser informados se o adquirente tiver direito à apropriação do crédito (enfoque do declarante).
* Nível hierárquico - 3
* Ocorrência - 1:N (um ou vários por registro C100)
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C170 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C170.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C170';
	
	/**
	* Número sequencial do item no documento fiscal.
	* @name $num_item
	* @size 3
	* @type numeric	
	* @position 02
	* @required true
	*/
	protected $num_item;
	
	/**
	* Código do item (campo 02 do Registro 0200).
	* @name $cod_item
	* @size 60
	* @type string	
	* @position 03
	* @required true
	*/
	protected $cod_item;
		
	/**
	*
	* Descrição complementar do item como adotado no documento fiscal.
	* @name $descr_compl
	* @size undefined
	* @type string	
	* @position 04
	* @required true	
	*/
	protected $descr_compl;

	/**
	* Quantidade do item.
	* $name $qtd
	* @size undefined
	* @type decimal com 5 casas decimais
	* @position 05
	* @required true
	*/
	protected $qtd;
	
	/**
	* Unidade do item (Campo 02 do registro 0190).
	* $name $unid
	* @size 6
	* @type string
	* @position 06
	* @required true
	*/
	protected $unid;
	
	/**
	* Valor total do item (mercadorias ou serviços).
	* $name $vl_item
	* @size undefined
	* @type decimal com 2 casas decimais
	* @position 07
	* @required true
	*/
	protected $vl_item;
	
	/**
	* Valor do desconto comercial.
	* $name $vl_desc
	* @size undefined
	* @type decimal com 2 casas decimais
	* @position 08
	* @required true
	*/
	protected $vl_desc;
	
	/**
	* Movimentação física do ITEM/PRODUTO:
	* 0. SIM
	* 1. NÃO
	* $name $ind_mov
	* @size 1
	* @type numeric
	* @position 09
	* @values Valores válidos: [0, 1]
	* @required true
	*/
	protected $ind_mov;
	
	/**
	* Código da Situação Tributária referente ao ICMS, conforme a Tabela indicada no item 4.3.1
	* $name $cst_icms
	* @size 3
	* @type string
	* @position 10
	* @required true
	*/
	protected $cst_icms;
	
	/**
	* Código Fiscal de Operação e Prestação.
	* $name $cfop
	* @size 4
	* @type numeric
	* @position 11
	* @required true
	*/
	protected $cfop;
	
	/**
	* Código da natureza da operação (campo 02 do Registro 0400).
	* $name $cod_nat
	* @size 10
	* @type string
	* @position 12
	* @required true
	*/
	protected $cod_nat;
	
	/**
	* Valor da base de cálculo do ICMS
	* $name $vl_bc_icms
	* @size undefined
	* @type decimal com 2 casas decimais
	* @position 13
	* @required true
	*/
	protected $vl_bc_icms;
	
	/**
	* Alíquota do ICMS.
	* $name $aliq_icms
	* @size 6
	* @type decimal 2 casas decimais
	* @position 14
	* @required true
	*/
	protected $aliq_icms;
	
	/**
	* Valor do ICMS creditado/debitado.
	* $name $vl_icms
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 15
	* @required true
	*/
	protected $vl_icms;

	
	/**
	* Valor da base de cálculo referente à substituição tributária.
	* $name $vl_bc_icms_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 16
	* @required true
	*/
	protected $vl_bc_icms_st;
	
	/**
	* Alíquota do ICMS da substituição tributária na unidade da federação de destino.
	* $name $aliq_st
	* @size 1
	* @type string
	* @position 17
	* @required true
	*/
	protected $aliq_st;
	
	/**
	* Valor do ICMS referente à substituição tributária.
	* $name $vl_icms_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 18
	* @required true
	*/
	protected $vl_icms_st;
	
	/**
	* Indicador de período de apuração do IPI:
	* 	0 - Mensal;
	* 	1 - Decendial
	* $name $ind_apur
	* @size 1
	* @type string
	* @position 19
	* @values Valores válidos: [0, 1]
	* @required true
	*/
	protected $ind_apur;
	
	/**
	* Código da Situação Tributária referente ao IPI, conforme a Tabela indicada no item 4.3.2.
	* $name $cst_ipi
	* @size 2
	* @type string
	* @position 20
	* @required true
	*/
	protected $cst_ipi;
	
	/**
	* Código de enquadramento legal do IPI, conforme tabela indicada no item 4.5.3.
	* $name $cod_enq
	* @size 3
	* @type string
	* @position 21
	* @required true
	*/
	protected $cod_enq;
		
	/**
	* Valor da base de cálculo do IPI.
	* $name $vl_bc_ipi
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 22
	* @required true
	*/
	protected $vl_bc_ipi;
	
	/**
	* Alíquota do IPI.
	* $name $aliq_ipi
	* @size 6
	* @type decimal 2 casas decimais
	* @position 23
	* @required true
	*/
	protected $aliq_ipi;	
	
	/**
	* Valor do IPI creditado/debitado.
	* $name $vl_ipi
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 24
	* @required true
	*/
	protected $vl_ipi;
	
	/**
	* Código da Situação Tributária referente ao PIS.
	* $name $cst_pis
	* @size 2
	* @type numeric
	* @position 25
	* @required true
	*/
	protected $cst_pis;
	
	/**
	* Valor da base de cálculo do PIS.
	* $name $vl_bc_pis
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 26
	* @required true
	*/
	protected $vl_bc_pis;
	
	/**
	* Alíquota do PIS (em percentual).
	* $name $aliq_pis
	* @size 8
	* @type decimal 4 casas decimais
	* @position 27
	* @required true
	*/
	protected $aliq_pis;
	
	/**
	* Quantidade – Base de cálculo PIS.
	* $name $quant_bc_pis
	* @size undefined
	* @type decimal 3 casas decimais
	* @position 28
	* @required true
	*/
	protected $quant_bc_pis;
	
	/**
	* Alíquota do PIS (em reais).
	* $name $aliq_pis_reais
	* @size undefined
	* @type decimal 4 casas decimais
	* @position 29
	* @required true
	*/
	protected $aliq_pis_reais;

	
	/**
	* Valor do PIS.
	* $name $vl_pis
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 30
	* @required true
	*/
	protected $vl_pis;
	
	/**
	* Código da Situação Tributária referente ao COFINS.
	* $name $cst_cofins
	* @size 2
	* @type numeric
	* @position 31
	* @required true
	*/
	protected $cst_cofins;
	
	/**
	* Valor da base de cálculo da COFINS.
	* $name $vl_bc_cofins
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 32
	* @required true
	*/
	protected $vl_bc_cofins;
	
	/**
	* Alíquota do COFINS (em percentual).
	* $name $aliq_cofins
	* @size 8
	* @type decimal 4 casas decimais
	* @position 33
	* @required true
	*/	
	protected $aliq_cofins;	
	
	/**
	* Quantidade – Base de cálculo COFINS.
	* $name $quant_bc_cofins
	* @size undefined
	* @type decimal 3 casas decimais
	* @position 34
	* @required true
	*/
	protected $quant_bc_cofins;
	
	/**
	* Alíquota da COFINS (em reais).
	* $name $aliq_cofins_reais
	* @size undefined
	* @type decimal 4 casas decimais
	* @position 35
	* @required true
	*/
	protected $aliq_cofins_reais;	
	/**
	* Valor da COFINS.
	* $name $vl_cofins
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 36
	* @required true
	*/
	protected $vl_cofins;	
	/**
	* Código da conta analítica contábil debitada/creditada;
	* $name $cod_cta
	* @size undefined
	* @type string
	* @position 37
	* @required true
	*/
	protected $cod_cta;	
	
	/**
	* metodo responsavel pela construcao do obj do registro 
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>