<?php 
/**
* REGISTRO C172: OPERAÇÕES COM ISSQN (CÓDIGO 01)
* Este registro tem por objetivo informar dados da prestação de serviços.
* Nível hierárquico - 4
* Ocorrência - 1:1
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C172 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C172.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C172';
	
	/**
	* Valor da base de cálculo do ISSQN.
	* @name $vl_bc_issqn
	* @size undefined
	* @type decimal com 2 casas decimais
	* @position 02
	* @required true
	*/
	protected $vl_bc_issqn;
	
	/**
	* Alíquota do ISSQN.
	* @name $aliq_issqn
	* @size 6
	* @type decimal com 2 casas decimais	
	* @position 03
	* @required true
	*/
	protected $aliq_issqn;

	/**
	* Valor do ISSQN.
	* $name $vl_issqn
	* @size undefined
	* @type decimal com 2 casas decimais
	* @position 04
	* @required true
	*/
	protected $vl_issqn;
	
	/**
	* metodo responsavel pela construcao do obj do registro 
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>