<?php 
/**
* REGISTRO C190: REGISTRO ANALÍTICO DO DOCUMENTO (CÓDIGO 01, 1B, 04 E 55).
* Este registro tem por objetivo representar a escrituração dos documentos fiscais totalizados por CST, CFOP e Alíquota de ICMS.
* Validação do Registro: não podem ser informados dois ou mais registros com a mesma combinação de valores dos
* campos: CST_ICMS, CFOP e ALIQ_ICMS. A combinação dos valores dos campos CST_ICMS, CFOP e ALIQ_ICMS
* devem existir no respectivo registro de itens do C170, quando este registro for exigido.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C190 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C190.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C190';
	
	/**
	* Código da Situação Tributária, conforme a Tabela indicada no item 4.3.1
	* @name $cst_icms
	* @size 3
	* @type numeric	
	* @position 02
	* @required true
	*/
	protected $cst_icms;
	
	/**
	* Código Fiscal de Operação e Prestação do agrupamento de itens
	* @name $cfop
	* @size 4
	* @type string	
	* @position 03
	* @required true
	*/
	protected $cfop;
		
	/**
	*
	* Alíquota do ICMS.
	* @name $aliq_icms
	* @size 60
	* @type string	
	* @position 04
	* @required true	
	*/
	protected $aliq_icms;

	/**
	* Valor da operação na combinação de CST_ICMS,CFOP e alíquota do ICMS, correspondente ao
	* somatório do valor das mercadorias, despesas acessórias (frete, seguros e outras despesas acessórias), ICMS_ST e IPI.
	* $name $vl_opr
	* @size undefined
	* @type decimal com 2 casas decimais
	* @position 05
	* @required true
	*/
	protected $vl_opr;
	
	/**
	* Parcela correspondente ao "Valor da base de cálculo do ICMS" referente à combinação de CST_ICMS, CFOP e alíquota do ICMS.
	* $name $vl_bc_icms
	* @size undefined
	* @type decimal com 2 casas decimais
	* @position 06
	* @required true
	*/
	protected $vl_bc_icms;
	
	/**
	* Parcela correspondente ao "Valor do ICMS" referente à combinação de CST_ICMS, CFOP e alíquota do ICMS.
	* $name $vl_icms
	* @size undefined
	* @type decimal com 2 casas decimais
	* @position 07
	* @required true
	*/
	protected $vl_icms;
	
	/**
	* Parcela correspondente ao "Valor da base de cálculo do ICMS" da substituição tributária referente à combinação de CST_ICMS, CFOP e alíquota do ICMS.
	* $name $vl_bc_icms_st
	* @size undefined
	* @type decimal com 2 casas decimais
	* @position 08
	* @required true
	*/
	protected $vl_bc_icms_st;
	
	/**
	* Parcela correspondente ao valor creditado/debitado do ICMS da substituição tributária, referente à combinação de CST_ICMS,CFOP, e alíquota do ICMS.
	* $name $vl_icms_st
	* @size 1
	* @type decimal com 2 casas decimais
	* @position 09
	* @required true
	*/
	protected $vl_icms_st;
	
	/**
	* Valor não tributado em função da redução da base de cálculo do ICMS, referente à combinação de CST_ICMS, CFOP e alíquota do ICMS.
	* $name $vl_red_bc
	* @size 3
	* @type decimal com 2 casas decimais
	* @position 10
	* @required true
	*/
	protected $vl_red_bc;
	
	/**
	* Parcela correspondente ao "Valor do IPI" referente à combinação CST_ICMS, CFOP e alíquota do ICMS.
	* $name $vl_ipi
	* @size 4
	* @type decimal com 2 casas decimais
	* @position 11
	* @required true
	*/
	protected $vl_ipi;
	
	/**
	* Código da observação do lançamento fiscal (campo 02 do Registro 0460)
	* $name $cod_obs
	* @size 6
	* @type string
	* @position 12
	* @required true
	*/
	protected $cod_obs;
	
	/**
	* metodo responsavel pela construcao do obj do registro 
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>