<?php 
/**
* REGISTRO C195: OBSERVAÇOES DO LANÇAMENTO FISCAL (CÓDIGO 01, 1B E 55)
* Este registro deve ser informado quando, em decorrência da legislação estadual, houver ajustes nos documentos
* fiscais, informações sobre diferencial de alíquota, antecipação de imposto e outras situações.
* Estas informações equivalem às observações que são lançadas na coluna “Observações” dos Livros Fiscais
* previstos no Convênio SN/70 – SINIEF, art. 63, I a IV.
* Sempre que existir um ajuste (lançamentos referentes aos impostos que têm o cálculo detalhado em Informações
* Complementares da NF; ou aos impostos que estão definidos na legislação e não constam na NF; ou aos recolhimentos
* antecipados dos impostos), deve, conforme dispuser a legislação estadual, ocorrer uma observação.
* Obs.: 
* - Não precisam ser informadas neste registro, salvo disposição contrária da legislação estadual, as informações que
* constam do quadro Dados Adicionais das notas fiscais modelo 1 ou 1A e que não interferem na Apuração do ICMS.
* Situação especial: 
* - Este registro será gerado também pelas empresas que são obrigadas a elaborar outras apurações nos estados do Espírito Santo e Pará.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C195 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C195.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C195';
	
	/**
	* Código da observação do lançamento fiscal (campo 02 do Registro 0460)
	* @name $cod_obs
	* @size 6
	* @type string
	* @position 02
	* @required true
	*/
	protected $cod_obs;
	
	/**
	* Descrição complementar do código de observação.
	* @name $txt_compl
	* @size undefined
	* @type string	
	* @position 03
	* @required true
	*/
	protected $txt_compl;
	
	/**
	* metodo responsavel pela construcao do obj do registro 
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>