<?php 
/**
* REGISTRO C197: OUTRAS OBRIGAÇÕES TRIBUTÁRIAS, AJUSTES E INFORMAÇÕES DE VALORES PROVENIENTES DE DOCUMENTO FISCAL
* Este registro tem por objetivo detalhar outras obrigações tributárias, ajustes e informações de valores do
documento fiscal do registro C195, que podem ou não alterar o cálculo do valor do imposto.
Os valores de ICMS ou ICMS ST (campo 07-VL_ICMS) serão somados diretamente na apuração, no registro
E110 – Apuração do ICMS – Operações Próprias, campo VL_AJ_DEBITOS ou campo VL_AJ_CREDITOS, e no registro
E210 – Apuração do ICMS – Substituição Tributária, campo VL_AJ_CREDITOS_ST e campo VL_AJ_DEBITOS_ST, de
acordo com a especificação do TERCEIRO CARACTERE do Código do Ajuste (Tabela 5.3 do Ato COTEPE/ICMS nº 09,
de 18 de abril de 2008 = Tabela de Ajustes e Valores provenientes do Documento Fiscal).
* Nível hierárquico - 4
* Ocorrência - 1:N
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C197 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C197.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C197';
	
	/**
	* Código do ajustes/benefício/incentivo, conforme tabela indicada no item 5.3
	* @name $cod_aj
	* @size 10
	* @type string
	* @position 02
	* @required true
	*/
	protected $cod_aj;
	
	/**
	* Descrição complementar do ajuste do documento fiscal
	* @name $descr_compl_aj
	* @size undefined
	* @type string	
	* @position 03
	* @required false
	*/
	protected $descr_compl_aj;
	
	/**
	* Código do item (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type string	
	* @position 04
	* @required false
	*/
	protected $cod_item;
	
	/**
	* Base de cálculo do ICMS ou do ICMS ST 
	* @name $vl_bc_icms
	* @size undefined
	* @type decimal 2	
	* @position 05
	* @required false
	*/
	protected $vl_bc_icms;
	
	/**
	* Alíquota do ICMS 
	* @name $aliq_icms
	* @size 6
	* @type decimal 2	
	* @position 06
	* @required false
	*/
	protected $aliq_icms;
	
	/**
	* Valor do ICMS ou do ICMS ST
	* @name $vl_icms
	* @size undefined
	* @type decimal 2	
	* @position 07
	* @required false
	*/
	protected $vl_icms;
	
	/**
	* Outros valores
	* @name $vl_outros
	* @size undefined
	* @type decimal 2	
	* @position 08
	* @required false
	*/
	protected $vl_outros;
	
	/**
	* metodo responsavel pela construcao do obj do registro 
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>