<?php 
/**
* REGISTRO C405: REDUÇÃO Z (CÓDIGO 02 e 2D).
* Este registro deve ser apresentado com as informações da Redução Z de cada equipamento em funcionamento na
* data das operações de venda à qual se refere a redução. Inclui todos os documentos fiscais totalizados na Redução Z,
* inclusive as operações de venda realizadas durante o período de tolerância do Equipamento ECF.
* Nível hierárquico - 3
* Ocorrência – 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C405 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C405.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C405';
	
	/**
	* Data do movimento a que se refere a Redução Z
	* @observacoes considerar a data do movimento, que inclui as operações de vendas realizadas durante o período de tolerância do equipamento ECF.Validação: o valor informado deve ser menor ou igual à DT_FIN deste arquivo.
	* @name $dt_doc
	* @size 8
	* @type numeric	
	* @position 02
	* @format ddmmaaaa
	* @required true
	*/
	protected $dt_doc;
	
	/**
	* Posição do Contador de Reinício de Operação
	* @name $cro
	* @size 3
	* @type numeric	
	* @position 03
	* @required true	
	*/
	protected $cro;
	
	/**
	*
	* Posição do Contador de Redução Z.
	* $name $crz
	* @size 6
	* @type numeric
	* @position 04
	* @required true
	*/
	protected $crz;


	/**
	* Número do Contador de Ordem de Operação do último documento emitido no dia. (Número do COO na Redução Z).
	* $name $num_coo_fin
	* @size 6
	* @type numeric
	* @position 05
	* @required true
	*/
	protected $num_coo_fin;

	/**
	* Valor do Grande Total final.
	* @name $gt_fin
	* @size undefined 
	* @type decimal 2 casas deciamis
	* @position 06	
	* @required true	
	*/
	protected $gt_fin;

	/**
	* Valor da venda bruta.
	* @name $vl_brt
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 07
	* @required true
	*/
	protected $vl_brt;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>